#ifndef __HARDWARE_SMC_ID_H__
#define __HARDWARE_SMC_ID_H__

#include "nvt_ivot_optee_smc_id_def.h"

#define NVT_SMC_HW_FUNC_ID_VER         0x0008

/* Add new "HW" module ID here*/
enum {
        MODULE_HW_L2CACHE_ID = 0,
        MODULE_HW_CPU_ID,
        MODULE_HW_EFUSE_ID,
	MODULE_HW_SHA_ID,
	MODULE_HW_RSA_ID,
	MODULE_HW_AES_ID,
	MODULE_HW_ECDSA_ID,
        MODULE_HW_ID_INVALID = 0x40
};


/* L2 Cache operation */
#define NVT_L2CACHE_CTRL		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_L2CACHE_ID, ID_0)
#define NVT_L2CACHE_AUX_CTRL		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_L2CACHE_ID, ID_1)
#define NVT_L2CACHE_DBG_CTRL		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_L2CACHE_ID, ID_2)
#define NVT_L2CACHE_PREFETCH_CTRL	OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_L2CACHE_ID, ID_3)
#define NVT_L2CACHE_PWR_CTRL		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_L2CACHE_ID, ID_4)

// ACTLR smp config
#define NVT_ACTLR_SMP_CFG		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_CPU_ID, ID_0)

/* efuse*/
#define NVT_EFUSE_OPERATION		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_EFUSE_ID, ID_0)

/*SHA*/
#define NVT_SHA_OPERATION		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_SHA_ID, ID_0)

/*RSA*/
#define NVT_RSA_OPERATION		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_RSA_ID, ID_0)

/*AES*/
#define NVT_AES_OPERATION		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_AES_ID, ID_0)

/*RSA*/
#define NVT_ECDSA_OPERATION		OEM_FAST_FUNC_GEN(HW_TYPE, MODULE_HW_ECDSA_ID, ID_0)

#endif
