/*
 * Copyright (c) 2021 Novatek Inc.
 *
 */

#include <stdlib.h>
#include <common.h>
#include <command.h>
#include <dm.h>
#include <timer.h>
#include <malloc.h> 
#include <asm/arch/nvt_rsa.h>

#define RSA1024_VERIFY
#define RSA2048_VERIFY
#define RSA4096_VERIFY

static uint8_t RSA512_KEY_N[] = {
	0xAA, 0x36, 0xAB, 0xCE, 0x88, 0xAC, 0xFD, 0xFF, 0x55, 0x52, 0x3C, 0x7F, 0xC4, 0x52, 0x3F, 0x90,
	0xEF, 0xA0, 0x0D, 0xF3, 0x77, 0x4A, 0x25, 0x9F, 0x2E, 0x62, 0xB4, 0xC5, 0xD9, 0x9C, 0xB5, 0xAD,
	0xB3, 0x00, 0xA0, 0x28, 0x5E, 0x53, 0x01, 0x93, 0x0E, 0x0C, 0x70, 0xFB, 0x68, 0x76, 0x93, 0x9C,
	0xE6, 0x16, 0xCE, 0x62, 0x4A, 0x11, 0xE0, 0x08, 0x6D, 0x34, 0x1E, 0xBC, 0xAC, 0xA0, 0xA1, 0xF5
};

static uint8_t RSA512_KEY_E[] = {0x11};

static uint8_t RSA512_KEY_D[] = {
	0x0A, 0x03, 0x37, 0x48, 0x62, 0x64, 0x87, 0x69, 0x5F, 0x5F, 0x30, 0xBC, 0x38, 0xB9, 0x8B, 0x44,
	0xC2, 0xCD, 0x2D, 0xFF, 0x43, 0x40, 0x98, 0xCD, 0x20, 0xD8, 0xA1, 0x38, 0xD0, 0x90, 0xBF, 0x64,
	0x79, 0x7C, 0x3F, 0xA7, 0xA2, 0xCD, 0xCB, 0x3C, 0xD1, 0xE0, 0xBD, 0xBA, 0x26, 0x54, 0xB4, 0xF9,
	0xDF, 0x8E, 0x8A, 0xE5, 0x9D, 0x73, 0x3D, 0x9F, 0x33, 0xB3, 0x01, 0x62, 0x4A, 0xFD, 0x1D, 0x51
};

static uint8_t RSA512_PLAINTEXT[] = {
	0x54, 0x85, 0x9B, 0x34, 0x2C, 0x49, 0xEA, 0x2A
};

static uint8_t RSA512_CIPHERTEXT[] = {
	0x63, 0x1C, 0xCD, 0x7B, 0xE1, 0x7E, 0xE4, 0xDE, 0xC9, 0xA8, 0x89, 0xA1, 0x74, 0xCB, 0x3C, 0x63,
	0x7D, 0x24, 0xEC, 0x83, 0xC3, 0x15, 0xE4, 0x7F, 0x73, 0x05, 0x34, 0xD1, 0xEC, 0x22, 0xBB, 0x8A,
	0x5E, 0x32, 0x39, 0x6D, 0xC1, 0x1D, 0x7D, 0x50, 0x3B, 0x9F, 0x7A, 0xAD, 0xF0, 0x2E, 0x25, 0x53,
	0x9F, 0x6E, 0xBD, 0x4C, 0x55, 0x84, 0x0C, 0x9B, 0xCF, 0x1A, 0x4B, 0x51, 0x1E, 0x9E, 0x0C, 0x06
};

#ifdef RSA1024_VERIFY
static uint8_t RSA1024_KEY_N[] = {
	0xda, 0x98, 0x88, 0x65, 0xbe, 0xc9, 0x14, 0xc5, 0x62, 0x28, 0xfa, 0xf2, 0x55, 0x6a, 0x2c, 0xcb,
	0xe8, 0x60, 0x5b, 0x24, 0xb0, 0x13, 0xda, 0x4c, 0xe4, 0x16, 0x9c, 0xf2, 0xac, 0x22, 0x12, 0x1a,
	0x0d, 0x5c, 0xa3, 0xb5, 0x57, 0x8f, 0x40, 0xa3, 0x93, 0x6a, 0xea, 0x99, 0x99, 0x55, 0xb8, 0x7b,
	0x6c, 0x2b, 0xe9, 0x44, 0x1d, 0x64, 0xb2, 0x44, 0xed, 0x5f, 0x2d, 0x56, 0x77, 0x3e, 0xa1, 0x63,
	0xc0, 0xc7, 0x89, 0xd8, 0x09, 0xf9, 0xe3, 0x9a, 0xbf, 0xcd, 0x03, 0x49, 0x1f, 0x4e, 0x32, 0xc5,
	0x13, 0xd6, 0x1f, 0xa7, 0x5d, 0x7a, 0x0b, 0x18, 0x0d, 0x48, 0x6e, 0xaa, 0xb8, 0x40, 0xeb, 0xd2,
	0xf0, 0xbc, 0x48, 0x7b, 0xa1, 0x85, 0x4a, 0x7c, 0xd2, 0xdb, 0xe6, 0x5d, 0xf6, 0x79, 0x64, 0x39,
	0x3b, 0xde, 0x66, 0xcf, 0xc5, 0x1d, 0x61, 0x60, 0xb4, 0x84, 0xeb, 0x51, 0x1f, 0x25, 0x6b, 0xe9
};

static uint8_t RSA1024_KEY_E[] = {0x01,0x00,0x01};

static uint8_t RSA1024_KEY_D[] = {
	0x0a, 0x74, 0xe7, 0x79, 0x6e, 0x81, 0xf1, 0xf3, 0x6b, 0x39, 0xa8, 0x9f, 0x75, 0x04, 0x8a, 0x36,
	0x0a, 0xdc, 0xa9, 0x1f, 0x7d, 0x28, 0xc5, 0xf5, 0x8d, 0xa7, 0xa3, 0x44, 0x5c, 0x85, 0x98, 0xb6,
	0x14, 0x53, 0x8d, 0x25, 0x3c, 0x96, 0x06, 0xb2, 0x8c, 0x77, 0xbd, 0xd7, 0x31, 0x25, 0x8f, 0x98,
	0x9f, 0xd9, 0x0d, 0xe4, 0x8b, 0x3f, 0x68, 0xe3, 0xb1, 0x33, 0x2f, 0x59, 0x06, 0x85, 0x41, 0x75,
	0x0c, 0x7e, 0x2d, 0xdc, 0x34, 0xab, 0x8c, 0x88, 0xa3, 0x71, 0x23, 0x44, 0x99, 0x82, 0x90, 0x04,
	0xf7, 0x72, 0xff, 0xe7, 0x5a, 0xc5, 0xac, 0xb9, 0x70, 0x5e, 0x2a, 0xe6, 0xd6, 0x12, 0x12, 0x83,
	0xaa, 0x0a, 0xc1, 0x1f, 0x3f, 0xe3, 0x6b, 0xba, 0xda, 0x1b, 0xf2, 0xdc, 0x2c, 0x09, 0xba, 0x6e,
	0x6c, 0xc0, 0x32, 0x7a, 0x2e, 0x04, 0x60, 0x81, 0x1c, 0x88, 0x07, 0xb4, 0x6c, 0xe5, 0x3a, 0x01
};

static uint8_t RSA1024_PLAINTEXT[] = {
	0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d,
	0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3,
	0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83,
	0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b,
	0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb,
	0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81,
	0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59,
	0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85
};

static uint8_t RSA1024_CIPHERTEXT[] = {
	0xd9, 0x60, 0x53, 0x0b, 0xc9, 0x0b, 0x8f, 0xdc, 0x86, 0xb6, 0x5a, 0x01, 0x91, 0xb5, 0xca, 0xa8,
	0x63, 0xea, 0x99, 0x64, 0x51, 0xa3, 0x6f, 0x8f, 0xca, 0xdc, 0xc2, 0x05, 0x78, 0xa5, 0x05, 0x48,
	0x3a, 0xe0, 0x68, 0xcd, 0x0b, 0xbd, 0x51, 0x6d, 0x73, 0x59, 0x96, 0x89, 0x1d, 0x0c, 0xa8, 0xaa,
	0x67, 0x68, 0xff, 0xf2, 0x95, 0x3f, 0xd8, 0x69, 0x7b, 0x2d, 0x75, 0x5c, 0x43, 0x7e, 0x61, 0x19,
	0x78, 0xca, 0x21, 0xa4, 0x7d, 0xa4, 0x3f, 0x66, 0x05, 0x62, 0xe8, 0x14, 0x32, 0x77, 0xaa, 0xff,
	0x0a, 0x1c, 0x00, 0xb3, 0x03, 0x07, 0x4d, 0x68, 0xb7, 0xa2, 0x9e, 0xf7, 0x98, 0xae, 0xff, 0xf0,
	0x9d, 0x92, 0xc4, 0x71, 0x6a, 0xe0, 0xff, 0xb9, 0xbd, 0x82, 0x2b, 0x90, 0x1a, 0x6b, 0x0b, 0x84,
	0xbe, 0x6f, 0xe9, 0x99, 0xde, 0xa0, 0x6d, 0xbb, 0xeb, 0x6e, 0x2b, 0x45, 0xaa, 0x01, 0x52, 0x35
};
#endif

#ifdef RSA2048_VERIFY
static uint8_t RSA2048_KEY_N[] = {
	0xa7, 0x39, 0x2c, 0x84, 0x0c, 0x3d, 0x39, 0x8a, 0x01, 0x6b, 0x20, 0xbe, 0x8e, 0x07, 0x46, 0x2c,
	0xc7, 0x06, 0x53, 0x1c, 0x54, 0x15, 0xdc, 0x33, 0xd2, 0x04, 0x8f, 0x64, 0x71, 0x70, 0xab, 0x0d,
	0xdc, 0x26, 0xb2, 0x38, 0x87, 0x6b, 0xf6, 0xb8, 0x15, 0x1d, 0x8b, 0x54, 0x51, 0xc7, 0x99, 0x0c,
	0x48, 0xb0, 0xaf, 0x95, 0x75, 0x9e, 0x6b, 0xe9, 0x1e, 0xb1, 0x83, 0x66, 0x8e, 0xb5, 0xce, 0x17,
	0x3e, 0xac, 0xaa, 0xdc, 0x1e, 0x0c, 0x2b, 0xaf, 0xed, 0x27, 0x91, 0x07, 0x01, 0x7c, 0x70, 0x33,
	0xc1, 0xc0, 0x80, 0x0a, 0x3d, 0x7a, 0xad, 0x8a, 0xdc, 0x2e, 0x16, 0x24, 0x93, 0x3c, 0x8b, 0x0f,
	0x73, 0x4f, 0x5a, 0x56, 0x5c, 0xf1, 0x4e, 0x3b, 0x76, 0xcf, 0x1a, 0x8d, 0xe0, 0xaf, 0x41, 0xf5,
	0x1b, 0x14, 0xc1, 0x54, 0x04, 0x4f, 0xcd, 0x20, 0x85, 0xdf, 0x65, 0xbf, 0x79, 0x12, 0x84, 0x07,
	0xb0, 0x92, 0x49, 0x52, 0x40, 0xee, 0x9d, 0x9b, 0x23, 0xe1, 0xbf, 0x62, 0x11, 0x4a, 0x02, 0x90,
	0x0a, 0x2c, 0x58, 0xba, 0x78, 0x7e, 0x31, 0x63, 0xae, 0x35, 0x2c, 0xe5, 0x23, 0x15, 0x64, 0x4d,
	0x3b, 0x98, 0x96, 0x60, 0x95, 0xe2, 0x2f, 0x37, 0xa7, 0x6a, 0xb5, 0xf7, 0xf7, 0x21, 0x09, 0x92,
	0x0a, 0x34, 0xd5, 0xa2, 0xcb, 0x7d, 0xb5, 0xf0, 0xd1, 0xfc, 0x3c, 0xcb, 0x8d, 0x11, 0x86, 0xe0,
	0x5c, 0x5f, 0x66, 0x35, 0x03, 0x7d, 0x92, 0xfa, 0x9a, 0x29, 0x1d, 0xc8, 0xdc, 0x11, 0x52, 0xeb,
	0x15, 0x6a, 0xa7, 0x6b, 0xb1, 0x97, 0x79, 0x68, 0x73, 0x89, 0x10, 0x51, 0xf5, 0x68, 0x96, 0xa7,
	0x0d, 0x15, 0x3f, 0x54, 0x46, 0x59, 0x8b, 0xd7, 0x32, 0xae, 0xba, 0x7b, 0xc8, 0xf8, 0xc3, 0x57,
	0x55, 0x07, 0x2a, 0x86, 0x1b, 0xff, 0x3a, 0xe9, 0xef, 0x0e, 0x56, 0x63, 0xd9, 0x2b, 0x74, 0xf7
};
static uint8_t RSA2048_KEY_E[] = {0x01, 0x00, 0x01};

static uint8_t RSA2048_KEY_D[] = {
	0x9d, 0x46, 0x52, 0xad, 0xe6, 0xec, 0xf6, 0x5e, 0xeb, 0xb2, 0x9b, 0xdb, 0x5c, 0xad, 0x4e, 0xbc,
	0xf2, 0x7a, 0xea, 0x53, 0xec, 0x69, 0x9a, 0xef, 0x4a, 0x09, 0x6b, 0xeb, 0xa6, 0x1d, 0xb7, 0x63,
	0x93, 0xb8, 0xf9, 0x49, 0xdd, 0x64, 0x17, 0x69, 0x4e, 0xc2, 0xb8, 0xb6, 0x17, 0x2c, 0x48, 0xaf,
	0x9a, 0xf6, 0x42, 0x4d, 0xa9, 0x8f, 0xd4, 0x22, 0x2e, 0xf1, 0xf9, 0x89, 0xcd, 0x93, 0x04, 0x40,
	0x2c, 0x7c, 0x2d, 0x3e, 0x55, 0x2c, 0x51, 0x32, 0x67, 0x34, 0x1d, 0x5c, 0x9f, 0x73, 0x2f, 0xfc,
	0x1d, 0xb0, 0x35, 0x3c, 0x6c, 0x52, 0x23, 0x42, 0x44, 0x8f, 0x3b, 0xd8, 0x2e, 0x7a, 0x74, 0xb7,
	0x95, 0x55, 0xfe, 0xba, 0xd7, 0x33, 0x44, 0xc6, 0xfc, 0x99, 0x10, 0x7a, 0x7b, 0xe5, 0x99, 0x7d,
	0x33, 0x79, 0x33, 0xd3, 0x17, 0x33, 0x0e, 0xd4, 0x15, 0xd4, 0xe4, 0x57, 0x4f, 0x41, 0xb0, 0xd6,
	0x1d, 0x5e, 0x72, 0x65, 0xe9, 0x3d, 0xc4, 0x48, 0xcd, 0x19, 0xbf, 0xe9, 0xd9, 0x32, 0xf0, 0x45,
	0x0d, 0xc7, 0xa8, 0xc7, 0x63, 0x8d, 0x5e, 0x55, 0xd8, 0x13, 0x9f, 0x9a, 0x34, 0x94, 0x94, 0xf8,
	0x59, 0xa6, 0x74, 0xb6, 0xd8, 0x9b, 0x78, 0xcf, 0xda, 0x81, 0x07, 0x1c, 0x69, 0x4d, 0x97, 0x7c,
	0x29, 0x34, 0xdf, 0x60, 0x8f, 0x94, 0x35, 0xd1, 0x39, 0x3f, 0x53, 0x95, 0xeb, 0x05, 0x8b, 0xc6,
	0x16, 0x12, 0x11, 0x28, 0x07, 0xb5, 0xec, 0xaa, 0x62, 0xd5, 0x04, 0x38, 0x9c, 0x0c, 0xca, 0x13,
	0xa1, 0x19, 0x2c, 0x3b, 0xde, 0x81, 0xcc, 0x8f, 0xac, 0x96, 0x42, 0x4a, 0xa7, 0x22, 0x6f, 0x3f,
	0xd0, 0x07, 0x86, 0x1a, 0x4e, 0x28, 0x4c, 0xfd, 0x66, 0xc9, 0xb5, 0x52, 0x41, 0xae, 0x16, 0xb4,
	0x9b, 0xa2, 0xd5, 0xbd, 0x58, 0x11, 0x83, 0x9f, 0x9d, 0x31, 0x51, 0x89, 0x07, 0xe3, 0x4e, 0xc1
};

static uint8_t RSA2048_PLAINTEXT[] = {
	0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d,
	0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3,
	0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83,
	0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b,
	0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb,
	0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81,
	0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59,
	0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9,
	0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd,
	0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61,
	0xd2, 0xbb, 0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7,
	0x82, 0x5f, 0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb,
	0x5a, 0xd5, 0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f,
	0xda, 0x85, 0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5,
	0x80, 0x5d, 0xd8, 0x83, 0x60, 0xdb, 0xba, 0x59, 0xd4, 0xbd, 0x5c, 0xd7, 0x82, 0x5f, 0xda, 0x85,
	0x58, 0xd3, 0xbc, 0x5b, 0xd6, 0x81, 0x5e, 0xd9, 0x84, 0x61, 0xd2, 0xbb, 0x5a, 0xd5, 0x80
};

static uint8_t RSA2048_CIPHERTEXT[] = {
	0x36, 0x04, 0xce, 0x55, 0x06, 0x7d, 0x38, 0xdb, 0xbb, 0x3d, 0x47, 0x61, 0x77, 0x72, 0x98, 0x70,
	0x00, 0x31, 0x83, 0x11, 0x9c, 0x0e, 0x72, 0xcd, 0xb2, 0x0f, 0xee, 0x67, 0xdd, 0xe8, 0x1d, 0xc1,
	0x94, 0x6f, 0xc2, 0xd3, 0xa2, 0xdc, 0xbf, 0xb2, 0x6f, 0x68, 0x9b, 0xbb, 0x06, 0x24, 0xbc, 0x92,
	0xcb, 0x04, 0x18, 0x8e, 0xc6, 0xc1, 0xe4, 0xef, 0x7a, 0xf0, 0x3b, 0x7b, 0x50, 0x49, 0x83, 0x5f,
	0xb4, 0x83, 0xeb, 0x22, 0x89, 0xd6, 0xbb, 0x09, 0x0b, 0x77, 0x4d, 0xf7, 0xe7, 0x58, 0xa6, 0xb2,
	0x35, 0xbd, 0x88, 0x1b, 0x8b, 0x08, 0x23, 0x6e, 0x10, 0xef, 0xad, 0x06, 0x7b, 0xeb, 0xae, 0xd1,
	0xcd, 0x9d, 0x43, 0xd3, 0xf7, 0x7d, 0xaa, 0x25, 0x10, 0xa0, 0xb4, 0x67, 0x81, 0x63, 0xa5, 0x77,
	0x71, 0x17, 0xac, 0x49, 0xf5, 0x97, 0x18, 0x19, 0xc9, 0x1a, 0xb9, 0xec, 0x12, 0x9f, 0x83, 0xc2,
	0x9c, 0x2e, 0x81, 0x08, 0xc5, 0xe6, 0xd3, 0xe8, 0xfe, 0x8e, 0x0f, 0xb5, 0x43, 0x62, 0xbb, 0xc2,
	0xad, 0xa9, 0x40, 0xe9, 0xed, 0x92, 0xec, 0x8a, 0x34, 0x12, 0x18, 0x8e, 0x9a, 0xda, 0x02, 0xed,
	0xfe, 0x4f, 0x18, 0x6b, 0x98, 0x74, 0x68, 0xc2, 0x5f, 0xc4, 0x45, 0x7d, 0xbe, 0x80, 0x47, 0x84,
	0xbf, 0x0e, 0xf9, 0xa8, 0xf8, 0xcd, 0x39, 0xc1, 0xae, 0x15, 0x27, 0xa3, 0x83, 0x00, 0x4e, 0xbe,
	0x7e, 0x88, 0x99, 0xbd, 0x63, 0xa6, 0x63, 0x69, 0x87, 0xf3, 0x62, 0x51, 0x38, 0x12, 0x98, 0x08,
	0x7f, 0xea, 0x8e, 0x10, 0x1f, 0xce, 0x1c, 0x81, 0x5b, 0x0b, 0x1a, 0xf8, 0x4d, 0xb4, 0xff, 0x50,
	0x4f, 0x1e, 0xea, 0x2f, 0xe6, 0x0e, 0xac, 0x08, 0x65, 0x1b, 0xba, 0x62, 0x16, 0x8b, 0x54, 0xb6,
	0xd0, 0x06, 0x09, 0xe4, 0xee, 0x44, 0xc4, 0x21, 0xd4, 0x27, 0xc5, 0x06, 0x02, 0xad, 0xa5, 0xa9
};
#endif

#ifdef RSA4096_VERIFY
static uint8_t RSA4096_KEY_N[] = {
	0xC3, 0x8B, 0x55, 0x7B, 0x73, 0x4D, 0xFF, 0xE9, 0x9B, 0xC6, 0xDC, 0x67, 0x3C, 0xB4, 0x8E, 0xA0,
	0x86, 0xED, 0xF2, 0xB9, 0x50, 0x5C, 0x54, 0x5C, 0xBA, 0xE4, 0xA1, 0xB2, 0xA7, 0xAE, 0x2F, 0x1B,
	0x7D, 0xF1, 0xFB, 0xAC, 0x79, 0xC5, 0xDF, 0x1A, 0x00, 0xC9, 0xB2, 0xC1, 0x61, 0x25, 0x33, 0xE6,
	0x9C, 0xE9, 0xCF, 0xD6, 0x27, 0xC4, 0x4E, 0x44, 0x30, 0x44, 0x5E, 0x08, 0xA1, 0x87, 0x52, 0xCC,
	0x6B, 0x97, 0x70, 0x8C, 0xBC, 0xA5, 0x06, 0x31, 0x0C, 0xD4, 0x2F, 0xD5, 0x7D, 0x26, 0x24, 0xA2,
	0xE2, 0xAC, 0x78, 0xF4, 0x53, 0x14, 0xCE, 0xF7, 0x19, 0x2E, 0xD7, 0xF7, 0xE6, 0x0C, 0xB9, 0x56,
	0x7F, 0x0B, 0xF1, 0xB1, 0xE2, 0x43, 0x70, 0xBD, 0x86, 0x1D, 0xA1, 0xCC, 0x2B, 0x19, 0x08, 0x76,
	0xEF, 0x91, 0xAC, 0xBF, 0x20, 0x24, 0x0D, 0x38, 0xC0, 0x89, 0xB8, 0x9A, 0x70, 0xB3, 0x64, 0xD9,
	0x8F, 0x80, 0x41, 0x10, 0x5B, 0x9F, 0xB1, 0xCB, 0x76, 0x43, 0x00, 0x21, 0x25, 0x36, 0xD4, 0x19,
	0xFC, 0x55, 0x95, 0x10, 0xE4, 0x26, 0x74, 0x98, 0x2C, 0xD9, 0xBD, 0x0B, 0x2B, 0x04, 0xC2, 0xAC,
	0x82, 0x38, 0xB4, 0xDD, 0x4C, 0x04, 0x7E, 0x51, 0x36, 0x40, 0x1E, 0x0B, 0xC4, 0x7C, 0x25, 0xDD,
	0x4B, 0xB2, 0xE7, 0x20, 0x0A, 0x57, 0xF9, 0xB4, 0x94, 0xC3, 0x08, 0x33, 0x22, 0x6F, 0x8B, 0x48,
	0xDB, 0x03, 0x68, 0x5A, 0x5B, 0xBA, 0xAE, 0xF3, 0xAD, 0xCF, 0xC3, 0x6D, 0xBA, 0xF1, 0x28, 0x67,
	0x7E, 0x6C, 0x79, 0x07, 0xDE, 0xFC, 0xED, 0xE7, 0x96, 0xE3, 0x6C, 0xE0, 0x2C, 0x87, 0xF8, 0x02,
	0x01, 0x28, 0x38, 0x43, 0x21, 0x53, 0x84, 0x69, 0x75, 0x78, 0x15, 0x7E, 0xEE, 0xD2, 0x1B, 0xB9,
	0x23, 0x40, 0xA8, 0x86, 0x1E, 0x38, 0x83, 0xB2, 0x73, 0x1D, 0x53, 0xFB, 0x9E, 0x2A, 0x8A, 0xB2,
	0x75, 0x35, 0x01, 0xC3, 0xC3, 0xC4, 0x94, 0xE8, 0x84, 0x86, 0x64, 0x81, 0xF4, 0x42, 0xAA, 0x3C,
	0x0E, 0xD6, 0x4F, 0xBC, 0x0A, 0x09, 0x2D, 0xE7, 0x1B, 0xD4, 0x10, 0xA8, 0x54, 0xEA, 0x89, 0x84,
	0x8A, 0xCB, 0xF7, 0x5A, 0x3C, 0xCA, 0x76, 0x08, 0x29, 0x62, 0xB4, 0x6A, 0x22, 0xDF, 0x14, 0x95,
	0x71, 0xFD, 0xB6, 0x86, 0x39, 0xB8, 0x8B, 0xF8, 0x91, 0x7F, 0x38, 0xAA, 0x14, 0xCD, 0xE5, 0xF5,
	0x1D, 0xC2, 0x6D, 0x53, 0x69, 0x52, 0x84, 0x7F, 0xA3, 0x1A, 0x5E, 0x26, 0x04, 0x83, 0x06, 0x73,
	0x52, 0x56, 0xCF, 0x76, 0x26, 0xC9, 0xDD, 0x75, 0xD7, 0xFC, 0xF4, 0x69, 0xD8, 0x7B, 0x55, 0xB7,
	0x68, 0x13, 0x53, 0xB9, 0xE7, 0x89, 0xC3, 0xE8, 0xD6, 0x6E, 0xA7, 0x6D, 0xEA, 0x81, 0xFD, 0xC4,
	0xB7, 0x05, 0x5A, 0xB7, 0x41, 0x0A, 0x23, 0x8E, 0x03, 0x8A, 0x1C, 0xAE, 0xD3, 0x1E, 0xCE, 0xE3,
	0x5E, 0xFC, 0x19, 0x4A, 0xEE, 0x61, 0x9B, 0x8E, 0xE5, 0xE5, 0xDD, 0x85, 0xF9, 0x41, 0xEC, 0x14,
	0x53, 0x92, 0xF7, 0xDD, 0x06, 0x85, 0x02, 0x91, 0xE3, 0xEB, 0x6C, 0x43, 0x03, 0xB1, 0x36, 0x7B,
	0x89, 0x5A, 0xA8, 0xEB, 0xFC, 0xD5, 0xA8, 0x35, 0xDC, 0x81, 0xD9, 0x5C, 0xBD, 0xCA, 0xDC, 0x9B,
	0x98, 0x0B, 0x06, 0x5D, 0x0C, 0x5B, 0xEE, 0xF3, 0xD5, 0xCC, 0x57, 0xC9, 0x71, 0x2F, 0x90, 0x3B,
	0x3C, 0xF0, 0x8E, 0x4E, 0x35, 0x48, 0xAE, 0x63, 0x74, 0xA9, 0xFC, 0x72, 0x75, 0x8E, 0x34, 0xA8,
	0xF2, 0x1F, 0xEA, 0xDF, 0x3A, 0x37, 0x2D, 0xE5, 0x39, 0x39, 0xF8, 0x57, 0x58, 0x3C, 0x04, 0xFE,
	0x87, 0x06, 0x98, 0xBC, 0x7B, 0xD3, 0x21, 0x36, 0x60, 0x25, 0x54, 0xA7, 0x3D, 0xFA, 0x91, 0xCC,
	0xA8, 0x0B, 0x92, 0x8E, 0xB4, 0xF7, 0x06, 0xFF, 0x1E, 0x95, 0xCB, 0x07, 0x76, 0x97, 0x3B, 0x9D
};

static uint8_t RSA4096_KEY_E[] = {0x01,0x00,0x01};

static uint8_t RSA4096_KEY_D[] = {
	0x74, 0xA9, 0xE0, 0x6A, 0x32, 0xB4, 0xCA, 0x85, 0xD9, 0x86, 0x9F, 0x60, 0x88, 0x7B, 0x40, 0xCC,
	0xCD, 0x33, 0x91, 0xA8, 0xB6, 0x25, 0x1F, 0xBF, 0xE3, 0x51, 0x1C, 0x97, 0xB6, 0x2A, 0xD9, 0xB8,
	0x11, 0x40, 0x19, 0xE3, 0x21, 0x13, 0xC8, 0xB3, 0x7E, 0xDC, 0xD7, 0x65, 0x40, 0x4C, 0x2D, 0xD6,
	0xDC, 0xAF, 0x32, 0x6C, 0x96, 0x75, 0x2C, 0x2C, 0xCA, 0x8F, 0x3F, 0x7A, 0xEE, 0xC4, 0x09, 0xC6,
	0x24, 0x3A, 0xC9, 0xCF, 0x6D, 0x8D, 0x17, 0x50, 0x94, 0x52, 0xD3, 0xE7, 0x0F, 0x2F, 0x7E, 0x94,
	0x1F, 0xA0, 0xBE, 0xD9, 0x25, 0xE8, 0x38, 0x42, 0x7C, 0x27, 0xD2, 0x79, 0xF8, 0x2A, 0x87, 0x38,
	0xEF, 0xBB, 0x74, 0x8B, 0xA8, 0x6E, 0x8C, 0x08, 0xC6, 0xC7, 0x4F, 0x0C, 0xBC, 0x79, 0xC6, 0xEF,
	0x0E, 0xA7, 0x5E, 0xE4, 0xF8, 0x8C, 0x09, 0xC7, 0x5E, 0x37, 0xCC, 0x87, 0x77, 0xCD, 0xCF, 0xD1,
	0x6D, 0x28, 0x1B, 0xA9, 0x62, 0xC0, 0xB8, 0x16, 0xA7, 0x8B, 0xF9, 0xBB, 0xCC, 0xB4, 0x15, 0x7F,
	0x1B, 0x69, 0x03, 0xF2, 0x7B, 0xEB, 0xE5, 0x8C, 0x14, 0xD6, 0x23, 0x4F, 0x52, 0x6F, 0x18, 0xA6,
	0x4B, 0x5B, 0x01, 0xAD, 0x35, 0xF9, 0x48, 0x53, 0xB3, 0x86, 0x35, 0x66, 0xD7, 0xE7, 0x29, 0xC0,
	0x09, 0xB5, 0xC6, 0xE6, 0xFA, 0xC4, 0xDA, 0x19, 0xBE, 0xD7, 0x4D, 0x41, 0x14, 0xBE, 0x6F, 0xDF,
	0x1B, 0xAB, 0xC0, 0xCA, 0x88, 0x07, 0xAC, 0xF1, 0x7D, 0x35, 0x83, 0x67, 0x28, 0x2D, 0x50, 0xE9,
	0xCE, 0x27, 0x71, 0x5E, 0x1C, 0xCF, 0xD2, 0x30, 0x65, 0x79, 0x72, 0x2F, 0x9C, 0xE1, 0xD2, 0x39,
	0x7F, 0xEF, 0x3B, 0x01, 0xF2, 0x14, 0x1D, 0xDF, 0xBD, 0x51, 0xD3, 0xA1, 0x53, 0x62, 0xCF, 0x5F,
	0x79, 0x84, 0xCE, 0x06, 0x96, 0x69, 0x29, 0x49, 0x82, 0x1C, 0x71, 0x4A, 0xA1, 0x66, 0xC8, 0x2F,
	0xFD, 0x7B, 0x96, 0x7B, 0xFC, 0xC4, 0x26, 0x58, 0xC4, 0xFC, 0x7C, 0xAF, 0xB5, 0xE8, 0x95, 0x83,
	0x87, 0xCB, 0x46, 0xDE, 0x97, 0xA7, 0xB3, 0xA2, 0x54, 0x5B, 0xD7, 0xAF, 0xAB, 0xEB, 0xC8, 0xF3,
	0x55, 0x9D, 0x48, 0x2B, 0x30, 0x9C, 0xDC, 0x26, 0x4B, 0xC2, 0x89, 0x45, 0x13, 0xB2, 0x01, 0x9A,
	0xA4, 0x65, 0xC3, 0xEC, 0x24, 0x2D, 0x26, 0x97, 0xEB, 0x80, 0x8A, 0x9D, 0x03, 0xBC, 0x59, 0x66,
	0x9E, 0xE2, 0xBB, 0xBB, 0x63, 0x19, 0x64, 0x93, 0x11, 0x7B, 0x25, 0x65, 0x30, 0xCD, 0x5B, 0x4B,
	0x2C, 0xFF, 0xDC, 0x2D, 0x30, 0x87, 0x1F, 0x3C, 0x88, 0x07, 0xD0, 0xFC, 0x48, 0xCC, 0x05, 0x8A,
	0xA2, 0xC8, 0x39, 0x3E, 0xD5, 0x51, 0xBC, 0x0A, 0xBE, 0x6D, 0xA8, 0xA0, 0xF6, 0x88, 0x06, 0x79,
	0x13, 0xFF, 0x1B, 0x45, 0xDA, 0x54, 0xC9, 0x24, 0x25, 0x8A, 0x75, 0x0A, 0x26, 0xD1, 0x69, 0x81,
	0x14, 0x14, 0xD1, 0x79, 0x7D, 0x8E, 0x76, 0xF2, 0xE0, 0xEB, 0xDD, 0x0F, 0xDE, 0xC2, 0xEC, 0x80,
	0xD7, 0xDC, 0x16, 0x99, 0x92, 0xBE, 0xCB, 0x40, 0x0C, 0xCE, 0x7C, 0x3B, 0x46, 0xA2, 0x5B, 0x5D,
	0x0C, 0x45, 0xEB, 0xE1, 0x00, 0xDE, 0x72, 0x50, 0xB1, 0xA6, 0x0B, 0x76, 0xC5, 0x8D, 0xFC, 0x82,
	0x38, 0x6D, 0x99, 0x14, 0x1D, 0x1A, 0x4A, 0xD3, 0x7C, 0x53, 0xB8, 0x12, 0x46, 0xA2, 0x30, 0x38,
	0x82, 0xF4, 0x96, 0x6E, 0x8C, 0xCE, 0x47, 0x0D, 0xAF, 0x0A, 0x3B, 0x45, 0xB7, 0x43, 0x95, 0x43,
	0x9E, 0x02, 0x2C, 0x44, 0x07, 0x6D, 0x1F, 0x3C, 0x66, 0x89, 0x09, 0xB6, 0x1F, 0x06, 0x30, 0xCC,
	0xAD, 0xCE, 0x7D, 0x9A, 0xDE, 0x3E, 0xFB, 0x6C, 0xE4, 0x58, 0x43, 0xD2, 0x4F, 0xA5, 0x9E, 0x5E,
	0xA7, 0x7B, 0xAE, 0x3A, 0xF6, 0x7E, 0xD9, 0xDB, 0xD3, 0xF5, 0xC5, 0x41, 0xAF, 0xE6, 0x9C, 0x91
};

static uint8_t RSA4096_PLAINTEXT[] = {0x54,0x85,0x9b,0x34,0x2c,0x49,0xea,0x2a};

static uint8_t RSA4096_CIPHERTEXT[] = {
	0x5c, 0xce, 0x9c, 0xd7, 0x9a, 0x9e, 0xa1, 0xfe, 0x7a, 0x82, 0x3c, 0x68, 0x27, 0x98, 0xe3, 0x5d,
	0xd5, 0xd7, 0x07, 0x29, 0xf5, 0xfb, 0xc3, 0x1a, 0x7f, 0x63, 0x1e, 0x62, 0x31, 0x3b, 0x19, 0x87,
	0x79, 0x4f, 0xec, 0x7b, 0xf3, 0xcb, 0xea, 0x9b, 0x95, 0x52, 0x3a, 0x40, 0xe5, 0x87, 0x7b, 0x72,
	0xd1, 0x72, 0xc9, 0xfb, 0x54, 0x63, 0xd8, 0xc9, 0xd7, 0x2c, 0xfc, 0x7b, 0xc3, 0x14, 0x1e, 0xbc,
	0x18, 0xb4, 0x34, 0xa1, 0xbf, 0x14, 0xb1, 0x37, 0x31, 0x6e, 0xf0, 0x1b, 0x35, 0x19, 0x54, 0x07,
	0xf7, 0x99, 0xec, 0x3e, 0x63, 0xe2, 0xcd, 0x61, 0x28, 0x65, 0xc3, 0xcd, 0xb1, 0x38, 0x36, 0xa5,
	0xb2, 0xd7, 0xb0, 0xdc, 0x1f, 0xf5, 0xef, 0x19, 0xc7, 0x53, 0x32, 0x2d, 0x1c, 0x26, 0xda, 0xe4,
	0x0d, 0xd6, 0x90, 0x7e, 0x28, 0xd8, 0xdc, 0xe4, 0x61, 0x05, 0xd2, 0x25, 0x90, 0x01, 0xd3, 0x96,
	0x6d, 0xa6, 0xcf, 0x58, 0x20, 0xbb, 0x03, 0xf4, 0x01, 0xbc, 0x79, 0xb9, 0x18, 0xd8, 0xb8, 0xba,
	0xbd, 0x93, 0xfc, 0xf2, 0x62, 0x5d, 0x8c, 0x66, 0x1e, 0x0e, 0x84, 0x59, 0x93, 0xdd, 0xe2, 0x93,
	0xa2, 0x62, 0x7d, 0x08, 0x82, 0x7a, 0xdd, 0xfc, 0xb8, 0xbc, 0xc5, 0x4f, 0x9c, 0x4e, 0xbf, 0xb4,
	0xfc, 0xf4, 0xc5, 0x01, 0xe8, 0x00, 0x70, 0x4d, 0x28, 0x26, 0xcc, 0x2e, 0xfe, 0x0e, 0x58, 0x41,
	0x8b, 0xec, 0xaf, 0x7c, 0x4b, 0x54, 0xd0, 0xa0, 0x64, 0xf9, 0x32, 0xf4, 0x2e, 0x47, 0x65, 0x0a,
	0x67, 0x88, 0x39, 0x3a, 0xdb, 0xb2, 0xdb, 0x7b, 0xb5, 0xf6, 0x17, 0xa8, 0xd9, 0xc6, 0x5e, 0x28,
	0x13, 0x82, 0x8a, 0x99, 0xdb, 0x60, 0x08, 0xa5, 0x23, 0x37, 0xfa, 0x88, 0x90, 0x31, 0xc8, 0x9d,
	0x8f, 0xec, 0xfb, 0x85, 0x9f, 0xb1, 0xce, 0xa6, 0x24, 0x50, 0x46, 0x44, 0x47, 0xcb, 0x65, 0xd1,
	0xdf, 0xc0, 0xb1, 0x6c, 0x90, 0x1f, 0x99, 0x8e, 0x4d, 0xd5, 0x9e, 0x31, 0x07, 0x66, 0x87, 0xdf,
	0x01, 0xaa, 0x56, 0x3c, 0x71, 0xe0, 0x2b, 0x6f, 0x67, 0x3b, 0x23, 0xed, 0xc2, 0xbd, 0x03, 0x30,
	0x79, 0x76, 0x02, 0x10, 0x10, 0x98, 0x85, 0x8a, 0xff, 0xfd, 0x0b, 0xda, 0xa5, 0xd9, 0x32, 0x48,
	0x02, 0xa0, 0x0b, 0xb9, 0x2a, 0x8a, 0x18, 0xca, 0xc6, 0x8f, 0x3f, 0xbb, 0x16, 0xb2, 0xaa, 0x98,
	0x27, 0xe3, 0x60, 0x43, 0xed, 0x15, 0x70, 0xd4, 0x57, 0x15, 0xfe, 0x19, 0xd4, 0x9b, 0x13, 0x78,
	0x8a, 0xf7, 0x21, 0xf1, 0xa2, 0xa2, 0x2d, 0xb3, 0x09, 0xcf, 0x44, 0x91, 0x6e, 0x08, 0x3a, 0x30,
	0x81, 0x3e, 0x90, 0x93, 0x8a, 0x67, 0x33, 0x00, 0x59, 0x54, 0x9a, 0x25, 0xd3, 0x49, 0x8e, 0x9f,
	0xc1, 0x4b, 0xe5, 0x86, 0xf3, 0x50, 0x4c, 0xbc, 0xc5, 0xd3, 0xf5, 0x3a, 0x54, 0xe1, 0x36, 0x3f,
	0xe2, 0x5a, 0xb4, 0x37, 0xc0, 0xeb, 0x70, 0x35, 0xec, 0xf6, 0xb7, 0xe8, 0x44, 0x3b, 0x7b, 0xf3,
	0xf1, 0xf2, 0x1e, 0xdb, 0x60, 0x7d, 0xd5, 0xbe, 0xf0, 0x71, 0x34, 0x90, 0x4c, 0xcb, 0xd4, 0x35,
	0x51, 0xc7, 0xdd, 0xd8, 0xc9, 0x81, 0xf5, 0x5d, 0x57, 0x46, 0x2c, 0xb1, 0x7b, 0x9b, 0xaa, 0xcb,
	0xd1, 0x22, 0x25, 0x49, 0x44, 0xa3, 0xd4, 0x6b, 0x29, 0x7b, 0xd8, 0xb2, 0x07, 0x93, 0xbf, 0x3d,
	0x52, 0x49, 0x84, 0x79, 0xef, 0xb8, 0xe5, 0xc4, 0xad, 0xca, 0xa8, 0xc6, 0xf6, 0xa6, 0x76, 0x70,
	0x5b, 0x0b, 0xe5, 0x83, 0xc6, 0x0e, 0xef, 0x55, 0xf2, 0xe7, 0xff, 0x04, 0xea, 0xe6, 0x13, 0xbe,
	0x40, 0xe1, 0x40, 0x45, 0x48, 0x66, 0x75, 0x31, 0xae, 0x35, 0x64, 0x91, 0x11, 0x6f, 0xda, 0xee,
	0x26, 0x86, 0x45, 0x6f, 0x0b, 0xd5, 0x9f, 0x03, 0xb1, 0x65, 0x5b, 0xdb, 0xa4, 0xe4, 0xf9, 0x45
};
#endif

/**
 * do_nvt_rsa() - Handle the "nvt_rsa" command-line command
 * @cmdtp:	Command data struct pointer
 * @flag:	Command flag
 * @argc:	Command-line argument count
 * @argv:	Array of command-line arguments
 *
 * Returns zero on success, CMD_RET_USAGE in case of misuse and negative
 * on error.
 */
static int do_nvt_rsa(struct cmd_tbl *cmdtp, int flag, int argc, char *const argv[])
{
	int ret = 0;
	int key_w;
	int offset;
	int dst_size;
	uint8_t *dst_buf = NULL;
	struct nvt_rsa_pio_t rsa;

	/* Check argument */
	if (argc < 3)
		return CMD_RET_USAGE;

	/* Key Length */
	if (!strncmp(argv[1],      "rsa512", 6))
		key_w = NVT_RSA_KEY_WIDTH_512;
	else if (!strncmp(argv[1], "rsa1024", 7))
		key_w = NVT_RSA_KEY_WIDTH_1024;
	else if (!strncmp(argv[1], "rsa2048", 7))
		key_w = NVT_RSA_KEY_WIDTH_2048;
	else if (!strncmp(argv[1], "rsa4096", 7))
		key_w = NVT_RSA_KEY_WIDTH_4096;
	else
		return CMD_RET_USAGE;

	/* Command */
	if (strncmp(argv[2], "verify", 6))
		return CMD_RET_USAGE;

	/* verify case */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			dst_size = NVT_RSA_512_OUT_SIZE;
			break;
#ifdef RSA1024_VERIFY
		case NVT_RSA_KEY_WIDTH_1024:
			dst_size = NVT_RSA_1024_OUT_SIZE;
			break;
#endif
#ifdef RSA2048_VERIFY
		case NVT_RSA_KEY_WIDTH_2048:
			dst_size = NVT_RSA_2048_OUT_SIZE;
			break;
#endif
#ifdef RSA4096_VERIFY
		case NVT_RSA_KEY_WIDTH_4096:
			dst_size = NVT_RSA_4096_OUT_SIZE;
			break;
#endif
		default:
			printf("nvt rsa %s verify not support!\n", argv[1]);
			return CMD_RET_FAILURE;
	}

	/* Open RSA Device */
	ret = nvt_rsa_open();
	if (ret < 0) {
		printf("nvt rsa open failed!\n");
		return CMD_RET_FAILURE;
	}

	/* alloc buffer */
	dst_buf = malloc(dst_size);
	if (!dst_buf) {
		printf("nvt rsa %s verify to allocate output buffer failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	/* RSA Encryption */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			rsa.key_w       = key_w;
			rsa.src         = RSA512_PLAINTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA512_KEY_N;
			rsa.key_ed      = RSA512_KEY_E;
			rsa.src_size    = sizeof(RSA512_PLAINTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA512_KEY_N);
			rsa.key_ed_size = sizeof(RSA512_KEY_E);
			break;
#ifdef RSA1024_VERIFY
		case NVT_RSA_KEY_WIDTH_1024:
			rsa.key_w       = key_w;
			rsa.src         = RSA1024_PLAINTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA1024_KEY_N;
			rsa.key_ed      = RSA1024_KEY_E;
			rsa.src_size    = sizeof(RSA1024_PLAINTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA1024_KEY_N);
			rsa.key_ed_size = sizeof(RSA1024_KEY_E);
			break;
#endif
#ifdef RSA2048_VERIFY
		case NVT_RSA_KEY_WIDTH_2048:
			rsa.key_w       = key_w;
			rsa.src         = RSA2048_PLAINTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA2048_KEY_N;
			rsa.key_ed      = RSA2048_KEY_E;
			rsa.src_size    = sizeof(RSA2048_PLAINTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA2048_KEY_N);
			rsa.key_ed_size = sizeof(RSA2048_KEY_E);
			break;
#endif
#ifdef RSA4096_VERIFY
		case NVT_RSA_KEY_WIDTH_4096:
			rsa.key_w       = key_w;
			rsa.src         = RSA4096_PLAINTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA4096_KEY_N;
			rsa.key_ed      = RSA4096_KEY_E;
			rsa.src_size    = sizeof(RSA4096_PLAINTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA4096_KEY_N);
			rsa.key_ed_size = sizeof(RSA4096_KEY_E);
			break;
#endif
		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	ret = nvt_rsa_pio_normal(&rsa);
	if (ret < 0) {
		printf("nvt rsa %s encryption failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	/* Ciphertext Compare */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			ret = memcmp(dst_buf, RSA512_CIPHERTEXT, sizeof(RSA512_CIPHERTEXT));
			break;
#ifdef RSA1024_VERIFY
		case NVT_RSA_KEY_WIDTH_1024:
			ret = memcmp(dst_buf, RSA1024_CIPHERTEXT, sizeof(RSA1024_CIPHERTEXT));
			break;
#endif
#ifdef RSA2048_VERIFY
		case NVT_RSA_KEY_WIDTH_2048:
			ret = memcmp(dst_buf, RSA2048_CIPHERTEXT, sizeof(RSA2048_CIPHERTEXT));
			break;
#endif
#ifdef RSA4096_VERIFY
		case NVT_RSA_KEY_WIDTH_4096:
			ret = memcmp(dst_buf, RSA4096_CIPHERTEXT, sizeof(RSA4096_CIPHERTEXT));
			break;
#endif
		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	if (ret) {
		printf("nvt rsa %s encryption compare failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	/* RSA Decryption */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			rsa.key_w       = key_w;
			rsa.src         = RSA512_CIPHERTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA512_KEY_N;
			rsa.key_ed      = RSA512_KEY_D;
			rsa.src_size    = sizeof(RSA512_CIPHERTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA512_KEY_N);
			rsa.key_ed_size = sizeof(RSA512_KEY_D);
			break;
#ifdef RSA1024_VERIFY
		case NVT_RSA_KEY_WIDTH_1024:
			rsa.key_w       = key_w;
			rsa.src         = RSA1024_CIPHERTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA1024_KEY_N;
			rsa.key_ed      = RSA1024_KEY_D;
			rsa.src_size    = sizeof(RSA1024_CIPHERTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA1024_KEY_N);
			rsa.key_ed_size = sizeof(RSA1024_KEY_D);
			break;
#endif
#ifdef RSA2048_VERIFY
		case NVT_RSA_KEY_WIDTH_2048:
			rsa.key_w       = key_w;
			rsa.src         = RSA2048_CIPHERTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA2048_KEY_N;
			rsa.key_ed      = RSA2048_KEY_D;
			rsa.src_size    = sizeof(RSA2048_CIPHERTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA2048_KEY_N);
			rsa.key_ed_size = sizeof(RSA2048_KEY_D);
			break;
#endif
#ifdef RSA4096_VERIFY
		case NVT_RSA_KEY_WIDTH_4096:
			rsa.key_w       = key_w;
			rsa.src         = RSA4096_CIPHERTEXT;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA4096_KEY_N;
			rsa.key_ed      = RSA4096_KEY_D;
			rsa.src_size    = sizeof(RSA4096_CIPHERTEXT);
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA4096_KEY_N);
			rsa.key_ed_size = sizeof(RSA4096_KEY_D);
			break;
#endif
		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	ret = nvt_rsa_pio_normal(&rsa);
	if (ret < 0) {
		printf("nvt rsa %s decryption failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	/* Plaintext Compare */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			offset = dst_size - sizeof(RSA512_PLAINTEXT);
			if (offset < 0 || (offset >= NVT_RSA_512_OUT_SIZE))
				offset = 0;
			ret = memcmp(&dst_buf[offset], RSA512_PLAINTEXT, sizeof(RSA512_PLAINTEXT));
			break;
#ifdef RSA1024_VERIFY
		case NVT_RSA_KEY_WIDTH_1024:
			offset = dst_size - sizeof(RSA1024_PLAINTEXT);
			if (offset < 0 || (offset >= NVT_RSA_1024_OUT_SIZE))
				offset = 0;
			ret = memcmp(&dst_buf[offset], RSA1024_PLAINTEXT, sizeof(RSA1024_PLAINTEXT));
			break;
#endif
#ifdef RSA2048_VERIFY
		case NVT_RSA_KEY_WIDTH_2048:
			offset = dst_size - sizeof(RSA2048_PLAINTEXT);
			if (offset < 0 || (offset >= NVT_RSA_2048_OUT_SIZE))
				offset = 0;
			ret = memcmp(&dst_buf[offset], RSA2048_PLAINTEXT, sizeof(RSA2048_PLAINTEXT));
			break;
#endif
#ifdef RSA4096_VERIFY
		case NVT_RSA_KEY_WIDTH_4096:
			offset = dst_size - sizeof(RSA4096_PLAINTEXT);
			if (offset < 0 || (offset >= NVT_RSA_4096_OUT_SIZE))
				offset = 0;
			ret = memcmp(&dst_buf[offset], RSA4096_PLAINTEXT, sizeof(RSA4096_PLAINTEXT));
			break;
#endif
		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	if (ret) {
		printf("nvt rsa %s decryption compare failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	printf("nvt rsa %s verify passed!\n", argv[1]);

exit:
	/* Close RSA Device */
	nvt_rsa_close();

	if (dst_buf)
		free(dst_buf);

	return ret;
}

/**
 * do_nvt_rsa() - Handle the "nvt_rsa" command-line command
 * @cmdtp:	Command data struct pointer
 * @flag:	Command flag
 * @argc:	Command-line argument count
 * @argv:	Array of command-line arguments
 *
 * Returns zero on success, CMD_RET_USAGE in case of misuse and negative
 * on error.
 */
static int perf_nvt_rsa(struct cmd_tbl *cmdtp, int flag, int argc, char *const argv[])
{
	int ret = 0;
	int key_w;
	int offset;
	int dst_size;
	uint8_t *dst_buf = NULL;
	struct nvt_rsa_pio_t rsa;
	int	test_size = 0;
	unsigned long test_buf;
	uint8_t* input;
	uint32_t start, end;

	/* Check argument */
	if (argc < 3)
		return CMD_RET_USAGE;

	/* Key Length */
	if (!strncmp(argv[1],      "rsa512", 6))
		key_w = NVT_RSA_KEY_WIDTH_512;
	else if (!strncmp(argv[1], "rsa1024", 7))
		key_w = NVT_RSA_KEY_WIDTH_1024;
	else if (!strncmp(argv[1], "rsa2048", 7))
		key_w = NVT_RSA_KEY_WIDTH_2048;
	else if (!strncmp(argv[1], "rsa4096", 7))
		key_w = NVT_RSA_KEY_WIDTH_4096;
	else
		return CMD_RET_USAGE;

	/* Command */
	if (strncmp(argv[2], "perf", 6))
		return CMD_RET_USAGE;

	/* perf case */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			dst_size = NVT_RSA_512_OUT_SIZE;
			break;
		case NVT_RSA_KEY_WIDTH_1024:
			dst_size = NVT_RSA_1024_OUT_SIZE;
			break;
		case NVT_RSA_KEY_WIDTH_2048:
			dst_size = NVT_RSA_2048_OUT_SIZE;
			break;
		case NVT_RSA_KEY_WIDTH_4096:
			dst_size = NVT_RSA_4096_OUT_SIZE;
			break;
			printf("nvt rsa %s verify not support!\n", argv[1]);
			return CMD_RET_FAILURE;
	}

	/* Open RSA Device */
	ret = nvt_rsa_open();
	if (ret < 0) {
		printf("nvt rsa open failed!\n");
		return CMD_RET_FAILURE;
	}

	/* alloc buffer */
	dst_buf = malloc(dst_size);
	if (!dst_buf) {
		printf("nvt rsa %s verify to allocate output buffer failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	
	/* alloc buffer */
	test_size = dst_size - 11; // according to the maximum formula
	test_buf = (unsigned long)malloc(test_size);
	input = (uint8_t *)test_buf;
	memset(input, 0xFF, test_size);

	printf("PLAINTEXT is %d bytes\n", test_size);


	/* RSA Encryption */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA512_KEY_N;
			rsa.key_ed      = RSA512_KEY_E;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA512_KEY_N);
			rsa.key_ed_size = sizeof(RSA512_KEY_E);
			break;

		case NVT_RSA_KEY_WIDTH_1024:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA1024_KEY_N;
			rsa.key_ed      = RSA1024_KEY_E;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA1024_KEY_N);
			rsa.key_ed_size = sizeof(RSA1024_KEY_E);
			break;


		case NVT_RSA_KEY_WIDTH_2048:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA2048_KEY_N;
			rsa.key_ed      = RSA2048_KEY_E;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA2048_KEY_N);
			rsa.key_ed_size = sizeof(RSA2048_KEY_E);
			break;

		case NVT_RSA_KEY_WIDTH_4096:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA4096_KEY_N;
			rsa.key_ed      = RSA4096_KEY_E;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA4096_KEY_N);
			rsa.key_ed_size = sizeof(RSA4096_KEY_E);
			break;

		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	start = timer_get_us();
	ret = nvt_rsa_pio_normal(&rsa);
	end = timer_get_us();
	if (ret < 0) {
		printf("nvt rsa %s encryption failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}
	printf("nvt rsa encryption %d us \n", (end-start)); 


	/* RSA Decryption */
	switch (key_w) {
		case NVT_RSA_KEY_WIDTH_512:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA512_KEY_N;
			rsa.key_ed      = RSA512_KEY_D;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA512_KEY_N);
			rsa.key_ed_size = sizeof(RSA512_KEY_D);
			break;

		case NVT_RSA_KEY_WIDTH_1024:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA1024_KEY_N;
			rsa.key_ed      = RSA1024_KEY_D;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA1024_KEY_N);
			rsa.key_ed_size = sizeof(RSA1024_KEY_D);
			break;

		case NVT_RSA_KEY_WIDTH_2048:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA2048_KEY_N;
			rsa.key_ed      = RSA2048_KEY_D;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA2048_KEY_N);
			rsa.key_ed_size = sizeof(RSA2048_KEY_D);
			break;

		case NVT_RSA_KEY_WIDTH_4096:
			rsa.key_w       = key_w;
			rsa.src         = input;
			rsa.dst         = dst_buf;
			rsa.key_n       = RSA4096_KEY_N;
			rsa.key_ed      = RSA4096_KEY_D;
			rsa.src_size    = test_size;
			rsa.dst_size    = dst_size;
			rsa.key_n_size  = sizeof(RSA4096_KEY_N);
			rsa.key_ed_size = sizeof(RSA4096_KEY_D);
			break;

		default:
			ret = CMD_RET_FAILURE;
			goto exit;
	}
	start = timer_get_us();
	ret = nvt_rsa_pio_normal(&rsa);
	end = timer_get_us();
	if (ret < 0) {
		printf("nvt rsa %s decryption failed!\n", argv[1]);
		ret = CMD_RET_FAILURE;
		goto exit;
	}

	printf("nvt rsa decryption %d us \n", (end-start)); 


exit:
	/* Close RSA Device */
	nvt_rsa_close();
	if (input)
		free(input);

	if (dst_buf)
		free(dst_buf);

	return ret;
}

/***************************************************/
U_BOOT_CMD(
	nvt_rsa, 3, 0, do_nvt_rsa,
	"nvt_rsa operation",
	"\nnvt_rsa rsa512  verify - for verify rsa512  encryption/decryption"
#ifdef RSA1024_VERIFY
	"\nnvt_rsa rsa1024 verify - for verify rsa1024 encryption/decryption"
#endif
#ifdef RSA2048_VERIFY
	"\nnvt_rsa rsa2048 verify - for verify rsa2048 encryption/decryption"
#endif
#ifdef RSA4096_VERIFY
	"\nnvt_rsa rsa4096 verify - for verify rsa4096 encryption/decryption"
#endif
);

U_BOOT_CMD(
	nvt_rsa_perf, 3, 0, perf_nvt_rsa,
	"nvt_rsa_perf operation",
	"\nnvt_rsa_perf rsa512  perf - for perf rsa512  encryption/decryption"
	"\nnvt_rsa_perf rsa1024 perf - for perf rsa1024 encryption/decryption"
	"\nnvt_rsa_perf rsa2048 perf - for perf rsa2048 encryption/decryption"
	"\nnvt_rsa_perf rsa4096 perf - for perf rsa4096 encryption/decryption"
);