/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) Novatek Inc.
 */

#ifndef PWM_ABNVT_H
#define PWM_ABNVT_H

#include <common.h>
#include <dm.h>
#include <asm/nvt-common/nvt_common.h>
#include <asm/arch/IOAddress.h>
#include <clk.h>

int abpwm_init(int pwm_id,int pwm_id2, int div, int invert);
void nvt_abpwm_set_freq(int pwm_id, u32 freq);
int abpwm_enable(int pwm_id);
void abpwm_disable(int pwm_id);

#ifndef DBG_ERR
#define DBG_ERR(fmtstr, args...)  printf("\033[0;31mERR:%s() \033[0m" fmtstr, __func__, ##args)
#endif

#endif
