/*
    HDMI register header file

    HDMI register header file.

    @file       hdmitx_reg.h
    @ingroup    mIDrvDisp_HDMITx
    @note       Nothing.

    Copyright   Novatek Microelectronics Corp. 2014.  All rights reserved.
*/

#ifndef _HDMITX_REG_H
#define _HDMITX_REG_H

#include <asm/arch/IOAddress.h>
#include <asm/nvt-common/rcw_macro_bit.h>
//#include <asm/nvt-common/rcw_macro.h>

//#include <asm/arch/efuse_protected.h>



//
//  HDMI TX Module Registers
//

REGDEF_OFFSET(HDMI_SYSCTRL_REG, 0x00)
REGDEF_BEGIN(HDMI_SYSCTRL_REG)
REGDEF_BIT(TXD_RST, 1)
REGDEF_BIT(FIFORST, 1)
REGDEF_BIT(TXPHY_RST, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(HDMI2, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(HSYNC_GATING, 1)
REGDEF_BIT(VSYNC_GATING, 1)
REGDEF_BIT(VSYNC, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(PIXCLK_STABLE, 1)
REGDEF_BIT(HPD, 1)
REGDEF_BIT(RSEN, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(AUD_MUTE, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(VD_INV, 1)
REGDEF_BIT(HD_INV, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(COMP0_SEL, 2)
REGDEF_BIT(COMP1_SEL, 2)
REGDEF_BIT(COMP2_SEL, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(SRC_SEL, 1)
REGDEF_END(HDMI_SYSCTRL_REG)

REGDEF_OFFSET(HDMI_DEBUG_REG, 0x0C)
REGDEF_BEGIN(HDMI_DEBUG_REG)
REGDEF_BIT(CP_RESTN, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(, 1)
REGDEF_BIT(, 8)
REGDEF_BIT(SIL9002_PD, 1)
REGDEF_BIT(SIL9002_ISEL, 1)
REGDEF_BIT(SIL9002_CLKINV, 1)
REGDEF_BIT(DBG_SEL, 8)
REGDEF_BIT(DC_HEADER, 8)
REGDEF_END(HDMI_DEBUG_REG)

REGDEF_OFFSET(HDMI_INTSTS_REG, 0x20)
REGDEF_BEGIN(HDMI_INTSTS_REG)
REGDEF_BIT(OVRUN_STS, 1)
REGDEF_BIT(RSEN_STS, 1)
REGDEF_BIT(HPD_CHG_STS, 1)
REGDEF_BIT(VSYNC_STS, 1)
REGDEF_BIT(PIXLK_STBL_STS, 1)
REGDEF_BIT(ACR_OVR_STS, 1)
REGDEF_BIT(CTS_CHG_STS, 1)
REGDEF_BIT(GCP_CHG_MUTE_STS, 1)
REGDEF_BIT(, 12)
REGDEF_BIT(CEC_RX_FRM_STS, 1)
REGDEF_BIT(CEC_RXPOLLING_STS, 1)
REGDEF_BIT(CEC_TX_FRM_STS, 1)
REGDEF_BIT(CEC_TX_RETRY_STS, 1)
REGDEF_BIT(CEC_TX_AL_STS, 1)
REGDEF_BIT(CEC_RX_TIMEOUT_STS, 1)
REGDEF_BIT(CEC_ERROR_STS, 1)
REGDEF_BIT(, 5)
REGDEF_END(HDMI_INTSTS_REG)

REGDEF_OFFSET(HDMI_INTEN_REG, 0x24)
REGDEF_BEGIN(HDMI_INTEN_REG)
REGDEF_BIT(OVRUN_EN, 1)
REGDEF_BIT(RSEN_EN, 1)
REGDEF_BIT(HPD_CHG_EN, 1)
REGDEF_BIT(VSYNC_EN, 1)
REGDEF_BIT(PIXLK_STBL_EN, 1)
REGDEF_BIT(ACR_OVR_EN, 1)
REGDEF_BIT(CTS_CHG_EN, 1)
REGDEF_BIT(GCP_CHG_MUTE_EN, 1)
REGDEF_BIT(, 12)
REGDEF_BIT(CEC_RX_FRM_EN, 1)
REGDEF_BIT(CEC_RXPOLLING_EN, 1)
REGDEF_BIT(CEC_TX_FRM_EN, 1)
REGDEF_BIT(CEC_TX_RETRY_EN, 1)
REGDEF_BIT(CEC_TX_AL_EN, 1)
REGDEF_BIT(CEC_RX_TIMEOUT_EN, 1)
REGDEF_BIT(CEC_ERROR_EN, 1)
REGDEF_BIT(, 5)
REGDEF_END(HDMI_INTEN_REG)

REGDEF_OFFSET(HDMI_TMDSCTRL0_REG, 0x28)
REGDEF_BEGIN(HDMI_TMDSCTRL0_REG)
REGDEF_BIT(, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(CLKDETECT_STS, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(TCLKSEL, 2)
REGDEF_BIT(, 9)
REGDEF_END(HDMI_TMDSCTRL0_REG)

REGDEF_OFFSET(HDMI_TMDSCTRL1_REG, 0x2C)
REGDEF_BEGIN(HDMI_TMDSCTRL1_REG)
REGDEF_BIT(, 16)
REGDEF_BIT(SAFE_START, 9)
REGDEF_BIT(, 7)
REGDEF_END(HDMI_TMDSCTRL1_REG)

REGDEF_OFFSET(HDMI_PG0_REG, 0x30)
REGDEF_BEGIN(HDMI_PG0_REG)
REGDEF_BIT(EN, 1)
REGDEF_BIT(PIXGEN_EN, 1)
REGDEF_BIT(SYNCGEN_EN, 1)
REGDEF_BIT(UPDATE, 1)
REGDEF_BIT(PR_CNT, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(VBUF_EN, 1)
REGDEF_BIT(PG_TYPE, 5)
REGDEF_BIT(, 2)
REGDEF_BIT(CBAR_EN, 1)
REGDEF_BIT(DEPTH_TYPE, 2)
REGDEF_BIT(, 14)
REGDEF_END(HDMI_PG0_REG)

REGDEF_OFFSET(HDMI_PG1_REG, 0x34)
REGDEF_BEGIN(HDMI_PG1_REG)
REGDEF_BIT(GRAY, 10)
REGDEF_BIT(, 6)
REGDEF_BIT(SG_HTOT, 16)
REGDEF_END(HDMI_PG1_REG)

REGDEF_OFFSET(HDMI_PG2_REG, 0x38)
REGDEF_BEGIN(HDMI_PG2_REG)
REGDEF_BIT(SG_HSW, 16)
REGDEF_BIT(SG_HAB, 16)
REGDEF_END(HDMI_PG2_REG)

REGDEF_OFFSET(HDMI_PG3_REG, 0x3C)
REGDEF_BEGIN(HDMI_PG3_REG)
REGDEF_BIT(SG_HAW, 16)
REGDEF_BIT(SG_VTOT, 16)
REGDEF_END(HDMI_PG3_REG)

REGDEF_OFFSET(HDMI_PG4_REG, 0x40)
REGDEF_BEGIN(HDMI_PG4_REG)
REGDEF_BIT(SG_VSW, 16)
REGDEF_BIT(SG_VAB, 16)
REGDEF_END(HDMI_PG4_REG)

REGDEF_OFFSET(HDMI_PG5_REG, 0x44)
REGDEF_BEGIN(HDMI_PG5_REG)
REGDEF_BIT(SG_VAW, 16)
REGDEF_BIT(, 16)
REGDEF_END(HDMI_PG5_REG)



REGDEF_OFFSET(HDMI_AUDCTRL_REG, 0x70)
REGDEF_BEGIN(HDMI_AUDCTRL_REG)
REGDEF_BIT(CTS_SEL, 1)
REGDEF_BIT(NCTSPKT_EN, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(AUD_EN, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(N_SVAL, 20)
REGDEF_BIT(, 4)
REGDEF_END(HDMI_AUDCTRL_REG)

REGDEF_OFFSET(HDMI_SWCTS_REG, 0x74)
REGDEF_BEGIN(HDMI_SWCTS_REG)
REGDEF_BIT(CTS_SVAL, 20)
REGDEF_BIT(, 12)
REGDEF_END(HDMI_SWCTS_REG)

REGDEF_OFFSET(HDMI_HWCTS_REG, 0x78)
REGDEF_BEGIN(HDMI_HWCTS_REG)
REGDEF_BIT(CTS_HVAL, 20)
REGDEF_BIT(, 12)
REGDEF_END(HDMI_HWCTS_REG)

REGDEF_OFFSET(HDMI_PCMHDR0_REG, 0x80)
REGDEF_BEGIN(HDMI_PCMHDR0_REG)
REGDEF_BIT(SEL, 1)
REGDEF_BIT(PCM, 1)
REGDEF_BIT(COPYRIGHT, 1)
REGDEF_BIT(INFO, 3)
REGDEF_BIT(MODE, 2)
REGDEF_BIT(CATEGORY, 8)
REGDEF_BIT(SRCNUM, 4)
REGDEF_BIT(CANNUM, 4)
REGDEF_BIT(FS, 4)
REGDEF_BIT(CLKACCUR, 4)
REGDEF_END(HDMI_PCMHDR0_REG)

REGDEF_OFFSET(HDMI_PCMHDR1_REG, 0x84)
REGDEF_BEGIN(HDMI_PCMHDR1_REG)
REGDEF_BIT(MAXLEN, 1)
REGDEF_BIT(WORDLEN, 3)
REGDEF_BIT(FS_ORIG, 4)
REGDEF_BIT(, 24)
REGDEF_END(HDMI_PCMHDR1_REG)

REGDEF_OFFSET(HDMI_CTRL_REG, 0x88)
REGDEF_BEGIN(HDMI_CTRL_REG)
REGDEF_BIT(HDMI_MODE, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(PKT_MODE, 3)
REGDEF_BIT(DC_EN, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(NULLPKT_EN, 1)
REGDEF_BIT(NULLPKT_VS_EN, 1)
REGDEF_BIT(GCP_MUTE_STS, 1)
REGDEF_BIT(, 5)
REGDEF_BIT(AUD_FIFO_CNT, 5)
REGDEF_BIT(, 11)
REGDEF_END(HDMI_CTRL_REG)

//REGDEF_OFFSET(HDMI_POWDOWN_REG      ,0x8C)
//REGDEF_BEGIN(HDMI_POWDOWN_REG)
//    REGDEF_BIT(                 ,16)
//    REGDEF_BIT(PD               ,1)
//    REGDEF_BIT(PDOSC            ,1)
//    REGDEF_BIT(                 ,14)
//REGDEF_END(HDMI_POWDOWN_REG)

REGDEF_OFFSET(HDMI_PKTCTRL_REG, 0x90)
REGDEF_BEGIN(HDMI_PKTCTRL_REG)
REGDEF_BIT(AVIINFO_RPT, 1)
REGDEF_BIT(AVIINFO_EN, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(AUDINFO_RPT, 1)
REGDEF_BIT(AUDINFO_EN, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(GENINFO_RPT, 1)
REGDEF_BIT(GENINFO_EN, 1)
REGDEF_BIT(GCP_RPT, 1)
REGDEF_BIT(GCP_EN, 1)
REGDEF_BIT(GEN2INFO_RPT, 1)
REGDEF_BIT(GEN2INFO_EN, 1)
REGDEF_BIT(, 18)
REGDEF_END(HDMI_PKTCTRL_REG)


REGDEF_OFFSET(HDMI_AVIINFO_REG, 0x100)
REGDEF_OFFSET(HDMI_AUDINFO_REG, 0x140)
REGDEF_OFFSET(HDMI_GENINFO_REG, 0x170)
REGDEF_OFFSET(HDMI_GEN2INFO_REG, 0x190)


REGDEF_OFFSET(HDMI_INFO0_REG, 0x00)
REGDEF_BEGIN(HDMI_INFO0_REG)
REGDEF_BIT(TYPE, 8)
REGDEF_BIT(VERS, 8)
REGDEF_BIT(LEN, 8)
REGDEF_BIT(CHSUM, 8)
REGDEF_END(HDMI_INFO0_REG)

REGDEF_OFFSET(HDMI_INFO1_REG, 0x04)
REGDEF_BEGIN(HDMI_INFO1_REG)
REGDEF_BIT(BYTE1, 8)
REGDEF_BIT(BYTE2, 8)
REGDEF_BIT(BYTE3, 8)
REGDEF_BIT(BYTE4, 8)
REGDEF_END(HDMI_INFO1_REG)

REGDEF_OFFSET(HDMI_INFO2_REG, 0x08)
REGDEF_BEGIN(HDMI_INFO2_REG)
REGDEF_BIT(BYTE5, 8)
REGDEF_BIT(BYTE6, 8)
REGDEF_BIT(BYTE7, 8)
REGDEF_BIT(BYTE8, 8)
REGDEF_END(HDMI_INFO2_REG)

REGDEF_OFFSET(HDMI_INFO3_REG, 0x0C)
REGDEF_BEGIN(HDMI_INFO3_REG)
REGDEF_BIT(BYTE9, 8)
REGDEF_BIT(BYTE10, 8)
REGDEF_BIT(BYTE11, 8)
REGDEF_BIT(BYTE12, 8)
REGDEF_END(HDMI_INFO3_REG)

REGDEF_OFFSET(HDMI_INFO4_REG, 0x10)
REGDEF_BEGIN(HDMI_INFO4_REG)
REGDEF_BIT(BYTE13, 8)
REGDEF_BIT(BYTE14, 8)
REGDEF_BIT(BYTE15, 8)
REGDEF_BIT(BYTE16, 8)
REGDEF_END(HDMI_INFO4_REG)

REGDEF_OFFSET(HDMI_INFO5_REG, 0x14)
REGDEF_BEGIN(HDMI_INFO5_REG)
REGDEF_BIT(BYTE17, 8)
REGDEF_BIT(BYTE18, 8)
REGDEF_BIT(BYTE19, 8)
REGDEF_BIT(BYTE20, 8)
REGDEF_END(HDMI_INFO5_REG)

REGDEF_OFFSET(HDMI_INFO6_REG, 0x18)
REGDEF_BEGIN(HDMI_INFO6_REG)
REGDEF_BIT(BYTE21, 8)
REGDEF_BIT(BYTE22, 8)
REGDEF_BIT(BYTE23, 8)
REGDEF_BIT(BYTE24, 8)
REGDEF_END(HDMI_INFO6_REG)

REGDEF_OFFSET(HDMI_INFO7_REG, 0x1C)
REGDEF_BEGIN(HDMI_INFO7_REG)
REGDEF_BIT(BYTE25, 8)
REGDEF_BIT(BYTE26, 8)
REGDEF_BIT(BYTE27, 8)
REGDEF_BIT(, 8)
REGDEF_END(HDMI_INFO7_REG)


REGDEF_OFFSET(HDMI_GENCTRL_REG, 0x1B0)
REGDEF_BEGIN(HDMI_GENCTRL_REG)
REGDEF_BIT(SETAVM, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(CLRAVM, 1)
REGDEF_BIT(, 27)
REGDEF_END(HDMI_GENCTRL_REG)


//
//  Analog Block (IP) Register Bank
//

REGDEF_OFFSET(HDMI_PHYBASE_REG, 0x200)


// TXPHY REG 0x06
/*REGDEF_OFFSET(HDMI_TTXCFG06_REG      ,0x218)
REGDEF_BEGIN(HDMI_TTXCFG06_REG)
    REGDEF_BIT(REG_PDB          ,1)
    REGDEF_BIT(REG_OSCLK_EN     ,1)
    REGDEF_BIT(REG_OE           ,1)
    REGDEF_BIT(REG_NOOSCLKOUT   ,1)
    REGDEF_BIT(REG_HALFCLKEN    ,1)
    REGDEF_BIT(REG_CLKDETECT    ,1)
    REGDEF_BIT(REG_CKSWCTL      ,1)
    REGDEF_BIT(REG_BGR_TEST     ,1)
    REGDEF_BIT(                 ,24)
REGDEF_END(HDMI_TTXCFG06_REG)*/

// TXPHY REG 0x09
/*REGDEF_OFFSET(HDMI_TTXCFG09_REG      ,0x224)
REGDEF_BEGIN(HDMI_TTXCFG09_REG)
    REGDEF_BIT(REG_PDB_M        ,1)
    REGDEF_BIT(REG_OSCLK_EN_M   ,1)
    REGDEF_BIT(REG_OE_M         ,1)
    REGDEF_BIT(REG_NOOSCLKOUT_M ,1)
    REGDEF_BIT(REG_HALFCLKEN_M  ,1)
    REGDEF_BIT(REG_CLKDETECT_M  ,1)
    REGDEF_BIT(REG_CKSWCTL_M    ,1)
    REGDEF_BIT(REG_BGR_TEST_M   ,1)
    REGDEF_BIT(                 ,24)
REGDEF_END(HDMI_TTXCFG09_REG)*/

// TXPHY REG 0x0A
/*REGDEF_OFFSET(HDMI_TTXCFG0A_REG      ,0x228)
REGDEF_BEGIN(HDMI_TTXCFG0A_REG)
    REGDEF_BIT(                 ,3)
    REGDEF_BIT(REG_PD           ,1)
    REGDEF_BIT(                 ,28)
REGDEF_END(HDMI_TTXCFG0A_REG)*/

//REGDEF_OFFSET(HDMI_TTXCFG0D_REG      ,0x230)


// TXPHY REG 0x34
/*REGDEF_OFFSET(HDMI_TTXCFG34_REG      ,0x2D0)
REGDEF_BEGIN(HDMI_TTXCFG34_REG)
    REGDEF_BIT(TRIM_TRIG            ,1)
    REGDEF_BIT(TRIM_DONE_FLAG       ,1)
    REGDEF_BIT(TRIM_ERR_FLAG        ,1)
    REGDEF_BIT(REG_FT_RTRIM_EN      ,1)
    REGDEF_BIT(REG_FT_RTRIM_EXT_EN  ,1)
    REGDEF_BIT(REG_FT_RTRIM_OP_EN   ,1)
    REGDEF_BIT(REG_RESTRIM_EN       ,1)
    REGDEF_BIT(REG_RESTRIM_CLK_EN   ,1)
    REGDEF_BIT(                     ,24)
REGDEF_END(HDMI_TTXCFG34_REG)*/

// TXPHY REG 0x35
/*REGDEF_OFFSET(HDMI_TTXCFG35_REG      ,0x2D4)
REGDEF_BEGIN(HDMI_TTXCFG35_REG)
    REGDEF_BIT(TRIM_RSEL        ,5)
    REGDEF_BIT(TRIM_CMP_OUT     ,1)
    REGDEF_BIT(                 ,26)
REGDEF_END(HDMI_TTXCFG35_REG)*/

// TXPHY REG 0x38
/*REGDEF_OFFSET(HDMI_TTXCFG38_REG      ,0x2E0)
REGDEF_BEGIN(HDMI_TTXCFG38_REG)
    REGDEF_BIT(TRIM_MAN_RSEL_SET,1)
    REGDEF_BIT(TRIM_MAN_RSEL    ,5)
    REGDEF_BIT(                 ,26)
REGDEF_END(HDMI_TTXCFG38_REG)*/




//
//  CEC Register Bank
//

REGDEF_OFFSET(CEC_CTRL_REG, 0x00)
REGDEF_BEGIN(CEC_CTRL_REG)
REGDEF_BIT(EN, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(LOCAL_ADDR, 4)
REGDEF_BIT(, 8)
REGDEF_BIT(FREECNT_1, 4)
REGDEF_BIT(FREECNT_2, 4)
REGDEF_BIT(FREECNT_3, 4)
REGDEF_BIT(TX_RETRY, 4)
REGDEF_END(CEC_CTRL_REG)

REGDEF_OFFSET(CEC_TXTIME0_REG, 0x04)
REGDEF_BEGIN(CEC_TXTIME0_REG)
REGDEF_BIT(TX_RISE_OFS, 8)
REGDEF_BIT(TX_FALL_OFS, 8)
REGDEF_BIT(, 16)
REGDEF_END(CEC_TXTIME0_REG)

REGDEF_OFFSET(CEC_RXTIME0_REG, 0x08)
REGDEF_BEGIN(CEC_RXTIME0_REG)
REGDEF_BIT(RX_START_OFS, 8)
REGDEF_BIT(RX_DATARISE_OFS, 8)
REGDEF_BIT(RX_SMP_OFS, 8)
REGDEF_BIT(DE_GLITCH, 4)
REGDEF_BIT(, 4)
REGDEF_END(CEC_RXTIME0_REG)

REGDEF_OFFSET(CEC_RXTIME1_REG, 0x0C)
REGDEF_BEGIN(CEC_RXTIME1_REG)
REGDEF_BIT(RX_ERR_LOW, 9)
REGDEF_BIT(, 7)
REGDEF_BIT(RX_DATAFALL_OFS, 8)
REGDEF_BIT(, 8)
REGDEF_END(CEC_RXTIME1_REG)

REGDEF_OFFSET(CEC_FRMSIZE_REG, 0x18)
REGDEF_BEGIN(CEC_FRMSIZE_REG)
REGDEF_BIT(RX_LENGTH, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(TX_LENGTH, 4)
REGDEF_BIT(, 4)
REGDEF_BIT(NACK_CTRL, 1)
REGDEF_BIT(, 15)
REGDEF_END(CEC_FRMSIZE_REG)

REGDEF_OFFSET(CEC_TXTRIG_REG, 0x1C)
REGDEF_BEGIN(CEC_TXTRIG_REG)
REGDEF_BIT(TX_TRIG, 1)
REGDEF_BIT(, 11)
REGDEF_BIT(ARBI_RANGE, 4)
REGDEF_BIT(, 16)
REGDEF_END(CEC_TXTRIG_REG)

REGDEF_OFFSET(CEC_TXHDR_REG, 0x20)
REGDEF_BEGIN(CEC_TXHDR_REG)
REGDEF_BIT(TX_DEST_ADDR, 4)
REGDEF_BIT(TX_SRC_ADDR, 4)
REGDEF_BIT(, 24)
REGDEF_END(CEC_TXHDR_REG)


REGDEF_OFFSET(CEC_TXDATA0_REG, 0x24)
REGDEF_OFFSET(CEC_TXDATA1_REG, 0x28)
REGDEF_OFFSET(CEC_TXDATA2_REG, 0x2C)
REGDEF_OFFSET(CEC_TXDATA3_REG, 0x30)


REGDEF_OFFSET(CEC_RXHDR_REG, 0x40)
REGDEF_BEGIN(CEC_RXHDR_REG)
REGDEF_BIT(RX_DEST_ADDR, 4)
REGDEF_BIT(RX_SRC_ADDR, 4)
REGDEF_BIT(, 24)
REGDEF_END(CEC_RXHDR_REG)


REGDEF_OFFSET(CEC_RXDATA0_REG, 0x44)
REGDEF_OFFSET(CEC_RXDATA1_REG, 0x48)
REGDEF_OFFSET(CEC_RXDATA2_REG, 0x4C)
REGDEF_OFFSET(CEC_RXDATA3_REG, 0x50)

        
REGDEF_OFFSET(HDMI_TOP_REG, 0x500)
REGDEF_BEGIN(HDMI_TOP_REG)
REGDEF_BIT(LCD_SRC_SEL, 2)
REGDEF_BIT(, 30)
REGDEF_END(HDMI_TOP_REG)




#define PLL_SYS_CR_REG_OFS              0x10
REGDEF_BEGIN(PLL_SYS_CR_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_SYS_CR_REG)

REGDEF_BEGIN(PLL_PLL2_CR0_REG)
REGDEF_BIT(PLL_RATIO0, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR0_REG)

REGDEF_BEGIN(PLL_PLL2_CR1_REG)
REGDEF_BIT(PLL_RATIO1, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR1_REG)

REGDEF_BEGIN(PLL_PLL2_CR2_REG)
REGDEF_BIT(PLL_RATIO2, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR2_REG)


//@}

#endif
