/**
    NVT clock maxfreq header file
    This file will provide NVT Maxfreq information
    @file       na51090-maxfreq.h
    @ingroup
    @note
    Copyright   Novatek Microelectronics Corp. 2024.  All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/

struct max_freq_node {
	char name[20];
	u32 max_freq[2];
};

static struct max_freq_node nvt_fixed_max_freq[] = {
	{"apb_clk",          {300000000, 300000000}},
	{"2f0110000.wdt",    {12000000, 12000000}},
	{"2f0a50000.rtc",    {32768, 32768}},
	{"2f0850000.dai",    {15360000, 15360000}},
	{"2f0850000.dai2",   {15360000, 15360000}},
	{"2f0850000.dai3",   {15360000, 15360000}},
	{"2f0850000.dai4",   {15360000, 15360000}},
	{"2f0850000.dai5",   {15360000, 15360000}},
	{"2f0330000.hwcp",   {400000000, 400000000}},
	{"2f0320000.jpeg",   {480000000, 480000000}},
	{"2f0a00000.venc",   {420000000, 420000000}},
	{"2f0500000.venc",   {420000000, 420000000}},
	{"h264d_mclk",       {600000000, 600000000}},
	{"h264d_aclk",       {600000000, 600000000}},
	{"h265d_mclk",       {600000000, 600000000}},
	{"h265d_aclk",       {350000000, 350000000}},
	{"2f0300000.osg",    {400000000, 400000000}},
	{"2f0820000.lcd2",   {148500000, 148500000}},
	{"2f0810000.lcd3",   {297000000, 297000000}},
	{"2f0800000.lcd3",   {594000000, 594000000}},
	{"2f0120000.pwm0",   {30000000, 30000000}},
	{"2f0120000.pwm1",   {30000000, 30000000}},
	{"2f0120000.pwm2",   {30000000, 30000000}},
	{"2f0120000.pwm3",   {30000000, 30000000}},
	{"remote_clk",       {3000000, 3000000}},
	{"2f0280000.uart",   {48000000, 48000000}},
	{"2f0290000.uart",   {48000000, 48000000}},
	{"2f02a0000.uart",   {48000000, 48000000}},
	{"2f02b0000.uart",   {48000000, 48000000}},
	{"2f02c0000.uart",   {48000000, 48000000}},
	{"ext0_clk",       	 {27000000, 27000000}},
	{"ext1_clk",         {27000000, 27000000}},
	{"ext2_clk",         {27000000, 27000000}},
	{"ext3_clk",         {27000000, 27000000}},
	{"2f0780000.csi",    {120000000, 120000000}},
	{"2f0790000.csi",    {120000000, 120000000}},
	{"2f07a0000.csi",    {120000000, 120000000}},
	{"2f07b0000.csi",    {120000000, 120000000}},
	{"2f07c0000.csi",    {120000000, 120000000}},
	{"2f07d0000.csi",    {120000000, 120000000}},
	{"2f07e0000.csi",    {120000000, 120000000}},
	{"2f07f0000.csi",    {120000000, 120000000}},
	{"csi_pxclk",        {400000000, 400000000}},
	{"csi2_pxclk",       {400000000, 400000000}},
	{"csi3_pxclk",       {400000000, 400000000}},
	{"csi4_pxclk",       {400000000, 400000000}},
	{"csi5_pxclk",       {400000000, 400000000}},
	{"csi6_pxclk",       {400000000, 400000000}},
	{"csi7_pxclk",       {400000000, 400000000}},
	{"csi8_pxclk",       {400000000, 400000000}},
	{"2f0150000.rng",    {240000000, 240000000}},
	{"2f0150000.rngro",  {480000000, 480000000}},
	{"2f0190000.mmc",    {96000000, 96000000}},
	{"2f01a0000.mmc",    {160000000, 160000000}},
	{"2f0180000.nand",   {120000000, 120000000}},
	{"2f0950000.crypt",  {400000000, 400000000}},
	{"2f0960000.hash",   {400000000, 400000000}},
	{"2f0a80000.rsa",    {400000000, 400000000}},
	{"vcap_mclk",        {450000000, 450000000}},
	{"vcap2_mclk",       {450000000, 450000000}},
	{"vcap_patclk",      {148500000, 148500000}},
	{"vcap2_patclk",     {148500000, 148500000}},
	{"2f0920000.ai",     {600000000, 600000000}},
	{"2f0930000.ai",     {600000000, 600000000}},
	{"2f0900000.ai",     {600000000, 600000000}},
	{"2f0910000.ai",     {600000000, 600000000}},
	{"2f0400000.ai",     {600000000, 600000000}},
	{"2f0940000.ive",    {480000000, 480000000}},
	{"2f0610000.dei",    {400000000, 400000000}},
	{"2f0620000.dei2",   {400000000, 400000000}},
	{"2f0410000.vpe",    {400000000, 400000000}},
	{"2f0420000.vpel",   {400000000, 400000000}},
	{"2f0310000.ssca",   {300000000, 300000000}},
	{"2f03a0000.age",    {300000000, 300000000}},
};
