/**
    NVT clock maxfreq header file
    This file will provide NVT Maxfreq information
    @file       nvt-im-fr-maxfreq.h
    @ingroup
    @note
    Copyright   Novatek Microelectronics Corp. 2019.  All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/
#ifndef __NVT_IM_FR_MAXFREQ_H__
#define __NVT_IM_FR_MAXFREQ_H__

struct max_freq_node {
	char name[20];
	u32 max_freq[2];
};

#ifdef CONFIG_COMMON_CLK_NA51055
static struct max_freq_node nvt_fixed_max_freq[] = {	
	{"f0040000.timer",  {3000000, 3000000}},			
	{"f0050000.wdt",    {12000000, 12000000}},
	{"f00b0000.drtc",   {12000000, 12000000}},	
	{"f0630000.dai",    {30000000, 30000000}},
	{"f0640000.eac",    {30000000, 30000000}},	
	{"f0a00000.jpg",    {360000000, 360000000}},
	{"f0a10000.h26x",   {320000000, 320000000}},	
	{"f0800000.ide",    {150000000, 150000000}},
	{"f0800000.ideif",  {150000000, 150000000}},		
	{"f0840000.dsi",    {960000000, 960000000}},
	{"f0260000.adc",    {30000000, 30000000}},
	{"f02b0000.eth",    {300000000, 300000000}},
	{"f0220000.i2c",    {48000000, 48000000}},
	{"f0350000.i2c2",   {48000000, 48000000}},
	{"f03a0000.i2c3",   {48000000, 48000000}},
	{"pwm_clk.0",       {120000000, 120000000}},
	{"pwm_clk.1",       {120000000, 120000000}},
	{"pwm_clk.2",       {120000000, 120000000}},
	{"pwm_clk.3",       {120000000, 120000000}},
	{"pwm_clk.4",       {120000000, 120000000}},
	{"pwm_clk.5",       {120000000, 120000000}},
	{"pwm_clk.6",       {120000000, 120000000}},
	{"pwm_clk.7",       {120000000, 120000000}},
	{"pwm_clk.8",       {120000000, 120000000}},
	{"pwm_clk.9",       {120000000, 120000000}},
	{"pwm_clk.10",      {120000000, 120000000}},
	{"pwm_clk.11",      {120000000, 120000000}},	
	{"f0250000.remote", {32768, 32768}},
	{"f0240000.sif",    {96000000, 96000000}},
	{"f0230000.spi",    {48000000, 48000000}},
	{"f0320000.spi",    {48000000, 48000000}},
	{"f0340000.spi",    {48000000, 48000000}},
	{"f0290000.uart",   {24000000, 24000000}},
	{"f0300000.uart",   {480000000, 480000000}},
	{"f0310000.uart",   {480000000, 480000000}},
	{"f0280000.csi",    {120000000, 120000000}},
	{"f0330000.csi",    {120000000, 120000000}},	
	{"f0400000.nand",   {120000000, 120000000}},	
	{"f0420000.mmc",    {96000000, 96000000}},
	{"f0500000.mmc",    {96000000, 96000000}},
	{"f0510000.mmc",    {96000000, 96000000}},	
	{"f0620000.crypto", {360000000, 360000000}},
	{"f0650000.tse",    {360000000, 360000000}},
	{"f0700000.hash",   {360000000, 360000000}},	
	{"f06a0000.rsa",    {360000000, 360000000}},
	{"f0680000.rng",    {240000000, 240000000}},
	{"f0680000.rngro",  {480000000, 480000000}},
	{"f0c00000.sie",    {300000000, 300000000}},
	{"f0d20000.sie",    {300000000, 300000000}},
	{"f0d30000.sie",    {300000000, 300000000}},	
	{"f0c00000.siemck", {150000000, 150000000}},
	{"f0c00000.siemk2", {150000000, 150000000}},	
	{"f0cc0000.tge",    {150000000, 150000000}},
	{"f0cc0000.tge2",   {150000000, 150000000}},	
	{"f0c20000.dce",    {280000000, 280000000}},
	{"f0c30000.ipe",    {280000000, 280000000}},
	{"f0c40000.ime",    {280000000, 280000000}},
	{"f0c50000.dis",    {480000000, 480000000}},
	{"f0c60000.ai",     {600000000, 600000000}},
	{"f0d50000.ai",     {480000000, 480000000}},
	{"f0c10000.md",     {240000000, 240000000}},
	{"f0cb0000.ai",     {600000000, 600000000}},
	{"f0d60000.ai",     {600000000, 600000000}},
	{"f0c70000.ife",    {280000000, 280000000}},
	{"f0d00000.ife2",   {280000000, 280000000}},	
	{"f0c80000.grph",   {480000000, 480000000}},
	{"f0d10000.grph",   {480000000, 480000000}},
	{"f0c90000.ise",    {480000000, 480000000}},
};

static struct max_freq_node nvt_fixed_max_freq_528[] = {	
	{"apb_clk",         {120000000, 120000000}},
	{"f0040000.timer",  {3000000, 3000000}},
	{"f0050000.wdt",    {12000000, 12000000}},
	{"f00b0000.drtc",   {12000000, 12000000}},	
	{"f0630000.dai",    {16384000, 16384000}},
	{"f0640000.eac",    {16384000, 16384000}},
	{"f0a00000.jpg",    {480000000, 480000000}},
	{"f0a10000.h26x",   {340000000, 340000000}},
	{"f0800000.ide",    {150000000, 150000000}},
	{"f0800000.ideif",  {150000000, 150000000}},
	{"f0840000.dsi",    {960000000, 960000000}},
	{"f0260000.adc",    {16000000, 16000000}},
	/*{"f02b0000.eth",    {125000000, 125000000}},*/
	{"f0220000.i2c",    {48000000, 48000000}},
	{"f0350000.i2c2",   {48000000, 48000000}},
	{"f03a0000.i2c3",   {48000000, 48000000}},
	{"f03b0000.i2c4",   {48000000, 48000000}},
	{"f03c0000.i2c5",   {48000000, 48000000}},
	{"pwm_clk.0",       {120000000, 120000000}},
	{"pwm_clk.1",       {120000000, 120000000}},
	{"pwm_clk.2",       {120000000, 120000000}},
	{"pwm_clk.3",       {120000000, 120000000}},
	{"pwm_clk.4",       {120000000, 120000000}},
	{"pwm_clk.5",       {120000000, 120000000}},
	{"pwm_clk.6",       {120000000, 120000000}},
	{"pwm_clk.7",       {120000000, 120000000}},
	{"pwm_clk.8",       {120000000, 120000000}},
	{"pwm_clk.9",       {120000000, 120000000}},
	{"pwm_clk.10",      {120000000, 120000000}},
	{"pwm_clk.11",      {120000000, 120000000}},
	{"ccnt_clk.0",      {3000000, 3000000}},
	{"ccnt_clk.1",      {3000000, 3000000}},
	{"ccnt_clk.2",      {3000000, 3000000}},
	{"f0250000.remote", {32768, 32768}},
	{"f0240000.sif",    {96000000, 96000000}},
	{"f0230000.spi",    {48000000, 48000000}},
	{"f0320000.spi",    {48000000, 48000000}},
	{"f0340000.spi",    {48000000, 48000000}},
	{"f0360000.spi",    {48000000, 48000000}},
	{"f03d0000.spi",    {48000000, 48000000}},
	{"f0290000.uart",   {24000000, 24000000}},
	{"f0300000.uart",   {480000000, 480000000}},
	{"f0310000.uart",   {480000000, 480000000}},
	{"f0380000.uart",   {480000000, 480000000}},
	{"f03e0000.uart",   {480000000, 480000000}},
	{"f03f0000.uart",   {480000000, 480000000}},
	{"sp_clk",          {96000000, 96000000}},
	{"f0280000.csi",    {120000000, 120000000}},
	{"f0330000.csi",    {120000000, 120000000}},	
	{"f0400000.nand",   {120000000, 120000000}},	
	{"f0420000.mmc",    {100000000, 100000000}},
	{"f0500000.mmc",    {100000000, 100000000}},
	{"f0510000.mmc",    {100000000, 100000000}},
	{"f0620000.crypto", {360000000, 360000000}},
	{"f0650000.tse",    {360000000, 360000000}},
	{"f0700000.hash",   {360000000, 360000000}},
	{"f06a0000.rsa",    {360000000, 360000000}},
	{"f0680000.rng",    {240000000, 240000000}},
	{"f0680000.rngro",  {480000000, 480000000}},
	{"f0c00000.sie",    {300000000, 300000000}},
	{"f0d20000.sie",    {300000000, 300000000}},
	{"f0d30000.sie",    {300000000, 300000000}},
	{"f0d40000.sie",    {300000000, 300000000}},
	{"f0d80000.sie",    {300000000, 300000000}},
	{"f0c00000.siemck", {150000000, 150000000}},
	{"f0c00000.siemk2", {150000000, 150000000}},
	{"f0c00000.siemk3", {150000000, 150000000}},
	{"f0cc0000.tge",    {150000000, 150000000}},
	{"f0cc0000.tge2",   {150000000, 150000000}},
	{"f0c20000.dce",    {360000000, 360000000}},
	{"f0c30000.ipe",    {360000000, 360000000}},
	{"f0c40000.ime",    {360000000, 360000000}},
	{"f0c50000.dis",    {480000000, 480000000}},
	{"f0c60000.ai",     {600000000, 600000000}},
	{"f0d50000.ai",     {480000000, 480000000}},
	{"f0d90000.sde",    {480000000, 480000000}},
	{"f0cd0000.vpe",    {400000000, 400000000}},
	{"f0c10000.md",     {360000000, 360000000}},
	{"f0d70000.ive",    {480000000, 480000000}},
	{"f0cb0000.ai",     {600000000, 600000000}},
	{"f0d60000.ai",     {600000000, 600000000}},
	{"f0c70000.ife",    {360000000, 360000000}},
	{"f0d00000.ife2",   {360000000, 360000000}},
	{"f0c80000.grph",   {480000000, 480000000}},
	{"f0d10000.grph",   {480000000, 480000000}},
	{"f0ca0000.affine", {480000000, 480000000}},
	{"f0c90000.ise",    {480000000, 480000000}},
};
#endif

#ifdef CONFIG_COMMON_CLK_NA51089
static struct max_freq_node nvt_fixed_max_freq[] = {
	{"apb_clk",         {120000000, 120000000}},
	{"f0040000.timer",  {3000000, 3000000}},
	{"f0050000.wdt",    {12000000, 12000000}},
	{"f00b0000.drtc",   {12000000, 12000000}},
	{"f0630000.dai",    {16384000, 16384000}},
	{"f0640000.eac",    {16384000, 16384000}},
	{"f0a00000.jpg",    {480000000, 480000000}},
	{"f0a10000.h26x",   {320000000, 320000000}},
	{"f0800000.ide",    {300000000, 300000000}},
	{"f0800000.ideif",  {300000000, 300000000}},
	{"f0840000.dsi",    {960000000, 960000000}},
	{"f0260000.adc",    {16000000, 16000000}},
	/*{"f02b0000.eth",    {125000000, 125000000}},*/
	{"f0220000.i2c",    {48000000, 48000000}},
	{"f0350000.i2c2",   {48000000, 48000000}},
	{"f03a0000.i2c3",   {48000000, 48000000}},
	{"pwm_clk.0",       {30000000, 30000000}},
	{"pwm_clk.1",       {30000000, 30000000}},
	{"pwm_clk.2",       {30000000, 30000000}},
	{"pwm_clk.3",       {30000000, 30000000}},
	{"pwm_clk.4",       {30000000, 30000000}},
	{"pwm_clk.5",       {30000000, 30000000}},
	{"pwm_clk.6",       {30000000, 30000000}},
	{"pwm_clk.7",       {30000000, 30000000}},
	{"pwm_clk.8",       {30000000, 30000000}},
	{"pwm_clk.9",       {30000000, 30000000}},
	{"pwm_clk.10",      {30000000, 30000000}},
	{"pwm_clk.11",      {30000000, 30000000}},
	{"ccnt_clk.0",      {3000000, 3000000}},
	{"ccnt_clk.1",      {3000000, 3000000}},
	{"ccnt_clk.2",      {3000000, 3000000}},
	{"f0250000.remote", {3000000, 3000000}},
	{"f0240000.sif",    {48000000, 48000000}},
	{"f0230000.spi",    {48000000, 48000000}},
	{"f0320000.spi",    {48000000, 48000000}},
	{"f0340000.spi",    {48000000, 48000000}},
	{"f0290000.uart",   {24000000, 24000000}},
	{"f0300000.uart",   {480000000, 480000000}},
	{"f0310000.uart",   {480000000, 480000000}},
	{"sp_clk",          {80000000, 80000000}},
	{"sp2_clk",         {80000000, 80000000}},
	{"f0280000.csi",    {120000000, 120000000}},
	{"f0330000.csi",    {120000000, 120000000}},
	{"f0400000.nand",   {120000000, 120000000}},
	{"f0420000.mmc",    {96000000, 96000000}},
	{"f0500000.mmc",    {96000000, 96000000}},
	{"f0510000.mmc",    {96000000, 96000000}},
	{"f0620000.crypto", {320000000, 320000000}},
	{"f0650000.tse",    {320000000, 320000000}},
	{"f0700000.hash",   {320000000, 320000000}},
	{"f06a0000.rsa",    {320000000, 320000000}},
	{"f0680000.rng",    {240000000, 240000000}},
	{"f0680000.rngro",  {480000000, 480000000}},
	{"f0c00000.sie",    {320000000, 320000000}},
	{"f0d20000.sie",    {320000000, 320000000}},
	{"f0d30000.sie",    {320000000, 320000000}},
	{"f0c00000.siemck", {150000000, 150000000}},
	{"f0c00000.siemk2", {150000000, 150000000}},
	{"f0cc0000.tge",    {150000000, 150000000}},
	{"f0cc0000.tge2",   {150000000, 150000000}},
	{"f0c20000.dce",    {240000000, 240000000}},
	{"f0c30000.ipe",    {240000000, 240000000}},
	{"f0c40000.ime",    {240000000, 240000000}},
	{"f0c50000.dis",    {240000000, 240000000}},
	{"f0d50000.ai",     {480000000, 480000000}},
	{"f0c10000.md",     {240000000, 240000000}},
	{"f0d70000.ive",    {480000000, 480000000}},
	{"f0cb0000.ai",     {600000000, 600000000}},
	{"f0c70000.ife",    {240000000, 240000000}},
	{"f0c80000.grph",   {480000000, 480000000}},
	{"f0d10000.grph",   {480000000, 480000000}},
	{"f0c90000.ise",    {480000000, 480000000}},
	{"f0690000.uvcp",   {320000000, 320000000}},
};
#endif
#endif
