/* =========================================================================
 * The Synopsys DWC ETHER QOS Software Driver and documentation (hereinafter
 * "Software") is an unsupported proprietary work of Synopsys, Inc. unless
 * otherwise expressly agreed to in writing between Synopsys and you.
 *
 * The Software IS NOT an item of Licensed Software or Licensed Product under
 * any End User Software License Agreement or Agreement for Licensed Product
 * with Synopsys or any supplement thereto.  Permission is hereby granted,
 * free of charge, to any person obtaining a copy of this software annotated
 * with this license and the Software, to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THIS SOFTWARE IS BEING DISTRIBUTED BY SYNOPSYS SOLELY ON AN "AS IS" BASIS
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE HEREBY DISCLAIMED. IN NO EVENT SHALL SYNOPSYS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * ========================================================================= */

#include <linux/fs.h>
#include <linux/debugfs.h>
#include "DWC_ETH_QOS_yheader.h"

#ifdef CONFIG_DEBUGFS_OBJ

//extern ULONG dwc_eth_qos_pci_base_addr;

#include "DWC_ETH_QOS_yregacc.h"

#define DEBUGFS_MAX_SIZE 100
static char debugfs_buf[DEBUGFS_MAX_SIZE];

//struct DWC_ETH_QOS_prv_data *pdata;

/*
 * This structure hold information about the /debug file
 */
//static struct dentry *dir;

/* Variables used to store the register value. */
//static unsigned int REGISTERS_val;
static unsigned int MAC_MA32_127LR127_val;
static unsigned int MAC_MA32_127LR126_val;
static unsigned int MAC_MA32_127LR125_val;
static unsigned int MAC_MA32_127LR124_val;
static unsigned int MAC_MA32_127LR123_val;
static unsigned int MAC_MA32_127LR122_val;
static unsigned int MAC_MA32_127LR121_val;
static unsigned int MAC_MA32_127LR120_val;
static unsigned int MAC_MA32_127LR119_val;
static unsigned int MAC_MA32_127LR118_val;
static unsigned int MAC_MA32_127LR117_val;
static unsigned int MAC_MA32_127LR116_val;
static unsigned int MAC_MA32_127LR115_val;
static unsigned int MAC_MA32_127LR114_val;
static unsigned int MAC_MA32_127LR113_val;
static unsigned int MAC_MA32_127LR112_val;
static unsigned int MAC_MA32_127LR111_val;
static unsigned int MAC_MA32_127LR110_val;
static unsigned int MAC_MA32_127LR109_val;
static unsigned int MAC_MA32_127LR108_val;
static unsigned int MAC_MA32_127LR107_val;
static unsigned int MAC_MA32_127LR106_val;
static unsigned int MAC_MA32_127LR105_val;
static unsigned int MAC_MA32_127LR104_val;
static unsigned int MAC_MA32_127LR103_val;
static unsigned int MAC_MA32_127LR102_val;
static unsigned int MAC_MA32_127LR101_val;
static unsigned int MAC_MA32_127LR100_val;
static unsigned int MAC_MA32_127LR99_val;
static unsigned int MAC_MA32_127LR98_val;
static unsigned int MAC_MA32_127LR97_val;
static unsigned int MAC_MA32_127LR96_val;
static unsigned int MAC_MA32_127LR95_val;
static unsigned int MAC_MA32_127LR94_val;
static unsigned int MAC_MA32_127LR93_val;
static unsigned int MAC_MA32_127LR92_val;
static unsigned int MAC_MA32_127LR91_val;
static unsigned int MAC_MA32_127LR90_val;
static unsigned int MAC_MA32_127LR89_val;
static unsigned int MAC_MA32_127LR88_val;
static unsigned int MAC_MA32_127LR87_val;
static unsigned int MAC_MA32_127LR86_val;
static unsigned int MAC_MA32_127LR85_val;
static unsigned int MAC_MA32_127LR84_val;
static unsigned int MAC_MA32_127LR83_val;
static unsigned int MAC_MA32_127LR82_val;
static unsigned int MAC_MA32_127LR81_val;
static unsigned int MAC_MA32_127LR80_val;
static unsigned int MAC_MA32_127LR79_val;
static unsigned int MAC_MA32_127LR78_val;
static unsigned int MAC_MA32_127LR77_val;
static unsigned int MAC_MA32_127LR76_val;
static unsigned int MAC_MA32_127LR75_val;
static unsigned int MAC_MA32_127LR74_val;
static unsigned int MAC_MA32_127LR73_val;
static unsigned int MAC_MA32_127LR72_val;
static unsigned int MAC_MA32_127LR71_val;
static unsigned int MAC_MA32_127LR70_val;
static unsigned int MAC_MA32_127LR69_val;
static unsigned int MAC_MA32_127LR68_val;
static unsigned int MAC_MA32_127LR67_val;
static unsigned int MAC_MA32_127LR66_val;
static unsigned int MAC_MA32_127LR65_val;
static unsigned int MAC_MA32_127LR64_val;
static unsigned int MAC_MA32_127LR63_val;
static unsigned int MAC_MA32_127LR62_val;
static unsigned int MAC_MA32_127LR61_val;
static unsigned int MAC_MA32_127LR60_val;
static unsigned int MAC_MA32_127LR59_val;
static unsigned int MAC_MA32_127LR58_val;
static unsigned int MAC_MA32_127LR57_val;
static unsigned int MAC_MA32_127LR56_val;
static unsigned int MAC_MA32_127LR55_val;
static unsigned int MAC_MA32_127LR54_val;
static unsigned int MAC_MA32_127LR53_val;
static unsigned int MAC_MA32_127LR52_val;
static unsigned int MAC_MA32_127LR51_val;
static unsigned int MAC_MA32_127LR50_val;
static unsigned int MAC_MA32_127LR49_val;
static unsigned int MAC_MA32_127LR48_val;
static unsigned int MAC_MA32_127LR47_val;
static unsigned int MAC_MA32_127LR46_val;
static unsigned int MAC_MA32_127LR45_val;
static unsigned int MAC_MA32_127LR44_val;
static unsigned int MAC_MA32_127LR43_val;
static unsigned int MAC_MA32_127LR42_val;
static unsigned int MAC_MA32_127LR41_val;
static unsigned int MAC_MA32_127LR40_val;
static unsigned int MAC_MA32_127LR39_val;
static unsigned int MAC_MA32_127LR38_val;
static unsigned int MAC_MA32_127LR37_val;
static unsigned int MAC_MA32_127LR36_val;
static unsigned int MAC_MA32_127LR35_val;
static unsigned int MAC_MA32_127LR34_val;
static unsigned int MAC_MA32_127LR33_val;
static unsigned int MAC_MA32_127LR32_val;
static unsigned int MAC_MA32_127HR127_val;
static unsigned int MAC_MA32_127HR126_val;
static unsigned int MAC_MA32_127HR125_val;
static unsigned int MAC_MA32_127HR124_val;
static unsigned int MAC_MA32_127HR123_val;
static unsigned int MAC_MA32_127HR122_val;
static unsigned int MAC_MA32_127HR121_val;
static unsigned int MAC_MA32_127HR120_val;
static unsigned int MAC_MA32_127HR119_val;
static unsigned int MAC_MA32_127HR118_val;
static unsigned int MAC_MA32_127HR117_val;
static unsigned int MAC_MA32_127HR116_val;
static unsigned int MAC_MA32_127HR115_val;
static unsigned int MAC_MA32_127HR114_val;
static unsigned int MAC_MA32_127HR113_val;
static unsigned int MAC_MA32_127HR112_val;
static unsigned int MAC_MA32_127HR111_val;
static unsigned int MAC_MA32_127HR110_val;
static unsigned int MAC_MA32_127HR109_val;
static unsigned int MAC_MA32_127HR108_val;
static unsigned int MAC_MA32_127HR107_val;
static unsigned int MAC_MA32_127HR106_val;
static unsigned int MAC_MA32_127HR105_val;
static unsigned int MAC_MA32_127HR104_val;
static unsigned int MAC_MA32_127HR103_val;
static unsigned int MAC_MA32_127HR102_val;
static unsigned int MAC_MA32_127HR101_val;
static unsigned int MAC_MA32_127HR100_val;
static unsigned int MAC_MA32_127HR99_val;
static unsigned int MAC_MA32_127HR98_val;
static unsigned int MAC_MA32_127HR97_val;
static unsigned int MAC_MA32_127HR96_val;
static unsigned int MAC_MA32_127HR95_val;
static unsigned int MAC_MA32_127HR94_val;
static unsigned int MAC_MA32_127HR93_val;
static unsigned int MAC_MA32_127HR92_val;
static unsigned int MAC_MA32_127HR91_val;
static unsigned int MAC_MA32_127HR90_val;
static unsigned int MAC_MA32_127HR89_val;
static unsigned int MAC_MA32_127HR88_val;
static unsigned int MAC_MA32_127HR87_val;
static unsigned int MAC_MA32_127HR86_val;
static unsigned int MAC_MA32_127HR85_val;
static unsigned int MAC_MA32_127HR84_val;
static unsigned int MAC_MA32_127HR83_val;
static unsigned int MAC_MA32_127HR82_val;
static unsigned int MAC_MA32_127HR81_val;
static unsigned int MAC_MA32_127HR80_val;
static unsigned int MAC_MA32_127HR79_val;
static unsigned int MAC_MA32_127HR78_val;
static unsigned int MAC_MA32_127HR77_val;
static unsigned int MAC_MA32_127HR76_val;
static unsigned int MAC_MA32_127HR75_val;
static unsigned int MAC_MA32_127HR74_val;
static unsigned int MAC_MA32_127HR73_val;
static unsigned int MAC_MA32_127HR72_val;
static unsigned int MAC_MA32_127HR71_val;
static unsigned int MAC_MA32_127HR70_val;
static unsigned int MAC_MA32_127HR69_val;
static unsigned int MAC_MA32_127HR68_val;
static unsigned int MAC_MA32_127HR67_val;
static unsigned int MAC_MA32_127HR66_val;
static unsigned int MAC_MA32_127HR65_val;
static unsigned int MAC_MA32_127HR64_val;
static unsigned int MAC_MA32_127HR63_val;
static unsigned int MAC_MA32_127HR62_val;
static unsigned int MAC_MA32_127HR61_val;
static unsigned int MAC_MA32_127HR60_val;
static unsigned int MAC_MA32_127HR59_val;
static unsigned int MAC_MA32_127HR58_val;
static unsigned int MAC_MA32_127HR57_val;
static unsigned int MAC_MA32_127HR56_val;
static unsigned int MAC_MA32_127HR55_val;
static unsigned int MAC_MA32_127HR54_val;
static unsigned int MAC_MA32_127HR53_val;
static unsigned int MAC_MA32_127HR52_val;
static unsigned int MAC_MA32_127HR51_val;
static unsigned int MAC_MA32_127HR50_val;
static unsigned int MAC_MA32_127HR49_val;
static unsigned int MAC_MA32_127HR48_val;
static unsigned int MAC_MA32_127HR47_val;
static unsigned int MAC_MA32_127HR46_val;
static unsigned int MAC_MA32_127HR45_val;
static unsigned int MAC_MA32_127HR44_val;
static unsigned int MAC_MA32_127HR43_val;
static unsigned int MAC_MA32_127HR42_val;
static unsigned int MAC_MA32_127HR41_val;
static unsigned int MAC_MA32_127HR40_val;
static unsigned int MAC_MA32_127HR39_val;
static unsigned int MAC_MA32_127HR38_val;
static unsigned int MAC_MA32_127HR37_val;
static unsigned int MAC_MA32_127HR36_val;
static unsigned int MAC_MA32_127HR35_val;
static unsigned int MAC_MA32_127HR34_val;
static unsigned int MAC_MA32_127HR33_val;
static unsigned int MAC_MA32_127HR32_val;
static unsigned int MAC_MA1_31LR31_val;
static unsigned int MAC_MA1_31LR30_val;
static unsigned int MAC_MA1_31LR29_val;
static unsigned int MAC_MA1_31LR28_val;
static unsigned int MAC_MA1_31LR27_val;
static unsigned int MAC_MA1_31LR26_val;
static unsigned int MAC_MA1_31LR25_val;
static unsigned int MAC_MA1_31LR24_val;
static unsigned int MAC_MA1_31LR23_val;
static unsigned int MAC_MA1_31LR22_val;
static unsigned int MAC_MA1_31LR21_val;
static unsigned int MAC_MA1_31LR20_val;
static unsigned int MAC_MA1_31LR19_val;
static unsigned int MAC_MA1_31LR18_val;
static unsigned int MAC_MA1_31LR17_val;
static unsigned int MAC_MA1_31LR16_val;
static unsigned int MAC_MA1_31LR15_val;
static unsigned int MAC_MA1_31LR14_val;
static unsigned int MAC_MA1_31LR13_val;
static unsigned int MAC_MA1_31LR12_val;
static unsigned int MAC_MA1_31LR11_val;
static unsigned int MAC_MA1_31LR10_val;
static unsigned int MAC_MA1_31LR9_val;
static unsigned int MAC_MA1_31LR8_val;
static unsigned int MAC_MA1_31LR7_val;
static unsigned int MAC_MA1_31LR6_val;
static unsigned int MAC_MA1_31LR5_val;
static unsigned int MAC_MA1_31LR4_val;
static unsigned int MAC_MA1_31LR3_val;
static unsigned int MAC_MA1_31LR2_val;
static unsigned int MAC_MA1_31LR1_val;
static unsigned int MAC_MA1_31HR31_val;
static unsigned int MAC_MA1_31HR30_val;
static unsigned int MAC_MA1_31HR29_val;
static unsigned int MAC_MA1_31HR28_val;
static unsigned int MAC_MA1_31HR27_val;
static unsigned int MAC_MA1_31HR26_val;
static unsigned int MAC_MA1_31HR25_val;
static unsigned int MAC_MA1_31HR24_val;
static unsigned int MAC_MA1_31HR23_val;
static unsigned int MAC_MA1_31HR22_val;
static unsigned int MAC_MA1_31HR21_val;
static unsigned int MAC_MA1_31HR20_val;
static unsigned int MAC_MA1_31HR19_val;
static unsigned int MAC_MA1_31HR18_val;
static unsigned int MAC_MA1_31HR17_val;
static unsigned int MAC_MA1_31HR16_val;
static unsigned int MAC_MA1_31HR15_val;
static unsigned int MAC_MA1_31HR14_val;
static unsigned int MAC_MA1_31HR13_val;
static unsigned int MAC_MA1_31HR12_val;
static unsigned int MAC_MA1_31HR11_val;
static unsigned int MAC_MA1_31HR10_val;
static unsigned int MAC_MA1_31HR9_val;
static unsigned int MAC_MA1_31HR8_val;
static unsigned int MAC_MA1_31HR7_val;
static unsigned int MAC_MA1_31HR6_val;
static unsigned int MAC_MA1_31HR5_val;
static unsigned int MAC_MA1_31HR4_val;
static unsigned int MAC_MA1_31HR3_val;
static unsigned int MAC_MA1_31HR2_val;
static unsigned int MAC_MA1_31HR1_val;
static unsigned int MAC_ARPA_val;
static unsigned int MAC_L3A3R7_val;
static unsigned int MAC_L3A3R6_val;
static unsigned int MAC_L3A3R5_val;
static unsigned int MAC_L3A3R4_val;
static unsigned int MAC_L3A3R3_val;
static unsigned int MAC_L3A3R2_val;
static unsigned int MAC_L3A3R1_val;
static unsigned int MAC_L3A3R0_val;
static unsigned int MAC_L3A2R7_val;
static unsigned int MAC_L3A2R6_val;
static unsigned int MAC_L3A2R5_val;
static unsigned int MAC_L3A2R4_val;
static unsigned int MAC_L3A2R3_val;
static unsigned int MAC_L3A2R2_val;
static unsigned int MAC_L3A2R1_val;
static unsigned int MAC_L3A2R0_val;
static unsigned int MAC_L3A1R7_val;
static unsigned int MAC_L3A1R6_val;
static unsigned int MAC_L3A1R5_val;
static unsigned int MAC_L3A1R4_val;
static unsigned int MAC_L3A1R3_val;
static unsigned int MAC_L3A1R2_val;
static unsigned int MAC_L3A1R1_val;
static unsigned int MAC_L3A1R0_val;
static unsigned int MAC_L3A0R7_val;
static unsigned int MAC_L3A0R6_val;
static unsigned int MAC_L3A0R5_val;
static unsigned int MAC_L3A0R4_val;
static unsigned int MAC_L3A0R3_val;
static unsigned int MAC_L3A0R2_val;
static unsigned int MAC_L3A0R1_val;
static unsigned int MAC_L3A0R0_val;
static unsigned int MAC_L4AR7_val;
static unsigned int MAC_L4AR6_val;
static unsigned int MAC_L4AR5_val;
static unsigned int MAC_L4AR4_val;
static unsigned int MAC_L4AR3_val;
static unsigned int MAC_L4AR2_val;
static unsigned int MAC_L4AR1_val;
static unsigned int MAC_L4AR0_val;
static unsigned int MAC_L3L4CR7_val;
static unsigned int MAC_L3L4CR6_val;
static unsigned int MAC_L3L4CR5_val;
static unsigned int MAC_L3L4CR4_val;
static unsigned int MAC_L3L4CR3_val;
static unsigned int MAC_L3L4CR2_val;
static unsigned int MAC_L3L4CR1_val;
static unsigned int MAC_L3L4CR0_val;
static unsigned int MAC_GPIOS_val;
static unsigned int MAC_PCS_val;
static unsigned int MAC_TES_val;
static unsigned int MAC_AE_val;
static unsigned int MAC_ALPA_val;
static unsigned int MAC_AAD_val;
static unsigned int MAC_ANS_val;
static unsigned int MAC_ANC_val;
static unsigned int MAC_LPC_val;
static unsigned int MAC_LPS_val;
static unsigned int MAC_LMIR_val;
static unsigned int MAC_SPI2R_val;
static unsigned int MAC_SPI1R_val;
static unsigned int MAC_SPI0R_val;
static unsigned int MAC_PTO_CR_val;
static unsigned int MAC_PPS_WIDTH3_val;
static unsigned int MAC_PPS_WIDTH2_val;
static unsigned int MAC_PPS_WIDTH1_val;
static unsigned int MAC_PPS_WIDTH0_val;
static unsigned int MAC_PPS_INTVAL3_val;
static unsigned int MAC_PPS_INTVAL2_val;
static unsigned int MAC_PPS_INTVAL1_val;
static unsigned int MAC_PPS_INTVAL0_val;
static unsigned int MAC_PPS_TTNS3_val;
static unsigned int MAC_PPS_TTNS2_val;
static unsigned int MAC_PPS_TTNS1_val;
static unsigned int MAC_PPS_TTNS0_val;
static unsigned int MAC_PPS_TTS3_val;
static unsigned int MAC_PPS_TTS2_val;
static unsigned int MAC_PPS_TTS1_val;
static unsigned int MAC_PPS_TTS0_val;
static unsigned int MAC_PPSC_val;
static unsigned int MAC_TEAC_val;
static unsigned int MAC_TIAC_val;
static unsigned int MAC_ATS_val;
static unsigned int MAC_ATN_val;
static unsigned int MAC_AC_val;
static unsigned int MAC_TTN_val;
static unsigned int MAC_TTSN_val;
static unsigned int MAC_TSR_val;
static unsigned int MAC_STHWR_val;
static unsigned int MAC_TAR_val;
static unsigned int MAC_STNSUR_val;
static unsigned int MAC_STSUR_val;
static unsigned int MAC_STNSR_val;
static unsigned int MAC_STSR_val;
static unsigned int MAC_SSIR_val;
static unsigned int MAC_TCR_val;
static unsigned int MTL_DSR_val;
static unsigned int MAC_RWPFFR_val;
static unsigned int MAC_RTSR_val;
static unsigned int MTL_IER_val;
static unsigned int MTL_QRCR7_val;
static unsigned int MTL_QRCR6_val;
static unsigned int MTL_QRCR5_val;
static unsigned int MTL_QRCR4_val;
static unsigned int MTL_QRCR3_val;
static unsigned int MTL_QRCR2_val;
static unsigned int MTL_QRCR1_val;
static unsigned int MTL_QRDR7_val;
static unsigned int MTL_QRDR6_val;
static unsigned int MTL_QRDR5_val;
static unsigned int MTL_QRDR4_val;
static unsigned int MTL_QRDR3_val;
static unsigned int MTL_QRDR2_val;
static unsigned int MTL_QRDR1_val;
static unsigned int MTL_QOCR7_val;
static unsigned int MTL_QOCR6_val;
static unsigned int MTL_QOCR5_val;
static unsigned int MTL_QOCR4_val;
static unsigned int MTL_QOCR3_val;
static unsigned int MTL_QOCR2_val;
static unsigned int MTL_QOCR1_val;
static unsigned int MTL_QROMR7_val;
static unsigned int MTL_QROMR6_val;
static unsigned int MTL_QROMR5_val;
static unsigned int MTL_QROMR4_val;
static unsigned int MTL_QROMR3_val;
static unsigned int MTL_QROMR2_val;
static unsigned int MTL_QROMR1_val;
static unsigned int MTL_QLCR7_val;
static unsigned int MTL_QLCR6_val;
static unsigned int MTL_QLCR5_val;
static unsigned int MTL_QLCR4_val;
static unsigned int MTL_QLCR3_val;
static unsigned int MTL_QLCR2_val;
static unsigned int MTL_QLCR1_val;
static unsigned int MTL_QHCR7_val;
static unsigned int MTL_QHCR6_val;
static unsigned int MTL_QHCR5_val;
static unsigned int MTL_QHCR4_val;
static unsigned int MTL_QHCR3_val;
static unsigned int MTL_QHCR2_val;
static unsigned int MTL_QHCR1_val;
static unsigned int MTL_QSSCR7_val;
static unsigned int MTL_QSSCR6_val;
static unsigned int MTL_QSSCR5_val;
static unsigned int MTL_QSSCR4_val;
static unsigned int MTL_QSSCR3_val;
static unsigned int MTL_QSSCR2_val;
static unsigned int MTL_QSSCR1_val;
static unsigned int MTL_QW7_val;
static unsigned int MTL_QW6_val;
static unsigned int MTL_QW5_val;
static unsigned int MTL_QW4_val;
static unsigned int MTL_QW3_val;
static unsigned int MTL_QW2_val;
static unsigned int MTL_QW1_val;
static unsigned int MTL_QESR7_val;
static unsigned int MTL_QESR6_val;
static unsigned int MTL_QESR5_val;
static unsigned int MTL_QESR4_val;
static unsigned int MTL_QESR3_val;
static unsigned int MTL_QESR2_val;
static unsigned int MTL_QESR1_val;
static unsigned int MTL_QECR7_val;
static unsigned int MTL_QECR6_val;
static unsigned int MTL_QECR5_val;
static unsigned int MTL_QECR4_val;
static unsigned int MTL_QECR3_val;
static unsigned int MTL_QECR2_val;
static unsigned int MTL_QECR1_val;
static unsigned int MTL_QTDR7_val;
static unsigned int MTL_QTDR6_val;
static unsigned int MTL_QTDR5_val;
static unsigned int MTL_QTDR4_val;
static unsigned int MTL_QTDR3_val;
static unsigned int MTL_QTDR2_val;
static unsigned int MTL_QTDR1_val;
static unsigned int MTL_QUCR7_val;
static unsigned int MTL_QUCR6_val;
static unsigned int MTL_QUCR5_val;
static unsigned int MTL_QUCR4_val;
static unsigned int MTL_QUCR3_val;
static unsigned int MTL_QUCR2_val;
static unsigned int MTL_QUCR1_val;
static unsigned int MTL_QTOMR7_val;
static unsigned int MTL_QTOMR6_val;
static unsigned int MTL_QTOMR5_val;
static unsigned int MTL_QTOMR4_val;
static unsigned int MTL_QTOMR3_val;
static unsigned int MTL_QTOMR2_val;
static unsigned int MTL_QTOMR1_val;
static unsigned int MAC_PMTCSR_val;
static unsigned int MMC_RXICMP_ERR_OCTETS_val;
static unsigned int MMC_RXICMP_GD_OCTETS_val;
static unsigned int MMC_RXTCP_ERR_OCTETS_val;
static unsigned int MMC_RXTCP_GD_OCTETS_val;
static unsigned int MMC_RXUDP_ERR_OCTETS_val;
static unsigned int MMC_RXUDP_GD_OCTETS_val;
static unsigned int MMC_RXIPV6_NOPAY_OCTETS_val;
static unsigned int MMC_RXIPV6_HDRERR_OCTETS_val;
static unsigned int MMC_RXIPV6_GD_OCTETS_val;
static unsigned int MMC_RXIPV4_UDSBL_OCTETS_val;
static unsigned int MMC_RXIPV4_FRAG_OCTETS_val;
static unsigned int MMC_RXIPV4_NOPAY_OCTETS_val;
static unsigned int MMC_RXIPV4_HDRERR_OCTETS_val;
static unsigned int MMC_RXIPV4_GD_OCTETS_val;
static unsigned int MMC_RXICMP_ERR_PKTS_val;
static unsigned int MMC_RXICMP_GD_PKTS_val;
static unsigned int MMC_RXTCP_ERR_PKTS_val;
static unsigned int MMC_RXTCP_GD_PKTS_val;
static unsigned int MMC_RXUDP_ERR_PKTS_val;
static unsigned int MMC_RXUDP_GD_PKTS_val;
static unsigned int MMC_RXIPV6_NOPAY_PKTS_val;
static unsigned int MMC_RXIPV6_HDRERR_PKTS_val;
static unsigned int MMC_RXIPV6_GD_PKTS_val;
static unsigned int MMC_RXIPV4_UBSBL_PKTS_val;
static unsigned int MMC_RXIPV4_FRAG_PKTS_val;
static unsigned int MMC_RXIPV4_NOPAY_PKTS_val;
static unsigned int MMC_RXIPV4_HDRERR_PKTS_val;
static unsigned int MMC_RXIPV4_GD_PKTS_val;
static unsigned int MMC_RXCTRLPACKETS_G_val;
static unsigned int MMC_RXRCVERROR_val;
static unsigned int MMC_RXWATCHDOGERROR_val;
static unsigned int MMC_RXVLANPACKETS_GB_val;
static unsigned int MMC_RXFIFOOVERFLOW_val;
static unsigned int MMC_RXPAUSEPACKETS_val;
static unsigned int MMC_RXOUTOFRANGETYPE_val;
static unsigned int MMC_RXLENGTHERROR_val;
static unsigned int MMC_RXUNICASTPACKETS_G_val;
static unsigned int MMC_RX1024TOMAXOCTETS_GB_val;
static unsigned int MMC_RX512TO1023OCTETS_GB_val;
static unsigned int MMC_RX256TO511OCTETS_GB_val;
static unsigned int MMC_RX128TO255OCTETS_GB_val;
static unsigned int MMC_RX65TO127OCTETS_GB_val;
static unsigned int MMC_RX64OCTETS_GB_val;
static unsigned int MMC_RXOVERSIZE_G_val;
static unsigned int MMC_RXUNDERSIZE_G_val;
static unsigned int MMC_RXJABBERERROR_val;
static unsigned int MMC_RXRUNTERROR_val;
static unsigned int MMC_RXALIGNMENTERROR_val;
static unsigned int MMC_RXCRCERROR_val;
static unsigned int MMC_RXMULTICASTPACKETS_G_val;
static unsigned int MMC_RXBROADCASTPACKETS_G_val;
static unsigned int MMC_RXOCTETCOUNT_G_val;
static unsigned int MMC_RXOCTETCOUNT_GB_val;
static unsigned int MMC_RXPACKETCOUNT_GB_val;
static unsigned int MMC_TXOVERSIZE_G_val;
static unsigned int MMC_TXVLANPACKETS_G_val;
static unsigned int MMC_TXPAUSEPACKETS_val;
static unsigned int MMC_TXEXCESSDEF_val;
static unsigned int MMC_TXPACKETSCOUNT_G_val;
static unsigned int MMC_TXOCTETCOUNT_G_val;
static unsigned int MMC_TXCARRIERERROR_val;
static unsigned int MMC_TXEXESSCOL_val;
static unsigned int MMC_TXLATECOL_val;
static unsigned int MMC_TXDEFERRED_val;
static unsigned int MMC_TXMULTICOL_G_val;
static unsigned int MMC_TXSINGLECOL_G_val;
static unsigned int MMC_TXUNDERFLOWERROR_val;
static unsigned int MMC_TXBROADCASTPACKETS_GB_val;
static unsigned int MMC_TXMULTICASTPACKETS_GB_val;
static unsigned int MMC_TXUNICASTPACKETS_GB_val;
static unsigned int MMC_TX1024TOMAXOCTETS_GB_val;
static unsigned int MMC_TX512TO1023OCTETS_GB_val;
static unsigned int MMC_TX256TO511OCTETS_GB_val;
static unsigned int MMC_TX128TO255OCTETS_GB_val;
static unsigned int MMC_TX65TO127OCTETS_GB_val;
static unsigned int MMC_TX64OCTETS_GB_val;
static unsigned int MMC_TXMULTICASTPACKETS_G_val;
static unsigned int MMC_TXBROADCASTPACKETS_G_val;
static unsigned int MMC_TXPACKETCOUNT_GB_val;
static unsigned int MMC_TXOCTETCOUNT_GB_val;
static unsigned int MMC_IPC_INTR_RX_val;
static unsigned int MMC_IPC_INTR_MASK_RX_val;
static unsigned int MMC_INTR_MASK_TX_val;
static unsigned int MMC_INTR_MASK_RX_val;
static unsigned int MMC_INTR_TX_val;
static unsigned int MMC_INTR_RX_val;
static unsigned int MMC_CNTRL_val;
static unsigned int MAC_MA1LR_val;
static unsigned int MAC_MA1HR_val;
static unsigned int MAC_MA0LR_val;
static unsigned int MAC_MA0HR_val;
static unsigned int MAC_GPIOR_val;
static unsigned int MAC_GMIIDR_val;
static unsigned int MAC_GMIIAR_val;
static unsigned int MAC_HFR2_val;
static unsigned int MAC_HFR1_val;
static unsigned int MAC_HFR0_val;
static unsigned int MAC_MDR_val;
static unsigned int MAC_VR_val;
static unsigned int MAC_HTR7_val;
static unsigned int MAC_HTR6_val;
static unsigned int MAC_HTR5_val;
static unsigned int MAC_HTR4_val;
static unsigned int MAC_HTR3_val;
static unsigned int MAC_HTR2_val;
static unsigned int MAC_HTR1_val;
static unsigned int MAC_HTR0_val;
static unsigned int DMA_RIWTR7_val;
static unsigned int DMA_RIWTR6_val;
static unsigned int DMA_RIWTR5_val;
static unsigned int DMA_RIWTR4_val;
static unsigned int DMA_RIWTR3_val;
static unsigned int DMA_RIWTR2_val;
static unsigned int DMA_RIWTR1_val;
static unsigned int DMA_RIWTR0_val;
static unsigned int DMA_RDRLR7_val;
static unsigned int DMA_RDRLR6_val;
static unsigned int DMA_RDRLR5_val;
static unsigned int DMA_RDRLR4_val;
static unsigned int DMA_RDRLR3_val;
static unsigned int DMA_RDRLR2_val;
static unsigned int DMA_RDRLR1_val;
static unsigned int DMA_RDRLR0_val;
static unsigned int DMA_TDRLR7_val;
static unsigned int DMA_TDRLR6_val;
static unsigned int DMA_TDRLR5_val;
static unsigned int DMA_TDRLR4_val;
static unsigned int DMA_TDRLR3_val;
static unsigned int DMA_TDRLR2_val;
static unsigned int DMA_TDRLR1_val;
static unsigned int DMA_TDRLR0_val;
static unsigned int DMA_RDTP_RPDR7_val;
static unsigned int DMA_RDTP_RPDR6_val;
static unsigned int DMA_RDTP_RPDR5_val;
static unsigned int DMA_RDTP_RPDR4_val;
static unsigned int DMA_RDTP_RPDR3_val;
static unsigned int DMA_RDTP_RPDR2_val;
static unsigned int DMA_RDTP_RPDR1_val;
static unsigned int DMA_RDTP_RPDR0_val;
static unsigned int DMA_TDTP_TPDR7_val;
static unsigned int DMA_TDTP_TPDR6_val;
static unsigned int DMA_TDTP_TPDR5_val;
static unsigned int DMA_TDTP_TPDR4_val;
static unsigned int DMA_TDTP_TPDR3_val;
static unsigned int DMA_TDTP_TPDR2_val;
static unsigned int DMA_TDTP_TPDR1_val;
static unsigned int DMA_TDTP_TPDR0_val;
static unsigned int DMA_RDLAR7_val;
static unsigned int DMA_RDLAR6_val;
static unsigned int DMA_RDLAR5_val;
static unsigned int DMA_RDLAR4_val;
static unsigned int DMA_RDLAR3_val;
static unsigned int DMA_RDLAR2_val;
static unsigned int DMA_RDLAR1_val;
static unsigned int DMA_RDLAR0_val;
static unsigned int DMA_TDLAR7_val;
static unsigned int DMA_TDLAR6_val;
static unsigned int DMA_TDLAR5_val;
static unsigned int DMA_TDLAR4_val;
static unsigned int DMA_TDLAR3_val;
static unsigned int DMA_TDLAR2_val;
static unsigned int DMA_TDLAR1_val;
static unsigned int DMA_TDLAR0_val;
static unsigned int DMA_IER7_val;
static unsigned int DMA_IER6_val;
static unsigned int DMA_IER5_val;
static unsigned int DMA_IER4_val;
static unsigned int DMA_IER3_val;
static unsigned int DMA_IER2_val;
static unsigned int DMA_IER1_val;
static unsigned int DMA_IER0_val;
static unsigned int MAC_IMR_val;
static unsigned int MAC_ISR_val;
static unsigned int MTL_ISR_val;
static unsigned int DMA_SR7_val;
static unsigned int DMA_SR6_val;
static unsigned int DMA_SR5_val;
static unsigned int DMA_SR4_val;
static unsigned int DMA_SR3_val;
static unsigned int DMA_SR2_val;
static unsigned int DMA_SR1_val;
static unsigned int DMA_SR0_val;
static unsigned int DMA_ISR_val;
static unsigned int DMA_DSR2_val;
static unsigned int DMA_DSR1_val;
static unsigned int DMA_DSR0_val;
static unsigned int MTL_Q0RDR_val;
static unsigned int MTL_Q0ESR_val;
static unsigned int MTL_Q0TDR_val;
static unsigned int DMA_CHRBAR7_val;
static unsigned int DMA_CHRBAR6_val;
static unsigned int DMA_CHRBAR5_val;
static unsigned int DMA_CHRBAR4_val;
static unsigned int DMA_CHRBAR3_val;
static unsigned int DMA_CHRBAR2_val;
static unsigned int DMA_CHRBAR1_val;
static unsigned int DMA_CHRBAR0_val;
static unsigned int DMA_CHTBAR7_val;
static unsigned int DMA_CHTBAR6_val;
static unsigned int DMA_CHTBAR5_val;
static unsigned int DMA_CHTBAR4_val;
static unsigned int DMA_CHTBAR3_val;
static unsigned int DMA_CHTBAR2_val;
static unsigned int DMA_CHTBAR1_val;
static unsigned int DMA_CHTBAR0_val;
static unsigned int DMA_CHRDR7_val;
static unsigned int DMA_CHRDR6_val;
static unsigned int DMA_CHRDR5_val;
static unsigned int DMA_CHRDR4_val;
static unsigned int DMA_CHRDR3_val;
static unsigned int DMA_CHRDR2_val;
static unsigned int DMA_CHRDR1_val;
static unsigned int DMA_CHRDR0_val;
static unsigned int DMA_CHTDR7_val;
static unsigned int DMA_CHTDR6_val;
static unsigned int DMA_CHTDR5_val;
static unsigned int DMA_CHTDR4_val;
static unsigned int DMA_CHTDR3_val;
static unsigned int DMA_CHTDR2_val;
static unsigned int DMA_CHTDR1_val;
static unsigned int DMA_CHTDR0_val;
static unsigned int DMA_SFCSR7_val;
static unsigned int DMA_SFCSR6_val;
static unsigned int DMA_SFCSR5_val;
static unsigned int DMA_SFCSR4_val;
static unsigned int DMA_SFCSR3_val;
static unsigned int DMA_SFCSR2_val;
static unsigned int DMA_SFCSR1_val;
static unsigned int DMA_SFCSR0_val;
static unsigned int MAC_IVLANTIRR_val;
static unsigned int MAC_VLANTIRR_val;
static unsigned int MAC_VLANHTR_val;
static unsigned int MAC_VLANTR_val;
static unsigned int DMA_SBUS_val;
static unsigned int DMA_BMR_val;
static unsigned int MTL_Q0RCR_val;
static unsigned int MTL_Q0OCR_val;
static unsigned int MTL_Q0ROMR_val;
static unsigned int MTL_Q0QR_val;
static unsigned int MTL_Q0ECR_val;
static unsigned int MTL_Q0UCR_val;
static unsigned int MTL_Q0TOMR_val;
static unsigned int MTL_RQDCM1R_val;
static unsigned int MTL_RQDCM0R_val;
static unsigned int MTL_FDDR_val;
static unsigned int MTL_FDACS_val;
static unsigned int MTL_OMR_val;
static unsigned int MAC_RQC3R_val;
static unsigned int MAC_RQC2R_val;
static unsigned int MAC_RQC1R_val;
static unsigned int MAC_RQC0R_val;
static unsigned int MAC_TQPM1R_val;
static unsigned int MAC_TQPM0R_val;
static unsigned int MAC_RFCR_val;
static unsigned int MAC_QTFCR7_val;
static unsigned int MAC_QTFCR6_val;
static unsigned int MAC_QTFCR5_val;
static unsigned int MAC_QTFCR4_val;
static unsigned int MAC_QTFCR3_val;
static unsigned int MAC_QTFCR2_val;
static unsigned int MAC_QTFCR1_val;
static unsigned int MAC_Q0TFCR_val;
static unsigned int DMA_AXI4CR7_val;
static unsigned int DMA_AXI4CR6_val;
static unsigned int DMA_AXI4CR5_val;
static unsigned int DMA_AXI4CR4_val;
static unsigned int DMA_AXI4CR3_val;
static unsigned int DMA_AXI4CR2_val;
static unsigned int DMA_AXI4CR1_val;
static unsigned int DMA_AXI4CR0_val;
static unsigned int DMA_RCR7_val;
static unsigned int DMA_RCR6_val;
static unsigned int DMA_RCR5_val;
static unsigned int DMA_RCR4_val;
static unsigned int DMA_RCR3_val;
static unsigned int DMA_RCR2_val;
static unsigned int DMA_RCR1_val;
static unsigned int DMA_RCR0_val;
static unsigned int DMA_TCR7_val;
static unsigned int DMA_TCR6_val;
static unsigned int DMA_TCR5_val;
static unsigned int DMA_TCR4_val;
static unsigned int DMA_TCR3_val;
static unsigned int DMA_TCR2_val;
static unsigned int DMA_TCR1_val;
static unsigned int DMA_TCR0_val;
static unsigned int DMA_CR7_val;
static unsigned int DMA_CR6_val;
static unsigned int DMA_CR5_val;
static unsigned int DMA_CR4_val;
static unsigned int DMA_CR3_val;
static unsigned int DMA_CR2_val;
static unsigned int DMA_CR1_val;
static unsigned int DMA_CR0_val;
static unsigned int MAC_WTR_val;
static unsigned int MAC_MPFR_val;
static unsigned int MAC_MECR_val;
static unsigned int MAC_MCR_val;

/* For MII/GMII register read/write */
static unsigned int MII_BMCR_REG_val;
static unsigned int MII_BMSR_REG_val;
static unsigned int MII_PHYSID1_REG_val;
static unsigned int MII_PHYSID2_REG_val;
static unsigned int MII_ADVERTISE_REG_val;
static unsigned int MII_LPA_REG_val;
static unsigned int MII_EXPANSION_REG_val;
static unsigned int AUTO_NEGO_NP_REG_val;
static unsigned int MII_ESTATUS_REG_val;
static unsigned int MII_CTRL1000_REG_val;
static unsigned int MII_STAT1000_REG_val;
static unsigned int PHY_CTL_REG_val;
static unsigned int PHY_STS_REG_val;

/* For controlling properties/features of the device */
static unsigned int feature_drop_tx_pktburstcnt_val = 1;

/* for mq */
static unsigned int qInx_val;

#if 0
void DWC_ETH_QOS_get_pdata(struct DWC_ETH_QOS_prv_data *prv_pdata)
{
	pdata = prv_pdata;
}
#endif

/*!
* \brief API extract the reg name from the buffer.
*
* \details This function extracts the register name from the command line
* argument passed to the file belonging to type debugfs.
*
* @param[in]  regname: An empty char pointer.
* @param[in]  buffer: It contains command line input reg name & value.
* @param[in]  buffer_size: buffer size.
*
* \return  void
*/

void get_reg_name(char *regname, char *buffer, unsigned long buffer_size)
{
	int i = 0, j = 0;
	unsigned long cnt = buffer_size;

	DBGPR("--> get_reg_name\n");

	while (cnt > 0) {
		if ((buffer[j] == '\t') || (buffer[j]) == ' ') {
			break;
		} else {
			regname[i] = buffer[j];
			i++;
		}
		j++;
		cnt--;
	}
	regname[i] = '\0';

	DBGPR("<-- get_reg_name\n");
	return;
}

/*!
* \brief API extract the reg value from the buffer.
*
* \details This function extracts the value to be written into the register
* from the command line argument passed to the debug file.
*
* @param[in]  value: An empty char pointer.
* @param[in]  buffer: It contains command line input reg name & value.
* @param[in]  buffer_size: buffer size.
*
* \return  void
*/

void get_reg_value(char *value, char *buffer, unsigned long buffer_size)
{
	int i = 0, j = 0;
	int cnt = buffer_size;
	bool value_present = 0;

	DBGPR("--> get_reg_value\n");

	while (cnt) {
		if ((buffer[j] == ' ') || (buffer[j] == '\t')) {
			value_present = 1;
		}

		if (value_present == 1 && (buffer[j] != ' ')
		    && (buffer[j] != '\t')) {
			value[i] = buffer[j];
			i++;
		}
		j++;
		cnt--;
	}
	value[i] = '\0';

	DBGPR("<-- get_reg_value\n");
	return;
}

/*!
*  \brief  API to write the reg value to specified register.
*
* \details This function extracts the value to be written into the register
* from the command line argument passed to the file belonging to the debugfs.
*
* @param[in]  file: debug file pointer.
* @param[in]  buf: It contains command line input reg name & value.
* @param[in]  count: contains buffer size.
* @param[in]  ppos: offset value.
*
* \retval  0 on Success.
* \retval  error number on Failure.
*/

static ssize_t DWC_ETH_QOS_write(struct file *file, const char __user * buf,
				 size_t count, loff_t * ppos)
{
	int ret = 0;
	char regName[50];
	char regValue[25];
	unsigned long integer_value;
	char *end_ptr;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DBGPR("--> DWC_ETH_QOS_write\n");

	if (count > DEBUGFS_MAX_SIZE)
		return -EINVAL;

	if (copy_from_user(debugfs_buf, buf, count)) {
		ret = -1;
	} else {
		get_reg_name(regName, debugfs_buf, count);
		get_reg_value(regValue, debugfs_buf, count);
		ret = count;

		integer_value = simple_strtoul(regValue, (char **)&end_ptr, 16);
		if ((*end_ptr != '\0') && (*end_ptr != '\n')) {
			printk(KERN_ERR
			       "Invalid value specified for register write");
			return -EINVAL;
		}

		if (!strcmp(regName, "MAC_MA32_127LR127")) {
			MAC_MA32_127LR_RgWr(pdata, 127, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR126")) {
			MAC_MA32_127LR_RgWr(pdata, 126, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR125")) {
			MAC_MA32_127LR_RgWr(pdata, 125, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR124")) {
			MAC_MA32_127LR_RgWr(pdata, 124, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR123")) {
			MAC_MA32_127LR_RgWr(pdata, 123, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR122")) {
			MAC_MA32_127LR_RgWr(pdata, 122, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR121")) {
			MAC_MA32_127LR_RgWr(pdata, 121, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR120")) {
			MAC_MA32_127LR_RgWr(pdata, 120, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR119")) {
			MAC_MA32_127LR_RgWr(pdata, 119, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR118")) {
			MAC_MA32_127LR_RgWr(pdata, 118, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR117")) {
			MAC_MA32_127LR_RgWr(pdata, 117, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR116")) {
			MAC_MA32_127LR_RgWr(pdata, 116, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR115")) {
			MAC_MA32_127LR_RgWr(pdata, 115, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR114")) {
			MAC_MA32_127LR_RgWr(pdata, 114, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR113")) {
			MAC_MA32_127LR_RgWr(pdata, 113, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR112")) {
			MAC_MA32_127LR_RgWr(pdata, 112, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR111")) {
			MAC_MA32_127LR_RgWr(pdata, 111, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR110")) {
			MAC_MA32_127LR_RgWr(pdata, 110, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR109")) {
			MAC_MA32_127LR_RgWr(pdata, 109, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR108")) {
			MAC_MA32_127LR_RgWr(pdata, 108, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR107")) {
			MAC_MA32_127LR_RgWr(pdata, 107, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR106")) {
			MAC_MA32_127LR_RgWr(pdata, 106, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR105")) {
			MAC_MA32_127LR_RgWr(pdata, 105, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR104")) {
			MAC_MA32_127LR_RgWr(pdata, 104, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR103")) {
			MAC_MA32_127LR_RgWr(pdata, 103, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR102")) {
			MAC_MA32_127LR_RgWr(pdata, 102, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR101")) {
			MAC_MA32_127LR_RgWr(pdata, 101, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR100")) {
			MAC_MA32_127LR_RgWr(pdata, 100, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR99")) {
			MAC_MA32_127LR_RgWr(pdata, 99, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR98")) {
			MAC_MA32_127LR_RgWr(pdata, 98, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR97")) {
			MAC_MA32_127LR_RgWr(pdata, 97, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR96")) {
			MAC_MA32_127LR_RgWr(pdata, 96, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR95")) {
			MAC_MA32_127LR_RgWr(pdata, 95, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR94")) {
			MAC_MA32_127LR_RgWr(pdata, 94, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR93")) {
			MAC_MA32_127LR_RgWr(pdata, 93, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR92")) {
			MAC_MA32_127LR_RgWr(pdata, 92, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR91")) {
			MAC_MA32_127LR_RgWr(pdata, 91, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR90")) {
			MAC_MA32_127LR_RgWr(pdata, 90, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR89")) {
			MAC_MA32_127LR_RgWr(pdata, 89, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR88")) {
			MAC_MA32_127LR_RgWr(pdata, 88, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR87")) {
			MAC_MA32_127LR_RgWr(pdata, 87, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR86")) {
			MAC_MA32_127LR_RgWr(pdata, 86, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR85")) {
			MAC_MA32_127LR_RgWr(pdata, 85, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR84")) {
			MAC_MA32_127LR_RgWr(pdata, 84, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR83")) {
			MAC_MA32_127LR_RgWr(pdata, 83, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR82")) {
			MAC_MA32_127LR_RgWr(pdata, 82, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR81")) {
			MAC_MA32_127LR_RgWr(pdata, 81, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR80")) {
			MAC_MA32_127LR_RgWr(pdata, 80, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR79")) {
			MAC_MA32_127LR_RgWr(pdata, 79, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR78")) {
			MAC_MA32_127LR_RgWr(pdata, 78, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR77")) {
			MAC_MA32_127LR_RgWr(pdata, 77, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR76")) {
			MAC_MA32_127LR_RgWr(pdata, 76, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR75")) {
			MAC_MA32_127LR_RgWr(pdata, 75, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR74")) {
			MAC_MA32_127LR_RgWr(pdata, 74, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR73")) {
			MAC_MA32_127LR_RgWr(pdata, 73, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR72")) {
			MAC_MA32_127LR_RgWr(pdata, 72, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR71")) {
			MAC_MA32_127LR_RgWr(pdata, 71, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR70")) {
			MAC_MA32_127LR_RgWr(pdata, 70, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR69")) {
			MAC_MA32_127LR_RgWr(pdata, 69, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR68")) {
			MAC_MA32_127LR_RgWr(pdata, 68, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR67")) {
			MAC_MA32_127LR_RgWr(pdata, 67, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR66")) {
			MAC_MA32_127LR_RgWr(pdata, 66, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR65")) {
			MAC_MA32_127LR_RgWr(pdata, 65, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR64")) {
			MAC_MA32_127LR_RgWr(pdata, 64, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR63")) {
			MAC_MA32_127LR_RgWr(pdata, 63, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR62")) {
			MAC_MA32_127LR_RgWr(pdata, 62, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR61")) {
			MAC_MA32_127LR_RgWr(pdata, 61, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR60")) {
			MAC_MA32_127LR_RgWr(pdata, 60, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR59")) {
			MAC_MA32_127LR_RgWr(pdata, 59, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR58")) {
			MAC_MA32_127LR_RgWr(pdata, 58, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR57")) {
			MAC_MA32_127LR_RgWr(pdata, 57, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR56")) {
			MAC_MA32_127LR_RgWr(pdata, 56, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR55")) {
			MAC_MA32_127LR_RgWr(pdata, 55, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR54")) {
			MAC_MA32_127LR_RgWr(pdata, 54, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR53")) {
			MAC_MA32_127LR_RgWr(pdata, 53, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR52")) {
			MAC_MA32_127LR_RgWr(pdata, 52, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR51")) {
			MAC_MA32_127LR_RgWr(pdata, 51, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR50")) {
			MAC_MA32_127LR_RgWr(pdata, 50, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR49")) {
			MAC_MA32_127LR_RgWr(pdata, 49, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR48")) {
			MAC_MA32_127LR_RgWr(pdata, 48, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR47")) {
			MAC_MA32_127LR_RgWr(pdata, 47, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR46")) {
			MAC_MA32_127LR_RgWr(pdata, 46, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR45")) {
			MAC_MA32_127LR_RgWr(pdata, 45, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR44")) {
			MAC_MA32_127LR_RgWr(pdata, 44, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR43")) {
			MAC_MA32_127LR_RgWr(pdata, 43, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR42")) {
			MAC_MA32_127LR_RgWr(pdata, 42, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR41")) {
			MAC_MA32_127LR_RgWr(pdata, 41, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR40")) {
			MAC_MA32_127LR_RgWr(pdata, 40, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR39")) {
			MAC_MA32_127LR_RgWr(pdata, 39, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR38")) {
			MAC_MA32_127LR_RgWr(pdata, 38, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR37")) {
			MAC_MA32_127LR_RgWr(pdata, 37, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR36")) {
			MAC_MA32_127LR_RgWr(pdata, 36, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR35")) {
			MAC_MA32_127LR_RgWr(pdata, 35, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR34")) {
			MAC_MA32_127LR_RgWr(pdata, 34, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR33")) {
			MAC_MA32_127LR_RgWr(pdata, 33, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127LR32")) {
			MAC_MA32_127LR_RgWr(pdata, 32, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR127")) {
			MAC_MA32_127HR_RgWr(pdata, 127, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR126")) {
			MAC_MA32_127HR_RgWr(pdata, 126, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR125")) {
			MAC_MA32_127HR_RgWr(pdata, 125, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR124")) {
			MAC_MA32_127HR_RgWr(pdata, 124, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR123")) {
			MAC_MA32_127HR_RgWr(pdata, 123, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR122")) {
			MAC_MA32_127HR_RgWr(pdata, 122, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR121")) {
			MAC_MA32_127HR_RgWr(pdata, 121, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR120")) {
			MAC_MA32_127HR_RgWr(pdata, 120, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR119")) {
			MAC_MA32_127HR_RgWr(pdata, 119, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR118")) {
			MAC_MA32_127HR_RgWr(pdata, 118, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR117")) {
			MAC_MA32_127HR_RgWr(pdata, 117, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR116")) {
			MAC_MA32_127HR_RgWr(pdata, 116, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR115")) {
			MAC_MA32_127HR_RgWr(pdata, 115, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR114")) {
			MAC_MA32_127HR_RgWr(pdata, 114, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR113")) {
			MAC_MA32_127HR_RgWr(pdata, 113, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR112")) {
			MAC_MA32_127HR_RgWr(pdata, 112, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR111")) {
			MAC_MA32_127HR_RgWr(pdata, 111, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR110")) {
			MAC_MA32_127HR_RgWr(pdata, 110, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR109")) {
			MAC_MA32_127HR_RgWr(pdata, 109, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR108")) {
			MAC_MA32_127HR_RgWr(pdata, 108, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR107")) {
			MAC_MA32_127HR_RgWr(pdata, 107, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR106")) {
			MAC_MA32_127HR_RgWr(pdata, 106, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR105")) {
			MAC_MA32_127HR_RgWr(pdata, 105, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR104")) {
			MAC_MA32_127HR_RgWr(pdata, 104, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR103")) {
			MAC_MA32_127HR_RgWr(pdata, 103, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR102")) {
			MAC_MA32_127HR_RgWr(pdata, 102, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR101")) {
			MAC_MA32_127HR_RgWr(pdata, 101, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR100")) {
			MAC_MA32_127HR_RgWr(pdata, 100, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR99")) {
			MAC_MA32_127HR_RgWr(pdata, 99, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR98")) {
			MAC_MA32_127HR_RgWr(pdata, 98, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR97")) {
			MAC_MA32_127HR_RgWr(pdata, 97, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR96")) {
			MAC_MA32_127HR_RgWr(pdata, 96, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR95")) {
			MAC_MA32_127HR_RgWr(pdata, 95, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR94")) {
			MAC_MA32_127HR_RgWr(pdata, 94, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR93")) {
			MAC_MA32_127HR_RgWr(pdata, 93, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR92")) {
			MAC_MA32_127HR_RgWr(pdata, 92, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR91")) {
			MAC_MA32_127HR_RgWr(pdata, 91, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR90")) {
			MAC_MA32_127HR_RgWr(pdata, 90, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR89")) {
			MAC_MA32_127HR_RgWr(pdata, 89, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR88")) {
			MAC_MA32_127HR_RgWr(pdata, 88, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR87")) {
			MAC_MA32_127HR_RgWr(pdata, 87, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR86")) {
			MAC_MA32_127HR_RgWr(pdata, 86, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR85")) {
			MAC_MA32_127HR_RgWr(pdata, 85, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR84")) {
			MAC_MA32_127HR_RgWr(pdata, 84, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR83")) {
			MAC_MA32_127HR_RgWr(pdata, 83, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR82")) {
			MAC_MA32_127HR_RgWr(pdata, 82, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR81")) {
			MAC_MA32_127HR_RgWr(pdata, 81, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR80")) {
			MAC_MA32_127HR_RgWr(pdata, 80, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR79")) {
			MAC_MA32_127HR_RgWr(pdata, 79, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR78")) {
			MAC_MA32_127HR_RgWr(pdata, 78, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR77")) {
			MAC_MA32_127HR_RgWr(pdata, 77, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR76")) {
			MAC_MA32_127HR_RgWr(pdata, 76, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR75")) {
			MAC_MA32_127HR_RgWr(pdata, 75, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR74")) {
			MAC_MA32_127HR_RgWr(pdata, 74, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR73")) {
			MAC_MA32_127HR_RgWr(pdata, 73, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR72")) {
			MAC_MA32_127HR_RgWr(pdata, 72, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR71")) {
			MAC_MA32_127HR_RgWr(pdata, 71, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR70")) {
			MAC_MA32_127HR_RgWr(pdata, 70, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR69")) {
			MAC_MA32_127HR_RgWr(pdata, 69, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR68")) {
			MAC_MA32_127HR_RgWr(pdata, 68, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR67")) {
			MAC_MA32_127HR_RgWr(pdata, 67, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR66")) {
			MAC_MA32_127HR_RgWr(pdata, 66, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR65")) {
			MAC_MA32_127HR_RgWr(pdata, 65, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR64")) {
			MAC_MA32_127HR_RgWr(pdata, 64, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR63")) {
			MAC_MA32_127HR_RgWr(pdata, 63, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR62")) {
			MAC_MA32_127HR_RgWr(pdata, 62, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR61")) {
			MAC_MA32_127HR_RgWr(pdata, 61, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR60")) {
			MAC_MA32_127HR_RgWr(pdata, 60, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR59")) {
			MAC_MA32_127HR_RgWr(pdata, 59, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR58")) {
			MAC_MA32_127HR_RgWr(pdata, 58, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR57")) {
			MAC_MA32_127HR_RgWr(pdata, 57, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR56")) {
			MAC_MA32_127HR_RgWr(pdata, 56, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR55")) {
			MAC_MA32_127HR_RgWr(pdata, 55, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR54")) {
			MAC_MA32_127HR_RgWr(pdata, 54, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR53")) {
			MAC_MA32_127HR_RgWr(pdata, 53, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR52")) {
			MAC_MA32_127HR_RgWr(pdata, 52, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR51")) {
			MAC_MA32_127HR_RgWr(pdata, 51, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR50")) {
			MAC_MA32_127HR_RgWr(pdata, 50, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR49")) {
			MAC_MA32_127HR_RgWr(pdata, 49, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR48")) {
			MAC_MA32_127HR_RgWr(pdata, 48, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR47")) {
			MAC_MA32_127HR_RgWr(pdata, 47, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR46")) {
			MAC_MA32_127HR_RgWr(pdata, 46, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR45")) {
			MAC_MA32_127HR_RgWr(pdata, 45, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR44")) {
			MAC_MA32_127HR_RgWr(pdata, 44, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR43")) {
			MAC_MA32_127HR_RgWr(pdata, 43, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR42")) {
			MAC_MA32_127HR_RgWr(pdata, 42, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR41")) {
			MAC_MA32_127HR_RgWr(pdata, 41, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR40")) {
			MAC_MA32_127HR_RgWr(pdata, 40, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR39")) {
			MAC_MA32_127HR_RgWr(pdata, 39, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR38")) {
			MAC_MA32_127HR_RgWr(pdata, 38, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR37")) {
			MAC_MA32_127HR_RgWr(pdata, 37, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR36")) {
			MAC_MA32_127HR_RgWr(pdata, 36, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR35")) {
			MAC_MA32_127HR_RgWr(pdata, 35, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR34")) {
			MAC_MA32_127HR_RgWr(pdata, 34, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR33")) {
			MAC_MA32_127HR_RgWr(pdata, 33, integer_value);
		} else if (!strcmp(regName, "MAC_MA32_127HR32")) {
			MAC_MA32_127HR_RgWr(pdata, 32, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR31")) {
			MAC_MA1_31LR_RgWr(pdata, 31, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR30")) {
			MAC_MA1_31LR_RgWr(pdata, 30, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR29")) {
			MAC_MA1_31LR_RgWr(pdata, 29, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR28")) {
			MAC_MA1_31LR_RgWr(pdata, 28, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR27")) {
			MAC_MA1_31LR_RgWr(pdata, 27, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR26")) {
			MAC_MA1_31LR_RgWr(pdata, 26, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR25")) {
			MAC_MA1_31LR_RgWr(pdata, 25, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR24")) {
			MAC_MA1_31LR_RgWr(pdata, 24, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR23")) {
			MAC_MA1_31LR_RgWr(pdata, 23, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR22")) {
			MAC_MA1_31LR_RgWr(pdata, 22, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR21")) {
			MAC_MA1_31LR_RgWr(pdata, 21, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR20")) {
			MAC_MA1_31LR_RgWr(pdata, 20, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR19")) {
			MAC_MA1_31LR_RgWr(pdata, 19, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR18")) {
			MAC_MA1_31LR_RgWr(pdata, 18, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR17")) {
			MAC_MA1_31LR_RgWr(pdata, 17, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR16")) {
			MAC_MA1_31LR_RgWr(pdata, 16, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR15")) {
			MAC_MA1_31LR_RgWr(pdata, 15, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR14")) {
			MAC_MA1_31LR_RgWr(pdata, 14, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR13")) {
			MAC_MA1_31LR_RgWr(pdata, 13, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR12")) {
			MAC_MA1_31LR_RgWr(pdata, 12, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR11")) {
			MAC_MA1_31LR_RgWr(pdata, 11, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR10")) {
			MAC_MA1_31LR_RgWr(pdata, 10, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR9")) {
			MAC_MA1_31LR_RgWr(pdata, 9, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR8")) {
			MAC_MA1_31LR_RgWr(pdata, 8, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR7")) {
			MAC_MA1_31LR_RgWr(pdata, 7, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR6")) {
			MAC_MA1_31LR_RgWr(pdata, 6, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR5")) {
			MAC_MA1_31LR_RgWr(pdata, 5, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR4")) {
			MAC_MA1_31LR_RgWr(pdata, 4, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR3")) {
			MAC_MA1_31LR_RgWr(pdata, 3, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR2")) {
			MAC_MA1_31LR_RgWr(pdata, 2, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31LR1")) {
			MAC_MA1_31LR_RgWr(pdata, 1, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR31")) {
			MAC_MA1_31HR_RgWr(pdata, 31, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR30")) {
			MAC_MA1_31HR_RgWr(pdata, 30, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR29")) {
			MAC_MA1_31HR_RgWr(pdata, 29, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR28")) {
			MAC_MA1_31HR_RgWr(pdata, 28, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR27")) {
			MAC_MA1_31HR_RgWr(pdata, 27, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR26")) {
			MAC_MA1_31HR_RgWr(pdata, 26, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR25")) {
			MAC_MA1_31HR_RgWr(pdata, 25, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR24")) {
			MAC_MA1_31HR_RgWr(pdata, 24, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR23")) {
			MAC_MA1_31HR_RgWr(pdata, 23, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR22")) {
			MAC_MA1_31HR_RgWr(pdata, 22, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR21")) {
			MAC_MA1_31HR_RgWr(pdata, 21, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR20")) {
			MAC_MA1_31HR_RgWr(pdata, 20, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR19")) {
			MAC_MA1_31HR_RgWr(pdata, 19, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR18")) {
			MAC_MA1_31HR_RgWr(pdata, 18, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR17")) {
			MAC_MA1_31HR_RgWr(pdata, 17, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR16")) {
			MAC_MA1_31HR_RgWr(pdata, 16, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR15")) {
			MAC_MA1_31HR_RgWr(pdata, 15, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR14")) {
			MAC_MA1_31HR_RgWr(pdata, 14, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR13")) {
			MAC_MA1_31HR_RgWr(pdata, 13, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR12")) {
			MAC_MA1_31HR_RgWr(pdata, 12, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR11")) {
			MAC_MA1_31HR_RgWr(pdata, 11, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR10")) {
			MAC_MA1_31HR_RgWr(pdata, 10, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR9")) {
			MAC_MA1_31HR_RgWr(pdata, 9, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR8")) {
			MAC_MA1_31HR_RgWr(pdata, 8, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR7")) {
			MAC_MA1_31HR_RgWr(pdata, 7, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR6")) {
			MAC_MA1_31HR_RgWr(pdata, 6, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR5")) {
			MAC_MA1_31HR_RgWr(pdata, 5, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR4")) {
			MAC_MA1_31HR_RgWr(pdata, 4, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR3")) {
			MAC_MA1_31HR_RgWr(pdata, 3, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR2")) {
			MAC_MA1_31HR_RgWr(pdata, 2, integer_value);
		} else if (!strcmp(regName, "MAC_MA1_31HR1")) {
			MAC_MA1_31HR_RgWr(pdata, 1, integer_value);
		} else if (!strcmp(regName, "MAC_ARPA")) {
			MAC_ARPA_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R7")) {
			MAC_L3A3R7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R6")) {
			MAC_L3A3R6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R5")) {
			MAC_L3A3R5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R4")) {
			MAC_L3A3R4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R3")) {
			MAC_L3A3R3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R2")) {
			MAC_L3A3R2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R1")) {
			MAC_L3A3R1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A3R0")) {
			MAC_L3A3R0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R7")) {
			MAC_L3A2R7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R6")) {
			MAC_L3A2R6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R5")) {
			MAC_L3A2R5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R4")) {
			MAC_L3A2R4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R3")) {
			MAC_L3A2R3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R2")) {
			MAC_L3A2R2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R1")) {
			MAC_L3A2R1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A2R0")) {
			MAC_L3A2R0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R7")) {
			MAC_L3A1R7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R6")) {
			MAC_L3A1R6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R5")) {
			MAC_L3A1R5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R4")) {
			MAC_L3A1R4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R3")) {
			MAC_L3A1R3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R2")) {
			MAC_L3A1R2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R1")) {
			MAC_L3A1R1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A1R0")) {
			MAC_L3A1R0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R7")) {
			MAC_L3A0R7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R6")) {
			MAC_L3A0R6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R5")) {
			MAC_L3A0R5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R4")) {
			MAC_L3A0R4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R3")) {
			MAC_L3A0R3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R2")) {
			MAC_L3A0R2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R1")) {
			MAC_L3A0R1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3A0R0")) {
			MAC_L3A0R0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR7")) {
			MAC_L4AR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR6")) {
			MAC_L4AR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR5")) {
			MAC_L4AR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR4")) {
			MAC_L4AR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR3")) {
			MAC_L4AR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR2")) {
			MAC_L4AR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR1")) {
			MAC_L4AR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L4AR0")) {
			MAC_L4AR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR7")) {
			MAC_L3L4CR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR6")) {
			MAC_L3L4CR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR5")) {
			MAC_L3L4CR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR4")) {
			MAC_L3L4CR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR3")) {
			MAC_L3L4CR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR2")) {
			MAC_L3L4CR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR1")) {
			MAC_L3L4CR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_L3L4CR0")) {
			MAC_L3L4CR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_GPIOS")) {
			MAC_GPIOS_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PCS")) {
			MAC_PCS_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TES")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_TES : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_AE")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_AE : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_ALPA")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_ALPA : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_AAD")) {
			MAC_AAD_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_ANS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_ANS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_ANC")) {
			MAC_ANC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_LPC")) {
			MAC_LPC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_LPS")) {
			MAC_LPS_RgWr(pdata, integer_value);
		} else if(!strcmp(regName,"MAC_LMIR")){
			MAC_LMIR_RgWr(pdata, integer_value);
		} else if(!strcmp(regName,"MAC_SPI2R")){
			MAC_SPI2R_RgWr(pdata, integer_value);
		} else if(!strcmp(regName,"MAC_SPI1R")){
			MAC_SPI1R_RgWr(pdata, integer_value);
		} else if(!strcmp(regName,"MAC_SPI0R")){
			MAC_SPI0R_RgWr(pdata, integer_value);
		} else if(!strcmp(regName,"MAC_PTO_CR")){
			MAC_PTO_CR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_WIDTH3")) {
			MAC_PPS_WIDTH3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_WIDTH2")) {
			MAC_PPS_WIDTH2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_WIDTH1")) {
			MAC_PPS_WIDTH1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_WIDTH0")) {
			MAC_PPS_WIDTH0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_INTVAL3")) {
			MAC_PPS_INTVAL3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_INTVAL2")) {
			MAC_PPS_INTVAL2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_INTVAL1")) {
			MAC_PPS_INTVAL1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_INTVAL0")) {
			MAC_PPS_INTVAL0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTNS3")) {
			MAC_PPS_TTNS3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTNS2")) {
			MAC_PPS_TTNS2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTNS1")) {
			MAC_PPS_TTNS1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTNS0")) {
			MAC_PPS_TTNS0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTS3")) {
			MAC_PPS_TTS3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTS2")) {
			MAC_PPS_TTS2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTS1")) {
			MAC_PPS_TTS1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPS_TTS0")) {
			MAC_PPS_TTS0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PPSC")) {
			MAC_PPSC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TEAC")) {
			MAC_TEAC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TIAC")) {
			MAC_TIAC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_ATS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_ATS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_ATN")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_ATN : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_AC")) {
			MAC_AC_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TTN")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_TTN : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_TTSN")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_TTSN : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_TSR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_TSR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_STHWR")) {
			MAC_STHWR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TAR")) {
			MAC_TAR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_STNSUR")) {
			MAC_STNSUR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_STSUR")) {
			MAC_STSUR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_STNSR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_STNSR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_STSR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_STSR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_SSIR")) {
			MAC_SSIR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TCR")) {
			MAC_TCR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_DSR")) {
			MTL_DSR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RWPFFR")) {
			MAC_RWPFFR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RTSR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_RTSR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_IER")) {
			MTL_IER_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR7")) {
			MTL_QRCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR6")) {
			MTL_QRCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR5")) {
			MTL_QRCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR4")) {
			MTL_QRCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR3")) {
			MTL_QRCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR2")) {
			MTL_QRCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRCR1")) {
			MTL_QRCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QRDR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QRDR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QRDR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QOCR7")) {
			MTL_QOCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR6")) {
			MTL_QOCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR5")) {
			MTL_QOCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR4")) {
			MTL_QOCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR3")) {
			MTL_QOCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR2")) {
			MTL_QOCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QOCR1")) {
			MTL_QOCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR7")) {
			MTL_QROMR_RgWr(pdata, 7, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR6")) {
			MTL_QROMR_RgWr(pdata, 6, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR5")) {
			MTL_QROMR_RgWr(pdata, 5, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR4")) {
			MTL_QROMR_RgWr(pdata, 4, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR3")) {
			MTL_QROMR_RgWr(pdata, 3, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR2")) {
			MTL_QROMR_RgWr(pdata, 2, integer_value);
		} else if (!strcmp(regName, "MTL_QROMR1")) {
			MTL_QROMR_RgWr(pdata, 1, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR7")) {
			MTL_QLCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR6")) {
			MTL_QLCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR5")) {
			MTL_QLCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR4")) {
			MTL_QLCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR3")) {
			MTL_QLCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR2")) {
			MTL_QLCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QLCR1")) {
			MTL_QLCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR7")) {
			MTL_QHCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR6")) {
			MTL_QHCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR5")) {
			MTL_QHCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR4")) {
			MTL_QHCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR3")) {
			MTL_QHCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR2")) {
			MTL_QHCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QHCR1")) {
			MTL_QHCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR7")) {
			MTL_QSSCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR6")) {
			MTL_QSSCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR5")) {
			MTL_QSSCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR4")) {
			MTL_QSSCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR3")) {
			MTL_QSSCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR2")) {
			MTL_QSSCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QSSCR1")) {
			MTL_QSSCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW7")) {
			MTL_QW7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW6")) {
			MTL_QW6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW5")) {
			MTL_QW5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW4")) {
			MTL_QW4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW3")) {
			MTL_QW3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW2")) {
			MTL_QW2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QW1")) {
			MTL_QW1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QESR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QESR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QESR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QECR7")) {
			MTL_QECR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR6")) {
			MTL_QECR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR5")) {
			MTL_QECR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR4")) {
			MTL_QECR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR3")) {
			MTL_QECR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR2")) {
			MTL_QECR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QECR1")) {
			MTL_QECR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTDR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QTDR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_QTDR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_QUCR7")) {
			MTL_QUCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR6")) {
			MTL_QUCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR5")) {
			MTL_QUCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR4")) {
			MTL_QUCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR3")) {
			MTL_QUCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR2")) {
			MTL_QUCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QUCR1")) {
			MTL_QUCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR7")) {
			MTL_QTOMR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR6")) {
			MTL_QTOMR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR5")) {
			MTL_QTOMR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR4")) {
			MTL_QTOMR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR3")) {
			MTL_QTOMR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR2")) {
			MTL_QTOMR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_QTOMR1")) {
			MTL_QTOMR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_PMTCSR")) {
			MAC_PMTCSR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_RXICMP_ERR_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXICMP_ERR_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXICMP_GD_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXICMP_GD_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXTCP_ERR_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXTCP_ERR_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXTCP_GD_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXTCP_GD_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUDP_ERR_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUDP_ERR_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUDP_GD_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUDP_GD_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_NOPAY_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_NOPAY_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_HDRERR_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_HDRERR_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_GD_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_GD_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_UDSBL_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_UDSBL_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_FRAG_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_FRAG_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_NOPAY_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_NOPAY_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_HDRERR_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_HDRERR_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_GD_OCTETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_GD_OCTETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXICMP_ERR_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXICMP_ERR_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXICMP_GD_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXICMP_GD_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXTCP_ERR_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXTCP_ERR_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXTCP_GD_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXTCP_GD_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUDP_ERR_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUDP_ERR_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUDP_GD_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUDP_GD_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_NOPAY_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_NOPAY_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_HDRERR_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_HDRERR_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV6_GD_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV6_GD_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_UBSBL_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_UBSBL_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_FRAG_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_FRAG_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_NOPAY_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_NOPAY_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_HDRERR_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_HDRERR_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXIPV4_GD_PKTS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXIPV4_GD_PKTS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXCTRLPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXCTRLPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXRCVERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXRCVERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXWATCHDOGERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXWATCHDOGERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXVLANPACKETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXVLANPACKETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXFIFOOVERFLOW")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXFIFOOVERFLOW : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXPAUSEPACKETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXPAUSEPACKETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXOUTOFRANGETYPE")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXOUTOFRANGETYPE : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXLENGTHERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXLENGTHERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUNICASTPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUNICASTPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX1024TOMAXOCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX1024TOMAXOCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX512TO1023OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX512TO1023OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX256TO511OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX256TO511OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX128TO255OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX128TO255OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX65TO127OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX65TO127OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RX64OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RX64OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXOVERSIZE_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXOVERSIZE_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXUNDERSIZE_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXUNDERSIZE_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXJABBERERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXJABBERERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXRUNTERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXRUNTERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXALIGNMENTERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXALIGNMENTERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXCRCERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXCRCERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXMULTICASTPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXMULTICASTPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXBROADCASTPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXBROADCASTPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXOCTETCOUNT_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXOCTETCOUNT_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXOCTETCOUNT_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXOCTETCOUNT_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_RXPACKETCOUNT_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_RXPACKETCOUNT_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXOVERSIZE_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXOVERSIZE_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXVLANPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXVLANPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXPAUSEPACKETS")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXPAUSEPACKETS : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXEXCESSDEF")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXEXCESSDEF : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXPACKETSCOUNT_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXPACKETSCOUNT_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXOCTETCOUNT_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXOCTETCOUNT_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXCARRIERERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXCARRIERERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXEXESSCOL")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXEXESSCOL : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXLATECOL")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXLATECOL : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXDEFERRED")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXDEFERRED : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXMULTICOL_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXMULTICOL_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXSINGLECOL_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXSINGLECOL_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXUNDERFLOWERROR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXUNDERFLOWERROR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXBROADCASTPACKETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXBROADCASTPACKETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXMULTICASTPACKETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXMULTICASTPACKETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXUNICASTPACKETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXUNICASTPACKETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX1024TOMAXOCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX1024TOMAXOCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX512TO1023OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX512TO1023OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX256TO511OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX256TO511OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX128TO255OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX128TO255OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX65TO127OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX65TO127OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TX64OCTETS_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TX64OCTETS_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXMULTICASTPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXMULTICASTPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXBROADCASTPACKETS_G")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXBROADCASTPACKETS_G : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXPACKETCOUNT_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXPACKETCOUNT_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_TXOCTETCOUNT_GB")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_TXOCTETCOUNT_GB : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_IPC_INTR_RX")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MMC_IPC_INTR_RX : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MMC_IPC_INTR_MASK_RX")) {
			MMC_IPC_INTR_MASK_RX_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_INTR_MASK_TX")) {
			MMC_INTR_MASK_TX_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_INTR_MASK_RX")) {
			MMC_INTR_MASK_RX_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_INTR_TX")) {
			MMC_INTR_TX_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_INTR_RX")) {
			MMC_INTR_RX_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MMC_CNTRL")) {
			MMC_CNTRL_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MA1LR")) {
			MAC_MA1LR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MA1HR")) {
			MAC_MA1HR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MA0LR")) {
			MAC_MA0LR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MA0HR")) {
			MAC_MA0HR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_GPIOR")) {
			MAC_GPIOR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_GMIIDR")) {
			MAC_GMIIDR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_GMIIAR")) {
			MAC_GMIIAR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HFR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_HFR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_HFR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_HFR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_HFR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_HFR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_MDR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_MDR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_VR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_VR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MAC_HTR7")) {
			MAC_HTR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR6")) {
			MAC_HTR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR5")) {
			MAC_HTR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR4")) {
			MAC_HTR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR3")) {
			MAC_HTR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR2")) {
			MAC_HTR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR1")) {
			MAC_HTR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_HTR0")) {
			MAC_HTR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR7")) {
			DMA_RIWTR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR6")) {
			DMA_RIWTR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR5")) {
			DMA_RIWTR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR4")) {
			DMA_RIWTR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR3")) {
			DMA_RIWTR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR2")) {
			DMA_RIWTR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR1")) {
			DMA_RIWTR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RIWTR0")) {
			DMA_RIWTR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR7")) {
			DMA_RDRLR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR6")) {
			DMA_RDRLR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR5")) {
			DMA_RDRLR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR4")) {
			DMA_RDRLR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR3")) {
			DMA_RDRLR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR2")) {
			DMA_RDRLR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR1")) {
			DMA_RDRLR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDRLR0")) {
			DMA_RDRLR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR7")) {
			DMA_TDRLR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR6")) {
			DMA_TDRLR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR5")) {
			DMA_TDRLR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR4")) {
			DMA_TDRLR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR3")) {
			DMA_TDRLR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR2")) {
			DMA_TDRLR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR1")) {
			DMA_TDRLR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDRLR0")) {
			DMA_TDRLR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR7")) {
			DMA_RDTP_RPDR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR6")) {
			DMA_RDTP_RPDR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR5")) {
			DMA_RDTP_RPDR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR4")) {
			DMA_RDTP_RPDR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR3")) {
			DMA_RDTP_RPDR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR2")) {
			DMA_RDTP_RPDR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR1")) {
			DMA_RDTP_RPDR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDTP_RPDR0")) {
			DMA_RDTP_RPDR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR7")) {
			DMA_TDTP_TPDR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR6")) {
			DMA_TDTP_TPDR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR5")) {
			DMA_TDTP_TPDR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR4")) {
			DMA_TDTP_TPDR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR3")) {
			DMA_TDTP_TPDR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR2")) {
			DMA_TDTP_TPDR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR1")) {
			DMA_TDTP_TPDR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDTP_TPDR0")) {
			DMA_TDTP_TPDR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR7")) {
			DMA_RDLAR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR6")) {
			DMA_RDLAR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR5")) {
			DMA_RDLAR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR4")) {
			DMA_RDLAR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR3")) {
			DMA_RDLAR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR2")) {
			DMA_RDLAR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR1")) {
			DMA_RDLAR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RDLAR0")) {
			DMA_RDLAR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR7")) {
			DMA_TDLAR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR6")) {
			DMA_TDLAR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR5")) {
			DMA_TDLAR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR4")) {
			DMA_TDLAR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR3")) {
			DMA_TDLAR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR2")) {
			DMA_TDLAR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR1")) {
			DMA_TDLAR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TDLAR0")) {
			DMA_TDLAR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_IER7")) {
			DMA_IER_RgWr(pdata, 7, integer_value);
		} else if (!strcmp(regName, "DMA_IER6")) {
			DMA_IER_RgWr(pdata, 6, integer_value);
		} else if (!strcmp(regName, "DMA_IER5")) {
			DMA_IER_RgWr(pdata, 5, integer_value);
		} else if (!strcmp(regName, "DMA_IER4")) {
			DMA_IER_RgWr(pdata, 4, integer_value);
		} else if (!strcmp(regName, "DMA_IER3")) {
			DMA_IER_RgWr(pdata, 3, integer_value);
		} else if (!strcmp(regName, "DMA_IER2")) {
			DMA_IER_RgWr(pdata, 2, integer_value);
		} else if (!strcmp(regName, "DMA_IER1")) {
			DMA_IER_RgWr(pdata, 1, integer_value);
		} else if (!strcmp(regName, "DMA_IER0")) {
			DMA_IER_RgWr(pdata, 0, integer_value);
		} else if (!strcmp(regName, "MAC_IMR")) {
			MAC_IMR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_ISR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MAC_ISR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_ISR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_ISR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_SR7")) {
			DMA_SR_RgWr(pdata, 7, integer_value);
		} else if (!strcmp(regName, "DMA_SR6")) {
			DMA_SR_RgWr(pdata, 6, integer_value);
		} else if (!strcmp(regName, "DMA_SR5")) {
			DMA_SR_RgWr(pdata, 5, integer_value);
		} else if (!strcmp(regName, "DMA_SR4")) {
			DMA_SR_RgWr(pdata, 4, integer_value);
		} else if (!strcmp(regName, "DMA_SR3")) {
			DMA_SR_RgWr(pdata, 3, integer_value);
		} else if (!strcmp(regName, "DMA_SR2")) {
			DMA_SR_RgWr(pdata, 2, integer_value);
		} else if (!strcmp(regName, "DMA_SR1")) {
			DMA_SR_RgWr(pdata, 1, integer_value);
		} else if (!strcmp(regName, "DMA_SR0")) {
			DMA_SR_RgWr(pdata, 0, integer_value);
		} else if (!strcmp(regName, "DMA_ISR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_ISR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_DSR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_DSR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_DSR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_DSR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_DSR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_DSR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_Q0RDR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_Q0RDR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_Q0ESR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_Q0ESR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_Q0TDR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_Q0TDR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRBAR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRBAR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTBAR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTBAR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHRDR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHRDR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR7")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR7 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR6")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR6 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR5")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR5 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR4")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR4 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR3")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR3 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR2")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR2 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR1")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR1 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_CHTDR0")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation DMA_CHTDR0 : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "DMA_SFCSR7")) {
			DMA_SFCSR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR6")) {
			DMA_SFCSR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR5")) {
			DMA_SFCSR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR4")) {
			DMA_SFCSR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR3")) {
			DMA_SFCSR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR2")) {
			DMA_SFCSR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR1")) {
			DMA_SFCSR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SFCSR0")) {
			DMA_SFCSR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_IVLANTIRR")) {
			MAC_IVLANTIRR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_VLANTIRR")) {
			MAC_VLANTIRR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_VLANHTR")) {
			MAC_VLANHTR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_VLANTR")) {
			MAC_VLANTR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_SBUS")) {
			DMA_SBUS_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_BMR")) {
			DMA_BMR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0RCR")) {
			MTL_Q0RCR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0OCR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_Q0OCR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_Q0ROMR")) {
			MTL_Q0ROMR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0QR")) {
			MTL_Q0QR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0ECR")) {
			MTL_Q0ECR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0UCR")) {
			MTL_Q0UCR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_Q0TOMR")) {
			MTL_Q0TOMR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_RQDCM1R")) {
			MTL_RQDCM1R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_RQDCM0R")) {
			MTL_RQDCM0R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_FDDR")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MTL_FDDR : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MTL_FDACS")) {
			MTL_FDACS_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MTL_OMR")) {
			MTL_OMR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RQC3R")) {
			MAC_RQC3R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RQC2R")) {
			MAC_RQC2R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RQC1R")) {
			MAC_RQC1R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RQC0R")) {
			MAC_RQC0R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TQPM1R")) {
			MAC_TQPM1R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_TQPM0R")) {
			MAC_TQPM0R_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_RFCR")) {
			MAC_RFCR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR7")) {
			MAC_QTFCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR6")) {
			MAC_QTFCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR5")) {
			MAC_QTFCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR4")) {
			MAC_QTFCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR3")) {
			MAC_QTFCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR2")) {
			MAC_QTFCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_QTFCR1")) {
			MAC_QTFCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_Q0TFCR")) {
			MAC_Q0TFCR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR7")) {
			DMA_AXI4CR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR6")) {
			DMA_AXI4CR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR5")) {
			DMA_AXI4CR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR4")) {
			DMA_AXI4CR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR3")) {
			DMA_AXI4CR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR2")) {
			DMA_AXI4CR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR1")) {
			DMA_AXI4CR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_AXI4CR0")) {
			DMA_AXI4CR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR7")) {
			DMA_RCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR6")) {
			DMA_RCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR5")) {
			DMA_RCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR4")) {
			DMA_RCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR3")) {
			DMA_RCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR2")) {
			DMA_RCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR1")) {
			DMA_RCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_RCR0")) {
			DMA_RCR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR7")) {
			DMA_TCR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR6")) {
			DMA_TCR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR5")) {
			DMA_TCR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR4")) {
			DMA_TCR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR3")) {
			DMA_TCR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR2")) {
			DMA_TCR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR1")) {
			DMA_TCR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_TCR0")) {
			DMA_TCR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR7")) {
			DMA_CR7_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR6")) {
			DMA_CR6_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR5")) {
			DMA_CR5_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR4")) {
			DMA_CR4_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR3")) {
			DMA_CR3_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR2")) {
			DMA_CR2_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR1")) {
			DMA_CR1_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "DMA_CR0")) {
			DMA_CR0_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_WTR")) {
			MAC_WTR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MPFR")) {
			MAC_MPFR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MECR")) {
			MAC_MECR_RgWr(pdata, integer_value);
		} else if (!strcmp(regName, "MAC_MCR")) {
			MAC_MCR_RgWr(pdata, integer_value);
		}
		/* For MII/GMII register read */
		else if (!strcmp(regName, "MII_BMCR_REG")) {
			DWC_ETH_QOS_mdio_write_direct(pdata,
						      pdata->phyaddr,
						      MII_BMCR,
						      (int)integer_value);
		} else if (!strcmp(regName, "MII_BMSR_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_BMSR_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MII_PHYSID1_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_PHYSID1_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MII_PHYSID2_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_PHYSID2_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MII_ADVERTISE_REG")) {
			DWC_ETH_QOS_mdio_write_direct(pdata,
						      pdata->phyaddr,
						      MII_ADVERTISE,
						      (int)integer_value);
		} else if (!strcmp(regName, "MII_LPA_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_LPA_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MII_EXPANSION_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_EXPANSION_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "AUTO_NEGO_NP_REG")) {
			DWC_ETH_QOS_mdio_write_direct(pdata,
						      pdata->phyaddr,
						      DWC_ETH_QOS_AUTO_NEGO_NP,
						      (int)integer_value);
		} else if (!strcmp(regName, "MII_ESTATUS_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_ESTATUS_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "MII_CTRL1000_REG")) {
			DWC_ETH_QOS_mdio_write_direct(pdata,
						      pdata->phyaddr,
						      MII_CTRL1000,
						      (int)integer_value);
		} else if (!strcmp(regName, "MII_STAT1000_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation MII_STAT1000_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "PHY_CTL_REG")) {
			DWC_ETH_QOS_mdio_write_direct(pdata,
						      pdata->phyaddr,
						      DWC_ETH_QOS_PHY_CTL,
						      (int)integer_value);
		} else if (!strcmp(regName, "PHY_STS_REG")) {
			printk(KERN_ALERT
			       "Could not complete Write Operation PHY_STS_REG : ReadOnly Register");
			ret = -EFAULT;
		} else if (!strcmp(regName, "feature_drop_tx_pktburstcnt")) {
			feature_drop_tx_pktburstcnt_val = (int)integer_value;
			if (feature_drop_tx_pktburstcnt_val == 0) {
				feature_drop_tx_pktburstcnt_val++;
				printk(KERN_ALERT
				       "Drop Tx frame count should be a positive non-zero number only\n");
			}
			pdata->drop_tx_pktburstcnt =
			    feature_drop_tx_pktburstcnt_val;
		} else if (!strcmp(regName, "qInx")) {
			qInx_val = (int)integer_value;
			if (qInx_val != 0
			    && ((qInx_val < 0)
				|| (qInx_val > (DWC_ETH_QOS_QUEUE_CNT - 1)))) {
				qInx_val = 0;
				printk(KERN_ALERT "Invalid queue number\n");
				ret = -EFAULT;
			}
		} else {
			printk(KERN_ALERT
			       "Could not complete Write Operation to Register. Register not found.\n");
			ret = -EFAULT;
		}
	}

	DBGPR("<-- DWC_ETH_QOS_write\n");

	return ret;
}

static ssize_t registers_write(struct file *file, const char __user * buf,
			       size_t count, loff_t * ppos)
{
	DBGPR("--> registers_write\n");
	printk(KERN_INFO
	       "Specify the correct file name for write operation: write error\n");
	DBGPR("<-- registers_write\n");

	return -1;
}

static ssize_t registers_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	char *debug_buf = NULL;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DBGPR("--> registers_read\n");

	printk("%s: base addr 0x%x\r\n", __func__, (int)pdata->dev->base_addr);

	MAC_MA32_127LR_RgRd(pdata, 127, MAC_MA32_127LR127_val);
	MAC_MA32_127LR_RgRd(pdata, 126, MAC_MA32_127LR126_val);
	MAC_MA32_127LR_RgRd(pdata, 125, MAC_MA32_127LR125_val);
	MAC_MA32_127LR_RgRd(pdata, 124, MAC_MA32_127LR124_val);
	MAC_MA32_127LR_RgRd(pdata, 123, MAC_MA32_127LR123_val);
	MAC_MA32_127LR_RgRd(pdata, 122, MAC_MA32_127LR122_val);
	MAC_MA32_127LR_RgRd(pdata, 121, MAC_MA32_127LR121_val);
	MAC_MA32_127LR_RgRd(pdata, 120, MAC_MA32_127LR120_val);
	MAC_MA32_127LR_RgRd(pdata, 119, MAC_MA32_127LR119_val);
	MAC_MA32_127LR_RgRd(pdata, 118, MAC_MA32_127LR118_val);
	MAC_MA32_127LR_RgRd(pdata, 117, MAC_MA32_127LR117_val);
	MAC_MA32_127LR_RgRd(pdata, 116, MAC_MA32_127LR116_val);
	MAC_MA32_127LR_RgRd(pdata, 115, MAC_MA32_127LR115_val);
	MAC_MA32_127LR_RgRd(pdata, 114, MAC_MA32_127LR114_val);
	MAC_MA32_127LR_RgRd(pdata, 113, MAC_MA32_127LR113_val);
	MAC_MA32_127LR_RgRd(pdata, 112, MAC_MA32_127LR112_val);
	MAC_MA32_127LR_RgRd(pdata, 111, MAC_MA32_127LR111_val);
	MAC_MA32_127LR_RgRd(pdata, 110, MAC_MA32_127LR110_val);
	MAC_MA32_127LR_RgRd(pdata, 109, MAC_MA32_127LR109_val);
	MAC_MA32_127LR_RgRd(pdata, 108, MAC_MA32_127LR108_val);
	MAC_MA32_127LR_RgRd(pdata, 107, MAC_MA32_127LR107_val);
	MAC_MA32_127LR_RgRd(pdata, 106, MAC_MA32_127LR106_val);
	MAC_MA32_127LR_RgRd(pdata, 105, MAC_MA32_127LR105_val);
	MAC_MA32_127LR_RgRd(pdata, 104, MAC_MA32_127LR104_val);
	MAC_MA32_127LR_RgRd(pdata, 103, MAC_MA32_127LR103_val);
	MAC_MA32_127LR_RgRd(pdata, 102, MAC_MA32_127LR102_val);
	MAC_MA32_127LR_RgRd(pdata, 101, MAC_MA32_127LR101_val);
	MAC_MA32_127LR_RgRd(pdata, 100, MAC_MA32_127LR100_val);
	MAC_MA32_127LR_RgRd(pdata, 99, MAC_MA32_127LR99_val);
	MAC_MA32_127LR_RgRd(pdata, 98, MAC_MA32_127LR98_val);
	MAC_MA32_127LR_RgRd(pdata, 97, MAC_MA32_127LR97_val);
	MAC_MA32_127LR_RgRd(pdata, 96, MAC_MA32_127LR96_val);
	MAC_MA32_127LR_RgRd(pdata, 95, MAC_MA32_127LR95_val);
	MAC_MA32_127LR_RgRd(pdata, 94, MAC_MA32_127LR94_val);
	MAC_MA32_127LR_RgRd(pdata, 93, MAC_MA32_127LR93_val);
	MAC_MA32_127LR_RgRd(pdata, 92, MAC_MA32_127LR92_val);
	MAC_MA32_127LR_RgRd(pdata, 91, MAC_MA32_127LR91_val);
	MAC_MA32_127LR_RgRd(pdata, 90, MAC_MA32_127LR90_val);
	MAC_MA32_127LR_RgRd(pdata, 89, MAC_MA32_127LR89_val);
	MAC_MA32_127LR_RgRd(pdata, 88, MAC_MA32_127LR88_val);
	MAC_MA32_127LR_RgRd(pdata, 87, MAC_MA32_127LR87_val);
	MAC_MA32_127LR_RgRd(pdata, 86, MAC_MA32_127LR86_val);
	MAC_MA32_127LR_RgRd(pdata, 85, MAC_MA32_127LR85_val);
	MAC_MA32_127LR_RgRd(pdata, 84, MAC_MA32_127LR84_val);
	MAC_MA32_127LR_RgRd(pdata, 83, MAC_MA32_127LR83_val);
	MAC_MA32_127LR_RgRd(pdata, 82, MAC_MA32_127LR82_val);
	MAC_MA32_127LR_RgRd(pdata, 81, MAC_MA32_127LR81_val);
	MAC_MA32_127LR_RgRd(pdata, 80, MAC_MA32_127LR80_val);
	MAC_MA32_127LR_RgRd(pdata, 79, MAC_MA32_127LR79_val);
	MAC_MA32_127LR_RgRd(pdata, 78, MAC_MA32_127LR78_val);
	MAC_MA32_127LR_RgRd(pdata, 77, MAC_MA32_127LR77_val);
	MAC_MA32_127LR_RgRd(pdata, 76, MAC_MA32_127LR76_val);
	MAC_MA32_127LR_RgRd(pdata, 75, MAC_MA32_127LR75_val);
	MAC_MA32_127LR_RgRd(pdata, 74, MAC_MA32_127LR74_val);
	MAC_MA32_127LR_RgRd(pdata, 73, MAC_MA32_127LR73_val);
	MAC_MA32_127LR_RgRd(pdata, 72, MAC_MA32_127LR72_val);
	MAC_MA32_127LR_RgRd(pdata, 71, MAC_MA32_127LR71_val);
	MAC_MA32_127LR_RgRd(pdata, 70, MAC_MA32_127LR70_val);
	MAC_MA32_127LR_RgRd(pdata, 69, MAC_MA32_127LR69_val);
	MAC_MA32_127LR_RgRd(pdata, 68, MAC_MA32_127LR68_val);
	MAC_MA32_127LR_RgRd(pdata, 67, MAC_MA32_127LR67_val);
	MAC_MA32_127LR_RgRd(pdata, 66, MAC_MA32_127LR66_val);
	MAC_MA32_127LR_RgRd(pdata, 65, MAC_MA32_127LR65_val);
	MAC_MA32_127LR_RgRd(pdata, 64, MAC_MA32_127LR64_val);
	MAC_MA32_127LR_RgRd(pdata, 63, MAC_MA32_127LR63_val);
	MAC_MA32_127LR_RgRd(pdata, 62, MAC_MA32_127LR62_val);
	MAC_MA32_127LR_RgRd(pdata, 61, MAC_MA32_127LR61_val);
	MAC_MA32_127LR_RgRd(pdata, 60, MAC_MA32_127LR60_val);
	MAC_MA32_127LR_RgRd(pdata, 59, MAC_MA32_127LR59_val);
	MAC_MA32_127LR_RgRd(pdata, 58, MAC_MA32_127LR58_val);
	MAC_MA32_127LR_RgRd(pdata, 57, MAC_MA32_127LR57_val);
	MAC_MA32_127LR_RgRd(pdata, 56, MAC_MA32_127LR56_val);
	MAC_MA32_127LR_RgRd(pdata, 55, MAC_MA32_127LR55_val);
	MAC_MA32_127LR_RgRd(pdata, 54, MAC_MA32_127LR54_val);
	MAC_MA32_127LR_RgRd(pdata, 53, MAC_MA32_127LR53_val);
	MAC_MA32_127LR_RgRd(pdata, 52, MAC_MA32_127LR52_val);
	MAC_MA32_127LR_RgRd(pdata, 51, MAC_MA32_127LR51_val);
	MAC_MA32_127LR_RgRd(pdata, 50, MAC_MA32_127LR50_val);
	MAC_MA32_127LR_RgRd(pdata, 49, MAC_MA32_127LR49_val);
	MAC_MA32_127LR_RgRd(pdata, 48, MAC_MA32_127LR48_val);
	MAC_MA32_127LR_RgRd(pdata, 47, MAC_MA32_127LR47_val);
	MAC_MA32_127LR_RgRd(pdata, 46, MAC_MA32_127LR46_val);
	MAC_MA32_127LR_RgRd(pdata, 45, MAC_MA32_127LR45_val);
	MAC_MA32_127LR_RgRd(pdata, 44, MAC_MA32_127LR44_val);
	MAC_MA32_127LR_RgRd(pdata, 43, MAC_MA32_127LR43_val);
	MAC_MA32_127LR_RgRd(pdata, 42, MAC_MA32_127LR42_val);
	MAC_MA32_127LR_RgRd(pdata, 41, MAC_MA32_127LR41_val);
	MAC_MA32_127LR_RgRd(pdata, 40, MAC_MA32_127LR40_val);
	MAC_MA32_127LR_RgRd(pdata, 39, MAC_MA32_127LR39_val);
	MAC_MA32_127LR_RgRd(pdata, 38, MAC_MA32_127LR38_val);
	MAC_MA32_127LR_RgRd(pdata, 37, MAC_MA32_127LR37_val);
	MAC_MA32_127LR_RgRd(pdata, 36, MAC_MA32_127LR36_val);
	MAC_MA32_127LR_RgRd(pdata, 35, MAC_MA32_127LR35_val);
	MAC_MA32_127LR_RgRd(pdata, 34, MAC_MA32_127LR34_val);
	MAC_MA32_127LR_RgRd(pdata, 33, MAC_MA32_127LR33_val);
	MAC_MA32_127LR_RgRd(pdata, 32, MAC_MA32_127LR32_val);
	MAC_MA32_127HR_RgRd(pdata, 127, MAC_MA32_127HR127_val);
	MAC_MA32_127HR_RgRd(pdata, 126, MAC_MA32_127HR126_val);
	MAC_MA32_127HR_RgRd(pdata, 125, MAC_MA32_127HR125_val);
	MAC_MA32_127HR_RgRd(pdata, 124, MAC_MA32_127HR124_val);
	MAC_MA32_127HR_RgRd(pdata, 123, MAC_MA32_127HR123_val);
	MAC_MA32_127HR_RgRd(pdata, 122, MAC_MA32_127HR122_val);
	MAC_MA32_127HR_RgRd(pdata, 121, MAC_MA32_127HR121_val);
	MAC_MA32_127HR_RgRd(pdata, 120, MAC_MA32_127HR120_val);
	MAC_MA32_127HR_RgRd(pdata, 119, MAC_MA32_127HR119_val);
	MAC_MA32_127HR_RgRd(pdata, 118, MAC_MA32_127HR118_val);
	MAC_MA32_127HR_RgRd(pdata, 117, MAC_MA32_127HR117_val);
	MAC_MA32_127HR_RgRd(pdata, 116, MAC_MA32_127HR116_val);
	MAC_MA32_127HR_RgRd(pdata, 115, MAC_MA32_127HR115_val);
	MAC_MA32_127HR_RgRd(pdata, 114, MAC_MA32_127HR114_val);
	MAC_MA32_127HR_RgRd(pdata, 113, MAC_MA32_127HR113_val);
	MAC_MA32_127HR_RgRd(pdata, 112, MAC_MA32_127HR112_val);
	MAC_MA32_127HR_RgRd(pdata, 111, MAC_MA32_127HR111_val);
	MAC_MA32_127HR_RgRd(pdata, 110, MAC_MA32_127HR110_val);
	MAC_MA32_127HR_RgRd(pdata, 109, MAC_MA32_127HR109_val);
	MAC_MA32_127HR_RgRd(pdata, 108, MAC_MA32_127HR108_val);
	MAC_MA32_127HR_RgRd(pdata, 107, MAC_MA32_127HR107_val);
	MAC_MA32_127HR_RgRd(pdata, 106, MAC_MA32_127HR106_val);
	MAC_MA32_127HR_RgRd(pdata, 105, MAC_MA32_127HR105_val);
	MAC_MA32_127HR_RgRd(pdata, 104, MAC_MA32_127HR104_val);
	MAC_MA32_127HR_RgRd(pdata, 103, MAC_MA32_127HR103_val);
	MAC_MA32_127HR_RgRd(pdata, 102, MAC_MA32_127HR102_val);
	MAC_MA32_127HR_RgRd(pdata, 101, MAC_MA32_127HR101_val);
	MAC_MA32_127HR_RgRd(pdata, 100, MAC_MA32_127HR100_val);
	MAC_MA32_127HR_RgRd(pdata, 99, MAC_MA32_127HR99_val);
	MAC_MA32_127HR_RgRd(pdata, 98, MAC_MA32_127HR98_val);
	MAC_MA32_127HR_RgRd(pdata, 97, MAC_MA32_127HR97_val);
	MAC_MA32_127HR_RgRd(pdata, 96, MAC_MA32_127HR96_val);
	MAC_MA32_127HR_RgRd(pdata, 95, MAC_MA32_127HR95_val);
	MAC_MA32_127HR_RgRd(pdata, 94, MAC_MA32_127HR94_val);
	MAC_MA32_127HR_RgRd(pdata, 93, MAC_MA32_127HR93_val);
	MAC_MA32_127HR_RgRd(pdata, 92, MAC_MA32_127HR92_val);
	MAC_MA32_127HR_RgRd(pdata, 91, MAC_MA32_127HR91_val);
	MAC_MA32_127HR_RgRd(pdata, 90, MAC_MA32_127HR90_val);
	MAC_MA32_127HR_RgRd(pdata, 89, MAC_MA32_127HR89_val);
	MAC_MA32_127HR_RgRd(pdata, 88, MAC_MA32_127HR88_val);
	MAC_MA32_127HR_RgRd(pdata, 87, MAC_MA32_127HR87_val);
	MAC_MA32_127HR_RgRd(pdata, 86, MAC_MA32_127HR86_val);
	MAC_MA32_127HR_RgRd(pdata, 85, MAC_MA32_127HR85_val);
	MAC_MA32_127HR_RgRd(pdata, 84, MAC_MA32_127HR84_val);
	MAC_MA32_127HR_RgRd(pdata, 83, MAC_MA32_127HR83_val);
	MAC_MA32_127HR_RgRd(pdata, 82, MAC_MA32_127HR82_val);
	MAC_MA32_127HR_RgRd(pdata, 81, MAC_MA32_127HR81_val);
	MAC_MA32_127HR_RgRd(pdata, 80, MAC_MA32_127HR80_val);
	MAC_MA32_127HR_RgRd(pdata, 79, MAC_MA32_127HR79_val);
	MAC_MA32_127HR_RgRd(pdata, 78, MAC_MA32_127HR78_val);
	MAC_MA32_127HR_RgRd(pdata, 77, MAC_MA32_127HR77_val);
	MAC_MA32_127HR_RgRd(pdata, 76, MAC_MA32_127HR76_val);
	MAC_MA32_127HR_RgRd(pdata, 75, MAC_MA32_127HR75_val);
	MAC_MA32_127HR_RgRd(pdata, 74, MAC_MA32_127HR74_val);
	MAC_MA32_127HR_RgRd(pdata, 73, MAC_MA32_127HR73_val);
	MAC_MA32_127HR_RgRd(pdata, 72, MAC_MA32_127HR72_val);
	MAC_MA32_127HR_RgRd(pdata, 71, MAC_MA32_127HR71_val);
	MAC_MA32_127HR_RgRd(pdata, 70, MAC_MA32_127HR70_val);
	MAC_MA32_127HR_RgRd(pdata, 69, MAC_MA32_127HR69_val);
	MAC_MA32_127HR_RgRd(pdata, 68, MAC_MA32_127HR68_val);
	MAC_MA32_127HR_RgRd(pdata, 67, MAC_MA32_127HR67_val);
	MAC_MA32_127HR_RgRd(pdata, 66, MAC_MA32_127HR66_val);
	MAC_MA32_127HR_RgRd(pdata, 65, MAC_MA32_127HR65_val);
	MAC_MA32_127HR_RgRd(pdata, 64, MAC_MA32_127HR64_val);
	MAC_MA32_127HR_RgRd(pdata, 63, MAC_MA32_127HR63_val);
	MAC_MA32_127HR_RgRd(pdata, 62, MAC_MA32_127HR62_val);
	MAC_MA32_127HR_RgRd(pdata, 61, MAC_MA32_127HR61_val);
	MAC_MA32_127HR_RgRd(pdata, 60, MAC_MA32_127HR60_val);
	MAC_MA32_127HR_RgRd(pdata, 59, MAC_MA32_127HR59_val);
	MAC_MA32_127HR_RgRd(pdata, 58, MAC_MA32_127HR58_val);
	MAC_MA32_127HR_RgRd(pdata, 57, MAC_MA32_127HR57_val);
	MAC_MA32_127HR_RgRd(pdata, 56, MAC_MA32_127HR56_val);
	MAC_MA32_127HR_RgRd(pdata, 55, MAC_MA32_127HR55_val);
	MAC_MA32_127HR_RgRd(pdata, 54, MAC_MA32_127HR54_val);
	MAC_MA32_127HR_RgRd(pdata, 53, MAC_MA32_127HR53_val);
	MAC_MA32_127HR_RgRd(pdata, 52, MAC_MA32_127HR52_val);
	MAC_MA32_127HR_RgRd(pdata, 51, MAC_MA32_127HR51_val);
	MAC_MA32_127HR_RgRd(pdata, 50, MAC_MA32_127HR50_val);
	MAC_MA32_127HR_RgRd(pdata, 49, MAC_MA32_127HR49_val);
	MAC_MA32_127HR_RgRd(pdata, 48, MAC_MA32_127HR48_val);
	MAC_MA32_127HR_RgRd(pdata, 47, MAC_MA32_127HR47_val);
	MAC_MA32_127HR_RgRd(pdata, 46, MAC_MA32_127HR46_val);
	MAC_MA32_127HR_RgRd(pdata, 45, MAC_MA32_127HR45_val);
	MAC_MA32_127HR_RgRd(pdata, 44, MAC_MA32_127HR44_val);
	MAC_MA32_127HR_RgRd(pdata, 43, MAC_MA32_127HR43_val);
	MAC_MA32_127HR_RgRd(pdata, 42, MAC_MA32_127HR42_val);
	MAC_MA32_127HR_RgRd(pdata, 41, MAC_MA32_127HR41_val);
	MAC_MA32_127HR_RgRd(pdata, 40, MAC_MA32_127HR40_val);
	MAC_MA32_127HR_RgRd(pdata, 39, MAC_MA32_127HR39_val);
	MAC_MA32_127HR_RgRd(pdata, 38, MAC_MA32_127HR38_val);
	MAC_MA32_127HR_RgRd(pdata, 37, MAC_MA32_127HR37_val);
	MAC_MA32_127HR_RgRd(pdata, 36, MAC_MA32_127HR36_val);
	MAC_MA32_127HR_RgRd(pdata, 35, MAC_MA32_127HR35_val);
	MAC_MA32_127HR_RgRd(pdata, 34, MAC_MA32_127HR34_val);
	MAC_MA32_127HR_RgRd(pdata, 33, MAC_MA32_127HR33_val);
	MAC_MA32_127HR_RgRd(pdata, 32, MAC_MA32_127HR32_val);
	MAC_MA1_31LR_RgRd(pdata, 31, MAC_MA1_31LR31_val);
	MAC_MA1_31LR_RgRd(pdata, 30, MAC_MA1_31LR30_val);
	MAC_MA1_31LR_RgRd(pdata, 29, MAC_MA1_31LR29_val);
	MAC_MA1_31LR_RgRd(pdata, 28, MAC_MA1_31LR28_val);
	MAC_MA1_31LR_RgRd(pdata, 27, MAC_MA1_31LR27_val);
	MAC_MA1_31LR_RgRd(pdata, 26, MAC_MA1_31LR26_val);
	MAC_MA1_31LR_RgRd(pdata, 25, MAC_MA1_31LR25_val);
	MAC_MA1_31LR_RgRd(pdata, 24, MAC_MA1_31LR24_val);
	MAC_MA1_31LR_RgRd(pdata, 23, MAC_MA1_31LR23_val);
	MAC_MA1_31LR_RgRd(pdata, 22, MAC_MA1_31LR22_val);
	MAC_MA1_31LR_RgRd(pdata, 21, MAC_MA1_31LR21_val);
	MAC_MA1_31LR_RgRd(pdata, 20, MAC_MA1_31LR20_val);
	MAC_MA1_31LR_RgRd(pdata, 19, MAC_MA1_31LR19_val);
	MAC_MA1_31LR_RgRd(pdata, 18, MAC_MA1_31LR18_val);
	MAC_MA1_31LR_RgRd(pdata, 17, MAC_MA1_31LR17_val);
	MAC_MA1_31LR_RgRd(pdata, 16, MAC_MA1_31LR16_val);
	MAC_MA1_31LR_RgRd(pdata, 15, MAC_MA1_31LR15_val);
	MAC_MA1_31LR_RgRd(pdata, 14, MAC_MA1_31LR14_val);
	MAC_MA1_31LR_RgRd(pdata, 13, MAC_MA1_31LR13_val);
	MAC_MA1_31LR_RgRd(pdata, 12, MAC_MA1_31LR12_val);
	MAC_MA1_31LR_RgRd(pdata, 11, MAC_MA1_31LR11_val);
	MAC_MA1_31LR_RgRd(pdata, 10, MAC_MA1_31LR10_val);
	MAC_MA1_31LR_RgRd(pdata, 9, MAC_MA1_31LR9_val);
	MAC_MA1_31LR_RgRd(pdata, 8, MAC_MA1_31LR8_val);
	MAC_MA1_31LR_RgRd(pdata, 7, MAC_MA1_31LR7_val);
	MAC_MA1_31LR_RgRd(pdata, 6, MAC_MA1_31LR6_val);
	MAC_MA1_31LR_RgRd(pdata, 5, MAC_MA1_31LR5_val);
	MAC_MA1_31LR_RgRd(pdata, 4, MAC_MA1_31LR4_val);
	MAC_MA1_31LR_RgRd(pdata, 3, MAC_MA1_31LR3_val);
	MAC_MA1_31LR_RgRd(pdata, 2, MAC_MA1_31LR2_val);
	MAC_MA1_31LR_RgRd(pdata, 1, MAC_MA1_31LR1_val);
	MAC_MA1_31HR_RgRd(pdata, 31, MAC_MA1_31HR31_val);
	MAC_MA1_31HR_RgRd(pdata, 30, MAC_MA1_31HR30_val);
	MAC_MA1_31HR_RgRd(pdata, 29, MAC_MA1_31HR29_val);
	MAC_MA1_31HR_RgRd(pdata, 28, MAC_MA1_31HR28_val);
	MAC_MA1_31HR_RgRd(pdata, 27, MAC_MA1_31HR27_val);
	MAC_MA1_31HR_RgRd(pdata, 26, MAC_MA1_31HR26_val);
	MAC_MA1_31HR_RgRd(pdata, 25, MAC_MA1_31HR25_val);
	MAC_MA1_31HR_RgRd(pdata, 24, MAC_MA1_31HR24_val);
	MAC_MA1_31HR_RgRd(pdata, 23, MAC_MA1_31HR23_val);
	MAC_MA1_31HR_RgRd(pdata, 22, MAC_MA1_31HR22_val);
	MAC_MA1_31HR_RgRd(pdata, 21, MAC_MA1_31HR21_val);
	MAC_MA1_31HR_RgRd(pdata, 20, MAC_MA1_31HR20_val);
	MAC_MA1_31HR_RgRd(pdata, 19, MAC_MA1_31HR19_val);
	MAC_MA1_31HR_RgRd(pdata, 18, MAC_MA1_31HR18_val);
	MAC_MA1_31HR_RgRd(pdata, 17, MAC_MA1_31HR17_val);
	MAC_MA1_31HR_RgRd(pdata, 16, MAC_MA1_31HR16_val);
	MAC_MA1_31HR_RgRd(pdata, 15, MAC_MA1_31HR15_val);
	MAC_MA1_31HR_RgRd(pdata, 14, MAC_MA1_31HR14_val);
	MAC_MA1_31HR_RgRd(pdata, 13, MAC_MA1_31HR13_val);
	MAC_MA1_31HR_RgRd(pdata, 12, MAC_MA1_31HR12_val);
	MAC_MA1_31HR_RgRd(pdata, 11, MAC_MA1_31HR11_val);
	MAC_MA1_31HR_RgRd(pdata, 10, MAC_MA1_31HR10_val);
	MAC_MA1_31HR_RgRd(pdata, 9, MAC_MA1_31HR9_val);
	MAC_MA1_31HR_RgRd(pdata, 8, MAC_MA1_31HR8_val);
	MAC_MA1_31HR_RgRd(pdata, 7, MAC_MA1_31HR7_val);
	MAC_MA1_31HR_RgRd(pdata, 6, MAC_MA1_31HR6_val);
	MAC_MA1_31HR_RgRd(pdata, 5, MAC_MA1_31HR5_val);
	MAC_MA1_31HR_RgRd(pdata, 4, MAC_MA1_31HR4_val);
	MAC_MA1_31HR_RgRd(pdata, 3, MAC_MA1_31HR3_val);
	MAC_MA1_31HR_RgRd(pdata, 2, MAC_MA1_31HR2_val);
	MAC_MA1_31HR_RgRd(pdata, 1, MAC_MA1_31HR1_val);
	MAC_ARPA_RgRd(pdata, MAC_ARPA_val);
	MAC_L3A3R7_RgRd(pdata, MAC_L3A3R7_val);
	MAC_L3A3R6_RgRd(pdata, MAC_L3A3R6_val);
	MAC_L3A3R5_RgRd(pdata, MAC_L3A3R5_val);
	MAC_L3A3R4_RgRd(pdata, MAC_L3A3R4_val);
	MAC_L3A3R3_RgRd(pdata, MAC_L3A3R3_val);
	MAC_L3A3R2_RgRd(pdata, MAC_L3A3R2_val);
	MAC_L3A3R1_RgRd(pdata, MAC_L3A3R1_val);
	MAC_L3A3R0_RgRd(pdata, MAC_L3A3R0_val);
	MAC_L3A2R7_RgRd(pdata, MAC_L3A2R7_val);
	MAC_L3A2R6_RgRd(pdata, MAC_L3A2R6_val);
	MAC_L3A2R5_RgRd(pdata, MAC_L3A2R5_val);
	MAC_L3A2R4_RgRd(pdata, MAC_L3A2R4_val);
	MAC_L3A2R3_RgRd(pdata, MAC_L3A2R3_val);
	MAC_L3A2R2_RgRd(pdata, MAC_L3A2R2_val);
	MAC_L3A2R1_RgRd(pdata, MAC_L3A2R1_val);
	MAC_L3A2R0_RgRd(pdata, MAC_L3A2R0_val);
	MAC_L3A1R7_RgRd(pdata, MAC_L3A1R7_val);
	MAC_L3A1R6_RgRd(pdata, MAC_L3A1R6_val);
	MAC_L3A1R5_RgRd(pdata, MAC_L3A1R5_val);
	MAC_L3A1R4_RgRd(pdata, MAC_L3A1R4_val);
	MAC_L3A1R3_RgRd(pdata, MAC_L3A1R3_val);
	MAC_L3A1R2_RgRd(pdata, MAC_L3A1R2_val);
	MAC_L3A1R1_RgRd(pdata, MAC_L3A1R1_val);
	MAC_L3A1R0_RgRd(pdata, MAC_L3A1R0_val);
	MAC_L3A0R7_RgRd(pdata, MAC_L3A0R7_val);
	MAC_L3A0R6_RgRd(pdata, MAC_L3A0R6_val);
	MAC_L3A0R5_RgRd(pdata, MAC_L3A0R5_val);
	MAC_L3A0R4_RgRd(pdata, MAC_L3A0R4_val);
	MAC_L3A0R3_RgRd(pdata, MAC_L3A0R3_val);
	MAC_L3A0R2_RgRd(pdata, MAC_L3A0R2_val);
	MAC_L3A0R1_RgRd(pdata, MAC_L3A0R1_val);
	MAC_L3A0R0_RgRd(pdata, MAC_L3A0R0_val);
	MAC_L4AR7_RgRd(pdata, MAC_L4AR7_val);
	MAC_L4AR6_RgRd(pdata, MAC_L4AR6_val);
	MAC_L4AR5_RgRd(pdata, MAC_L4AR5_val);
	MAC_L4AR4_RgRd(pdata, MAC_L4AR4_val);
	MAC_L4AR3_RgRd(pdata, MAC_L4AR3_val);
	MAC_L4AR2_RgRd(pdata, MAC_L4AR2_val);
	MAC_L4AR1_RgRd(pdata, MAC_L4AR1_val);
	MAC_L4AR0_RgRd(pdata, MAC_L4AR0_val);
	MAC_L3L4CR7_RgRd(pdata, MAC_L3L4CR7_val);
	MAC_L3L4CR6_RgRd(pdata, MAC_L3L4CR6_val);
	MAC_L3L4CR5_RgRd(pdata, MAC_L3L4CR5_val);
	MAC_L3L4CR4_RgRd(pdata, MAC_L3L4CR4_val);
	MAC_L3L4CR3_RgRd(pdata, MAC_L3L4CR3_val);
	MAC_L3L4CR2_RgRd(pdata, MAC_L3L4CR2_val);
	MAC_L3L4CR1_RgRd(pdata, MAC_L3L4CR1_val);
	MAC_L3L4CR0_RgRd(pdata, MAC_L3L4CR0_val);
	MAC_GPIOS_RgRd(pdata, MAC_GPIOS_val);
	MAC_PCS_RgRd(pdata, MAC_PCS_val);
	MAC_TES_RgRd(pdata, MAC_TES_val);
	MAC_AE_RgRd(pdata, MAC_AE_val);
	MAC_ALPA_RgRd(pdata, MAC_ALPA_val);
	MAC_AAD_RgRd(pdata, MAC_AAD_val);
	MAC_ANS_RgRd(pdata, MAC_ANS_val);
	MAC_ANC_RgRd(pdata, MAC_ANC_val);
	MAC_LPC_RgRd(pdata, MAC_LPC_val);
	MAC_LPS_RgRd(pdata, MAC_LPS_val);
   	MAC_SPI2R_RgRd(pdata, MAC_LMIR_val);
	MAC_SPI2R_RgRd(pdata, MAC_SPI2R_val);
	MAC_SPI1R_RgRd(pdata, MAC_SPI1R_val);
	MAC_SPI0R_RgRd(pdata, MAC_SPI0R_val);
	MAC_PTO_CR_RgRd(pdata, MAC_PTO_CR_val);
	MAC_PPS_WIDTH3_RgRd(pdata, MAC_PPS_WIDTH3_val);
	MAC_PPS_WIDTH2_RgRd(pdata, MAC_PPS_WIDTH2_val);
	MAC_PPS_WIDTH1_RgRd(pdata, MAC_PPS_WIDTH1_val);
	MAC_PPS_WIDTH0_RgRd(pdata, MAC_PPS_WIDTH0_val);
	MAC_PPS_INTVAL3_RgRd(pdata, MAC_PPS_INTVAL3_val);
	MAC_PPS_INTVAL2_RgRd(pdata, MAC_PPS_INTVAL2_val);
	MAC_PPS_INTVAL1_RgRd(pdata, MAC_PPS_INTVAL1_val);
	MAC_PPS_INTVAL0_RgRd(pdata, MAC_PPS_INTVAL0_val);
	MAC_PPS_TTNS3_RgRd(pdata, MAC_PPS_TTNS3_val);
	MAC_PPS_TTNS2_RgRd(pdata, MAC_PPS_TTNS2_val);
	MAC_PPS_TTNS1_RgRd(pdata, MAC_PPS_TTNS1_val);
	MAC_PPS_TTNS0_RgRd(pdata, MAC_PPS_TTNS0_val);
	MAC_PPS_TTS3_RgRd(pdata, MAC_PPS_TTS3_val);
	MAC_PPS_TTS2_RgRd(pdata, MAC_PPS_TTS2_val);
	MAC_PPS_TTS1_RgRd(pdata, MAC_PPS_TTS1_val);
	MAC_PPS_TTS0_RgRd(pdata, MAC_PPS_TTS0_val);
	MAC_PPSC_RgRd(pdata, MAC_PPSC_val);
	MAC_TEAC_RgRd(pdata, MAC_TEAC_val);
	MAC_TIAC_RgRd(pdata, MAC_TIAC_val);
	MAC_ATS_RgRd(pdata, MAC_ATS_val);
	MAC_ATN_RgRd(pdata, MAC_ATN_val);
	MAC_AC_RgRd(pdata, MAC_AC_val);
	MAC_TTN_RgRd(pdata, MAC_TTN_val);
	MAC_TTSN_RgRd(pdata, MAC_TTSN_val);
	MAC_TSR_RgRd(pdata, MAC_TSR_val);
	MAC_STHWR_RgRd(pdata, MAC_STHWR_val);
	MAC_TAR_RgRd(pdata, MAC_TAR_val);
	MAC_STNSUR_RgRd(pdata, MAC_STNSUR_val);
	MAC_STSUR_RgRd(pdata, MAC_STSUR_val);
	MAC_STNSR_RgRd(pdata, MAC_STNSR_val);
	MAC_STSR_RgRd(pdata, MAC_STSR_val);
	MAC_SSIR_RgRd(pdata, MAC_SSIR_val);
	MAC_TCR_RgRd(pdata, MAC_TCR_val);
	MTL_DSR_RgRd(pdata, MTL_DSR_val);
	MAC_RWPFFR_RgRd(pdata, MAC_RWPFFR_val);
	MAC_RTSR_RgRd(pdata, MAC_RTSR_val);
	MTL_IER_RgRd(pdata, MTL_IER_val);
	MTL_QRCR7_RgRd(pdata, MTL_QRCR7_val);
	MTL_QRCR6_RgRd(pdata, MTL_QRCR6_val);
	MTL_QRCR5_RgRd(pdata, MTL_QRCR5_val);
	MTL_QRCR4_RgRd(pdata, MTL_QRCR4_val);
	MTL_QRCR3_RgRd(pdata, MTL_QRCR3_val);
	MTL_QRCR2_RgRd(pdata, MTL_QRCR2_val);
	MTL_QRCR1_RgRd(pdata, MTL_QRCR1_val);
	MTL_QRDR7_RgRd(pdata, MTL_QRDR7_val);
	MTL_QRDR6_RgRd(pdata, MTL_QRDR6_val);
	MTL_QRDR5_RgRd(pdata, MTL_QRDR5_val);
	MTL_QRDR4_RgRd(pdata, MTL_QRDR4_val);
	MTL_QRDR3_RgRd(pdata, MTL_QRDR3_val);
	MTL_QRDR2_RgRd(pdata, MTL_QRDR2_val);
	MTL_QRDR1_RgRd(pdata, MTL_QRDR1_val);
	MTL_QOCR7_RgRd(pdata, MTL_QOCR7_val);
	MTL_QOCR6_RgRd(pdata, MTL_QOCR6_val);
	MTL_QOCR5_RgRd(pdata, MTL_QOCR5_val);
	MTL_QOCR4_RgRd(pdata, MTL_QOCR4_val);
	MTL_QOCR3_RgRd(pdata, MTL_QOCR3_val);
	MTL_QOCR2_RgRd(pdata, MTL_QOCR2_val);
	MTL_QOCR1_RgRd(pdata, MTL_QOCR1_val);
	MTL_QROMR_RgRd(pdata, 7, MTL_QROMR7_val);
	MTL_QROMR_RgRd(pdata, 6, MTL_QROMR6_val);
	MTL_QROMR_RgRd(pdata, 5, MTL_QROMR5_val);
	MTL_QROMR_RgRd(pdata, 4, MTL_QROMR4_val);
	MTL_QROMR_RgRd(pdata, 3, MTL_QROMR3_val);
	MTL_QROMR_RgRd(pdata, 2, MTL_QROMR2_val);
	MTL_QROMR_RgRd(pdata, 1, MTL_QROMR1_val);
	MTL_QLCR7_RgRd(pdata, MTL_QLCR7_val);
	MTL_QLCR6_RgRd(pdata, MTL_QLCR6_val);
	MTL_QLCR5_RgRd(pdata, MTL_QLCR5_val);
	MTL_QLCR4_RgRd(pdata, MTL_QLCR4_val);
	MTL_QLCR3_RgRd(pdata, MTL_QLCR3_val);
	MTL_QLCR2_RgRd(pdata, MTL_QLCR2_val);
	MTL_QLCR1_RgRd(pdata, MTL_QLCR1_val);
	MTL_QHCR7_RgRd(pdata, MTL_QHCR7_val);
	MTL_QHCR6_RgRd(pdata, MTL_QHCR6_val);
	MTL_QHCR5_RgRd(pdata, MTL_QHCR5_val);
	MTL_QHCR4_RgRd(pdata, MTL_QHCR4_val);
	MTL_QHCR3_RgRd(pdata, MTL_QHCR3_val);
	MTL_QHCR2_RgRd(pdata, MTL_QHCR2_val);
	MTL_QHCR1_RgRd(pdata, MTL_QHCR1_val);
	MTL_QSSCR7_RgRd(pdata, MTL_QSSCR7_val);
	MTL_QSSCR6_RgRd(pdata, MTL_QSSCR6_val);
	MTL_QSSCR5_RgRd(pdata, MTL_QSSCR5_val);
	MTL_QSSCR4_RgRd(pdata, MTL_QSSCR4_val);
	MTL_QSSCR3_RgRd(pdata, MTL_QSSCR3_val);
	MTL_QSSCR2_RgRd(pdata, MTL_QSSCR2_val);
	MTL_QSSCR1_RgRd(pdata, MTL_QSSCR1_val);
	MTL_QW7_RgRd(pdata, MTL_QW7_val);
	MTL_QW6_RgRd(pdata, MTL_QW6_val);
	MTL_QW5_RgRd(pdata, MTL_QW5_val);
	MTL_QW4_RgRd(pdata, MTL_QW4_val);
	MTL_QW3_RgRd(pdata, MTL_QW3_val);
	MTL_QW2_RgRd(pdata, MTL_QW2_val);
	MTL_QW1_RgRd(pdata, MTL_QW1_val);
	MTL_QESR7_RgRd(pdata, MTL_QESR7_val);
	MTL_QESR6_RgRd(pdata, MTL_QESR6_val);
	MTL_QESR5_RgRd(pdata, MTL_QESR5_val);
	MTL_QESR4_RgRd(pdata, MTL_QESR4_val);
	MTL_QESR3_RgRd(pdata, MTL_QESR3_val);
	MTL_QESR2_RgRd(pdata, MTL_QESR2_val);
	MTL_QESR1_RgRd(pdata, MTL_QESR1_val);
	MTL_QECR7_RgRd(pdata, MTL_QECR7_val);
	MTL_QECR6_RgRd(pdata, MTL_QECR6_val);
	MTL_QECR5_RgRd(pdata, MTL_QECR5_val);
	MTL_QECR4_RgRd(pdata, MTL_QECR4_val);
	MTL_QECR3_RgRd(pdata, MTL_QECR3_val);
	MTL_QECR2_RgRd(pdata, MTL_QECR2_val);
	MTL_QECR1_RgRd(pdata, MTL_QECR1_val);
	MTL_QTDR7_RgRd(pdata, MTL_QTDR7_val);
	MTL_QTDR6_RgRd(pdata, MTL_QTDR6_val);
	MTL_QTDR5_RgRd(pdata, MTL_QTDR5_val);
	MTL_QTDR4_RgRd(pdata, MTL_QTDR4_val);
	MTL_QTDR3_RgRd(pdata, MTL_QTDR3_val);
	MTL_QTDR2_RgRd(pdata, MTL_QTDR2_val);
	MTL_QTDR1_RgRd(pdata, MTL_QTDR1_val);
	MTL_QUCR7_RgRd(pdata, MTL_QUCR7_val);
	MTL_QUCR6_RgRd(pdata, MTL_QUCR6_val);
	MTL_QUCR5_RgRd(pdata, MTL_QUCR5_val);
	MTL_QUCR4_RgRd(pdata, MTL_QUCR4_val);
	MTL_QUCR3_RgRd(pdata, MTL_QUCR3_val);
	MTL_QUCR2_RgRd(pdata, MTL_QUCR2_val);
	MTL_QUCR1_RgRd(pdata, MTL_QUCR1_val);
	MTL_QTOMR7_RgRd(pdata, MTL_QTOMR7_val);
	MTL_QTOMR6_RgRd(pdata, MTL_QTOMR6_val);
	MTL_QTOMR5_RgRd(pdata, MTL_QTOMR5_val);
	MTL_QTOMR4_RgRd(pdata, MTL_QTOMR4_val);
	MTL_QTOMR3_RgRd(pdata, MTL_QTOMR3_val);
	MTL_QTOMR2_RgRd(pdata, MTL_QTOMR2_val);
	MTL_QTOMR1_RgRd(pdata, MTL_QTOMR1_val);
	MAC_PMTCSR_RgRd(pdata, MAC_PMTCSR_val);
	if (pdata->hw_feat.mmc_sel) {
		MMC_RXICMP_ERR_OCTETS_RgRd(pdata, MMC_RXICMP_ERR_OCTETS_val);
		MMC_RXICMP_GD_OCTETS_RgRd(pdata, MMC_RXICMP_GD_OCTETS_val);
		MMC_RXTCP_ERR_OCTETS_RgRd(pdata, MMC_RXTCP_ERR_OCTETS_val);
		MMC_RXTCP_GD_OCTETS_RgRd(pdata, MMC_RXTCP_GD_OCTETS_val);
		MMC_RXUDP_ERR_OCTETS_RgRd(pdata, MMC_RXUDP_ERR_OCTETS_val);
		MMC_RXUDP_GD_OCTETS_RgRd(pdata, MMC_RXUDP_GD_OCTETS_val);
		MMC_RXIPV6_NOPAY_OCTETS_RgRd(pdata, MMC_RXIPV6_NOPAY_OCTETS_val);
		MMC_RXIPV6_HDRERR_OCTETS_RgRd(pdata, MMC_RXIPV6_HDRERR_OCTETS_val);
		MMC_RXIPV6_GD_OCTETS_RgRd(pdata, MMC_RXIPV6_GD_OCTETS_val);
		MMC_RXIPV4_UDSBL_OCTETS_RgRd(pdata, MMC_RXIPV4_UDSBL_OCTETS_val);
		MMC_RXIPV4_FRAG_OCTETS_RgRd(pdata, MMC_RXIPV4_FRAG_OCTETS_val);
		MMC_RXIPV4_NOPAY_OCTETS_RgRd(pdata, MMC_RXIPV4_NOPAY_OCTETS_val);
		MMC_RXIPV4_HDRERR_OCTETS_RgRd(pdata, MMC_RXIPV4_HDRERR_OCTETS_val);
		MMC_RXIPV4_GD_OCTETS_RgRd(pdata, MMC_RXIPV4_GD_OCTETS_val);
		MMC_RXICMP_ERR_PKTS_RgRd(pdata, MMC_RXICMP_ERR_PKTS_val);
		MMC_RXICMP_GD_PKTS_RgRd(pdata, MMC_RXICMP_GD_PKTS_val);
		MMC_RXTCP_ERR_PKTS_RgRd(pdata, MMC_RXTCP_ERR_PKTS_val);
		MMC_RXTCP_GD_PKTS_RgRd(pdata, MMC_RXTCP_GD_PKTS_val);
		MMC_RXUDP_ERR_PKTS_RgRd(pdata, MMC_RXUDP_ERR_PKTS_val);
		MMC_RXUDP_GD_PKTS_RgRd(pdata, MMC_RXUDP_GD_PKTS_val);
		MMC_RXIPV6_NOPAY_PKTS_RgRd(pdata, MMC_RXIPV6_NOPAY_PKTS_val);
		MMC_RXIPV6_HDRERR_PKTS_RgRd(pdata, MMC_RXIPV6_HDRERR_PKTS_val);
		MMC_RXIPV6_GD_PKTS_RgRd(pdata, MMC_RXIPV6_GD_PKTS_val);
		MMC_RXIPV4_UBSBL_PKTS_RgRd(pdata, MMC_RXIPV4_UBSBL_PKTS_val);
		MMC_RXIPV4_FRAG_PKTS_RgRd(pdata, MMC_RXIPV4_FRAG_PKTS_val);
		MMC_RXIPV4_NOPAY_PKTS_RgRd(pdata, MMC_RXIPV4_NOPAY_PKTS_val);
		MMC_RXIPV4_HDRERR_PKTS_RgRd(pdata, MMC_RXIPV4_HDRERR_PKTS_val);
		MMC_RXIPV4_GD_PKTS_RgRd(pdata, MMC_RXIPV4_GD_PKTS_val);
		MMC_RXCTRLPACKETS_G_RgRd(pdata, MMC_RXCTRLPACKETS_G_val);
		MMC_RXRCVERROR_RgRd(pdata, MMC_RXRCVERROR_val);
		MMC_RXWATCHDOGERROR_RgRd(pdata, MMC_RXWATCHDOGERROR_val);
		MMC_RXVLANPACKETS_GB_RgRd(pdata, MMC_RXVLANPACKETS_GB_val);
		MMC_RXFIFOOVERFLOW_RgRd(pdata, MMC_RXFIFOOVERFLOW_val);
		MMC_RXPAUSEPACKETS_RgRd(pdata, MMC_RXPAUSEPACKETS_val);
		MMC_RXOUTOFRANGETYPE_RgRd(pdata, MMC_RXOUTOFRANGETYPE_val);
		MMC_RXLENGTHERROR_RgRd(pdata, MMC_RXLENGTHERROR_val);
		MMC_RXUNICASTPACKETS_G_RgRd(pdata, MMC_RXUNICASTPACKETS_G_val);
		MMC_RX1024TOMAXOCTETS_GB_RgRd(pdata, MMC_RX1024TOMAXOCTETS_GB_val);
		MMC_RX512TO1023OCTETS_GB_RgRd(pdata, MMC_RX512TO1023OCTETS_GB_val);
		MMC_RX256TO511OCTETS_GB_RgRd(pdata, MMC_RX256TO511OCTETS_GB_val);
		MMC_RX128TO255OCTETS_GB_RgRd(pdata, MMC_RX128TO255OCTETS_GB_val);
		MMC_RX65TO127OCTETS_GB_RgRd(pdata, MMC_RX65TO127OCTETS_GB_val);
		MMC_RX64OCTETS_GB_RgRd(pdata, MMC_RX64OCTETS_GB_val);
		MMC_RXOVERSIZE_G_RgRd(pdata, MMC_RXOVERSIZE_G_val);
		MMC_RXUNDERSIZE_G_RgRd(pdata, MMC_RXUNDERSIZE_G_val);
		MMC_RXJABBERERROR_RgRd(pdata, MMC_RXJABBERERROR_val);
		MMC_RXRUNTERROR_RgRd(pdata, MMC_RXRUNTERROR_val);
		MMC_RXALIGNMENTERROR_RgRd(pdata, MMC_RXALIGNMENTERROR_val);
		MMC_RXCRCERROR_RgRd(pdata, MMC_RXCRCERROR_val);
		MMC_RXMULTICASTPACKETS_G_RgRd(pdata, MMC_RXMULTICASTPACKETS_G_val);
		MMC_RXBROADCASTPACKETS_G_RgRd(pdata, MMC_RXBROADCASTPACKETS_G_val);
		MMC_RXOCTETCOUNT_G_RgRd(pdata, MMC_RXOCTETCOUNT_G_val);
		MMC_RXOCTETCOUNT_GB_RgRd(pdata, MMC_RXOCTETCOUNT_GB_val);
		MMC_RXPACKETCOUNT_GB_RgRd(pdata, MMC_RXPACKETCOUNT_GB_val);
		MMC_TXOVERSIZE_G_RgRd(pdata, MMC_TXOVERSIZE_G_val);
		MMC_TXVLANPACKETS_G_RgRd(pdata, MMC_TXVLANPACKETS_G_val);
		MMC_TXPAUSEPACKETS_RgRd(pdata, MMC_TXPAUSEPACKETS_val);
		MMC_TXEXCESSDEF_RgRd(pdata, MMC_TXEXCESSDEF_val);
		MMC_TXPACKETSCOUNT_G_RgRd(pdata, MMC_TXPACKETSCOUNT_G_val);
		MMC_TXOCTETCOUNT_G_RgRd(pdata, MMC_TXOCTETCOUNT_G_val);
		MMC_TXCARRIERERROR_RgRd(pdata, MMC_TXCARRIERERROR_val);
		MMC_TXEXESSCOL_RgRd(pdata, MMC_TXEXESSCOL_val);
		MMC_TXLATECOL_RgRd(pdata, MMC_TXLATECOL_val);
		MMC_TXDEFERRED_RgRd(pdata, MMC_TXDEFERRED_val);
		MMC_TXMULTICOL_G_RgRd(pdata, MMC_TXMULTICOL_G_val);
		MMC_TXSINGLECOL_G_RgRd(pdata, MMC_TXSINGLECOL_G_val);
		MMC_TXUNDERFLOWERROR_RgRd(pdata, MMC_TXUNDERFLOWERROR_val);
		MMC_TXBROADCASTPACKETS_GB_RgRd(pdata, MMC_TXBROADCASTPACKETS_GB_val);
		MMC_TXMULTICASTPACKETS_GB_RgRd(pdata, MMC_TXMULTICASTPACKETS_GB_val);
		MMC_TXUNICASTPACKETS_GB_RgRd(pdata, MMC_TXUNICASTPACKETS_GB_val);
		MMC_TX1024TOMAXOCTETS_GB_RgRd(pdata, MMC_TX1024TOMAXOCTETS_GB_val);
		MMC_TX512TO1023OCTETS_GB_RgRd(pdata, MMC_TX512TO1023OCTETS_GB_val);
		MMC_TX256TO511OCTETS_GB_RgRd(pdata, MMC_TX256TO511OCTETS_GB_val);
		MMC_TX128TO255OCTETS_GB_RgRd(pdata, MMC_TX128TO255OCTETS_GB_val);
		MMC_TX65TO127OCTETS_GB_RgRd(pdata, MMC_TX65TO127OCTETS_GB_val);
		MMC_TX64OCTETS_GB_RgRd(pdata, MMC_TX64OCTETS_GB_val);
		MMC_TXMULTICASTPACKETS_G_RgRd(pdata, MMC_TXMULTICASTPACKETS_G_val);
		MMC_TXBROADCASTPACKETS_G_RgRd(pdata, MMC_TXBROADCASTPACKETS_G_val);
		MMC_TXPACKETCOUNT_GB_RgRd(pdata, MMC_TXPACKETCOUNT_GB_val);
		MMC_TXOCTETCOUNT_GB_RgRd(pdata, MMC_TXOCTETCOUNT_GB_val);
		MMC_IPC_INTR_RX_RgRd(pdata, MMC_IPC_INTR_RX_val);
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, MMC_IPC_INTR_MASK_RX_val);
		MMC_INTR_MASK_TX_RgRd(pdata, MMC_INTR_MASK_TX_val);
		MMC_INTR_MASK_RX_RgRd(pdata, MMC_INTR_MASK_RX_val);
		MMC_INTR_TX_RgRd(pdata, MMC_INTR_TX_val);
		MMC_INTR_RX_RgRd(pdata, MMC_INTR_RX_val);
		MMC_CNTRL_RgRd(pdata, MMC_CNTRL_val);
	}
	MAC_MA1LR_RgRd(pdata, MAC_MA1LR_val);
	MAC_MA1HR_RgRd(pdata, MAC_MA1HR_val);
	MAC_MA0LR_RgRd(pdata, MAC_MA0LR_val);
	MAC_MA0HR_RgRd(pdata, MAC_MA0HR_val);
	MAC_GPIOR_RgRd(pdata, MAC_GPIOR_val);
	MAC_GMIIDR_RgRd(pdata, MAC_GMIIDR_val);
	MAC_GMIIAR_RgRd(pdata, MAC_GMIIAR_val);
	MAC_HFR2_RgRd(pdata, MAC_HFR2_val);
	MAC_HFR1_RgRd(pdata, MAC_HFR1_val);
	MAC_HFR0_RgRd(pdata, MAC_HFR0_val);
	MAC_MDR_RgRd(pdata, MAC_MDR_val);
	MAC_VR_RgRd(pdata, MAC_VR_val);
	MAC_HTR7_RgRd(pdata, MAC_HTR7_val);
	MAC_HTR6_RgRd(pdata, MAC_HTR6_val);
	MAC_HTR5_RgRd(pdata, MAC_HTR5_val);
	MAC_HTR4_RgRd(pdata, MAC_HTR4_val);
	MAC_HTR3_RgRd(pdata, MAC_HTR3_val);
	MAC_HTR2_RgRd(pdata, MAC_HTR2_val);
	MAC_HTR1_RgRd(pdata, MAC_HTR1_val);
	MAC_HTR0_RgRd(pdata, MAC_HTR0_val);
	DMA_RIWTR7_RgRd(pdata, DMA_RIWTR7_val);
	DMA_RIWTR6_RgRd(pdata, DMA_RIWTR6_val);
	DMA_RIWTR5_RgRd(pdata, DMA_RIWTR5_val);
	DMA_RIWTR4_RgRd(pdata, DMA_RIWTR4_val);
	DMA_RIWTR3_RgRd(pdata, DMA_RIWTR3_val);
	DMA_RIWTR2_RgRd(pdata, DMA_RIWTR2_val);
	DMA_RIWTR1_RgRd(pdata, DMA_RIWTR1_val);
	DMA_RIWTR0_RgRd(pdata, DMA_RIWTR0_val);
	DMA_RDRLR7_RgRd(pdata, DMA_RDRLR7_val);
	DMA_RDRLR6_RgRd(pdata, DMA_RDRLR6_val);
	DMA_RDRLR5_RgRd(pdata, DMA_RDRLR5_val);
	DMA_RDRLR4_RgRd(pdata, DMA_RDRLR4_val);
	DMA_RDRLR3_RgRd(pdata, DMA_RDRLR3_val);
	DMA_RDRLR2_RgRd(pdata, DMA_RDRLR2_val);
	DMA_RDRLR1_RgRd(pdata, DMA_RDRLR1_val);
	DMA_RDRLR0_RgRd(pdata, DMA_RDRLR0_val);
	DMA_TDRLR7_RgRd(pdata, DMA_TDRLR7_val);
	DMA_TDRLR6_RgRd(pdata, DMA_TDRLR6_val);
	DMA_TDRLR5_RgRd(pdata, DMA_TDRLR5_val);
	DMA_TDRLR4_RgRd(pdata, DMA_TDRLR4_val);
	DMA_TDRLR3_RgRd(pdata, DMA_TDRLR3_val);
	DMA_TDRLR2_RgRd(pdata, DMA_TDRLR2_val);
	DMA_TDRLR1_RgRd(pdata, DMA_TDRLR1_val);
	DMA_TDRLR0_RgRd(pdata, DMA_TDRLR0_val);
	DMA_RDTP_RPDR7_RgRd(pdata, DMA_RDTP_RPDR7_val);
	DMA_RDTP_RPDR6_RgRd(pdata, DMA_RDTP_RPDR6_val);
	DMA_RDTP_RPDR5_RgRd(pdata, DMA_RDTP_RPDR5_val);
	DMA_RDTP_RPDR4_RgRd(pdata, DMA_RDTP_RPDR4_val);
	DMA_RDTP_RPDR3_RgRd(pdata, DMA_RDTP_RPDR3_val);
	DMA_RDTP_RPDR2_RgRd(pdata, DMA_RDTP_RPDR2_val);
	DMA_RDTP_RPDR1_RgRd(pdata, DMA_RDTP_RPDR1_val);
	DMA_RDTP_RPDR0_RgRd(pdata, DMA_RDTP_RPDR0_val);
	DMA_TDTP_TPDR7_RgRd(pdata, DMA_TDTP_TPDR7_val);
	DMA_TDTP_TPDR6_RgRd(pdata, DMA_TDTP_TPDR6_val);
	DMA_TDTP_TPDR5_RgRd(pdata, DMA_TDTP_TPDR5_val);
	DMA_TDTP_TPDR4_RgRd(pdata, DMA_TDTP_TPDR4_val);
	DMA_TDTP_TPDR3_RgRd(pdata, DMA_TDTP_TPDR3_val);
	DMA_TDTP_TPDR2_RgRd(pdata, DMA_TDTP_TPDR2_val);
	DMA_TDTP_TPDR1_RgRd(pdata, DMA_TDTP_TPDR1_val);
	DMA_TDTP_TPDR0_RgRd(pdata, DMA_TDTP_TPDR0_val);
	DMA_RDLAR7_RgRd(pdata, DMA_RDLAR7_val);
	DMA_RDLAR6_RgRd(pdata, DMA_RDLAR6_val);
	DMA_RDLAR5_RgRd(pdata, DMA_RDLAR5_val);
	DMA_RDLAR4_RgRd(pdata, DMA_RDLAR4_val);
	DMA_RDLAR3_RgRd(pdata, DMA_RDLAR3_val);
	DMA_RDLAR2_RgRd(pdata, DMA_RDLAR2_val);
	DMA_RDLAR1_RgRd(pdata, DMA_RDLAR1_val);
	DMA_RDLAR0_RgRd(pdata, DMA_RDLAR0_val);
	DMA_TDLAR7_RgRd(pdata, DMA_TDLAR7_val);
	DMA_TDLAR6_RgRd(pdata, DMA_TDLAR6_val);
	DMA_TDLAR5_RgRd(pdata, DMA_TDLAR5_val);
	DMA_TDLAR4_RgRd(pdata, DMA_TDLAR4_val);
	DMA_TDLAR3_RgRd(pdata, DMA_TDLAR3_val);
	DMA_TDLAR2_RgRd(pdata, DMA_TDLAR2_val);
	DMA_TDLAR1_RgRd(pdata, DMA_TDLAR1_val);
	DMA_TDLAR0_RgRd(pdata, DMA_TDLAR0_val);
	DMA_IER_RgRd(pdata, 7, DMA_IER7_val);
	DMA_IER_RgRd(pdata, 6, DMA_IER6_val);
	DMA_IER_RgRd(pdata, 5, DMA_IER5_val);
	DMA_IER_RgRd(pdata, 4, DMA_IER4_val);
	DMA_IER_RgRd(pdata, 3, DMA_IER3_val);
	DMA_IER_RgRd(pdata, 2, DMA_IER2_val);
	DMA_IER_RgRd(pdata, 1, DMA_IER1_val);
	DMA_IER_RgRd(pdata, 0, DMA_IER0_val);
	MAC_IMR_RgRd(pdata, MAC_IMR_val);
	MAC_ISR_RgRd(pdata, MAC_ISR_val);
	MTL_ISR_RgRd(pdata, MTL_ISR_val);
	DMA_SR_RgRd(pdata, 7, DMA_SR7_val);
	DMA_SR_RgRd(pdata, 6, DMA_SR6_val);
	DMA_SR_RgRd(pdata, 5, DMA_SR5_val);
	DMA_SR_RgRd(pdata, 4, DMA_SR4_val);
	DMA_SR_RgRd(pdata, 3, DMA_SR3_val);
	DMA_SR_RgRd(pdata, 2, DMA_SR2_val);
	DMA_SR_RgRd(pdata, 1, DMA_SR1_val);
	DMA_SR_RgRd(pdata, 0, DMA_SR0_val);
	DMA_ISR_RgRd(pdata, DMA_ISR_val);
	DMA_DSR2_RgRd(pdata, DMA_DSR2_val);
	DMA_DSR1_RgRd(pdata, DMA_DSR1_val);
	DMA_DSR0_RgRd(pdata, DMA_DSR0_val);
	MTL_Q0RDR_RgRd(pdata, MTL_Q0RDR_val);
	MTL_Q0ESR_RgRd(pdata, MTL_Q0ESR_val);
	MTL_Q0TDR_RgRd(pdata, MTL_Q0TDR_val);
	DMA_CHRBAR7_RgRd(pdata, DMA_CHRBAR7_val);
	DMA_CHRBAR6_RgRd(pdata, DMA_CHRBAR6_val);
	DMA_CHRBAR5_RgRd(pdata, DMA_CHRBAR5_val);
	DMA_CHRBAR4_RgRd(pdata, DMA_CHRBAR4_val);
	DMA_CHRBAR3_RgRd(pdata, DMA_CHRBAR3_val);
	DMA_CHRBAR2_RgRd(pdata, DMA_CHRBAR2_val);
	DMA_CHRBAR1_RgRd(pdata, DMA_CHRBAR1_val);
	DMA_CHRBAR0_RgRd(pdata, DMA_CHRBAR0_val);
	DMA_CHTBAR7_RgRd(pdata, DMA_CHTBAR7_val);
	DMA_CHTBAR6_RgRd(pdata, DMA_CHTBAR6_val);
	DMA_CHTBAR5_RgRd(pdata, DMA_CHTBAR5_val);
	DMA_CHTBAR4_RgRd(pdata, DMA_CHTBAR4_val);
	DMA_CHTBAR3_RgRd(pdata, DMA_CHTBAR3_val);
	DMA_CHTBAR2_RgRd(pdata, DMA_CHTBAR2_val);
	DMA_CHTBAR1_RgRd(pdata, DMA_CHTBAR1_val);
	DMA_CHTBAR0_RgRd(pdata, DMA_CHTBAR0_val);
	DMA_CHRDR7_RgRd(pdata, DMA_CHRDR7_val);
	DMA_CHRDR6_RgRd(pdata, DMA_CHRDR6_val);
	DMA_CHRDR5_RgRd(pdata, DMA_CHRDR5_val);
	DMA_CHRDR4_RgRd(pdata, DMA_CHRDR4_val);
	DMA_CHRDR3_RgRd(pdata, DMA_CHRDR3_val);
	DMA_CHRDR2_RgRd(pdata, DMA_CHRDR2_val);
	DMA_CHRDR1_RgRd(pdata, DMA_CHRDR1_val);
	DMA_CHRDR0_RgRd(pdata, DMA_CHRDR0_val);
	DMA_CHTDR7_RgRd(pdata, DMA_CHTDR7_val);
	DMA_CHTDR6_RgRd(pdata, DMA_CHTDR6_val);
	DMA_CHTDR5_RgRd(pdata, DMA_CHTDR5_val);
	DMA_CHTDR4_RgRd(pdata, DMA_CHTDR4_val);
	DMA_CHTDR3_RgRd(pdata, DMA_CHTDR3_val);
	DMA_CHTDR2_RgRd(pdata, DMA_CHTDR2_val);
	DMA_CHTDR1_RgRd(pdata, DMA_CHTDR1_val);
	DMA_CHTDR0_RgRd(pdata, DMA_CHTDR0_val);
	DMA_SFCSR7_RgRd(pdata, DMA_SFCSR7_val);
	DMA_SFCSR6_RgRd(pdata, DMA_SFCSR6_val);
	DMA_SFCSR5_RgRd(pdata, DMA_SFCSR5_val);
	DMA_SFCSR4_RgRd(pdata, DMA_SFCSR4_val);
	DMA_SFCSR3_RgRd(pdata, DMA_SFCSR3_val);
	DMA_SFCSR2_RgRd(pdata, DMA_SFCSR2_val);
	DMA_SFCSR1_RgRd(pdata, DMA_SFCSR1_val);
	DMA_SFCSR0_RgRd(pdata, DMA_SFCSR0_val);
	MAC_IVLANTIRR_RgRd(pdata, MAC_IVLANTIRR_val);
	MAC_VLANTIRR_RgRd(pdata, MAC_VLANTIRR_val);
	MAC_VLANHTR_RgRd(pdata, MAC_VLANHTR_val);
	MAC_VLANTR_RgRd(pdata, MAC_VLANTR_val);
	DMA_SBUS_RgRd(pdata, DMA_SBUS_val);
	DMA_BMR_RgRd(pdata, DMA_BMR_val);
	MTL_Q0RCR_RgRd(pdata, MTL_Q0RCR_val);
	MTL_Q0OCR_RgRd(pdata, MTL_Q0OCR_val);
	MTL_Q0ROMR_RgRd(pdata, MTL_Q0ROMR_val);
	MTL_Q0QR_RgRd(pdata, MTL_Q0QR_val);
	MTL_Q0ECR_RgRd(pdata, MTL_Q0ECR_val);
	MTL_Q0UCR_RgRd(pdata, MTL_Q0UCR_val);
	MTL_Q0TOMR_RgRd(pdata, MTL_Q0TOMR_val);
	MTL_RQDCM1R_RgRd(pdata, MTL_RQDCM1R_val);
	MTL_RQDCM0R_RgRd(pdata, MTL_RQDCM0R_val);
	MTL_FDDR_RgRd(pdata, MTL_FDDR_val);
	MTL_FDACS_RgRd(pdata, MTL_FDACS_val);
	MTL_OMR_RgRd(pdata, MTL_OMR_val);
	MAC_RQC3R_RgRd(pdata, MAC_RQC3R_val);
	MAC_RQC2R_RgRd(pdata, MAC_RQC2R_val);
	MAC_RQC1R_RgRd(pdata, MAC_RQC1R_val);
	MAC_RQC0R_RgRd(pdata, MAC_RQC0R_val);
	MAC_TQPM1R_RgRd(pdata, MAC_TQPM1R_val);
	MAC_TQPM0R_RgRd(pdata, MAC_TQPM0R_val);
	MAC_RFCR_RgRd(pdata, MAC_RFCR_val);
	MAC_QTFCR7_RgRd(pdata, MAC_QTFCR7_val);
	MAC_QTFCR6_RgRd(pdata, MAC_QTFCR6_val);
	MAC_QTFCR5_RgRd(pdata, MAC_QTFCR5_val);
	MAC_QTFCR4_RgRd(pdata, MAC_QTFCR4_val);
	MAC_QTFCR3_RgRd(pdata, MAC_QTFCR3_val);
	MAC_QTFCR2_RgRd(pdata, MAC_QTFCR2_val);
	MAC_QTFCR1_RgRd(pdata, MAC_QTFCR1_val);
	MAC_Q0TFCR_RgRd(pdata, MAC_Q0TFCR_val);
	DMA_AXI4CR7_RgRd(pdata, DMA_AXI4CR7_val);
	DMA_AXI4CR6_RgRd(pdata, DMA_AXI4CR6_val);
	DMA_AXI4CR5_RgRd(pdata, DMA_AXI4CR5_val);
	DMA_AXI4CR4_RgRd(pdata, DMA_AXI4CR4_val);
	DMA_AXI4CR3_RgRd(pdata, DMA_AXI4CR3_val);
	DMA_AXI4CR2_RgRd(pdata, DMA_AXI4CR2_val);
	DMA_AXI4CR1_RgRd(pdata, DMA_AXI4CR1_val);
	DMA_AXI4CR0_RgRd(pdata, DMA_AXI4CR0_val);
	DMA_RCR7_RgRd(pdata, DMA_RCR7_val);
	DMA_RCR6_RgRd(pdata, DMA_RCR6_val);
	DMA_RCR5_RgRd(pdata, DMA_RCR5_val);
	DMA_RCR4_RgRd(pdata, DMA_RCR4_val);
	DMA_RCR3_RgRd(pdata, DMA_RCR3_val);
	DMA_RCR2_RgRd(pdata, DMA_RCR2_val);
	DMA_RCR1_RgRd(pdata, DMA_RCR1_val);
	DMA_RCR0_RgRd(pdata, DMA_RCR0_val);
	DMA_TCR7_RgRd(pdata, DMA_TCR7_val);
	DMA_TCR6_RgRd(pdata, DMA_TCR6_val);
	DMA_TCR5_RgRd(pdata, DMA_TCR5_val);
	DMA_TCR4_RgRd(pdata, DMA_TCR4_val);
	DMA_TCR3_RgRd(pdata, DMA_TCR3_val);
	DMA_TCR2_RgRd(pdata, DMA_TCR2_val);
	DMA_TCR1_RgRd(pdata, DMA_TCR1_val);
	DMA_TCR0_RgRd(pdata, DMA_TCR0_val);
	DMA_CR7_RgRd(pdata, DMA_CR7_val);
	DMA_CR6_RgRd(pdata, DMA_CR6_val);
	DMA_CR5_RgRd(pdata, DMA_CR5_val);
	DMA_CR4_RgRd(pdata, DMA_CR4_val);
	DMA_CR3_RgRd(pdata, DMA_CR3_val);
	DMA_CR2_RgRd(pdata, DMA_CR2_val);
	DMA_CR1_RgRd(pdata, DMA_CR1_val);
	DMA_CR0_RgRd(pdata, DMA_CR0_val);
	MAC_WTR_RgRd(pdata, MAC_WTR_val);
	MAC_MPFR_RgRd(pdata, MAC_MPFR_val);
	MAC_MECR_RgRd(pdata, MAC_MECR_val);
	MAC_MCR_RgRd(pdata, MAC_MCR_val);
	/* For MII/GMII register read */
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_BMCR,
				     &MII_BMCR_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_BMSR,
				     &MII_BMSR_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_PHYSID1,
				     &MII_PHYSID1_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_PHYSID2,
				     &MII_PHYSID2_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_ADVERTISE,
				     &MII_ADVERTISE_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_LPA,
				     &MII_LPA_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_EXPANSION,
				     &MII_EXPANSION_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr,
				     DWC_ETH_QOS_AUTO_NEGO_NP,
				     &AUTO_NEGO_NP_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_ESTATUS,
				     &MII_ESTATUS_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_CTRL1000,
				     &MII_CTRL1000_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_STAT1000,
				     &MII_STAT1000_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, DWC_ETH_QOS_PHY_CTL,
				     &PHY_CTL_REG_val);
	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, DWC_ETH_QOS_PHY_STS,
				     &PHY_STS_REG_val);
	debug_buf = (char *)kmalloc(26820, GFP_KERNEL);

	sprintf(debug_buf,
		"MAC_MA32_127LR127            :%#x\n"
		"MAC_MA32_127LR126            :%#x\n"
		"MAC_MA32_127LR125            :%#x\n"
		"MAC_MA32_127LR124            :%#x\n"
		"MAC_MA32_127LR123            :%#x\n"
		"MAC_MA32_127LR122            :%#x\n"
		"MAC_MA32_127LR121            :%#x\n"
		"MAC_MA32_127LR120            :%#x\n"
		"MAC_MA32_127LR119            :%#x\n"
		"MAC_MA32_127LR118            :%#x\n"
		"MAC_MA32_127LR117            :%#x\n"
		"MAC_MA32_127LR116            :%#x\n"
		"MAC_MA32_127LR115            :%#x\n"
		"MAC_MA32_127LR114            :%#x\n"
		"MAC_MA32_127LR113            :%#x\n"
		"MAC_MA32_127LR112            :%#x\n"
		"MAC_MA32_127LR111            :%#x\n"
		"MAC_MA32_127LR110            :%#x\n"
		"MAC_MA32_127LR109            :%#x\n"
		"MAC_MA32_127LR108            :%#x\n"
		"MAC_MA32_127LR107            :%#x\n"
		"MAC_MA32_127LR106            :%#x\n"
		"MAC_MA32_127LR105            :%#x\n"
		"MAC_MA32_127LR104            :%#x\n"
		"MAC_MA32_127LR103            :%#x\n"
		"MAC_MA32_127LR102            :%#x\n"
		"MAC_MA32_127LR101            :%#x\n"
		"MAC_MA32_127LR100            :%#x\n"
		"MAC_MA32_127LR99            :%#x\n"
		"MAC_MA32_127LR98            :%#x\n"
		"MAC_MA32_127LR97            :%#x\n"
		"MAC_MA32_127LR96            :%#x\n"
		"MAC_MA32_127LR95            :%#x\n"
		"MAC_MA32_127LR94            :%#x\n"
		"MAC_MA32_127LR93            :%#x\n"
		"MAC_MA32_127LR92            :%#x\n"
		"MAC_MA32_127LR91            :%#x\n"
		"MAC_MA32_127LR90            :%#x\n"
		"MAC_MA32_127LR89            :%#x\n"
		"MAC_MA32_127LR88            :%#x\n"
		"MAC_MA32_127LR87            :%#x\n"
		"MAC_MA32_127LR86            :%#x\n"
		"MAC_MA32_127LR85            :%#x\n"
		"MAC_MA32_127LR84            :%#x\n"
		"MAC_MA32_127LR83            :%#x\n"
		"MAC_MA32_127LR82            :%#x\n"
		"MAC_MA32_127LR81            :%#x\n"
		"MAC_MA32_127LR80            :%#x\n"
		"MAC_MA32_127LR79            :%#x\n"
		"MAC_MA32_127LR78            :%#x\n"
		"MAC_MA32_127LR77            :%#x\n"
		"MAC_MA32_127LR76            :%#x\n"
		"MAC_MA32_127LR75            :%#x\n"
		"MAC_MA32_127LR74            :%#x\n"
		"MAC_MA32_127LR73            :%#x\n"
		"MAC_MA32_127LR72            :%#x\n"
		"MAC_MA32_127LR71            :%#x\n"
		"MAC_MA32_127LR70            :%#x\n"
		"MAC_MA32_127LR69            :%#x\n"
		"MAC_MA32_127LR68            :%#x\n"
		"MAC_MA32_127LR67            :%#x\n"
		"MAC_MA32_127LR66            :%#x\n"
		"MAC_MA32_127LR65            :%#x\n"
		"MAC_MA32_127LR64            :%#x\n"
		"MAC_MA32_127LR63            :%#x\n"
		"MAC_MA32_127LR62            :%#x\n"
		"MAC_MA32_127LR61            :%#x\n"
		"MAC_MA32_127LR60            :%#x\n"
		"MAC_MA32_127LR59            :%#x\n"
		"MAC_MA32_127LR58            :%#x\n"
		"MAC_MA32_127LR57            :%#x\n"
		"MAC_MA32_127LR56            :%#x\n"
		"MAC_MA32_127LR55            :%#x\n"
		"MAC_MA32_127LR54            :%#x\n"
		"MAC_MA32_127LR53            :%#x\n"
		"MAC_MA32_127LR52            :%#x\n"
		"MAC_MA32_127LR51            :%#x\n"
		"MAC_MA32_127LR50            :%#x\n"
		"MAC_MA32_127LR49            :%#x\n"
		"MAC_MA32_127LR48            :%#x\n"
		"MAC_MA32_127LR47            :%#x\n"
		"MAC_MA32_127LR46            :%#x\n"
		"MAC_MA32_127LR45            :%#x\n"
		"MAC_MA32_127LR44            :%#x\n"
		"MAC_MA32_127LR43            :%#x\n"
		"MAC_MA32_127LR42            :%#x\n"
		"MAC_MA32_127LR41            :%#x\n"
		"MAC_MA32_127LR40            :%#x\n"
		"MAC_MA32_127LR39            :%#x\n"
		"MAC_MA32_127LR38            :%#x\n"
		"MAC_MA32_127LR37            :%#x\n"
		"MAC_MA32_127LR36            :%#x\n"
		"MAC_MA32_127LR35            :%#x\n"
		"MAC_MA32_127LR34            :%#x\n"
		"MAC_MA32_127LR33            :%#x\n"
		"MAC_MA32_127LR32            :%#x\n"
		"MAC_MA32_127HR127            :%#x\n"
		"MAC_MA32_127HR126            :%#x\n"
		"MAC_MA32_127HR125            :%#x\n"
		"MAC_MA32_127HR124            :%#x\n"
		"MAC_MA32_127HR123            :%#x\n"
		"MAC_MA32_127HR122            :%#x\n"
		"MAC_MA32_127HR121            :%#x\n"
		"MAC_MA32_127HR120            :%#x\n"
		"MAC_MA32_127HR119            :%#x\n"
		"MAC_MA32_127HR118            :%#x\n"
		"MAC_MA32_127HR117            :%#x\n"
		"MAC_MA32_127HR116            :%#x\n"
		"MAC_MA32_127HR115            :%#x\n"
		"MAC_MA32_127HR114            :%#x\n"
		"MAC_MA32_127HR113            :%#x\n"
		"MAC_MA32_127HR112            :%#x\n"
		"MAC_MA32_127HR111            :%#x\n"
		"MAC_MA32_127HR110            :%#x\n"
		"MAC_MA32_127HR109            :%#x\n"
		"MAC_MA32_127HR108            :%#x\n"
		"MAC_MA32_127HR107            :%#x\n"
		"MAC_MA32_127HR106            :%#x\n"
		"MAC_MA32_127HR105            :%#x\n"
		"MAC_MA32_127HR104            :%#x\n"
		"MAC_MA32_127HR103            :%#x\n"
		"MAC_MA32_127HR102            :%#x\n"
		"MAC_MA32_127HR101            :%#x\n"
		"MAC_MA32_127HR100            :%#x\n"
		"MAC_MA32_127HR99            :%#x\n"
		"MAC_MA32_127HR98            :%#x\n"
		"MAC_MA32_127HR97            :%#x\n"
		"MAC_MA32_127HR96            :%#x\n"
		"MAC_MA32_127HR95            :%#x\n"
		"MAC_MA32_127HR94            :%#x\n"
		"MAC_MA32_127HR93            :%#x\n"
		"MAC_MA32_127HR92            :%#x\n"
		"MAC_MA32_127HR91            :%#x\n"
		"MAC_MA32_127HR90            :%#x\n"
		"MAC_MA32_127HR89            :%#x\n"
		"MAC_MA32_127HR88            :%#x\n"
		"MAC_MA32_127HR87            :%#x\n"
		"MAC_MA32_127HR86            :%#x\n"
		"MAC_MA32_127HR85            :%#x\n"
		"MAC_MA32_127HR84            :%#x\n"
		"MAC_MA32_127HR83            :%#x\n"
		"MAC_MA32_127HR82            :%#x\n"
		"MAC_MA32_127HR81            :%#x\n"
		"MAC_MA32_127HR80            :%#x\n"
		"MAC_MA32_127HR79            :%#x\n"
		"MAC_MA32_127HR78            :%#x\n"
		"MAC_MA32_127HR77            :%#x\n"
		"MAC_MA32_127HR76            :%#x\n"
		"MAC_MA32_127HR75            :%#x\n"
		"MAC_MA32_127HR74            :%#x\n"
		"MAC_MA32_127HR73            :%#x\n"
		"MAC_MA32_127HR72            :%#x\n"
		"MAC_MA32_127HR71            :%#x\n"
		"MAC_MA32_127HR70            :%#x\n"
		"MAC_MA32_127HR69            :%#x\n"
		"MAC_MA32_127HR68            :%#x\n"
		"MAC_MA32_127HR67            :%#x\n"
		"MAC_MA32_127HR66            :%#x\n"
		"MAC_MA32_127HR65            :%#x\n"
		"MAC_MA32_127HR64            :%#x\n"
		"MAC_MA32_127HR63            :%#x\n"
		"MAC_MA32_127HR62            :%#x\n"
		"MAC_MA32_127HR61            :%#x\n"
		"MAC_MA32_127HR60            :%#x\n"
		"MAC_MA32_127HR59            :%#x\n"
		"MAC_MA32_127HR58            :%#x\n"
		"MAC_MA32_127HR57            :%#x\n"
		"MAC_MA32_127HR56            :%#x\n"
		"MAC_MA32_127HR55            :%#x\n"
		"MAC_MA32_127HR54            :%#x\n"
		"MAC_MA32_127HR53            :%#x\n"
		"MAC_MA32_127HR52            :%#x\n"
		"MAC_MA32_127HR51            :%#x\n"
		"MAC_MA32_127HR50            :%#x\n"
		"MAC_MA32_127HR49            :%#x\n"
		"MAC_MA32_127HR48            :%#x\n"
		"MAC_MA32_127HR47            :%#x\n"
		"MAC_MA32_127HR46            :%#x\n"
		"MAC_MA32_127HR45            :%#x\n"
		"MAC_MA32_127HR44            :%#x\n"
		"MAC_MA32_127HR43            :%#x\n"
		"MAC_MA32_127HR42            :%#x\n"
		"MAC_MA32_127HR41            :%#x\n"
		"MAC_MA32_127HR40            :%#x\n"
		"MAC_MA32_127HR39            :%#x\n"
		"MAC_MA32_127HR38            :%#x\n"
		"MAC_MA32_127HR37            :%#x\n"
		"MAC_MA32_127HR36            :%#x\n"
		"MAC_MA32_127HR35            :%#x\n"
		"MAC_MA32_127HR34            :%#x\n"
		"MAC_MA32_127HR33            :%#x\n"
		"MAC_MA32_127HR32            :%#x\n"
		"MAC_MA1_31LR31              :%#x\n"
		"MAC_MA1_31LR30              :%#x\n"
		"MAC_MA1_31LR29              :%#x\n"
		"MAC_MA1_31LR28              :%#x\n"
		"MAC_MA1_31LR27              :%#x\n"
		"MAC_MA1_31LR26              :%#x\n"
		"MAC_MA1_31LR25              :%#x\n"
		"MAC_MA1_31LR24              :%#x\n"
		"MAC_MA1_31LR23              :%#x\n"
		"MAC_MA1_31LR22              :%#x\n"
		"MAC_MA1_31LR21              :%#x\n"
		"MAC_MA1_31LR20              :%#x\n"
		"MAC_MA1_31LR19              :%#x\n"
		"MAC_MA1_31LR18              :%#x\n"
		"MAC_MA1_31LR17              :%#x\n"
		"MAC_MA1_31LR16              :%#x\n"
		"MAC_MA1_31LR15              :%#x\n"
		"MAC_MA1_31LR14              :%#x\n"
		"MAC_MA1_31LR13              :%#x\n"
		"MAC_MA1_31LR12              :%#x\n"
		"MAC_MA1_31LR11              :%#x\n"
		"MAC_MA1_31LR10              :%#x\n"
		"MAC_MA1_31LR9              :%#x\n"
		"MAC_MA1_31LR8              :%#x\n"
		"MAC_MA1_31LR7              :%#x\n"
		"MAC_MA1_31LR6              :%#x\n"
		"MAC_MA1_31LR5              :%#x\n"
		"MAC_MA1_31LR4              :%#x\n"
		"MAC_MA1_31LR3              :%#x\n"
		"MAC_MA1_31LR2              :%#x\n"
		"MAC_MA1_31LR1              :%#x\n"
		"MAC_MA1_31HR31              :%#x\n"
		"MAC_MA1_31HR30              :%#x\n"
		"MAC_MA1_31HR29              :%#x\n"
		"MAC_MA1_31HR28              :%#x\n"
		"MAC_MA1_31HR27              :%#x\n"
		"MAC_MA1_31HR26              :%#x\n"
		"MAC_MA1_31HR25              :%#x\n"
		"MAC_MA1_31HR24              :%#x\n"
		"MAC_MA1_31HR23              :%#x\n"
		"MAC_MA1_31HR22              :%#x\n"
		"MAC_MA1_31HR21              :%#x\n"
		"MAC_MA1_31HR20              :%#x\n"
		"MAC_MA1_31HR19              :%#x\n"
		"MAC_MA1_31HR18              :%#x\n"
		"MAC_MA1_31HR17              :%#x\n"
		"MAC_MA1_31HR16              :%#x\n"
		"MAC_MA1_31HR15              :%#x\n"
		"MAC_MA1_31HR14              :%#x\n"
		"MAC_MA1_31HR13              :%#x\n"
		"MAC_MA1_31HR12              :%#x\n"
		"MAC_MA1_31HR11              :%#x\n"
		"MAC_MA1_31HR10              :%#x\n"
		"MAC_MA1_31HR9              :%#x\n"
		"MAC_MA1_31HR8              :%#x\n"
		"MAC_MA1_31HR7              :%#x\n"
		"MAC_MA1_31HR6              :%#x\n"
		"MAC_MA1_31HR5              :%#x\n"
		"MAC_MA1_31HR4              :%#x\n"
		"MAC_MA1_31HR3              :%#x\n"
		"MAC_MA1_31HR2              :%#x\n"
		"MAC_MA1_31HR1              :%#x\n"
		"MAC_ARPA                   :%#x\n"
		"MAC_L3A3R7                 :%#x\n"
		"MAC_L3A3R6                 :%#x\n"
		"MAC_L3A3R5                 :%#x\n"
		"MAC_L3A3R4                 :%#x\n"
		"MAC_L3A3R3                 :%#x\n"
		"MAC_L3A3R2                 :%#x\n"
		"MAC_L3A3R1                 :%#x\n"
		"MAC_L3A3R0                 :%#x\n"
		"MAC_L3A2R7                 :%#x\n"
		"MAC_L3A2R6                 :%#x\n"
		"MAC_L3A2R5                 :%#x\n"
		"MAC_L3A2R4                 :%#x\n"
		"MAC_L3A2R3                 :%#x\n"
		"MAC_L3A2R2                 :%#x\n"
		"MAC_L3A2R1                 :%#x\n"
		"MAC_L3A2R0                 :%#x\n"
		"MAC_L3A1R7                 :%#x\n"
		"MAC_L3A1R6                 :%#x\n"
		"MAC_L3A1R5                 :%#x\n"
		"MAC_L3A1R4                 :%#x\n"
		"MAC_L3A1R3                 :%#x\n"
		"MAC_L3A1R2                 :%#x\n"
		"MAC_L3A1R1                 :%#x\n"
		"MAC_L3A1R0                 :%#x\n"
		"MAC_L3A0R7                 :%#x\n"
		"MAC_L3A0R6                 :%#x\n"
		"MAC_L3A0R5                 :%#x\n"
		"MAC_L3A0R4                 :%#x\n"
		"MAC_L3A0R3                 :%#x\n"
		"MAC_L3A0R2                 :%#x\n"
		"MAC_L3A0R1                 :%#x\n"
		"MAC_L3A0R0                 :%#x\n"
		"MAC_L4AR7                 :%#x\n"
		"MAC_L4AR6                 :%#x\n"
		"MAC_L4AR5                 :%#x\n"
		"MAC_L4AR4                 :%#x\n"
		"MAC_L4AR3                 :%#x\n"
		"MAC_L4AR2                 :%#x\n"
		"MAC_L4AR1                 :%#x\n"
		"MAC_L4AR0                 :%#x\n"
		"MAC_L3L4CR7                :%#x\n"
		"MAC_L3L4CR6                :%#x\n"
		"MAC_L3L4CR5                :%#x\n"
		"MAC_L3L4CR4                :%#x\n"
		"MAC_L3L4CR3                :%#x\n"
		"MAC_L3L4CR2                :%#x\n"
		"MAC_L3L4CR1                :%#x\n"
		"MAC_L3L4CR0                :%#x\n"
		"MAC_GPIOS                  :%#x\n"
		"MAC_PCS                    :%#x\n"
		"MAC_TES                    :%#x\n"
		"MAC_AE                     :%#x\n"
		"MAC_ALPA                   :%#x\n"
		"MAC_AAD                    :%#x\n"
		"MAC_ANS                    :%#x\n"
		"MAC_ANC                    :%#x\n"
		"MAC_LPC                    :%#x\n"
		"MAC_LPS                    :%#x\n"
        "MAC_LMIR                   :%#x\n"
		"MAC_SPI2R                  :%#x\n"
		"MAC_SPI1R                  :%#x\n"
		"MAC_SPI0R                  :%#x\n"
		"MAC_PTO_CR                 :%#x\n"
		"MAC_PPS_WIDTH3             :%#x\n"
		"MAC_PPS_WIDTH2             :%#x\n"
		"MAC_PPS_WIDTH1             :%#x\n"
		"MAC_PPS_WIDTH0             :%#x\n"
		"MAC_PPS_INTVAL3            :%#x\n"
		"MAC_PPS_INTVAL2            :%#x\n"
		"MAC_PPS_INTVAL1            :%#x\n"
		"MAC_PPS_INTVAL0            :%#x\n"
		"MAC_PPS_TTNS3              :%#x\n"
		"MAC_PPS_TTNS2              :%#x\n"
		"MAC_PPS_TTNS1              :%#x\n"
		"MAC_PPS_TTNS0              :%#x\n"
		"MAC_PPS_TTS3               :%#x\n"
		"MAC_PPS_TTS2               :%#x\n"
		"MAC_PPS_TTS1               :%#x\n"
		"MAC_PPS_TTS0               :%#x\n"
		"MAC_PPSC                   :%#x\n"
		"MAC_TEAC                   :%#x\n"
		"MAC_TIAC                   :%#x\n"
		"MAC_ATS                    :%#x\n"
		"MAC_ATN                    :%#x\n"
		"MAC_AC                     :%#x\n"
		"MAC_TTN                    :%#x\n"
		"MAC_TTSN                   :%#x\n"
		"MAC_TSR                    :%#x\n"
		"MAC_STHWR                  :%#x\n"
		"MAC_TAR                    :%#x\n"
		"MAC_STNSUR                 :%#x\n"
		"MAC_STSUR                  :%#x\n"
		"MAC_STNSR                  :%#x\n"
		"MAC_STSR                   :%#x\n"
		"MAC_SSIR                   :%#x\n"
		"MAC_TCR                    :%#x\n"
		"MTL_DSR                    :%#x\n"
		"MAC_RWPFFR                 :%#x\n"
		"MAC_RTSR                   :%#x\n"
		"MTL_IER                    :%#x\n"
		"MTL_QRCR7                  :%#x\n"
		"MTL_QRCR6                  :%#x\n"
		"MTL_QRCR5                  :%#x\n"
		"MTL_QRCR4                  :%#x\n"
		"MTL_QRCR3                  :%#x\n"
		"MTL_QRCR2                  :%#x\n"
		"MTL_QRCR1                  :%#x\n"
		"MTL_QRDR7                  :%#x\n"
		"MTL_QRDR6                  :%#x\n"
		"MTL_QRDR5                  :%#x\n"
		"MTL_QRDR4                  :%#x\n"
		"MTL_QRDR3                  :%#x\n"
		"MTL_QRDR2                  :%#x\n"
		"MTL_QRDR1                  :%#x\n"
		"MTL_QOCR7                  :%#x\n"
		"MTL_QOCR6                  :%#x\n"
		"MTL_QOCR5                  :%#x\n"
		"MTL_QOCR4                  :%#x\n"
		"MTL_QOCR3                  :%#x\n"
		"MTL_QOCR2                  :%#x\n"
		"MTL_QOCR1                  :%#x\n"
		"MTL_QROMR7                 :%#x\n"
		"MTL_QROMR6                 :%#x\n"
		"MTL_QROMR5                 :%#x\n"
		"MTL_QROMR4                 :%#x\n"
		"MTL_QROMR3                 :%#x\n"
		"MTL_QROMR2                 :%#x\n"
		"MTL_QROMR1                 :%#x\n"
		"MTL_QLCR7                  :%#x\n"
		"MTL_QLCR6                  :%#x\n"
		"MTL_QLCR5                  :%#x\n"
		"MTL_QLCR4                  :%#x\n"
		"MTL_QLCR3                  :%#x\n"
		"MTL_QLCR2                  :%#x\n"
		"MTL_QLCR1                  :%#x\n"
		"MTL_QHCR7                  :%#x\n"
		"MTL_QHCR6                  :%#x\n"
		"MTL_QHCR5                  :%#x\n"
		"MTL_QHCR4                  :%#x\n"
		"MTL_QHCR3                  :%#x\n"
		"MTL_QHCR2                  :%#x\n"
		"MTL_QHCR1                  :%#x\n"
		"MTL_QSSCR7                 :%#x\n"
		"MTL_QSSCR6                 :%#x\n"
		"MTL_QSSCR5                 :%#x\n"
		"MTL_QSSCR4                 :%#x\n"
		"MTL_QSSCR3                 :%#x\n"
		"MTL_QSSCR2                 :%#x\n"
		"MTL_QSSCR1                 :%#x\n"
		"MTL_QW7                    :%#x\n"
		"MTL_QW6                    :%#x\n"
		"MTL_QW5                    :%#x\n"
		"MTL_QW4                    :%#x\n"
		"MTL_QW3                    :%#x\n"
		"MTL_QW2                    :%#x\n"
		"MTL_QW1                    :%#x\n"
		"MTL_QESR7                  :%#x\n"
		"MTL_QESR6                  :%#x\n"
		"MTL_QESR5                  :%#x\n"
		"MTL_QESR4                  :%#x\n"
		"MTL_QESR3                  :%#x\n"
		"MTL_QESR2                  :%#x\n"
		"MTL_QESR1                  :%#x\n"
		"MTL_QECR7                  :%#x\n"
		"MTL_QECR6                  :%#x\n"
		"MTL_QECR5                  :%#x\n"
		"MTL_QECR4                  :%#x\n"
		"MTL_QECR3                  :%#x\n"
		"MTL_QECR2                  :%#x\n"
		"MTL_QECR1                  :%#x\n"
		"MTL_QTDR7                  :%#x\n"
		"MTL_QTDR6                  :%#x\n"
		"MTL_QTDR5                  :%#x\n"
		"MTL_QTDR4                  :%#x\n"
		"MTL_QTDR3                  :%#x\n"
		"MTL_QTDR2                  :%#x\n"
		"MTL_QTDR1                  :%#x\n"
		"MTL_QUCR7                  :%#x\n"
		"MTL_QUCR6                  :%#x\n"
		"MTL_QUCR5                  :%#x\n"
		"MTL_QUCR4                  :%#x\n"
		"MTL_QUCR3                  :%#x\n"
		"MTL_QUCR2                  :%#x\n"
		"MTL_QUCR1                  :%#x\n"
		"MTL_QTOMR7                 :%#x\n"
		"MTL_QTOMR6                 :%#x\n"
		"MTL_QTOMR5                 :%#x\n"
		"MTL_QTOMR4                 :%#x\n"
		"MTL_QTOMR3                 :%#x\n"
		"MTL_QTOMR2                 :%#x\n"
		"MTL_QTOMR1                 :%#x\n"
		"MAC_PMTCSR                 :%#x\n"
		"MMC_RXICMP_ERR_OCTETS      :%#x\n"
		"MMC_RXICMP_GD_OCTETS       :%#x\n"
		"MMC_RXTCP_ERR_OCTETS       :%#x\n"
		"MMC_RXTCP_GD_OCTETS        :%#x\n"
		"MMC_RXUDP_ERR_OCTETS       :%#x\n"
		"MMC_RXUDP_GD_OCTETS        :%#x\n"
		"MMC_RXIPV6_NOPAY_OCTETS    :%#x\n"
		"MMC_RXIPV6_HDRERR_OCTETS   :%#x\n"
		"MMC_RXIPV6_GD_OCTETS       :%#x\n"
		"MMC_RXIPV4_UDSBL_OCTETS    :%#x\n"
		"MMC_RXIPV4_FRAG_OCTETS     :%#x\n"
		"MMC_RXIPV4_NOPAY_OCTETS    :%#x\n"
		"MMC_RXIPV4_HDRERR_OCTETS   :%#x\n"
		"MMC_RXIPV4_GD_OCTETS       :%#x\n"
		"MMC_RXICMP_ERR_PKTS        :%#x\n"
		"MMC_RXICMP_GD_PKTS         :%#x\n"
		"MMC_RXTCP_ERR_PKTS         :%#x\n"
		"MMC_RXTCP_GD_PKTS          :%#x\n"
		"MMC_RXUDP_ERR_PKTS         :%#x\n"
		"MMC_RXUDP_GD_PKTS          :%#x\n"
		"MMC_RXIPV6_NOPAY_PKTS      :%#x\n"
		"MMC_RXIPV6_HDRERR_PKTS     :%#x\n"
		"MMC_RXIPV6_GD_PKTS         :%#x\n"
		"MMC_RXIPV4_UBSBL_PKTS      :%#x\n"
		"MMC_RXIPV4_FRAG_PKTS       :%#x\n"
		"MMC_RXIPV4_NOPAY_PKTS      :%#x\n"
		"MMC_RXIPV4_HDRERR_PKTS     :%#x\n"
		"MMC_RXIPV4_GD_PKTS         :%#x\n"
		"MMC_RXCTRLPACKETS_G        :%#x\n"
		"MMC_RXRCVERROR             :%#x\n"
		"MMC_RXWATCHDOGERROR        :%#x\n"
		"MMC_RXVLANPACKETS_GB       :%#x\n"
		"MMC_RXFIFOOVERFLOW         :%#x\n"
		"MMC_RXPAUSEPACKETS         :%#x\n"
		"MMC_RXOUTOFRANGETYPE       :%#x\n"
		"MMC_RXLENGTHERROR          :%#x\n"
		"MMC_RXUNICASTPACKETS_G     :%#x\n"
		"MMC_RX1024TOMAXOCTETS_GB   :%#x\n"
		"MMC_RX512TO1023OCTETS_GB   :%#x\n"
		"MMC_RX256TO511OCTETS_GB    :%#x\n"
		"MMC_RX128TO255OCTETS_GB    :%#x\n"
		"MMC_RX65TO127OCTETS_GB     :%#x\n"
		"MMC_RX64OCTETS_GB          :%#x\n"
		"MMC_RXOVERSIZE_G           :%#x\n"
		"MMC_RXUNDERSIZE_G          :%#x\n"
		"MMC_RXJABBERERROR          :%#x\n"
		"MMC_RXRUNTERROR            :%#x\n"
		"MMC_RXALIGNMENTERROR       :%#x\n"
		"MMC_RXCRCERROR             :%#x\n"
		"MMC_RXMULTICASTPACKETS_G   :%#x\n"
		"MMC_RXBROADCASTPACKETS_G   :%#x\n"
		"MMC_RXOCTETCOUNT_G         :%#x\n"
		"MMC_RXOCTETCOUNT_GB        :%#x\n"
		"MMC_RXPACKETCOUNT_GB       :%#x\n"
		"MMC_TXOVERSIZE_G           :%#x\n"
		"MMC_TXVLANPACKETS_G        :%#x\n"
		"MMC_TXPAUSEPACKETS         :%#x\n"
		"MMC_TXEXCESSDEF            :%#x\n"
		"MMC_TXPACKETSCOUNT_G       :%#x\n"
		"MMC_TXOCTETCOUNT_G         :%#x\n"
		"MMC_TXCARRIERERROR         :%#x\n"
		"MMC_TXEXESSCOL             :%#x\n"
		"MMC_TXLATECOL              :%#x\n"
		"MMC_TXDEFERRED             :%#x\n"
		"MMC_TXMULTICOL_G           :%#x\n"
		"MMC_TXSINGLECOL_G          :%#x\n"
		"MMC_TXUNDERFLOWERROR       :%#x\n"
		"MMC_TXBROADCASTPACKETS_GB  :%#x\n"
		"MMC_TXMULTICASTPACKETS_GB  :%#x\n"
		"MMC_TXUNICASTPACKETS_GB    :%#x\n"
		"MMC_TX1024TOMAXOCTETS_GB   :%#x\n"
		"MMC_TX512TO1023OCTETS_GB   :%#x\n"
		"MMC_TX256TO511OCTETS_GB    :%#x\n"
		"MMC_TX128TO255OCTETS_GB    :%#x\n"
		"MMC_TX65TO127OCTETS_GB     :%#x\n"
		"MMC_TX64OCTETS_GB          :%#x\n"
		"MMC_TXMULTICASTPACKETS_G   :%#x\n"
		"MMC_TXBROADCASTPACKETS_G   :%#x\n"
		"MMC_TXPACKETCOUNT_GB       :%#x\n"
		"MMC_TXOCTETCOUNT_GB        :%#x\n"
		"MMC_IPC_INTR_RX            :%#x\n"
		"MMC_IPC_INTR_MASK_RX       :%#x\n"
		"MMC_INTR_MASK_TX           :%#x\n"
		"MMC_INTR_MASK_RX           :%#x\n"
		"MMC_INTR_TX                :%#x\n"
		"MMC_INTR_RX                :%#x\n"
		"MMC_CNTRL                  :%#x\n"
		"MAC_MA1LR                  :%#x\n"
		"MAC_MA1HR                  :%#x\n"
		"MAC_MA0LR                  :%#x\n"
		"MAC_MA0HR                  :%#x\n"
		"MAC_GPIOR                  :%#x\n"
		"MAC_GMIIDR                 :%#x\n"
		"MAC_GMIIAR                 :%#x\n"
		"MAC_HFR2                   :%#x\n"
		"MAC_HFR1                   :%#x\n"
		"MAC_HFR0                   :%#x\n"
		"MAC_MDR                    :%#x\n"
		"MAC_VR                     :%#x\n"
		"MAC_HTR7                   :%#x\n"
		"MAC_HTR6                   :%#x\n"
		"MAC_HTR5                   :%#x\n"
		"MAC_HTR4                   :%#x\n"
		"MAC_HTR3                   :%#x\n"
		"MAC_HTR2                   :%#x\n"
		"MAC_HTR1                   :%#x\n"
		"MAC_HTR0                   :%#x\n"
		"DMA_RIWTR7                 :%#x\n"
		"DMA_RIWTR6                 :%#x\n"
		"DMA_RIWTR5                 :%#x\n"
		"DMA_RIWTR4                 :%#x\n"
		"DMA_RIWTR3                 :%#x\n"
		"DMA_RIWTR2                 :%#x\n"
		"DMA_RIWTR1                 :%#x\n"
		"DMA_RIWTR0                 :%#x\n"
		"DMA_RDRLR7                 :%#x\n"
		"DMA_RDRLR6                 :%#x\n"
		"DMA_RDRLR5                 :%#x\n"
		"DMA_RDRLR4                 :%#x\n"
		"DMA_RDRLR3                 :%#x\n"
		"DMA_RDRLR2                 :%#x\n"
		"DMA_RDRLR1                 :%#x\n"
		"DMA_RDRLR0                 :%#x\n"
		"DMA_TDRLR7                 :%#x\n"
		"DMA_TDRLR6                 :%#x\n"
		"DMA_TDRLR5                 :%#x\n"
		"DMA_TDRLR4                 :%#x\n"
		"DMA_TDRLR3                 :%#x\n"
		"DMA_TDRLR2                 :%#x\n"
		"DMA_TDRLR1                 :%#x\n"
		"DMA_TDRLR0                 :%#x\n"
		"DMA_RDTP_RPDR7             :%#x\n"
		"DMA_RDTP_RPDR6             :%#x\n"
		"DMA_RDTP_RPDR5             :%#x\n"
		"DMA_RDTP_RPDR4             :%#x\n"
		"DMA_RDTP_RPDR3             :%#x\n"
		"DMA_RDTP_RPDR2             :%#x\n"
		"DMA_RDTP_RPDR1             :%#x\n"
		"DMA_RDTP_RPDR0             :%#x\n"
		"DMA_TDTP_TPDR7             :%#x\n"
		"DMA_TDTP_TPDR6             :%#x\n"
		"DMA_TDTP_TPDR5             :%#x\n"
		"DMA_TDTP_TPDR4             :%#x\n"
		"DMA_TDTP_TPDR3             :%#x\n"
		"DMA_TDTP_TPDR2             :%#x\n"
		"DMA_TDTP_TPDR1             :%#x\n"
		"DMA_TDTP_TPDR0             :%#x\n"
		"DMA_RDLAR7                 :%#x\n"
		"DMA_RDLAR6                 :%#x\n"
		"DMA_RDLAR5                 :%#x\n"
		"DMA_RDLAR4                 :%#x\n"
		"DMA_RDLAR3                 :%#x\n"
		"DMA_RDLAR2                 :%#x\n"
		"DMA_RDLAR1                 :%#x\n"
		"DMA_RDLAR0                 :%#x\n"
		"DMA_TDLAR7                 :%#x\n"
		"DMA_TDLAR6                 :%#x\n"
		"DMA_TDLAR5                 :%#x\n"
		"DMA_TDLAR4                 :%#x\n"
		"DMA_TDLAR3                 :%#x\n"
		"DMA_TDLAR2                 :%#x\n"
		"DMA_TDLAR1                 :%#x\n"
		"DMA_TDLAR0                 :%#x\n"
		"DMA_IER7                   :%#x\n"
		"DMA_IER6                   :%#x\n"
		"DMA_IER5                   :%#x\n"
		"DMA_IER4                   :%#x\n"
		"DMA_IER3                   :%#x\n"
		"DMA_IER2                   :%#x\n"
		"DMA_IER1                   :%#x\n"
		"DMA_IER0                   :%#x\n"
		"MAC_IMR                    :%#x\n"
		"MAC_ISR                    :%#x\n"
		"MTL_ISR                    :%#x\n"
		"DMA_SR7                    :%#x\n"
		"DMA_SR6                    :%#x\n"
		"DMA_SR5                    :%#x\n"
		"DMA_SR4                    :%#x\n"
		"DMA_SR3                    :%#x\n"
		"DMA_SR2                    :%#x\n"
		"DMA_SR1                    :%#x\n"
		"DMA_SR0                    :%#x\n"
		"DMA_ISR                    :%#x\n"
		"DMA_DSR2                   :%#x\n"
		"DMA_DSR1                   :%#x\n"
		"DMA_DSR0                   :%#x\n"
		"MTL_Q0RDR                  :%#x\n"
		"MTL_Q0ESR                  :%#x\n"
		"MTL_Q0TDR                  :%#x\n"
		"DMA_CHRBAR7                :%#x\n"
		"DMA_CHRBAR6                :%#x\n"
		"DMA_CHRBAR5                :%#x\n"
		"DMA_CHRBAR4                :%#x\n"
		"DMA_CHRBAR3                :%#x\n"
		"DMA_CHRBAR2                :%#x\n"
		"DMA_CHRBAR1                :%#x\n"
		"DMA_CHRBAR0                :%#x\n"
		"DMA_CHTBAR7                :%#x\n"
		"DMA_CHTBAR6                :%#x\n"
		"DMA_CHTBAR5                :%#x\n"
		"DMA_CHTBAR4                :%#x\n"
		"DMA_CHTBAR3                :%#x\n"
		"DMA_CHTBAR2                :%#x\n"
		"DMA_CHTBAR1                :%#x\n"
		"DMA_CHTBAR0                :%#x\n"
		"DMA_CHRDR7                 :%#x\n"
		"DMA_CHRDR6                 :%#x\n"
		"DMA_CHRDR5                 :%#x\n"
		"DMA_CHRDR4                 :%#x\n"
		"DMA_CHRDR3                 :%#x\n"
		"DMA_CHRDR2                 :%#x\n"
		"DMA_CHRDR1                 :%#x\n"
		"DMA_CHRDR0                 :%#x\n"
		"DMA_CHTDR7                 :%#x\n"
		"DMA_CHTDR6                 :%#x\n"
		"DMA_CHTDR5                 :%#x\n"
		"DMA_CHTDR4                 :%#x\n"
		"DMA_CHTDR3                 :%#x\n"
		"DMA_CHTDR2                 :%#x\n"
		"DMA_CHTDR1                 :%#x\n"
		"DMA_CHTDR0                 :%#x\n"
		"DMA_SFCSR7                 :%#x\n"
		"DMA_SFCSR6                 :%#x\n"
		"DMA_SFCSR5                 :%#x\n"
		"DMA_SFCSR4                 :%#x\n"
		"DMA_SFCSR3                 :%#x\n"
		"DMA_SFCSR2                 :%#x\n"
		"DMA_SFCSR1                 :%#x\n"
		"DMA_SFCSR0                 :%#x\n"
		"MAC_IVLANTIRR              :%#x\n"
		"MAC_VLANTIRR               :%#x\n"
		"MAC_VLANHTR                :%#x\n"
		"MAC_VLANTR                 :%#x\n"
		"DMA_SBUS                   :%#x\n"
		"DMA_BMR                    :%#x\n"
		"MTL_Q0RCR                  :%#x\n"
		"MTL_Q0OCR                  :%#x\n"
		"MTL_Q0ROMR                 :%#x\n"
		"MTL_Q0QR                   :%#x\n"
		"MTL_Q0ECR                  :%#x\n"
		"MTL_Q0UCR                  :%#x\n"
		"MTL_Q0TOMR                 :%#x\n"
		"MTL_RQDCM1R                :%#x\n"
		"MTL_RQDCM0R                :%#x\n"
		"MTL_FDDR                   :%#x\n"
		"MTL_FDACS                  :%#x\n"
		"MTL_OMR                    :%#x\n"
		"MAC_RQC3R                  :%#x\n"
		"MAC_RQC2R                  :%#x\n"
		"MAC_RQC1R                  :%#x\n"
		"MAC_RQC0R                  :%#x\n"
		"MAC_TQPM1R                 :%#x\n"
		"MAC_TQPM0R                 :%#x\n"
		"MAC_RFCR                   :%#x\n"
		"MAC_QTFCR7                 :%#x\n"
		"MAC_QTFCR6                 :%#x\n"
		"MAC_QTFCR5                 :%#x\n"
		"MAC_QTFCR4                 :%#x\n"
		"MAC_QTFCR3                 :%#x\n"
		"MAC_QTFCR2                 :%#x\n"
		"MAC_QTFCR1                 :%#x\n"
		"MAC_Q0TFCR                 :%#x\n"
		"DMA_AXI4CR7                :%#x\n"
		"DMA_AXI4CR6                :%#x\n"
		"DMA_AXI4CR5                :%#x\n"
		"DMA_AXI4CR4                :%#x\n"
		"DMA_AXI4CR3                :%#x\n"
		"DMA_AXI4CR2                :%#x\n"
		"DMA_AXI4CR1                :%#x\n"
		"DMA_AXI4CR0                :%#x\n"
		"DMA_RCR7                   :%#x\n"
		"DMA_RCR6                   :%#x\n"
		"DMA_RCR5                   :%#x\n"
		"DMA_RCR4                   :%#x\n"
		"DMA_RCR3                   :%#x\n"
		"DMA_RCR2                   :%#x\n"
		"DMA_RCR1                   :%#x\n"
		"DMA_RCR0                   :%#x\n"
		"DMA_TCR7                   :%#x\n"
		"DMA_TCR6                   :%#x\n"
		"DMA_TCR5                   :%#x\n"
		"DMA_TCR4                   :%#x\n"
		"DMA_TCR3                   :%#x\n"
		"DMA_TCR2                   :%#x\n"
		"DMA_TCR1                   :%#x\n"
		"DMA_TCR0                   :%#x\n"
		"DMA_CR7                    :%#x\n"
		"DMA_CR6                    :%#x\n"
		"DMA_CR5                    :%#x\n"
		"DMA_CR4                    :%#x\n"
		"DMA_CR3                    :%#x\n"
		"DMA_CR2                    :%#x\n"
		"DMA_CR1                    :%#x\n"
		"DMA_CR0                    :%#x\n"
		"MAC_WTR                    :%#x\n"
		"MAC_MPFR                   :%#x\n"
		"MAC_MECR                   :%#x\n"
		"MAC_MCR                    :%#x\n"
		"\nMII/GMII Registers\n\n"
		"Phy Control Reg(Basic Mode Control Reg)   : %#x\n"
		"Phy Status Reg(Basic Mode Status Reg)     : %#x\n"
		"Phy Id (PHYS ID 1)                        : %#x\n"
		"Phy Id (PHYS ID 2)                        : %#x\n"
		"Auto-nego Adv (Advertisement Control Reg) : %#x\n"
		"Auto-nego Lap (Link Partner Ability Reg)  : %#x\n"
		"Auto-nego Exp (Extension Reg)             : %#x\n"
		"Auto-nego Np                              : %#x\n"
		"Extended Status Reg                       : %#x\n"
		"1000 Ctl Reg (1000BASE-T Control Reg)     : %#x\n"
		"1000 Sts Reg (1000BASE-T Status)          : %#x\n"
		"PHY Ctl Reg                               : %#x\n"
		"PHY Sts Reg                               : %#x\n"
		"\n IP Features/Properties\n\n"
		"feature_drop_tx_pktburstcnt		   : %#x\n",
		MAC_MA32_127LR127_val,
		MAC_MA32_127LR126_val,
		MAC_MA32_127LR125_val,
		MAC_MA32_127LR124_val,
		MAC_MA32_127LR123_val,
		MAC_MA32_127LR122_val,
		MAC_MA32_127LR121_val,
		MAC_MA32_127LR120_val,
		MAC_MA32_127LR119_val,
		MAC_MA32_127LR118_val,
		MAC_MA32_127LR117_val,
		MAC_MA32_127LR116_val,
		MAC_MA32_127LR115_val,
		MAC_MA32_127LR114_val,
		MAC_MA32_127LR113_val,
		MAC_MA32_127LR112_val,
		MAC_MA32_127LR111_val,
		MAC_MA32_127LR110_val,
		MAC_MA32_127LR109_val,
		MAC_MA32_127LR108_val,
		MAC_MA32_127LR107_val,
		MAC_MA32_127LR106_val,
		MAC_MA32_127LR105_val,
		MAC_MA32_127LR104_val,
		MAC_MA32_127LR103_val,
		MAC_MA32_127LR102_val,
		MAC_MA32_127LR101_val,
		MAC_MA32_127LR100_val,
		MAC_MA32_127LR99_val,
		MAC_MA32_127LR98_val,
		MAC_MA32_127LR97_val,
		MAC_MA32_127LR96_val,
		MAC_MA32_127LR95_val,
		MAC_MA32_127LR94_val,
		MAC_MA32_127LR93_val,
		MAC_MA32_127LR92_val,
		MAC_MA32_127LR91_val,
		MAC_MA32_127LR90_val,
		MAC_MA32_127LR89_val,
		MAC_MA32_127LR88_val,
		MAC_MA32_127LR87_val,
		MAC_MA32_127LR86_val,
		MAC_MA32_127LR85_val,
		MAC_MA32_127LR84_val,
		MAC_MA32_127LR83_val,
		MAC_MA32_127LR82_val,
		MAC_MA32_127LR81_val,
		MAC_MA32_127LR80_val,
		MAC_MA32_127LR79_val,
		MAC_MA32_127LR78_val,
		MAC_MA32_127LR77_val,
		MAC_MA32_127LR76_val,
		MAC_MA32_127LR75_val,
		MAC_MA32_127LR74_val,
		MAC_MA32_127LR73_val,
		MAC_MA32_127LR72_val,
		MAC_MA32_127LR71_val,
		MAC_MA32_127LR70_val,
		MAC_MA32_127LR69_val,
		MAC_MA32_127LR68_val,
		MAC_MA32_127LR67_val,
		MAC_MA32_127LR66_val,
		MAC_MA32_127LR65_val,
		MAC_MA32_127LR64_val,
		MAC_MA32_127LR63_val,
		MAC_MA32_127LR62_val,
		MAC_MA32_127LR61_val,
		MAC_MA32_127LR60_val,
		MAC_MA32_127LR59_val,
		MAC_MA32_127LR58_val,
		MAC_MA32_127LR57_val,
		MAC_MA32_127LR56_val,
		MAC_MA32_127LR55_val,
		MAC_MA32_127LR54_val,
		MAC_MA32_127LR53_val,
		MAC_MA32_127LR52_val,
		MAC_MA32_127LR51_val,
		MAC_MA32_127LR50_val,
		MAC_MA32_127LR49_val,
		MAC_MA32_127LR48_val,
		MAC_MA32_127LR47_val,
		MAC_MA32_127LR46_val,
		MAC_MA32_127LR45_val,
		MAC_MA32_127LR44_val,
		MAC_MA32_127LR43_val,
		MAC_MA32_127LR42_val,
		MAC_MA32_127LR41_val,
		MAC_MA32_127LR40_val,
		MAC_MA32_127LR39_val,
		MAC_MA32_127LR38_val,
		MAC_MA32_127LR37_val,
		MAC_MA32_127LR36_val,
		MAC_MA32_127LR35_val,
		MAC_MA32_127LR34_val,
		MAC_MA32_127LR33_val,
		MAC_MA32_127LR32_val,
		MAC_MA32_127HR127_val,
		MAC_MA32_127HR126_val,
		MAC_MA32_127HR125_val,
		MAC_MA32_127HR124_val,
		MAC_MA32_127HR123_val,
		MAC_MA32_127HR122_val,
		MAC_MA32_127HR121_val,
		MAC_MA32_127HR120_val,
		MAC_MA32_127HR119_val,
		MAC_MA32_127HR118_val,
		MAC_MA32_127HR117_val,
		MAC_MA32_127HR116_val,
		MAC_MA32_127HR115_val,
		MAC_MA32_127HR114_val,
		MAC_MA32_127HR113_val,
		MAC_MA32_127HR112_val,
		MAC_MA32_127HR111_val,
		MAC_MA32_127HR110_val,
		MAC_MA32_127HR109_val,
		MAC_MA32_127HR108_val,
		MAC_MA32_127HR107_val,
		MAC_MA32_127HR106_val,
		MAC_MA32_127HR105_val,
		MAC_MA32_127HR104_val,
		MAC_MA32_127HR103_val,
		MAC_MA32_127HR102_val,
		MAC_MA32_127HR101_val,
		MAC_MA32_127HR100_val,
		MAC_MA32_127HR99_val,
		MAC_MA32_127HR98_val,
		MAC_MA32_127HR97_val,
		MAC_MA32_127HR96_val,
		MAC_MA32_127HR95_val,
		MAC_MA32_127HR94_val,
		MAC_MA32_127HR93_val,
		MAC_MA32_127HR92_val,
		MAC_MA32_127HR91_val,
		MAC_MA32_127HR90_val,
		MAC_MA32_127HR89_val,
		MAC_MA32_127HR88_val,
		MAC_MA32_127HR87_val,
		MAC_MA32_127HR86_val,
		MAC_MA32_127HR85_val,
		MAC_MA32_127HR84_val,
		MAC_MA32_127HR83_val,
		MAC_MA32_127HR82_val,
		MAC_MA32_127HR81_val,
		MAC_MA32_127HR80_val,
		MAC_MA32_127HR79_val,
		MAC_MA32_127HR78_val,
		MAC_MA32_127HR77_val,
		MAC_MA32_127HR76_val,
		MAC_MA32_127HR75_val,
		MAC_MA32_127HR74_val,
		MAC_MA32_127HR73_val,
		MAC_MA32_127HR72_val,
		MAC_MA32_127HR71_val,
		MAC_MA32_127HR70_val,
		MAC_MA32_127HR69_val,
		MAC_MA32_127HR68_val,
		MAC_MA32_127HR67_val,
		MAC_MA32_127HR66_val,
		MAC_MA32_127HR65_val,
		MAC_MA32_127HR64_val,
		MAC_MA32_127HR63_val,
		MAC_MA32_127HR62_val,
		MAC_MA32_127HR61_val,
		MAC_MA32_127HR60_val,
		MAC_MA32_127HR59_val,
		MAC_MA32_127HR58_val,
		MAC_MA32_127HR57_val,
		MAC_MA32_127HR56_val,
		MAC_MA32_127HR55_val,
		MAC_MA32_127HR54_val,
		MAC_MA32_127HR53_val,
		MAC_MA32_127HR52_val,
		MAC_MA32_127HR51_val,
		MAC_MA32_127HR50_val,
		MAC_MA32_127HR49_val,
		MAC_MA32_127HR48_val,
		MAC_MA32_127HR47_val,
		MAC_MA32_127HR46_val,
		MAC_MA32_127HR45_val,
		MAC_MA32_127HR44_val,
		MAC_MA32_127HR43_val,
		MAC_MA32_127HR42_val,
		MAC_MA32_127HR41_val,
		MAC_MA32_127HR40_val,
		MAC_MA32_127HR39_val,
		MAC_MA32_127HR38_val,
		MAC_MA32_127HR37_val,
		MAC_MA32_127HR36_val,
		MAC_MA32_127HR35_val,
		MAC_MA32_127HR34_val,
		MAC_MA32_127HR33_val,
		MAC_MA32_127HR32_val,
		MAC_MA1_31LR31_val,
		MAC_MA1_31LR30_val,
		MAC_MA1_31LR29_val,
		MAC_MA1_31LR28_val,
		MAC_MA1_31LR27_val,
		MAC_MA1_31LR26_val,
		MAC_MA1_31LR25_val,
		MAC_MA1_31LR24_val,
		MAC_MA1_31LR23_val,
		MAC_MA1_31LR22_val,
		MAC_MA1_31LR21_val,
		MAC_MA1_31LR20_val,
		MAC_MA1_31LR19_val,
		MAC_MA1_31LR18_val,
		MAC_MA1_31LR17_val,
		MAC_MA1_31LR16_val,
		MAC_MA1_31LR15_val,
		MAC_MA1_31LR14_val,
		MAC_MA1_31LR13_val,
		MAC_MA1_31LR12_val,
		MAC_MA1_31LR11_val,
		MAC_MA1_31LR10_val,
		MAC_MA1_31LR9_val,
		MAC_MA1_31LR8_val,
		MAC_MA1_31LR7_val,
		MAC_MA1_31LR6_val,
		MAC_MA1_31LR5_val,
		MAC_MA1_31LR4_val,
		MAC_MA1_31LR3_val,
		MAC_MA1_31LR2_val,
		MAC_MA1_31LR1_val,
		MAC_MA1_31HR31_val,
		MAC_MA1_31HR30_val,
		MAC_MA1_31HR29_val,
		MAC_MA1_31HR28_val,
		MAC_MA1_31HR27_val,
		MAC_MA1_31HR26_val,
		MAC_MA1_31HR25_val,
		MAC_MA1_31HR24_val,
		MAC_MA1_31HR23_val,
		MAC_MA1_31HR22_val,
		MAC_MA1_31HR21_val,
		MAC_MA1_31HR20_val,
		MAC_MA1_31HR19_val,
		MAC_MA1_31HR18_val,
		MAC_MA1_31HR17_val,
		MAC_MA1_31HR16_val,
		MAC_MA1_31HR15_val,
		MAC_MA1_31HR14_val,
		MAC_MA1_31HR13_val,
		MAC_MA1_31HR12_val,
		MAC_MA1_31HR11_val,
		MAC_MA1_31HR10_val,
		MAC_MA1_31HR9_val,
		MAC_MA1_31HR8_val,
		MAC_MA1_31HR7_val,
		MAC_MA1_31HR6_val,
		MAC_MA1_31HR5_val,
		MAC_MA1_31HR4_val,
		MAC_MA1_31HR3_val,
		MAC_MA1_31HR2_val,
		MAC_MA1_31HR1_val,
		MAC_ARPA_val,
		MAC_L3A3R7_val,
		MAC_L3A3R6_val,
		MAC_L3A3R5_val,
		MAC_L3A3R4_val,
		MAC_L3A3R3_val,
		MAC_L3A3R2_val,
		MAC_L3A3R1_val,
		MAC_L3A3R0_val,
		MAC_L3A2R7_val,
		MAC_L3A2R6_val,
		MAC_L3A2R5_val,
		MAC_L3A2R4_val,
		MAC_L3A2R3_val,
		MAC_L3A2R2_val,
		MAC_L3A2R1_val,
		MAC_L3A2R0_val,
		MAC_L3A1R7_val,
		MAC_L3A1R6_val,
		MAC_L3A1R5_val,
		MAC_L3A1R4_val,
		MAC_L3A1R3_val,
		MAC_L3A1R2_val,
		MAC_L3A1R1_val,
		MAC_L3A1R0_val,
		MAC_L3A0R7_val,
		MAC_L3A0R6_val,
		MAC_L3A0R5_val,
		MAC_L3A0R4_val,
		MAC_L3A0R3_val,
		MAC_L3A0R2_val,
		MAC_L3A0R1_val,
		MAC_L3A0R0_val,
		MAC_L4AR7_val,
		MAC_L4AR6_val,
		MAC_L4AR5_val,
		MAC_L4AR4_val,
		MAC_L4AR3_val,
		MAC_L4AR2_val,
		MAC_L4AR1_val,
		MAC_L4AR0_val,
		MAC_L3L4CR7_val,
		MAC_L3L4CR6_val,
		MAC_L3L4CR5_val,
		MAC_L3L4CR4_val,
		MAC_L3L4CR3_val,
		MAC_L3L4CR2_val,
		MAC_L3L4CR1_val,
		MAC_L3L4CR0_val,
		MAC_GPIOS_val,
		MAC_PCS_val,
		MAC_TES_val,
		MAC_AE_val,
		MAC_ALPA_val,
		MAC_AAD_val,
		MAC_ANS_val,
		MAC_ANC_val,
		MAC_LPC_val,
		MAC_LPS_val,
       	MAC_LMIR_val,
		MAC_SPI2R_val,
		MAC_SPI1R_val,
		MAC_SPI0R_val,
		MAC_PTO_CR_val,
		MAC_PPS_WIDTH3_val,
		MAC_PPS_WIDTH2_val,
		MAC_PPS_WIDTH1_val,
		MAC_PPS_WIDTH0_val,
		MAC_PPS_INTVAL3_val,
		MAC_PPS_INTVAL2_val,
		MAC_PPS_INTVAL1_val,
		MAC_PPS_INTVAL0_val,
		MAC_PPS_TTNS3_val,
		MAC_PPS_TTNS2_val,
		MAC_PPS_TTNS1_val,
		MAC_PPS_TTNS0_val,
		MAC_PPS_TTS3_val,
		MAC_PPS_TTS2_val,
		MAC_PPS_TTS1_val,
		MAC_PPS_TTS0_val,
		MAC_PPSC_val,
		MAC_TEAC_val,
		MAC_TIAC_val,
		MAC_ATS_val,
		MAC_ATN_val,
		MAC_AC_val,
		MAC_TTN_val,
		MAC_TTSN_val,
		MAC_TSR_val,
		MAC_STHWR_val,
		MAC_TAR_val,
		MAC_STNSUR_val,
		MAC_STSUR_val,
		MAC_STNSR_val,
		MAC_STSR_val,
		MAC_SSIR_val,
		MAC_TCR_val,
		MTL_DSR_val,
		MAC_RWPFFR_val,
		MAC_RTSR_val,
		MTL_IER_val,
		MTL_QRCR7_val,
		MTL_QRCR6_val,
		MTL_QRCR5_val,
		MTL_QRCR4_val,
		MTL_QRCR3_val,
		MTL_QRCR2_val,
		MTL_QRCR1_val,
		MTL_QRDR7_val,
		MTL_QRDR6_val,
		MTL_QRDR5_val,
		MTL_QRDR4_val,
		MTL_QRDR3_val,
		MTL_QRDR2_val,
		MTL_QRDR1_val,
		MTL_QOCR7_val,
		MTL_QOCR6_val,
		MTL_QOCR5_val,
		MTL_QOCR4_val,
		MTL_QOCR3_val,
		MTL_QOCR2_val,
		MTL_QOCR1_val,
		MTL_QROMR7_val,
		MTL_QROMR6_val,
		MTL_QROMR5_val,
		MTL_QROMR4_val,
		MTL_QROMR3_val,
		MTL_QROMR2_val,
		MTL_QROMR1_val,
		MTL_QLCR7_val,
		MTL_QLCR6_val,
		MTL_QLCR5_val,
		MTL_QLCR4_val,
		MTL_QLCR3_val,
		MTL_QLCR2_val,
		MTL_QLCR1_val,
		MTL_QHCR7_val,
		MTL_QHCR6_val,
		MTL_QHCR5_val,
		MTL_QHCR4_val,
		MTL_QHCR3_val,
		MTL_QHCR2_val,
		MTL_QHCR1_val,
		MTL_QSSCR7_val,
		MTL_QSSCR6_val,
		MTL_QSSCR5_val,
		MTL_QSSCR4_val,
		MTL_QSSCR3_val,
		MTL_QSSCR2_val,
		MTL_QSSCR1_val,
		MTL_QW7_val,
		MTL_QW6_val,
		MTL_QW5_val,
		MTL_QW4_val,
		MTL_QW3_val,
		MTL_QW2_val,
		MTL_QW1_val,
		MTL_QESR7_val,
		MTL_QESR6_val,
		MTL_QESR5_val,
		MTL_QESR4_val,
		MTL_QESR3_val,
		MTL_QESR2_val,
		MTL_QESR1_val,
		MTL_QECR7_val,
		MTL_QECR6_val,
		MTL_QECR5_val,
		MTL_QECR4_val,
		MTL_QECR3_val,
		MTL_QECR2_val,
		MTL_QECR1_val,
		MTL_QTDR7_val,
		MTL_QTDR6_val,
		MTL_QTDR5_val,
		MTL_QTDR4_val,
		MTL_QTDR3_val,
		MTL_QTDR2_val,
		MTL_QTDR1_val,
		MTL_QUCR7_val,
		MTL_QUCR6_val,
		MTL_QUCR5_val,
		MTL_QUCR4_val,
		MTL_QUCR3_val,
		MTL_QUCR2_val,
		MTL_QUCR1_val,
		MTL_QTOMR7_val,
		MTL_QTOMR6_val,
		MTL_QTOMR5_val,
		MTL_QTOMR4_val,
		MTL_QTOMR3_val,
		MTL_QTOMR2_val,
		MTL_QTOMR1_val,
		MAC_PMTCSR_val,
		MMC_RXICMP_ERR_OCTETS_val,
		MMC_RXICMP_GD_OCTETS_val,
		MMC_RXTCP_ERR_OCTETS_val,
		MMC_RXTCP_GD_OCTETS_val,
		MMC_RXUDP_ERR_OCTETS_val,
		MMC_RXUDP_GD_OCTETS_val,
		MMC_RXIPV6_NOPAY_OCTETS_val,
		MMC_RXIPV6_HDRERR_OCTETS_val,
		MMC_RXIPV6_GD_OCTETS_val,
		MMC_RXIPV4_UDSBL_OCTETS_val,
		MMC_RXIPV4_FRAG_OCTETS_val,
		MMC_RXIPV4_NOPAY_OCTETS_val,
		MMC_RXIPV4_HDRERR_OCTETS_val,
		MMC_RXIPV4_GD_OCTETS_val,
		MMC_RXICMP_ERR_PKTS_val,
		MMC_RXICMP_GD_PKTS_val,
		MMC_RXTCP_ERR_PKTS_val,
		MMC_RXTCP_GD_PKTS_val,
		MMC_RXUDP_ERR_PKTS_val,
		MMC_RXUDP_GD_PKTS_val,
		MMC_RXIPV6_NOPAY_PKTS_val,
		MMC_RXIPV6_HDRERR_PKTS_val,
		MMC_RXIPV6_GD_PKTS_val,
		MMC_RXIPV4_UBSBL_PKTS_val,
		MMC_RXIPV4_FRAG_PKTS_val,
		MMC_RXIPV4_NOPAY_PKTS_val,
		MMC_RXIPV4_HDRERR_PKTS_val,
		MMC_RXIPV4_GD_PKTS_val,
		MMC_RXCTRLPACKETS_G_val,
		MMC_RXRCVERROR_val,
		MMC_RXWATCHDOGERROR_val,
		MMC_RXVLANPACKETS_GB_val,
		MMC_RXFIFOOVERFLOW_val,
		MMC_RXPAUSEPACKETS_val,
		MMC_RXOUTOFRANGETYPE_val,
		MMC_RXLENGTHERROR_val,
		MMC_RXUNICASTPACKETS_G_val,
		MMC_RX1024TOMAXOCTETS_GB_val,
		MMC_RX512TO1023OCTETS_GB_val,
		MMC_RX256TO511OCTETS_GB_val,
		MMC_RX128TO255OCTETS_GB_val,
		MMC_RX65TO127OCTETS_GB_val,
		MMC_RX64OCTETS_GB_val,
		MMC_RXOVERSIZE_G_val,
		MMC_RXUNDERSIZE_G_val,
		MMC_RXJABBERERROR_val,
		MMC_RXRUNTERROR_val,
		MMC_RXALIGNMENTERROR_val,
		MMC_RXCRCERROR_val,
		MMC_RXMULTICASTPACKETS_G_val,
		MMC_RXBROADCASTPACKETS_G_val,
		MMC_RXOCTETCOUNT_G_val,
		MMC_RXOCTETCOUNT_GB_val,
		MMC_RXPACKETCOUNT_GB_val,
		MMC_TXOVERSIZE_G_val,
		MMC_TXVLANPACKETS_G_val,
		MMC_TXPAUSEPACKETS_val,
		MMC_TXEXCESSDEF_val,
		MMC_TXPACKETSCOUNT_G_val,
		MMC_TXOCTETCOUNT_G_val,
		MMC_TXCARRIERERROR_val,
		MMC_TXEXESSCOL_val,
		MMC_TXLATECOL_val,
		MMC_TXDEFERRED_val,
		MMC_TXMULTICOL_G_val,
		MMC_TXSINGLECOL_G_val,
		MMC_TXUNDERFLOWERROR_val,
		MMC_TXBROADCASTPACKETS_GB_val,
		MMC_TXMULTICASTPACKETS_GB_val,
		MMC_TXUNICASTPACKETS_GB_val,
		MMC_TX1024TOMAXOCTETS_GB_val,
		MMC_TX512TO1023OCTETS_GB_val,
		MMC_TX256TO511OCTETS_GB_val,
		MMC_TX128TO255OCTETS_GB_val,
		MMC_TX65TO127OCTETS_GB_val,
		MMC_TX64OCTETS_GB_val,
		MMC_TXMULTICASTPACKETS_G_val,
		MMC_TXBROADCASTPACKETS_G_val,
		MMC_TXPACKETCOUNT_GB_val,
		MMC_TXOCTETCOUNT_GB_val,
		MMC_IPC_INTR_RX_val,
		MMC_IPC_INTR_MASK_RX_val,
		MMC_INTR_MASK_TX_val,
		MMC_INTR_MASK_RX_val,
		MMC_INTR_TX_val,
		MMC_INTR_RX_val,
		MMC_CNTRL_val,
		MAC_MA1LR_val,
		MAC_MA1HR_val,
		MAC_MA0LR_val,
		MAC_MA0HR_val,
		MAC_GPIOR_val,
		MAC_GMIIDR_val,
		MAC_GMIIAR_val,
		MAC_HFR2_val,
		MAC_HFR1_val,
		MAC_HFR0_val,
		MAC_MDR_val,
		MAC_VR_val,
		MAC_HTR7_val,
		MAC_HTR6_val,
		MAC_HTR5_val,
		MAC_HTR4_val,
		MAC_HTR3_val,
		MAC_HTR2_val,
		MAC_HTR1_val,
		MAC_HTR0_val,
		DMA_RIWTR7_val,
		DMA_RIWTR6_val,
		DMA_RIWTR5_val,
		DMA_RIWTR4_val,
		DMA_RIWTR3_val,
		DMA_RIWTR2_val,
		DMA_RIWTR1_val,
		DMA_RIWTR0_val,
		DMA_RDRLR7_val,
		DMA_RDRLR6_val,
		DMA_RDRLR5_val,
		DMA_RDRLR4_val,
		DMA_RDRLR3_val,
		DMA_RDRLR2_val,
		DMA_RDRLR1_val,
		DMA_RDRLR0_val,
		DMA_TDRLR7_val,
		DMA_TDRLR6_val,
		DMA_TDRLR5_val,
		DMA_TDRLR4_val,
		DMA_TDRLR3_val,
		DMA_TDRLR2_val,
		DMA_TDRLR1_val,
		DMA_TDRLR0_val,
		DMA_RDTP_RPDR7_val,
		DMA_RDTP_RPDR6_val,
		DMA_RDTP_RPDR5_val,
		DMA_RDTP_RPDR4_val,
		DMA_RDTP_RPDR3_val,
		DMA_RDTP_RPDR2_val,
		DMA_RDTP_RPDR1_val,
		DMA_RDTP_RPDR0_val,
		DMA_TDTP_TPDR7_val,
		DMA_TDTP_TPDR6_val,
		DMA_TDTP_TPDR5_val,
		DMA_TDTP_TPDR4_val,
		DMA_TDTP_TPDR3_val,
		DMA_TDTP_TPDR2_val,
		DMA_TDTP_TPDR1_val,
		DMA_TDTP_TPDR0_val,
		DMA_RDLAR7_val,
		DMA_RDLAR6_val,
		DMA_RDLAR5_val,
		DMA_RDLAR4_val,
		DMA_RDLAR3_val,
		DMA_RDLAR2_val,
		DMA_RDLAR1_val,
		DMA_RDLAR0_val,
		DMA_TDLAR7_val,
		DMA_TDLAR6_val,
		DMA_TDLAR5_val,
		DMA_TDLAR4_val,
		DMA_TDLAR3_val,
		DMA_TDLAR2_val,
		DMA_TDLAR1_val,
		DMA_TDLAR0_val,
		DMA_IER7_val,
		DMA_IER6_val,
		DMA_IER5_val,
		DMA_IER4_val,
		DMA_IER3_val,
		DMA_IER2_val,
		DMA_IER1_val,
		DMA_IER0_val,
		MAC_IMR_val,
		MAC_ISR_val,
		MTL_ISR_val,
		DMA_SR7_val,
		DMA_SR6_val,
		DMA_SR5_val,
		DMA_SR4_val,
		DMA_SR3_val,
		DMA_SR2_val,
		DMA_SR1_val,
		DMA_SR0_val,
		DMA_ISR_val,
		DMA_DSR2_val,
		DMA_DSR1_val,
		DMA_DSR0_val,
		MTL_Q0RDR_val,
		MTL_Q0ESR_val,
		MTL_Q0TDR_val,
		DMA_CHRBAR7_val,
		DMA_CHRBAR6_val,
		DMA_CHRBAR5_val,
		DMA_CHRBAR4_val,
		DMA_CHRBAR3_val,
		DMA_CHRBAR2_val,
		DMA_CHRBAR1_val,
		DMA_CHRBAR0_val,
		DMA_CHTBAR7_val,
		DMA_CHTBAR6_val,
		DMA_CHTBAR5_val,
		DMA_CHTBAR4_val,
		DMA_CHTBAR3_val,
		DMA_CHTBAR2_val,
		DMA_CHTBAR1_val,
		DMA_CHTBAR0_val,
		DMA_CHRDR7_val,
		DMA_CHRDR6_val,
		DMA_CHRDR5_val,
		DMA_CHRDR4_val,
		DMA_CHRDR3_val,
		DMA_CHRDR2_val,
		DMA_CHRDR1_val,
		DMA_CHRDR0_val,
		DMA_CHTDR7_val,
		DMA_CHTDR6_val,
		DMA_CHTDR5_val,
		DMA_CHTDR4_val,
		DMA_CHTDR3_val,
		DMA_CHTDR2_val,
		DMA_CHTDR1_val,
		DMA_CHTDR0_val,
		DMA_SFCSR7_val,
		DMA_SFCSR6_val,
		DMA_SFCSR5_val,
		DMA_SFCSR4_val,
		DMA_SFCSR3_val,
		DMA_SFCSR2_val,
		DMA_SFCSR1_val,
		DMA_SFCSR0_val,
		MAC_IVLANTIRR_val,
		MAC_VLANTIRR_val,
		MAC_VLANHTR_val,
		MAC_VLANTR_val,
		DMA_SBUS_val,
		DMA_BMR_val,
		MTL_Q0RCR_val,
		MTL_Q0OCR_val,
		MTL_Q0ROMR_val,
		MTL_Q0QR_val,
		MTL_Q0ECR_val,
		MTL_Q0UCR_val,
		MTL_Q0TOMR_val,
		MTL_RQDCM1R_val,
		MTL_RQDCM0R_val,
		MTL_FDDR_val,
		MTL_FDACS_val,
		MTL_OMR_val,
		MAC_RQC3R_val,
		MAC_RQC2R_val,
		MAC_RQC1R_val,
		MAC_RQC0R_val,
		MAC_TQPM1R_val,
		MAC_TQPM0R_val,
		MAC_RFCR_val,
		MAC_QTFCR7_val,
		MAC_QTFCR6_val,
		MAC_QTFCR5_val,
		MAC_QTFCR4_val,
		MAC_QTFCR3_val,
		MAC_QTFCR2_val,
		MAC_QTFCR1_val,
		MAC_Q0TFCR_val,
		DMA_AXI4CR7_val,
		DMA_AXI4CR6_val,
		DMA_AXI4CR5_val,
		DMA_AXI4CR4_val,
		DMA_AXI4CR3_val,
		DMA_AXI4CR2_val,
		DMA_AXI4CR1_val,
		DMA_AXI4CR0_val,
		DMA_RCR7_val,
		DMA_RCR6_val,
		DMA_RCR5_val,
		DMA_RCR4_val,
		DMA_RCR3_val,
		DMA_RCR2_val,
		DMA_RCR1_val,
		DMA_RCR0_val,
		DMA_TCR7_val,
		DMA_TCR6_val,
		DMA_TCR5_val,
		DMA_TCR4_val,
		DMA_TCR3_val,
		DMA_TCR2_val,
		DMA_TCR1_val,
		DMA_TCR0_val,
		DMA_CR7_val,
		DMA_CR6_val,
		DMA_CR5_val,
		DMA_CR4_val,
		DMA_CR3_val,
		DMA_CR2_val,
		DMA_CR1_val,
		DMA_CR0_val,
		MAC_WTR_val,
		MAC_MPFR_val,
		MAC_MECR_val,
		MAC_MCR_val,
		MII_BMCR_REG_val,
		MII_BMSR_REG_val,
		MII_PHYSID1_REG_val,
		MII_PHYSID2_REG_val,
		MII_ADVERTISE_REG_val,
		MII_LPA_REG_val,
		MII_EXPANSION_REG_val,
		AUTO_NEGO_NP_REG_val,
		MII_ESTATUS_REG_val,
		MII_CTRL1000_REG_val,
		MII_STAT1000_REG_val,
		PHY_CTL_REG_val,
		PHY_STS_REG_val, feature_drop_tx_pktburstcnt_val);

	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(debug_buf);
	DBGPR("<-- registers_read\n");

	return ret;
}

static int debugfile_open(struct inode *inode, struct file *file)
{
	file->private_data = inode->i_private;

	return 0;
}

static const struct file_operations registers_fops = {
	.open = debugfile_open,
	.read = registers_read,
	.write = registers_write,
};

static ssize_t descriptor_write(struct file *file, const char __user * buf,
				size_t count, loff_t * ppos)
{
	DBGPR("--> registers_write\n");
	printk(KERN_INFO
	       "write operation not supported for descrptors: write error\n");
	DBGPR("<-- registers_write\n");

	return -1;
}

static ssize_t MAC_MA32_127LR127_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 127, MAC_MA32_127LR127_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR127            :%#x\n",
		MAC_MA32_127LR127_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR127_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR127_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR126_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 126, MAC_MA32_127LR126_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR126            :%#x\n",
		MAC_MA32_127LR126_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR126_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR126_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR125_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 125, MAC_MA32_127LR125_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR125            :%#x\n",
		MAC_MA32_127LR125_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR125_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR125_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR124_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 124, MAC_MA32_127LR124_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR124            :%#x\n",
		MAC_MA32_127LR124_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR124_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR124_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR123_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 123, MAC_MA32_127LR123_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR123            :%#x\n",
		MAC_MA32_127LR123_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR123_fops = {
	.read = MAC_MA32_127LR123_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR122_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 122, MAC_MA32_127LR122_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR122            :%#x\n",
		MAC_MA32_127LR122_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR122_fops = {
	.read = MAC_MA32_127LR122_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR121_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 121, MAC_MA32_127LR121_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR121            :%#x\n",
		MAC_MA32_127LR121_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR121_fops = {
	.read = MAC_MA32_127LR121_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR120_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 120, MAC_MA32_127LR120_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR120            :%#x\n",
		MAC_MA32_127LR120_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR120_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR120_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR119_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 119, MAC_MA32_127LR119_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR119            :%#x\n",
		MAC_MA32_127LR119_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR119_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR119_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR118_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 118, MAC_MA32_127LR118_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR118            :%#x\n",
		MAC_MA32_127LR118_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR118_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR118_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR117_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 117, MAC_MA32_127LR117_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR117            :%#x\n",
		MAC_MA32_127LR117_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR117_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR117_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR116_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 116, MAC_MA32_127LR116_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR116            :%#x\n",
		MAC_MA32_127LR116_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR116_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR116_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR115_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 115, MAC_MA32_127LR115_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR115            :%#x\n",
		MAC_MA32_127LR115_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR115_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR115_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR114_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 114, MAC_MA32_127LR114_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR114            :%#x\n",
		MAC_MA32_127LR114_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR114_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR114_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR113_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 113, MAC_MA32_127LR113_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR113            :%#x\n",
		MAC_MA32_127LR113_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR113_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR113_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR112_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 112, MAC_MA32_127LR112_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR112            :%#x\n",
		MAC_MA32_127LR112_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR112_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR112_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR111_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 111, MAC_MA32_127LR111_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR111            :%#x\n",
		MAC_MA32_127LR111_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR111_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR111_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR110_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 110, MAC_MA32_127LR110_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR110            :%#x\n",
		MAC_MA32_127LR110_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR110_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR110_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR109_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 109, MAC_MA32_127LR109_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR109            :%#x\n",
		MAC_MA32_127LR109_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR109_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR109_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR108_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 108, MAC_MA32_127LR108_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR108            :%#x\n",
		MAC_MA32_127LR108_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR108_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR108_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR107_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 107, MAC_MA32_127LR107_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR107            :%#x\n",
		MAC_MA32_127LR107_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR107_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR107_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR106_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 106, MAC_MA32_127LR106_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR106            :%#x\n",
		MAC_MA32_127LR106_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR106_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR106_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR105_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 105, MAC_MA32_127LR105_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR105            :%#x\n",
		MAC_MA32_127LR105_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR105_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR105_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR104_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 104, MAC_MA32_127LR104_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR104            :%#x\n",
		MAC_MA32_127LR104_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR104_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR104_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR103_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 103, MAC_MA32_127LR103_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR103            :%#x\n",
		MAC_MA32_127LR103_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR103_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR103_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR102_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 102, MAC_MA32_127LR102_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR102            :%#x\n",
		MAC_MA32_127LR102_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR102_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR102_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR101_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 101, MAC_MA32_127LR101_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR101            :%#x\n",
		MAC_MA32_127LR101_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR101_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR101_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR100_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 100, MAC_MA32_127LR100_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR100            :%#x\n",
		MAC_MA32_127LR100_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR100_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR100_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR99_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 99, MAC_MA32_127LR99_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR99            :%#x\n",
		MAC_MA32_127LR99_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR99_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR99_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR98_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 98, MAC_MA32_127LR98_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR98            :%#x\n",
		MAC_MA32_127LR98_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR98_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR98_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR97_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 97, MAC_MA32_127LR97_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR97            :%#x\n",
		MAC_MA32_127LR97_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR97_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR97_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR96_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 96, MAC_MA32_127LR96_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR96            :%#x\n",
		MAC_MA32_127LR96_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR96_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR96_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR95_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 95, MAC_MA32_127LR95_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR95            :%#x\n",
		MAC_MA32_127LR95_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR95_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR95_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR94_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 94, MAC_MA32_127LR94_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR94            :%#x\n",
		MAC_MA32_127LR94_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR94_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR94_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR93_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 93, MAC_MA32_127LR93_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR93            :%#x\n",
		MAC_MA32_127LR93_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR93_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR93_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR92_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 92, MAC_MA32_127LR92_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR92            :%#x\n",
		MAC_MA32_127LR92_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR92_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR92_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR91_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 91, MAC_MA32_127LR91_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR91            :%#x\n",
		MAC_MA32_127LR91_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR91_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR91_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR90_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 90, MAC_MA32_127LR90_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR90            :%#x\n",
		MAC_MA32_127LR90_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR90_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR90_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR89_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 89, MAC_MA32_127LR89_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR89            :%#x\n",
		MAC_MA32_127LR89_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR89_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR89_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR88_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 88, MAC_MA32_127LR88_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR88            :%#x\n",
		MAC_MA32_127LR88_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR88_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR88_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR87_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 87, MAC_MA32_127LR87_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR87            :%#x\n",
		MAC_MA32_127LR87_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR87_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR87_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR86_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 86, MAC_MA32_127LR86_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR86            :%#x\n",
		MAC_MA32_127LR86_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR86_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR86_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR85_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 85, MAC_MA32_127LR85_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR85            :%#x\n",
		MAC_MA32_127LR85_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR85_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR85_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR84_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 84, MAC_MA32_127LR84_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR84            :%#x\n",
		MAC_MA32_127LR84_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR84_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR84_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR83_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 83, MAC_MA32_127LR83_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR83            :%#x\n",
		MAC_MA32_127LR83_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR83_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR83_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR82_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 82, MAC_MA32_127LR82_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR82            :%#x\n",
		MAC_MA32_127LR82_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR82_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR82_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR81_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 81, MAC_MA32_127LR81_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR81            :%#x\n",
		MAC_MA32_127LR81_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR81_fops = {\
	.open = debugfile_open,
	.read = MAC_MA32_127LR81_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR80_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 80, MAC_MA32_127LR80_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR80            :%#x\n",
		MAC_MA32_127LR80_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR80_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR80_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR79_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 79, MAC_MA32_127LR79_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR79            :%#x\n",
		MAC_MA32_127LR79_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR79_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR79_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR78_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 78, MAC_MA32_127LR78_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR78            :%#x\n",
		MAC_MA32_127LR78_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR78_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR78_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR77_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 77, MAC_MA32_127LR77_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR77            :%#x\n",
		MAC_MA32_127LR77_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR77_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR77_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR76_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 76, MAC_MA32_127LR76_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR76            :%#x\n",
		MAC_MA32_127LR76_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR76_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR76_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR75_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 75, MAC_MA32_127LR75_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR75            :%#x\n",
		MAC_MA32_127LR75_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR75_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR75_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR74_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 74, MAC_MA32_127LR74_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR74            :%#x\n",
		MAC_MA32_127LR74_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR74_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR74_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR73_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 73, MAC_MA32_127LR73_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR73            :%#x\n",
		MAC_MA32_127LR73_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR73_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR73_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR72_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 72, MAC_MA32_127LR72_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR72            :%#x\n",
		MAC_MA32_127LR72_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR72_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR72_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR71_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 71, MAC_MA32_127LR71_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR71            :%#x\n",
		MAC_MA32_127LR71_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR71_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR71_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR70_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 70, MAC_MA32_127LR70_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR70            :%#x\n",
		MAC_MA32_127LR70_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR70_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR70_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR69_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 69, MAC_MA32_127LR69_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR69            :%#x\n",
		MAC_MA32_127LR69_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR69_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR69_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR68_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 68, MAC_MA32_127LR68_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR68            :%#x\n",
		MAC_MA32_127LR68_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR68_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR68_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR67_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 67, MAC_MA32_127LR67_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR67            :%#x\n",
		MAC_MA32_127LR67_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR67_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR67_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR66_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 66, MAC_MA32_127LR66_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR66            :%#x\n",
		MAC_MA32_127LR66_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR66_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR66_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR65_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 65, MAC_MA32_127LR65_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR65            :%#x\n",
		MAC_MA32_127LR65_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR65_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR65_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR64_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 64, MAC_MA32_127LR64_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR64            :%#x\n",
		MAC_MA32_127LR64_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR64_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR64_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR63_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 63, MAC_MA32_127LR63_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR63            :%#x\n",
		MAC_MA32_127LR63_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR63_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR63_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR62_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 62, MAC_MA32_127LR62_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR62            :%#x\n",
		MAC_MA32_127LR62_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR62_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR62_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR61_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 61, MAC_MA32_127LR61_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR61            :%#x\n",
		MAC_MA32_127LR61_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR61_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR61_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR60_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 60, MAC_MA32_127LR60_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR60            :%#x\n",
		MAC_MA32_127LR60_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR60_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR60_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR59_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 59, MAC_MA32_127LR59_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR59            :%#x\n",
		MAC_MA32_127LR59_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR59_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR59_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR58_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 58, MAC_MA32_127LR58_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR58            :%#x\n",
		MAC_MA32_127LR58_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR58_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR58_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR57_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 57, MAC_MA32_127LR57_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR57            :%#x\n",
		MAC_MA32_127LR57_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR57_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR57_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR56_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 56, MAC_MA32_127LR56_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR56            :%#x\n",
		MAC_MA32_127LR56_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR56_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR56_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR55_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 55, MAC_MA32_127LR55_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR55            :%#x\n",
		MAC_MA32_127LR55_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR55_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR55_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR54_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 54, MAC_MA32_127LR54_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR54            :%#x\n",
		MAC_MA32_127LR54_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR54_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR54_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR53_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 53, MAC_MA32_127LR53_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR53            :%#x\n",
		MAC_MA32_127LR53_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR53_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR53_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR52_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 52, MAC_MA32_127LR52_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR52            :%#x\n",
		MAC_MA32_127LR52_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR52_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR52_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR51_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 51, MAC_MA32_127LR51_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR51            :%#x\n",
		MAC_MA32_127LR51_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR51_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR51_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR50_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 50, MAC_MA32_127LR50_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR50            :%#x\n",
		MAC_MA32_127LR50_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR50_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR50_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR49_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 49, MAC_MA32_127LR49_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR49            :%#x\n",
		MAC_MA32_127LR49_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR49_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR49_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR48_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 48, MAC_MA32_127LR48_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR48            :%#x\n",
		MAC_MA32_127LR48_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR48_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR48_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR47_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 47, MAC_MA32_127LR47_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR47            :%#x\n",
		MAC_MA32_127LR47_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR47_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR47_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR46_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 46, MAC_MA32_127LR46_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR46            :%#x\n",
		MAC_MA32_127LR46_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR46_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR46_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR45_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 45, MAC_MA32_127LR45_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR45            :%#x\n",
		MAC_MA32_127LR45_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR45_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR45_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR44_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 44, MAC_MA32_127LR44_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR44            :%#x\n",
		MAC_MA32_127LR44_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR44_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR44_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR43_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 43, MAC_MA32_127LR43_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR43            :%#x\n",
		MAC_MA32_127LR43_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR43_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR43_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR42_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 42, MAC_MA32_127LR42_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR42            :%#x\n",
		MAC_MA32_127LR42_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR42_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR42_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR41_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 41, MAC_MA32_127LR41_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR41            :%#x\n",
		MAC_MA32_127LR41_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR41_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR41_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR40_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 40, MAC_MA32_127LR40_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR40            :%#x\n",
		MAC_MA32_127LR40_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR40_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR40_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR39_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 39, MAC_MA32_127LR39_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR39            :%#x\n",
		MAC_MA32_127LR39_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR39_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR39_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR38_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 38, MAC_MA32_127LR38_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR38            :%#x\n",
		MAC_MA32_127LR38_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR38_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR38_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR37_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 37, MAC_MA32_127LR37_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR37            :%#x\n",
		MAC_MA32_127LR37_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR37_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR37_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR36_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 36, MAC_MA32_127LR36_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR36            :%#x\n",
		MAC_MA32_127LR36_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR36_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR36_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR35_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 35, MAC_MA32_127LR35_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR35            :%#x\n",
		MAC_MA32_127LR35_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR35_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR35_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR34_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 34, MAC_MA32_127LR34_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR34            :%#x\n",
		MAC_MA32_127LR34_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR34_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR34_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR33_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 33, MAC_MA32_127LR33_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR33            :%#x\n",
		MAC_MA32_127LR33_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR33_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR33_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127LR32_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127LR_RgRd(pdata, 32, MAC_MA32_127LR32_val);
	sprintf(debugfs_buf, "MAC_MA32_127LR32            :%#x\n",
		MAC_MA32_127LR32_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127LR32_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127LR32_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR127_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 127, MAC_MA32_127HR127_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR127            :%#x\n",
		MAC_MA32_127HR127_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR127_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR127_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR126_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 126, MAC_MA32_127HR126_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR126            :%#x\n",
		MAC_MA32_127HR126_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR126_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR126_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR125_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 125, MAC_MA32_127HR125_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR125            :%#x\n",
		MAC_MA32_127HR125_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR125_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR125_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR124_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 124, MAC_MA32_127HR124_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR124            :%#x\n",
		MAC_MA32_127HR124_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR124_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR124_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR123_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 123, MAC_MA32_127HR123_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR123            :%#x\n",
		MAC_MA32_127HR123_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR123_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR123_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR122_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 122, MAC_MA32_127HR122_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR122            :%#x\n",
		MAC_MA32_127HR122_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR122_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR122_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR121_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 121, MAC_MA32_127HR121_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR121            :%#x\n",
		MAC_MA32_127HR121_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR121_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR121_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR120_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 120, MAC_MA32_127HR120_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR120            :%#x\n",
		MAC_MA32_127HR120_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR120_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR120_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR119_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 119, MAC_MA32_127HR119_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR119            :%#x\n",
		MAC_MA32_127HR119_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR119_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR119_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR118_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 118, MAC_MA32_127HR118_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR118            :%#x\n",
		MAC_MA32_127HR118_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR118_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR118_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR117_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 117, MAC_MA32_127HR117_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR117            :%#x\n",
		MAC_MA32_127HR117_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR117_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR117_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR116_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 116, MAC_MA32_127HR116_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR116            :%#x\n",
		MAC_MA32_127HR116_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR116_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR116_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR115_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 115, MAC_MA32_127HR115_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR115            :%#x\n",
		MAC_MA32_127HR115_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR115_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR115_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR114_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 114, MAC_MA32_127HR114_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR114            :%#x\n",
		MAC_MA32_127HR114_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR114_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR114_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR113_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 113, MAC_MA32_127HR113_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR113            :%#x\n",
		MAC_MA32_127HR113_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR113_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR113_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR112_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 112, MAC_MA32_127HR112_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR112            :%#x\n",
		MAC_MA32_127HR112_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR112_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR112_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR111_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 111, MAC_MA32_127HR111_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR111            :%#x\n",
		MAC_MA32_127HR111_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR111_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR111_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR110_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 110, MAC_MA32_127HR110_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR110            :%#x\n",
		MAC_MA32_127HR110_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR110_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR110_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR109_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 109, MAC_MA32_127HR109_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR109            :%#x\n",
		MAC_MA32_127HR109_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR109_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR109_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR108_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 108, MAC_MA32_127HR108_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR108            :%#x\n",
		MAC_MA32_127HR108_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR108_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR108_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR107_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 107, MAC_MA32_127HR107_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR107            :%#x\n",
		MAC_MA32_127HR107_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR107_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR107_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR106_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 106, MAC_MA32_127HR106_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR106            :%#x\n",
		MAC_MA32_127HR106_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR106_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR106_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR105_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 105, MAC_MA32_127HR105_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR105            :%#x\n",
		MAC_MA32_127HR105_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR105_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR105_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR104_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 104, MAC_MA32_127HR104_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR104            :%#x\n",
		MAC_MA32_127HR104_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR104_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR104_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR103_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 103, MAC_MA32_127HR103_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR103            :%#x\n",
		MAC_MA32_127HR103_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR103_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR103_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR102_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 102, MAC_MA32_127HR102_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR102            :%#x\n",
		MAC_MA32_127HR102_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR102_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR102_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR101_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 101, MAC_MA32_127HR101_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR101            :%#x\n",
		MAC_MA32_127HR101_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR101_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR101_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR100_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 100, MAC_MA32_127HR100_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR100            :%#x\n",
		MAC_MA32_127HR100_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR100_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR100_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR99_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 99, MAC_MA32_127HR99_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR99            :%#x\n",
		MAC_MA32_127HR99_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR99_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR99_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR98_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 98, MAC_MA32_127HR98_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR98            :%#x\n",
		MAC_MA32_127HR98_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR98_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR98_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR97_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 97, MAC_MA32_127HR97_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR97            :%#x\n",
		MAC_MA32_127HR97_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR97_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR97_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR96_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 96, MAC_MA32_127HR96_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR96            :%#x\n",
		MAC_MA32_127HR96_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR96_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR96_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR95_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 95, MAC_MA32_127HR95_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR95            :%#x\n",
		MAC_MA32_127HR95_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR95_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR95_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR94_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 94, MAC_MA32_127HR94_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR94            :%#x\n",
		MAC_MA32_127HR94_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR94_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR94_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR93_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 93, MAC_MA32_127HR93_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR93            :%#x\n",
		MAC_MA32_127HR93_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR93_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR93_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR92_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 92, MAC_MA32_127HR92_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR92            :%#x\n",
		MAC_MA32_127HR92_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR92_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR92_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR91_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 91, MAC_MA32_127HR91_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR91            :%#x\n",
		MAC_MA32_127HR91_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR91_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR91_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR90_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 90, MAC_MA32_127HR90_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR90            :%#x\n",
		MAC_MA32_127HR90_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR90_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR90_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR89_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 89, MAC_MA32_127HR89_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR89            :%#x\n",
		MAC_MA32_127HR89_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR89_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR89_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR88_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 88, MAC_MA32_127HR88_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR88            :%#x\n",
		MAC_MA32_127HR88_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR88_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR88_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR87_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 87, MAC_MA32_127HR87_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR87            :%#x\n",
		MAC_MA32_127HR87_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR87_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR87_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR86_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 86, MAC_MA32_127HR86_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR86            :%#x\n",
		MAC_MA32_127HR86_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR86_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR86_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR85_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 85, MAC_MA32_127HR85_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR85            :%#x\n",
		MAC_MA32_127HR85_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR85_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR85_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR84_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 84, MAC_MA32_127HR84_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR84            :%#x\n",
		MAC_MA32_127HR84_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR84_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR84_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR83_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 83, MAC_MA32_127HR83_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR83            :%#x\n",
		MAC_MA32_127HR83_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR83_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR83_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR82_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 82, MAC_MA32_127HR82_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR82            :%#x\n",
		MAC_MA32_127HR82_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR82_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR82_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR81_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 81, MAC_MA32_127HR81_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR81            :%#x\n",
		MAC_MA32_127HR81_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR81_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR81_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR80_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 80, MAC_MA32_127HR80_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR80            :%#x\n",
		MAC_MA32_127HR80_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR80_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR80_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR79_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 79, MAC_MA32_127HR79_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR79            :%#x\n",
		MAC_MA32_127HR79_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR79_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR79_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR78_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 78, MAC_MA32_127HR78_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR78            :%#x\n",
		MAC_MA32_127HR78_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR78_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR78_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR77_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 77, MAC_MA32_127HR77_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR77            :%#x\n",
		MAC_MA32_127HR77_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR77_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR77_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR76_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 76, MAC_MA32_127HR76_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR76            :%#x\n",
		MAC_MA32_127HR76_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR76_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR76_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR75_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 75, MAC_MA32_127HR75_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR75            :%#x\n",
		MAC_MA32_127HR75_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR75_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR75_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR74_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 74, MAC_MA32_127HR74_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR74            :%#x\n",
		MAC_MA32_127HR74_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR74_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR74_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR73_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 73, MAC_MA32_127HR73_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR73            :%#x\n",
		MAC_MA32_127HR73_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR73_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR73_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR72_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 72, MAC_MA32_127HR72_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR72            :%#x\n",
		MAC_MA32_127HR72_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR72_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR72_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR71_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 71, MAC_MA32_127HR71_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR71            :%#x\n",
		MAC_MA32_127HR71_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR71_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR71_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR70_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 70, MAC_MA32_127HR70_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR70            :%#x\n",
		MAC_MA32_127HR70_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR70_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR70_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR69_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 69, MAC_MA32_127HR69_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR69            :%#x\n",
		MAC_MA32_127HR69_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR69_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR69_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR68_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 68, MAC_MA32_127HR68_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR68            :%#x\n",
		MAC_MA32_127HR68_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR68_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR68_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR67_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 67, MAC_MA32_127HR67_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR67            :%#x\n",
		MAC_MA32_127HR67_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR67_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR67_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR66_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 66, MAC_MA32_127HR66_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR66            :%#x\n",
		MAC_MA32_127HR66_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR66_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR66_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR65_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 65, MAC_MA32_127HR65_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR65            :%#x\n",
		MAC_MA32_127HR65_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR65_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR65_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR64_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 64, MAC_MA32_127HR64_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR64            :%#x\n",
		MAC_MA32_127HR64_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR64_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR64_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR63_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 63, MAC_MA32_127HR63_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR63            :%#x\n",
		MAC_MA32_127HR63_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR63_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR63_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR62_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 62, MAC_MA32_127HR62_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR62            :%#x\n",
		MAC_MA32_127HR62_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR62_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR62_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR61_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 61, MAC_MA32_127HR61_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR61            :%#x\n",
		MAC_MA32_127HR61_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR61_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR61_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR60_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 60, MAC_MA32_127HR60_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR60            :%#x\n",
		MAC_MA32_127HR60_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR60_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR60_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR59_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 59, MAC_MA32_127HR59_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR59            :%#x\n",
		MAC_MA32_127HR59_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR59_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR59_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR58_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 58, MAC_MA32_127HR58_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR58            :%#x\n",
		MAC_MA32_127HR58_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR58_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR58_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR57_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 57, MAC_MA32_127HR57_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR57            :%#x\n",
		MAC_MA32_127HR57_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR57_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR57_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR56_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 56, MAC_MA32_127HR56_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR56            :%#x\n",
		MAC_MA32_127HR56_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR56_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR56_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR55_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 55, MAC_MA32_127HR55_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR55            :%#x\n",
		MAC_MA32_127HR55_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR55_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR55_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR54_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 54, MAC_MA32_127HR54_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR54            :%#x\n",
		MAC_MA32_127HR54_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR54_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR54_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR53_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 53, MAC_MA32_127HR53_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR53            :%#x\n",
		MAC_MA32_127HR53_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR53_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR53_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR52_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 52, MAC_MA32_127HR52_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR52            :%#x\n",
		MAC_MA32_127HR52_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR52_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR52_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR51_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 51, MAC_MA32_127HR51_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR51            :%#x\n",
		MAC_MA32_127HR51_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR51_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR51_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR50_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 50, MAC_MA32_127HR50_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR50            :%#x\n",
		MAC_MA32_127HR50_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR50_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR50_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR49_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 49, MAC_MA32_127HR49_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR49            :%#x\n",
		MAC_MA32_127HR49_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR49_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR49_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR48_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 48, MAC_MA32_127HR48_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR48            :%#x\n",
		MAC_MA32_127HR48_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR48_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR48_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR47_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 47, MAC_MA32_127HR47_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR47            :%#x\n",
		MAC_MA32_127HR47_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR47_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR47_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR46_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 46, MAC_MA32_127HR46_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR46            :%#x\n",
		MAC_MA32_127HR46_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR46_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR46_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR45_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 45, MAC_MA32_127HR45_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR45            :%#x\n",
		MAC_MA32_127HR45_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR45_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR45_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR44_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 44, MAC_MA32_127HR44_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR44            :%#x\n",
		MAC_MA32_127HR44_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR44_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR44_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR43_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 43, MAC_MA32_127HR43_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR43            :%#x\n",
		MAC_MA32_127HR43_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR43_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR43_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR42_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 42, MAC_MA32_127HR42_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR42            :%#x\n",
		MAC_MA32_127HR42_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR42_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR42_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR41_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 41, MAC_MA32_127HR41_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR41            :%#x\n",
		MAC_MA32_127HR41_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR41_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR41_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR40_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 40, MAC_MA32_127HR40_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR40            :%#x\n",
		MAC_MA32_127HR40_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR40_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR40_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR39_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 39, MAC_MA32_127HR39_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR39            :%#x\n",
		MAC_MA32_127HR39_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR39_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR39_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR38_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 38, MAC_MA32_127HR38_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR38            :%#x\n",
		MAC_MA32_127HR38_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR38_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR38_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR37_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 37, MAC_MA32_127HR37_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR37            :%#x\n",
		MAC_MA32_127HR37_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR37_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR37_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR36_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 36, MAC_MA32_127HR36_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR36            :%#x\n",
		MAC_MA32_127HR36_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR36_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR36_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR35_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 35, MAC_MA32_127HR35_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR35            :%#x\n",
		MAC_MA32_127HR35_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR35_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR35_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR34_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 34, MAC_MA32_127HR34_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR34            :%#x\n",
		MAC_MA32_127HR34_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR34_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR34_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR33_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 33, MAC_MA32_127HR33_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR33            :%#x\n",
		MAC_MA32_127HR33_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR33_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR33_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA32_127HR32_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA32_127HR_RgRd(pdata, 32, MAC_MA32_127HR32_val);
	sprintf(debugfs_buf, "MAC_MA32_127HR32            :%#x\n",
		MAC_MA32_127HR32_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA32_127HR32_fops = {
	.open = debugfile_open,
	.read = MAC_MA32_127HR32_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR31_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 31, MAC_MA1_31LR31_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR31              :%#x\n",
		MAC_MA1_31LR31_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR31_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR31_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR30_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 30, MAC_MA1_31LR30_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR30              :%#x\n",
		MAC_MA1_31LR30_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR30_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR30_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR29_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 29, MAC_MA1_31LR29_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR29              :%#x\n",
		MAC_MA1_31LR29_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR29_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR29_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR28_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 28, MAC_MA1_31LR28_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR28              :%#x\n",
		MAC_MA1_31LR28_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR28_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR28_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR27_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 27, MAC_MA1_31LR27_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR27              :%#x\n",
		MAC_MA1_31LR27_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR27_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR27_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR26_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 26, MAC_MA1_31LR26_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR26              :%#x\n",
		MAC_MA1_31LR26_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR26_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR26_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR25_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 25, MAC_MA1_31LR25_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR25              :%#x\n",
		MAC_MA1_31LR25_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR25_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR25_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR24_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 24, MAC_MA1_31LR24_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR24              :%#x\n",
		MAC_MA1_31LR24_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR24_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR24_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR23_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 23, MAC_MA1_31LR23_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR23              :%#x\n",
		MAC_MA1_31LR23_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR23_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR23_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR22_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 22, MAC_MA1_31LR22_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR22              :%#x\n",
		MAC_MA1_31LR22_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR22_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR22_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR21_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 21, MAC_MA1_31LR21_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR21              :%#x\n",
		MAC_MA1_31LR21_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR21_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR21_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR20_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 20, MAC_MA1_31LR20_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR20              :%#x\n",
		MAC_MA1_31LR20_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR20_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR20_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR19_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 19, MAC_MA1_31LR19_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR19              :%#x\n",
		MAC_MA1_31LR19_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR19_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR19_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR18_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 18, MAC_MA1_31LR18_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR18              :%#x\n",
		MAC_MA1_31LR18_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR18_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR18_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR17_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 17, MAC_MA1_31LR17_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR17              :%#x\n",
		MAC_MA1_31LR17_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR17_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR17_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR16_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 16, MAC_MA1_31LR16_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR16              :%#x\n",
		MAC_MA1_31LR16_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR16_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR16_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR15_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 15, MAC_MA1_31LR15_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR15              :%#x\n",
		MAC_MA1_31LR15_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR15_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR15_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR14_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 14, MAC_MA1_31LR14_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR14              :%#x\n",
		MAC_MA1_31LR14_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR14_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR14_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR13_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 13, MAC_MA1_31LR13_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR13              :%#x\n",
		MAC_MA1_31LR13_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR13_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR13_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR12_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 12, MAC_MA1_31LR12_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR12              :%#x\n",
		MAC_MA1_31LR12_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR12_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR12_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR11_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 11, MAC_MA1_31LR11_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR11              :%#x\n",
		MAC_MA1_31LR11_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR11_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR11_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR10_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 10, MAC_MA1_31LR10_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR10              :%#x\n",
		MAC_MA1_31LR10_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR10_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR10_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR9_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 9, MAC_MA1_31LR9_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR9              :%#x\n",
		MAC_MA1_31LR9_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR9_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR9_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR8_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 8, MAC_MA1_31LR8_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR8              :%#x\n",
		MAC_MA1_31LR8_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR8_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR8_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR7_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 7, MAC_MA1_31LR7_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR7              :%#x\n",
		MAC_MA1_31LR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR7_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR6_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 6, MAC_MA1_31LR6_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR6              :%#x\n",
		MAC_MA1_31LR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR6_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR5_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 5, MAC_MA1_31LR5_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR5              :%#x\n",
		MAC_MA1_31LR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR5_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR4_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 4, MAC_MA1_31LR4_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR4              :%#x\n",
		MAC_MA1_31LR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR4_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR3_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 3, MAC_MA1_31LR3_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR3              :%#x\n",
		MAC_MA1_31LR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR3_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR2_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 2, MAC_MA1_31LR2_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR2              :%#x\n",
		MAC_MA1_31LR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR2_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31LR1_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31LR_RgRd(pdata, 1, MAC_MA1_31LR1_val);
	sprintf(debugfs_buf, "MAC_MA1_31LR1              :%#x\n",
		MAC_MA1_31LR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31LR1_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31LR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR31_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 31, MAC_MA1_31HR31_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR31              :%#x\n",
		MAC_MA1_31HR31_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR31_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR31_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR30_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 30, MAC_MA1_31HR30_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR30              :%#x\n",
		MAC_MA1_31HR30_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR30_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR30_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR29_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 29, MAC_MA1_31HR29_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR29              :%#x\n",
		MAC_MA1_31HR29_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR29_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR29_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR28_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 28, MAC_MA1_31HR28_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR28              :%#x\n",
		MAC_MA1_31HR28_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR28_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR28_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR27_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 27, MAC_MA1_31HR27_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR27              :%#x\n",
		MAC_MA1_31HR27_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR27_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR27_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR26_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 26, MAC_MA1_31HR26_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR26              :%#x\n",
		MAC_MA1_31HR26_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR26_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR26_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR25_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 25, MAC_MA1_31HR25_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR25              :%#x\n",
		MAC_MA1_31HR25_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR25_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR25_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR24_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 24, MAC_MA1_31HR24_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR24              :%#x\n",
		MAC_MA1_31HR24_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR24_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR24_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR23_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 23, MAC_MA1_31HR23_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR23              :%#x\n",
		MAC_MA1_31HR23_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR23_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR23_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR22_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 22, MAC_MA1_31HR22_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR22              :%#x\n",
		MAC_MA1_31HR22_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR22_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR22_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR21_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 21, MAC_MA1_31HR21_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR21              :%#x\n",
		MAC_MA1_31HR21_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR21_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR21_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR20_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 20, MAC_MA1_31HR20_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR20              :%#x\n",
		MAC_MA1_31HR20_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR20_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR20_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR19_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 19, MAC_MA1_31HR19_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR19              :%#x\n",
		MAC_MA1_31HR19_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR19_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR19_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR18_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 18, MAC_MA1_31HR18_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR18              :%#x\n",
		MAC_MA1_31HR18_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR18_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR18_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR17_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 17, MAC_MA1_31HR17_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR17              :%#x\n",
		MAC_MA1_31HR17_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR17_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR17_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR16_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 16, MAC_MA1_31HR16_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR16              :%#x\n",
		MAC_MA1_31HR16_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR16_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR16_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR15_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 15, MAC_MA1_31HR15_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR15              :%#x\n",
		MAC_MA1_31HR15_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR15_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR15_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR14_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 14, MAC_MA1_31HR14_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR14              :%#x\n",
		MAC_MA1_31HR14_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR14_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR14_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR13_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 13, MAC_MA1_31HR13_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR13              :%#x\n",
		MAC_MA1_31HR13_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR13_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR13_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR12_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 12, MAC_MA1_31HR12_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR12              :%#x\n",
		MAC_MA1_31HR12_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR12_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR12_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR11_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 11, MAC_MA1_31HR11_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR11              :%#x\n",
		MAC_MA1_31HR11_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR11_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR11_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR10_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 10, MAC_MA1_31HR10_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR10              :%#x\n",
		MAC_MA1_31HR10_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR10_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR10_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR9_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 9, MAC_MA1_31HR9_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR9              :%#x\n",
		MAC_MA1_31HR9_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR9_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR9_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR8_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 8, MAC_MA1_31HR8_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR8              :%#x\n",
		MAC_MA1_31HR8_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR8_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR8_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR7_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 7, MAC_MA1_31HR7_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR7              :%#x\n",
		MAC_MA1_31HR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR7_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR6_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 6, MAC_MA1_31HR6_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR6              :%#x\n",
		MAC_MA1_31HR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR6_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR5_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 5, MAC_MA1_31HR5_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR5              :%#x\n",
		MAC_MA1_31HR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR5_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR4_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 4, MAC_MA1_31HR4_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR4              :%#x\n",
		MAC_MA1_31HR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR4_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR3_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 3, MAC_MA1_31HR3_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR3              :%#x\n",
		MAC_MA1_31HR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR3_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR2_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 2, MAC_MA1_31HR2_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR2              :%#x\n",
		MAC_MA1_31HR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR2_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1_31HR1_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1_31HR_RgRd(pdata, 1, MAC_MA1_31HR1_val);
	sprintf(debugfs_buf, "MAC_MA1_31HR1              :%#x\n",
		MAC_MA1_31HR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1_31HR1_fops = {
	.open = debugfile_open,
	.read = MAC_MA1_31HR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ARPA_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ARPA_RgRd(pdata, MAC_ARPA_val);
	sprintf(debugfs_buf, "MAC_ARPA                   :%#x\n", MAC_ARPA_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ARPA_fops = {
	.open = debugfile_open,
	.read = MAC_ARPA_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R7_RgRd(pdata, MAC_L3A3R7_val);
	sprintf(debugfs_buf, "MAC_L3A3R7                 :%#x\n",
		MAC_L3A3R7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R7_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R6_RgRd(pdata, MAC_L3A3R6_val);
	sprintf(debugfs_buf, "MAC_L3A3R6                 :%#x\n",
		MAC_L3A3R6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R6_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R5_RgRd(pdata, MAC_L3A3R5_val);
	sprintf(debugfs_buf, "MAC_L3A3R5                 :%#x\n",
		MAC_L3A3R5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R5_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R4_RgRd(pdata, MAC_L3A3R4_val);
	sprintf(debugfs_buf, "MAC_L3A3R4                 :%#x\n",
		MAC_L3A3R4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R4_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R3_RgRd(pdata, MAC_L3A3R3_val);
	sprintf(debugfs_buf, "MAC_L3A3R3                 :%#x\n",
		MAC_L3A3R3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R3_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R2_RgRd(pdata, MAC_L3A3R2_val);
	sprintf(debugfs_buf, "MAC_L3A3R2                 :%#x\n",
		MAC_L3A3R2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R2_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R1_RgRd(pdata, MAC_L3A3R1_val);
	sprintf(debugfs_buf, "MAC_L3A3R1                 :%#x\n",
		MAC_L3A3R1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R1_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A3R0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A3R0_RgRd(pdata, MAC_L3A3R0_val);
	sprintf(debugfs_buf, "MAC_L3A3R0                 :%#x\n",
		MAC_L3A3R0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A3R0_fops = {
	.open = debugfile_open,
	.read = MAC_L3A3R0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R7_RgRd(pdata, MAC_L3A2R7_val);
	sprintf(debugfs_buf, "MAC_L3A2R7                 :%#x\n",
		MAC_L3A2R7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R7_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R6_RgRd(pdata, MAC_L3A2R6_val);
	sprintf(debugfs_buf, "MAC_L3A2R6                 :%#x\n",
		MAC_L3A2R6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R6_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R5_RgRd(pdata, MAC_L3A2R5_val);
	sprintf(debugfs_buf, "MAC_L3A2R5                 :%#x\n",
		MAC_L3A2R5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R5_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R4_RgRd(pdata, MAC_L3A2R4_val);
	sprintf(debugfs_buf, "MAC_L3A2R4                 :%#x\n",
		MAC_L3A2R4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R4_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R3_RgRd(pdata, MAC_L3A2R3_val);
	sprintf(debugfs_buf, "MAC_L3A2R3                 :%#x\n",
		MAC_L3A2R3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R3_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R2_RgRd(pdata, MAC_L3A2R2_val);
	sprintf(debugfs_buf, "MAC_L3A2R2                 :%#x\n",
		MAC_L3A2R2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R2_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R1_RgRd(pdata, MAC_L3A2R1_val);
	sprintf(debugfs_buf, "MAC_L3A2R1                 :%#x\n",
		MAC_L3A2R1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R1_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A2R0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A2R0_RgRd(pdata, MAC_L3A2R0_val);
	sprintf(debugfs_buf, "MAC_L3A2R0                 :%#x\n",
		MAC_L3A2R0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A2R0_fops = {
	.open = debugfile_open,
	.read = MAC_L3A2R0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R7_RgRd(pdata, MAC_L3A1R7_val);
	sprintf(debugfs_buf, "MAC_L3A1R7                 :%#x\n",
		MAC_L3A1R7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R7_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R6_RgRd(pdata, MAC_L3A1R6_val);
	sprintf(debugfs_buf, "MAC_L3A1R6                 :%#x\n",
		MAC_L3A1R6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R6_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R5_RgRd(pdata, MAC_L3A1R5_val);
	sprintf(debugfs_buf, "MAC_L3A1R5                 :%#x\n",
		MAC_L3A1R5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R5_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R4_RgRd(pdata, MAC_L3A1R4_val);
	sprintf(debugfs_buf, "MAC_L3A1R4                 :%#x\n",
		MAC_L3A1R4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R4_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R3_RgRd(pdata, MAC_L3A1R3_val);
	sprintf(debugfs_buf, "MAC_L3A1R3                 :%#x\n",
		MAC_L3A1R3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R3_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R2_RgRd(pdata, MAC_L3A1R2_val);
	sprintf(debugfs_buf, "MAC_L3A1R2                 :%#x\n",
		MAC_L3A1R2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R2_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R1_RgRd(pdata, MAC_L3A1R1_val);
	sprintf(debugfs_buf, "MAC_L3A1R1                 :%#x\n",
		MAC_L3A1R1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R1_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A1R0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A1R0_RgRd(pdata, MAC_L3A1R0_val);
	sprintf(debugfs_buf, "MAC_L3A1R0                 :%#x\n",
		MAC_L3A1R0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A1R0_fops = {
	.open = debugfile_open,
	.read = MAC_L3A1R0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R7_RgRd(pdata, MAC_L3A0R7_val);
	sprintf(debugfs_buf, "MAC_L3A0R7                 :%#x\n",
		MAC_L3A0R7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R7_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R6_RgRd(pdata, MAC_L3A0R6_val);
	sprintf(debugfs_buf, "MAC_L3A0R6                 :%#x\n",
		MAC_L3A0R6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R6_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R5_RgRd(pdata, MAC_L3A0R5_val);
	sprintf(debugfs_buf, "MAC_L3A0R5                 :%#x\n",
		MAC_L3A0R5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R5_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R4_RgRd(pdata, MAC_L3A0R4_val);
	sprintf(debugfs_buf, "MAC_L3A0R4                 :%#x\n",
		MAC_L3A0R4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R4_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R3_RgRd(pdata, MAC_L3A0R3_val);
	sprintf(debugfs_buf, "MAC_L3A0R3                 :%#x\n",
		MAC_L3A0R3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R3_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R2_RgRd(pdata, MAC_L3A0R2_val);
	sprintf(debugfs_buf, "MAC_L3A0R2                 :%#x\n",
		MAC_L3A0R2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R2_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R1_RgRd(pdata, MAC_L3A0R1_val);
	sprintf(debugfs_buf, "MAC_L3A0R1                 :%#x\n",
		MAC_L3A0R1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R1_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3A0R0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3A0R0_RgRd(pdata, MAC_L3A0R0_val);
	sprintf(debugfs_buf, "MAC_L3A0R0                 :%#x\n",
		MAC_L3A0R0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3A0R0_fops = {
	.open = debugfile_open,
	.read = MAC_L3A0R0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR7_RgRd(pdata, MAC_L4AR7_val);
	sprintf(debugfs_buf, "MAC_L4AR7                 :%#x\n", MAC_L4AR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR7_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR6_RgRd(pdata, MAC_L4AR6_val);
	sprintf(debugfs_buf, "MAC_L4AR6                 :%#x\n", MAC_L4AR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR6_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR5_RgRd(pdata, MAC_L4AR5_val);
	sprintf(debugfs_buf, "MAC_L4AR5                 :%#x\n", MAC_L4AR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR5_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR4_RgRd(pdata, MAC_L4AR4_val);
	sprintf(debugfs_buf, "MAC_L4AR4                 :%#x\n", MAC_L4AR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR4_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR3_RgRd(pdata, MAC_L4AR3_val);
	sprintf(debugfs_buf, "MAC_L4AR3                 :%#x\n", MAC_L4AR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR3_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR2_RgRd(pdata, MAC_L4AR2_val);
	sprintf(debugfs_buf, "MAC_L4AR2                 :%#x\n", MAC_L4AR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR2_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR1_RgRd(pdata, MAC_L4AR1_val);
	sprintf(debugfs_buf, "MAC_L4AR1                 :%#x\n", MAC_L4AR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR1_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L4AR0_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L4AR0_RgRd(pdata, MAC_L4AR0_val);
	sprintf(debugfs_buf, "MAC_L4AR0                 :%#x\n", MAC_L4AR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L4AR0_fops = {
	.open = debugfile_open,
	.read = MAC_L4AR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR7_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR7_RgRd(pdata, MAC_L3L4CR7_val);
	sprintf(debugfs_buf, "MAC_L3L4CR7                :%#x\n",
		MAC_L3L4CR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR7_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR6_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR6_RgRd(pdata, MAC_L3L4CR6_val);
	sprintf(debugfs_buf, "MAC_L3L4CR6                :%#x\n",
		MAC_L3L4CR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR6_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR5_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR5_RgRd(pdata, MAC_L3L4CR5_val);
	sprintf(debugfs_buf, "MAC_L3L4CR5                :%#x\n",
		MAC_L3L4CR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR5_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR4_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR4_RgRd(pdata, MAC_L3L4CR4_val);
	sprintf(debugfs_buf, "MAC_L3L4CR4                :%#x\n",
		MAC_L3L4CR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR4_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR3_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR3_RgRd(pdata, MAC_L3L4CR3_val);
	sprintf(debugfs_buf, "MAC_L3L4CR3                :%#x\n",
		MAC_L3L4CR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR3_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR2_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR2_RgRd(pdata, MAC_L3L4CR2_val);
	sprintf(debugfs_buf, "MAC_L3L4CR2                :%#x\n",
		MAC_L3L4CR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR2_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR1_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR1_RgRd(pdata, MAC_L3L4CR1_val);
	sprintf(debugfs_buf, "MAC_L3L4CR1                :%#x\n",
		MAC_L3L4CR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR1_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_L3L4CR0_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_L3L4CR0_RgRd(pdata, MAC_L3L4CR0_val);
	sprintf(debugfs_buf, "MAC_L3L4CR0                :%#x\n",
		MAC_L3L4CR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_L3L4CR0_fops = {
	.open = debugfile_open,
	.read = MAC_L3L4CR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_GPIOS_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_GPIOS_RgRd(pdata, MAC_GPIOS_val);
	sprintf(debugfs_buf, "MAC_GPIOS                  :%#x\n",
		MAC_GPIOS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_GPIOS_fops = {
	.open = debugfile_open,
	.read = MAC_GPIOS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PCS_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PCS_RgRd(pdata, MAC_PCS_val);
	sprintf(debugfs_buf, "MAC_PCS                    :%#x\n", MAC_PCS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PCS_fops = {
	.open = debugfile_open,
	.read = MAC_PCS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TES_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TES_RgRd(pdata, MAC_TES_val);
	sprintf(debugfs_buf, "MAC_TES                    :%#x\n", MAC_TES_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TES_fops = {
	.open = debugfile_open,
	.read = MAC_TES_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_AE_read(struct file *file, char __user * userbuf,
			   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_AE_RgRd(pdata, MAC_AE_val);
	sprintf(debugfs_buf, "MAC_AE                     :%#x\n", MAC_AE_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_AE_fops = {
	.open = debugfile_open,
	.read = MAC_AE_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ALPA_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ALPA_RgRd(pdata, MAC_ALPA_val);
	sprintf(debugfs_buf, "MAC_ALPA                   :%#x\n", MAC_ALPA_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ALPA_fops = {
	.open = debugfile_open,
	.read = MAC_ALPA_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_AAD_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_AAD_RgRd(pdata, MAC_AAD_val);
	sprintf(debugfs_buf, "MAC_AAD                    :%#x\n", MAC_AAD_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_AAD_fops = {
	.open = debugfile_open,
	.read = MAC_AAD_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ANS_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ANS_RgRd(pdata, MAC_ANS_val);
	sprintf(debugfs_buf, "MAC_ANS                    :%#x\n", MAC_ANS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ANS_fops = {
	.open = debugfile_open,
	.read = MAC_ANS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ANC_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ANC_RgRd(pdata, MAC_ANC_val);
	sprintf(debugfs_buf, "MAC_ANC                    :%#x\n", MAC_ANC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ANC_fops = {
	.open = debugfile_open,
	.read = MAC_ANC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_LPC_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_LPC_RgRd(pdata, MAC_LPC_val);
	sprintf(debugfs_buf, "MAC_LPC                    :%#x\n", MAC_LPC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_LPC_fops = {
	.open = debugfile_open,
	.read = MAC_LPC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_LPS_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_LPS_RgRd(pdata, MAC_LPS_val);
	sprintf(debugfs_buf, "MAC_LPS                    :%#x\n", MAC_LPS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_LPS_fops = {
	.open = debugfile_open,
	.read = MAC_LPS_read,
	.write = DWC_ETH_QOS_write,
};


static ssize_t MAC_LMIR_read(struct file *file, char __user *userbuf,
		size_t count, loff_t *ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_LMIR_RgRd(pdata, MAC_LMIR_val);
	sprintf(debugfs_buf, "MAC_LMIR                  :%#x\n", MAC_LMIR_val);
	ret = simple_read_from_buffer(userbuf, count, ppos, debugfs_buf, strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_LMIR_fops = {
	.open = debugfile_open,
	.read = MAC_LMIR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_SPI2R_read(struct file *file, char __user *userbuf,
		size_t count, loff_t *ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_SPI2R_RgRd(pdata, MAC_SPI2R_val);
	sprintf(debugfs_buf, "MAC_SPI2R                  :%#x\n", MAC_SPI2R_val);
	ret = simple_read_from_buffer(userbuf, count, ppos, debugfs_buf, strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_SPI2R_fops = {
	.open = debugfile_open,
	.read = MAC_SPI2R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_SPI1R_read(struct file *file, char __user *userbuf,
		size_t count, loff_t *ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_SPI1R_RgRd(pdata, MAC_SPI1R_val);
	sprintf(debugfs_buf, "MAC_SPI1R                  :%#x\n", MAC_SPI1R_val);
	ret = simple_read_from_buffer(userbuf, count, ppos, debugfs_buf, strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_SPI1R_fops = {
	.open = debugfile_open,
	.read = MAC_SPI1R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_SPI0R_read(struct file *file, char __user *userbuf,
		size_t count, loff_t *ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_SPI0R_RgRd(pdata, MAC_SPI0R_val);
	sprintf(debugfs_buf, "MAC_SPI0R                  :%#x\n", MAC_SPI0R_val);
	ret = simple_read_from_buffer(userbuf, count, ppos, debugfs_buf, strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_SPI0R_fops = {
	.open = debugfile_open,
	.read = MAC_SPI0R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PTO_CR_read(struct file *file, char __user *userbuf,
		size_t count, loff_t *ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PTO_CR_RgRd(pdata, MAC_PTO_CR_val);
	sprintf(debugfs_buf, "MAC_PTO_CR                 :%#x\n", MAC_PTO_CR_val);
	ret = simple_read_from_buffer(userbuf, count, ppos, debugfs_buf, strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PTO_CR_fops = {
	.open = debugfile_open,
	.read = MAC_PTO_CR_read,
	.write = DWC_ETH_QOS_write,
};



static ssize_t MAC_PPS_WIDTH3_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_WIDTH3_RgRd(pdata, MAC_PPS_WIDTH3_val);
	sprintf(debugfs_buf, "MAC_PPS_WIDTH3             :%#x\n",
		MAC_PPS_WIDTH3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_WIDTH3_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_WIDTH3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_WIDTH2_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_WIDTH2_RgRd(pdata, MAC_PPS_WIDTH2_val);
	sprintf(debugfs_buf, "MAC_PPS_WIDTH2             :%#x\n",
		MAC_PPS_WIDTH2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_WIDTH2_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_WIDTH2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_WIDTH1_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_WIDTH1_RgRd(pdata, MAC_PPS_WIDTH1_val);
	sprintf(debugfs_buf, "MAC_PPS_WIDTH1             :%#x\n",
		MAC_PPS_WIDTH1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_WIDTH1_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_WIDTH1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_WIDTH0_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_WIDTH0_RgRd(pdata, MAC_PPS_WIDTH0_val);
	sprintf(debugfs_buf, "MAC_PPS_WIDTH0             :%#x\n",
		MAC_PPS_WIDTH0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_WIDTH0_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_WIDTH0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_INTVAL3_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_INTVAL3_RgRd(pdata, MAC_PPS_INTVAL3_val);
	sprintf(debugfs_buf, "MAC_PPS_INTVAL3            :%#x\n",
		MAC_PPS_INTVAL3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_INTVAL3_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_INTVAL3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_INTVAL2_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_INTVAL2_RgRd(pdata, MAC_PPS_INTVAL2_val);
	sprintf(debugfs_buf, "MAC_PPS_INTVAL2            :%#x\n",
		MAC_PPS_INTVAL2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_INTVAL2_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_INTVAL2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_INTVAL1_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_INTVAL1_RgRd(pdata, MAC_PPS_INTVAL1_val);
	sprintf(debugfs_buf, "MAC_PPS_INTVAL1            :%#x\n",
		MAC_PPS_INTVAL1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_INTVAL1_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_INTVAL1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_INTVAL0_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_INTVAL0_RgRd(pdata, MAC_PPS_INTVAL0_val);
	sprintf(debugfs_buf, "MAC_PPS_INTVAL0            :%#x\n",
		MAC_PPS_INTVAL0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_INTVAL0_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_INTVAL0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTNS3_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTNS3_RgRd(pdata, MAC_PPS_TTNS3_val);
	sprintf(debugfs_buf, "MAC_PPS_TTNS3              :%#x\n",
		MAC_PPS_TTNS3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTNS3_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTNS3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTNS2_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTNS2_RgRd(pdata, MAC_PPS_TTNS2_val);
	sprintf(debugfs_buf, "MAC_PPS_TTNS2              :%#x\n",
		MAC_PPS_TTNS2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTNS2_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTNS2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTNS1_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTNS1_RgRd(pdata, MAC_PPS_TTNS1_val);
	sprintf(debugfs_buf, "MAC_PPS_TTNS1              :%#x\n",
		MAC_PPS_TTNS1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTNS1_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTNS1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTNS0_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTNS0_RgRd(pdata, MAC_PPS_TTNS0_val);
	sprintf(debugfs_buf, "MAC_PPS_TTNS0              :%#x\n",
		MAC_PPS_TTNS0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTNS0_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTNS0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTS3_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTS3_RgRd(pdata, MAC_PPS_TTS3_val);
	sprintf(debugfs_buf, "MAC_PPS_TTS3               :%#x\n",
		MAC_PPS_TTS3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTS3_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTS3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTS2_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTS2_RgRd(pdata, MAC_PPS_TTS2_val);
	sprintf(debugfs_buf, "MAC_PPS_TTS2               :%#x\n",
		MAC_PPS_TTS2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTS2_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTS2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTS1_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTS1_RgRd(pdata, MAC_PPS_TTS1_val);
	sprintf(debugfs_buf, "MAC_PPS_TTS1               :%#x\n",
		MAC_PPS_TTS1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTS1_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTS1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPS_TTS0_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPS_TTS0_RgRd(pdata, MAC_PPS_TTS0_val);
	sprintf(debugfs_buf, "MAC_PPS_TTS0               :%#x\n",
		MAC_PPS_TTS0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPS_TTS0_fops = {
	.open = debugfile_open,
	.read = MAC_PPS_TTS0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PPSC_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PPSC_RgRd(pdata, MAC_PPSC_val);
	sprintf(debugfs_buf, "MAC_PPSC                   :%#x\n", MAC_PPSC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PPSC_fops = {
	.open = debugfile_open,
	.read = MAC_PPSC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TEAC_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TEAC_RgRd(pdata, MAC_TEAC_val);
	sprintf(debugfs_buf, "MAC_TEAC                   :%#x\n", MAC_TEAC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TEAC_fops = {
	.open = debugfile_open,
	.read = MAC_TEAC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TIAC_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TIAC_RgRd(pdata, MAC_TIAC_val);
	sprintf(debugfs_buf, "MAC_TIAC                   :%#x\n", MAC_TIAC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TIAC_fops = {
	.open = debugfile_open,
	.read = MAC_TIAC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ATS_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ATS_RgRd(pdata, MAC_ATS_val);
	sprintf(debugfs_buf, "MAC_ATS                    :%#x\n", MAC_ATS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ATS_fops = {
	.open = debugfile_open,
	.read = MAC_ATS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ATN_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ATN_RgRd(pdata, MAC_ATN_val);
	sprintf(debugfs_buf, "MAC_ATN                    :%#x\n", MAC_ATN_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ATN_fops = {
	.open = debugfile_open,
	.read = MAC_ATN_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_AC_read(struct file *file, char __user * userbuf,
			   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_AC_RgRd(pdata, MAC_AC_val);
	sprintf(debugfs_buf, "MAC_AC                     :%#x\n", MAC_AC_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_AC_fops = {
	.open = debugfile_open,
	.read = MAC_AC_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TTN_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TTN_RgRd(pdata, MAC_TTN_val);
	sprintf(debugfs_buf, "MAC_TTN                    :%#x\n", MAC_TTN_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TTN_fops = {
	.open = debugfile_open,
	.read = MAC_TTN_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TTSN_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TTSN_RgRd(pdata, MAC_TTSN_val);
	sprintf(debugfs_buf, "MAC_TTSN                   :%#x\n", MAC_TTSN_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TTSN_fops = {
	.open = debugfile_open,
	.read = MAC_TTSN_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TSR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TSR_RgRd(pdata, MAC_TSR_val);
	sprintf(debugfs_buf, "MAC_TSR                    :%#x\n", MAC_TSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TSR_fops = {
	.open = debugfile_open,
	.read = MAC_TSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_STHWR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_STHWR_RgRd(pdata, MAC_STHWR_val);
	sprintf(debugfs_buf, "MAC_STHWR                  :%#x\n",
		MAC_STHWR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_STHWR_fops = {
	.open = debugfile_open,
	.read = MAC_STHWR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TAR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TAR_RgRd(pdata, MAC_TAR_val);
	sprintf(debugfs_buf, "MAC_TAR                    :%#x\n", MAC_TAR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TAR_fops = {
	.open = debugfile_open,
	.read = MAC_TAR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_STNSUR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_STNSUR_RgRd(pdata, MAC_STNSUR_val);
	sprintf(debugfs_buf, "MAC_STNSUR                 :%#x\n",
		MAC_STNSUR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_STNSUR_fops = {
	.open = debugfile_open,
	.read = MAC_STNSUR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_STSUR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_STSUR_RgRd(pdata, MAC_STSUR_val);
	sprintf(debugfs_buf, "MAC_STSUR                  :%#x\n",
		MAC_STSUR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_STSUR_fops = {
	.open = debugfile_open,
	.read = MAC_STSUR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_STNSR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_STNSR_RgRd(pdata, MAC_STNSR_val);
	sprintf(debugfs_buf, "MAC_STNSR                  :%#x\n",
		MAC_STNSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_STNSR_fops = {
	.open = debugfile_open,
	.read = MAC_STNSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_STSR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_STSR_RgRd(pdata, MAC_STSR_val);
	sprintf(debugfs_buf, "MAC_STSR                   :%#x\n", MAC_STSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_STSR_fops = {
	.open = debugfile_open,
	.read = MAC_STSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_SSIR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_SSIR_RgRd(pdata, MAC_SSIR_val);
	sprintf(debugfs_buf, "MAC_SSIR                   :%#x\n", MAC_SSIR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_SSIR_fops = {
	.open = debugfile_open,
	.read = MAC_SSIR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TCR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TCR_RgRd(pdata, MAC_TCR_val);
	sprintf(debugfs_buf, "MAC_TCR                    :%#x\n", MAC_TCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TCR_fops = {
	.open = debugfile_open,
	.read = MAC_TCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_DSR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_DSR_RgRd(pdata, MTL_DSR_val);
	sprintf(debugfs_buf, "MTL_DSR                    :%#x\n", MTL_DSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_DSR_fops = {
	.open = debugfile_open,
	.read = MTL_DSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RWPFFR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RWPFFR_RgRd(pdata, MAC_RWPFFR_val);
	sprintf(debugfs_buf, "MAC_RWPFFR                 :%#x\n",
		MAC_RWPFFR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RWPFFR_fops = {
	.open = debugfile_open,
	.read = MAC_RWPFFR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RTSR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RTSR_RgRd(pdata, MAC_RTSR_val);
	sprintf(debugfs_buf, "MAC_RTSR                   :%#x\n", MAC_RTSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RTSR_fops = {
	.open = debugfile_open,
	.read = MAC_RTSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_IER_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_IER_RgRd(pdata, MTL_IER_val);
	sprintf(debugfs_buf, "MTL_IER                    :%#x\n", MTL_IER_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_IER_fops = {
	.open = debugfile_open,
	.read = MTL_IER_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR7_RgRd(pdata, MTL_QRCR7_val);
	sprintf(debugfs_buf, "MTL_QRCR7                  :%#x\n",
		MTL_QRCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR6_RgRd(pdata, MTL_QRCR6_val);
	sprintf(debugfs_buf, "MTL_QRCR6                  :%#x\n",
		MTL_QRCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR5_RgRd(pdata, MTL_QRCR5_val);
	sprintf(debugfs_buf, "MTL_QRCR5                  :%#x\n",
		MTL_QRCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR4_RgRd(pdata, MTL_QRCR4_val);
	sprintf(debugfs_buf, "MTL_QRCR4                  :%#x\n",
		MTL_QRCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR3_RgRd(pdata, MTL_QRCR3_val);
	sprintf(debugfs_buf, "MTL_QRCR3                  :%#x\n",
		MTL_QRCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR2_RgRd(pdata, MTL_QRCR2_val);
	sprintf(debugfs_buf, "MTL_QRCR2                  :%#x\n",
		MTL_QRCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRCR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRCR1_RgRd(pdata, MTL_QRCR1_val);
	sprintf(debugfs_buf, "MTL_QRCR1                  :%#x\n",
		MTL_QRCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QRCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR7_RgRd(pdata, MTL_QRDR7_val);
	sprintf(debugfs_buf, "MTL_QRDR7                  :%#x\n",
		MTL_QRDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR7_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR6_RgRd(pdata, MTL_QRDR6_val);
	sprintf(debugfs_buf, "MTL_QRDR6                  :%#x\n",
		MTL_QRDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR6_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR5_RgRd(pdata, MTL_QRDR5_val);
	sprintf(debugfs_buf, "MTL_QRDR5                  :%#x\n",
		MTL_QRDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR5_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR4_RgRd(pdata, MTL_QRDR4_val);
	sprintf(debugfs_buf, "MTL_QRDR4                  :%#x\n",
		MTL_QRDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR4_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR3_RgRd(pdata, MTL_QRDR3_val);
	sprintf(debugfs_buf, "MTL_QRDR3                  :%#x\n",
		MTL_QRDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR3_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR2_RgRd(pdata, MTL_QRDR2_val);
	sprintf(debugfs_buf, "MTL_QRDR2                  :%#x\n",
		MTL_QRDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR2_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QRDR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QRDR1_RgRd(pdata, MTL_QRDR1_val);
	sprintf(debugfs_buf, "MTL_QRDR1                  :%#x\n",
		MTL_QRDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QRDR1_fops = {
	.open = debugfile_open,
	.read = MTL_QRDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR7_RgRd(pdata, MTL_QOCR7_val);
	sprintf(debugfs_buf, "MTL_QOCR7                  :%#x\n",
		MTL_QOCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR6_RgRd(pdata, MTL_QOCR6_val);
	sprintf(debugfs_buf, "MTL_QOCR6                  :%#x\n",
		MTL_QOCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR5_RgRd(pdata, MTL_QOCR5_val);
	sprintf(debugfs_buf, "MTL_QOCR5                  :%#x\n",
		MTL_QOCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR4_RgRd(pdata, MTL_QOCR4_val);
	sprintf(debugfs_buf, "MTL_QOCR4                  :%#x\n",
		MTL_QOCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR3_RgRd(pdata, MTL_QOCR3_val);
	sprintf(debugfs_buf, "MTL_QOCR3                  :%#x\n",
		MTL_QOCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR2_RgRd(pdata, MTL_QOCR2_val);
	sprintf(debugfs_buf, "MTL_QOCR2                  :%#x\n",
		MTL_QOCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QOCR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QOCR1_RgRd(pdata, MTL_QOCR1_val);
	sprintf(debugfs_buf, "MTL_QOCR1                  :%#x\n",
		MTL_QOCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QOCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QOCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 7, MTL_QROMR7_val);
	sprintf(debugfs_buf, "MTL_QROMR7                 :%#x\n",
		MTL_QROMR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR7_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 6, MTL_QROMR6_val);
	sprintf(debugfs_buf, "MTL_QROMR6                 :%#x\n",
		MTL_QROMR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR6_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 5, MTL_QROMR5_val);
	sprintf(debugfs_buf, "MTL_QROMR5                 :%#x\n",
		MTL_QROMR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR5_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 4, MTL_QROMR4_val);
	sprintf(debugfs_buf, "MTL_QROMR4                 :%#x\n",
		MTL_QROMR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR4_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 3, MTL_QROMR3_val);
	sprintf(debugfs_buf, "MTL_QROMR3                 :%#x\n",
		MTL_QROMR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR3_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 2, MTL_QROMR2_val);
	sprintf(debugfs_buf, "MTL_QROMR2                 :%#x\n",
		MTL_QROMR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR2_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QROMR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QROMR_RgRd(pdata, 1, MTL_QROMR1_val);
	sprintf(debugfs_buf, "MTL_QROMR1                 :%#x\n",
		MTL_QROMR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QROMR1_fops = {
	.open = debugfile_open,
	.read = MTL_QROMR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR7_RgRd(pdata, MTL_QLCR7_val);
	sprintf(debugfs_buf, "MTL_QLCR7                  :%#x\n",
		MTL_QLCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR6_RgRd(pdata, MTL_QLCR6_val);
	sprintf(debugfs_buf, "MTL_QLCR6                  :%#x\n",
		MTL_QLCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR5_RgRd(pdata, MTL_QLCR5_val);
	sprintf(debugfs_buf, "MTL_QLCR5                  :%#x\n",
		MTL_QLCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR4_RgRd(pdata, MTL_QLCR4_val);
	sprintf(debugfs_buf, "MTL_QLCR4                  :%#x\n",
		MTL_QLCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR3_RgRd(pdata, MTL_QLCR3_val);
	sprintf(debugfs_buf, "MTL_QLCR3                  :%#x\n",
		MTL_QLCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR2_RgRd(pdata, MTL_QLCR2_val);
	sprintf(debugfs_buf, "MTL_QLCR2                  :%#x\n",
		MTL_QLCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QLCR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QLCR1_RgRd(pdata, MTL_QLCR1_val);
	sprintf(debugfs_buf, "MTL_QLCR1                  :%#x\n",
		MTL_QLCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QLCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QLCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR7_RgRd(pdata, MTL_QHCR7_val);
	sprintf(debugfs_buf, "MTL_QHCR7                  :%#x\n",
		MTL_QHCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR6_RgRd(pdata, MTL_QHCR6_val);
	sprintf(debugfs_buf, "MTL_QHCR6                  :%#x\n",
		MTL_QHCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR5_RgRd(pdata, MTL_QHCR5_val);
	sprintf(debugfs_buf, "MTL_QHCR5                  :%#x\n",
		MTL_QHCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR4_RgRd(pdata, MTL_QHCR4_val);
	sprintf(debugfs_buf, "MTL_QHCR4                  :%#x\n",
		MTL_QHCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR3_RgRd(pdata, MTL_QHCR3_val);
	sprintf(debugfs_buf, "MTL_QHCR3                  :%#x\n",
		MTL_QHCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR2_RgRd(pdata, MTL_QHCR2_val);
	sprintf(debugfs_buf, "MTL_QHCR2                  :%#x\n",
		MTL_QHCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QHCR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QHCR1_RgRd(pdata, MTL_QHCR1_val);
	sprintf(debugfs_buf, "MTL_QHCR1                  :%#x\n",
		MTL_QHCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QHCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QHCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR7_RgRd(pdata, MTL_QSSCR7_val);
	sprintf(debugfs_buf, "MTL_QSSCR7                 :%#x\n",
		MTL_QSSCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR6_RgRd(pdata, MTL_QSSCR6_val);
	sprintf(debugfs_buf, "MTL_QSSCR6                 :%#x\n",
		MTL_QSSCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR5_RgRd(pdata, MTL_QSSCR5_val);
	sprintf(debugfs_buf, "MTL_QSSCR5                 :%#x\n",
		MTL_QSSCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR4_RgRd(pdata, MTL_QSSCR4_val);
	sprintf(debugfs_buf, "MTL_QSSCR4                 :%#x\n",
		MTL_QSSCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR3_RgRd(pdata, MTL_QSSCR3_val);
	sprintf(debugfs_buf, "MTL_QSSCR3                 :%#x\n",
		MTL_QSSCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR2_RgRd(pdata, MTL_QSSCR2_val);
	sprintf(debugfs_buf, "MTL_QSSCR2                 :%#x\n",
		MTL_QSSCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QSSCR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QSSCR1_RgRd(pdata, MTL_QSSCR1_val);
	sprintf(debugfs_buf, "MTL_QSSCR1                 :%#x\n",
		MTL_QSSCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QSSCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QSSCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW7_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW7_RgRd(pdata, MTL_QW7_val);
	sprintf(debugfs_buf, "MTL_QW7                    :%#x\n", MTL_QW7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW7_fops = {
	.open = debugfile_open,
	.read = MTL_QW7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW6_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW6_RgRd(pdata, MTL_QW6_val);
	sprintf(debugfs_buf, "MTL_QW6                    :%#x\n", MTL_QW6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW6_fops = {
	.open = debugfile_open,
	.read = MTL_QW6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW5_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW5_RgRd(pdata, MTL_QW5_val);
	sprintf(debugfs_buf, "MTL_QW5                    :%#x\n", MTL_QW5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW5_fops = {
	.open = debugfile_open,
	.read = MTL_QW5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW4_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW4_RgRd(pdata, MTL_QW4_val);
	sprintf(debugfs_buf, "MTL_QW4                    :%#x\n", MTL_QW4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW4_fops = {
	.open = debugfile_open,
	.read = MTL_QW4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW3_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW3_RgRd(pdata, MTL_QW3_val);
	sprintf(debugfs_buf, "MTL_QW3                    :%#x\n", MTL_QW3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW3_fops = {
	.open = debugfile_open,
	.read = MTL_QW3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW2_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW2_RgRd(pdata, MTL_QW2_val);
	sprintf(debugfs_buf, "MTL_QW2                    :%#x\n", MTL_QW2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW2_fops = {
	.open = debugfile_open,
	.read = MTL_QW2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QW1_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QW1_RgRd(pdata, MTL_QW1_val);
	sprintf(debugfs_buf, "MTL_QW1                    :%#x\n", MTL_QW1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QW1_fops = {
	.open = debugfile_open,
	.read = MTL_QW1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR7_RgRd(pdata, MTL_QESR7_val);
	sprintf(debugfs_buf, "MTL_QESR7                  :%#x\n",
		MTL_QESR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR7_fops = {
	.open = debugfile_open,
	.read = MTL_QESR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR6_RgRd(pdata, MTL_QESR6_val);
	sprintf(debugfs_buf, "MTL_QESR6                  :%#x\n",
		MTL_QESR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR6_fops = {
	.open = debugfile_open,
	.read = MTL_QESR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR5_RgRd(pdata, MTL_QESR5_val);
	sprintf(debugfs_buf, "MTL_QESR5                  :%#x\n",
		MTL_QESR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR5_fops = {
	.open = debugfile_open,
	.read = MTL_QESR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR4_RgRd(pdata, MTL_QESR4_val);
	sprintf(debugfs_buf, "MTL_QESR4                  :%#x\n",
		MTL_QESR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR4_fops = {
	.open = debugfile_open,
	.read = MTL_QESR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR3_RgRd(pdata, MTL_QESR3_val);
	sprintf(debugfs_buf, "MTL_QESR3                  :%#x\n",
		MTL_QESR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR3_fops = {
	.open = debugfile_open,
	.read = MTL_QESR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR2_RgRd(pdata, MTL_QESR2_val);
	sprintf(debugfs_buf, "MTL_QESR2                  :%#x\n",
		MTL_QESR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR2_fops = {
	.open = debugfile_open,
	.read = MTL_QESR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QESR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QESR1_RgRd(pdata, MTL_QESR1_val);
	sprintf(debugfs_buf, "MTL_QESR1                  :%#x\n",
		MTL_QESR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QESR1_fops = {
	.open = debugfile_open,
	.read = MTL_QESR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR7_RgRd(pdata, MTL_QECR7_val);
	sprintf(debugfs_buf, "MTL_QECR7                  :%#x\n",
		MTL_QECR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR7_fops = {
	.open = debugfile_open,
	.read = MTL_QECR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR6_RgRd(pdata, MTL_QECR6_val);
	sprintf(debugfs_buf, "MTL_QECR6                  :%#x\n",
		MTL_QECR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR6_fops = {
	.open = debugfile_open,
	.read = MTL_QECR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR5_RgRd(pdata, MTL_QECR5_val);
	sprintf(debugfs_buf, "MTL_QECR5                  :%#x\n",
		MTL_QECR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR5_fops = {
	.open = debugfile_open,
	.read = MTL_QECR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR4_RgRd(pdata, MTL_QECR4_val);
	sprintf(debugfs_buf, "MTL_QECR4                  :%#x\n",
		MTL_QECR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR4_fops = {
	.open = debugfile_open,
	.read = MTL_QECR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR3_RgRd(pdata, MTL_QECR3_val);
	sprintf(debugfs_buf, "MTL_QECR3                  :%#x\n",
		MTL_QECR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR3_fops = {
	.open = debugfile_open,
	.read = MTL_QECR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR2_RgRd(pdata, MTL_QECR2_val);
	sprintf(debugfs_buf, "MTL_QECR2                  :%#x\n",
		MTL_QECR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR2_fops = {
	.open = debugfile_open,
	.read = MTL_QECR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QECR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QECR1_RgRd(pdata, MTL_QECR1_val);
	sprintf(debugfs_buf, "MTL_QECR1                  :%#x\n",
		MTL_QECR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QECR1_fops = {
	.open = debugfile_open,
	.read = MTL_QECR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR7_RgRd(pdata, MTL_QTDR7_val);
	sprintf(debugfs_buf, "MTL_QTDR7                  :%#x\n",
		MTL_QTDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR7_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR6_RgRd(pdata, MTL_QTDR6_val);
	sprintf(debugfs_buf, "MTL_QTDR6                  :%#x\n",
		MTL_QTDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR6_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR5_RgRd(pdata, MTL_QTDR5_val);
	sprintf(debugfs_buf, "MTL_QTDR5                  :%#x\n",
		MTL_QTDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR5_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR4_RgRd(pdata, MTL_QTDR4_val);
	sprintf(debugfs_buf, "MTL_QTDR4                  :%#x\n",
		MTL_QTDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR4_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR3_RgRd(pdata, MTL_QTDR3_val);
	sprintf(debugfs_buf, "MTL_QTDR3                  :%#x\n",
		MTL_QTDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR3_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR2_RgRd(pdata, MTL_QTDR2_val);
	sprintf(debugfs_buf, "MTL_QTDR2                  :%#x\n",
		MTL_QTDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR2_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTDR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTDR1_RgRd(pdata, MTL_QTDR1_val);
	sprintf(debugfs_buf, "MTL_QTDR1                  :%#x\n",
		MTL_QTDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTDR1_fops = {
	.open = debugfile_open,
	.read = MTL_QTDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR7_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR7_RgRd(pdata, MTL_QUCR7_val);
	sprintf(debugfs_buf, "MTL_QUCR7                  :%#x\n",
		MTL_QUCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR7_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR6_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR6_RgRd(pdata, MTL_QUCR6_val);
	sprintf(debugfs_buf, "MTL_QUCR6                  :%#x\n",
		MTL_QUCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR6_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR5_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR5_RgRd(pdata, MTL_QUCR5_val);
	sprintf(debugfs_buf, "MTL_QUCR5                  :%#x\n",
		MTL_QUCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR5_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR4_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR4_RgRd(pdata, MTL_QUCR4_val);
	sprintf(debugfs_buf, "MTL_QUCR4                  :%#x\n",
		MTL_QUCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR4_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR3_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR3_RgRd(pdata, MTL_QUCR3_val);
	sprintf(debugfs_buf, "MTL_QUCR3                  :%#x\n",
		MTL_QUCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR3_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR2_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR2_RgRd(pdata, MTL_QUCR2_val);
	sprintf(debugfs_buf, "MTL_QUCR2                  :%#x\n",
		MTL_QUCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR2_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QUCR1_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QUCR1_RgRd(pdata, MTL_QUCR1_val);
	sprintf(debugfs_buf, "MTL_QUCR1                  :%#x\n",
		MTL_QUCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QUCR1_fops = {
	.open = debugfile_open,
	.read = MTL_QUCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR7_RgRd(pdata, MTL_QTOMR7_val);
	sprintf(debugfs_buf, "MTL_QTOMR7                 :%#x\n",
		MTL_QTOMR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR7_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR6_RgRd(pdata, MTL_QTOMR6_val);
	sprintf(debugfs_buf, "MTL_QTOMR6                 :%#x\n",
		MTL_QTOMR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR6_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR5_RgRd(pdata, MTL_QTOMR5_val);
	sprintf(debugfs_buf, "MTL_QTOMR5                 :%#x\n",
		MTL_QTOMR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR5_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR4_RgRd(pdata, MTL_QTOMR4_val);
	sprintf(debugfs_buf, "MTL_QTOMR4                 :%#x\n",
		MTL_QTOMR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR4_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR3_RgRd(pdata, MTL_QTOMR3_val);
	sprintf(debugfs_buf, "MTL_QTOMR3                 :%#x\n",
		MTL_QTOMR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR3_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR2_RgRd(pdata, MTL_QTOMR2_val);
	sprintf(debugfs_buf, "MTL_QTOMR2                 :%#x\n",
		MTL_QTOMR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR2_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_QTOMR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_QTOMR1_RgRd(pdata, MTL_QTOMR1_val);
	sprintf(debugfs_buf, "MTL_QTOMR1                 :%#x\n",
		MTL_QTOMR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_QTOMR1_fops = {
	.open = debugfile_open,
	.read = MTL_QTOMR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_PMTCSR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_PMTCSR_RgRd(pdata, MAC_PMTCSR_val);
	sprintf(debugfs_buf, "MAC_PMTCSR                 :%#x\n",
		MAC_PMTCSR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_PMTCSR_fops = {
	.open = debugfile_open,
	.read = MAC_PMTCSR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXICMP_ERR_OCTETS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXICMP_ERR_OCTETS_RgRd(pdata, MMC_RXICMP_ERR_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXICMP_ERR_OCTETS      :%#x\n",
		MMC_RXICMP_ERR_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXICMP_ERR_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXICMP_ERR_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXICMP_GD_OCTETS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXICMP_GD_OCTETS_RgRd(pdata, MMC_RXICMP_GD_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXICMP_GD_OCTETS       :%#x\n",
		MMC_RXICMP_GD_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXICMP_GD_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXICMP_GD_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXTCP_ERR_OCTETS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXTCP_ERR_OCTETS_RgRd(pdata, MMC_RXTCP_ERR_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXTCP_ERR_OCTETS       :%#x\n",
		MMC_RXTCP_ERR_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXTCP_ERR_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXTCP_ERR_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXTCP_GD_OCTETS_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXTCP_GD_OCTETS_RgRd(pdata, MMC_RXTCP_GD_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXTCP_GD_OCTETS        :%#x\n",
		MMC_RXTCP_GD_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXTCP_GD_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXTCP_GD_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUDP_ERR_OCTETS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUDP_ERR_OCTETS_RgRd(pdata, MMC_RXUDP_ERR_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXUDP_ERR_OCTETS       :%#x\n",
		MMC_RXUDP_ERR_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUDP_ERR_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXUDP_ERR_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUDP_GD_OCTETS_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUDP_GD_OCTETS_RgRd(pdata, MMC_RXUDP_GD_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXUDP_GD_OCTETS        :%#x\n",
		MMC_RXUDP_GD_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUDP_GD_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXUDP_GD_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_NOPAY_OCTETS_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_NOPAY_OCTETS_RgRd(pdata, MMC_RXIPV6_NOPAY_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_NOPAY_OCTETS    :%#x\n",
		MMC_RXIPV6_NOPAY_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_NOPAY_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_NOPAY_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_HDRERR_OCTETS_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_HDRERR_OCTETS_RgRd(pdata, MMC_RXIPV6_HDRERR_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_HDRERR_OCTETS   :%#x\n",
		MMC_RXIPV6_HDRERR_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_HDRERR_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_HDRERR_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_GD_OCTETS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_GD_OCTETS_RgRd(pdata, MMC_RXIPV6_GD_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_GD_OCTETS       :%#x\n",
		MMC_RXIPV6_GD_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_GD_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_GD_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_UDSBL_OCTETS_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_UDSBL_OCTETS_RgRd(pdata, MMC_RXIPV4_UDSBL_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_UDSBL_OCTETS    :%#x\n",
		MMC_RXIPV4_UDSBL_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_UDSBL_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_UDSBL_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_FRAG_OCTETS_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_FRAG_OCTETS_RgRd(pdata, MMC_RXIPV4_FRAG_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_FRAG_OCTETS     :%#x\n",
		MMC_RXIPV4_FRAG_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_FRAG_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_FRAG_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_NOPAY_OCTETS_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_NOPAY_OCTETS_RgRd(pdata, MMC_RXIPV4_NOPAY_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_NOPAY_OCTETS    :%#x\n",
		MMC_RXIPV4_NOPAY_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_NOPAY_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_NOPAY_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_HDRERR_OCTETS_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_HDRERR_OCTETS_RgRd(pdata, MMC_RXIPV4_HDRERR_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_HDRERR_OCTETS   :%#x\n",
		MMC_RXIPV4_HDRERR_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_HDRERR_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_HDRERR_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_GD_OCTETS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_GD_OCTETS_RgRd(pdata, MMC_RXIPV4_GD_OCTETS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_GD_OCTETS       :%#x\n",
		MMC_RXIPV4_GD_OCTETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_GD_OCTETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_GD_OCTETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXICMP_ERR_PKTS_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXICMP_ERR_PKTS_RgRd(pdata, MMC_RXICMP_ERR_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXICMP_ERR_PKTS        :%#x\n",
		MMC_RXICMP_ERR_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXICMP_ERR_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXICMP_ERR_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXICMP_GD_PKTS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXICMP_GD_PKTS_RgRd(pdata, MMC_RXICMP_GD_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXICMP_GD_PKTS         :%#x\n",
		MMC_RXICMP_GD_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXICMP_GD_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXICMP_GD_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXTCP_ERR_PKTS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXTCP_ERR_PKTS_RgRd(pdata, MMC_RXTCP_ERR_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXTCP_ERR_PKTS         :%#x\n",
		MMC_RXTCP_ERR_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXTCP_ERR_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXTCP_ERR_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXTCP_GD_PKTS_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXTCP_GD_PKTS_RgRd(pdata, MMC_RXTCP_GD_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXTCP_GD_PKTS          :%#x\n",
		MMC_RXTCP_GD_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXTCP_GD_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXTCP_GD_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUDP_ERR_PKTS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUDP_ERR_PKTS_RgRd(pdata, MMC_RXUDP_ERR_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXUDP_ERR_PKTS         :%#x\n",
		MMC_RXUDP_ERR_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUDP_ERR_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXUDP_ERR_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUDP_GD_PKTS_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUDP_GD_PKTS_RgRd(pdata, MMC_RXUDP_GD_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXUDP_GD_PKTS          :%#x\n",
		MMC_RXUDP_GD_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUDP_GD_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXUDP_GD_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_NOPAY_PKTS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_NOPAY_PKTS_RgRd(pdata, MMC_RXIPV6_NOPAY_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_NOPAY_PKTS      :%#x\n",
		MMC_RXIPV6_NOPAY_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_NOPAY_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_NOPAY_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_HDRERR_PKTS_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_HDRERR_PKTS_RgRd(pdata, MMC_RXIPV6_HDRERR_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_HDRERR_PKTS     :%#x\n",
		MMC_RXIPV6_HDRERR_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_HDRERR_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_HDRERR_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV6_GD_PKTS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV6_GD_PKTS_RgRd(pdata, MMC_RXIPV6_GD_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV6_GD_PKTS         :%#x\n",
		MMC_RXIPV6_GD_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV6_GD_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV6_GD_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_UBSBL_PKTS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_UBSBL_PKTS_RgRd(pdata, MMC_RXIPV4_UBSBL_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_UBSBL_PKTS      :%#x\n",
		MMC_RXIPV4_UBSBL_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_UBSBL_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_UBSBL_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_FRAG_PKTS_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_FRAG_PKTS_RgRd(pdata, MMC_RXIPV4_FRAG_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_FRAG_PKTS       :%#x\n",
		MMC_RXIPV4_FRAG_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_FRAG_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_FRAG_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_NOPAY_PKTS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_NOPAY_PKTS_RgRd(pdata, MMC_RXIPV4_NOPAY_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_NOPAY_PKTS      :%#x\n",
		MMC_RXIPV4_NOPAY_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_NOPAY_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_NOPAY_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_HDRERR_PKTS_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_HDRERR_PKTS_RgRd(pdata, MMC_RXIPV4_HDRERR_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_HDRERR_PKTS     :%#x\n",
		MMC_RXIPV4_HDRERR_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_HDRERR_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_HDRERR_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXIPV4_GD_PKTS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXIPV4_GD_PKTS_RgRd(pdata, MMC_RXIPV4_GD_PKTS_val);
	sprintf(debugfs_buf, "MMC_RXIPV4_GD_PKTS         :%#x\n",
		MMC_RXIPV4_GD_PKTS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXIPV4_GD_PKTS_fops = {
	.open = debugfile_open,
	.read = MMC_RXIPV4_GD_PKTS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXCTRLPACKETS_G_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXCTRLPACKETS_G_RgRd(pdata, MMC_RXCTRLPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_RXCTRLPACKETS_G        :%#x\n",
		MMC_RXCTRLPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXCTRLPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXCTRLPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXRCVERROR_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXRCVERROR_RgRd(pdata, MMC_RXRCVERROR_val);
	sprintf(debugfs_buf, "MMC_RXRCVERROR             :%#x\n",
		MMC_RXRCVERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXRCVERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXRCVERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXWATCHDOGERROR_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXWATCHDOGERROR_RgRd(pdata, MMC_RXWATCHDOGERROR_val);
	sprintf(debugfs_buf, "MMC_RXWATCHDOGERROR        :%#x\n",
		MMC_RXWATCHDOGERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXWATCHDOGERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXWATCHDOGERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXVLANPACKETS_GB_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXVLANPACKETS_GB_RgRd(pdata, MMC_RXVLANPACKETS_GB_val);
	sprintf(debugfs_buf, "MMC_RXVLANPACKETS_GB       :%#x\n",
		MMC_RXVLANPACKETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXVLANPACKETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RXVLANPACKETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXFIFOOVERFLOW_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXFIFOOVERFLOW_RgRd(pdata, MMC_RXFIFOOVERFLOW_val);
	sprintf(debugfs_buf, "MMC_RXFIFOOVERFLOW         :%#x\n",
		MMC_RXFIFOOVERFLOW_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXFIFOOVERFLOW_fops = {
	.open = debugfile_open,
	.read = MMC_RXFIFOOVERFLOW_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXPAUSEPACKETS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXPAUSEPACKETS_RgRd(pdata, MMC_RXPAUSEPACKETS_val);
	sprintf(debugfs_buf, "MMC_RXPAUSEPACKETS         :%#x\n",
		MMC_RXPAUSEPACKETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXPAUSEPACKETS_fops = {
	.open = debugfile_open,
	.read = MMC_RXPAUSEPACKETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXOUTOFRANGETYPE_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXOUTOFRANGETYPE_RgRd(pdata, MMC_RXOUTOFRANGETYPE_val);
	sprintf(debugfs_buf, "MMC_RXOUTOFRANGETYPE       :%#x\n",
		MMC_RXOUTOFRANGETYPE_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXOUTOFRANGETYPE_fops = {
	.open = debugfile_open,
	.read = MMC_RXOUTOFRANGETYPE_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXLENGTHERROR_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXLENGTHERROR_RgRd(pdata, MMC_RXLENGTHERROR_val);
	sprintf(debugfs_buf, "MMC_RXLENGTHERROR          :%#x\n",
		MMC_RXLENGTHERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXLENGTHERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXLENGTHERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUNICASTPACKETS_G_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUNICASTPACKETS_G_RgRd(pdata, MMC_RXUNICASTPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_RXUNICASTPACKETS_G     :%#x\n",
		MMC_RXUNICASTPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUNICASTPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXUNICASTPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX1024TOMAXOCTETS_GB_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX1024TOMAXOCTETS_GB_RgRd(pdata, MMC_RX1024TOMAXOCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX1024TOMAXOCTETS_GB   :%#x\n",
		MMC_RX1024TOMAXOCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX1024TOMAXOCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX1024TOMAXOCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX512TO1023OCTETS_GB_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX512TO1023OCTETS_GB_RgRd(pdata, MMC_RX512TO1023OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX512TO1023OCTETS_GB   :%#x\n",
		MMC_RX512TO1023OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX512TO1023OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX512TO1023OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX256TO511OCTETS_GB_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX256TO511OCTETS_GB_RgRd(pdata, MMC_RX256TO511OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX256TO511OCTETS_GB    :%#x\n",
		MMC_RX256TO511OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX256TO511OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX256TO511OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX128TO255OCTETS_GB_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX128TO255OCTETS_GB_RgRd(pdata, MMC_RX128TO255OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX128TO255OCTETS_GB    :%#x\n",
		MMC_RX128TO255OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX128TO255OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX128TO255OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX65TO127OCTETS_GB_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX65TO127OCTETS_GB_RgRd(pdata, MMC_RX65TO127OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX65TO127OCTETS_GB     :%#x\n",
		MMC_RX65TO127OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX65TO127OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX65TO127OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RX64OCTETS_GB_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RX64OCTETS_GB_RgRd(pdata, MMC_RX64OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_RX64OCTETS_GB          :%#x\n",
		MMC_RX64OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RX64OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RX64OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXOVERSIZE_G_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXOVERSIZE_G_RgRd(pdata, MMC_RXOVERSIZE_G_val);
	sprintf(debugfs_buf, "MMC_RXOVERSIZE_G           :%#x\n",
		MMC_RXOVERSIZE_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXOVERSIZE_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXOVERSIZE_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXUNDERSIZE_G_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXUNDERSIZE_G_RgRd(pdata, MMC_RXUNDERSIZE_G_val);
	sprintf(debugfs_buf, "MMC_RXUNDERSIZE_G          :%#x\n",
		MMC_RXUNDERSIZE_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXUNDERSIZE_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXUNDERSIZE_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXJABBERERROR_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXJABBERERROR_RgRd(pdata, MMC_RXJABBERERROR_val);
	sprintf(debugfs_buf, "MMC_RXJABBERERROR          :%#x\n",
		MMC_RXJABBERERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXJABBERERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXJABBERERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXRUNTERROR_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXRUNTERROR_RgRd(pdata, MMC_RXRUNTERROR_val);
	sprintf(debugfs_buf, "MMC_RXRUNTERROR            :%#x\n",
		MMC_RXRUNTERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXRUNTERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXRUNTERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXALIGNMENTERROR_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXALIGNMENTERROR_RgRd(pdata, MMC_RXALIGNMENTERROR_val);
	sprintf(debugfs_buf, "MMC_RXALIGNMENTERROR       :%#x\n",
		MMC_RXALIGNMENTERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXALIGNMENTERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXALIGNMENTERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXCRCERROR_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXCRCERROR_RgRd(pdata, MMC_RXCRCERROR_val);
	sprintf(debugfs_buf, "MMC_RXCRCERROR             :%#x\n",
		MMC_RXCRCERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXCRCERROR_fops = {
	.open = debugfile_open,
	.read = MMC_RXCRCERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXMULTICASTPACKETS_G_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXMULTICASTPACKETS_G_RgRd(pdata, MMC_RXMULTICASTPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_RXMULTICASTPACKETS_G   :%#x\n",
		MMC_RXMULTICASTPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXMULTICASTPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXMULTICASTPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXBROADCASTPACKETS_G_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXBROADCASTPACKETS_G_RgRd(pdata, MMC_RXBROADCASTPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_RXBROADCASTPACKETS_G   :%#x\n",
		MMC_RXBROADCASTPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXBROADCASTPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXBROADCASTPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXOCTETCOUNT_G_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXOCTETCOUNT_G_RgRd(pdata, MMC_RXOCTETCOUNT_G_val);
	sprintf(debugfs_buf, "MMC_RXOCTETCOUNT_G         :%#x\n",
		MMC_RXOCTETCOUNT_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXOCTETCOUNT_G_fops = {
	.open = debugfile_open,
	.read = MMC_RXOCTETCOUNT_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXOCTETCOUNT_GB_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXOCTETCOUNT_GB_RgRd(pdata, MMC_RXOCTETCOUNT_GB_val);
	sprintf(debugfs_buf, "MMC_RXOCTETCOUNT_GB        :%#x\n",
		MMC_RXOCTETCOUNT_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXOCTETCOUNT_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RXOCTETCOUNT_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_RXPACKETCOUNT_GB_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_RXPACKETCOUNT_GB_RgRd(pdata, MMC_RXPACKETCOUNT_GB_val);
	sprintf(debugfs_buf, "MMC_RXPACKETCOUNT_GB       :%#x\n",
		MMC_RXPACKETCOUNT_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_RXPACKETCOUNT_GB_fops = {
	.open = debugfile_open,
	.read = MMC_RXPACKETCOUNT_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXOVERSIZE_G_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXOVERSIZE_G_RgRd(pdata, MMC_TXOVERSIZE_G_val);
	sprintf(debugfs_buf, "MMC_TXOVERSIZE_G           :%#x\n",
		MMC_TXOVERSIZE_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXOVERSIZE_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXOVERSIZE_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXVLANPACKETS_G_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXVLANPACKETS_G_RgRd(pdata, MMC_TXVLANPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_TXVLANPACKETS_G        :%#x\n",
		MMC_TXVLANPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXVLANPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXVLANPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXPAUSEPACKETS_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXPAUSEPACKETS_RgRd(pdata, MMC_TXPAUSEPACKETS_val);
	sprintf(debugfs_buf, "MMC_TXPAUSEPACKETS         :%#x\n",
		MMC_TXPAUSEPACKETS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXPAUSEPACKETS_fops = {
	.open = debugfile_open,
	.read = MMC_TXPAUSEPACKETS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXEXCESSDEF_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXEXCESSDEF_RgRd(pdata, MMC_TXEXCESSDEF_val);
	sprintf(debugfs_buf, "MMC_TXEXCESSDEF            :%#x\n",
		MMC_TXEXCESSDEF_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXEXCESSDEF_fops = {
	.open = debugfile_open,
	.read = MMC_TXEXCESSDEF_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXPACKETSCOUNT_G_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXPACKETSCOUNT_G_RgRd(pdata, MMC_TXPACKETSCOUNT_G_val);
	sprintf(debugfs_buf, "MMC_TXPACKETSCOUNT_G       :%#x\n",
		MMC_TXPACKETSCOUNT_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXPACKETSCOUNT_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXPACKETSCOUNT_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXOCTETCOUNT_G_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXOCTETCOUNT_G_RgRd(pdata, MMC_TXOCTETCOUNT_G_val);
	sprintf(debugfs_buf, "MMC_TXOCTETCOUNT_G         :%#x\n",
		MMC_TXOCTETCOUNT_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXOCTETCOUNT_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXOCTETCOUNT_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXCARRIERERROR_read(struct file *file, char __user * userbuf,
				       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXCARRIERERROR_RgRd(pdata, MMC_TXCARRIERERROR_val);
	sprintf(debugfs_buf, "MMC_TXCARRIERERROR         :%#x\n",
		MMC_TXCARRIERERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXCARRIERERROR_fops = {
	.open = debugfile_open,
	.read = MMC_TXCARRIERERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXEXESSCOL_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXEXESSCOL_RgRd(pdata, MMC_TXEXESSCOL_val);
	sprintf(debugfs_buf, "MMC_TXEXESSCOL             :%#x\n",
		MMC_TXEXESSCOL_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXEXESSCOL_fops = {
	.open = debugfile_open,
	.read = MMC_TXEXESSCOL_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXLATECOL_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXLATECOL_RgRd(pdata, MMC_TXLATECOL_val);
	sprintf(debugfs_buf, "MMC_TXLATECOL              :%#x\n",
		MMC_TXLATECOL_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXLATECOL_fops = {
	.open = debugfile_open,
	.read = MMC_TXLATECOL_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXDEFERRED_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXDEFERRED_RgRd(pdata, MMC_TXDEFERRED_val);
	sprintf(debugfs_buf, "MMC_TXDEFERRED             :%#x\n",
		MMC_TXDEFERRED_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXDEFERRED_fops = {
	.open = debugfile_open,
	.read = MMC_TXDEFERRED_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXMULTICOL_G_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXMULTICOL_G_RgRd(pdata, MMC_TXMULTICOL_G_val);
	sprintf(debugfs_buf, "MMC_TXMULTICOL_G           :%#x\n",
		MMC_TXMULTICOL_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXMULTICOL_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXMULTICOL_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXSINGLECOL_G_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXSINGLECOL_G_RgRd(pdata, MMC_TXSINGLECOL_G_val);
	sprintf(debugfs_buf, "MMC_TXSINGLECOL_G          :%#x\n",
		MMC_TXSINGLECOL_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXSINGLECOL_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXSINGLECOL_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXUNDERFLOWERROR_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXUNDERFLOWERROR_RgRd(pdata, MMC_TXUNDERFLOWERROR_val);
	sprintf(debugfs_buf, "MMC_TXUNDERFLOWERROR       :%#x\n",
		MMC_TXUNDERFLOWERROR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXUNDERFLOWERROR_fops = {
	.open = debugfile_open,
	.read = MMC_TXUNDERFLOWERROR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXBROADCASTPACKETS_GB_read(struct file *file,
					      char __user * userbuf,
					      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXBROADCASTPACKETS_GB_RgRd(pdata, MMC_TXBROADCASTPACKETS_GB_val);
	sprintf(debugfs_buf, "MMC_TXBROADCASTPACKETS_GB  :%#x\n",
		MMC_TXBROADCASTPACKETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXBROADCASTPACKETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TXBROADCASTPACKETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXMULTICASTPACKETS_GB_read(struct file *file,
					      char __user * userbuf,
					      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXMULTICASTPACKETS_GB_RgRd(pdata, MMC_TXMULTICASTPACKETS_GB_val);
	sprintf(debugfs_buf, "MMC_TXMULTICASTPACKETS_GB  :%#x\n",
		MMC_TXMULTICASTPACKETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXMULTICASTPACKETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TXMULTICASTPACKETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXUNICASTPACKETS_GB_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXUNICASTPACKETS_GB_RgRd(pdata, MMC_TXUNICASTPACKETS_GB_val);
	sprintf(debugfs_buf, "MMC_TXUNICASTPACKETS_GB    :%#x\n",
		MMC_TXUNICASTPACKETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXUNICASTPACKETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TXUNICASTPACKETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX1024TOMAXOCTETS_GB_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX1024TOMAXOCTETS_GB_RgRd(pdata, MMC_TX1024TOMAXOCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX1024TOMAXOCTETS_GB   :%#x\n",
		MMC_TX1024TOMAXOCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX1024TOMAXOCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX1024TOMAXOCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX512TO1023OCTETS_GB_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX512TO1023OCTETS_GB_RgRd(pdata, MMC_TX512TO1023OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX512TO1023OCTETS_GB   :%#x\n",
		MMC_TX512TO1023OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX512TO1023OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX512TO1023OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX256TO511OCTETS_GB_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX256TO511OCTETS_GB_RgRd(pdata, MMC_TX256TO511OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX256TO511OCTETS_GB    :%#x\n",
		MMC_TX256TO511OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX256TO511OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX256TO511OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX128TO255OCTETS_GB_read(struct file *file,
					    char __user * userbuf, size_t count,
					    loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX128TO255OCTETS_GB_RgRd(pdata, MMC_TX128TO255OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX128TO255OCTETS_GB    :%#x\n",
		MMC_TX128TO255OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX128TO255OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX128TO255OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX65TO127OCTETS_GB_read(struct file *file,
					   char __user * userbuf, size_t count,
					   loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX65TO127OCTETS_GB_RgRd(pdata, MMC_TX65TO127OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX65TO127OCTETS_GB     :%#x\n",
		MMC_TX65TO127OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX65TO127OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX65TO127OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TX64OCTETS_GB_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TX64OCTETS_GB_RgRd(pdata, MMC_TX64OCTETS_GB_val);
	sprintf(debugfs_buf, "MMC_TX64OCTETS_GB          :%#x\n",
		MMC_TX64OCTETS_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TX64OCTETS_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TX64OCTETS_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXMULTICASTPACKETS_G_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXMULTICASTPACKETS_G_RgRd(pdata, MMC_TXMULTICASTPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_TXMULTICASTPACKETS_G   :%#x\n",
		MMC_TXMULTICASTPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXMULTICASTPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXMULTICASTPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXBROADCASTPACKETS_G_read(struct file *file,
					     char __user * userbuf,
					     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXBROADCASTPACKETS_G_RgRd(pdata, MMC_TXBROADCASTPACKETS_G_val);
	sprintf(debugfs_buf, "MMC_TXBROADCASTPACKETS_G   :%#x\n",
		MMC_TXBROADCASTPACKETS_G_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXBROADCASTPACKETS_G_fops = {
	.open = debugfile_open,
	.read = MMC_TXBROADCASTPACKETS_G_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXPACKETCOUNT_GB_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXPACKETCOUNT_GB_RgRd(pdata, MMC_TXPACKETCOUNT_GB_val);
	sprintf(debugfs_buf, "MMC_TXPACKETCOUNT_GB       :%#x\n",
		MMC_TXPACKETCOUNT_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXPACKETCOUNT_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TXPACKETCOUNT_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_TXOCTETCOUNT_GB_read(struct file *file,
					char __user * userbuf, size_t count,
					loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_TXOCTETCOUNT_GB_RgRd(pdata, MMC_TXOCTETCOUNT_GB_val);
	sprintf(debugfs_buf, "MMC_TXOCTETCOUNT_GB        :%#x\n",
		MMC_TXOCTETCOUNT_GB_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_TXOCTETCOUNT_GB_fops = {
	.open = debugfile_open,
	.read = MMC_TXOCTETCOUNT_GB_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_IPC_INTR_RX_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_IPC_INTR_RX_RgRd(pdata, MMC_IPC_INTR_RX_val);
	sprintf(debugfs_buf, "MMC_IPC_INTR_RX            :%#x\n",
		MMC_IPC_INTR_RX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_IPC_INTR_RX_fops = {
	.open = debugfile_open,
	.read = MMC_IPC_INTR_RX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_IPC_INTR_MASK_RX_read(struct file *file,
					 char __user * userbuf, size_t count,
					 loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_IPC_INTR_MASK_RX_RgRd(pdata, MMC_IPC_INTR_MASK_RX_val);
	sprintf(debugfs_buf, "MMC_IPC_INTR_MASK_RX       :%#x\n",
		MMC_IPC_INTR_MASK_RX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_IPC_INTR_MASK_RX_fops = {
	.open = debugfile_open,
	.read = MMC_IPC_INTR_MASK_RX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_INTR_MASK_TX_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_INTR_MASK_TX_RgRd(pdata, MMC_INTR_MASK_TX_val);
	sprintf(debugfs_buf, "MMC_INTR_MASK_TX           :%#x\n",
		MMC_INTR_MASK_TX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_INTR_MASK_TX_fops = {
	.open = debugfile_open,
	.read = MMC_INTR_MASK_TX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_INTR_MASK_RX_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_INTR_MASK_RX_RgRd(pdata, MMC_INTR_MASK_RX_val);
	sprintf(debugfs_buf, "MMC_INTR_MASK_RX           :%#x\n",
		MMC_INTR_MASK_RX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_INTR_MASK_RX_fops = {
	.open = debugfile_open,
	.read = MMC_INTR_MASK_RX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_INTR_TX_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_INTR_TX_RgRd(pdata, MMC_INTR_TX_val);
	sprintf(debugfs_buf, "MMC_INTR_TX                :%#x\n",
		MMC_INTR_TX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_INTR_TX_fops = {
	.open = debugfile_open,
	.read = MMC_INTR_TX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_INTR_RX_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_INTR_RX_RgRd(pdata, MMC_INTR_RX_val);
	sprintf(debugfs_buf, "MMC_INTR_RX                :%#x\n",
		MMC_INTR_RX_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_INTR_RX_fops = {
	.open = debugfile_open,
	.read = MMC_INTR_RX_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MMC_CNTRL_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	if (!pdata->hw_feat.mmc_sel) {
		printk(KERN_ALERT
		       "MMC Module not selected. Register cannot be read\n");
		return -EINVAL;
	}
	MMC_CNTRL_RgRd(pdata, MMC_CNTRL_val);
	sprintf(debugfs_buf, "MMC_CNTRL                  :%#x\n",
		MMC_CNTRL_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MMC_CNTRL_fops = {
	.open = debugfile_open,
	.read = MMC_CNTRL_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1LR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1LR_RgRd(pdata, MAC_MA1LR_val);
	sprintf(debugfs_buf, "MAC_MA1LR                  :%#x\n",
		MAC_MA1LR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1LR_fops = {
	.open = debugfile_open,
	.read = MAC_MA1LR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA1HR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA1HR_RgRd(pdata, MAC_MA1HR_val);
	sprintf(debugfs_buf, "MAC_MA1HR                  :%#x\n",
		MAC_MA1HR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA1HR_fops = {
	.open = debugfile_open,
	.read = MAC_MA1HR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA0LR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA0LR_RgRd(pdata, MAC_MA0LR_val);
	sprintf(debugfs_buf, "MAC_MA0LR                  :%#x\n",
		MAC_MA0LR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA0LR_fops = {
	.open = debugfile_open,
	.read = MAC_MA0LR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MA0HR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MA0HR_RgRd(pdata, MAC_MA0HR_val);
	sprintf(debugfs_buf, "MAC_MA0HR       :%#x\n", MAC_MA0HR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MA0HR_fops = {
	.open = debugfile_open,
	.read = MAC_MA0HR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_GPIOR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_GPIOR_RgRd(pdata, MAC_GPIOR_val);
	sprintf(debugfs_buf, "MAC_GPIOR       :%#x\n", MAC_GPIOR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_GPIOR_fops = {
	.open = debugfile_open,
	.read = MAC_GPIOR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_GMIIDR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_GMIIDR_RgRd(pdata, MAC_GMIIDR_val);
	sprintf(debugfs_buf, "MAC_GMIIDR      :%#x\n", MAC_GMIIDR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_GMIIDR_fops = {
	.open = debugfile_open,
	.read = MAC_GMIIDR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_GMIIAR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_GMIIAR_RgRd(pdata, MAC_GMIIAR_val);
	sprintf(debugfs_buf, "MAC_GMIIAR      :%#x\n", MAC_GMIIAR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_GMIIAR_fops = {
	.open = debugfile_open,
	.read = MAC_GMIIAR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HFR2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HFR2_RgRd(pdata, MAC_HFR2_val);
	sprintf(debugfs_buf, "MAC_HFR2        :%#x\n", MAC_HFR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HFR2_fops = {
	.open = debugfile_open,
	.read = MAC_HFR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HFR1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HFR1_RgRd(pdata, MAC_HFR1_val);
	sprintf(debugfs_buf, "MAC_HFR1        :%#x\n", MAC_HFR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HFR1_fops = {
	.open = debugfile_open,
	.read = MAC_HFR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HFR0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HFR0_RgRd(pdata, MAC_HFR0_val);
	sprintf(debugfs_buf, "MAC_HFR0        :%#x\n", MAC_HFR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HFR0_fops = {
	.open = debugfile_open,
	.read = MAC_HFR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MDR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MDR_RgRd(pdata, MAC_MDR_val);
	sprintf(debugfs_buf, "MAC_MDR         :%#x\n", MAC_MDR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MDR_fops = {
	.open = debugfile_open,
	.read = MAC_MDR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_VR_read(struct file *file, char __user * userbuf,
			   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_VR_RgRd(pdata, MAC_VR_val);
	sprintf(debugfs_buf, "MAC_VR          :%#x\n", MAC_VR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_VR_fops = {
	.open = debugfile_open,
	.read = MAC_VR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR7_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR7_RgRd(pdata, MAC_HTR7_val);
	sprintf(debugfs_buf, "MAC_HTR7        :%#x\n", MAC_HTR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR7_fops = {
	.open = debugfile_open,
	.read = MAC_HTR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR6_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR6_RgRd(pdata, MAC_HTR6_val);
	sprintf(debugfs_buf, "MAC_HTR6        :%#x\n", MAC_HTR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR6_fops = {
	.open = debugfile_open,
	.read = MAC_HTR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR5_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR5_RgRd(pdata, MAC_HTR5_val);
	sprintf(debugfs_buf, "MAC_HTR5        :%#x\n", MAC_HTR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR5_fops = {
	.open = debugfile_open,
	.read = MAC_HTR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR4_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR4_RgRd(pdata, MAC_HTR4_val);
	sprintf(debugfs_buf, "MAC_HTR4        :%#x\n", MAC_HTR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR4_fops = {
	.open = debugfile_open,
	.read = MAC_HTR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR3_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR3_RgRd(pdata, MAC_HTR3_val);
	sprintf(debugfs_buf, "MAC_HTR3        :%#x\n", MAC_HTR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR3_fops = {
	.open = debugfile_open,
	.read = MAC_HTR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR2_RgRd(pdata, MAC_HTR2_val);
	sprintf(debugfs_buf, "MAC_HTR2        :%#x\n", MAC_HTR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR2_fops = {
	.open = debugfile_open,
	.read = MAC_HTR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR1_RgRd(pdata, MAC_HTR1_val);
	sprintf(debugfs_buf, "MAC_HTR1        :%#x\n", MAC_HTR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR1_fops = {
	.open = debugfile_open,
	.read = MAC_HTR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_HTR0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_HTR0_RgRd(pdata, MAC_HTR0_val);
	sprintf(debugfs_buf, "MAC_HTR0        :%#x\n", MAC_HTR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_HTR0_fops = {
	.open = debugfile_open,
	.read = MAC_HTR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR7_RgRd(pdata, DMA_RIWTR7_val);
	sprintf(debugfs_buf, "DMA_RIWTR7      :%#x\n", DMA_RIWTR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR7_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR6_RgRd(pdata, DMA_RIWTR6_val);
	sprintf(debugfs_buf, "DMA_RIWTR6      :%#x\n", DMA_RIWTR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR6_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR5_RgRd(pdata, DMA_RIWTR5_val);
	sprintf(debugfs_buf, "DMA_RIWTR5      :%#x\n", DMA_RIWTR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR5_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR4_RgRd(pdata, DMA_RIWTR4_val);
	sprintf(debugfs_buf, "DMA_RIWTR4      :%#x\n", DMA_RIWTR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR4_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR3_RgRd(pdata, DMA_RIWTR3_val);
	sprintf(debugfs_buf, "DMA_RIWTR3      :%#x\n", DMA_RIWTR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR3_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR2_RgRd(pdata, DMA_RIWTR2_val);
	sprintf(debugfs_buf, "DMA_RIWTR2      :%#x\n", DMA_RIWTR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR2_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR1_RgRd(pdata, DMA_RIWTR1_val);
	sprintf(debugfs_buf, "DMA_RIWTR1      :%#x\n", DMA_RIWTR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR1_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RIWTR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RIWTR0_RgRd(pdata, DMA_RIWTR0_val);
	sprintf(debugfs_buf, "DMA_RIWTR0      :%#x\n", DMA_RIWTR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RIWTR0_fops = {
	.open = debugfile_open,
	.read = DMA_RIWTR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR7_RgRd(pdata, DMA_RDRLR7_val);
	sprintf(debugfs_buf, "DMA_RDRLR7      :%#x\n", DMA_RDRLR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR7_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR6_RgRd(pdata, DMA_RDRLR6_val);
	sprintf(debugfs_buf, "DMA_RDRLR6      :%#x\n", DMA_RDRLR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR6_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR5_RgRd(pdata, DMA_RDRLR5_val);
	sprintf(debugfs_buf, "DMA_RDRLR5      :%#x\n", DMA_RDRLR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR5_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR4_RgRd(pdata, DMA_RDRLR4_val);
	sprintf(debugfs_buf, "DMA_RDRLR4      :%#x\n", DMA_RDRLR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR4_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR3_RgRd(pdata, DMA_RDRLR3_val);
	sprintf(debugfs_buf, "DMA_RDRLR3      :%#x\n", DMA_RDRLR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR3_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR2_RgRd(pdata, DMA_RDRLR2_val);
	sprintf(debugfs_buf, "DMA_RDRLR2      :%#x\n", DMA_RDRLR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR2_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR1_RgRd(pdata, DMA_RDRLR1_val);
	sprintf(debugfs_buf, "DMA_RDRLR1      :%#x\n", DMA_RDRLR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR1_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDRLR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDRLR0_RgRd(pdata, DMA_RDRLR0_val);
	sprintf(debugfs_buf, "DMA_RDRLR0      :%#x\n", DMA_RDRLR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDRLR0_fops = {
	.open = debugfile_open,
	.read = DMA_RDRLR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR7_RgRd(pdata, DMA_TDRLR7_val);
	sprintf(debugfs_buf, "DMA_TDRLR7      :%#x\n", DMA_TDRLR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR7_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR6_RgRd(pdata, DMA_TDRLR6_val);
	sprintf(debugfs_buf, "DMA_TDRLR6      :%#x\n", DMA_TDRLR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR6_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR5_RgRd(pdata, DMA_TDRLR5_val);
	sprintf(debugfs_buf, "DMA_TDRLR5      :%#x\n", DMA_TDRLR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR5_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR4_RgRd(pdata, DMA_TDRLR4_val);
	sprintf(debugfs_buf, "DMA_TDRLR4      :%#x\n", DMA_TDRLR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR4_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR3_RgRd(pdata, DMA_TDRLR3_val);
	sprintf(debugfs_buf, "DMA_TDRLR3      :%#x\n", DMA_TDRLR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR3_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR2_RgRd(pdata, DMA_TDRLR2_val);
	sprintf(debugfs_buf, "DMA_TDRLR2      :%#x\n", DMA_TDRLR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR2_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR1_RgRd(pdata, DMA_TDRLR1_val);
	sprintf(debugfs_buf, "DMA_TDRLR1      :%#x\n", DMA_TDRLR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR1_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDRLR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDRLR0_RgRd(pdata, DMA_TDRLR0_val);
	sprintf(debugfs_buf, "DMA_TDRLR0      :%#x\n", DMA_TDRLR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDRLR0_fops = {
	.open = debugfile_open,
	.read = DMA_TDRLR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR7_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR7_RgRd(pdata, DMA_RDTP_RPDR7_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR7  :%#x\n", DMA_RDTP_RPDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR7_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR6_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR6_RgRd(pdata, DMA_RDTP_RPDR6_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR6  :%#x\n", DMA_RDTP_RPDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR6_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR5_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR5_RgRd(pdata, DMA_RDTP_RPDR5_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR5  :%#x\n", DMA_RDTP_RPDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR5_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR4_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR4_RgRd(pdata, DMA_RDTP_RPDR4_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR4  :%#x\n", DMA_RDTP_RPDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR4_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR3_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR3_RgRd(pdata, DMA_RDTP_RPDR3_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR3  :%#x\n", DMA_RDTP_RPDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR3_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR2_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR2_RgRd(pdata, DMA_RDTP_RPDR2_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR2  :%#x\n", DMA_RDTP_RPDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR2_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR1_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR1_RgRd(pdata, DMA_RDTP_RPDR1_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR1  :%#x\n", DMA_RDTP_RPDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR1_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDTP_RPDR0_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDTP_RPDR0_RgRd(pdata, DMA_RDTP_RPDR0_val);
	sprintf(debugfs_buf, "DMA_RDTP_RPDR0  :%#x\n", DMA_RDTP_RPDR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDTP_RPDR0_fops = {
	.open = debugfile_open,
	.read = DMA_RDTP_RPDR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR7_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR7_RgRd(pdata, DMA_TDTP_TPDR7_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR7  :%#x\n", DMA_TDTP_TPDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR7_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR6_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR6_RgRd(pdata, DMA_TDTP_TPDR6_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR6  :%#x\n", DMA_TDTP_TPDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR6_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR5_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR5_RgRd(pdata, DMA_TDTP_TPDR5_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR5  :%#x\n", DMA_TDTP_TPDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR5_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR4_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR4_RgRd(pdata, DMA_TDTP_TPDR4_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR4  :%#x\n", DMA_TDTP_TPDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR4_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR3_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR3_RgRd(pdata, DMA_TDTP_TPDR3_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR3  :%#x\n", DMA_TDTP_TPDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR3_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR2_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR2_RgRd(pdata, DMA_TDTP_TPDR2_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR2  :%#x\n", DMA_TDTP_TPDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR2_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR1_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR1_RgRd(pdata, DMA_TDTP_TPDR1_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR1  :%#x\n", DMA_TDTP_TPDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR1_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDTP_TPDR0_read(struct file *file, char __user * userbuf,
				   size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDTP_TPDR0_RgRd(pdata, DMA_TDTP_TPDR0_val);
	sprintf(debugfs_buf, "DMA_TDTP_TPDR0  :%#x\n", DMA_TDTP_TPDR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDTP_TPDR0_fops = {
	.open = debugfile_open,
	.read = DMA_TDTP_TPDR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR7_RgRd(pdata, DMA_RDLAR7_val);
	sprintf(debugfs_buf, "DMA_RDLAR7      :%#x\n", DMA_RDLAR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR7_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR6_RgRd(pdata, DMA_RDLAR6_val);
	sprintf(debugfs_buf, "DMA_RDLAR6      :%#x\n", DMA_RDLAR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR6_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR5_RgRd(pdata, DMA_RDLAR5_val);
	sprintf(debugfs_buf, "DMA_RDLAR5      :%#x\n", DMA_RDLAR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR5_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR4_RgRd(pdata, DMA_RDLAR4_val);
	sprintf(debugfs_buf, "DMA_RDLAR4      :%#x\n", DMA_RDLAR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR4_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR3_RgRd(pdata, DMA_RDLAR3_val);
	sprintf(debugfs_buf, "DMA_RDLAR3      :%#x\n", DMA_RDLAR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR3_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR2_RgRd(pdata, DMA_RDLAR2_val);
	sprintf(debugfs_buf, "DMA_RDLAR2      :%#x\n", DMA_RDLAR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR2_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR1_RgRd(pdata, DMA_RDLAR1_val);
	sprintf(debugfs_buf, "DMA_RDLAR1      :%#x\n", DMA_RDLAR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR1_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RDLAR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RDLAR0_RgRd(pdata, DMA_RDLAR0_val);
	sprintf(debugfs_buf, "DMA_RDLAR0      :%#x\n", DMA_RDLAR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RDLAR0_fops = {
	.open = debugfile_open,
	.read = DMA_RDLAR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR7_RgRd(pdata, DMA_TDLAR7_val);
	sprintf(debugfs_buf, "DMA_TDLAR7      :%#x\n", DMA_TDLAR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR7_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR6_RgRd(pdata, DMA_TDLAR6_val);
	sprintf(debugfs_buf, "DMA_TDLAR6      :%#x\n", DMA_TDLAR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR6_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR5_RgRd(pdata, DMA_TDLAR5_val);
	sprintf(debugfs_buf, "DMA_TDLAR5      :%#x\n", DMA_TDLAR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR5_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR4_RgRd(pdata, DMA_TDLAR4_val);
	sprintf(debugfs_buf, "DMA_TDLAR4      :%#x\n", DMA_TDLAR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR4_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR3_RgRd(pdata, DMA_TDLAR3_val);
	sprintf(debugfs_buf, "DMA_TDLAR3      :%#x\n", DMA_TDLAR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR3_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR2_RgRd(pdata, DMA_TDLAR2_val);
	sprintf(debugfs_buf, "DMA_TDLAR2      :%#x\n", DMA_TDLAR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR2_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR1_RgRd(pdata, DMA_TDLAR1_val);
	sprintf(debugfs_buf, "DMA_TDLAR1      :%#x\n", DMA_TDLAR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR1_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TDLAR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TDLAR0_RgRd(pdata, DMA_TDLAR0_val);
	sprintf(debugfs_buf, "DMA_TDLAR0      :%#x\n", DMA_TDLAR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TDLAR0_fops = {
	.open = debugfile_open,
	.read = DMA_TDLAR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER7_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 7, DMA_IER7_val);
	sprintf(debugfs_buf, "DMA_IER7        :%#x\n", DMA_IER7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER7_fops = {
	.open = debugfile_open,
	.read = DMA_IER7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER6_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 6, DMA_IER6_val);
	sprintf(debugfs_buf, "DMA_IER6        :%#x\n", DMA_IER6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER6_fops = {
	.open = debugfile_open,
	.read = DMA_IER6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER5_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 5, DMA_IER5_val);
	sprintf(debugfs_buf, "DMA_IER5        :%#x\n", DMA_IER5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER5_fops = {
	.open = debugfile_open,
	.read = DMA_IER5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER4_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 4, DMA_IER4_val);
	sprintf(debugfs_buf, "DMA_IER4        :%#x\n", DMA_IER4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER4_fops = {
	.open = debugfile_open,
	.read = DMA_IER4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER3_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 3, DMA_IER3_val);
	sprintf(debugfs_buf, "DMA_IER3        :%#x\n", DMA_IER3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER3_fops = {
	.open = debugfile_open,
	.read = DMA_IER3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 2, DMA_IER2_val);
	sprintf(debugfs_buf, "DMA_IER2        :%#x\n", DMA_IER2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER2_fops = {
	.open = debugfile_open,
	.read = DMA_IER2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 1, DMA_IER1_val);
	sprintf(debugfs_buf, "DMA_IER1        :%#x\n", DMA_IER1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER1_fops = {
	.open = debugfile_open,
	.read = DMA_IER1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_IER0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_IER_RgRd(pdata, 0, DMA_IER0_val);
	sprintf(debugfs_buf, "DMA_IER0        :%#x\n", DMA_IER0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_IER0_fops = {
	.open = debugfile_open,
	.read = DMA_IER0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_IMR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_IMR_RgRd(pdata, MAC_IMR_val);
	sprintf(debugfs_buf, "MAC_IMR         :%#x\n", MAC_IMR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_IMR_fops = {
	.open = debugfile_open,
	.read = MAC_IMR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_ISR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_ISR_RgRd(pdata, MAC_ISR_val);
	sprintf(debugfs_buf, "MAC_ISR         :%#x\n", MAC_ISR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_ISR_fops = {
	.open = debugfile_open,
	.read = MAC_ISR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_ISR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_ISR_RgRd(pdata, MTL_ISR_val);
	sprintf(debugfs_buf, "MTL_ISR         :%#x\n", MTL_ISR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_ISR_fops = {
	.open = debugfile_open,
	.read = MTL_ISR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR7_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 7, DMA_SR7_val);
	sprintf(debugfs_buf, "DMA_SR7         :%#x\n", DMA_SR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR7_fops = {
	.open = debugfile_open,
	.read = DMA_SR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR6_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 6, DMA_SR6_val);
	sprintf(debugfs_buf, "DMA_SR6         :%#x\n", DMA_SR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR6_fops = {
	.open = debugfile_open,
	.read = DMA_SR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR5_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 5, DMA_SR5_val);
	sprintf(debugfs_buf, "DMA_SR5         :%#x\n", DMA_SR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR5_fops = {
	.open = debugfile_open,
	.read = DMA_SR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR4_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 4, DMA_SR4_val);
	sprintf(debugfs_buf, "DMA_SR4         :%#x\n", DMA_SR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR4_fops = {
	.open = debugfile_open,
	.read = DMA_SR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR3_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 3, DMA_SR3_val);
	sprintf(debugfs_buf, "DMA_SR3         :%#x\n", DMA_SR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR3_fops = {
	.open = debugfile_open,
	.read = DMA_SR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR2_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 2, DMA_SR2_val);
	sprintf(debugfs_buf, "DMA_SR2         :%#x\n", DMA_SR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR2_fops = {
	.open = debugfile_open,
	.read = DMA_SR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR1_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 1, DMA_SR1_val);
	sprintf(debugfs_buf, "DMA_SR1         :%#x\n", DMA_SR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR1_fops = {
	.open = debugfile_open,
	.read = DMA_SR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SR0_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SR_RgRd(pdata, 0, DMA_SR0_val);
	sprintf(debugfs_buf, "DMA_SR0         :%#x\n", DMA_SR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SR0_fops = {
	.open = debugfile_open,
	.read = DMA_SR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_ISR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_ISR_RgRd(pdata, DMA_ISR_val);
	sprintf(debugfs_buf, "DMA_ISR         :%#x\n", DMA_ISR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_ISR_fops = {
	.open = debugfile_open,
	.read = DMA_ISR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_DSR2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_DSR2_RgRd(pdata, DMA_DSR2_val);
	sprintf(debugfs_buf, "DMA_DSR2                   :%#x\n", DMA_DSR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_DSR2_fops = {
	.open = debugfile_open,
	.read = DMA_DSR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_DSR1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_DSR1_RgRd(pdata, DMA_DSR1_val);
	sprintf(debugfs_buf, "DMA_DSR1                   :%#x\n", DMA_DSR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_DSR1_fops = {
	.open = debugfile_open,
	.read = DMA_DSR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_DSR0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_DSR0_RgRd(pdata, DMA_DSR0_val);
	sprintf(debugfs_buf, "DMA_DSR0                   :%#x\n", DMA_DSR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_DSR0_fops = {
	.open = debugfile_open,
	.read = DMA_DSR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0RDR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0RDR_RgRd(pdata, MTL_Q0RDR_val);
	sprintf(debugfs_buf, "MTL_Q0RDR       :%#x\n", MTL_Q0RDR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0RDR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0RDR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0ESR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0ESR_RgRd(pdata, MTL_Q0ESR_val);
	sprintf(debugfs_buf, "MTL_Q0ESR       :%#x\n", MTL_Q0ESR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0ESR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0ESR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0TDR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0TDR_RgRd(pdata, MTL_Q0TDR_val);
	sprintf(debugfs_buf, "MTL_Q0TDR       :%#x\n", MTL_Q0TDR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0TDR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0TDR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR7_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR7_RgRd(pdata, DMA_CHRBAR7_val);
	sprintf(debugfs_buf, "DMA_CHRBAR7     :%#x\n", DMA_CHRBAR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR7_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR6_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR6_RgRd(pdata, DMA_CHRBAR6_val);
	sprintf(debugfs_buf, "DMA_CHRBAR6     :%#x\n", DMA_CHRBAR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR6_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR5_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR5_RgRd(pdata, DMA_CHRBAR5_val);
	sprintf(debugfs_buf, "DMA_CHRBAR5     :%#x\n", DMA_CHRBAR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR5_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR4_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR4_RgRd(pdata, DMA_CHRBAR4_val);
	sprintf(debugfs_buf, "DMA_CHRBAR4     :%#x\n", DMA_CHRBAR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR4_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR3_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR3_RgRd(pdata, DMA_CHRBAR3_val);
	sprintf(debugfs_buf, "DMA_CHRBAR3     :%#x\n", DMA_CHRBAR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR3_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR2_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR2_RgRd(pdata, DMA_CHRBAR2_val);
	sprintf(debugfs_buf, "DMA_CHRBAR2     :%#x\n", DMA_CHRBAR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR2_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR1_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR1_RgRd(pdata, DMA_CHRBAR1_val);
	sprintf(debugfs_buf, "DMA_CHRBAR1     :%#x\n", DMA_CHRBAR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR1_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRBAR0_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRBAR0_RgRd(pdata, DMA_CHRBAR0_val);
	sprintf(debugfs_buf, "DMA_CHRBAR0     :%#x\n", DMA_CHRBAR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRBAR0_fops = {
	.open = debugfile_open,
	.read = DMA_CHRBAR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR7_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR7_RgRd(pdata, DMA_CHTBAR7_val);
	sprintf(debugfs_buf, "DMA_CHTBAR7     :%#x\n", DMA_CHTBAR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR7_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR6_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR6_RgRd(pdata, DMA_CHTBAR6_val);
	sprintf(debugfs_buf, "DMA_CHTBAR6     :%#x\n", DMA_CHTBAR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR6_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR5_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR5_RgRd(pdata, DMA_CHTBAR5_val);
	sprintf(debugfs_buf, "DMA_CHTBAR5     :%#x\n", DMA_CHTBAR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR5_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR4_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR4_RgRd(pdata, DMA_CHTBAR4_val);
	sprintf(debugfs_buf, "DMA_CHTBAR4     :%#x\n", DMA_CHTBAR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR4_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR3_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR3_RgRd(pdata, DMA_CHTBAR3_val);
	sprintf(debugfs_buf, "DMA_CHTBAR3     :%#x\n", DMA_CHTBAR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR3_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR2_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR2_RgRd(pdata, DMA_CHTBAR2_val);
	sprintf(debugfs_buf, "DMA_CHTBAR2     :%#x\n", DMA_CHTBAR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR2_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR1_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR1_RgRd(pdata, DMA_CHTBAR1_val);
	sprintf(debugfs_buf, "DMA_CHTBAR1     :%#x\n", DMA_CHTBAR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR1_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTBAR0_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTBAR0_RgRd(pdata, DMA_CHTBAR0_val);
	sprintf(debugfs_buf, "DMA_CHTBAR0     :%#x\n", DMA_CHTBAR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTBAR0_fops = {
	.open = debugfile_open,
	.read = DMA_CHTBAR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR7_RgRd(pdata, DMA_CHRDR7_val);
	sprintf(debugfs_buf, "DMA_CHRDR7      :%#x\n", DMA_CHRDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR7_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR6_RgRd(pdata, DMA_CHRDR6_val);
	sprintf(debugfs_buf, "DMA_CHRDR6      :%#x\n", DMA_CHRDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR6_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR5_RgRd(pdata, DMA_CHRDR5_val);
	sprintf(debugfs_buf, "DMA_CHRDR5      :%#x\n", DMA_CHRDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR5_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR4_RgRd(pdata, DMA_CHRDR4_val);
	sprintf(debugfs_buf, "DMA_CHRDR4      :%#x\n", DMA_CHRDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR4_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR3_RgRd(pdata, DMA_CHRDR3_val);
	sprintf(debugfs_buf, "DMA_CHRDR3      :%#x\n", DMA_CHRDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR3_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR2_RgRd(pdata, DMA_CHRDR2_val);
	sprintf(debugfs_buf, "DMA_CHRDR2      :%#x\n", DMA_CHRDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR2_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR1_RgRd(pdata, DMA_CHRDR1_val);
	sprintf(debugfs_buf, "DMA_CHRDR1      :%#x\n", DMA_CHRDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR1_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHRDR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHRDR0_RgRd(pdata, DMA_CHRDR0_val);
	sprintf(debugfs_buf, "DMA_CHRDR0      :%#x\n", DMA_CHRDR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHRDR0_fops = {
	.open = debugfile_open,
	.read = DMA_CHRDR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR7_RgRd(pdata, DMA_CHTDR7_val);
	sprintf(debugfs_buf, "DMA_CHTDR7      :%#x\n", DMA_CHTDR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR7_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR6_RgRd(pdata, DMA_CHTDR6_val);
	sprintf(debugfs_buf, "DMA_CHTDR6      :%#x\n", DMA_CHTDR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR6_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR5_RgRd(pdata, DMA_CHTDR5_val);
	sprintf(debugfs_buf, "DMA_CHTDR5      :%#x\n", DMA_CHTDR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR5_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR4_RgRd(pdata, DMA_CHTDR4_val);
	sprintf(debugfs_buf, "DMA_CHTDR4      :%#x\n", DMA_CHTDR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR4_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR3_RgRd(pdata, DMA_CHTDR3_val);
	sprintf(debugfs_buf, "DMA_CHTDR3      :%#x\n", DMA_CHTDR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR3_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR2_RgRd(pdata, DMA_CHTDR2_val);
	sprintf(debugfs_buf, "DMA_CHTDR2      :%#x\n", DMA_CHTDR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR2_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR1_RgRd(pdata, DMA_CHTDR1_val);
	sprintf(debugfs_buf, "DMA_CHTDR1      :%#x\n", DMA_CHTDR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR1_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CHTDR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CHTDR0_RgRd(pdata, DMA_CHTDR0_val);
	sprintf(debugfs_buf, "DMA_CHTDR0      :%#x\n", DMA_CHTDR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CHTDR0_fops = {
	.open = debugfile_open,
	.read = DMA_CHTDR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR7_RgRd(pdata, DMA_SFCSR7_val);
	sprintf(debugfs_buf, "DMA_SFCSR7      :%#x\n", DMA_SFCSR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR7_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR6_RgRd(pdata, DMA_SFCSR6_val);
	sprintf(debugfs_buf, "DMA_SFCSR6      :%#x\n", DMA_SFCSR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR6_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR5_RgRd(pdata, DMA_SFCSR5_val);
	sprintf(debugfs_buf, "DMA_SFCSR5      :%#x\n", DMA_SFCSR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR5_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR4_RgRd(pdata, DMA_SFCSR4_val);
	sprintf(debugfs_buf, "DMA_SFCSR4      :%#x\n", DMA_SFCSR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR4_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR3_RgRd(pdata, DMA_SFCSR3_val);
	sprintf(debugfs_buf, "DMA_SFCSR3      :%#x\n", DMA_SFCSR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR3_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR2_RgRd(pdata, DMA_SFCSR2_val);
	sprintf(debugfs_buf, "DMA_SFCSR2      :%#x\n", DMA_SFCSR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR2_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR1_RgRd(pdata, DMA_SFCSR1_val);
	sprintf(debugfs_buf, "DMA_SFCSR1      :%#x\n", DMA_SFCSR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR1_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SFCSR0_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SFCSR0_RgRd(pdata, DMA_SFCSR0_val);
	sprintf(debugfs_buf, "DMA_SFCSR0      :%#x\n", DMA_SFCSR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SFCSR0_fops = {
	.open = debugfile_open,
	.read = DMA_SFCSR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_IVLANTIRR_read(struct file *file, char __user * userbuf,
				  size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_IVLANTIRR_RgRd(pdata, MAC_IVLANTIRR_val);
	sprintf(debugfs_buf, "MAC_IVLANTIRR              :%#x\n",
		MAC_IVLANTIRR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_IVLANTIRR_fops = {
	.open = debugfile_open,
	.read = MAC_IVLANTIRR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_VLANTIRR_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_VLANTIRR_RgRd(pdata, MAC_VLANTIRR_val);
	sprintf(debugfs_buf, "MAC_VLANTIRR               :%#x\n",
		MAC_VLANTIRR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_VLANTIRR_fops = {
	.open = debugfile_open,
	.read = MAC_VLANTIRR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_VLANHTR_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_VLANHTR_RgRd(pdata, MAC_VLANHTR_val);
	sprintf(debugfs_buf, "MAC_VLANHTR                :%#x\n",
		MAC_VLANHTR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_VLANHTR_fops = {
	.open = debugfile_open,
	.read = MAC_VLANHTR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_VLANTR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_VLANTR_RgRd(pdata, MAC_VLANTR_val);
	sprintf(debugfs_buf, "MAC_VLANTR                 :%#x\n",
		MAC_VLANTR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_VLANTR_fops = {
	.open = debugfile_open,
	.read = MAC_VLANTR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_SBUS_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_SBUS_RgRd(pdata, DMA_SBUS_val);
	sprintf(debugfs_buf, "DMA_SBUS                   :%#x\n", DMA_SBUS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_SBUS_fops = {
	.open = debugfile_open,
	.read = DMA_SBUS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_BMR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_BMR_RgRd(pdata, DMA_BMR_val);
	sprintf(debugfs_buf, "DMA_BMR                    :%#x\n", DMA_BMR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_BMR_fops = {
	.open = debugfile_open,
	.read = DMA_BMR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0RCR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0RCR_RgRd(pdata, MTL_Q0RCR_val);
	sprintf(debugfs_buf, "MTL_Q0RCR       :%#x\n", MTL_Q0RCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0RCR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0RCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0OCR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0OCR_RgRd(pdata, MTL_Q0OCR_val);
	sprintf(debugfs_buf, "MTL_Q0OCR       :%#x\n", MTL_Q0OCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0OCR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0OCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0ROMR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0ROMR_RgRd(pdata, MTL_Q0ROMR_val);
	sprintf(debugfs_buf, "MTL_Q0ROMR      :%#x\n", MTL_Q0ROMR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0ROMR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0ROMR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0QR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0QR_RgRd(pdata, MTL_Q0QR_val);
	sprintf(debugfs_buf, "MTL_Q0QR        :%#x\n", MTL_Q0QR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0QR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0QR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0ECR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0ECR_RgRd(pdata, MTL_Q0ECR_val);
	sprintf(debugfs_buf, "MTL_Q0ECR       :%#x\n", MTL_Q0ECR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0ECR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0ECR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0UCR_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0UCR_RgRd(pdata, MTL_Q0UCR_val);
	sprintf(debugfs_buf, "MTL_Q0UCR       :%#x\n", MTL_Q0UCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0UCR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0UCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_Q0TOMR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_Q0TOMR_RgRd(pdata, MTL_Q0TOMR_val);
	sprintf(debugfs_buf, "MTL_Q0TOMR      :%#x\n", MTL_Q0TOMR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_Q0TOMR_fops = {
	.open = debugfile_open,
	.read = MTL_Q0TOMR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_RQDCM1R_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_RQDCM1R_RgRd(pdata, MTL_RQDCM1R_val);
	sprintf(debugfs_buf, "MTL_RQDCM1R     :%#x\n", MTL_RQDCM1R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_RQDCM1R_fops = {
	.open = debugfile_open,
	.read = MTL_RQDCM1R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_RQDCM0R_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_RQDCM0R_RgRd(pdata, MTL_RQDCM0R_val);
	sprintf(debugfs_buf, "MTL_RQDCM0R     :%#x\n", MTL_RQDCM0R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_RQDCM0R_fops = {
	.open = debugfile_open,
	.read = MTL_RQDCM0R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_FDDR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_FDDR_RgRd(pdata, MTL_FDDR_val);
	sprintf(debugfs_buf, "MTL_FDDR        :%#x\n", MTL_FDDR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_FDDR_fops = {
	.open = debugfile_open,
	.read = MTL_FDDR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_FDACS_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_FDACS_RgRd(pdata, MTL_FDACS_val);
	sprintf(debugfs_buf, "MTL_FDACS       :%#x\n", MTL_FDACS_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_FDACS_fops = {
	.open = debugfile_open,
	.read = MTL_FDACS_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MTL_OMR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MTL_OMR_RgRd(pdata, MTL_OMR_val);
	sprintf(debugfs_buf, "MTL_OMR         :%#x\n", MTL_OMR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MTL_OMR_fops = {
	.open = debugfile_open,
	.read = MTL_OMR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RQC3R_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RQC3R_RgRd(pdata, MAC_RQC3R_val);
	sprintf(debugfs_buf, "MAC_RQC3R       :%#x\n", MAC_RQC3R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RQC3R_fops = {
	.open = debugfile_open,
	.read = MAC_RQC3R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RQC2R_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RQC2R_RgRd(pdata, MAC_RQC2R_val);
	sprintf(debugfs_buf, "MAC_RQC2R       :%#x\n", MAC_RQC2R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RQC2R_fops = {
	.open = debugfile_open,
	.read = MAC_RQC2R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RQC1R_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RQC1R_RgRd(pdata, MAC_RQC1R_val);
	sprintf(debugfs_buf, "MAC_RQC1R       :%#x\n", MAC_RQC1R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RQC1R_fops = {
	.open = debugfile_open,
	.read = MAC_RQC1R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RQC0R_read(struct file *file, char __user * userbuf,
			      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RQC0R_RgRd(pdata, MAC_RQC0R_val);
	sprintf(debugfs_buf, "MAC_RQC0R       :%#x\n", MAC_RQC0R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RQC0R_fops = {
	.open = debugfile_open,
	.read = MAC_RQC0R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TQPM1R_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TQPM1R_RgRd(pdata, MAC_TQPM1R_val);
	sprintf(debugfs_buf, "MAC_TQPM1R      :%#x\n", MAC_TQPM1R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TQPM1R_fops = {
	.open = debugfile_open,
	.read = MAC_TQPM1R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_TQPM0R_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_TQPM0R_RgRd(pdata, MAC_TQPM0R_val);
	sprintf(debugfs_buf, "MAC_TQPM0R      :%#x\n", MAC_TQPM0R_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_TQPM0R_fops = {
	.open = debugfile_open,
	.read = MAC_TQPM0R_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_RFCR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_RFCR_RgRd(pdata, MAC_RFCR_val);
	sprintf(debugfs_buf, "MAC_RFCR        :%#x\n", MAC_RFCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_RFCR_fops = {
	.open = debugfile_open,
	.read = MAC_RFCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR7_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR7_RgRd(pdata, MAC_QTFCR7_val);
	sprintf(debugfs_buf, "MAC_QTFCR7      :%#x\n", MAC_QTFCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR7_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR6_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR6_RgRd(pdata, MAC_QTFCR6_val);
	sprintf(debugfs_buf, "MAC_QTFCR6      :%#x\n", MAC_QTFCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR6_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR5_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR5_RgRd(pdata, MAC_QTFCR5_val);
	sprintf(debugfs_buf, "MAC_QTFCR5      :%#x\n", MAC_QTFCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR5_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR4_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR4_RgRd(pdata, MAC_QTFCR4_val);
	sprintf(debugfs_buf, "MAC_QTFCR4      :%#x\n", MAC_QTFCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR4_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR3_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR3_RgRd(pdata, MAC_QTFCR3_val);
	sprintf(debugfs_buf, "MAC_QTFCR3      :%#x\n", MAC_QTFCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR3_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR2_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR2_RgRd(pdata, MAC_QTFCR2_val);
	sprintf(debugfs_buf, "MAC_QTFCR2      :%#x\n", MAC_QTFCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR2_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_QTFCR1_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_QTFCR1_RgRd(pdata, MAC_QTFCR1_val);
	sprintf(debugfs_buf, "MAC_QTFCR1      :%#x\n", MAC_QTFCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_QTFCR1_fops = {
	.open = debugfile_open,
	.read = MAC_QTFCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_Q0TFCR_read(struct file *file, char __user * userbuf,
			       size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_Q0TFCR_RgRd(pdata, MAC_Q0TFCR_val);
	sprintf(debugfs_buf, "MAC_Q0TFCR      :%#x\n", MAC_Q0TFCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_Q0TFCR_fops = {
	.open = debugfile_open,
	.read = MAC_Q0TFCR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR7_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR7_RgRd(pdata, DMA_AXI4CR7_val);
	sprintf(debugfs_buf, "DMA_AXI4CR7     :%#x\n", DMA_AXI4CR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR7_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR6_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR6_RgRd(pdata, DMA_AXI4CR6_val);
	sprintf(debugfs_buf, "DMA_AXI4CR6     :%#x\n", DMA_AXI4CR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR6_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR5_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR5_RgRd(pdata, DMA_AXI4CR5_val);
	sprintf(debugfs_buf, "DMA_AXI4CR5     :%#x\n", DMA_AXI4CR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR5_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR4_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR4_RgRd(pdata, DMA_AXI4CR4_val);
	sprintf(debugfs_buf, "DMA_AXI4CR4     :%#x\n", DMA_AXI4CR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR4_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR3_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR3_RgRd(pdata, DMA_AXI4CR3_val);
	sprintf(debugfs_buf, "DMA_AXI4CR3     :%#x\n", DMA_AXI4CR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR3_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR2_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR2_RgRd(pdata, DMA_AXI4CR2_val);
	sprintf(debugfs_buf, "DMA_AXI4CR2     :%#x\n", DMA_AXI4CR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR2_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR1_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR1_RgRd(pdata, DMA_AXI4CR1_val);
	sprintf(debugfs_buf, "DMA_AXI4CR1     :%#x\n", DMA_AXI4CR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR1_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_AXI4CR0_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_AXI4CR0_RgRd(pdata, DMA_AXI4CR0_val);
	sprintf(debugfs_buf, "DMA_AXI4CR0     :%#x\n", DMA_AXI4CR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_AXI4CR0_fops = {
	.open = debugfile_open,
	.read = DMA_AXI4CR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR7_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR7_RgRd(pdata, DMA_RCR7_val);
	sprintf(debugfs_buf, "DMA_RCR7        :%#x\n", DMA_RCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR7_fops = {
	.open = debugfile_open,
	.read = DMA_RCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR6_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR6_RgRd(pdata, DMA_RCR6_val);
	sprintf(debugfs_buf, "DMA_RCR6        :%#x\n", DMA_RCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR6_fops = {
	.open = debugfile_open,
	.read = DMA_RCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR5_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR5_RgRd(pdata, DMA_RCR5_val);
	sprintf(debugfs_buf, "DMA_RCR5        :%#x\n", DMA_RCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR5_fops = {
	.open = debugfile_open,
	.read = DMA_RCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR4_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR4_RgRd(pdata, DMA_RCR4_val);
	sprintf(debugfs_buf, "DMA_RCR4        :%#x\n", DMA_RCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR4_fops = {
	.open = debugfile_open,
	.read = DMA_RCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR3_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR3_RgRd(pdata, DMA_RCR3_val);
	sprintf(debugfs_buf, "DMA_RCR3        :%#x\n", DMA_RCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR3_fops = {
	.open = debugfile_open,
	.read = DMA_RCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR2_RgRd(pdata, DMA_RCR2_val);
	sprintf(debugfs_buf, "DMA_RCR2        :%#x\n", DMA_RCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR2_fops = {
	.open = debugfile_open,
	.read = DMA_RCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR1_RgRd(pdata, DMA_RCR1_val);
	sprintf(debugfs_buf, "DMA_RCR1        :%#x\n", DMA_RCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR1_fops = {
	.open = debugfile_open,
	.read = DMA_RCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_RCR0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_RCR0_RgRd(pdata, DMA_RCR0_val);
	sprintf(debugfs_buf, "DMA_RCR0        :%#x\n", DMA_RCR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_RCR0_fops = {
	.open = debugfile_open,
	.read = DMA_RCR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR7_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR7_RgRd(pdata, DMA_TCR7_val);
	sprintf(debugfs_buf, "DMA_TCR7        :%#x\n", DMA_TCR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR7_fops = {
	.open = debugfile_open,
	.read = DMA_TCR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR6_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR6_RgRd(pdata, DMA_TCR6_val);
	sprintf(debugfs_buf, "DMA_TCR6        :%#x\n", DMA_TCR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR6_fops = {
	.open = debugfile_open,
	.read = DMA_TCR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR5_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR5_RgRd(pdata, DMA_TCR5_val);
	sprintf(debugfs_buf, "DMA_TCR5        :%#x\n", DMA_TCR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR5_fops = {
	.open = debugfile_open,
	.read = DMA_TCR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR4_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR4_RgRd(pdata, DMA_TCR4_val);
	sprintf(debugfs_buf, "DMA_TCR4        :%#x\n", DMA_TCR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR4_fops = {
	.open = debugfile_open,
	.read = DMA_TCR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR3_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR3_RgRd(pdata, DMA_TCR3_val);
	sprintf(debugfs_buf, "DMA_TCR3        :%#x\n", DMA_TCR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR3_fops = {
	.open = debugfile_open,
	.read = DMA_TCR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR2_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR2_RgRd(pdata, DMA_TCR2_val);
	sprintf(debugfs_buf, "DMA_TCR2        :%#x\n", DMA_TCR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR2_fops = {
	.open = debugfile_open,
	.read = DMA_TCR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR1_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR1_RgRd(pdata, DMA_TCR1_val);
	sprintf(debugfs_buf, "DMA_TCR1        :%#x\n", DMA_TCR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR1_fops = {
	.open = debugfile_open,
	.read = DMA_TCR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_TCR0_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_TCR0_RgRd(pdata, DMA_TCR0_val);
	sprintf(debugfs_buf, "DMA_TCR0        :%#x\n", DMA_TCR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_TCR0_fops = {
	.open = debugfile_open,
	.read = DMA_TCR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR7_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR7_RgRd(pdata, DMA_CR7_val);
	sprintf(debugfs_buf, "DMA_CR7         :%#x\n", DMA_CR7_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR7_fops = {
	.open = debugfile_open,
	.read = DMA_CR7_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR6_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR6_RgRd(pdata, DMA_CR6_val);
	sprintf(debugfs_buf, "DMA_CR6         :%#x\n", DMA_CR6_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR6_fops = {
	.open = debugfile_open,
	.read = DMA_CR6_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR5_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR5_RgRd(pdata, DMA_CR5_val);
	sprintf(debugfs_buf, "DMA_CR5         :%#x\n", DMA_CR5_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR5_fops = {
	.open = debugfile_open,
	.read = DMA_CR5_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR4_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR4_RgRd(pdata, DMA_CR4_val);
	sprintf(debugfs_buf, "DMA_CR4         :%#x\n", DMA_CR4_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR4_fops = {
	.open = debugfile_open,
	.read = DMA_CR4_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR3_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR3_RgRd(pdata, DMA_CR3_val);
	sprintf(debugfs_buf, "DMA_CR3         :%#x\n", DMA_CR3_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR3_fops = {
	.open = debugfile_open,
	.read = DMA_CR3_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR2_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR2_RgRd(pdata, DMA_CR2_val);
	sprintf(debugfs_buf, "DMA_CR2         :%#x\n", DMA_CR2_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR2_fops = {
	.open = debugfile_open,
	.read = DMA_CR2_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR1_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR1_RgRd(pdata, DMA_CR1_val);
	sprintf(debugfs_buf, "DMA_CR1         :%#x\n", DMA_CR1_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR1_fops = {
	.open = debugfile_open,
	.read = DMA_CR1_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t DMA_CR0_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DMA_CR0_RgRd(pdata, DMA_CR0_val);
	sprintf(debugfs_buf, "DMA_CR0         :%#x\n", DMA_CR0_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations DMA_CR0_fops = {
	.open = debugfile_open,
	.read = DMA_CR0_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_WTR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_WTR_RgRd(pdata, MAC_WTR_val);
	sprintf(debugfs_buf, "MAC_WTR         :%#x\n", MAC_WTR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_WTR_fops = {
	.open = debugfile_open,
	.read = MAC_WTR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MPFR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MPFR_RgRd(pdata, MAC_MPFR_val);
	sprintf(debugfs_buf, "MAC_MPFR        :%#x\n", MAC_MPFR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MPFR_fops = {
	.open = debugfile_open,
	.read = MAC_MPFR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MECR_read(struct file *file, char __user * userbuf,
			     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MECR_RgRd(pdata, MAC_MECR_val);
	sprintf(debugfs_buf, "MAC_MECR        :%#x\n", MAC_MECR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MECR_fops = {
	.open = debugfile_open,
	.read = MAC_MECR_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MAC_MCR_read(struct file *file, char __user * userbuf,
			    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	MAC_MCR_RgRd(pdata, MAC_MCR_val);
	sprintf(debugfs_buf, "MAC_MCR         :%#x\n", MAC_MCR_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MAC_MCR_fops = {
	.open = debugfile_open,
	.read = MAC_MCR_read,
	.write = DWC_ETH_QOS_write,
};

/* For MII/GMII registers */
static ssize_t MII_BMCR_REG_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_BMCR,
				     &MII_BMCR_REG_val);
	sprintf(debugfs_buf,
		"Phy Control Reg(Basic Mode Control Reg)      :%#x\n",
		MII_BMCR_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_BMCR_REG_fops = {
	.open = debugfile_open,
	.read = MII_BMCR_REG_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MII_BMSR_REG_read(struct file *file, char __user * userbuf,
				 size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_BMSR,
				     &MII_BMSR_REG_val);
	sprintf(debugfs_buf,
		"Phy Status Reg(Basic Mode Status Reg)        :%#x\n",
		MII_BMSR_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_BMSR_REG_fops = {
	.open = debugfile_open,
	.read = MII_BMSR_REG_read,
};

static ssize_t MII_PHYSID1_REG_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_PHYSID1,
				     &MII_PHYSID1_REG_val);
	sprintf(debugfs_buf,
		"Phy Id (PHYS ID 1)                           :%#x\n",
		MII_PHYSID1_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_PHYSID1_REG_fops = {
	.open = debugfile_open,
	.read = MII_PHYSID1_REG_read,
};

static ssize_t MII_PHYSID2_REG_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_PHYSID2,
				     &MII_PHYSID2_REG_val);
	sprintf(debugfs_buf,
		"Phy Id (PHYS ID 2)                           :%#x\n",
		MII_PHYSID2_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_PHYSID2_REG_fops = {
	.open = debugfile_open,
	.read = MII_PHYSID2_REG_read,
};

static ssize_t MII_ADVERTISE_REG_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_ADVERTISE,
				     &MII_ADVERTISE_REG_val);
	sprintf(debugfs_buf,
		"Auto-nego Adv (Advertisement Control Reg)    :%#x\n",
		MII_ADVERTISE_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_ADVERTISE_REG_fops = {
	.open = debugfile_open,
	.read = MII_ADVERTISE_REG_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MII_LPA_REG_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_LPA,
				     &MII_LPA_REG_val);
	sprintf(debugfs_buf,
		"Auto-nego Lap (Link Partner Ability Reg)     :%#x\n",
		MII_LPA_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_LPA_REG_fops = {
	.open = debugfile_open,
	.read = MII_LPA_REG_read,
};

static ssize_t MII_EXPANSION_REG_read(struct file *file, char __user * userbuf,
				      size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_EXPANSION,
				     &MII_EXPANSION_REG_val);
	sprintf(debugfs_buf,
		"Auto-nego Exp (Extension Reg)                :%#x\n",
		MII_EXPANSION_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_EXPANSION_REG_fops = {
	.open = debugfile_open,
	.read = MII_EXPANSION_REG_read,
};

static ssize_t AUTO_NEGO_NP_REG_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr,
				     DWC_ETH_QOS_AUTO_NEGO_NP,
				     &AUTO_NEGO_NP_REG_val);
	sprintf(debugfs_buf,
		"Auto-nego Np                                 :%#x\n",
		AUTO_NEGO_NP_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations AUTO_NEGO_NP_REG_fops = {
	.open = debugfile_open,
	.read = AUTO_NEGO_NP_REG_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MII_ESTATUS_REG_read(struct file *file, char __user * userbuf,
				    size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_ESTATUS,
				     &MII_ESTATUS_REG_val);
	sprintf(debugfs_buf,
		"Extended Status Reg                          :%#x\n",
		MII_ESTATUS_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_ESTATUS_REG_fops = {
	.open = debugfile_open,
	.read = MII_ESTATUS_REG_read,
};

static ssize_t MII_CTRL1000_REG_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_CTRL1000,
				     &MII_CTRL1000_REG_val);
	sprintf(debugfs_buf,
		"1000 Ctl Reg (1000BASE-T Control Reg)        :%#x\n",
		MII_CTRL1000_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_CTRL1000_REG_fops = {
	.open = debugfile_open,
	.read = MII_CTRL1000_REG_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t MII_STAT1000_REG_read(struct file *file, char __user * userbuf,
				     size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, MII_STAT1000,
				     &MII_STAT1000_REG_val);
	sprintf(debugfs_buf,
		"1000 Sts Reg (1000BASE-T Status)             :%#x\n",
		MII_STAT1000_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations MII_STAT1000_REG_fops = {
	.open = debugfile_open,
	.read = MII_STAT1000_REG_read,
};

static ssize_t PHY_CTL_REG_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, DWC_ETH_QOS_PHY_CTL,
				     &PHY_CTL_REG_val);
	sprintf(debugfs_buf,
		"PHY Specific Ctl Reg                         :%#x\n",
		PHY_CTL_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations PHY_CTL_REG_fops = {
	.open = debugfile_open,
	.read = PHY_CTL_REG_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t PHY_STS_REG_read(struct file *file, char __user * userbuf,
				size_t count, loff_t * ppos)
{
	ssize_t ret;
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;

	DWC_ETH_QOS_mdio_read_direct(pdata, pdata->phyaddr, DWC_ETH_QOS_PHY_STS,
				     &PHY_STS_REG_val);
	sprintf(debugfs_buf,
		"PHY Specific Sts Reg                         :%#x\n",
		PHY_STS_REG_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations PHY_STS_REG_fops = {
	.open = debugfile_open,
	.read = PHY_STS_REG_read,
};

static ssize_t feature_drop_tx_pktburstcnt_read(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	ssize_t ret;

	sprintf(debugfs_buf, "feature_drop_tx_pktburstcnt             :%#x\n",
		feature_drop_tx_pktburstcnt_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations feature_drop_tx_pktburstcnt_fops = {
	.open = debugfile_open,
	.read = feature_drop_tx_pktburstcnt_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t qInx_read(struct file *file,
			 char __user * userbuf, size_t count, loff_t * ppos)
{
	ssize_t ret;

	sprintf(debugfs_buf, "qInx             :%#x\n", qInx_val);
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debugfs_buf,
				    strlen(debugfs_buf));
	return ret;
}

static const struct file_operations qInx_fops = {
	.open = debugfile_open,
	.read = qInx_read,
	.write = DWC_ETH_QOS_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read0(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read0\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num)
			, pRX_NORMAL_DESC[desc_num].RDES3,
			pRX_NORMAL_DESC[desc_num].RDES2,
			pRX_NORMAL_DESC[desc_num].RDES1,
			pRX_NORMAL_DESC[desc_num].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read0\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops0 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read0,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read1(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read1\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 20)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 20)
			, pRX_NORMAL_DESC[desc_num + 20].RDES3,
			pRX_NORMAL_DESC[desc_num + 20].RDES2,
			pRX_NORMAL_DESC[desc_num + 20].RDES1,
			pRX_NORMAL_DESC[desc_num + 20].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read1\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops1 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read1,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read2(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read2\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 40)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 40)
			, pRX_NORMAL_DESC[desc_num + 40].RDES3,
			pRX_NORMAL_DESC[desc_num + 40].RDES2,
			pRX_NORMAL_DESC[desc_num + 40].RDES1,
			pRX_NORMAL_DESC[desc_num + 40].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read2\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops2 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read2,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read3(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read3\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 60)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 60)
			, pRX_NORMAL_DESC[desc_num + 60].RDES3,
			pRX_NORMAL_DESC[desc_num + 60].RDES2,
			pRX_NORMAL_DESC[desc_num + 60].RDES1,
			pRX_NORMAL_DESC[desc_num + 60].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read3\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops3 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read3,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read4(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read4\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 80)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 80)
			, pRX_NORMAL_DESC[desc_num + 80].RDES3,
			pRX_NORMAL_DESC[desc_num + 80].RDES2,
			pRX_NORMAL_DESC[desc_num + 80].RDES1,
			pRX_NORMAL_DESC[desc_num + 80].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read4\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops4 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read4,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read5(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read5\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 100)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 100)
			, pRX_NORMAL_DESC[desc_num + 100].RDES3,
			pRX_NORMAL_DESC[desc_num + 100].RDES2,
			pRX_NORMAL_DESC[desc_num + 100].RDES1,
			pRX_NORMAL_DESC[desc_num + 100].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read5\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops5 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read5,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read6(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read6\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 120)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 120)
			, pRX_NORMAL_DESC[desc_num + 120].RDES3,
			pRX_NORMAL_DESC[desc_num + 120].RDES2,
			pRX_NORMAL_DESC[desc_num + 120].RDES1,
			pRX_NORMAL_DESC[desc_num + 120].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read6\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops6 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read6,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read7(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read7\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 140)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 140)
			, pRX_NORMAL_DESC[desc_num + 140].RDES3,
			pRX_NORMAL_DESC[desc_num + 140].RDES2,
			pRX_NORMAL_DESC[desc_num + 140].RDES1,
			pRX_NORMAL_DESC[desc_num + 140].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read7\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops7 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read7,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read8(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read8\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 160)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 160)
			, pRX_NORMAL_DESC[desc_num + 160].RDES3,
			pRX_NORMAL_DESC[desc_num + 160].RDES2,
			pRX_NORMAL_DESC[desc_num + 160].RDES1,
			pRX_NORMAL_DESC[desc_num + 160].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read8\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops8 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read8,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read9(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read9\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 180)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 180)
			, pRX_NORMAL_DESC[desc_num + 180].RDES3,
			pRX_NORMAL_DESC[desc_num + 180].RDES2,
			pRX_NORMAL_DESC[desc_num + 180].RDES1,
			pRX_NORMAL_DESC[desc_num + 180].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read9\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops9 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read9,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read10(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read10\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 200)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 200)
			, pRX_NORMAL_DESC[desc_num + 200].RDES3,
			pRX_NORMAL_DESC[desc_num + 200].RDES2,
			pRX_NORMAL_DESC[desc_num + 200].RDES1,
			pRX_NORMAL_DESC[desc_num + 200].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read10\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops10 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read10,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read11(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read11\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 220)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 220)
			, pRX_NORMAL_DESC[desc_num + 220].RDES3,
			pRX_NORMAL_DESC[desc_num + 220].RDES2,
			pRX_NORMAL_DESC[desc_num + 220].RDES1,
			pRX_NORMAL_DESC[desc_num + 220].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read11\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops11 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read11,
	.write = descriptor_write,
};

static ssize_t RX_NORMAL_DESC_descriptor_read12(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_RX_NORMAL_DESC *pRX_NORMAL_DESC = GET_RX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> RX_NORMAL_DESC_descriptor_read12\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(9952, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 16; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"RX_NORMAL_DESC.RDES3             :%x\n"
			"RX_NORMAL_DESC.RDES2             :%x\n"
			"RX_NORMAL_DESC.RDES1             :%x\n"
			"RX_NORMAL_DESC.RDES0             :%x\n",
			qInx_val, (int)(desc_num + 240)
			, (ULONG) GET_RX_DESC_DMA_ADDR(qInx_val, desc_num + 240)
			, pRX_NORMAL_DESC[desc_num + 240].RDES3,
			pRX_NORMAL_DESC[desc_num + 240].RDES2,
			pRX_NORMAL_DESC[desc_num + 240].RDES1,
			pRX_NORMAL_DESC[desc_num + 240].RDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- RX_NORMAL_DESC_descriptor_read12\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_desc_fops12 = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_descriptor_read12,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read0(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read0\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num)
			, pTX_NORMAL_DESC[desc_num].TDES3,
			pTX_NORMAL_DESC[desc_num].TDES2,
			pTX_NORMAL_DESC[desc_num].TDES1,
			pTX_NORMAL_DESC[desc_num].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read0\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops0 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read0,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read1(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read1\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 20)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 20)
			, pTX_NORMAL_DESC[desc_num + 20].TDES3,
			pTX_NORMAL_DESC[desc_num + 20].TDES2,
			pTX_NORMAL_DESC[desc_num + 20].TDES1,
			pTX_NORMAL_DESC[desc_num + 20].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read1\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops1 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read1,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read2(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read2\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 40)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 40)
			, pTX_NORMAL_DESC[desc_num + 40].TDES3,
			pTX_NORMAL_DESC[desc_num + 40].TDES2,
			pTX_NORMAL_DESC[desc_num + 40].TDES1,
			pTX_NORMAL_DESC[desc_num + 40].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read2\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops2 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read2,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read3(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read3\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 60)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 60)
			, pTX_NORMAL_DESC[desc_num + 60].TDES3,
			pTX_NORMAL_DESC[desc_num + 60].TDES2,
			pTX_NORMAL_DESC[desc_num + 60].TDES1,
			pTX_NORMAL_DESC[desc_num + 60].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read3\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops3 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read3,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read4(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read4\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 80)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 80)
			, pTX_NORMAL_DESC[desc_num + 80].TDES3,
			pTX_NORMAL_DESC[desc_num + 80].TDES2,
			pTX_NORMAL_DESC[desc_num + 80].TDES1,
			pTX_NORMAL_DESC[desc_num + 80].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read4\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops4 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read4,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read5(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read5\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 100)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 100)
			, pTX_NORMAL_DESC[desc_num + 100].TDES3,
			pTX_NORMAL_DESC[desc_num + 100].TDES2,
			pTX_NORMAL_DESC[desc_num + 100].TDES1,
			pTX_NORMAL_DESC[desc_num + 100].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read5\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops5 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read5,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read6(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read6\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 120)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 120)
			, pTX_NORMAL_DESC[desc_num + 120].TDES3,
			pTX_NORMAL_DESC[desc_num + 120].TDES2,
			pTX_NORMAL_DESC[desc_num + 120].TDES1,
			pTX_NORMAL_DESC[desc_num + 120].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read6\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops6 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read6,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read7(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read7\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 140)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 140)
			, pTX_NORMAL_DESC[desc_num + 140].TDES3,
			pTX_NORMAL_DESC[desc_num + 140].TDES2,
			pTX_NORMAL_DESC[desc_num + 140].TDES1,
			pTX_NORMAL_DESC[desc_num + 140].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read7\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops7 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read7,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read8(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read8\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 160)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 160)
			, pTX_NORMAL_DESC[desc_num + 160].TDES3,
			pTX_NORMAL_DESC[desc_num + 160].TDES2,
			pTX_NORMAL_DESC[desc_num + 160].TDES1,
			pTX_NORMAL_DESC[desc_num + 160].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read8\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops8 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read8,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read9(struct file *file,
					       char __user * userbuf,
					       size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read9\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 180)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 180)
			, pTX_NORMAL_DESC[desc_num + 180].TDES3,
			pTX_NORMAL_DESC[desc_num + 180].TDES2,
			pTX_NORMAL_DESC[desc_num + 180].TDES1,
			pTX_NORMAL_DESC[desc_num + 180].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read9\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops9 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read9,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read10(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read10\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 200)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 200)
			, pTX_NORMAL_DESC[desc_num + 200].TDES3,
			pTX_NORMAL_DESC[desc_num + 200].TDES2,
			pTX_NORMAL_DESC[desc_num + 200].TDES1,
			pTX_NORMAL_DESC[desc_num + 200].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read10\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops10 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read10,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read11(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read11\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(12440, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 20; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 220)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 220)
			, pTX_NORMAL_DESC[desc_num + 220].TDES3,
			pTX_NORMAL_DESC[desc_num + 220].TDES2,
			pTX_NORMAL_DESC[desc_num + 220].TDES1,
			pTX_NORMAL_DESC[desc_num + 220].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read11\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops11 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read11,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_descriptor_read12(struct file *file,
						char __user * userbuf,
						size_t count, loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct s_TX_NORMAL_DESC *pTX_NORMAL_DESC = GET_TX_DESC_PTR(qInx_val, 0);
	ssize_t ret = 0, desc_num = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;

	DBGPR("--> TX_NORMAL_DESC_descriptor_read12\n");
	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(9952, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';
	for (desc_num = 0; desc_num < 16; desc_num++) {
		sprintf(tmpBuf,
			"Channel %d Descriptor %d's [%#lx] contents are:\n"
			"TX_NORMAL_DESC.TDES3             :%x\n"
			"TX_NORMAL_DESC.TDES2             :%x\n"
			"TX_NORMAL_DESC.TDES1             :%x\n"
			"TX_NORMAL_DESC.TDES0             :%x\n",
			qInx_val, (int)(desc_num + 240)
			, (ULONG) GET_TX_DESC_DMA_ADDR(qInx_val, desc_num + 240)
			, pTX_NORMAL_DESC[desc_num + 240].TDES3,
			pTX_NORMAL_DESC[desc_num + 240].TDES2,
			pTX_NORMAL_DESC[desc_num + 240].TDES1,
			pTX_NORMAL_DESC[desc_num + 240].TDES0);
		strcat(debug_buf, tmpBuf);
	}
	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_descriptor_read12\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_desc_fops12 = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_descriptor_read12,
	.write = descriptor_write,
};

static ssize_t TX_NORMAL_DESC_STATUS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct DWC_ETH_QOS_tx_wrapper_descriptor *desc_data =
	    GET_TX_WRAPPER_DESC(qInx_val);
	ssize_t ret = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;
	int i;
	/* shadow variables */
	unsigned int cur_tx = desc_data->cur_tx;
	unsigned int dirty_tx = desc_data->dirty_tx;
	unsigned int free_desc_cnt = desc_data->free_desc_cnt;
	unsigned int tx_pkt_queued = desc_data->tx_pkt_queued;

	unsigned int tmp_cur_tx = 0;
	unsigned int tmp_dirty_tx = 0;

	DBGPR("--> TX_NORMAL_DESC_STATUS_read\n");

	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(9952, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';

	sprintf(debug_buf,
		"\nCHANNEL %d TX DESCRIPTORS STATUS......................\n\n",
		qInx_val);

	sprintf(tmpBuf, "TOTAL DESCRIPTOR COUNT                   : %d\n\n"
		"TOTAL FREE DESCRIPTOR COUNT              : %d\n\n"
		"TOTAL DESCRIPTOR QUEUED FOR TRANSMISSION : %d\n\n"
		"NEXT DESCRIPTOR TO BE USED BY DRIVER     : %d\n\n"
		"NEXT DESCRIPTOR TO BE USED BY DEVICE     : %d\n\n",
		TX_DESC_CNT, free_desc_cnt, tx_pkt_queued, cur_tx, dirty_tx);
	strcat(debug_buf, tmpBuf);

	/* Free tx descriptor index */
	if ((free_desc_cnt == TX_DESC_CNT) && (tx_pkt_queued == 0)) {
		sprintf(tmpBuf,
			"ALL %d DESCRIPTORS ARE FREE, HENCE NO PACKETS ARE QUEUED FOR TRANSMISSION\n",
			TX_DESC_CNT);
		strcat(debug_buf, tmpBuf);
	} else if ((free_desc_cnt == 0) && (tx_pkt_queued == TX_DESC_CNT)) {
		sprintf(tmpBuf,
			"ALL %d DESCRIPTORS ARE USED FOR TRANSMISSION, HENCE NO FREE DESCRIPTORS\n",
			TX_DESC_CNT);
		strcat(debug_buf, tmpBuf);
	} else {
		if (free_desc_cnt > 0) {
			tmp_cur_tx = cur_tx;
			tmp_dirty_tx = dirty_tx;
			i = 1;
			sprintf(tmpBuf,
				"FREE DESCRIPTORS INDEX(es) are           :\n\n");
			strcat(debug_buf, tmpBuf);
			if (tmp_cur_tx > tmp_dirty_tx) {
				for (; tmp_cur_tx < TX_DESC_CNT; tmp_cur_tx++) {
					sprintf(tmpBuf, "%d ", tmp_cur_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
				for (tmp_cur_tx = 0; tmp_cur_tx < tmp_dirty_tx;
				     tmp_cur_tx++) {
					sprintf(tmpBuf, "%d ", tmp_cur_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
			} else {	/* (tmp_cur_tx < tmp_dirty_tx) */
				for (; tmp_cur_tx > tmp_dirty_tx; tmp_cur_tx++) {
					sprintf(tmpBuf, "%d ", tmp_cur_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
			}
			sprintf(tmpBuf, "\n");
			strcat(debug_buf, tmpBuf);
		}

		if (tx_pkt_queued > 0) {
			tmp_cur_tx = cur_tx;
			tmp_dirty_tx = dirty_tx;
			i = 1;
			sprintf(tmpBuf,
				"\nUSED DESCRIPTORS INDEX(es) are           :\n\n");
			strcat(debug_buf, tmpBuf);
			if (tmp_dirty_tx < tmp_cur_tx) {
				for (; tmp_dirty_tx < tmp_cur_tx;
				     tmp_dirty_tx++) {
					sprintf(tmpBuf, "%d ", tmp_dirty_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
			} else {	/* (tmp_dirty_tx < tmp_cur_tx) */
				for (; tmp_dirty_tx < TX_DESC_CNT;
				     tmp_dirty_tx++) {
					sprintf(tmpBuf, "%d ", tmp_dirty_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
				for (tmp_dirty_tx = 0;
				     tmp_dirty_tx < tmp_cur_tx;
				     tmp_dirty_tx++) {
					sprintf(tmpBuf, "%d ", tmp_dirty_tx);
					strcat(debug_buf, tmpBuf);
					if ((i % 16) == 0) {
						sprintf(tmpBuf, "\n");
						strcat(debug_buf, tmpBuf);
					}
					i++;
				}
			}
			sprintf(tmpBuf, "\n");
			strcat(debug_buf, tmpBuf);
		}
	}
	sprintf(tmpBuf, "\n.........................................DONE\n\n");
	strcat(debug_buf, tmpBuf);

	sprintf(tmpBuf, "curr mss %d\r\n", desc_data->default_mss);
	strcat(debug_buf, tmpBuf);

	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<-- TX_NORMAL_DESC_STATUS_read\n");
	return ret;
}

static const struct file_operations TX_NORMAL_DESC_STATUS_fops = {
	.open = debugfile_open,
	.read = TX_NORMAL_DESC_STATUS_read,
};

static ssize_t RX_NORMAL_DESC_STATUS_read(struct file *file,
					  char __user * userbuf, size_t count,
					  loff_t * ppos)
{
	struct DWC_ETH_QOS_prv_data *pdata = file->private_data;
	struct DWC_ETH_QOS_rx_wrapper_descriptor *desc_data =
	    GET_RX_WRAPPER_DESC(qInx_val);
	ssize_t ret = 0;
	char *tmpBuf = NULL;
	char *debug_buf = NULL;
	UINT varDMA_CHRDR;	/* head ptr */
	UINT varDMA_RDTP_RPDR;	/* tail ptr */
	UINT varDMA_RDLAR;	/* tail ptr */
	UINT tail_idx;
	UINT head_idx;
	UINT drv_desc_cnt = 0;
	UINT dev_desc_cnt = 0;
	unsigned int cur_rx = desc_data->cur_rx;

	DBGPR("-->RX_NORMAL_DESC_STATUS_read\n");

	tmpBuf = (char *)kmalloc(622, GFP_KERNEL);
	if (!tmpBuf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf = (char *)kmalloc(9952, GFP_KERNEL);
	if (!debug_buf) {
		printk(KERN_ERR "Memory allocation failed:\n");
		return -ENOMEM;
	}
	debug_buf[0] = '\0';

	cur_rx = desc_data->cur_rx;
	DMA_CHRDR_RgRd(pdata, qInx_val, varDMA_CHRDR);
	DMA_RDTP_RPDR_RgRd(pdata, qInx_val, varDMA_RDTP_RPDR);
	DMA_RDLAR_RgRd(pdata, qInx_val, varDMA_RDLAR);

	tail_idx =
	    (varDMA_RDTP_RPDR - varDMA_RDLAR) / sizeof(struct s_RX_NORMAL_DESC);

	head_idx =
	    (varDMA_CHRDR - varDMA_RDLAR) / sizeof(struct s_RX_NORMAL_DESC);

	if (tail_idx == head_idx) {
		dev_desc_cnt = 0;
		drv_desc_cnt = RX_DESC_CNT;
		printk(KERN_ALERT "\nhead:[%d]%#x tail:[%d]%#x cur-rx:%d\n",
		       head_idx, varDMA_CHRDR, tail_idx,
		       varDMA_RDTP_RPDR, cur_rx);
	} else if (head_idx > tail_idx) {	/* tail ptr is above head ptr */
		dev_desc_cnt = RX_DESC_CNT - (head_idx - tail_idx) + 1;
		drv_desc_cnt = RX_DESC_CNT - dev_desc_cnt;
	} else {		/* tail ptr is below head ptr */
		dev_desc_cnt = (tail_idx - head_idx + 1);
		drv_desc_cnt = RX_DESC_CNT - dev_desc_cnt;
	}

	sprintf(debug_buf,
		"\nCHANNEL %d : RX DESCRIPTORS STATUS....................\n\n",
		qInx_val);

	sprintf(tmpBuf, "TOTAL DESCRIPTOR COUNT                   : %d\n\n"
		"TOTAL DESCRIPTORS OWNED BY DEVICE        : %d\n\n"
		"TOTAL DESCRIPTOR OWNED BY DRIVER         : %d\n\n"
		"NEXT DESCRIPTOR TO BE USED BY DEVICE     : %d\n\n"
		"NEXT DESCRIPTOR TO BE USED BY DRIVER     : %d\n\n",
		RX_DESC_CNT, dev_desc_cnt, drv_desc_cnt, head_idx, cur_rx);
	strcat(debug_buf, tmpBuf);
	sprintf(tmpBuf, "\n.........................................DONE\n\n");
	strcat(debug_buf, tmpBuf);

	ret =
	    simple_read_from_buffer(userbuf, count, ppos, debug_buf,
				    strlen(debug_buf));
	kfree(tmpBuf);
	kfree(debug_buf);

	DBGPR("<--RX_NORMAL_DESC_STATUS_read\n");
	return ret;
}

static const struct file_operations RX_NORMAL_DESC_STATUS_fops = {
	.open = debugfile_open,
	.read = RX_NORMAL_DESC_STATUS_read,
};

/*!
*  \brief  API to create debugfs files
*
* \details This function will creates debug files required for debugging.
* All debug files are created inside a directory named as ddgen_DWC_ETH_QOS
* (debugfs directory /sys/kernel/debug/ddgen_DWC_ETH_QOS directory).
* Note: Before doing any read or write operation, debugfs has to be mounted on system.
*
* \retval  0 on Success.
* \retval  error number on Failure.
*/

int create_debug_files(struct DWC_ETH_QOS_prv_data *pdata)
{
	int ret = 0;
	struct dentry *registers;
	struct dentry *MAC_MA32_127LR127;
	struct dentry *MAC_MA32_127LR126;
	struct dentry *MAC_MA32_127LR125;
	struct dentry *MAC_MA32_127LR124;
	struct dentry *MAC_MA32_127LR123;
	struct dentry *MAC_MA32_127LR122;
	struct dentry *MAC_MA32_127LR121;
	struct dentry *MAC_MA32_127LR120;
	struct dentry *MAC_MA32_127LR119;
	struct dentry *MAC_MA32_127LR118;
	struct dentry *MAC_MA32_127LR117;
	struct dentry *MAC_MA32_127LR116;
	struct dentry *MAC_MA32_127LR115;
	struct dentry *MAC_MA32_127LR114;
	struct dentry *MAC_MA32_127LR113;
	struct dentry *MAC_MA32_127LR112;
	struct dentry *MAC_MA32_127LR111;
	struct dentry *MAC_MA32_127LR110;
	struct dentry *MAC_MA32_127LR109;
	struct dentry *MAC_MA32_127LR108;
	struct dentry *MAC_MA32_127LR107;
	struct dentry *MAC_MA32_127LR106;
	struct dentry *MAC_MA32_127LR105;
	struct dentry *MAC_MA32_127LR104;
	struct dentry *MAC_MA32_127LR103;
	struct dentry *MAC_MA32_127LR102;
	struct dentry *MAC_MA32_127LR101;
	struct dentry *MAC_MA32_127LR100;
	struct dentry *MAC_MA32_127LR99;
	struct dentry *MAC_MA32_127LR98;
	struct dentry *MAC_MA32_127LR97;
	struct dentry *MAC_MA32_127LR96;
	struct dentry *MAC_MA32_127LR95;
	struct dentry *MAC_MA32_127LR94;
	struct dentry *MAC_MA32_127LR93;
	struct dentry *MAC_MA32_127LR92;
	struct dentry *MAC_MA32_127LR91;
	struct dentry *MAC_MA32_127LR90;
	struct dentry *MAC_MA32_127LR89;
	struct dentry *MAC_MA32_127LR88;
	struct dentry *MAC_MA32_127LR87;
	struct dentry *MAC_MA32_127LR86;
	struct dentry *MAC_MA32_127LR85;
	struct dentry *MAC_MA32_127LR84;
	struct dentry *MAC_MA32_127LR83;
	struct dentry *MAC_MA32_127LR82;
	struct dentry *MAC_MA32_127LR81;
	struct dentry *MAC_MA32_127LR80;
	struct dentry *MAC_MA32_127LR79;
	struct dentry *MAC_MA32_127LR78;
	struct dentry *MAC_MA32_127LR77;
	struct dentry *MAC_MA32_127LR76;
	struct dentry *MAC_MA32_127LR75;
	struct dentry *MAC_MA32_127LR74;
	struct dentry *MAC_MA32_127LR73;
	struct dentry *MAC_MA32_127LR72;
	struct dentry *MAC_MA32_127LR71;
	struct dentry *MAC_MA32_127LR70;
	struct dentry *MAC_MA32_127LR69;
	struct dentry *MAC_MA32_127LR68;
	struct dentry *MAC_MA32_127LR67;
	struct dentry *MAC_MA32_127LR66;
	struct dentry *MAC_MA32_127LR65;
	struct dentry *MAC_MA32_127LR64;
	struct dentry *MAC_MA32_127LR63;
	struct dentry *MAC_MA32_127LR62;
	struct dentry *MAC_MA32_127LR61;
	struct dentry *MAC_MA32_127LR60;
	struct dentry *MAC_MA32_127LR59;
	struct dentry *MAC_MA32_127LR58;
	struct dentry *MAC_MA32_127LR57;
	struct dentry *MAC_MA32_127LR56;
	struct dentry *MAC_MA32_127LR55;
	struct dentry *MAC_MA32_127LR54;
	struct dentry *MAC_MA32_127LR53;
	struct dentry *MAC_MA32_127LR52;
	struct dentry *MAC_MA32_127LR51;
	struct dentry *MAC_MA32_127LR50;
	struct dentry *MAC_MA32_127LR49;
	struct dentry *MAC_MA32_127LR48;
	struct dentry *MAC_MA32_127LR47;
	struct dentry *MAC_MA32_127LR46;
	struct dentry *MAC_MA32_127LR45;
	struct dentry *MAC_MA32_127LR44;
	struct dentry *MAC_MA32_127LR43;
	struct dentry *MAC_MA32_127LR42;
	struct dentry *MAC_MA32_127LR41;
	struct dentry *MAC_MA32_127LR40;
	struct dentry *MAC_MA32_127LR39;
	struct dentry *MAC_MA32_127LR38;
	struct dentry *MAC_MA32_127LR37;
	struct dentry *MAC_MA32_127LR36;
	struct dentry *MAC_MA32_127LR35;
	struct dentry *MAC_MA32_127LR34;
	struct dentry *MAC_MA32_127LR33;
	struct dentry *MAC_MA32_127LR32;
	struct dentry *MAC_MA32_127HR127;
	struct dentry *MAC_MA32_127HR126;
	struct dentry *MAC_MA32_127HR125;
	struct dentry *MAC_MA32_127HR124;
	struct dentry *MAC_MA32_127HR123;
	struct dentry *MAC_MA32_127HR122;
	struct dentry *MAC_MA32_127HR121;
	struct dentry *MAC_MA32_127HR120;
	struct dentry *MAC_MA32_127HR119;
	struct dentry *MAC_MA32_127HR118;
	struct dentry *MAC_MA32_127HR117;
	struct dentry *MAC_MA32_127HR116;
	struct dentry *MAC_MA32_127HR115;
	struct dentry *MAC_MA32_127HR114;
	struct dentry *MAC_MA32_127HR113;
	struct dentry *MAC_MA32_127HR112;
	struct dentry *MAC_MA32_127HR111;
	struct dentry *MAC_MA32_127HR110;
	struct dentry *MAC_MA32_127HR109;
	struct dentry *MAC_MA32_127HR108;
	struct dentry *MAC_MA32_127HR107;
	struct dentry *MAC_MA32_127HR106;
	struct dentry *MAC_MA32_127HR105;
	struct dentry *MAC_MA32_127HR104;
	struct dentry *MAC_MA32_127HR103;
	struct dentry *MAC_MA32_127HR102;
	struct dentry *MAC_MA32_127HR101;
	struct dentry *MAC_MA32_127HR100;
	struct dentry *MAC_MA32_127HR99;
	struct dentry *MAC_MA32_127HR98;
	struct dentry *MAC_MA32_127HR97;
	struct dentry *MAC_MA32_127HR96;
	struct dentry *MAC_MA32_127HR95;
	struct dentry *MAC_MA32_127HR94;
	struct dentry *MAC_MA32_127HR93;
	struct dentry *MAC_MA32_127HR92;
	struct dentry *MAC_MA32_127HR91;
	struct dentry *MAC_MA32_127HR90;
	struct dentry *MAC_MA32_127HR89;
	struct dentry *MAC_MA32_127HR88;
	struct dentry *MAC_MA32_127HR87;
	struct dentry *MAC_MA32_127HR86;
	struct dentry *MAC_MA32_127HR85;
	struct dentry *MAC_MA32_127HR84;
	struct dentry *MAC_MA32_127HR83;
	struct dentry *MAC_MA32_127HR82;
	struct dentry *MAC_MA32_127HR81;
	struct dentry *MAC_MA32_127HR80;
	struct dentry *MAC_MA32_127HR79;
	struct dentry *MAC_MA32_127HR78;
	struct dentry *MAC_MA32_127HR77;
	struct dentry *MAC_MA32_127HR76;
	struct dentry *MAC_MA32_127HR75;
	struct dentry *MAC_MA32_127HR74;
	struct dentry *MAC_MA32_127HR73;
	struct dentry *MAC_MA32_127HR72;
	struct dentry *MAC_MA32_127HR71;
	struct dentry *MAC_MA32_127HR70;
	struct dentry *MAC_MA32_127HR69;
	struct dentry *MAC_MA32_127HR68;
	struct dentry *MAC_MA32_127HR67;
	struct dentry *MAC_MA32_127HR66;
	struct dentry *MAC_MA32_127HR65;
	struct dentry *MAC_MA32_127HR64;
	struct dentry *MAC_MA32_127HR63;
	struct dentry *MAC_MA32_127HR62;
	struct dentry *MAC_MA32_127HR61;
	struct dentry *MAC_MA32_127HR60;
	struct dentry *MAC_MA32_127HR59;
	struct dentry *MAC_MA32_127HR58;
	struct dentry *MAC_MA32_127HR57;
	struct dentry *MAC_MA32_127HR56;
	struct dentry *MAC_MA32_127HR55;
	struct dentry *MAC_MA32_127HR54;
	struct dentry *MAC_MA32_127HR53;
	struct dentry *MAC_MA32_127HR52;
	struct dentry *MAC_MA32_127HR51;
	struct dentry *MAC_MA32_127HR50;
	struct dentry *MAC_MA32_127HR49;
	struct dentry *MAC_MA32_127HR48;
	struct dentry *MAC_MA32_127HR47;
	struct dentry *MAC_MA32_127HR46;
	struct dentry *MAC_MA32_127HR45;
	struct dentry *MAC_MA32_127HR44;
	struct dentry *MAC_MA32_127HR43;
	struct dentry *MAC_MA32_127HR42;
	struct dentry *MAC_MA32_127HR41;
	struct dentry *MAC_MA32_127HR40;
	struct dentry *MAC_MA32_127HR39;
	struct dentry *MAC_MA32_127HR38;
	struct dentry *MAC_MA32_127HR37;
	struct dentry *MAC_MA32_127HR36;
	struct dentry *MAC_MA32_127HR35;
	struct dentry *MAC_MA32_127HR34;
	struct dentry *MAC_MA32_127HR33;
	struct dentry *MAC_MA32_127HR32;
	struct dentry *MAC_MA1_31LR31;
	struct dentry *MAC_MA1_31LR30;
	struct dentry *MAC_MA1_31LR29;
	struct dentry *MAC_MA1_31LR28;
	struct dentry *MAC_MA1_31LR27;
	struct dentry *MAC_MA1_31LR26;
	struct dentry *MAC_MA1_31LR25;
	struct dentry *MAC_MA1_31LR24;
	struct dentry *MAC_MA1_31LR23;
	struct dentry *MAC_MA1_31LR22;
	struct dentry *MAC_MA1_31LR21;
	struct dentry *MAC_MA1_31LR20;
	struct dentry *MAC_MA1_31LR19;
	struct dentry *MAC_MA1_31LR18;
	struct dentry *MAC_MA1_31LR17;
	struct dentry *MAC_MA1_31LR16;
	struct dentry *MAC_MA1_31LR15;
	struct dentry *MAC_MA1_31LR14;
	struct dentry *MAC_MA1_31LR13;
	struct dentry *MAC_MA1_31LR12;
	struct dentry *MAC_MA1_31LR11;
	struct dentry *MAC_MA1_31LR10;
	struct dentry *MAC_MA1_31LR9;
	struct dentry *MAC_MA1_31LR8;
	struct dentry *MAC_MA1_31LR7;
	struct dentry *MAC_MA1_31LR6;
	struct dentry *MAC_MA1_31LR5;
	struct dentry *MAC_MA1_31LR4;
	struct dentry *MAC_MA1_31LR3;
	struct dentry *MAC_MA1_31LR2;
	struct dentry *MAC_MA1_31LR1;
	struct dentry *MAC_MA1_31HR31;
	struct dentry *MAC_MA1_31HR30;
	struct dentry *MAC_MA1_31HR29;
	struct dentry *MAC_MA1_31HR28;
	struct dentry *MAC_MA1_31HR27;
	struct dentry *MAC_MA1_31HR26;
	struct dentry *MAC_MA1_31HR25;
	struct dentry *MAC_MA1_31HR24;
	struct dentry *MAC_MA1_31HR23;
	struct dentry *MAC_MA1_31HR22;
	struct dentry *MAC_MA1_31HR21;
	struct dentry *MAC_MA1_31HR20;
	struct dentry *MAC_MA1_31HR19;
	struct dentry *MAC_MA1_31HR18;
	struct dentry *MAC_MA1_31HR17;
	struct dentry *MAC_MA1_31HR16;
	struct dentry *MAC_MA1_31HR15;
	struct dentry *MAC_MA1_31HR14;
	struct dentry *MAC_MA1_31HR13;
	struct dentry *MAC_MA1_31HR12;
	struct dentry *MAC_MA1_31HR11;
	struct dentry *MAC_MA1_31HR10;
	struct dentry *MAC_MA1_31HR9;
	struct dentry *MAC_MA1_31HR8;
	struct dentry *MAC_MA1_31HR7;
	struct dentry *MAC_MA1_31HR6;
	struct dentry *MAC_MA1_31HR5;
	struct dentry *MAC_MA1_31HR4;
	struct dentry *MAC_MA1_31HR3;
	struct dentry *MAC_MA1_31HR2;
	struct dentry *MAC_MA1_31HR1;
	struct dentry *MAC_ARPA;
	struct dentry *MAC_L3A3R7;
	struct dentry *MAC_L3A3R6;
	struct dentry *MAC_L3A3R5;
	struct dentry *MAC_L3A3R4;
	struct dentry *MAC_L3A3R3;
	struct dentry *MAC_L3A3R2;
	struct dentry *MAC_L3A3R1;
	struct dentry *MAC_L3A3R0;
	struct dentry *MAC_L3A2R7;
	struct dentry *MAC_L3A2R6;
	struct dentry *MAC_L3A2R5;
	struct dentry *MAC_L3A2R4;
	struct dentry *MAC_L3A2R3;
	struct dentry *MAC_L3A2R2;
	struct dentry *MAC_L3A2R1;
	struct dentry *MAC_L3A2R0;
	struct dentry *MAC_L3A1R7;
	struct dentry *MAC_L3A1R6;
	struct dentry *MAC_L3A1R5;
	struct dentry *MAC_L3A1R4;
	struct dentry *MAC_L3A1R3;
	struct dentry *MAC_L3A1R2;
	struct dentry *MAC_L3A1R1;
	struct dentry *MAC_L3A1R0;
	struct dentry *MAC_L3A0R7;
	struct dentry *MAC_L3A0R6;
	struct dentry *MAC_L3A0R5;
	struct dentry *MAC_L3A0R4;
	struct dentry *MAC_L3A0R3;
	struct dentry *MAC_L3A0R2;
	struct dentry *MAC_L3A0R1;
	struct dentry *MAC_L3A0R0;
	struct dentry *MAC_L4AR7;
	struct dentry *MAC_L4AR6;
	struct dentry *MAC_L4AR5;
	struct dentry *MAC_L4AR4;
	struct dentry *MAC_L4AR3;
	struct dentry *MAC_L4AR2;
	struct dentry *MAC_L4AR1;
	struct dentry *MAC_L4AR0;
	struct dentry *MAC_L3L4CR7;
	struct dentry *MAC_L3L4CR6;
	struct dentry *MAC_L3L4CR5;
	struct dentry *MAC_L3L4CR4;
	struct dentry *MAC_L3L4CR3;
	struct dentry *MAC_L3L4CR2;
	struct dentry *MAC_L3L4CR1;
	struct dentry *MAC_L3L4CR0;
	struct dentry *MAC_GPIOS;
	struct dentry *MAC_PCS;
	struct dentry *MAC_TES;
	struct dentry *MAC_AE;
	struct dentry *MAC_ALPA;
	struct dentry *MAC_AAD;
	struct dentry *MAC_ANS;
	struct dentry *MAC_ANC;
	struct dentry *MAC_LPC;
	struct dentry *MAC_LPS;
	struct dentry *MAC_LMIR;
	struct dentry *MAC_SPI2R;
	struct dentry *MAC_SPI1R;
	struct dentry *MAC_SPI0R;
	struct dentry *MAC_PTO_CR;
	struct dentry *MAC_PPS_WIDTH3;
	struct dentry *MAC_PPS_WIDTH2;
	struct dentry *MAC_PPS_WIDTH1;
	struct dentry *MAC_PPS_WIDTH0;
	struct dentry *MAC_PPS_INTVAL3;
	struct dentry *MAC_PPS_INTVAL2;
	struct dentry *MAC_PPS_INTVAL1;
	struct dentry *MAC_PPS_INTVAL0;
	struct dentry *MAC_PPS_TTNS3;
	struct dentry *MAC_PPS_TTNS2;
	struct dentry *MAC_PPS_TTNS1;
	struct dentry *MAC_PPS_TTNS0;
	struct dentry *MAC_PPS_TTS3;
	struct dentry *MAC_PPS_TTS2;
	struct dentry *MAC_PPS_TTS1;
	struct dentry *MAC_PPS_TTS0;
	struct dentry *MAC_PPSC;
	struct dentry *MAC_TEAC;
	struct dentry *MAC_TIAC;
	struct dentry *MAC_ATS;
	struct dentry *MAC_ATN;
	struct dentry *MAC_AC;
	struct dentry *MAC_TTN;
	struct dentry *MAC_TTSN;
	struct dentry *MAC_TSR;
	struct dentry *MAC_STHWR;
	struct dentry *MAC_TAR;
	struct dentry *MAC_STNSUR;
	struct dentry *MAC_STSUR;
	struct dentry *MAC_STNSR;
	struct dentry *MAC_STSR;
	struct dentry *MAC_SSIR;
	struct dentry *MAC_TCR;
	struct dentry *MTL_DSR;
	struct dentry *MAC_RWPFFR;
	struct dentry *MAC_RTSR;
	struct dentry *MTL_IER;
	struct dentry *MTL_QRCR7;
	struct dentry *MTL_QRCR6;
	struct dentry *MTL_QRCR5;
	struct dentry *MTL_QRCR4;
	struct dentry *MTL_QRCR3;
	struct dentry *MTL_QRCR2;
	struct dentry *MTL_QRCR1;
	struct dentry *MTL_QRDR7;
	struct dentry *MTL_QRDR6;
	struct dentry *MTL_QRDR5;
	struct dentry *MTL_QRDR4;
	struct dentry *MTL_QRDR3;
	struct dentry *MTL_QRDR2;
	struct dentry *MTL_QRDR1;
	struct dentry *MTL_QOCR7;
	struct dentry *MTL_QOCR6;
	struct dentry *MTL_QOCR5;
	struct dentry *MTL_QOCR4;
	struct dentry *MTL_QOCR3;
	struct dentry *MTL_QOCR2;
	struct dentry *MTL_QOCR1;
	struct dentry *MTL_QROMR7;
	struct dentry *MTL_QROMR6;
	struct dentry *MTL_QROMR5;
	struct dentry *MTL_QROMR4;
	struct dentry *MTL_QROMR3;
	struct dentry *MTL_QROMR2;
	struct dentry *MTL_QROMR1;
	struct dentry *MTL_QLCR7;
	struct dentry *MTL_QLCR6;
	struct dentry *MTL_QLCR5;
	struct dentry *MTL_QLCR4;
	struct dentry *MTL_QLCR3;
	struct dentry *MTL_QLCR2;
	struct dentry *MTL_QLCR1;
	struct dentry *MTL_QHCR7;
	struct dentry *MTL_QHCR6;
	struct dentry *MTL_QHCR5;
	struct dentry *MTL_QHCR4;
	struct dentry *MTL_QHCR3;
	struct dentry *MTL_QHCR2;
	struct dentry *MTL_QHCR1;
	struct dentry *MTL_QSSCR7;
	struct dentry *MTL_QSSCR6;
	struct dentry *MTL_QSSCR5;
	struct dentry *MTL_QSSCR4;
	struct dentry *MTL_QSSCR3;
	struct dentry *MTL_QSSCR2;
	struct dentry *MTL_QSSCR1;
	struct dentry *MTL_QW7;
	struct dentry *MTL_QW6;
	struct dentry *MTL_QW5;
	struct dentry *MTL_QW4;
	struct dentry *MTL_QW3;
	struct dentry *MTL_QW2;
	struct dentry *MTL_QW1;
	struct dentry *MTL_QESR7;
	struct dentry *MTL_QESR6;
	struct dentry *MTL_QESR5;
	struct dentry *MTL_QESR4;
	struct dentry *MTL_QESR3;
	struct dentry *MTL_QESR2;
	struct dentry *MTL_QESR1;
	struct dentry *MTL_QECR7;
	struct dentry *MTL_QECR6;
	struct dentry *MTL_QECR5;
	struct dentry *MTL_QECR4;
	struct dentry *MTL_QECR3;
	struct dentry *MTL_QECR2;
	struct dentry *MTL_QECR1;
	struct dentry *MTL_QTDR7;
	struct dentry *MTL_QTDR6;
	struct dentry *MTL_QTDR5;
	struct dentry *MTL_QTDR4;
	struct dentry *MTL_QTDR3;
	struct dentry *MTL_QTDR2;
	struct dentry *MTL_QTDR1;
	struct dentry *MTL_QUCR7;
	struct dentry *MTL_QUCR6;
	struct dentry *MTL_QUCR5;
	struct dentry *MTL_QUCR4;
	struct dentry *MTL_QUCR3;
	struct dentry *MTL_QUCR2;
	struct dentry *MTL_QUCR1;
	struct dentry *MTL_QTOMR7;
	struct dentry *MTL_QTOMR6;
	struct dentry *MTL_QTOMR5;
	struct dentry *MTL_QTOMR4;
	struct dentry *MTL_QTOMR3;
	struct dentry *MTL_QTOMR2;
	struct dentry *MTL_QTOMR1;
	struct dentry *MAC_PMTCSR;
	struct dentry *MMC_RXICMP_ERR_OCTETS;
	struct dentry *MMC_RXICMP_GD_OCTETS;
	struct dentry *MMC_RXTCP_ERR_OCTETS;
	struct dentry *MMC_RXTCP_GD_OCTETS;
	struct dentry *MMC_RXUDP_ERR_OCTETS;
	struct dentry *MMC_RXUDP_GD_OCTETS;
	struct dentry *MMC_RXIPV6_NOPAY_OCTETS;
	struct dentry *MMC_RXIPV6_HDRERR_OCTETS;
	struct dentry *MMC_RXIPV6_GD_OCTETS;
	struct dentry *MMC_RXIPV4_UDSBL_OCTETS;
	struct dentry *MMC_RXIPV4_FRAG_OCTETS;
	struct dentry *MMC_RXIPV4_NOPAY_OCTETS;
	struct dentry *MMC_RXIPV4_HDRERR_OCTETS;
	struct dentry *MMC_RXIPV4_GD_OCTETS;
	struct dentry *MMC_RXICMP_ERR_PKTS;
	struct dentry *MMC_RXICMP_GD_PKTS;
	struct dentry *MMC_RXTCP_ERR_PKTS;
	struct dentry *MMC_RXTCP_GD_PKTS;
	struct dentry *MMC_RXUDP_ERR_PKTS;
	struct dentry *MMC_RXUDP_GD_PKTS;
	struct dentry *MMC_RXIPV6_NOPAY_PKTS;
	struct dentry *MMC_RXIPV6_HDRERR_PKTS;
	struct dentry *MMC_RXIPV6_GD_PKTS;
	struct dentry *MMC_RXIPV4_UBSBL_PKTS;
	struct dentry *MMC_RXIPV4_FRAG_PKTS;
	struct dentry *MMC_RXIPV4_NOPAY_PKTS;
	struct dentry *MMC_RXIPV4_HDRERR_PKTS;
	struct dentry *MMC_RXIPV4_GD_PKTS;
	struct dentry *MMC_RXCTRLPACKETS_G;
	struct dentry *MMC_RXRCVERROR;
	struct dentry *MMC_RXWATCHDOGERROR;
	struct dentry *MMC_RXVLANPACKETS_GB;
	struct dentry *MMC_RXFIFOOVERFLOW;
	struct dentry *MMC_RXPAUSEPACKETS;
	struct dentry *MMC_RXOUTOFRANGETYPE;
	struct dentry *MMC_RXLENGTHERROR;
	struct dentry *MMC_RXUNICASTPACKETS_G;
	struct dentry *MMC_RX1024TOMAXOCTETS_GB;
	struct dentry *MMC_RX512TO1023OCTETS_GB;
	struct dentry *MMC_RX256TO511OCTETS_GB;
	struct dentry *MMC_RX128TO255OCTETS_GB;
	struct dentry *MMC_RX65TO127OCTETS_GB;
	struct dentry *MMC_RX64OCTETS_GB;
	struct dentry *MMC_RXOVERSIZE_G;
	struct dentry *MMC_RXUNDERSIZE_G;
	struct dentry *MMC_RXJABBERERROR;
	struct dentry *MMC_RXRUNTERROR;
	struct dentry *MMC_RXALIGNMENTERROR;
	struct dentry *MMC_RXCRCERROR;
	struct dentry *MMC_RXMULTICASTPACKETS_G;
	struct dentry *MMC_RXBROADCASTPACKETS_G;
	struct dentry *MMC_RXOCTETCOUNT_G;
	struct dentry *MMC_RXOCTETCOUNT_GB;
	struct dentry *MMC_RXPACKETCOUNT_GB;
	struct dentry *MMC_TXOVERSIZE_G;
	struct dentry *MMC_TXVLANPACKETS_G;
	struct dentry *MMC_TXPAUSEPACKETS;
	struct dentry *MMC_TXEXCESSDEF;
	struct dentry *MMC_TXPACKETSCOUNT_G;
	struct dentry *MMC_TXOCTETCOUNT_G;
	struct dentry *MMC_TXCARRIERERROR;
	struct dentry *MMC_TXEXESSCOL;
	struct dentry *MMC_TXLATECOL;
	struct dentry *MMC_TXDEFERRED;
	struct dentry *MMC_TXMULTICOL_G;
	struct dentry *MMC_TXSINGLECOL_G;
	struct dentry *MMC_TXUNDERFLOWERROR;
	struct dentry *MMC_TXBROADCASTPACKETS_GB;
	struct dentry *MMC_TXMULTICASTPACKETS_GB;
	struct dentry *MMC_TXUNICASTPACKETS_GB;
	struct dentry *MMC_TX1024TOMAXOCTETS_GB;
	struct dentry *MMC_TX512TO1023OCTETS_GB;
	struct dentry *MMC_TX256TO511OCTETS_GB;
	struct dentry *MMC_TX128TO255OCTETS_GB;
	struct dentry *MMC_TX65TO127OCTETS_GB;
	struct dentry *MMC_TX64OCTETS_GB;
	struct dentry *MMC_TXMULTICASTPACKETS_G;
	struct dentry *MMC_TXBROADCASTPACKETS_G;
	struct dentry *MMC_TXPACKETCOUNT_GB;
	struct dentry *MMC_TXOCTETCOUNT_GB;
	struct dentry *MMC_IPC_INTR_RX;
	struct dentry *MMC_IPC_INTR_MASK_RX;
	struct dentry *MMC_INTR_MASK_TX;
	struct dentry *MMC_INTR_MASK_RX;
	struct dentry *MMC_INTR_TX;
	struct dentry *MMC_INTR_RX;
	struct dentry *MMC_CNTRL;
	struct dentry *MAC_MA1LR;
	struct dentry *MAC_MA1HR;
	struct dentry *MAC_MA0LR;
	struct dentry *MAC_MA0HR;
	struct dentry *MAC_GPIOR;
	struct dentry *MAC_GMIIDR;
	struct dentry *MAC_GMIIAR;
	struct dentry *MAC_HFR2;
	struct dentry *MAC_HFR1;
	struct dentry *MAC_HFR0;
	struct dentry *MAC_MDR;
	struct dentry *MAC_VR;
	struct dentry *MAC_HTR7;
	struct dentry *MAC_HTR6;
	struct dentry *MAC_HTR5;
	struct dentry *MAC_HTR4;
	struct dentry *MAC_HTR3;
	struct dentry *MAC_HTR2;
	struct dentry *MAC_HTR1;
	struct dentry *MAC_HTR0;
	struct dentry *DMA_RIWTR7;
	struct dentry *DMA_RIWTR6;
	struct dentry *DMA_RIWTR5;
	struct dentry *DMA_RIWTR4;
	struct dentry *DMA_RIWTR3;
	struct dentry *DMA_RIWTR2;
	struct dentry *DMA_RIWTR1;
	struct dentry *DMA_RIWTR0;
	struct dentry *DMA_RDRLR7;
	struct dentry *DMA_RDRLR6;
	struct dentry *DMA_RDRLR5;
	struct dentry *DMA_RDRLR4;
	struct dentry *DMA_RDRLR3;
	struct dentry *DMA_RDRLR2;
	struct dentry *DMA_RDRLR1;
	struct dentry *DMA_RDRLR0;
	struct dentry *DMA_TDRLR7;
	struct dentry *DMA_TDRLR6;
	struct dentry *DMA_TDRLR5;
	struct dentry *DMA_TDRLR4;
	struct dentry *DMA_TDRLR3;
	struct dentry *DMA_TDRLR2;
	struct dentry *DMA_TDRLR1;
	struct dentry *DMA_TDRLR0;
	struct dentry *DMA_RDTP_RPDR7;
	struct dentry *DMA_RDTP_RPDR6;
	struct dentry *DMA_RDTP_RPDR5;
	struct dentry *DMA_RDTP_RPDR4;
	struct dentry *DMA_RDTP_RPDR3;
	struct dentry *DMA_RDTP_RPDR2;
	struct dentry *DMA_RDTP_RPDR1;
	struct dentry *DMA_RDTP_RPDR0;
	struct dentry *DMA_TDTP_TPDR7;
	struct dentry *DMA_TDTP_TPDR6;
	struct dentry *DMA_TDTP_TPDR5;
	struct dentry *DMA_TDTP_TPDR4;
	struct dentry *DMA_TDTP_TPDR3;
	struct dentry *DMA_TDTP_TPDR2;
	struct dentry *DMA_TDTP_TPDR1;
	struct dentry *DMA_TDTP_TPDR0;
	struct dentry *DMA_RDLAR7;
	struct dentry *DMA_RDLAR6;
	struct dentry *DMA_RDLAR5;
	struct dentry *DMA_RDLAR4;
	struct dentry *DMA_RDLAR3;
	struct dentry *DMA_RDLAR2;
	struct dentry *DMA_RDLAR1;
	struct dentry *DMA_RDLAR0;
	struct dentry *DMA_TDLAR7;
	struct dentry *DMA_TDLAR6;
	struct dentry *DMA_TDLAR5;
	struct dentry *DMA_TDLAR4;
	struct dentry *DMA_TDLAR3;
	struct dentry *DMA_TDLAR2;
	struct dentry *DMA_TDLAR1;
	struct dentry *DMA_TDLAR0;
	struct dentry *DMA_IER7;
	struct dentry *DMA_IER6;
	struct dentry *DMA_IER5;
	struct dentry *DMA_IER4;
	struct dentry *DMA_IER3;
	struct dentry *DMA_IER2;
	struct dentry *DMA_IER1;
	struct dentry *DMA_IER0;
	struct dentry *MAC_IMR;
	struct dentry *MAC_ISR;
	struct dentry *MTL_ISR;
	struct dentry *DMA_SR7;
	struct dentry *DMA_SR6;
	struct dentry *DMA_SR5;
	struct dentry *DMA_SR4;
	struct dentry *DMA_SR3;
	struct dentry *DMA_SR2;
	struct dentry *DMA_SR1;
	struct dentry *DMA_SR0;
	struct dentry *DMA_ISR;
	struct dentry *DMA_DSR2;
	struct dentry *DMA_DSR1;
	struct dentry *DMA_DSR0;
	struct dentry *MTL_Q0RDR;
	struct dentry *MTL_Q0ESR;
	struct dentry *MTL_Q0TDR;
	struct dentry *DMA_CHRBAR7;
	struct dentry *DMA_CHRBAR6;
	struct dentry *DMA_CHRBAR5;
	struct dentry *DMA_CHRBAR4;
	struct dentry *DMA_CHRBAR3;
	struct dentry *DMA_CHRBAR2;
	struct dentry *DMA_CHRBAR1;
	struct dentry *DMA_CHRBAR0;
	struct dentry *DMA_CHTBAR7;
	struct dentry *DMA_CHTBAR6;
	struct dentry *DMA_CHTBAR5;
	struct dentry *DMA_CHTBAR4;
	struct dentry *DMA_CHTBAR3;
	struct dentry *DMA_CHTBAR2;
	struct dentry *DMA_CHTBAR1;
	struct dentry *DMA_CHTBAR0;
	struct dentry *DMA_CHRDR7;
	struct dentry *DMA_CHRDR6;
	struct dentry *DMA_CHRDR5;
	struct dentry *DMA_CHRDR4;
	struct dentry *DMA_CHRDR3;
	struct dentry *DMA_CHRDR2;
	struct dentry *DMA_CHRDR1;
	struct dentry *DMA_CHRDR0;
	struct dentry *DMA_CHTDR7;
	struct dentry *DMA_CHTDR6;
	struct dentry *DMA_CHTDR5;
	struct dentry *DMA_CHTDR4;
	struct dentry *DMA_CHTDR3;
	struct dentry *DMA_CHTDR2;
	struct dentry *DMA_CHTDR1;
	struct dentry *DMA_CHTDR0;
	struct dentry *DMA_SFCSR7;
	struct dentry *DMA_SFCSR6;
	struct dentry *DMA_SFCSR5;
	struct dentry *DMA_SFCSR4;
	struct dentry *DMA_SFCSR3;
	struct dentry *DMA_SFCSR2;
	struct dentry *DMA_SFCSR1;
	struct dentry *DMA_SFCSR0;
	struct dentry *MAC_IVLANTIRR;
	struct dentry *MAC_VLANTIRR;
	struct dentry *MAC_VLANHTR;
	struct dentry *MAC_VLANTR;
	struct dentry *DMA_SBUS;
	struct dentry *DMA_BMR;
	struct dentry *MTL_Q0RCR;
	struct dentry *MTL_Q0OCR;
	struct dentry *MTL_Q0ROMR;
	struct dentry *MTL_Q0QR;
	struct dentry *MTL_Q0ECR;
	struct dentry *MTL_Q0UCR;
	struct dentry *MTL_Q0TOMR;
	struct dentry *MTL_RQDCM1R;
	struct dentry *MTL_RQDCM0R;
	struct dentry *MTL_FDDR;
	struct dentry *MTL_FDACS;
	struct dentry *MTL_OMR;
	struct dentry *MAC_RQC3R;
	struct dentry *MAC_RQC2R;
	struct dentry *MAC_RQC1R;
	struct dentry *MAC_RQC0R;
	struct dentry *MAC_TQPM1R;
	struct dentry *MAC_TQPM0R;
	struct dentry *MAC_RFCR;
	struct dentry *MAC_QTFCR7;
	struct dentry *MAC_QTFCR6;
	struct dentry *MAC_QTFCR5;
	struct dentry *MAC_QTFCR4;
	struct dentry *MAC_QTFCR3;
	struct dentry *MAC_QTFCR2;
	struct dentry *MAC_QTFCR1;
	struct dentry *MAC_Q0TFCR;
	struct dentry *DMA_AXI4CR7;
	struct dentry *DMA_AXI4CR6;
	struct dentry *DMA_AXI4CR5;
	struct dentry *DMA_AXI4CR4;
	struct dentry *DMA_AXI4CR3;
	struct dentry *DMA_AXI4CR2;
	struct dentry *DMA_AXI4CR1;
	struct dentry *DMA_AXI4CR0;
	struct dentry *DMA_RCR7;
	struct dentry *DMA_RCR6;
	struct dentry *DMA_RCR5;
	struct dentry *DMA_RCR4;
	struct dentry *DMA_RCR3;
	struct dentry *DMA_RCR2;
	struct dentry *DMA_RCR1;
	struct dentry *DMA_RCR0;
	struct dentry *DMA_TCR7;
	struct dentry *DMA_TCR6;
	struct dentry *DMA_TCR5;
	struct dentry *DMA_TCR4;
	struct dentry *DMA_TCR3;
	struct dentry *DMA_TCR2;
	struct dentry *DMA_TCR1;
	struct dentry *DMA_TCR0;
	struct dentry *DMA_CR7;
	struct dentry *DMA_CR6;
	struct dentry *DMA_CR5;
	struct dentry *DMA_CR4;
	struct dentry *DMA_CR3;
	struct dentry *DMA_CR2;
	struct dentry *DMA_CR1;
	struct dentry *DMA_CR0;
	struct dentry *MAC_WTR;
	struct dentry *MAC_MPFR;
	struct dentry *MAC_MECR;
	struct dentry *MAC_MCR;
	/* MII/GMII registers */
	struct dentry *MII_BMCR_REG;
	struct dentry *MII_BMSR_REG;
	struct dentry *MII_PHYSID1_REG;
	struct dentry *MII_PHYSID2_REG;
	struct dentry *MII_ADVERTISE_REG;
	struct dentry *MII_LPA_REG;
	struct dentry *MII_EXPANSION_REG;
	struct dentry *AUTO_NEGO_NP_REG;
	struct dentry *MII_ESTATUS_REG;
	struct dentry *MII_CTRL1000_REG;
	struct dentry *MII_STAT1000_REG;
	struct dentry *PHY_CTL_REG;
	struct dentry *PHY_STS_REG;
	struct dentry *feature_drop_tx_pktburstcnt;
	struct dentry *qInx;

	struct dentry *RX_NORMAL_DESC_desc0;
	struct dentry *RX_NORMAL_DESC_desc1;
	struct dentry *RX_NORMAL_DESC_desc2;
	struct dentry *RX_NORMAL_DESC_desc3;
	struct dentry *RX_NORMAL_DESC_desc4;
	struct dentry *RX_NORMAL_DESC_desc5;
	struct dentry *RX_NORMAL_DESC_desc6;
	struct dentry *RX_NORMAL_DESC_desc7;
	struct dentry *RX_NORMAL_DESC_desc8;
	struct dentry *RX_NORMAL_DESC_desc9;
	struct dentry *RX_NORMAL_DESC_desc10;
	struct dentry *RX_NORMAL_DESC_desc11;
	struct dentry *RX_NORMAL_DESC_desc12;
	struct dentry *TX_NORMAL_DESC_desc0;
	struct dentry *TX_NORMAL_DESC_desc1;
	struct dentry *TX_NORMAL_DESC_desc2;
	struct dentry *TX_NORMAL_DESC_desc3;
	struct dentry *TX_NORMAL_DESC_desc4;
	struct dentry *TX_NORMAL_DESC_desc5;
	struct dentry *TX_NORMAL_DESC_desc6;
	struct dentry *TX_NORMAL_DESC_desc7;
	struct dentry *TX_NORMAL_DESC_desc8;
	struct dentry *TX_NORMAL_DESC_desc9;
	struct dentry *TX_NORMAL_DESC_desc10;
	struct dentry *TX_NORMAL_DESC_desc11;
	struct dentry *TX_NORMAL_DESC_desc12;
	struct dentry *TX_NORMAL_DESC_STATUS;
	struct dentry *RX_NORMAL_DESC_STATUS;
	struct dentry *dir;

	DBGPR("--> create_debug_files\n");

	sprintf(pdata->dbg_data.debugfs_buf, "ddgen_DWC_ETH_QOS:%s",
		dev_name(&pdata->pdev->dev));
	dir = debugfs_create_dir(pdata->dbg_data.debugfs_buf, NULL);
	if (dir == NULL) {
		printk(KERN_INFO
		       "error creating directory: DWC_ETH_QOS_debug\n");
		return -ENODEV;
	}
	pdata->dbg_data.dir = dir;

	registers =
	    debugfs_create_file("registers", 744, dir, pdata,
				&registers_fops);
	if (registers == NULL) {
		printk(KERN_INFO "error creating file: registers\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR127 =
	    debugfs_create_file("MAC_MA32_127LR127", 744, dir,
				pdata,
				&MAC_MA32_127LR127_fops);
	if (MAC_MA32_127LR127 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR127\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR126 =
	    debugfs_create_file("MAC_MA32_127LR126", 744, dir,
				pdata,
				&MAC_MA32_127LR126_fops);
	if (MAC_MA32_127LR126 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR126\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR125 =
	    debugfs_create_file("MAC_MA32_127LR125", 744, dir,
				pdata,
				&MAC_MA32_127LR125_fops);
	if (MAC_MA32_127LR125 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR125\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR124 =
	    debugfs_create_file("MAC_MA32_127LR124", 744, dir,
				pdata,
				&MAC_MA32_127LR124_fops);
	if (MAC_MA32_127LR124 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR124\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR123 =
	    debugfs_create_file("MAC_MA32_127LR123", 744, dir,
				pdata,
				&MAC_MA32_127LR123_fops);
	if (MAC_MA32_127LR123 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR123\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR122 =
	    debugfs_create_file("MAC_MA32_127LR122", 744, dir,
				pdata,
				&MAC_MA32_127LR122_fops);
	if (MAC_MA32_127LR122 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR122\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR121 =
	    debugfs_create_file("MAC_MA32_127LR121", 744, dir,
				pdata,
				&MAC_MA32_127LR121_fops);
	if (MAC_MA32_127LR121 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR121\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR120 =
	    debugfs_create_file("MAC_MA32_127LR120", 744, dir,
				pdata,
				&MAC_MA32_127LR120_fops);
	if (MAC_MA32_127LR120 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR120\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR119 =
	    debugfs_create_file("MAC_MA32_127LR119", 744, dir,
				pdata,
				&MAC_MA32_127LR119_fops);
	if (MAC_MA32_127LR119 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR119\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR118 =
	    debugfs_create_file("MAC_MA32_127LR118", 744, dir,
				pdata,
				&MAC_MA32_127LR118_fops);
	if (MAC_MA32_127LR118 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR118\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR117 =
	    debugfs_create_file("MAC_MA32_127LR117", 744, dir,
				pdata,
				&MAC_MA32_127LR117_fops);
	if (MAC_MA32_127LR117 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR117\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR116 =
	    debugfs_create_file("MAC_MA32_127LR116", 744, dir,
				pdata,
				&MAC_MA32_127LR116_fops);
	if (MAC_MA32_127LR116 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR116\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR115 =
	    debugfs_create_file("MAC_MA32_127LR115", 744, dir,
				pdata,
				&MAC_MA32_127LR115_fops);
	if (MAC_MA32_127LR115 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR115\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR114 =
	    debugfs_create_file("MAC_MA32_127LR114", 744, dir,
				pdata,
				&MAC_MA32_127LR114_fops);
	if (MAC_MA32_127LR114 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR114\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR113 =
	    debugfs_create_file("MAC_MA32_127LR113", 744, dir,
				pdata,
				&MAC_MA32_127LR113_fops);
	if (MAC_MA32_127LR113 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR113\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR112 =
	    debugfs_create_file("MAC_MA32_127LR112", 744, dir,
				pdata,
				&MAC_MA32_127LR112_fops);
	if (MAC_MA32_127LR112 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR112\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR111 =
	    debugfs_create_file("MAC_MA32_127LR111", 744, dir,
				pdata,
				&MAC_MA32_127LR111_fops);
	if (MAC_MA32_127LR111 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR111\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR110 =
	    debugfs_create_file("MAC_MA32_127LR110", 744, dir,
				pdata,
				&MAC_MA32_127LR110_fops);
	if (MAC_MA32_127LR110 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR110\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR109 =
	    debugfs_create_file("MAC_MA32_127LR109", 744, dir,
				pdata,
				&MAC_MA32_127LR109_fops);
	if (MAC_MA32_127LR109 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR109\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR108 =
	    debugfs_create_file("MAC_MA32_127LR108", 744, dir,
				pdata,
				&MAC_MA32_127LR108_fops);
	if (MAC_MA32_127LR108 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR108\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR107 =
	    debugfs_create_file("MAC_MA32_127LR107", 744, dir,
				pdata,
				&MAC_MA32_127LR107_fops);
	if (MAC_MA32_127LR107 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR107\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR106 =
	    debugfs_create_file("MAC_MA32_127LR106", 744, dir,
				pdata,
				&MAC_MA32_127LR106_fops);
	if (MAC_MA32_127LR106 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR106\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR105 =
	    debugfs_create_file("MAC_MA32_127LR105", 744, dir,
				pdata,
				&MAC_MA32_127LR105_fops);
	if (MAC_MA32_127LR105 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR105\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR104 =
	    debugfs_create_file("MAC_MA32_127LR104", 744, dir,
				pdata,
				&MAC_MA32_127LR104_fops);
	if (MAC_MA32_127LR104 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR104\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR103 =
	    debugfs_create_file("MAC_MA32_127LR103", 744, dir,
				pdata,
				&MAC_MA32_127LR103_fops);
	if (MAC_MA32_127LR103 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR103\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR102 =
	    debugfs_create_file("MAC_MA32_127LR102", 744, dir,
				pdata,
				&MAC_MA32_127LR102_fops);
	if (MAC_MA32_127LR102 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR102\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR101 =
	    debugfs_create_file("MAC_MA32_127LR101", 744, dir,
				pdata,
				&MAC_MA32_127LR101_fops);
	if (MAC_MA32_127LR101 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR101\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR100 =
	    debugfs_create_file("MAC_MA32_127LR100", 744, dir,
				pdata,
				&MAC_MA32_127LR100_fops);
	if (MAC_MA32_127LR100 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR100\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR99 =
	    debugfs_create_file("MAC_MA32_127LR99", 744, dir,
				pdata, &MAC_MA32_127LR99_fops);
	if (MAC_MA32_127LR99 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR99\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR98 =
	    debugfs_create_file("MAC_MA32_127LR98", 744, dir,
				pdata, &MAC_MA32_127LR98_fops);
	if (MAC_MA32_127LR98 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR98\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR97 =
	    debugfs_create_file("MAC_MA32_127LR97", 744, dir,
				pdata, &MAC_MA32_127LR97_fops);
	if (MAC_MA32_127LR97 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR97\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR96 =
	    debugfs_create_file("MAC_MA32_127LR96", 744, dir,
				pdata, &MAC_MA32_127LR96_fops);
	if (MAC_MA32_127LR96 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR96\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR95 =
	    debugfs_create_file("MAC_MA32_127LR95", 744, dir,
				pdata, &MAC_MA32_127LR95_fops);
	if (MAC_MA32_127LR95 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR95\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR94 =
	    debugfs_create_file("MAC_MA32_127LR94", 744, dir,
				pdata, &MAC_MA32_127LR94_fops);
	if (MAC_MA32_127LR94 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR94\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR93 =
	    debugfs_create_file("MAC_MA32_127LR93", 744, dir,
				pdata, &MAC_MA32_127LR93_fops);
	if (MAC_MA32_127LR93 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR93\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR92 =
	    debugfs_create_file("MAC_MA32_127LR92", 744, dir,
				pdata, &MAC_MA32_127LR92_fops);
	if (MAC_MA32_127LR92 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR92\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR91 =
	    debugfs_create_file("MAC_MA32_127LR91", 744, dir,
				pdata, &MAC_MA32_127LR91_fops);
	if (MAC_MA32_127LR91 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR91\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR90 =
	    debugfs_create_file("MAC_MA32_127LR90", 744, dir,
				pdata, &MAC_MA32_127LR90_fops);
	if (MAC_MA32_127LR90 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR90\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR89 =
	    debugfs_create_file("MAC_MA32_127LR89", 744, dir,
				pdata, &MAC_MA32_127LR89_fops);
	if (MAC_MA32_127LR89 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR89\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR88 =
	    debugfs_create_file("MAC_MA32_127LR88", 744, dir,
				pdata, &MAC_MA32_127LR88_fops);
	if (MAC_MA32_127LR88 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR88\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR87 =
	    debugfs_create_file("MAC_MA32_127LR87", 744, dir,
				pdata, &MAC_MA32_127LR87_fops);
	if (MAC_MA32_127LR87 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR87\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR86 =
	    debugfs_create_file("MAC_MA32_127LR86", 744, dir,
				pdata, &MAC_MA32_127LR86_fops);
	if (MAC_MA32_127LR86 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR86\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR85 =
	    debugfs_create_file("MAC_MA32_127LR85", 744, dir,
				pdata, &MAC_MA32_127LR85_fops);
	if (MAC_MA32_127LR85 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR85\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR84 =
	    debugfs_create_file("MAC_MA32_127LR84", 744, dir,
				pdata, &MAC_MA32_127LR84_fops);
	if (MAC_MA32_127LR84 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR84\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR83 =
	    debugfs_create_file("MAC_MA32_127LR83", 744, dir,
				pdata, &MAC_MA32_127LR83_fops);
	if (MAC_MA32_127LR83 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR83\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR82 =
	    debugfs_create_file("MAC_MA32_127LR82", 744, dir,
				pdata, &MAC_MA32_127LR82_fops);
	if (MAC_MA32_127LR82 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR82\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR81 =
	    debugfs_create_file("MAC_MA32_127LR81", 744, dir,
				pdata, &MAC_MA32_127LR81_fops);
	if (MAC_MA32_127LR81 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR81\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR80 =
	    debugfs_create_file("MAC_MA32_127LR80", 744, dir,
				pdata, &MAC_MA32_127LR80_fops);
	if (MAC_MA32_127LR80 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR80\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR79 =
	    debugfs_create_file("MAC_MA32_127LR79", 744, dir,
				pdata, &MAC_MA32_127LR79_fops);
	if (MAC_MA32_127LR79 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR79\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR78 =
	    debugfs_create_file("MAC_MA32_127LR78", 744, dir,
				pdata, &MAC_MA32_127LR78_fops);
	if (MAC_MA32_127LR78 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR78\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR77 =
	    debugfs_create_file("MAC_MA32_127LR77", 744, dir,
				pdata, &MAC_MA32_127LR77_fops);
	if (MAC_MA32_127LR77 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR77\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR76 =
	    debugfs_create_file("MAC_MA32_127LR76", 744, dir,
				pdata, &MAC_MA32_127LR76_fops);
	if (MAC_MA32_127LR76 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR76\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR75 =
	    debugfs_create_file("MAC_MA32_127LR75", 744, dir,
				pdata, &MAC_MA32_127LR75_fops);
	if (MAC_MA32_127LR75 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR75\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR74 =
	    debugfs_create_file("MAC_MA32_127LR74", 744, dir,
				pdata, &MAC_MA32_127LR74_fops);
	if (MAC_MA32_127LR74 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR74\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR73 =
	    debugfs_create_file("MAC_MA32_127LR73", 744, dir,
				pdata, &MAC_MA32_127LR73_fops);
	if (MAC_MA32_127LR73 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR73\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR72 =
	    debugfs_create_file("MAC_MA32_127LR72", 744, dir,
				pdata, &MAC_MA32_127LR72_fops);
	if (MAC_MA32_127LR72 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR72\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR71 =
	    debugfs_create_file("MAC_MA32_127LR71", 744, dir,
				pdata, &MAC_MA32_127LR71_fops);
	if (MAC_MA32_127LR71 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR71\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR70 =
	    debugfs_create_file("MAC_MA32_127LR70", 744, dir,
				pdata, &MAC_MA32_127LR70_fops);
	if (MAC_MA32_127LR70 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR70\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR69 =
	    debugfs_create_file("MAC_MA32_127LR69", 744, dir,
				pdata, &MAC_MA32_127LR69_fops);
	if (MAC_MA32_127LR69 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR69\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR68 =
	    debugfs_create_file("MAC_MA32_127LR68", 744, dir,
				pdata, &MAC_MA32_127LR68_fops);
	if (MAC_MA32_127LR68 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR68\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR67 =
	    debugfs_create_file("MAC_MA32_127LR67", 744, dir,
				pdata, &MAC_MA32_127LR67_fops);
	if (MAC_MA32_127LR67 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR67\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR66 =
	    debugfs_create_file("MAC_MA32_127LR66", 744, dir,
				pdata, &MAC_MA32_127LR66_fops);
	if (MAC_MA32_127LR66 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR66\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR65 =
	    debugfs_create_file("MAC_MA32_127LR65", 744, dir,
				pdata, &MAC_MA32_127LR65_fops);
	if (MAC_MA32_127LR65 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR65\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR64 =
	    debugfs_create_file("MAC_MA32_127LR64", 744, dir,
				pdata, &MAC_MA32_127LR64_fops);
	if (MAC_MA32_127LR64 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR64\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR63 =
	    debugfs_create_file("MAC_MA32_127LR63", 744, dir,
				pdata, &MAC_MA32_127LR63_fops);
	if (MAC_MA32_127LR63 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR63\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR62 =
	    debugfs_create_file("MAC_MA32_127LR62", 744, dir,
				pdata, &MAC_MA32_127LR62_fops);
	if (MAC_MA32_127LR62 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR62\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR61 =
	    debugfs_create_file("MAC_MA32_127LR61", 744, dir,
				pdata, &MAC_MA32_127LR61_fops);
	if (MAC_MA32_127LR61 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR61\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR60 =
	    debugfs_create_file("MAC_MA32_127LR60", 744, dir,
				pdata, &MAC_MA32_127LR60_fops);
	if (MAC_MA32_127LR60 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR60\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR59 =
	    debugfs_create_file("MAC_MA32_127LR59", 744, dir,
				pdata, &MAC_MA32_127LR59_fops);
	if (MAC_MA32_127LR59 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR59\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR58 =
	    debugfs_create_file("MAC_MA32_127LR58", 744, dir,
				pdata, &MAC_MA32_127LR58_fops);
	if (MAC_MA32_127LR58 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR58\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR57 =
	    debugfs_create_file("MAC_MA32_127LR57", 744, dir,
				pdata, &MAC_MA32_127LR57_fops);
	if (MAC_MA32_127LR57 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR57\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR56 =
	    debugfs_create_file("MAC_MA32_127LR56", 744, dir,
				pdata, &MAC_MA32_127LR56_fops);
	if (MAC_MA32_127LR56 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR56\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR55 =
	    debugfs_create_file("MAC_MA32_127LR55", 744, dir,
				pdata, &MAC_MA32_127LR55_fops);
	if (MAC_MA32_127LR55 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR55\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR54 =
	    debugfs_create_file("MAC_MA32_127LR54", 744, dir,
				pdata, &MAC_MA32_127LR54_fops);
	if (MAC_MA32_127LR54 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR54\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR53 =
	    debugfs_create_file("MAC_MA32_127LR53", 744, dir,
				pdata, &MAC_MA32_127LR53_fops);
	if (MAC_MA32_127LR53 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR53\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR52 =
	    debugfs_create_file("MAC_MA32_127LR52", 744, dir,
				pdata, &MAC_MA32_127LR52_fops);
	if (MAC_MA32_127LR52 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR52\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR51 =
	    debugfs_create_file("MAC_MA32_127LR51", 744, dir,
				pdata, &MAC_MA32_127LR51_fops);
	if (MAC_MA32_127LR51 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR51\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR50 =
	    debugfs_create_file("MAC_MA32_127LR50", 744, dir,
				pdata, &MAC_MA32_127LR50_fops);
	if (MAC_MA32_127LR50 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR50\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR49 =
	    debugfs_create_file("MAC_MA32_127LR49", 744, dir,
				pdata, &MAC_MA32_127LR49_fops);
	if (MAC_MA32_127LR49 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR49\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR48 =
	    debugfs_create_file("MAC_MA32_127LR48", 744, dir,
				pdata, &MAC_MA32_127LR48_fops);
	if (MAC_MA32_127LR48 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR48\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR47 =
	    debugfs_create_file("MAC_MA32_127LR47", 744, dir,
				pdata, &MAC_MA32_127LR47_fops);
	if (MAC_MA32_127LR47 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR47\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR46 =
	    debugfs_create_file("MAC_MA32_127LR46", 744, dir,
				pdata, &MAC_MA32_127LR46_fops);
	if (MAC_MA32_127LR46 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR46\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR45 =
	    debugfs_create_file("MAC_MA32_127LR45", 744, dir,
				pdata, &MAC_MA32_127LR45_fops);
	if (MAC_MA32_127LR45 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR45\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR44 =
	    debugfs_create_file("MAC_MA32_127LR44", 744, dir,
				pdata, &MAC_MA32_127LR44_fops);
	if (MAC_MA32_127LR44 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR44\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR43 =
	    debugfs_create_file("MAC_MA32_127LR43", 744, dir,
				pdata, &MAC_MA32_127LR43_fops);
	if (MAC_MA32_127LR43 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR43\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR42 =
	    debugfs_create_file("MAC_MA32_127LR42", 744, dir,
				pdata, &MAC_MA32_127LR42_fops);
	if (MAC_MA32_127LR42 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR42\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR41 =
	    debugfs_create_file("MAC_MA32_127LR41", 744, dir,
				pdata, &MAC_MA32_127LR41_fops);
	if (MAC_MA32_127LR41 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR41\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR40 =
	    debugfs_create_file("MAC_MA32_127LR40", 744, dir,
				pdata, &MAC_MA32_127LR40_fops);
	if (MAC_MA32_127LR40 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR40\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR39 =
	    debugfs_create_file("MAC_MA32_127LR39", 744, dir,
				pdata, &MAC_MA32_127LR39_fops);
	if (MAC_MA32_127LR39 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR39\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR38 =
	    debugfs_create_file("MAC_MA32_127LR38", 744, dir,
				pdata, &MAC_MA32_127LR38_fops);
	if (MAC_MA32_127LR38 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR38\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR37 =
	    debugfs_create_file("MAC_MA32_127LR37", 744, dir,
				pdata, &MAC_MA32_127LR37_fops);
	if (MAC_MA32_127LR37 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR37\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR36 =
	    debugfs_create_file("MAC_MA32_127LR36", 744, dir,
				pdata, &MAC_MA32_127LR36_fops);
	if (MAC_MA32_127LR36 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR36\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR35 =
	    debugfs_create_file("MAC_MA32_127LR35", 744, dir,
				pdata, &MAC_MA32_127LR35_fops);
	if (MAC_MA32_127LR35 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR35\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR34 =
	    debugfs_create_file("MAC_MA32_127LR34", 744, dir,
				pdata, &MAC_MA32_127LR34_fops);
	if (MAC_MA32_127LR34 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR34\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR33 =
	    debugfs_create_file("MAC_MA32_127LR33", 744, dir,
				pdata, &MAC_MA32_127LR33_fops);
	if (MAC_MA32_127LR33 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR33\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127LR32 =
	    debugfs_create_file("MAC_MA32_127LR32", 744, dir,
				pdata, &MAC_MA32_127LR32_fops);
	if (MAC_MA32_127LR32 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127LR32\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR127 =
	    debugfs_create_file("MAC_MA32_127HR127", 744, dir,
				pdata,
				&MAC_MA32_127HR127_fops);
	if (MAC_MA32_127HR127 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR127\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR126 =
	    debugfs_create_file("MAC_MA32_127HR126", 744, dir,
				pdata,
				&MAC_MA32_127HR126_fops);
	if (MAC_MA32_127HR126 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR126\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR125 =
	    debugfs_create_file("MAC_MA32_127HR125", 744, dir,
				pdata,
				&MAC_MA32_127HR125_fops);
	if (MAC_MA32_127HR125 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR125\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR124 =
	    debugfs_create_file("MAC_MA32_127HR124", 744, dir,
				pdata,
				&MAC_MA32_127HR124_fops);
	if (MAC_MA32_127HR124 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR124\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR123 =
	    debugfs_create_file("MAC_MA32_127HR123", 744, dir,
				pdata,
				&MAC_MA32_127HR123_fops);
	if (MAC_MA32_127HR123 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR123\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR122 =
	    debugfs_create_file("MAC_MA32_127HR122", 744, dir,
				pdata,
				&MAC_MA32_127HR122_fops);
	if (MAC_MA32_127HR122 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR122\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR121 =
	    debugfs_create_file("MAC_MA32_127HR121", 744, dir,
				pdata,
				&MAC_MA32_127HR121_fops);
	if (MAC_MA32_127HR121 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR121\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR120 =
	    debugfs_create_file("MAC_MA32_127HR120", 744, dir,
				pdata,
				&MAC_MA32_127HR120_fops);
	if (MAC_MA32_127HR120 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR120\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR119 =
	    debugfs_create_file("MAC_MA32_127HR119", 744, dir,
				pdata,
				&MAC_MA32_127HR119_fops);
	if (MAC_MA32_127HR119 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR119\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR118 =
	    debugfs_create_file("MAC_MA32_127HR118", 744, dir,
				pdata,
				&MAC_MA32_127HR118_fops);
	if (MAC_MA32_127HR118 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR118\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR117 =
	    debugfs_create_file("MAC_MA32_127HR117", 744, dir,
				pdata,
				&MAC_MA32_127HR117_fops);
	if (MAC_MA32_127HR117 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR117\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR116 =
	    debugfs_create_file("MAC_MA32_127HR116", 744, dir,
				pdata,
				&MAC_MA32_127HR116_fops);
	if (MAC_MA32_127HR116 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR116\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR115 =
	    debugfs_create_file("MAC_MA32_127HR115", 744, dir,
				pdata,
				&MAC_MA32_127HR115_fops);
	if (MAC_MA32_127HR115 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR115\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR114 =
	    debugfs_create_file("MAC_MA32_127HR114", 744, dir,
				pdata,
				&MAC_MA32_127HR114_fops);
	if (MAC_MA32_127HR114 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR114\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR113 =
	    debugfs_create_file("MAC_MA32_127HR113", 744, dir,
				pdata,
				&MAC_MA32_127HR113_fops);
	if (MAC_MA32_127HR113 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR113\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR112 =
	    debugfs_create_file("MAC_MA32_127HR112", 744, dir,
				pdata,
				&MAC_MA32_127HR112_fops);
	if (MAC_MA32_127HR112 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR112\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR111 =
	    debugfs_create_file("MAC_MA32_127HR111", 744, dir,
				pdata,
				&MAC_MA32_127HR111_fops);
	if (MAC_MA32_127HR111 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR111\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR110 =
	    debugfs_create_file("MAC_MA32_127HR110", 744, dir,
				pdata,
				&MAC_MA32_127HR110_fops);
	if (MAC_MA32_127HR110 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR110\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR109 =
	    debugfs_create_file("MAC_MA32_127HR109", 744, dir,
				pdata,
				&MAC_MA32_127HR109_fops);
	if (MAC_MA32_127HR109 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR109\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR108 =
	    debugfs_create_file("MAC_MA32_127HR108", 744, dir,
				pdata,
				&MAC_MA32_127HR108_fops);
	if (MAC_MA32_127HR108 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR108\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR107 =
	    debugfs_create_file("MAC_MA32_127HR107", 744, dir,
				pdata,
				&MAC_MA32_127HR107_fops);
	if (MAC_MA32_127HR107 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR107\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR106 =
	    debugfs_create_file("MAC_MA32_127HR106", 744, dir,
				pdata,
				&MAC_MA32_127HR106_fops);
	if (MAC_MA32_127HR106 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR106\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR105 =
	    debugfs_create_file("MAC_MA32_127HR105", 744, dir,
				pdata,
				&MAC_MA32_127HR105_fops);
	if (MAC_MA32_127HR105 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR105\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR104 =
	    debugfs_create_file("MAC_MA32_127HR104", 744, dir,
				pdata,
				&MAC_MA32_127HR104_fops);
	if (MAC_MA32_127HR104 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR104\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR103 =
	    debugfs_create_file("MAC_MA32_127HR103", 744, dir,
				pdata,
				&MAC_MA32_127HR103_fops);
	if (MAC_MA32_127HR103 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR103\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR102 =
	    debugfs_create_file("MAC_MA32_127HR102", 744, dir,
				pdata,
				&MAC_MA32_127HR102_fops);
	if (MAC_MA32_127HR102 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR102\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR101 =
	    debugfs_create_file("MAC_MA32_127HR101", 744, dir,
				pdata,
				&MAC_MA32_127HR101_fops);
	if (MAC_MA32_127HR101 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR101\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR100 =
	    debugfs_create_file("MAC_MA32_127HR100", 744, dir,
				pdata,
				&MAC_MA32_127HR100_fops);
	if (MAC_MA32_127HR100 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR100\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR99 =
	    debugfs_create_file("MAC_MA32_127HR99", 744, dir,
				pdata, &MAC_MA32_127HR99_fops);
	if (MAC_MA32_127HR99 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR99\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR98 =
	    debugfs_create_file("MAC_MA32_127HR98", 744, dir,
				pdata, &MAC_MA32_127HR98_fops);
	if (MAC_MA32_127HR98 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR98\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR97 =
	    debugfs_create_file("MAC_MA32_127HR97", 744, dir,
				pdata, &MAC_MA32_127HR97_fops);
	if (MAC_MA32_127HR97 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR97\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR96 =
	    debugfs_create_file("MAC_MA32_127HR96", 744, dir,
				pdata, &MAC_MA32_127HR96_fops);
	if (MAC_MA32_127HR96 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR96\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR95 =
	    debugfs_create_file("MAC_MA32_127HR95", 744, dir,
				pdata, &MAC_MA32_127HR95_fops);
	if (MAC_MA32_127HR95 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR95\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR94 =
	    debugfs_create_file("MAC_MA32_127HR94", 744, dir,
				pdata, &MAC_MA32_127HR94_fops);
	if (MAC_MA32_127HR94 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR94\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR93 =
	    debugfs_create_file("MAC_MA32_127HR93", 744, dir,
				pdata, &MAC_MA32_127HR93_fops);
	if (MAC_MA32_127HR93 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR93\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR92 =
	    debugfs_create_file("MAC_MA32_127HR92", 744, dir,
				pdata, &MAC_MA32_127HR92_fops);
	if (MAC_MA32_127HR92 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR92\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR91 =
	    debugfs_create_file("MAC_MA32_127HR91", 744, dir,
				pdata, &MAC_MA32_127HR91_fops);
	if (MAC_MA32_127HR91 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR91\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR90 =
	    debugfs_create_file("MAC_MA32_127HR90", 744, dir,
				pdata, &MAC_MA32_127HR90_fops);
	if (MAC_MA32_127HR90 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR90\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR89 =
	    debugfs_create_file("MAC_MA32_127HR89", 744, dir,
				pdata, &MAC_MA32_127HR89_fops);
	if (MAC_MA32_127HR89 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR89\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR88 =
	    debugfs_create_file("MAC_MA32_127HR88", 744, dir,
				pdata, &MAC_MA32_127HR88_fops);
	if (MAC_MA32_127HR88 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR88\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR87 =
	    debugfs_create_file("MAC_MA32_127HR87", 744, dir,
				pdata, &MAC_MA32_127HR87_fops);
	if (MAC_MA32_127HR87 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR87\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR86 =
	    debugfs_create_file("MAC_MA32_127HR86", 744, dir,
				pdata, &MAC_MA32_127HR86_fops);
	if (MAC_MA32_127HR86 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR86\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR85 =
	    debugfs_create_file("MAC_MA32_127HR85", 744, dir,
				pdata, &MAC_MA32_127HR85_fops);
	if (MAC_MA32_127HR85 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR85\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR84 =
	    debugfs_create_file("MAC_MA32_127HR84", 744, dir,
				pdata, &MAC_MA32_127HR84_fops);
	if (MAC_MA32_127HR84 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR84\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR83 =
	    debugfs_create_file("MAC_MA32_127HR83", 744, dir,
				pdata, &MAC_MA32_127HR83_fops);
	if (MAC_MA32_127HR83 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR83\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR82 =
	    debugfs_create_file("MAC_MA32_127HR82", 744, dir,
				pdata, &MAC_MA32_127HR82_fops);
	if (MAC_MA32_127HR82 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR82\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR81 =
	    debugfs_create_file("MAC_MA32_127HR81", 744, dir,
				pdata, &MAC_MA32_127HR81_fops);
	if (MAC_MA32_127HR81 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR81\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR80 =
	    debugfs_create_file("MAC_MA32_127HR80", 744, dir,
				pdata, &MAC_MA32_127HR80_fops);
	if (MAC_MA32_127HR80 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR80\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR79 =
	    debugfs_create_file("MAC_MA32_127HR79", 744, dir,
				pdata, &MAC_MA32_127HR79_fops);
	if (MAC_MA32_127HR79 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR79\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR78 =
	    debugfs_create_file("MAC_MA32_127HR78", 744, dir,
				pdata, &MAC_MA32_127HR78_fops);
	if (MAC_MA32_127HR78 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR78\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR77 =
	    debugfs_create_file("MAC_MA32_127HR77", 744, dir,
				pdata, &MAC_MA32_127HR77_fops);
	if (MAC_MA32_127HR77 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR77\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR76 =
	    debugfs_create_file("MAC_MA32_127HR76", 744, dir,
				pdata, &MAC_MA32_127HR76_fops);
	if (MAC_MA32_127HR76 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR76\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR75 =
	    debugfs_create_file("MAC_MA32_127HR75", 744, dir,
				pdata, &MAC_MA32_127HR75_fops);
	if (MAC_MA32_127HR75 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR75\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR74 =
	    debugfs_create_file("MAC_MA32_127HR74", 744, dir,
				pdata, &MAC_MA32_127HR74_fops);
	if (MAC_MA32_127HR74 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR74\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR73 =
	    debugfs_create_file("MAC_MA32_127HR73", 744, dir,
				pdata, &MAC_MA32_127HR73_fops);
	if (MAC_MA32_127HR73 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR73\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR72 =
	    debugfs_create_file("MAC_MA32_127HR72", 744, dir,
				pdata, &MAC_MA32_127HR72_fops);
	if (MAC_MA32_127HR72 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR72\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR71 =
	    debugfs_create_file("MAC_MA32_127HR71", 744, dir,
				pdata, &MAC_MA32_127HR71_fops);
	if (MAC_MA32_127HR71 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR71\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR70 =
	    debugfs_create_file("MAC_MA32_127HR70", 744, dir,
				pdata, &MAC_MA32_127HR70_fops);
	if (MAC_MA32_127HR70 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR70\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR69 =
	    debugfs_create_file("MAC_MA32_127HR69", 744, dir,
				pdata, &MAC_MA32_127HR69_fops);
	if (MAC_MA32_127HR69 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR69\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR68 =
	    debugfs_create_file("MAC_MA32_127HR68", 744, dir,
				pdata, &MAC_MA32_127HR68_fops);
	if (MAC_MA32_127HR68 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR68\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR67 =
	    debugfs_create_file("MAC_MA32_127HR67", 744, dir,
				pdata, &MAC_MA32_127HR67_fops);
	if (MAC_MA32_127HR67 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR67\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR66 =
	    debugfs_create_file("MAC_MA32_127HR66", 744, dir,
				pdata, &MAC_MA32_127HR66_fops);
	if (MAC_MA32_127HR66 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR66\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR65 =
	    debugfs_create_file("MAC_MA32_127HR65", 744, dir,
				pdata, &MAC_MA32_127HR65_fops);
	if (MAC_MA32_127HR65 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR65\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR64 =
	    debugfs_create_file("MAC_MA32_127HR64", 744, dir,
				pdata, &MAC_MA32_127HR64_fops);
	if (MAC_MA32_127HR64 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR64\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR63 =
	    debugfs_create_file("MAC_MA32_127HR63", 744, dir,
				pdata, &MAC_MA32_127HR63_fops);
	if (MAC_MA32_127HR63 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR63\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR62 =
	    debugfs_create_file("MAC_MA32_127HR62", 744, dir,
				pdata, &MAC_MA32_127HR62_fops);
	if (MAC_MA32_127HR62 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR62\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR61 =
	    debugfs_create_file("MAC_MA32_127HR61", 744, dir,
				pdata, &MAC_MA32_127HR61_fops);
	if (MAC_MA32_127HR61 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR61\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR60 =
	    debugfs_create_file("MAC_MA32_127HR60", 744, dir,
				pdata, &MAC_MA32_127HR60_fops);
	if (MAC_MA32_127HR60 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR60\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR59 =
	    debugfs_create_file("MAC_MA32_127HR59", 744, dir,
				pdata, &MAC_MA32_127HR59_fops);
	if (MAC_MA32_127HR59 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR59\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR58 =
	    debugfs_create_file("MAC_MA32_127HR58", 744, dir,
				pdata, &MAC_MA32_127HR58_fops);
	if (MAC_MA32_127HR58 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR58\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR57 =
	    debugfs_create_file("MAC_MA32_127HR57", 744, dir,
				pdata, &MAC_MA32_127HR57_fops);
	if (MAC_MA32_127HR57 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR57\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR56 =
	    debugfs_create_file("MAC_MA32_127HR56", 744, dir,
				pdata, &MAC_MA32_127HR56_fops);
	if (MAC_MA32_127HR56 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR56\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR55 =
	    debugfs_create_file("MAC_MA32_127HR55", 744, dir,
				pdata, &MAC_MA32_127HR55_fops);
	if (MAC_MA32_127HR55 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR55\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR54 =
	    debugfs_create_file("MAC_MA32_127HR54", 744, dir,
				pdata, &MAC_MA32_127HR54_fops);
	if (MAC_MA32_127HR54 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR54\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR53 =
	    debugfs_create_file("MAC_MA32_127HR53", 744, dir,
				pdata, &MAC_MA32_127HR53_fops);
	if (MAC_MA32_127HR53 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR53\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR52 =
	    debugfs_create_file("MAC_MA32_127HR52", 744, dir,
				pdata, &MAC_MA32_127HR52_fops);
	if (MAC_MA32_127HR52 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR52\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR51 =
	    debugfs_create_file("MAC_MA32_127HR51", 744, dir,
				pdata, &MAC_MA32_127HR51_fops);
	if (MAC_MA32_127HR51 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR51\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR50 =
	    debugfs_create_file("MAC_MA32_127HR50", 744, dir,
				pdata, &MAC_MA32_127HR50_fops);
	if (MAC_MA32_127HR50 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR50\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR49 =
	    debugfs_create_file("MAC_MA32_127HR49", 744, dir,
				pdata, &MAC_MA32_127HR49_fops);
	if (MAC_MA32_127HR49 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR49\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR48 =
	    debugfs_create_file("MAC_MA32_127HR48", 744, dir,
				pdata, &MAC_MA32_127HR48_fops);
	if (MAC_MA32_127HR48 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR48\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR47 =
	    debugfs_create_file("MAC_MA32_127HR47", 744, dir,
				pdata, &MAC_MA32_127HR47_fops);
	if (MAC_MA32_127HR47 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR47\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR46 =
	    debugfs_create_file("MAC_MA32_127HR46", 744, dir,
				pdata, &MAC_MA32_127HR46_fops);
	if (MAC_MA32_127HR46 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR46\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR45 =
	    debugfs_create_file("MAC_MA32_127HR45", 744, dir,
				pdata, &MAC_MA32_127HR45_fops);
	if (MAC_MA32_127HR45 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR45\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR44 =
	    debugfs_create_file("MAC_MA32_127HR44", 744, dir,
				pdata, &MAC_MA32_127HR44_fops);
	if (MAC_MA32_127HR44 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR44\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR43 =
	    debugfs_create_file("MAC_MA32_127HR43", 744, dir,
				pdata, &MAC_MA32_127HR43_fops);
	if (MAC_MA32_127HR43 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR43\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR42 =
	    debugfs_create_file("MAC_MA32_127HR42", 744, dir,
				pdata, &MAC_MA32_127HR42_fops);
	if (MAC_MA32_127HR42 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR42\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR41 =
	    debugfs_create_file("MAC_MA32_127HR41", 744, dir,
				pdata, &MAC_MA32_127HR41_fops);
	if (MAC_MA32_127HR41 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR41\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR40 =
	    debugfs_create_file("MAC_MA32_127HR40", 744, dir,
				pdata, &MAC_MA32_127HR40_fops);
	if (MAC_MA32_127HR40 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR40\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR39 =
	    debugfs_create_file("MAC_MA32_127HR39", 744, dir,
				pdata, &MAC_MA32_127HR39_fops);
	if (MAC_MA32_127HR39 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR39\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR38 =
	    debugfs_create_file("MAC_MA32_127HR38", 744, dir,
				pdata, &MAC_MA32_127HR38_fops);
	if (MAC_MA32_127HR38 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR38\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR37 =
	    debugfs_create_file("MAC_MA32_127HR37", 744, dir,
				pdata, &MAC_MA32_127HR37_fops);
	if (MAC_MA32_127HR37 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR37\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR36 =
	    debugfs_create_file("MAC_MA32_127HR36", 744, dir,
				pdata, &MAC_MA32_127HR36_fops);
	if (MAC_MA32_127HR36 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR36\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR35 =
	    debugfs_create_file("MAC_MA32_127HR35", 744, dir,
				pdata, &MAC_MA32_127HR35_fops);
	if (MAC_MA32_127HR35 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR35\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR34 =
	    debugfs_create_file("MAC_MA32_127HR34", 744, dir,
				pdata, &MAC_MA32_127HR34_fops);
	if (MAC_MA32_127HR34 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR34\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR33 =
	    debugfs_create_file("MAC_MA32_127HR33", 744, dir,
				pdata, &MAC_MA32_127HR33_fops);
	if (MAC_MA32_127HR33 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR33\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA32_127HR32 =
	    debugfs_create_file("MAC_MA32_127HR32", 744, dir,
				pdata, &MAC_MA32_127HR32_fops);
	if (MAC_MA32_127HR32 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA32_127HR32\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR31 =
	    debugfs_create_file("MAC_MA1_31LR31", 744, dir, pdata,
				&MAC_MA1_31LR31_fops);
	if (MAC_MA1_31LR31 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR31\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR30 =
	    debugfs_create_file("MAC_MA1_31LR30", 744, dir, pdata,
				&MAC_MA1_31LR30_fops);
	if (MAC_MA1_31LR30 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR30\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR29 =
	    debugfs_create_file("MAC_MA1_31LR29", 744, dir, pdata,
				&MAC_MA1_31LR29_fops);
	if (MAC_MA1_31LR29 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR29\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR28 =
	    debugfs_create_file("MAC_MA1_31LR28", 744, dir, pdata,
				&MAC_MA1_31LR28_fops);
	if (MAC_MA1_31LR28 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR28\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR27 =
	    debugfs_create_file("MAC_MA1_31LR27", 744, dir, pdata,
				&MAC_MA1_31LR27_fops);
	if (MAC_MA1_31LR27 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR27\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR26 =
	    debugfs_create_file("MAC_MA1_31LR26", 744, dir, pdata,
				&MAC_MA1_31LR26_fops);
	if (MAC_MA1_31LR26 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR26\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR25 =
	    debugfs_create_file("MAC_MA1_31LR25", 744, dir, pdata,
				&MAC_MA1_31LR25_fops);
	if (MAC_MA1_31LR25 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR25\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR24 =
	    debugfs_create_file("MAC_MA1_31LR24", 744, dir, pdata,
				&MAC_MA1_31LR24_fops);
	if (MAC_MA1_31LR24 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR24\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR23 =
	    debugfs_create_file("MAC_MA1_31LR23", 744, dir, pdata,
				&MAC_MA1_31LR23_fops);
	if (MAC_MA1_31LR23 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR23\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR22 =
	    debugfs_create_file("MAC_MA1_31LR22", 744, dir, pdata,
				&MAC_MA1_31LR22_fops);
	if (MAC_MA1_31LR22 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR22\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR21 =
	    debugfs_create_file("MAC_MA1_31LR21", 744, dir, pdata,
				&MAC_MA1_31LR21_fops);
	if (MAC_MA1_31LR21 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR21\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR20 =
	    debugfs_create_file("MAC_MA1_31LR20", 744, dir, pdata,
				&MAC_MA1_31LR20_fops);
	if (MAC_MA1_31LR20 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR20\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR19 =
	    debugfs_create_file("MAC_MA1_31LR19", 744, dir, pdata,
				&MAC_MA1_31LR19_fops);
	if (MAC_MA1_31LR19 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR19\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR18 =
	    debugfs_create_file("MAC_MA1_31LR18", 744, dir, pdata,
				&MAC_MA1_31LR18_fops);
	if (MAC_MA1_31LR18 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR18\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR17 =
	    debugfs_create_file("MAC_MA1_31LR17", 744, dir, pdata,
				&MAC_MA1_31LR17_fops);
	if (MAC_MA1_31LR17 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR17\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR16 =
	    debugfs_create_file("MAC_MA1_31LR16", 744, dir, pdata,
				&MAC_MA1_31LR16_fops);
	if (MAC_MA1_31LR16 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR16\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR15 =
	    debugfs_create_file("MAC_MA1_31LR15", 744, dir, pdata,
				&MAC_MA1_31LR15_fops);
	if (MAC_MA1_31LR15 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR15\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR14 =
	    debugfs_create_file("MAC_MA1_31LR14", 744, dir, pdata,
				&MAC_MA1_31LR14_fops);
	if (MAC_MA1_31LR14 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR14\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR13 =
	    debugfs_create_file("MAC_MA1_31LR13", 744, dir, pdata,
				&MAC_MA1_31LR13_fops);
	if (MAC_MA1_31LR13 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR13\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR12 =
	    debugfs_create_file("MAC_MA1_31LR12", 744, dir, pdata,
				&MAC_MA1_31LR12_fops);
	if (MAC_MA1_31LR12 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR12\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR11 =
	    debugfs_create_file("MAC_MA1_31LR11", 744, dir, pdata,
				&MAC_MA1_31LR11_fops);
	if (MAC_MA1_31LR11 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR11\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR10 =
	    debugfs_create_file("MAC_MA1_31LR10", 744, dir, pdata,
				&MAC_MA1_31LR10_fops);
	if (MAC_MA1_31LR10 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR10\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR9 =
	    debugfs_create_file("MAC_MA1_31LR9", 744, dir, pdata,
				&MAC_MA1_31LR9_fops);
	if (MAC_MA1_31LR9 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR9\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR8 =
	    debugfs_create_file("MAC_MA1_31LR8", 744, dir, pdata,
				&MAC_MA1_31LR8_fops);
	if (MAC_MA1_31LR8 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR8\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR7 =
	    debugfs_create_file("MAC_MA1_31LR7", 744, dir, pdata,
				&MAC_MA1_31LR7_fops);
	if (MAC_MA1_31LR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR6 =
	    debugfs_create_file("MAC_MA1_31LR6", 744, dir, pdata,
				&MAC_MA1_31LR6_fops);
	if (MAC_MA1_31LR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR5 =
	    debugfs_create_file("MAC_MA1_31LR5", 744, dir, pdata,
				&MAC_MA1_31LR5_fops);
	if (MAC_MA1_31LR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR4 =
	    debugfs_create_file("MAC_MA1_31LR4", 744, dir, pdata,
				&MAC_MA1_31LR4_fops);
	if (MAC_MA1_31LR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR3 =
	    debugfs_create_file("MAC_MA1_31LR3", 744, dir, pdata,
				&MAC_MA1_31LR3_fops);
	if (MAC_MA1_31LR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR2 =
	    debugfs_create_file("MAC_MA1_31LR2", 744, dir, pdata,
				&MAC_MA1_31LR2_fops);
	if (MAC_MA1_31LR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31LR1 =
	    debugfs_create_file("MAC_MA1_31LR1", 744, dir, pdata,
				&MAC_MA1_31LR1_fops);
	if (MAC_MA1_31LR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31LR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR31 =
	    debugfs_create_file("MAC_MA1_31HR31", 744, dir, pdata,
				&MAC_MA1_31HR31_fops);
	if (MAC_MA1_31HR31 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR31\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR30 =
	    debugfs_create_file("MAC_MA1_31HR30", 744, dir, pdata,
				&MAC_MA1_31HR30_fops);
	if (MAC_MA1_31HR30 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR30\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR29 =
	    debugfs_create_file("MAC_MA1_31HR29", 744, dir, pdata,
				&MAC_MA1_31HR29_fops);
	if (MAC_MA1_31HR29 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR29\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR28 =
	    debugfs_create_file("MAC_MA1_31HR28", 744, dir, pdata,
				&MAC_MA1_31HR28_fops);
	if (MAC_MA1_31HR28 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR28\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR27 =
	    debugfs_create_file("MAC_MA1_31HR27", 744, dir, pdata,
				&MAC_MA1_31HR27_fops);
	if (MAC_MA1_31HR27 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR27\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR26 =
	    debugfs_create_file("MAC_MA1_31HR26", 744, dir, pdata,
				&MAC_MA1_31HR26_fops);
	if (MAC_MA1_31HR26 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR26\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR25 =
	    debugfs_create_file("MAC_MA1_31HR25", 744, dir, pdata,
				&MAC_MA1_31HR25_fops);
	if (MAC_MA1_31HR25 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR25\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR24 =
	    debugfs_create_file("MAC_MA1_31HR24", 744, dir, pdata,
				&MAC_MA1_31HR24_fops);
	if (MAC_MA1_31HR24 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR24\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR23 =
	    debugfs_create_file("MAC_MA1_31HR23", 744, dir, pdata,
				&MAC_MA1_31HR23_fops);
	if (MAC_MA1_31HR23 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR23\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR22 =
	    debugfs_create_file("MAC_MA1_31HR22", 744, dir, pdata,
				&MAC_MA1_31HR22_fops);
	if (MAC_MA1_31HR22 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR22\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR21 =
	    debugfs_create_file("MAC_MA1_31HR21", 744, dir, pdata,
				&MAC_MA1_31HR21_fops);
	if (MAC_MA1_31HR21 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR21\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR20 =
	    debugfs_create_file("MAC_MA1_31HR20", 744, dir, pdata,
				&MAC_MA1_31HR20_fops);
	if (MAC_MA1_31HR20 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR20\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR19 =
	    debugfs_create_file("MAC_MA1_31HR19", 744, dir, pdata,
				&MAC_MA1_31HR19_fops);
	if (MAC_MA1_31HR19 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR19\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR18 =
	    debugfs_create_file("MAC_MA1_31HR18", 744, dir, pdata,
				&MAC_MA1_31HR18_fops);
	if (MAC_MA1_31HR18 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR18\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR17 =
	    debugfs_create_file("MAC_MA1_31HR17", 744, dir, pdata,
				&MAC_MA1_31HR17_fops);
	if (MAC_MA1_31HR17 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR17\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR16 =
	    debugfs_create_file("MAC_MA1_31HR16", 744, dir, pdata,
				&MAC_MA1_31HR16_fops);
	if (MAC_MA1_31HR16 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR16\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR15 =
	    debugfs_create_file("MAC_MA1_31HR15", 744, dir, pdata,
				&MAC_MA1_31HR15_fops);
	if (MAC_MA1_31HR15 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR15\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR14 =
	    debugfs_create_file("MAC_MA1_31HR14", 744, dir, pdata,
				&MAC_MA1_31HR14_fops);
	if (MAC_MA1_31HR14 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR14\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR13 =
	    debugfs_create_file("MAC_MA1_31HR13", 744, dir, pdata,
				&MAC_MA1_31HR13_fops);
	if (MAC_MA1_31HR13 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR13\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR12 =
	    debugfs_create_file("MAC_MA1_31HR12", 744, dir, pdata,
				&MAC_MA1_31HR12_fops);
	if (MAC_MA1_31HR12 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR12\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR11 =
	    debugfs_create_file("MAC_MA1_31HR11", 744, dir, pdata,
				&MAC_MA1_31HR11_fops);
	if (MAC_MA1_31HR11 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR11\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR10 =
	    debugfs_create_file("MAC_MA1_31HR10", 744, dir, pdata,
				&MAC_MA1_31HR10_fops);
	if (MAC_MA1_31HR10 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR10\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR9 =
	    debugfs_create_file("MAC_MA1_31HR9", 744, dir, pdata,
				&MAC_MA1_31HR9_fops);
	if (MAC_MA1_31HR9 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR9\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR8 =
	    debugfs_create_file("MAC_MA1_31HR8", 744, dir, pdata,
				&MAC_MA1_31HR8_fops);
	if (MAC_MA1_31HR8 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR8\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR7 =
	    debugfs_create_file("MAC_MA1_31HR7", 744, dir, pdata,
				&MAC_MA1_31HR7_fops);
	if (MAC_MA1_31HR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR6 =
	    debugfs_create_file("MAC_MA1_31HR6", 744, dir, pdata,
				&MAC_MA1_31HR6_fops);
	if (MAC_MA1_31HR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR5 =
	    debugfs_create_file("MAC_MA1_31HR5", 744, dir, pdata,
				&MAC_MA1_31HR5_fops);
	if (MAC_MA1_31HR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR4 =
	    debugfs_create_file("MAC_MA1_31HR4", 744, dir, pdata,
				&MAC_MA1_31HR4_fops);
	if (MAC_MA1_31HR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR3 =
	    debugfs_create_file("MAC_MA1_31HR3", 744, dir, pdata,
				&MAC_MA1_31HR3_fops);
	if (MAC_MA1_31HR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR2 =
	    debugfs_create_file("MAC_MA1_31HR2", 744, dir, pdata,
				&MAC_MA1_31HR2_fops);
	if (MAC_MA1_31HR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1_31HR1 =
	    debugfs_create_file("MAC_MA1_31HR1", 744, dir, pdata,
				&MAC_MA1_31HR1_fops);
	if (MAC_MA1_31HR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1_31HR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ARPA =
	    debugfs_create_file("MAC_ARPA", 744, dir, pdata,
				&MAC_ARPA_fops);
	if (MAC_ARPA == NULL) {
		printk(KERN_INFO "error creating file: MAC_ARPA\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R7 =
	    debugfs_create_file("MAC_L3A3R7", 744, dir, pdata,
				&MAC_L3A3R7_fops);
	if (MAC_L3A3R7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R6 =
	    debugfs_create_file("MAC_L3A3R6", 744, dir, pdata,
				&MAC_L3A3R6_fops);
	if (MAC_L3A3R6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R5 =
	    debugfs_create_file("MAC_L3A3R5", 744, dir, pdata,
				&MAC_L3A3R5_fops);
	if (MAC_L3A3R5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R4 =
	    debugfs_create_file("MAC_L3A3R4", 744, dir, pdata,
				&MAC_L3A3R4_fops);
	if (MAC_L3A3R4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R3 =
	    debugfs_create_file("MAC_L3A3R3", 744, dir, pdata,
				&MAC_L3A3R3_fops);
	if (MAC_L3A3R3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R2 =
	    debugfs_create_file("MAC_L3A3R2", 744, dir, pdata,
				&MAC_L3A3R2_fops);
	if (MAC_L3A3R2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R1 =
	    debugfs_create_file("MAC_L3A3R1", 744, dir, pdata,
				&MAC_L3A3R1_fops);
	if (MAC_L3A3R1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A3R0 =
	    debugfs_create_file("MAC_L3A3R0", 744, dir, pdata,
				&MAC_L3A3R0_fops);
	if (MAC_L3A3R0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A3R0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R7 =
	    debugfs_create_file("MAC_L3A2R7", 744, dir, pdata,
				&MAC_L3A2R7_fops);
	if (MAC_L3A2R7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R6 =
	    debugfs_create_file("MAC_L3A2R6", 744, dir, pdata,
				&MAC_L3A2R6_fops);
	if (MAC_L3A2R6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R5 =
	    debugfs_create_file("MAC_L3A2R5", 744, dir, pdata,
				&MAC_L3A2R5_fops);
	if (MAC_L3A2R5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R4 =
	    debugfs_create_file("MAC_L3A2R4", 744, dir, pdata,
				&MAC_L3A2R4_fops);
	if (MAC_L3A2R4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R3 =
	    debugfs_create_file("MAC_L3A2R3", 744, dir, pdata,
				&MAC_L3A2R3_fops);
	if (MAC_L3A2R3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R2 =
	    debugfs_create_file("MAC_L3A2R2", 744, dir, pdata,
				&MAC_L3A2R2_fops);
	if (MAC_L3A2R2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R1 =
	    debugfs_create_file("MAC_L3A2R1", 744, dir, pdata,
				&MAC_L3A2R1_fops);
	if (MAC_L3A2R1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A2R0 =
	    debugfs_create_file("MAC_L3A2R0", 744, dir, pdata,
				&MAC_L3A2R0_fops);
	if (MAC_L3A2R0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A2R0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R7 =
	    debugfs_create_file("MAC_L3A1R7", 744, dir, pdata,
				&MAC_L3A1R7_fops);
	if (MAC_L3A1R7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R6 =
	    debugfs_create_file("MAC_L3A1R6", 744, dir, pdata,
				&MAC_L3A1R6_fops);
	if (MAC_L3A1R6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R5 =
	    debugfs_create_file("MAC_L3A1R5", 744, dir, pdata,
				&MAC_L3A1R5_fops);
	if (MAC_L3A1R5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R4 =
	    debugfs_create_file("MAC_L3A1R4", 744, dir, pdata,
				&MAC_L3A1R4_fops);
	if (MAC_L3A1R4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R3 =
	    debugfs_create_file("MAC_L3A1R3", 744, dir, pdata,
				&MAC_L3A1R3_fops);
	if (MAC_L3A1R3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R2 =
	    debugfs_create_file("MAC_L3A1R2", 744, dir, pdata,
				&MAC_L3A1R2_fops);
	if (MAC_L3A1R2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R1 =
	    debugfs_create_file("MAC_L3A1R1", 744, dir, pdata,
				&MAC_L3A1R1_fops);
	if (MAC_L3A1R1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A1R0 =
	    debugfs_create_file("MAC_L3A1R0", 744, dir, pdata,
				&MAC_L3A1R0_fops);
	if (MAC_L3A1R0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A1R0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R7 =
	    debugfs_create_file("MAC_L3A0R7", 744, dir, pdata,
				&MAC_L3A0R7_fops);
	if (MAC_L3A0R7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R6 =
	    debugfs_create_file("MAC_L3A0R6", 744, dir, pdata,
				&MAC_L3A0R6_fops);
	if (MAC_L3A0R6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R5 =
	    debugfs_create_file("MAC_L3A0R5", 744, dir, pdata,
				&MAC_L3A0R5_fops);
	if (MAC_L3A0R5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R4 =
	    debugfs_create_file("MAC_L3A0R4", 744, dir, pdata,
				&MAC_L3A0R4_fops);
	if (MAC_L3A0R4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R3 =
	    debugfs_create_file("MAC_L3A0R3", 744, dir, pdata,
				&MAC_L3A0R3_fops);
	if (MAC_L3A0R3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R2 =
	    debugfs_create_file("MAC_L3A0R2", 744, dir, pdata,
				&MAC_L3A0R2_fops);
	if (MAC_L3A0R2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R1 =
	    debugfs_create_file("MAC_L3A0R1", 744, dir, pdata,
				&MAC_L3A0R1_fops);
	if (MAC_L3A0R1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3A0R0 =
	    debugfs_create_file("MAC_L3A0R0", 744, dir, pdata,
				&MAC_L3A0R0_fops);
	if (MAC_L3A0R0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3A0R0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR7 =
	    debugfs_create_file("MAC_L4AR7", 744, dir, pdata,
				&MAC_L4AR7_fops);
	if (MAC_L4AR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR6 =
	    debugfs_create_file("MAC_L4AR6", 744, dir, pdata,
				&MAC_L4AR6_fops);
	if (MAC_L4AR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR5 =
	    debugfs_create_file("MAC_L4AR5", 744, dir, pdata,
				&MAC_L4AR5_fops);
	if (MAC_L4AR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR4 =
	    debugfs_create_file("MAC_L4AR4", 744, dir, pdata,
				&MAC_L4AR4_fops);
	if (MAC_L4AR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR3 =
	    debugfs_create_file("MAC_L4AR3", 744, dir, pdata,
				&MAC_L4AR3_fops);
	if (MAC_L4AR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR2 =
	    debugfs_create_file("MAC_L4AR2", 744, dir, pdata,
				&MAC_L4AR2_fops);
	if (MAC_L4AR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR1 =
	    debugfs_create_file("MAC_L4AR1", 744, dir, pdata,
				&MAC_L4AR1_fops);
	if (MAC_L4AR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L4AR0 =
	    debugfs_create_file("MAC_L4AR0", 744, dir, pdata,
				&MAC_L4AR0_fops);
	if (MAC_L4AR0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L4AR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR7 =
	    debugfs_create_file("MAC_L3L4CR7", 744, dir, pdata,
				&MAC_L3L4CR7_fops);
	if (MAC_L3L4CR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR6 =
	    debugfs_create_file("MAC_L3L4CR6", 744, dir, pdata,
				&MAC_L3L4CR6_fops);
	if (MAC_L3L4CR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR5 =
	    debugfs_create_file("MAC_L3L4CR5", 744, dir, pdata,
				&MAC_L3L4CR5_fops);
	if (MAC_L3L4CR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR4 =
	    debugfs_create_file("MAC_L3L4CR4", 744, dir, pdata,
				&MAC_L3L4CR4_fops);
	if (MAC_L3L4CR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR3 =
	    debugfs_create_file("MAC_L3L4CR3", 744, dir, pdata,
				&MAC_L3L4CR3_fops);
	if (MAC_L3L4CR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR2 =
	    debugfs_create_file("MAC_L3L4CR2", 744, dir, pdata,
				&MAC_L3L4CR2_fops);
	if (MAC_L3L4CR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR1 =
	    debugfs_create_file("MAC_L3L4CR1", 744, dir, pdata,
				&MAC_L3L4CR1_fops);
	if (MAC_L3L4CR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_L3L4CR0 =
	    debugfs_create_file("MAC_L3L4CR0", 744, dir, pdata,
				&MAC_L3L4CR0_fops);
	if (MAC_L3L4CR0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_L3L4CR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_GPIOS =
	    debugfs_create_file("MAC_GPIOS", 744, dir, pdata,
				&MAC_GPIOS_fops);
	if (MAC_GPIOS == NULL) {
		printk(KERN_INFO "error creating file: MAC_GPIOS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PCS =
	    debugfs_create_file("MAC_PCS", 744, dir, pdata,
				&MAC_PCS_fops);
	if (MAC_PCS == NULL) {
		printk(KERN_INFO "error creating file: MAC_PCS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TES =
	    debugfs_create_file("MAC_TES", 744, dir, pdata,
				&MAC_TES_fops);
	if (MAC_TES == NULL) {
		printk(KERN_INFO "error creating file: MAC_TES\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_AE =
	    debugfs_create_file("MAC_AE", 744, dir, pdata, &MAC_AE_fops);
	if (MAC_AE == NULL) {
		printk(KERN_INFO "error creating file: MAC_AE\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ALPA =
	    debugfs_create_file("MAC_ALPA", 744, dir, pdata,
				&MAC_ALPA_fops);
	if (MAC_ALPA == NULL) {
		printk(KERN_INFO "error creating file: MAC_ALPA\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_AAD =
	    debugfs_create_file("MAC_AAD", 744, dir, pdata,
				&MAC_AAD_fops);
	if (MAC_AAD == NULL) {
		printk(KERN_INFO "error creating file: MAC_AAD\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ANS =
	    debugfs_create_file("MAC_ANS", 744, dir, pdata,
				&MAC_ANS_fops);
	if (MAC_ANS == NULL) {
		printk(KERN_INFO "error creating file: MAC_ANS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ANC =
	    debugfs_create_file("MAC_ANC", 744, dir, pdata,
				&MAC_ANC_fops);
	if (MAC_ANC == NULL) {
		printk(KERN_INFO "error creating file: MAC_ANC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_LPC =
	    debugfs_create_file("MAC_LPC", 744, dir, pdata,
				&MAC_LPC_fops);
	if (MAC_LPC == NULL) {
		printk(KERN_INFO "error creating file: MAC_LPC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_LPS =
	    debugfs_create_file("MAC_LPS", 744, dir, pdata,
				&MAC_LPS_fops);
	if (MAC_LPS == NULL) {
		printk(KERN_INFO "error creating file: MAC_LPS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_LMIR = debugfs_create_file("MAC_LMIR", 744, dir, pdata, &MAC_LMIR_fops);
	if(MAC_LMIR == NULL) {
		printk(KERN_INFO "error creating file: MAC_LMIR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_SPI2R = debugfs_create_file("MAC_SPI2R", 744, dir, pdata, &MAC_SPI2R_fops);
	if(MAC_SPI2R == NULL) {
		printk(KERN_INFO "error creating file: MAC_SPI2R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_SPI1R = debugfs_create_file("MAC_SPI1R", 744, dir, pdata, &MAC_SPI1R_fops);
	if(MAC_SPI1R == NULL) {
		printk(KERN_INFO "error creating file: MAC_SPI1R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_SPI0R = debugfs_create_file("MAC_SPI0R", 744, dir, pdata, &MAC_SPI0R_fops);
	if(MAC_SPI0R == NULL) {
		printk(KERN_INFO "error creating file: MAC_SPI0R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PTO_CR = debugfs_create_file("MAC_PTO_CR", 744, dir, pdata, &MAC_PTO_CR_fops);
	if(MAC_PTO_CR == NULL) {
		printk(KERN_INFO "error creating file: MAC_PTO_CR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}




	MAC_PPS_WIDTH3 =
	    debugfs_create_file("MAC_PPS_WIDTH3", 744, dir, pdata,
				&MAC_PPS_WIDTH3_fops);
	if (MAC_PPS_WIDTH3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_WIDTH3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_WIDTH2 =
	    debugfs_create_file("MAC_PPS_WIDTH2", 744, dir, pdata,
				&MAC_PPS_WIDTH2_fops);
	if (MAC_PPS_WIDTH2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_WIDTH2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_WIDTH1 =
	    debugfs_create_file("MAC_PPS_WIDTH1", 744, dir, pdata,
				&MAC_PPS_WIDTH1_fops);
	if (MAC_PPS_WIDTH1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_WIDTH1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_WIDTH0 =
	    debugfs_create_file("MAC_PPS_WIDTH0", 744, dir, pdata,
				&MAC_PPS_WIDTH0_fops);
	if (MAC_PPS_WIDTH0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_WIDTH0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_INTVAL3 =
	    debugfs_create_file("MAC_PPS_INTVAL3", 744, dir,
				pdata, &MAC_PPS_INTVAL3_fops);
	if (MAC_PPS_INTVAL3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_INTVAL3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_INTVAL2 =
	    debugfs_create_file("MAC_PPS_INTVAL2", 744, dir,
				pdata, &MAC_PPS_INTVAL2_fops);
	if (MAC_PPS_INTVAL2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_INTVAL2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_INTVAL1 =
	    debugfs_create_file("MAC_PPS_INTVAL1", 744, dir,
				pdata, &MAC_PPS_INTVAL1_fops);
	if (MAC_PPS_INTVAL1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_INTVAL1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_INTVAL0 =
	    debugfs_create_file("MAC_PPS_INTVAL0", 744, dir,
				pdata, &MAC_PPS_INTVAL0_fops);
	if (MAC_PPS_INTVAL0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_INTVAL0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTNS3 =
	    debugfs_create_file("MAC_PPS_TTNS3", 744, dir, pdata,
				&MAC_PPS_TTNS3_fops);
	if (MAC_PPS_TTNS3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTNS3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTNS2 =
	    debugfs_create_file("MAC_PPS_TTNS2", 744, dir, pdata,
				&MAC_PPS_TTNS2_fops);
	if (MAC_PPS_TTNS2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTNS2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTNS1 =
	    debugfs_create_file("MAC_PPS_TTNS1", 744, dir, pdata,
				&MAC_PPS_TTNS1_fops);
	if (MAC_PPS_TTNS1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTNS1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTNS0 =
	    debugfs_create_file("MAC_PPS_TTNS0", 744, dir, pdata,
				&MAC_PPS_TTNS0_fops);
	if (MAC_PPS_TTNS0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTNS0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTS3 =
	    debugfs_create_file("MAC_PPS_TTS3", 744, dir, pdata,
				&MAC_PPS_TTS3_fops);
	if (MAC_PPS_TTS3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTS3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTS2 =
	    debugfs_create_file("MAC_PPS_TTS2", 744, dir, pdata,
				&MAC_PPS_TTS2_fops);
	if (MAC_PPS_TTS2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTS2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTS1 =
	    debugfs_create_file("MAC_PPS_TTS1", 744, dir, pdata,
				&MAC_PPS_TTS1_fops);
	if (MAC_PPS_TTS1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTS1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPS_TTS0 =
	    debugfs_create_file("MAC_PPS_TTS0", 744, dir, pdata,
				&MAC_PPS_TTS0_fops);
	if (MAC_PPS_TTS0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPS_TTS0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PPSC =
	    debugfs_create_file("MAC_PPSC", 744, dir, pdata,
				&MAC_PPSC_fops);
	if (MAC_PPSC == NULL) {
		printk(KERN_INFO "error creating file: MAC_PPSC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TEAC =
	    debugfs_create_file("MAC_TEAC", 744, dir, pdata,
				&MAC_TEAC_fops);
	if (MAC_TEAC == NULL) {
		printk(KERN_INFO "error creating file: MAC_TEAC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TIAC =
	    debugfs_create_file("MAC_TIAC", 744, dir, pdata,
				&MAC_TIAC_fops);
	if (MAC_TIAC == NULL) {
		printk(KERN_INFO "error creating file: MAC_TIAC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ATS =
	    debugfs_create_file("MAC_ATS", 744, dir, pdata,
				&MAC_ATS_fops);
	if (MAC_ATS == NULL) {
		printk(KERN_INFO "error creating file: MAC_ATS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ATN =
	    debugfs_create_file("MAC_ATN", 744, dir, pdata,
				&MAC_ATN_fops);
	if (MAC_ATN == NULL) {
		printk(KERN_INFO "error creating file: MAC_ATN\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_AC =
	    debugfs_create_file("MAC_AC", 744, dir, pdata, &MAC_AC_fops);
	if (MAC_AC == NULL) {
		printk(KERN_INFO "error creating file: MAC_AC\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TTN =
	    debugfs_create_file("MAC_TTN", 744, dir, pdata,
				&MAC_TTN_fops);
	if (MAC_TTN == NULL) {
		printk(KERN_INFO "error creating file: MAC_TTN\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TTSN =
	    debugfs_create_file("MAC_TTSN", 744, dir, pdata,
				&MAC_TTSN_fops);
	if (MAC_TTSN == NULL) {
		printk(KERN_INFO "error creating file: MAC_TTSN\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TSR =
	    debugfs_create_file("MAC_TSR", 744, dir, pdata,
				&MAC_TSR_fops);
	if (MAC_TSR == NULL) {
		printk(KERN_INFO "error creating file: MAC_TSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_STHWR =
	    debugfs_create_file("MAC_STHWR", 744, dir, pdata,
				&MAC_STHWR_fops);
	if (MAC_STHWR == NULL) {
		printk(KERN_INFO "error creating file: MAC_STHWR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TAR =
	    debugfs_create_file("MAC_TAR", 744, dir, pdata,
				&MAC_TAR_fops);
	if (MAC_TAR == NULL) {
		printk(KERN_INFO "error creating file: MAC_TAR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_STNSUR =
	    debugfs_create_file("MAC_STNSUR", 744, dir, pdata,
				&MAC_STNSUR_fops);
	if (MAC_STNSUR == NULL) {
		printk(KERN_INFO "error creating file: MAC_STNSUR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_STSUR =
	    debugfs_create_file("MAC_STSUR", 744, dir, pdata,
				&MAC_STSUR_fops);
	if (MAC_STSUR == NULL) {
		printk(KERN_INFO "error creating file: MAC_STSUR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_STNSR =
	    debugfs_create_file("MAC_STNSR", 744, dir, pdata,
				&MAC_STNSR_fops);
	if (MAC_STNSR == NULL) {
		printk(KERN_INFO "error creating file: MAC_STNSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_STSR =
	    debugfs_create_file("MAC_STSR", 744, dir, pdata,
				&MAC_STSR_fops);
	if (MAC_STSR == NULL) {
		printk(KERN_INFO "error creating file: MAC_STSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_SSIR =
	    debugfs_create_file("MAC_SSIR", 744, dir, pdata,
				&MAC_SSIR_fops);
	if (MAC_SSIR == NULL) {
		printk(KERN_INFO "error creating file: MAC_SSIR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TCR =
	    debugfs_create_file("MAC_TCR", 744, dir, pdata,
				&MAC_TCR_fops);
	if (MAC_TCR == NULL) {
		printk(KERN_INFO "error creating file: MAC_TCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_DSR =
	    debugfs_create_file("MTL_DSR", 744, dir, pdata,
				&MTL_DSR_fops);
	if (MTL_DSR == NULL) {
		printk(KERN_INFO "error creating file: MTL_DSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RWPFFR =
	    debugfs_create_file("MAC_RWPFFR", 744, dir, pdata,
				&MAC_RWPFFR_fops);
	if (MAC_RWPFFR == NULL) {
		printk(KERN_INFO "error creating file: MAC_RWPFFR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RTSR =
	    debugfs_create_file("MAC_RTSR", 744, dir, pdata,
				&MAC_RTSR_fops);
	if (MAC_RTSR == NULL) {
		printk(KERN_INFO "error creating file: MAC_RTSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_IER =
	    debugfs_create_file("MTL_IER", 744, dir, pdata,
				&MTL_IER_fops);
	if (MTL_IER == NULL) {
		printk(KERN_INFO "error creating file: MTL_IER\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR7 =
	    debugfs_create_file("MTL_QRCR7", 744, dir, pdata,
				&MTL_QRCR7_fops);
	if (MTL_QRCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR6 =
	    debugfs_create_file("MTL_QRCR6", 744, dir, pdata,
				&MTL_QRCR6_fops);
	if (MTL_QRCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR5 =
	    debugfs_create_file("MTL_QRCR5", 744, dir, pdata,
				&MTL_QRCR5_fops);
	if (MTL_QRCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR4 =
	    debugfs_create_file("MTL_QRCR4", 744, dir, pdata,
				&MTL_QRCR4_fops);
	if (MTL_QRCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR3 =
	    debugfs_create_file("MTL_QRCR3", 744, dir, pdata,
				&MTL_QRCR3_fops);
	if (MTL_QRCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR2 =
	    debugfs_create_file("MTL_QRCR2", 744, dir, pdata,
				&MTL_QRCR2_fops);
	if (MTL_QRCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRCR1 =
	    debugfs_create_file("MTL_QRCR1", 744, dir, pdata,
				&MTL_QRCR1_fops);
	if (MTL_QRCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR7 =
	    debugfs_create_file("MTL_QRDR7", 744, dir, pdata,
				&MTL_QRDR7_fops);
	if (MTL_QRDR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR6 =
	    debugfs_create_file("MTL_QRDR6", 744, dir, pdata,
				&MTL_QRDR6_fops);
	if (MTL_QRDR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR5 =
	    debugfs_create_file("MTL_QRDR5", 744, dir, pdata,
				&MTL_QRDR5_fops);
	if (MTL_QRDR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR4 =
	    debugfs_create_file("MTL_QRDR4", 744, dir, pdata,
				&MTL_QRDR4_fops);
	if (MTL_QRDR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR3 =
	    debugfs_create_file("MTL_QRDR3", 744, dir, pdata,
				&MTL_QRDR3_fops);
	if (MTL_QRDR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR2 =
	    debugfs_create_file("MTL_QRDR2", 744, dir, pdata,
				&MTL_QRDR2_fops);
	if (MTL_QRDR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QRDR1 =
	    debugfs_create_file("MTL_QRDR1", 744, dir, pdata,
				&MTL_QRDR1_fops);
	if (MTL_QRDR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QRDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR7 =
	    debugfs_create_file("MTL_QOCR7", 744, dir, pdata,
				&MTL_QOCR7_fops);
	if (MTL_QOCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR6 =
	    debugfs_create_file("MTL_QOCR6", 744, dir, pdata,
				&MTL_QOCR6_fops);
	if (MTL_QOCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR5 =
	    debugfs_create_file("MTL_QOCR5", 744, dir, pdata,
				&MTL_QOCR5_fops);
	if (MTL_QOCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR4 =
	    debugfs_create_file("MTL_QOCR4", 744, dir, pdata,
				&MTL_QOCR4_fops);
	if (MTL_QOCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR3 =
	    debugfs_create_file("MTL_QOCR3", 744, dir, pdata,
				&MTL_QOCR3_fops);
	if (MTL_QOCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR2 =
	    debugfs_create_file("MTL_QOCR2", 744, dir, pdata,
				&MTL_QOCR2_fops);
	if (MTL_QOCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QOCR1 =
	    debugfs_create_file("MTL_QOCR1", 744, dir, pdata,
				&MTL_QOCR1_fops);
	if (MTL_QOCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QOCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR7 =
	    debugfs_create_file("MTL_QROMR7", 744, dir, pdata,
				&MTL_QROMR7_fops);
	if (MTL_QROMR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR6 =
	    debugfs_create_file("MTL_QROMR6", 744, dir, pdata,
				&MTL_QROMR6_fops);
	if (MTL_QROMR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR5 =
	    debugfs_create_file("MTL_QROMR5", 744, dir, pdata,
				&MTL_QROMR5_fops);
	if (MTL_QROMR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR4 =
	    debugfs_create_file("MTL_QROMR4", 744, dir, pdata,
				&MTL_QROMR4_fops);
	if (MTL_QROMR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR3 =
	    debugfs_create_file("MTL_QROMR3", 744, dir, pdata,
				&MTL_QROMR3_fops);
	if (MTL_QROMR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR2 =
	    debugfs_create_file("MTL_QROMR2", 744, dir, pdata,
				&MTL_QROMR2_fops);
	if (MTL_QROMR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QROMR1 =
	    debugfs_create_file("MTL_QROMR1", 744, dir, pdata,
				&MTL_QROMR1_fops);
	if (MTL_QROMR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QROMR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR7 =
	    debugfs_create_file("MTL_QLCR7", 744, dir, pdata,
				&MTL_QLCR7_fops);
	if (MTL_QLCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR6 =
	    debugfs_create_file("MTL_QLCR6", 744, dir, pdata,
				&MTL_QLCR6_fops);
	if (MTL_QLCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR5 =
	    debugfs_create_file("MTL_QLCR5", 744, dir, pdata,
				&MTL_QLCR5_fops);
	if (MTL_QLCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR4 =
	    debugfs_create_file("MTL_QLCR4", 744, dir, pdata,
				&MTL_QLCR4_fops);
	if (MTL_QLCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR3 =
	    debugfs_create_file("MTL_QLCR3", 744, dir, pdata,
				&MTL_QLCR3_fops);
	if (MTL_QLCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR2 =
	    debugfs_create_file("MTL_QLCR2", 744, dir, pdata,
				&MTL_QLCR2_fops);
	if (MTL_QLCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QLCR1 =
	    debugfs_create_file("MTL_QLCR1", 744, dir, pdata,
				&MTL_QLCR1_fops);
	if (MTL_QLCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QLCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR7 =
	    debugfs_create_file("MTL_QHCR7", 744, dir, pdata,
				&MTL_QHCR7_fops);
	if (MTL_QHCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR6 =
	    debugfs_create_file("MTL_QHCR6", 744, dir, pdata,
				&MTL_QHCR6_fops);
	if (MTL_QHCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR5 =
	    debugfs_create_file("MTL_QHCR5", 744, dir, pdata,
				&MTL_QHCR5_fops);
	if (MTL_QHCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR4 =
	    debugfs_create_file("MTL_QHCR4", 744, dir, pdata,
				&MTL_QHCR4_fops);
	if (MTL_QHCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR3 =
	    debugfs_create_file("MTL_QHCR3", 744, dir, pdata,
				&MTL_QHCR3_fops);
	if (MTL_QHCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR2 =
	    debugfs_create_file("MTL_QHCR2", 744, dir, pdata,
				&MTL_QHCR2_fops);
	if (MTL_QHCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QHCR1 =
	    debugfs_create_file("MTL_QHCR1", 744, dir, pdata,
				&MTL_QHCR1_fops);
	if (MTL_QHCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QHCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR7 =
	    debugfs_create_file("MTL_QSSCR7", 744, dir, pdata,
				&MTL_QSSCR7_fops);
	if (MTL_QSSCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR6 =
	    debugfs_create_file("MTL_QSSCR6", 744, dir, pdata,
				&MTL_QSSCR6_fops);
	if (MTL_QSSCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR5 =
	    debugfs_create_file("MTL_QSSCR5", 744, dir, pdata,
				&MTL_QSSCR5_fops);
	if (MTL_QSSCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR4 =
	    debugfs_create_file("MTL_QSSCR4", 744, dir, pdata,
				&MTL_QSSCR4_fops);
	if (MTL_QSSCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR3 =
	    debugfs_create_file("MTL_QSSCR3", 744, dir, pdata,
				&MTL_QSSCR3_fops);
	if (MTL_QSSCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR2 =
	    debugfs_create_file("MTL_QSSCR2", 744, dir, pdata,
				&MTL_QSSCR2_fops);
	if (MTL_QSSCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QSSCR1 =
	    debugfs_create_file("MTL_QSSCR1", 744, dir, pdata,
				&MTL_QSSCR1_fops);
	if (MTL_QSSCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QSSCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW7 =
	    debugfs_create_file("MTL_QW7", 744, dir, pdata,
				&MTL_QW7_fops);
	if (MTL_QW7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW6 =
	    debugfs_create_file("MTL_QW6", 744, dir, pdata,
				&MTL_QW6_fops);
	if (MTL_QW6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW5 =
	    debugfs_create_file("MTL_QW5", 744, dir, pdata,
				&MTL_QW5_fops);
	if (MTL_QW5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW4 =
	    debugfs_create_file("MTL_QW4", 744, dir, pdata,
				&MTL_QW4_fops);
	if (MTL_QW4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW3 =
	    debugfs_create_file("MTL_QW3", 744, dir, pdata,
				&MTL_QW3_fops);
	if (MTL_QW3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW2 =
	    debugfs_create_file("MTL_QW2", 744, dir, pdata,
				&MTL_QW2_fops);
	if (MTL_QW2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QW1 =
	    debugfs_create_file("MTL_QW1", 744, dir, pdata,
				&MTL_QW1_fops);
	if (MTL_QW1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QW1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR7 =
	    debugfs_create_file("MTL_QESR7", 744, dir, pdata,
				&MTL_QESR7_fops);
	if (MTL_QESR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR6 =
	    debugfs_create_file("MTL_QESR6", 744, dir, pdata,
				&MTL_QESR6_fops);
	if (MTL_QESR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR5 =
	    debugfs_create_file("MTL_QESR5", 744, dir, pdata,
				&MTL_QESR5_fops);
	if (MTL_QESR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR4 =
	    debugfs_create_file("MTL_QESR4", 744, dir, pdata,
				&MTL_QESR4_fops);
	if (MTL_QESR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR3 =
	    debugfs_create_file("MTL_QESR3", 744, dir, pdata,
				&MTL_QESR3_fops);
	if (MTL_QESR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR2 =
	    debugfs_create_file("MTL_QESR2", 744, dir, pdata,
				&MTL_QESR2_fops);
	if (MTL_QESR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QESR1 =
	    debugfs_create_file("MTL_QESR1", 744, dir, pdata,
				&MTL_QESR1_fops);
	if (MTL_QESR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QESR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR7 =
	    debugfs_create_file("MTL_QECR7", 744, dir, pdata,
				&MTL_QECR7_fops);
	if (MTL_QECR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR6 =
	    debugfs_create_file("MTL_QECR6", 744, dir, pdata,
				&MTL_QECR6_fops);
	if (MTL_QECR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR5 =
	    debugfs_create_file("MTL_QECR5", 744, dir, pdata,
				&MTL_QECR5_fops);
	if (MTL_QECR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR4 =
	    debugfs_create_file("MTL_QECR4", 744, dir, pdata,
				&MTL_QECR4_fops);
	if (MTL_QECR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR3 =
	    debugfs_create_file("MTL_QECR3", 744, dir, pdata,
				&MTL_QECR3_fops);
	if (MTL_QECR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR2 =
	    debugfs_create_file("MTL_QECR2", 744, dir, pdata,
				&MTL_QECR2_fops);
	if (MTL_QECR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QECR1 =
	    debugfs_create_file("MTL_QECR1", 744, dir, pdata,
				&MTL_QECR1_fops);
	if (MTL_QECR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QECR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR7 =
	    debugfs_create_file("MTL_QTDR7", 744, dir, pdata,
				&MTL_QTDR7_fops);
	if (MTL_QTDR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR6 =
	    debugfs_create_file("MTL_QTDR6", 744, dir, pdata,
				&MTL_QTDR6_fops);
	if (MTL_QTDR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR5 =
	    debugfs_create_file("MTL_QTDR5", 744, dir, pdata,
				&MTL_QTDR5_fops);
	if (MTL_QTDR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR4 =
	    debugfs_create_file("MTL_QTDR4", 744, dir, pdata,
				&MTL_QTDR4_fops);
	if (MTL_QTDR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR3 =
	    debugfs_create_file("MTL_QTDR3", 744, dir, pdata,
				&MTL_QTDR3_fops);
	if (MTL_QTDR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR2 =
	    debugfs_create_file("MTL_QTDR2", 744, dir, pdata,
				&MTL_QTDR2_fops);
	if (MTL_QTDR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTDR1 =
	    debugfs_create_file("MTL_QTDR1", 744, dir, pdata,
				&MTL_QTDR1_fops);
	if (MTL_QTDR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR7 =
	    debugfs_create_file("MTL_QUCR7", 744, dir, pdata,
				&MTL_QUCR7_fops);
	if (MTL_QUCR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR6 =
	    debugfs_create_file("MTL_QUCR6", 744, dir, pdata,
				&MTL_QUCR6_fops);
	if (MTL_QUCR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR5 =
	    debugfs_create_file("MTL_QUCR5", 744, dir, pdata,
				&MTL_QUCR5_fops);
	if (MTL_QUCR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR4 =
	    debugfs_create_file("MTL_QUCR4", 744, dir, pdata,
				&MTL_QUCR4_fops);
	if (MTL_QUCR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR3 =
	    debugfs_create_file("MTL_QUCR3", 744, dir, pdata,
				&MTL_QUCR3_fops);
	if (MTL_QUCR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR2 =
	    debugfs_create_file("MTL_QUCR2", 744, dir, pdata,
				&MTL_QUCR2_fops);
	if (MTL_QUCR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QUCR1 =
	    debugfs_create_file("MTL_QUCR1", 744, dir, pdata,
				&MTL_QUCR1_fops);
	if (MTL_QUCR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QUCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR7 =
	    debugfs_create_file("MTL_QTOMR7", 744, dir, pdata,
				&MTL_QTOMR7_fops);
	if (MTL_QTOMR7 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR6 =
	    debugfs_create_file("MTL_QTOMR6", 744, dir, pdata,
				&MTL_QTOMR6_fops);
	if (MTL_QTOMR6 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR5 =
	    debugfs_create_file("MTL_QTOMR5", 744, dir, pdata,
				&MTL_QTOMR5_fops);
	if (MTL_QTOMR5 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR4 =
	    debugfs_create_file("MTL_QTOMR4", 744, dir, pdata,
				&MTL_QTOMR4_fops);
	if (MTL_QTOMR4 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR3 =
	    debugfs_create_file("MTL_QTOMR3", 744, dir, pdata,
				&MTL_QTOMR3_fops);
	if (MTL_QTOMR3 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR2 =
	    debugfs_create_file("MTL_QTOMR2", 744, dir, pdata,
				&MTL_QTOMR2_fops);
	if (MTL_QTOMR2 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_QTOMR1 =
	    debugfs_create_file("MTL_QTOMR1", 744, dir, pdata,
				&MTL_QTOMR1_fops);
	if (MTL_QTOMR1 == NULL) {
		printk(KERN_INFO "error creating file: MTL_QTOMR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_PMTCSR =
	    debugfs_create_file("MAC_PMTCSR", 744, dir, pdata,
				&MAC_PMTCSR_fops);
	if (MAC_PMTCSR == NULL) {
		printk(KERN_INFO "error creating file: MAC_PMTCSR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXICMP_ERR_OCTETS =
	    debugfs_create_file("MMC_RXICMP_ERR_OCTETS", 744, dir,
				pdata,
				&MMC_RXICMP_ERR_OCTETS_fops);
	if (MMC_RXICMP_ERR_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXICMP_ERR_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXICMP_GD_OCTETS =
	    debugfs_create_file("MMC_RXICMP_GD_OCTETS", 744, dir,
				pdata,
				&MMC_RXICMP_GD_OCTETS_fops);
	if (MMC_RXICMP_GD_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXICMP_GD_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXTCP_ERR_OCTETS =
	    debugfs_create_file("MMC_RXTCP_ERR_OCTETS", 744, dir,
				pdata,
				&MMC_RXTCP_ERR_OCTETS_fops);
	if (MMC_RXTCP_ERR_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXTCP_ERR_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXTCP_GD_OCTETS =
	    debugfs_create_file("MMC_RXTCP_GD_OCTETS", 744, dir,
				pdata,
				&MMC_RXTCP_GD_OCTETS_fops);
	if (MMC_RXTCP_GD_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXTCP_GD_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUDP_ERR_OCTETS =
	    debugfs_create_file("MMC_RXUDP_ERR_OCTETS", 744, dir,
				pdata,
				&MMC_RXUDP_ERR_OCTETS_fops);
	if (MMC_RXUDP_ERR_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXUDP_ERR_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUDP_GD_OCTETS =
	    debugfs_create_file("MMC_RXUDP_GD_OCTETS", 744, dir,
				pdata,
				&MMC_RXUDP_GD_OCTETS_fops);
	if (MMC_RXUDP_GD_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXUDP_GD_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_NOPAY_OCTETS =
	    debugfs_create_file("MMC_RXIPV6_NOPAY_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV6_NOPAY_OCTETS_fops);
	if (MMC_RXIPV6_NOPAY_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV6_NOPAY_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_HDRERR_OCTETS =
	    debugfs_create_file("MMC_RXIPV6_HDRERR_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV6_HDRERR_OCTETS_fops);
	if (MMC_RXIPV6_HDRERR_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV6_HDRERR_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_GD_OCTETS =
	    debugfs_create_file("MMC_RXIPV6_GD_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV6_GD_OCTETS_fops);
	if (MMC_RXIPV6_GD_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXIPV6_GD_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_UDSBL_OCTETS =
	    debugfs_create_file("MMC_RXIPV4_UDSBL_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV4_UDSBL_OCTETS_fops);
	if (MMC_RXIPV4_UDSBL_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_UDSBL_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_FRAG_OCTETS =
	    debugfs_create_file("MMC_RXIPV4_FRAG_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV4_FRAG_OCTETS_fops);
	if (MMC_RXIPV4_FRAG_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_FRAG_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_NOPAY_OCTETS =
	    debugfs_create_file("MMC_RXIPV4_NOPAY_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV4_NOPAY_OCTETS_fops);
	if (MMC_RXIPV4_NOPAY_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_NOPAY_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_HDRERR_OCTETS =
	    debugfs_create_file("MMC_RXIPV4_HDRERR_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV4_HDRERR_OCTETS_fops);
	if (MMC_RXIPV4_HDRERR_OCTETS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_HDRERR_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_GD_OCTETS =
	    debugfs_create_file("MMC_RXIPV4_GD_OCTETS", 744, dir,
				pdata,
				&MMC_RXIPV4_GD_OCTETS_fops);
	if (MMC_RXIPV4_GD_OCTETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXIPV4_GD_OCTETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXICMP_ERR_PKTS =
	    debugfs_create_file("MMC_RXICMP_ERR_PKTS", 744, dir,
				pdata,
				&MMC_RXICMP_ERR_PKTS_fops);
	if (MMC_RXICMP_ERR_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXICMP_ERR_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXICMP_GD_PKTS =
	    debugfs_create_file("MMC_RXICMP_GD_PKTS", 744, dir,
				pdata,
				&MMC_RXICMP_GD_PKTS_fops);
	if (MMC_RXICMP_GD_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXICMP_GD_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXTCP_ERR_PKTS =
	    debugfs_create_file("MMC_RXTCP_ERR_PKTS", 744, dir,
				pdata,
				&MMC_RXTCP_ERR_PKTS_fops);
	if (MMC_RXTCP_ERR_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXTCP_ERR_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXTCP_GD_PKTS =
	    debugfs_create_file("MMC_RXTCP_GD_PKTS", 744, dir,
				pdata,
				&MMC_RXTCP_GD_PKTS_fops);
	if (MMC_RXTCP_GD_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXTCP_GD_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUDP_ERR_PKTS =
	    debugfs_create_file("MMC_RXUDP_ERR_PKTS", 744, dir,
				pdata,
				&MMC_RXUDP_ERR_PKTS_fops);
	if (MMC_RXUDP_ERR_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXUDP_ERR_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUDP_GD_PKTS =
	    debugfs_create_file("MMC_RXUDP_GD_PKTS", 744, dir,
				pdata,
				&MMC_RXUDP_GD_PKTS_fops);
	if (MMC_RXUDP_GD_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXUDP_GD_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_NOPAY_PKTS =
	    debugfs_create_file("MMC_RXIPV6_NOPAY_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV6_NOPAY_PKTS_fops);
	if (MMC_RXIPV6_NOPAY_PKTS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV6_NOPAY_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_HDRERR_PKTS =
	    debugfs_create_file("MMC_RXIPV6_HDRERR_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV6_HDRERR_PKTS_fops);
	if (MMC_RXIPV6_HDRERR_PKTS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV6_HDRERR_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV6_GD_PKTS =
	    debugfs_create_file("MMC_RXIPV6_GD_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV6_GD_PKTS_fops);
	if (MMC_RXIPV6_GD_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXIPV6_GD_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_UBSBL_PKTS =
	    debugfs_create_file("MMC_RXIPV4_UBSBL_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV4_UBSBL_PKTS_fops);
	if (MMC_RXIPV4_UBSBL_PKTS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_UBSBL_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_FRAG_PKTS =
	    debugfs_create_file("MMC_RXIPV4_FRAG_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV4_FRAG_PKTS_fops);
	if (MMC_RXIPV4_FRAG_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXIPV4_FRAG_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_NOPAY_PKTS =
	    debugfs_create_file("MMC_RXIPV4_NOPAY_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV4_NOPAY_PKTS_fops);
	if (MMC_RXIPV4_NOPAY_PKTS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_NOPAY_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_HDRERR_PKTS =
	    debugfs_create_file("MMC_RXIPV4_HDRERR_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV4_HDRERR_PKTS_fops);
	if (MMC_RXIPV4_HDRERR_PKTS == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXIPV4_HDRERR_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXIPV4_GD_PKTS =
	    debugfs_create_file("MMC_RXIPV4_GD_PKTS", 744, dir,
				pdata,
				&MMC_RXIPV4_GD_PKTS_fops);
	if (MMC_RXIPV4_GD_PKTS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXIPV4_GD_PKTS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXCTRLPACKETS_G =
	    debugfs_create_file("MMC_RXCTRLPACKETS_G", 744, dir,
				pdata,
				&MMC_RXCTRLPACKETS_G_fops);
	if (MMC_RXCTRLPACKETS_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXCTRLPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXRCVERROR =
	    debugfs_create_file("MMC_RXRCVERROR", 744, dir, pdata,
				&MMC_RXRCVERROR_fops);
	if (MMC_RXRCVERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXRCVERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXWATCHDOGERROR =
	    debugfs_create_file("MMC_RXWATCHDOGERROR", 744, dir,
				pdata,
				&MMC_RXWATCHDOGERROR_fops);
	if (MMC_RXWATCHDOGERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXWATCHDOGERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXVLANPACKETS_GB =
	    debugfs_create_file("MMC_RXVLANPACKETS_GB", 744, dir,
				pdata,
				&MMC_RXVLANPACKETS_GB_fops);
	if (MMC_RXVLANPACKETS_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXVLANPACKETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXFIFOOVERFLOW =
	    debugfs_create_file("MMC_RXFIFOOVERFLOW", 744, dir,
				pdata,
				&MMC_RXFIFOOVERFLOW_fops);
	if (MMC_RXFIFOOVERFLOW == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXFIFOOVERFLOW\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXPAUSEPACKETS =
	    debugfs_create_file("MMC_RXPAUSEPACKETS", 744, dir,
				pdata,
				&MMC_RXPAUSEPACKETS_fops);
	if (MMC_RXPAUSEPACKETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXPAUSEPACKETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXOUTOFRANGETYPE =
	    debugfs_create_file("MMC_RXOUTOFRANGETYPE", 744, dir,
				pdata,
				&MMC_RXOUTOFRANGETYPE_fops);
	if (MMC_RXOUTOFRANGETYPE == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXOUTOFRANGETYPE\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXLENGTHERROR =
	    debugfs_create_file("MMC_RXLENGTHERROR", 744, dir,
				pdata,
				&MMC_RXLENGTHERROR_fops);
	if (MMC_RXLENGTHERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXLENGTHERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUNICASTPACKETS_G =
	    debugfs_create_file("MMC_RXUNICASTPACKETS_G", 744, dir,
				pdata,
				&MMC_RXUNICASTPACKETS_G_fops);
	if (MMC_RXUNICASTPACKETS_G == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXUNICASTPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX1024TOMAXOCTETS_GB =
	    debugfs_create_file("MMC_RX1024TOMAXOCTETS_GB", 744, dir,
				pdata,
				&MMC_RX1024TOMAXOCTETS_GB_fops);
	if (MMC_RX1024TOMAXOCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RX1024TOMAXOCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX512TO1023OCTETS_GB =
	    debugfs_create_file("MMC_RX512TO1023OCTETS_GB", 744, dir,
				pdata,
				&MMC_RX512TO1023OCTETS_GB_fops);
	if (MMC_RX512TO1023OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RX512TO1023OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX256TO511OCTETS_GB =
	    debugfs_create_file("MMC_RX256TO511OCTETS_GB", 744, dir,
				pdata,
				&MMC_RX256TO511OCTETS_GB_fops);
	if (MMC_RX256TO511OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RX256TO511OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX128TO255OCTETS_GB =
	    debugfs_create_file("MMC_RX128TO255OCTETS_GB", 744, dir,
				pdata,
				&MMC_RX128TO255OCTETS_GB_fops);
	if (MMC_RX128TO255OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RX128TO255OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX65TO127OCTETS_GB =
	    debugfs_create_file("MMC_RX65TO127OCTETS_GB", 744, dir,
				pdata,
				&MMC_RX65TO127OCTETS_GB_fops);
	if (MMC_RX65TO127OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RX65TO127OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RX64OCTETS_GB =
	    debugfs_create_file("MMC_RX64OCTETS_GB", 744, dir,
				pdata,
				&MMC_RX64OCTETS_GB_fops);
	if (MMC_RX64OCTETS_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_RX64OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXOVERSIZE_G =
	    debugfs_create_file("MMC_RXOVERSIZE_G", 744, dir,
				pdata, &MMC_RXOVERSIZE_G_fops);
	if (MMC_RXOVERSIZE_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXOVERSIZE_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXUNDERSIZE_G =
	    debugfs_create_file("MMC_RXUNDERSIZE_G", 744, dir,
				pdata,
				&MMC_RXUNDERSIZE_G_fops);
	if (MMC_RXUNDERSIZE_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXUNDERSIZE_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXJABBERERROR =
	    debugfs_create_file("MMC_RXJABBERERROR", 744, dir,
				pdata,
				&MMC_RXJABBERERROR_fops);
	if (MMC_RXJABBERERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXJABBERERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXRUNTERROR =
	    debugfs_create_file("MMC_RXRUNTERROR", 744, dir,
				pdata, &MMC_RXRUNTERROR_fops);
	if (MMC_RXRUNTERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXRUNTERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXALIGNMENTERROR =
	    debugfs_create_file("MMC_RXALIGNMENTERROR", 744, dir,
				pdata,
				&MMC_RXALIGNMENTERROR_fops);
	if (MMC_RXALIGNMENTERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXALIGNMENTERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXCRCERROR =
	    debugfs_create_file("MMC_RXCRCERROR", 744, dir, pdata,
				&MMC_RXCRCERROR_fops);
	if (MMC_RXCRCERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXCRCERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXMULTICASTPACKETS_G =
	    debugfs_create_file("MMC_RXMULTICASTPACKETS_G", 744, dir,
				pdata,
				&MMC_RXMULTICASTPACKETS_G_fops);
	if (MMC_RXMULTICASTPACKETS_G == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXMULTICASTPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXBROADCASTPACKETS_G =
	    debugfs_create_file("MMC_RXBROADCASTPACKETS_G", 744, dir,
				pdata,
				&MMC_RXBROADCASTPACKETS_G_fops);
	if (MMC_RXBROADCASTPACKETS_G == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_RXBROADCASTPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXOCTETCOUNT_G =
	    debugfs_create_file("MMC_RXOCTETCOUNT_G", 744, dir,
				pdata,
				&MMC_RXOCTETCOUNT_G_fops);
	if (MMC_RXOCTETCOUNT_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXOCTETCOUNT_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXOCTETCOUNT_GB =
	    debugfs_create_file("MMC_RXOCTETCOUNT_GB", 744, dir,
				pdata,
				&MMC_RXOCTETCOUNT_GB_fops);
	if (MMC_RXOCTETCOUNT_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXOCTETCOUNT_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_RXPACKETCOUNT_GB =
	    debugfs_create_file("MMC_RXPACKETCOUNT_GB", 744, dir,
				pdata,
				&MMC_RXPACKETCOUNT_GB_fops);
	if (MMC_RXPACKETCOUNT_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_RXPACKETCOUNT_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXOVERSIZE_G =
	    debugfs_create_file("MMC_TXOVERSIZE_G", 744, dir,
				pdata, &MMC_TXOVERSIZE_G_fops);
	if (MMC_TXOVERSIZE_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXOVERSIZE_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXVLANPACKETS_G =
	    debugfs_create_file("MMC_TXVLANPACKETS_G", 744, dir,
				pdata,
				&MMC_TXVLANPACKETS_G_fops);
	if (MMC_TXVLANPACKETS_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXVLANPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXPAUSEPACKETS =
	    debugfs_create_file("MMC_TXPAUSEPACKETS", 744, dir,
				pdata,
				&MMC_TXPAUSEPACKETS_fops);
	if (MMC_TXPAUSEPACKETS == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXPAUSEPACKETS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXEXCESSDEF =
	    debugfs_create_file("MMC_TXEXCESSDEF", 744, dir,
				pdata, &MMC_TXEXCESSDEF_fops);
	if (MMC_TXEXCESSDEF == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXEXCESSDEF\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXPACKETSCOUNT_G =
	    debugfs_create_file("MMC_TXPACKETSCOUNT_G", 744, dir,
				pdata,
				&MMC_TXPACKETSCOUNT_G_fops);
	if (MMC_TXPACKETSCOUNT_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXPACKETSCOUNT_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXOCTETCOUNT_G =
	    debugfs_create_file("MMC_TXOCTETCOUNT_G", 744, dir,
				pdata,
				&MMC_TXOCTETCOUNT_G_fops);
	if (MMC_TXOCTETCOUNT_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXOCTETCOUNT_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXCARRIERERROR =
	    debugfs_create_file("MMC_TXCARRIERERROR", 744, dir,
				pdata,
				&MMC_TXCARRIERERROR_fops);
	if (MMC_TXCARRIERERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXCARRIERERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXEXESSCOL =
	    debugfs_create_file("MMC_TXEXESSCOL", 744, dir, pdata,
				&MMC_TXEXESSCOL_fops);
	if (MMC_TXEXESSCOL == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXEXESSCOL\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXLATECOL =
	    debugfs_create_file("MMC_TXLATECOL", 744, dir, pdata,
				&MMC_TXLATECOL_fops);
	if (MMC_TXLATECOL == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXLATECOL\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXDEFERRED =
	    debugfs_create_file("MMC_TXDEFERRED", 744, dir, pdata,
				&MMC_TXDEFERRED_fops);
	if (MMC_TXDEFERRED == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXDEFERRED\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXMULTICOL_G =
	    debugfs_create_file("MMC_TXMULTICOL_G", 744, dir,
				pdata, &MMC_TXMULTICOL_G_fops);
	if (MMC_TXMULTICOL_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXMULTICOL_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXSINGLECOL_G =
	    debugfs_create_file("MMC_TXSINGLECOL_G", 744, dir,
				pdata,
				&MMC_TXSINGLECOL_G_fops);
	if (MMC_TXSINGLECOL_G == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXSINGLECOL_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXUNDERFLOWERROR =
	    debugfs_create_file("MMC_TXUNDERFLOWERROR", 744, dir,
				pdata,
				&MMC_TXUNDERFLOWERROR_fops);
	if (MMC_TXUNDERFLOWERROR == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXUNDERFLOWERROR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXBROADCASTPACKETS_GB =
	    debugfs_create_file("MMC_TXBROADCASTPACKETS_GB", 744, dir,
				pdata,
				&MMC_TXBROADCASTPACKETS_GB_fops);
	if (MMC_TXBROADCASTPACKETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TXBROADCASTPACKETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXMULTICASTPACKETS_GB =
	    debugfs_create_file("MMC_TXMULTICASTPACKETS_GB", 744, dir,
				pdata,
				&MMC_TXMULTICASTPACKETS_GB_fops);
	if (MMC_TXMULTICASTPACKETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TXMULTICASTPACKETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXUNICASTPACKETS_GB =
	    debugfs_create_file("MMC_TXUNICASTPACKETS_GB", 744, dir,
				pdata,
				&MMC_TXUNICASTPACKETS_GB_fops);
	if (MMC_TXUNICASTPACKETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TXUNICASTPACKETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX1024TOMAXOCTETS_GB =
	    debugfs_create_file("MMC_TX1024TOMAXOCTETS_GB", 744, dir,
				pdata,
				&MMC_TX1024TOMAXOCTETS_GB_fops);
	if (MMC_TX1024TOMAXOCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TX1024TOMAXOCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX512TO1023OCTETS_GB =
	    debugfs_create_file("MMC_TX512TO1023OCTETS_GB", 744, dir,
				pdata,
				&MMC_TX512TO1023OCTETS_GB_fops);
	if (MMC_TX512TO1023OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TX512TO1023OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX256TO511OCTETS_GB =
	    debugfs_create_file("MMC_TX256TO511OCTETS_GB", 744, dir,
				pdata,
				&MMC_TX256TO511OCTETS_GB_fops);
	if (MMC_TX256TO511OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TX256TO511OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX128TO255OCTETS_GB =
	    debugfs_create_file("MMC_TX128TO255OCTETS_GB", 744, dir,
				pdata,
				&MMC_TX128TO255OCTETS_GB_fops);
	if (MMC_TX128TO255OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TX128TO255OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX65TO127OCTETS_GB =
	    debugfs_create_file("MMC_TX65TO127OCTETS_GB", 744, dir,
				pdata,
				&MMC_TX65TO127OCTETS_GB_fops);
	if (MMC_TX65TO127OCTETS_GB == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TX65TO127OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TX64OCTETS_GB =
	    debugfs_create_file("MMC_TX64OCTETS_GB", 744, dir,
				pdata,
				&MMC_TX64OCTETS_GB_fops);
	if (MMC_TX64OCTETS_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_TX64OCTETS_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXMULTICASTPACKETS_G =
	    debugfs_create_file("MMC_TXMULTICASTPACKETS_G", 744, dir,
				pdata,
				&MMC_TXMULTICASTPACKETS_G_fops);
	if (MMC_TXMULTICASTPACKETS_G == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TXMULTICASTPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXBROADCASTPACKETS_G =
	    debugfs_create_file("MMC_TXBROADCASTPACKETS_G", 744, dir,
				pdata,
				&MMC_TXBROADCASTPACKETS_G_fops);
	if (MMC_TXBROADCASTPACKETS_G == NULL) {
		printk(KERN_INFO
		       "error creating file: MMC_TXBROADCASTPACKETS_G\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXPACKETCOUNT_GB =
	    debugfs_create_file("MMC_TXPACKETCOUNT_GB", 744, dir,
				pdata,
				&MMC_TXPACKETCOUNT_GB_fops);
	if (MMC_TXPACKETCOUNT_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXPACKETCOUNT_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_TXOCTETCOUNT_GB =
	    debugfs_create_file("MMC_TXOCTETCOUNT_GB", 744, dir,
				pdata,
				&MMC_TXOCTETCOUNT_GB_fops);
	if (MMC_TXOCTETCOUNT_GB == NULL) {
		printk(KERN_INFO "error creating file: MMC_TXOCTETCOUNT_GB\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_IPC_INTR_RX =
	    debugfs_create_file("MMC_IPC_INTR_RX", 744, dir,
				pdata, &MMC_IPC_INTR_RX_fops);
	if (MMC_IPC_INTR_RX == NULL) {
		printk(KERN_INFO "error creating file: MMC_IPC_INTR_RX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_IPC_INTR_MASK_RX =
	    debugfs_create_file("MMC_IPC_INTR_MASK_RX", 744, dir,
				pdata,
				&MMC_IPC_INTR_MASK_RX_fops);
	if (MMC_IPC_INTR_MASK_RX == NULL) {
		printk(KERN_INFO "error creating file: MMC_IPC_INTR_MASK_RX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_INTR_MASK_TX =
	    debugfs_create_file("MMC_INTR_MASK_TX", 744, dir,
				pdata, &MMC_INTR_MASK_TX_fops);
	if (MMC_INTR_MASK_TX == NULL) {
		printk(KERN_INFO "error creating file: MMC_INTR_MASK_TX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_INTR_MASK_RX =
	    debugfs_create_file("MMC_INTR_MASK_RX", 744, dir,
				pdata, &MMC_INTR_MASK_RX_fops);
	if (MMC_INTR_MASK_RX == NULL) {
		printk(KERN_INFO "error creating file: MMC_INTR_MASK_RX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_INTR_TX =
	    debugfs_create_file("MMC_INTR_TX", 744, dir, pdata,
				&MMC_INTR_TX_fops);
	if (MMC_INTR_TX == NULL) {
		printk(KERN_INFO "error creating file: MMC_INTR_TX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_INTR_RX =
	    debugfs_create_file("MMC_INTR_RX", 744, dir, pdata,
				&MMC_INTR_RX_fops);
	if (MMC_INTR_RX == NULL) {
		printk(KERN_INFO "error creating file: MMC_INTR_RX\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MMC_CNTRL =
	    debugfs_create_file("MMC_CNTRL", 744, dir, pdata,
				&MMC_CNTRL_fops);
	if (MMC_CNTRL == NULL) {
		printk(KERN_INFO "error creating file: MMC_CNTRL\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1LR =
	    debugfs_create_file("MAC_MA1LR", 744, dir, pdata,
				&MAC_MA1LR_fops);
	if (MAC_MA1LR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1LR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA1HR =
	    debugfs_create_file("MAC_MA1HR", 744, dir, pdata,
				&MAC_MA1HR_fops);
	if (MAC_MA1HR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA1HR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA0LR =
	    debugfs_create_file("MAC_MA0LR", 744, dir, pdata,
				&MAC_MA0LR_fops);
	if (MAC_MA0LR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA0LR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MA0HR =
	    debugfs_create_file("MAC_MA0HR", 744, dir, pdata,
				&MAC_MA0HR_fops);
	if (MAC_MA0HR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MA0HR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_GPIOR =
	    debugfs_create_file("MAC_GPIOR", 744, dir, pdata,
				&MAC_GPIOR_fops);
	if (MAC_GPIOR == NULL) {
		printk(KERN_INFO "error creating file: MAC_GPIOR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_GMIIDR =
	    debugfs_create_file("MAC_GMIIDR", 744, dir, pdata,
				&MAC_GMIIDR_fops);
	if (MAC_GMIIDR == NULL) {
		printk(KERN_INFO "error creating file: MAC_GMIIDR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_GMIIAR =
	    debugfs_create_file("MAC_GMIIAR", 744, dir, pdata,
				&MAC_GMIIAR_fops);
	if (MAC_GMIIAR == NULL) {
		printk(KERN_INFO "error creating file: MAC_GMIIAR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HFR2 =
	    debugfs_create_file("MAC_HFR2", 744, dir, pdata,
				&MAC_HFR2_fops);
	if (MAC_HFR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HFR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HFR1 =
	    debugfs_create_file("MAC_HFR1", 744, dir, pdata,
				&MAC_HFR1_fops);
	if (MAC_HFR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HFR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HFR0 =
	    debugfs_create_file("MAC_HFR0", 744, dir, pdata,
				&MAC_HFR0_fops);
	if (MAC_HFR0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HFR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MDR =
	    debugfs_create_file("MAC_MDR", 744, dir, pdata,
				&MAC_MDR_fops);
	if (MAC_MDR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MDR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_VR =
	    debugfs_create_file("MAC_VR", 744, dir, pdata, &MAC_VR_fops);
	if (MAC_VR == NULL) {
		printk(KERN_INFO "error creating file: MAC_VR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR7 =
	    debugfs_create_file("MAC_HTR7", 744, dir, pdata,
				&MAC_HTR7_fops);
	if (MAC_HTR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR6 =
	    debugfs_create_file("MAC_HTR6", 744, dir, pdata,
				&MAC_HTR6_fops);
	if (MAC_HTR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR5 =
	    debugfs_create_file("MAC_HTR5", 744, dir, pdata,
				&MAC_HTR5_fops);
	if (MAC_HTR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR4 =
	    debugfs_create_file("MAC_HTR4", 744, dir, pdata,
				&MAC_HTR4_fops);
	if (MAC_HTR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR3 =
	    debugfs_create_file("MAC_HTR3", 744, dir, pdata,
				&MAC_HTR3_fops);
	if (MAC_HTR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR2 =
	    debugfs_create_file("MAC_HTR2", 744, dir, pdata,
				&MAC_HTR2_fops);
	if (MAC_HTR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR1 =
	    debugfs_create_file("MAC_HTR1", 744, dir, pdata,
				&MAC_HTR1_fops);
	if (MAC_HTR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_HTR0 =
	    debugfs_create_file("MAC_HTR0", 744, dir, pdata,
				&MAC_HTR0_fops);
	if (MAC_HTR0 == NULL) {
		printk(KERN_INFO "error creating file: MAC_HTR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR7 =
	    debugfs_create_file("DMA_RIWTR7", 744, dir, pdata,
				&DMA_RIWTR7_fops);
	if (DMA_RIWTR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR6 =
	    debugfs_create_file("DMA_RIWTR6", 744, dir, pdata,
				&DMA_RIWTR6_fops);
	if (DMA_RIWTR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR5 =
	    debugfs_create_file("DMA_RIWTR5", 744, dir, pdata,
				&DMA_RIWTR5_fops);
	if (DMA_RIWTR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR4 =
	    debugfs_create_file("DMA_RIWTR4", 744, dir, pdata,
				&DMA_RIWTR4_fops);
	if (DMA_RIWTR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR3 =
	    debugfs_create_file("DMA_RIWTR3", 744, dir, pdata,
				&DMA_RIWTR3_fops);
	if (DMA_RIWTR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR2 =
	    debugfs_create_file("DMA_RIWTR2", 744, dir, pdata,
				&DMA_RIWTR2_fops);
	if (DMA_RIWTR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR1 =
	    debugfs_create_file("DMA_RIWTR1", 744, dir, pdata,
				&DMA_RIWTR1_fops);
	if (DMA_RIWTR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RIWTR0 =
	    debugfs_create_file("DMA_RIWTR0", 744, dir, pdata,
				&DMA_RIWTR0_fops);
	if (DMA_RIWTR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RIWTR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR7 =
	    debugfs_create_file("DMA_RDRLR7", 744, dir, pdata,
				&DMA_RDRLR7_fops);
	if (DMA_RDRLR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR6 =
	    debugfs_create_file("DMA_RDRLR6", 744, dir, pdata,
				&DMA_RDRLR6_fops);
	if (DMA_RDRLR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR5 =
	    debugfs_create_file("DMA_RDRLR5", 744, dir, pdata,
				&DMA_RDRLR5_fops);
	if (DMA_RDRLR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR4 =
	    debugfs_create_file("DMA_RDRLR4", 744, dir, pdata,
				&DMA_RDRLR4_fops);
	if (DMA_RDRLR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR3 =
	    debugfs_create_file("DMA_RDRLR3", 744, dir, pdata,
				&DMA_RDRLR3_fops);
	if (DMA_RDRLR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR2 =
	    debugfs_create_file("DMA_RDRLR2", 744, dir, pdata,
				&DMA_RDRLR2_fops);
	if (DMA_RDRLR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR1 =
	    debugfs_create_file("DMA_RDRLR1", 744, dir, pdata,
				&DMA_RDRLR1_fops);
	if (DMA_RDRLR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDRLR0 =
	    debugfs_create_file("DMA_RDRLR0", 744, dir, pdata,
				&DMA_RDRLR0_fops);
	if (DMA_RDRLR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDRLR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR7 =
	    debugfs_create_file("DMA_TDRLR7", 744, dir, pdata,
				&DMA_TDRLR7_fops);
	if (DMA_TDRLR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR6 =
	    debugfs_create_file("DMA_TDRLR6", 744, dir, pdata,
				&DMA_TDRLR6_fops);
	if (DMA_TDRLR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR5 =
	    debugfs_create_file("DMA_TDRLR5", 744, dir, pdata,
				&DMA_TDRLR5_fops);
	if (DMA_TDRLR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR4 =
	    debugfs_create_file("DMA_TDRLR4", 744, dir, pdata,
				&DMA_TDRLR4_fops);
	if (DMA_TDRLR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR3 =
	    debugfs_create_file("DMA_TDRLR3", 744, dir, pdata,
				&DMA_TDRLR3_fops);
	if (DMA_TDRLR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR2 =
	    debugfs_create_file("DMA_TDRLR2", 744, dir, pdata,
				&DMA_TDRLR2_fops);
	if (DMA_TDRLR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR1 =
	    debugfs_create_file("DMA_TDRLR1", 744, dir, pdata,
				&DMA_TDRLR1_fops);
	if (DMA_TDRLR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDRLR0 =
	    debugfs_create_file("DMA_TDRLR0", 744, dir, pdata,
				&DMA_TDRLR0_fops);
	if (DMA_TDRLR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDRLR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR7 =
	    debugfs_create_file("DMA_RDTP_RPDR7", 744, dir, pdata,
				&DMA_RDTP_RPDR7_fops);
	if (DMA_RDTP_RPDR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR6 =
	    debugfs_create_file("DMA_RDTP_RPDR6", 744, dir, pdata,
				&DMA_RDTP_RPDR6_fops);
	if (DMA_RDTP_RPDR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR5 =
	    debugfs_create_file("DMA_RDTP_RPDR5", 744, dir, pdata,
				&DMA_RDTP_RPDR5_fops);
	if (DMA_RDTP_RPDR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR4 =
	    debugfs_create_file("DMA_RDTP_RPDR4", 744, dir, pdata,
				&DMA_RDTP_RPDR4_fops);
	if (DMA_RDTP_RPDR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR3 =
	    debugfs_create_file("DMA_RDTP_RPDR3", 744, dir, pdata,
				&DMA_RDTP_RPDR3_fops);
	if (DMA_RDTP_RPDR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR2 =
	    debugfs_create_file("DMA_RDTP_RPDR2", 744, dir, pdata,
				&DMA_RDTP_RPDR2_fops);
	if (DMA_RDTP_RPDR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR1 =
	    debugfs_create_file("DMA_RDTP_RPDR1", 744, dir, pdata,
				&DMA_RDTP_RPDR1_fops);
	if (DMA_RDTP_RPDR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDTP_RPDR0 =
	    debugfs_create_file("DMA_RDTP_RPDR0", 744, dir, pdata,
				&DMA_RDTP_RPDR0_fops);
	if (DMA_RDTP_RPDR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDTP_RPDR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR7 =
	    debugfs_create_file("DMA_TDTP_TPDR7", 744, dir, pdata,
				&DMA_TDTP_TPDR7_fops);
	if (DMA_TDTP_TPDR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR6 =
	    debugfs_create_file("DMA_TDTP_TPDR6", 744, dir, pdata,
				&DMA_TDTP_TPDR6_fops);
	if (DMA_TDTP_TPDR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR5 =
	    debugfs_create_file("DMA_TDTP_TPDR5", 744, dir, pdata,
				&DMA_TDTP_TPDR5_fops);
	if (DMA_TDTP_TPDR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR4 =
	    debugfs_create_file("DMA_TDTP_TPDR4", 744, dir, pdata,
				&DMA_TDTP_TPDR4_fops);
	if (DMA_TDTP_TPDR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR3 =
	    debugfs_create_file("DMA_TDTP_TPDR3", 744, dir, pdata,
				&DMA_TDTP_TPDR3_fops);
	if (DMA_TDTP_TPDR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR2 =
	    debugfs_create_file("DMA_TDTP_TPDR2", 744, dir, pdata,
				&DMA_TDTP_TPDR2_fops);
	if (DMA_TDTP_TPDR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR1 =
	    debugfs_create_file("DMA_TDTP_TPDR1", 744, dir, pdata,
				&DMA_TDTP_TPDR1_fops);
	if (DMA_TDTP_TPDR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDTP_TPDR0 =
	    debugfs_create_file("DMA_TDTP_TPDR0", 744, dir, pdata,
				&DMA_TDTP_TPDR0_fops);
	if (DMA_TDTP_TPDR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDTP_TPDR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR7 =
	    debugfs_create_file("DMA_RDLAR7", 744, dir, pdata,
				&DMA_RDLAR7_fops);
	if (DMA_RDLAR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR6 =
	    debugfs_create_file("DMA_RDLAR6", 744, dir, pdata,
				&DMA_RDLAR6_fops);
	if (DMA_RDLAR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR5 =
	    debugfs_create_file("DMA_RDLAR5", 744, dir, pdata,
				&DMA_RDLAR5_fops);
	if (DMA_RDLAR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR4 =
	    debugfs_create_file("DMA_RDLAR4", 744, dir, pdata,
				&DMA_RDLAR4_fops);
	if (DMA_RDLAR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR3 =
	    debugfs_create_file("DMA_RDLAR3", 744, dir, pdata,
				&DMA_RDLAR3_fops);
	if (DMA_RDLAR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR2 =
	    debugfs_create_file("DMA_RDLAR2", 744, dir, pdata,
				&DMA_RDLAR2_fops);
	if (DMA_RDLAR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR1 =
	    debugfs_create_file("DMA_RDLAR1", 744, dir, pdata,
				&DMA_RDLAR1_fops);
	if (DMA_RDLAR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RDLAR0 =
	    debugfs_create_file("DMA_RDLAR0", 744, dir, pdata,
				&DMA_RDLAR0_fops);
	if (DMA_RDLAR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RDLAR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR7 =
	    debugfs_create_file("DMA_TDLAR7", 744, dir, pdata,
				&DMA_TDLAR7_fops);
	if (DMA_TDLAR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR6 =
	    debugfs_create_file("DMA_TDLAR6", 744, dir, pdata,
				&DMA_TDLAR6_fops);
	if (DMA_TDLAR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR5 =
	    debugfs_create_file("DMA_TDLAR5", 744, dir, pdata,
				&DMA_TDLAR5_fops);
	if (DMA_TDLAR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR4 =
	    debugfs_create_file("DMA_TDLAR4", 744, dir, pdata,
				&DMA_TDLAR4_fops);
	if (DMA_TDLAR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR3 =
	    debugfs_create_file("DMA_TDLAR3", 744, dir, pdata,
				&DMA_TDLAR3_fops);
	if (DMA_TDLAR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR2 =
	    debugfs_create_file("DMA_TDLAR2", 744, dir, pdata,
				&DMA_TDLAR2_fops);
	if (DMA_TDLAR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR1 =
	    debugfs_create_file("DMA_TDLAR1", 744, dir, pdata,
				&DMA_TDLAR1_fops);
	if (DMA_TDLAR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TDLAR0 =
	    debugfs_create_file("DMA_TDLAR0", 744, dir, pdata,
				&DMA_TDLAR0_fops);
	if (DMA_TDLAR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TDLAR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER7 =
	    debugfs_create_file("DMA_IER7", 744, dir, pdata,
				&DMA_IER7_fops);
	if (DMA_IER7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER6 =
	    debugfs_create_file("DMA_IER6", 744, dir, pdata,
				&DMA_IER6_fops);
	if (DMA_IER6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER5 =
	    debugfs_create_file("DMA_IER5", 744, dir, pdata,
				&DMA_IER5_fops);
	if (DMA_IER5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER4 =
	    debugfs_create_file("DMA_IER4", 744, dir, pdata,
				&DMA_IER4_fops);
	if (DMA_IER4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER3 =
	    debugfs_create_file("DMA_IER3", 744, dir, pdata,
				&DMA_IER3_fops);
	if (DMA_IER3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER2 =
	    debugfs_create_file("DMA_IER2", 744, dir, pdata,
				&DMA_IER2_fops);
	if (DMA_IER2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER1 =
	    debugfs_create_file("DMA_IER1", 744, dir, pdata,
				&DMA_IER1_fops);
	if (DMA_IER1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_IER0 =
	    debugfs_create_file("DMA_IER0", 744, dir, pdata,
				&DMA_IER0_fops);
	if (DMA_IER0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_IER0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_IMR =
	    debugfs_create_file("MAC_IMR", 744, dir, pdata,
				&MAC_IMR_fops);
	if (MAC_IMR == NULL) {
		printk(KERN_INFO "error creating file: MAC_IMR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_ISR =
	    debugfs_create_file("MAC_ISR", 744, dir, pdata,
				&MAC_ISR_fops);
	if (MAC_ISR == NULL) {
		printk(KERN_INFO "error creating file: MAC_ISR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_ISR =
	    debugfs_create_file("MTL_ISR", 744, dir, pdata,
				&MTL_ISR_fops);
	if (MTL_ISR == NULL) {
		printk(KERN_INFO "error creating file: MTL_ISR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR7 =
	    debugfs_create_file("DMA_SR7", 744, dir, pdata,
				&DMA_SR7_fops);
	if (DMA_SR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR6 =
	    debugfs_create_file("DMA_SR6", 744, dir, pdata,
				&DMA_SR6_fops);
	if (DMA_SR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR5 =
	    debugfs_create_file("DMA_SR5", 744, dir, pdata,
				&DMA_SR5_fops);
	if (DMA_SR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR4 =
	    debugfs_create_file("DMA_SR4", 744, dir, pdata,
				&DMA_SR4_fops);
	if (DMA_SR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR3 =
	    debugfs_create_file("DMA_SR3", 744, dir, pdata,
				&DMA_SR3_fops);
	if (DMA_SR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR2 =
	    debugfs_create_file("DMA_SR2", 744, dir, pdata,
				&DMA_SR2_fops);
	if (DMA_SR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR1 =
	    debugfs_create_file("DMA_SR1", 744, dir, pdata,
				&DMA_SR1_fops);
	if (DMA_SR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SR0 =
	    debugfs_create_file("DMA_SR0", 744, dir, pdata,
				&DMA_SR0_fops);
	if (DMA_SR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_ISR =
	    debugfs_create_file("DMA_ISR", 744, dir, pdata,
				&DMA_ISR_fops);
	if (DMA_ISR == NULL) {
		printk(KERN_INFO "error creating file: DMA_ISR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_DSR2 =
	    debugfs_create_file("DMA_DSR2", 744, dir, pdata,
				&DMA_DSR2_fops);
	if (DMA_DSR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_DSR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_DSR1 =
	    debugfs_create_file("DMA_DSR1", 744, dir, pdata,
				&DMA_DSR1_fops);
	if (DMA_DSR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_DSR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_DSR0 =
	    debugfs_create_file("DMA_DSR0", 744, dir, pdata,
				&DMA_DSR0_fops);
	if (DMA_DSR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_DSR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0RDR =
	    debugfs_create_file("MTL_Q0RDR", 744, dir, pdata,
				&MTL_Q0RDR_fops);
	if (MTL_Q0RDR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0RDR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0ESR =
	    debugfs_create_file("MTL_Q0ESR", 744, dir, pdata,
				&MTL_Q0ESR_fops);
	if (MTL_Q0ESR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0ESR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0TDR =
	    debugfs_create_file("MTL_Q0TDR", 744, dir, pdata,
				&MTL_Q0TDR_fops);
	if (MTL_Q0TDR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0TDR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR7 =
	    debugfs_create_file("DMA_CHRBAR7", 744, dir, pdata,
				&DMA_CHRBAR7_fops);
	if (DMA_CHRBAR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR6 =
	    debugfs_create_file("DMA_CHRBAR6", 744, dir, pdata,
				&DMA_CHRBAR6_fops);
	if (DMA_CHRBAR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR5 =
	    debugfs_create_file("DMA_CHRBAR5", 744, dir, pdata,
				&DMA_CHRBAR5_fops);
	if (DMA_CHRBAR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR4 =
	    debugfs_create_file("DMA_CHRBAR4", 744, dir, pdata,
				&DMA_CHRBAR4_fops);
	if (DMA_CHRBAR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR3 =
	    debugfs_create_file("DMA_CHRBAR3", 744, dir, pdata,
				&DMA_CHRBAR3_fops);
	if (DMA_CHRBAR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR2 =
	    debugfs_create_file("DMA_CHRBAR2", 744, dir, pdata,
				&DMA_CHRBAR2_fops);
	if (DMA_CHRBAR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR1 =
	    debugfs_create_file("DMA_CHRBAR1", 744, dir, pdata,
				&DMA_CHRBAR1_fops);
	if (DMA_CHRBAR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRBAR0 =
	    debugfs_create_file("DMA_CHRBAR0", 744, dir, pdata,
				&DMA_CHRBAR0_fops);
	if (DMA_CHRBAR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRBAR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR7 =
	    debugfs_create_file("DMA_CHTBAR7", 744, dir, pdata,
				&DMA_CHTBAR7_fops);
	if (DMA_CHTBAR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR6 =
	    debugfs_create_file("DMA_CHTBAR6", 744, dir, pdata,
				&DMA_CHTBAR6_fops);
	if (DMA_CHTBAR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR5 =
	    debugfs_create_file("DMA_CHTBAR5", 744, dir, pdata,
				&DMA_CHTBAR5_fops);
	if (DMA_CHTBAR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR4 =
	    debugfs_create_file("DMA_CHTBAR4", 744, dir, pdata,
				&DMA_CHTBAR4_fops);
	if (DMA_CHTBAR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR3 =
	    debugfs_create_file("DMA_CHTBAR3", 744, dir, pdata,
				&DMA_CHTBAR3_fops);
	if (DMA_CHTBAR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR2 =
	    debugfs_create_file("DMA_CHTBAR2", 744, dir, pdata,
				&DMA_CHTBAR2_fops);
	if (DMA_CHTBAR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR1 =
	    debugfs_create_file("DMA_CHTBAR1", 744, dir, pdata,
				&DMA_CHTBAR1_fops);
	if (DMA_CHTBAR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTBAR0 =
	    debugfs_create_file("DMA_CHTBAR0", 744, dir, pdata,
				&DMA_CHTBAR0_fops);
	if (DMA_CHTBAR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTBAR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR7 =
	    debugfs_create_file("DMA_CHRDR7", 744, dir, pdata,
				&DMA_CHRDR7_fops);
	if (DMA_CHRDR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR6 =
	    debugfs_create_file("DMA_CHRDR6", 744, dir, pdata,
				&DMA_CHRDR6_fops);
	if (DMA_CHRDR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR5 =
	    debugfs_create_file("DMA_CHRDR5", 744, dir, pdata,
				&DMA_CHRDR5_fops);
	if (DMA_CHRDR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR4 =
	    debugfs_create_file("DMA_CHRDR4", 744, dir, pdata,
				&DMA_CHRDR4_fops);
	if (DMA_CHRDR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR3 =
	    debugfs_create_file("DMA_CHRDR3", 744, dir, pdata,
				&DMA_CHRDR3_fops);
	if (DMA_CHRDR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR2 =
	    debugfs_create_file("DMA_CHRDR2", 744, dir, pdata,
				&DMA_CHRDR2_fops);
	if (DMA_CHRDR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR1 =
	    debugfs_create_file("DMA_CHRDR1", 744, dir, pdata,
				&DMA_CHRDR1_fops);
	if (DMA_CHRDR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHRDR0 =
	    debugfs_create_file("DMA_CHRDR0", 744, dir, pdata,
				&DMA_CHRDR0_fops);
	if (DMA_CHRDR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHRDR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR7 =
	    debugfs_create_file("DMA_CHTDR7", 744, dir, pdata,
				&DMA_CHTDR7_fops);
	if (DMA_CHTDR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR6 =
	    debugfs_create_file("DMA_CHTDR6", 744, dir, pdata,
				&DMA_CHTDR6_fops);
	if (DMA_CHTDR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR5 =
	    debugfs_create_file("DMA_CHTDR5", 744, dir, pdata,
				&DMA_CHTDR5_fops);
	if (DMA_CHTDR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR4 =
	    debugfs_create_file("DMA_CHTDR4", 744, dir, pdata,
				&DMA_CHTDR4_fops);
	if (DMA_CHTDR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR3 =
	    debugfs_create_file("DMA_CHTDR3", 744, dir, pdata,
				&DMA_CHTDR3_fops);
	if (DMA_CHTDR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR2 =
	    debugfs_create_file("DMA_CHTDR2", 744, dir, pdata,
				&DMA_CHTDR2_fops);
	if (DMA_CHTDR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR1 =
	    debugfs_create_file("DMA_CHTDR1", 744, dir, pdata,
				&DMA_CHTDR1_fops);
	if (DMA_CHTDR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CHTDR0 =
	    debugfs_create_file("DMA_CHTDR0", 744, dir, pdata,
				&DMA_CHTDR0_fops);
	if (DMA_CHTDR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CHTDR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR7 =
	    debugfs_create_file("DMA_SFCSR7", 744, dir, pdata,
				&DMA_SFCSR7_fops);
	if (DMA_SFCSR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR6 =
	    debugfs_create_file("DMA_SFCSR6", 744, dir, pdata,
				&DMA_SFCSR6_fops);
	if (DMA_SFCSR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR5 =
	    debugfs_create_file("DMA_SFCSR5", 744, dir, pdata,
				&DMA_SFCSR5_fops);
	if (DMA_SFCSR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR4 =
	    debugfs_create_file("DMA_SFCSR4", 744, dir, pdata,
				&DMA_SFCSR4_fops);
	if (DMA_SFCSR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR3 =
	    debugfs_create_file("DMA_SFCSR3", 744, dir, pdata,
				&DMA_SFCSR3_fops);
	if (DMA_SFCSR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR2 =
	    debugfs_create_file("DMA_SFCSR2", 744, dir, pdata,
				&DMA_SFCSR2_fops);
	if (DMA_SFCSR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR1 =
	    debugfs_create_file("DMA_SFCSR1", 744, dir, pdata,
				&DMA_SFCSR1_fops);
	if (DMA_SFCSR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SFCSR0 =
	    debugfs_create_file("DMA_SFCSR0", 744, dir, pdata,
				&DMA_SFCSR0_fops);
	if (DMA_SFCSR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_SFCSR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_IVLANTIRR =
	    debugfs_create_file("MAC_IVLANTIRR", 744, dir, pdata,
				&MAC_IVLANTIRR_fops);
	if (MAC_IVLANTIRR == NULL) {
		printk(KERN_INFO "error creating file: MAC_IVLANTIRR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_VLANTIRR =
	    debugfs_create_file("MAC_VLANTIRR", 744, dir, pdata,
				&MAC_VLANTIRR_fops);
	if (MAC_VLANTIRR == NULL) {
		printk(KERN_INFO "error creating file: MAC_VLANTIRR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_VLANHTR =
	    debugfs_create_file("MAC_VLANHTR", 744, dir, pdata,
				&MAC_VLANHTR_fops);
	if (MAC_VLANHTR == NULL) {
		printk(KERN_INFO "error creating file: MAC_VLANHTR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_VLANTR =
	    debugfs_create_file("MAC_VLANTR", 744, dir, pdata,
				&MAC_VLANTR_fops);
	if (MAC_VLANTR == NULL) {
		printk(KERN_INFO "error creating file: MAC_VLANTR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_SBUS =
	    debugfs_create_file("DMA_SBUS", 744, dir, pdata,
				&DMA_SBUS_fops);
	if (DMA_SBUS == NULL) {
		printk(KERN_INFO "error creating file: DMA_SBUS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_BMR =
	    debugfs_create_file("DMA_BMR", 744, dir, pdata,
				&DMA_BMR_fops);
	if (DMA_BMR == NULL) {
		printk(KERN_INFO "error creating file: DMA_BMR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0RCR =
	    debugfs_create_file("MTL_Q0RCR", 744, dir, pdata,
				&MTL_Q0RCR_fops);
	if (MTL_Q0RCR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0RCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0OCR =
	    debugfs_create_file("MTL_Q0OCR", 744, dir, pdata,
				&MTL_Q0OCR_fops);
	if (MTL_Q0OCR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0OCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0ROMR =
	    debugfs_create_file("MTL_Q0ROMR", 744, dir, pdata,
				&MTL_Q0ROMR_fops);
	if (MTL_Q0ROMR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0ROMR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0QR =
	    debugfs_create_file("MTL_Q0QR", 744, dir, pdata,
				&MTL_Q0QR_fops);
	if (MTL_Q0QR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0QR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0ECR =
	    debugfs_create_file("MTL_Q0ECR", 744, dir, pdata,
				&MTL_Q0ECR_fops);
	if (MTL_Q0ECR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0ECR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0UCR =
	    debugfs_create_file("MTL_Q0UCR", 744, dir, pdata,
				&MTL_Q0UCR_fops);
	if (MTL_Q0UCR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0UCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_Q0TOMR =
	    debugfs_create_file("MTL_Q0TOMR", 744, dir, pdata,
				&MTL_Q0TOMR_fops);
	if (MTL_Q0TOMR == NULL) {
		printk(KERN_INFO "error creating file: MTL_Q0TOMR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_RQDCM1R =
	    debugfs_create_file("MTL_RQDCM1R", 744, dir, pdata,
				&MTL_RQDCM1R_fops);
	if (MTL_RQDCM1R == NULL) {
		printk(KERN_INFO "error creating file: MTL_RQDCM1R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_RQDCM0R =
	    debugfs_create_file("MTL_RQDCM0R", 744, dir, pdata,
				&MTL_RQDCM0R_fops);
	if (MTL_RQDCM0R == NULL) {
		printk(KERN_INFO "error creating file: MTL_RQDCM0R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_FDDR =
	    debugfs_create_file("MTL_FDDR", 744, dir, pdata,
				&MTL_FDDR_fops);
	if (MTL_FDDR == NULL) {
		printk(KERN_INFO "error creating file: MTL_FDDR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_FDACS =
	    debugfs_create_file("MTL_FDACS", 744, dir, pdata,
				&MTL_FDACS_fops);
	if (MTL_FDACS == NULL) {
		printk(KERN_INFO "error creating file: MTL_FDACS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MTL_OMR =
	    debugfs_create_file("MTL_OMR", 744, dir, pdata,
				&MTL_OMR_fops);
	if (MTL_OMR == NULL) {
		printk(KERN_INFO "error creating file: MTL_OMR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RQC3R =
	    debugfs_create_file("MAC_RQC3R", 744, dir, pdata,
				&MAC_RQC3R_fops);
	if (MAC_RQC3R == NULL) {
		printk(KERN_INFO "error creating file: MAC_RQC3R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RQC2R =
	    debugfs_create_file("MAC_RQC2R", 744, dir, pdata,
				&MAC_RQC2R_fops);
	if (MAC_RQC2R == NULL) {
		printk(KERN_INFO "error creating file: MAC_RQC2R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RQC1R =
	    debugfs_create_file("MAC_RQC1R", 744, dir, pdata,
				&MAC_RQC1R_fops);
	if (MAC_RQC1R == NULL) {
		printk(KERN_INFO "error creating file: MAC_RQC1R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RQC0R =
	    debugfs_create_file("MAC_RQC0R", 744, dir, pdata,
				&MAC_RQC0R_fops);
	if (MAC_RQC0R == NULL) {
		printk(KERN_INFO "error creating file: MAC_RQC0R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TQPM1R =
	    debugfs_create_file("MAC_TQPM1R", 744, dir, pdata,
				&MAC_TQPM1R_fops);
	if (MAC_TQPM1R == NULL) {
		printk(KERN_INFO "error creating file: MAC_TQPM1R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_TQPM0R =
	    debugfs_create_file("MAC_TQPM0R", 744, dir, pdata,
				&MAC_TQPM0R_fops);
	if (MAC_TQPM0R == NULL) {
		printk(KERN_INFO "error creating file: MAC_TQPM0R\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_RFCR =
	    debugfs_create_file("MAC_RFCR", 744, dir, pdata,
				&MAC_RFCR_fops);
	if (MAC_RFCR == NULL) {
		printk(KERN_INFO "error creating file: MAC_RFCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR7 =
	    debugfs_create_file("MAC_QTFCR7", 744, dir, pdata,
				&MAC_QTFCR7_fops);
	if (MAC_QTFCR7 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR6 =
	    debugfs_create_file("MAC_QTFCR6", 744, dir, pdata,
				&MAC_QTFCR6_fops);
	if (MAC_QTFCR6 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR5 =
	    debugfs_create_file("MAC_QTFCR5", 744, dir, pdata,
				&MAC_QTFCR5_fops);
	if (MAC_QTFCR5 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR4 =
	    debugfs_create_file("MAC_QTFCR4", 744, dir, pdata,
				&MAC_QTFCR4_fops);
	if (MAC_QTFCR4 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR3 =
	    debugfs_create_file("MAC_QTFCR3", 744, dir, pdata,
				&MAC_QTFCR3_fops);
	if (MAC_QTFCR3 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR2 =
	    debugfs_create_file("MAC_QTFCR2", 744, dir, pdata,
				&MAC_QTFCR2_fops);
	if (MAC_QTFCR2 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_QTFCR1 =
	    debugfs_create_file("MAC_QTFCR1", 744, dir, pdata,
				&MAC_QTFCR1_fops);
	if (MAC_QTFCR1 == NULL) {
		printk(KERN_INFO "error creating file: MAC_QTFCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_Q0TFCR =
	    debugfs_create_file("MAC_Q0TFCR", 744, dir, pdata,
				&MAC_Q0TFCR_fops);
	if (MAC_Q0TFCR == NULL) {
		printk(KERN_INFO "error creating file: MAC_Q0TFCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR7 =
	    debugfs_create_file("DMA_AXI4CR7", 744, dir, pdata,
				&DMA_AXI4CR7_fops);
	if (DMA_AXI4CR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR6 =
	    debugfs_create_file("DMA_AXI4CR6", 744, dir, pdata,
				&DMA_AXI4CR6_fops);
	if (DMA_AXI4CR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR5 =
	    debugfs_create_file("DMA_AXI4CR5", 744, dir, pdata,
				&DMA_AXI4CR5_fops);
	if (DMA_AXI4CR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR4 =
	    debugfs_create_file("DMA_AXI4CR4", 744, dir, pdata,
				&DMA_AXI4CR4_fops);
	if (DMA_AXI4CR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR3 =
	    debugfs_create_file("DMA_AXI4CR3", 744, dir, pdata,
				&DMA_AXI4CR3_fops);
	if (DMA_AXI4CR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR2 =
	    debugfs_create_file("DMA_AXI4CR2", 744, dir, pdata,
				&DMA_AXI4CR2_fops);
	if (DMA_AXI4CR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR1 =
	    debugfs_create_file("DMA_AXI4CR1", 744, dir, pdata,
				&DMA_AXI4CR1_fops);
	if (DMA_AXI4CR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_AXI4CR0 =
	    debugfs_create_file("DMA_AXI4CR0", 744, dir, pdata,
				&DMA_AXI4CR0_fops);
	if (DMA_AXI4CR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_AXI4CR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR7 =
	    debugfs_create_file("DMA_RCR7", 744, dir, pdata,
				&DMA_RCR7_fops);
	if (DMA_RCR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR6 =
	    debugfs_create_file("DMA_RCR6", 744, dir, pdata,
				&DMA_RCR6_fops);
	if (DMA_RCR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR5 =
	    debugfs_create_file("DMA_RCR5", 744, dir, pdata,
				&DMA_RCR5_fops);
	if (DMA_RCR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR4 =
	    debugfs_create_file("DMA_RCR4", 744, dir, pdata,
				&DMA_RCR4_fops);
	if (DMA_RCR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR3 =
	    debugfs_create_file("DMA_RCR3", 744, dir, pdata,
				&DMA_RCR3_fops);
	if (DMA_RCR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR2 =
	    debugfs_create_file("DMA_RCR2", 744, dir, pdata,
				&DMA_RCR2_fops);
	if (DMA_RCR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR1 =
	    debugfs_create_file("DMA_RCR1", 744, dir, pdata,
				&DMA_RCR1_fops);
	if (DMA_RCR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_RCR0 =
	    debugfs_create_file("DMA_RCR0", 744, dir, pdata,
				&DMA_RCR0_fops);
	if (DMA_RCR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_RCR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR7 =
	    debugfs_create_file("DMA_TCR7", 744, dir, pdata,
				&DMA_TCR7_fops);
	if (DMA_TCR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR6 =
	    debugfs_create_file("DMA_TCR6", 744, dir, pdata,
				&DMA_TCR6_fops);
	if (DMA_TCR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR5 =
	    debugfs_create_file("DMA_TCR5", 744, dir, pdata,
				&DMA_TCR5_fops);
	if (DMA_TCR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR4 =
	    debugfs_create_file("DMA_TCR4", 744, dir, pdata,
				&DMA_TCR4_fops);
	if (DMA_TCR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR3 =
	    debugfs_create_file("DMA_TCR3", 744, dir, pdata,
				&DMA_TCR3_fops);
	if (DMA_TCR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR2 =
	    debugfs_create_file("DMA_TCR2", 744, dir, pdata,
				&DMA_TCR2_fops);
	if (DMA_TCR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR1 =
	    debugfs_create_file("DMA_TCR1", 744, dir, pdata,
				&DMA_TCR1_fops);
	if (DMA_TCR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_TCR0 =
	    debugfs_create_file("DMA_TCR0", 744, dir, pdata,
				&DMA_TCR0_fops);
	if (DMA_TCR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_TCR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR7 =
	    debugfs_create_file("DMA_CR7", 744, dir, pdata,
				&DMA_CR7_fops);
	if (DMA_CR7 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR6 =
	    debugfs_create_file("DMA_CR6", 744, dir, pdata,
				&DMA_CR6_fops);
	if (DMA_CR6 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR5 =
	    debugfs_create_file("DMA_CR5", 744, dir, pdata,
				&DMA_CR5_fops);
	if (DMA_CR5 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR4 =
	    debugfs_create_file("DMA_CR4", 744, dir, pdata,
				&DMA_CR4_fops);
	if (DMA_CR4 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR3 =
	    debugfs_create_file("DMA_CR3", 744, dir, pdata,
				&DMA_CR3_fops);
	if (DMA_CR3 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR2 =
	    debugfs_create_file("DMA_CR2", 744, dir, pdata,
				&DMA_CR2_fops);
	if (DMA_CR2 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR1 =
	    debugfs_create_file("DMA_CR1", 744, dir, pdata,
				&DMA_CR1_fops);
	if (DMA_CR1 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DMA_CR0 =
	    debugfs_create_file("DMA_CR0", 744, dir, pdata,
				&DMA_CR0_fops);
	if (DMA_CR0 == NULL) {
		printk(KERN_INFO "error creating file: DMA_CR0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_WTR =
	    debugfs_create_file("MAC_WTR", 744, dir, pdata,
				&MAC_WTR_fops);
	if (MAC_WTR == NULL) {
		printk(KERN_INFO "error creating file: MAC_WTR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MPFR =
	    debugfs_create_file("MAC_MPFR", 744, dir, pdata,
				&MAC_MPFR_fops);
	if (MAC_MPFR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MPFR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MECR =
	    debugfs_create_file("MAC_MECR", 744, dir, pdata,
				&MAC_MECR_fops);
	if (MAC_MECR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MECR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MAC_MCR =
	    debugfs_create_file("MAC_MCR", 744, dir, pdata,
				&MAC_MCR_fops);
	if (MAC_MCR == NULL) {
		printk(KERN_INFO "error creating file: MAC_MCR\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}
	/* MII/GMII registers */
	MII_BMCR_REG =
	    debugfs_create_file("MII_BMCR_REG", 744, dir, pdata,
				&MII_BMCR_REG_fops);
	if (MII_BMCR_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_BMCR_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_BMSR_REG =
	    debugfs_create_file("MII_BMSR_REG", 744, dir, pdata,
				&MII_BMSR_REG_fops);
	if (MII_BMSR_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_BMSR_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_PHYSID1_REG =
	    debugfs_create_file("MII_PHYSID1_REG", 744, dir,
				pdata, &MII_PHYSID1_REG_fops);
	if (MII_PHYSID1_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_PHYSID1_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_PHYSID2_REG =
	    debugfs_create_file("MII_PHYSID2_REG", 744, dir,
				pdata, &MII_PHYSID2_REG_fops);
	if (MII_PHYSID2_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_PHYSID2_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_ADVERTISE_REG =
	    debugfs_create_file("MII_ADVERTISE_REG", 744, dir,
				pdata,
				&MII_ADVERTISE_REG_fops);
	if (MII_ADVERTISE_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_ADVERTISE_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_LPA_REG =
	    debugfs_create_file("MII_LPA_REG", 744, dir, pdata,
				&MII_LPA_REG_fops);
	if (MII_LPA_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_LPA_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_EXPANSION_REG =
	    debugfs_create_file("MII_EXPANSION_REG", 744, dir,
				pdata,
				&MII_EXPANSION_REG_fops);
	if (MII_EXPANSION_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_EXPANSION_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	AUTO_NEGO_NP_REG =
	    debugfs_create_file("AUTO_NEGO_NP_REG", 744, dir,
				pdata, &AUTO_NEGO_NP_REG_fops);
	if (AUTO_NEGO_NP_REG == NULL) {
		printk(KERN_INFO "error creating file: AUTO_NEGO_NP_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_ESTATUS_REG =
	    debugfs_create_file("MII_ESTATUS_REG", 744, dir,
				pdata, &MII_ESTATUS_REG_fops);
	if (MII_ESTATUS_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_ESTATUS_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_CTRL1000_REG =
	    debugfs_create_file("MII_CTRL1000_REG", 744, dir,
				pdata, &MII_CTRL1000_REG_fops);
	if (MII_CTRL1000_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_CTRL1000_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	MII_STAT1000_REG =
	    debugfs_create_file("MII_STAT1000_REG", 744, dir,
				pdata, &MII_STAT1000_REG_fops);
	if (MII_STAT1000_REG == NULL) {
		printk(KERN_INFO "error creating file: MII_STAT1000_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	PHY_CTL_REG =
	    debugfs_create_file("PHY_CTL_REG", 744, dir, pdata,
				&PHY_CTL_REG_fops);
	if (PHY_CTL_REG == NULL) {
		printk(KERN_INFO "error creating file: PHY_CTL_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	PHY_STS_REG =
	    debugfs_create_file("PHY_STS_REG", 744, dir, pdata,
				&PHY_STS_REG_fops);
	if (PHY_STS_REG == NULL) {
		printk(KERN_INFO "error creating file: PHY_STS_REG\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	feature_drop_tx_pktburstcnt =
	    debugfs_create_file("feature_drop_tx_pktburstcnt", 744, dir,
				pdata,
				&feature_drop_tx_pktburstcnt_fops);
	if (feature_drop_tx_pktburstcnt == NULL) {
		printk(KERN_INFO
		       "error creating file: feature_drop_tx_pktburstcnt\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	qInx = debugfs_create_file("qInx", 744, dir, pdata, &qInx_fops);
	if (qInx == NULL) {
		printk(KERN_INFO "error creating file: qInx\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc0 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor0", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops0);
	if (RX_NORMAL_DESC_desc0 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc1 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor1", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops1);
	if (RX_NORMAL_DESC_desc1 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc2 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor2", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops2);
	if (RX_NORMAL_DESC_desc2 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc3 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor3", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops3);
	if (RX_NORMAL_DESC_desc3 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc4 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor4", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops4);
	if (RX_NORMAL_DESC_desc4 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc5 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor5", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops5);
	if (RX_NORMAL_DESC_desc5 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc6 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor6", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops6);
	if (RX_NORMAL_DESC_desc6 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc7 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor7", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops7);
	if (RX_NORMAL_DESC_desc7 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc8 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor8", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops8);
	if (RX_NORMAL_DESC_desc8 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor8\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc9 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor9", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops9);
	if (RX_NORMAL_DESC_desc9 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor9\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc10 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor10", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops10);
	if (RX_NORMAL_DESC_desc10 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor10\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc11 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor11", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops11);
	if (RX_NORMAL_DESC_desc11 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor11\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_desc12 =
	    debugfs_create_file("RX_NORMAL_DESC_descriptor12", 744, dir, pdata,
				&RX_NORMAL_DESC_desc_fops12);
	if (RX_NORMAL_DESC_desc12 == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_descriptor12\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc0 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor0", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops0);
	if (TX_NORMAL_DESC_desc0 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor0\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc1 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor1", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops1);
	if (TX_NORMAL_DESC_desc1 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor1\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc2 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor2", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops2);
	if (TX_NORMAL_DESC_desc2 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor2\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc3 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor3", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops3);
	if (TX_NORMAL_DESC_desc3 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor3\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc4 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor4", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops4);
	if (TX_NORMAL_DESC_desc4 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor4\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc5 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor5", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops5);
	if (TX_NORMAL_DESC_desc5 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor5\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc6 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor6", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops6);
	if (TX_NORMAL_DESC_desc6 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor6\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc7 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor7", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops7);
	if (TX_NORMAL_DESC_desc7 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor7\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc8 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor8", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops8);
	if (TX_NORMAL_DESC_desc8 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor8\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc9 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor9", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops9);
	if (TX_NORMAL_DESC_desc9 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor9\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc10 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor10", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops10);
	if (TX_NORMAL_DESC_desc10 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor10\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc11 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor11", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops11);
	if (TX_NORMAL_DESC_desc11 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor11\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_desc12 =
	    debugfs_create_file("TX_NORMAL_DESC_descriptor12", 744, dir, pdata,
				&TX_NORMAL_DESC_desc_fops12);
	if (TX_NORMAL_DESC_desc12 == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_descriptor12\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	TX_NORMAL_DESC_STATUS =
	    debugfs_create_file("TX_NORMAL_DESC_STATUS", 744, dir, pdata,
				&TX_NORMAL_DESC_STATUS_fops);
	if (TX_NORMAL_DESC_STATUS == NULL) {
		printk(KERN_INFO
		       "error while creating file: TX_NORMAL_DESC_STATUS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	RX_NORMAL_DESC_STATUS =
	    debugfs_create_file("RX_NORMAL_DESC_STATUS", 744, dir, pdata,
				&RX_NORMAL_DESC_STATUS_fops);
	if (RX_NORMAL_DESC_STATUS == NULL) {
		printk(KERN_INFO
		       "error while creating file: RX_NORMAL_DESC_STATUS\n");
		ret = -ENODEV;
		goto remove_debug_file;
	}

	DBGPR("<-- create_debug_files\n");

	return ret;

 remove_debug_file:
	remove_debug_files(pdata);
	DBGPR("<-- create_debug_files\n");
	return ret;
}

/*!
* \brief  API to remove debugfs files
*
* \details This function will removes all debug files created inside
* /sys/kernel/debug/ddgen_DWC_ETH_QOS directory and also the directory
* ddgen_DWC_ETH_QOS.
*
* \retval  0 on Success.
* \retval  error number on Failure.
*/

void remove_debug_files(struct DWC_ETH_QOS_prv_data *pdata)
{
	DBGPR("--> remove_debug_files\n");
	debugfs_remove_recursive(pdata->dbg_data.dir);
	DBGPR("<-- remove_debug_files\n");
	return;
}

#endif // CONFIG_DEBUGFS_OBJ
