/* =========================================================================
 * The Synopsys DWC ETHER QOS Software Driver and documentation (hereinafter
 * "Software") is an unsupported proprietary work of Synopsys, Inc. unless
 * otherwise expressly agreed to in writing between Synopsys and you.
 *
 * The Software IS NOT an item of Licensed Software or Licensed Product under
 * any End User Software License Agreement or Agreement for Licensed Product
 * with Synopsys or any supplement thereto.  Permission is hereby granted,
 * free of charge, to any person obtaining a copy of this software annotated
 * with this license and the Software, to deal in the Software without
 * restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THIS SOFTWARE IS BEING DISTRIBUTED BY SYNOPSYS SOLELY ON AN "AS IS" BASIS
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE HEREBY DISCLAIMED. IN NO EVENT SHALL SYNOPSYS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * ========================================================================= */

#ifndef __DWC_ETH_QOS__REGACC__H__

#define __DWC_ETH_QOS__REGACC__H__


#define MAKE_MASK_32(e, s) (((e)-(s))==31?0xffffffffUL:((1UL<<((e)-(s)+1))-1))

#define MAKE_MASK_64(e, s) (((e)-(s))==63?0xffffffffffffffffULL:((1ULL<<((e)-(s)+1))-1))

#define GET_BITS(e, s, reg, data) \
  (data = ((e)-(s) > 31) ?\
    (((reg)>>(s))&MAKE_MASK_64(e,s)) :\
    (((reg)>>(s))&MAKE_MASK_32(e,s)))

#define SET_BITS(e, s, reg, val) do { \
  if((e)-(s) > 31) { \
    reg = ( (((val)<<(s))&(MAKE_MASK_64((e),(s))<<(s))) | ((reg)&(~(MAKE_MASK_64((e),(s))<<(s)))) ); \
  } \
  else { \
    reg = ( (((val)<<(s))&(MAKE_MASK_32((e),(s))<<(s))) | ((reg)&(~(MAKE_MASK_32((e),(s))<<(s)))) ); \
  } \
} while(0)

/* virtual_registers Low Bit Macro Name's */
#define RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS  0x1e
#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS  0
#define RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS  0
#define RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS  0x1e
#define TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS  0x1b
#define TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS  0x1a
#define TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS  0x17
#define TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS  0x12
#define TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES3_VT_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS  0xf
#define TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS  0
#define TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS  0
#define RX_NORMAL_DESC_RDES3_OWN_LBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS  0x1e
#define RX_NORMAL_DESC_RDES3_FD_LBIT_POS  0x1d
#define RX_NORMAL_DESC_RDES3_LD_LBIT_POS  0x1c
#define RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS  0x1b
#define RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS  0x1a
#define RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS  0x19
#define RX_NORMAL_DESC_RDES3_CE_LBIT_POS  0x18
#define RX_NORMAL_DESC_RDES3_GP_LBIT_POS  0x17
#define RX_NORMAL_DESC_RDES3_RWT_LBIT_POS  0x16
#define RX_NORMAL_DESC_RDES3_OE_LBIT_POS  0x15
#define RX_NORMAL_DESC_RDES3_RE_LBIT_POS  0x14
#define RX_NORMAL_DESC_RDES3_DE_LBIT_POS  0x13
#define RX_NORMAL_DESC_RDES3_LT_LBIT_POS  0x10
#define RX_NORMAL_DESC_RDES3_ES_LBIT_POS  0xf
#define RX_NORMAL_DESC_RDES3_FL_LBIT_POS  0
#define RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS  0
#define RX_NORMAL_DESC_RDES1_COP_LBIT_POS  0x10
#define RX_NORMAL_DESC_RDES1_TD_LBIT_POS  0xf
#define RX_NORMAL_DESC_RDES1_TSA_LBIT_POS  0xe
#define RX_NORMAL_DESC_RDES1_PV_LBIT_POS  0xd
#define RX_NORMAL_DESC_RDES1_PFT_LBIT_POS  0xc
#define RX_NORMAL_DESC_RDES1_PMT_LBIT_POS  0x8
#define RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS  0x7
#define RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS  0x6
#define RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS  0x5
#define RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS  0x4
#define RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS  0x3
#define RX_NORMAL_DESC_RDES1_PT_LBIT_POS  0
#define RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS  0
#define TX_NORMAL_DESC_TDES3_OWN_LBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES3_FD_LBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES3_LD_LBIT_POS  0x1c
#define TX_NORMAL_DESC_TDES3_CPC_LBIT_POS  0x1a
#define TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS  0x17
#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS  0x13
#define TX_NORMAL_DESC_TDES3_TSE_LBIT_POS  0x12
#define TX_NORMAL_DESC_TDES3_TSE_MODE_LBIT_POS  0xd
#define TX_NORMAL_DESC_TDES3_CIC_LBIT_POS  0x10
#define TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS  0xf
#define TX_NORMAL_DESC_TDES3_FL_LBIT_POS  0
#define TX_NORMAL_DESC_TDES2_IC_LBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES2_B2L_LBIT_POS  0x10
#define TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS  0xe
#define TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS  0
#define TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS  0
#define TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS  0
#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS  0x4
#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS  0x3
#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS  0x2
#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS  0x1
#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS  0
#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS  0x5
#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS  0x4
#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS  0x3
#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS  0x2
#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS  0x1
#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS  0
#define RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS  0x10
#define RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS  0
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS  0x1
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS  0
#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS  0
#define TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS  0
#define TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS  0
#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS  0
#define TX_PKT_FEATURES_MSS_MSS_LBIT_POS  0
#define TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS  0x10
#define TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS  0
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS  0x3
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS  0x2
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS  0

/* virtual_registers High Bit Macro Name's */
#define RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS  0x1e
#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS  0x1f
#define RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS  0x1e
#define TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS  0x1b
#define TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS  0x1a
#define TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS  0x17
#define TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS  0x13
#define TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS  0x11
#define TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS  0x10
#define TX_CONTEXT_DESC_TDES3_VT_HBIT_POS  0xf
#define TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS  0xe
#define TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS  0x1f
#define TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_OWN_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS  0x1e
#define RX_NORMAL_DESC_RDES3_FD_HBIT_POS  0x1d
#define RX_NORMAL_DESC_RDES3_LD_HBIT_POS  0x1c
#define RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS  0x1b
#define RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS  0x1a
#define RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS  0x19
#define RX_NORMAL_DESC_RDES3_CE_HBIT_POS  0x18
#define RX_NORMAL_DESC_RDES3_GP_HBIT_POS  0x17
#define RX_NORMAL_DESC_RDES3_RWT_HBIT_POS  0x16
#define RX_NORMAL_DESC_RDES3_OE_HBIT_POS  0x15
#define RX_NORMAL_DESC_RDES3_RE_HBIT_POS  0x14
#define RX_NORMAL_DESC_RDES3_DE_HBIT_POS  0x13
#define RX_NORMAL_DESC_RDES3_LT_HBIT_POS  0x12
#define RX_NORMAL_DESC_RDES3_ES_HBIT_POS  0xf
#define RX_NORMAL_DESC_RDES3_FL_HBIT_POS  0xe
#define RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES1_COP_HBIT_POS  0x1f
#define RX_NORMAL_DESC_RDES1_TD_HBIT_POS  0xf
#define RX_NORMAL_DESC_RDES1_TSA_HBIT_POS  0xe
#define RX_NORMAL_DESC_RDES1_PV_HBIT_POS  0xd
#define RX_NORMAL_DESC_RDES1_PFT_HBIT_POS  0xc
#define RX_NORMAL_DESC_RDES1_PMT_HBIT_POS  0xb
#define RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS  0x7
#define RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS  0x6
#define RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS  0x5
#define RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS  0x4
#define RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS  0x3
#define RX_NORMAL_DESC_RDES1_PT_HBIT_POS  0x2
#define RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_OWN_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES3_FD_HBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES3_LD_HBIT_POS  0x1c
#define TX_NORMAL_DESC_TDES3_CPC_HBIT_POS  0x1b
#define TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS  0x19
#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS  0x16
#define TX_NORMAL_DESC_TDES3_TSE_HBIT_POS  0x12
#define TX_NORMAL_DESC_TDES3_TSE_MODE_HBIT_POS  0xe
#define TX_NORMAL_DESC_TDES3_CIC_HBIT_POS  0x11
#define TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS  0xf
#define TX_NORMAL_DESC_TDES3_FL_HBIT_POS  0xe
#define TX_NORMAL_DESC_TDES2_IC_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS  0x1e
#define TX_NORMAL_DESC_TDES2_B2L_HBIT_POS  0x1d
#define TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS  0xf
#define TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS  0xd
#define TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS  0x1f
#define TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS  0x1f
#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS  0x4
#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS  0x3
#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS  0x2
#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS  0x1
#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS  0
#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS  0x5
#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS  0x4
#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS  0x3
#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS  0x2
#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS  0x1
#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS  0
#define RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS  0x1f
#define RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS  0xf
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS  0x1
#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS  0
#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS  0x1f
#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS  0
#define TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS  0xf
#define TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS  0x7
#define TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS  0x7
#define TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS  0xf
#define TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS  0x7
#define TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS  0x7
#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS  0x3f
#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS  0x3f
#define TX_PKT_FEATURES_MSS_MSS_HBIT_POS  0x3f
#define TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS  0x1f
#define TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS  0xf
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS  0x3
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS  0x2
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS  0x1
#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS  0

/* virtual_registers Register-Field Read-Write Macros */
#define RX_CONTEXT_DESC_RDES3_OWN_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS, RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while(0)

#define RX_CONTEXT_DESC_RDES3_OWN_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES3_OWN_HBIT_POS, RX_CONTEXT_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while(0)


#define RX_CONTEXT_DESC_RDES3_CTXT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS, RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)

#define RX_CONTEXT_DESC_RDES3_CTXT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES3_CTXT_HBIT_POS, RX_CONTEXT_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)


#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS, RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS, ptr, data); \
} while(0)

#define RX_CONTEXT_DESC_RDES2_RESERVED_BITS_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES2_RESERVED_BITS_HBIT_POS, RX_CONTEXT_DESC_RDES2_RESERVED_BITS_LBIT_POS, ptr, data); \
} while(0)


#define RX_CONTEXT_DESC_RDES1_RTSH_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS, RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS, ptr, data); \
} while(0)

#define RX_CONTEXT_DESC_RDES1_RTSH_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES1_RTSH_HBIT_POS, RX_CONTEXT_DESC_RDES1_RTSH_LBIT_POS, ptr, data); \
} while(0)


#define RX_CONTEXT_DESC_RDES0_RTSL_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS, RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS, ptr, data); \
} while(0)

#define RX_CONTEXT_DESC_RDES0_RTSL_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_CONTEXT_DESC_RDES0_RTSL_HBIT_POS, RX_CONTEXT_DESC_RDES0_RTSL_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_OWN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS, TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_OWN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_OWN_HBIT_POS, TX_CONTEXT_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_CTXT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS, TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_CTXT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_CTXT_HBIT_POS, TX_CONTEXT_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_OSTC_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS, TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_OSTC_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_OSTC_HBIT_POS, TX_CONTEXT_DESC_TDES3_OSTC_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_TCMSSV_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS, TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_TCMSSV_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_TCMSSV_HBIT_POS, TX_CONTEXT_DESC_TDES3_TCMSSV_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_CDX_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS, TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_CDX_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_CDX_HBIT_POS, TX_CONTEXT_DESC_TDES3_CDX_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_IVTIR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_IVTIR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_IVTIR_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVTIR_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_SVLTV_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_SVLTV_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_SVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_SVLTV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_IVLTV_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_IVLTV_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_IVLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_IVLTV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_VLTV_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_VLTV_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_VLTV_HBIT_POS, TX_CONTEXT_DESC_TDES3_VLTV_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES3_VT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES3_VT_HBIT_POS, TX_CONTEXT_DESC_TDES3_VT_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES3_VT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES3_VT_HBIT_POS, TX_CONTEXT_DESC_TDES3_VT_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES2_IVT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES2_IVT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_IVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_IVT_LBIT_POS, ptr, data); \
} while(0)



#define TX_CONTEXT_DESC_TDES2_SVT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES2_SVT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_SVT_HBIT_POS, TX_CONTEXT_DESC_TDES2_SVT_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES2_MSS_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS, TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES2_MSS_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES2_MSS_HBIT_POS, TX_CONTEXT_DESC_TDES2_MSS_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES1_NDAP_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS, TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES1_NDAP_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES1_NDAP_HBIT_POS, TX_CONTEXT_DESC_TDES1_NDAP_LBIT_POS, ptr, data); \
} while(0)


#define TX_CONTEXT_DESC_TDES0_TTSL_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS, TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS, ptr, data); \
} while(0)

#define TX_CONTEXT_DESC_TDES0_TTSL_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_CONTEXT_DESC_TDES0_TTSL_HBIT_POS, TX_CONTEXT_DESC_TDES0_TTSL_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_OWN_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_OWN_HBIT_POS, RX_NORMAL_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_OWN_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_OWN_HBIT_POS, RX_NORMAL_DESC_RDES3_OWN_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_CTXT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS, RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_CTXT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_CTXT_HBIT_POS, RX_NORMAL_DESC_RDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_FD_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_FD_HBIT_POS, RX_NORMAL_DESC_RDES3_FD_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_FD_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_FD_HBIT_POS, RX_NORMAL_DESC_RDES3_FD_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_LD_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_LD_HBIT_POS, RX_NORMAL_DESC_RDES3_LD_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_LD_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_LD_HBIT_POS, RX_NORMAL_DESC_RDES3_LD_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_RS2V_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_RS2V_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS2V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS2V_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_RS1V_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_RS1V_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS1V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS1V_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_RS0V_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_RS0V_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RS0V_HBIT_POS, RX_NORMAL_DESC_RDES3_RS0V_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_CE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_CE_HBIT_POS, RX_NORMAL_DESC_RDES3_CE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_CE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_CE_HBIT_POS, RX_NORMAL_DESC_RDES3_CE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_GP_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_GP_HBIT_POS, RX_NORMAL_DESC_RDES3_GP_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_GP_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_GP_HBIT_POS, RX_NORMAL_DESC_RDES3_GP_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_RWT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RWT_HBIT_POS, RX_NORMAL_DESC_RDES3_RWT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_RWT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RWT_HBIT_POS, RX_NORMAL_DESC_RDES3_RWT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_OE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_OE_HBIT_POS, RX_NORMAL_DESC_RDES3_OE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_OE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_OE_HBIT_POS, RX_NORMAL_DESC_RDES3_OE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_RE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_RE_HBIT_POS, RX_NORMAL_DESC_RDES3_RE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_RE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_RE_HBIT_POS, RX_NORMAL_DESC_RDES3_RE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_DE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_DE_HBIT_POS, RX_NORMAL_DESC_RDES3_DE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_DE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_DE_HBIT_POS, RX_NORMAL_DESC_RDES3_DE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_LT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_LT_HBIT_POS, RX_NORMAL_DESC_RDES3_LT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_LT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_LT_HBIT_POS, RX_NORMAL_DESC_RDES3_LT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_ES_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_ES_HBIT_POS, RX_NORMAL_DESC_RDES3_ES_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_ES_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_ES_HBIT_POS, RX_NORMAL_DESC_RDES3_ES_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES3_FL_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES3_FL_HBIT_POS, RX_NORMAL_DESC_RDES3_FL_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES3_FL_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES3_FL_HBIT_POS, RX_NORMAL_DESC_RDES3_FL_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES2_B2AP_NDA_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS, RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES2_B2AP_NDA_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES2_B2AP_NDA_HBIT_POS, RX_NORMAL_DESC_RDES2_B2AP_NDA_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_COP_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_COP_HBIT_POS, RX_NORMAL_DESC_RDES1_COP_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_COP_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_COP_HBIT_POS, RX_NORMAL_DESC_RDES1_COP_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_TD_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_TD_HBIT_POS, RX_NORMAL_DESC_RDES1_TD_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_TD_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_TD_HBIT_POS, RX_NORMAL_DESC_RDES1_TD_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_TSA_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_TSA_HBIT_POS, RX_NORMAL_DESC_RDES1_TSA_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_TSA_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_TSA_HBIT_POS, RX_NORMAL_DESC_RDES1_TSA_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_PV_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PV_HBIT_POS, RX_NORMAL_DESC_RDES1_PV_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_PV_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PV_HBIT_POS, RX_NORMAL_DESC_RDES1_PV_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_PFT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PFT_HBIT_POS, RX_NORMAL_DESC_RDES1_PFT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_PFT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PFT_HBIT_POS, RX_NORMAL_DESC_RDES1_PFT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_PMT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PMT_HBIT_POS, RX_NORMAL_DESC_RDES1_PMT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_PMT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PMT_HBIT_POS, RX_NORMAL_DESC_RDES1_PMT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_IPPE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_IPPE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPPE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPPE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_IPCB_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS, RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_IPCB_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPCB_HBIT_POS, RX_NORMAL_DESC_RDES1_IPCB_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_IPV6_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_IPV6_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPV6_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV6_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_IPV4_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_IPV4_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPV4_HBIT_POS, RX_NORMAL_DESC_RDES1_IPV4_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_IPHE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_IPHE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_IPHE_HBIT_POS, RX_NORMAL_DESC_RDES1_IPHE_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES1_PT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES1_PT_HBIT_POS, RX_NORMAL_DESC_RDES1_PT_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES1_PT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES1_PT_HBIT_POS, RX_NORMAL_DESC_RDES1_PT_LBIT_POS, ptr, data); \
} while(0)


#define RX_NORMAL_DESC_RDES0_HDR_B1AP_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS, RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS, ptr, data); \
} while(0)

#define RX_NORMAL_DESC_RDES0_HDR_B1AP_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_NORMAL_DESC_RDES0_HDR_B1AP_HBIT_POS, RX_NORMAL_DESC_RDES0_HDR_B1AP_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_OWN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_OWN_HBIT_POS, TX_NORMAL_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_OWN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_OWN_HBIT_POS, TX_NORMAL_DESC_TDES3_OWN_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_CTXT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS, TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_CTXT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CTXT_HBIT_POS, TX_NORMAL_DESC_TDES3_CTXT_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_FD_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_FD_HBIT_POS, TX_NORMAL_DESC_TDES3_FD_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_FD_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_FD_HBIT_POS, TX_NORMAL_DESC_TDES3_FD_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_LD_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_LD_HBIT_POS, TX_NORMAL_DESC_TDES3_LD_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_LD_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_LD_HBIT_POS, TX_NORMAL_DESC_TDES3_LD_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_CPC_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CPC_HBIT_POS, TX_NORMAL_DESC_TDES3_CPC_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_CPC_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CPC_HBIT_POS, TX_NORMAL_DESC_TDES3_CPC_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_SAIC_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS, TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_SAIC_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_SAIC_HBIT_POS, TX_NORMAL_DESC_TDES3_SAIC_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS, TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_HBIT_POS, TX_NORMAL_DESC_TDES3_SLOTNUM_TCPHDRLEN_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_TSE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_TSE_HBIT_POS, TX_NORMAL_DESC_TDES3_TSE_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_TSE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_TSE_HBIT_POS, TX_NORMAL_DESC_TDES3_TSE_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_CIC_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_CIC_HBIT_POS, TX_NORMAL_DESC_TDES3_CIC_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_CIC_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_CIC_HBIT_POS, TX_NORMAL_DESC_TDES3_CIC_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_TIPLH_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS, TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_TIPLH_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_TIPLH_HBIT_POS, TX_NORMAL_DESC_TDES3_TIPLH_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES3_FL_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES3_FL_HBIT_POS, TX_NORMAL_DESC_TDES3_FL_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES3_FL_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES3_FL_HBIT_POS, TX_NORMAL_DESC_TDES3_FL_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES2_IC_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_IC_HBIT_POS, TX_NORMAL_DESC_TDES2_IC_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES2_IC_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_IC_HBIT_POS, TX_NORMAL_DESC_TDES2_IC_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES2_TTSE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS, TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES2_TTSE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_TTSE_HBIT_POS, TX_NORMAL_DESC_TDES2_TTSE_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES2_B2L_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_B2L_HBIT_POS, TX_NORMAL_DESC_TDES2_B2L_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES2_B2L_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_B2L_HBIT_POS, TX_NORMAL_DESC_TDES2_B2L_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES2_VTIR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS, TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES2_VTIR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_VTIR_HBIT_POS, TX_NORMAL_DESC_TDES2_VTIR_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES2_HL_B1L_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS, TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES2_HL_B1L_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES2_HL_B1L_HBIT_POS, TX_NORMAL_DESC_TDES2_HL_B1L_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES1_B2A_NDA_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS, TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES1_B2A_NDA_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES1_B2A_NDA_HBIT_POS, TX_NORMAL_DESC_TDES1_B2A_NDA_LBIT_POS, ptr, data); \
} while(0)


#define TX_NORMAL_DESC_TDES0_B1A_HAP_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS, TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS, ptr, data); \
} while(0)

#define TX_NORMAL_DESC_TDES0_B1A_HAP_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_NORMAL_DESC_TDES0_B1A_HAP_HBIT_POS, TX_NORMAL_DESC_TDES0_B1A_HAP_LBIT_POS, ptr, data); \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_HEARTBEAT_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_WINDOW_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_CARRIER_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_HBIT_POS, TX_ERROR_COUNTERS_TX_ERRORS_ABORTED_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_MISSED_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FIFO_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_FRAME_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_CRC_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_OVERRUN_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS, ptr, data); \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_HBIT_POS, RX_ERROR_COUNTERS_RX_ERRORS_LENGTH_ERROR_LBIT_POS, ptr, data); \
} while(0)


#define RX_PKT_FEATURES_VLAN_TAG_SVT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while(0)

#define RX_PKT_FEATURES_VLAN_TAG_SVT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while(0)


#define RX_PKT_FEATURES_VLAN_TAG_VT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while(0)

#define RX_PKT_FEATURES_VLAN_TAG_VT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, RX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while(0)


#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while(0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while(0)


#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_Mlf_Rd(ptr, data) do { \
  GET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS, ptr, data); \
} while(0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_Mlf_Wr(ptr, data) do { \
  SET_BITS(RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_HBIT_POS, RX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_DONE_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_TCP_HDR_LEN_LEN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS, TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TCP_HDR_LEN_LEN_HBIT_POS, TX_PKT_FEATURES_TCP_HDR_LEN_LEN_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_TCP_PKT_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_TYPE_IP_PKT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_TYPE_IP_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_TYPE_IP_PKT_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_TUCSE_TCPCSE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS, TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_TUCSE_TCPCSE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSE_TCPCSE_HBIT_POS, TX_PKT_FEATURES_TUCSE_TCPCSE_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_TUCSO_TCPCSO_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS, TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_TUCSO_TCPCSO_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSO_TCPCSO_HBIT_POS, TX_PKT_FEATURES_TUCSO_TCPCSO_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_TUCSS_TCPCSS_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS, TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_TUCSS_TCPCSS_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_TUCSS_TCPCSS_HBIT_POS, TX_PKT_FEATURES_TUCSS_TCPCSS_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_IPCSE_IPCSE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS, TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_IPCSE_IPCSE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSE_IPCSE_HBIT_POS, TX_PKT_FEATURES_IPCSE_IPCSE_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_IPCSO_IPCSO_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS, TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_IPCSO_IPCSO_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSO_IPCSO_HBIT_POS, TX_PKT_FEATURES_IPCSO_IPCSO_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_IPCSS_IPCSS_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS, TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_IPCSS_IPCSS_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_IPCSS_IPCSS_HBIT_POS, TX_PKT_FEATURES_IPCSS_IPCSS_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS, TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PAY_LEN_PAY_LEN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PAY_LEN_PAY_LEN_HBIT_POS, TX_PKT_FEATURES_PAY_LEN_PAY_LEN_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS, TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_HDR_LEN_HDR_LEN_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_HDR_LEN_HDR_LEN_HBIT_POS, TX_PKT_FEATURES_HDR_LEN_HDR_LEN_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_MSS_MSS_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_MSS_MSS_HBIT_POS, TX_PKT_FEATURES_MSS_MSS_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_MSS_MSS_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_MSS_MSS_HBIT_POS, TX_PKT_FEATURES_MSS_MSS_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_VLAN_TAG_SVT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_VLAN_TAG_SVT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_VLAN_TAG_SVT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_SVT_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_VLAN_TAG_VT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_VLAN_TAG_VT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_VLAN_TAG_VT_HBIT_POS, TX_PKT_FEATURES_VLAN_TAG_VT_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_VLAN_PKT_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_PTP_ENABLE_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_TSO_ENABLE_LBIT_POS, ptr, data); \
} while(0)


#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_Mlf_Rd(ptr, data) do { \
  GET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS, ptr, data); \
} while(0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_Mlf_Wr(ptr, data) do { \
  SET_BITS(TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_HBIT_POS, TX_PKT_FEATURES_PKT_ATTRIBUTES_CSUM_ENABLE_LBIT_POS, ptr, data); \
} while(0)



/* virtual_registers Register Read-Write Macros */
#define RX_CONTEXT_DESC_RDES3_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_CONTEXT_DESC_RDES3_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_CONTEXT_DESC_RDES2_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_CONTEXT_DESC_RDES2_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_CONTEXT_DESC_RDES1_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_CONTEXT_DESC_RDES1_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_CONTEXT_DESC_RDES0_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_CONTEXT_DESC_RDES0_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_CONTEXT_DESC_TDES3_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_CONTEXT_DESC_TDES3_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_CONTEXT_DESC_TDES2_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_CONTEXT_DESC_TDES2_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_CONTEXT_DESC_TDES1_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_CONTEXT_DESC_TDES1_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_CONTEXT_DESC_TDES0_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_CONTEXT_DESC_TDES0_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_RDES3_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_RDES3_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_RDES2_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_RDES2_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_RDES1_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_RDES1_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_RDES0_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_RDES0_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_TX_ERRORS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_TX_ERRORS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_RX_BUF_PTR_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_RX_BUF_PTR_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_NEXT_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_NEXT_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_NORMAL_DESC_SKB_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_NORMAL_DESC_SKB_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_TDES3_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_TDES3_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_TDES2_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_TDES2_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_TDES1_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_TDES1_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_TDES0_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_TDES0_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_TX_BUF_PTR_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_TX_BUF_PTR_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_NORMAL_DESC_NEXT_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_NORMAL_DESC_NEXT_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_ERROR_COUNTERS_TX_ERRORS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_ERROR_COUNTERS_TX_ERRORS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_ERROR_COUNTERS_RX_ERRORS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_ERROR_COUNTERS_RX_ERRORS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_PKT_FEATURES_VLAN_TAG_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_PKT_FEATURES_VLAN_TAG_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define RX_PKT_FEATURES_PKT_ATTRIBUTES_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define RX_PKT_FEATURES_PKT_ATTRIBUTES_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_TCP_HDR_LEN_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_TCP_HDR_LEN_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_PKT_TYPE_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_PKT_TYPE_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_TUCSE_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_TUCSE_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_TUCSO_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_TUCSO_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_TUCSS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_TUCSS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_IPCSE_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_IPCSE_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_IPCSO_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_IPCSO_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_IPCSS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_IPCSS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_PAY_LEN_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_PAY_LEN_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_HDR_LEN_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_HDR_LEN_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_MSS_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_MSS_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_VLAN_TAG_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_VLAN_TAG_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)


#define TX_PKT_FEATURES_PKT_ATTRIBUTES_Ml_Rd(ptr, data) do { \
	data = ptr; \
} while(0)

#define TX_PKT_FEATURES_PKT_ATTRIBUTES_Ml_Wr(ptr, data) do { \
	ptr = data; \
} while(0)



#define  BASE_ADDRESS   0
#ifdef DWC_ETH_QOS_VER_4_0
#define MAC_ARPA_RgOffAddr ((BASE_ADDRESS + 0x0ae0))
#else
#define MAC_ARPA_RgOffAddr ((BASE_ADDRESS + 0x0210))
#endif

#define MAC_ARPA_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_ARPA_RgOffAddr));\
} while(0)

#define MAC_ARPA_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ARPA_RgOffAddr));\
} while(0)

#define MAC_ARPA_ARPPA_UdfWr(pdata, data) do {\
		MAC_ARPA_RgWr(pdata, data);\
} while(0)

#define MAC_ARPA_ARPPA_UdfRd(pdata, data) do {\
		MAC_ARPA_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R7_RgOffAddr ((BASE_ADDRESS + 0xa6c))

#define MAC_L3A3R7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R7_RgOffAddr));\
} while(0)

#define MAC_L3A3R7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R7_RgOffAddr));\
} while(0)

#define MAC_L3A3R7_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R7_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R7_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R7_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R6_RgOffAddr ((BASE_ADDRESS + 0xa3c))

#define MAC_L3A3R6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R6_RgOffAddr));\
} while(0)

#define MAC_L3A3R6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R6_RgOffAddr));\
} while(0)

#define MAC_L3A3R6_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R6_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R6_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R6_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R5_RgOffAddr ((BASE_ADDRESS + 0xa0c))

#define MAC_L3A3R5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R5_RgOffAddr));\
} while(0)

#define MAC_L3A3R5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R5_RgOffAddr));\
} while(0)

#define MAC_L3A3R5_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R5_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R5_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R5_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R4_RgOffAddr ((BASE_ADDRESS + 0x9dc))

#define MAC_L3A3R4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R4_RgOffAddr));\
} while(0)

#define MAC_L3A3R4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R4_RgOffAddr));\
} while(0)

#define MAC_L3A3R4_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R4_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R4_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R4_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R3_RgOffAddr ((BASE_ADDRESS + 0x9ac))

#define MAC_L3A3R3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R3_RgOffAddr));\
} while(0)

#define MAC_L3A3R3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R3_RgOffAddr));\
} while(0)

#define MAC_L3A3R3_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R3_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R3_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R3_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R2_RgOffAddr ((BASE_ADDRESS + 0x97c))

#define MAC_L3A3R2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R2_RgOffAddr));\
} while(0)

#define MAC_L3A3R2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R2_RgOffAddr));\
} while(0)

#define MAC_L3A3R2_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R2_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R2_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R2_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R1_RgOffAddr ((BASE_ADDRESS + 0x94c))

#define MAC_L3A3R1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R1_RgOffAddr));\
} while(0)

#define MAC_L3A3R1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R1_RgOffAddr));\
} while(0)

#define MAC_L3A3R1_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R1_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R1_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R1_RgRd(pdata, data);\
} while(0)


#define MAC_L3A3R0_RgOffAddr ((BASE_ADDRESS + 0x91c))

#define MAC_L3A3R0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A3R0_RgOffAddr));\
} while(0)

#define MAC_L3A3R0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A3R0_RgOffAddr));\
} while(0)

#define MAC_L3A3R0_L3A30_UdfWr(pdata, data) do {\
		MAC_L3A3R0_RgWr(pdata, data);\
} while(0)

#define MAC_L3A3R0_L3A30_UdfRd(pdata, data) do {\
		MAC_L3A3R0_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R7_RgOffAddr ((BASE_ADDRESS + 0xa68))

#define MAC_L3A2R7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R7_RgOffAddr));\
} while(0)

#define MAC_L3A2R7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R7_RgOffAddr));\
} while(0)

#define MAC_L3A2R7_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R7_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R7_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R7_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R6_RgOffAddr ((BASE_ADDRESS + 0xa38))

#define MAC_L3A2R6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R6_RgOffAddr));\
} while(0)

#define MAC_L3A2R6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R6_RgOffAddr));\
} while(0)

#define MAC_L3A2R6_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R6_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R6_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R6_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R5_RgOffAddr ((BASE_ADDRESS + 0xa08))

#define MAC_L3A2R5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R5_RgOffAddr));\
} while(0)

#define MAC_L3A2R5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R5_RgOffAddr));\
} while(0)

#define MAC_L3A2R5_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R5_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R5_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R5_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R4_RgOffAddr ((BASE_ADDRESS + 0x9d8))

#define MAC_L3A2R4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R4_RgOffAddr));\
} while(0)

#define MAC_L3A2R4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R4_RgOffAddr));\
} while(0)

#define MAC_L3A2R4_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R4_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R4_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R4_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R3_RgOffAddr ((BASE_ADDRESS + 0x9a8))

#define MAC_L3A2R3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R3_RgOffAddr));\
} while(0)

#define MAC_L3A2R3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R3_RgOffAddr));\
} while(0)

#define MAC_L3A2R3_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R3_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R3_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R3_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R2_RgOffAddr ((BASE_ADDRESS + 0x978))

#define MAC_L3A2R2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R2_RgOffAddr));\
} while(0)

#define MAC_L3A2R2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R2_RgOffAddr));\
} while(0)

#define MAC_L3A2R2_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R2_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R2_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R2_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R1_RgOffAddr ((BASE_ADDRESS + 0x948))

#define MAC_L3A2R1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R1_RgOffAddr));\
} while(0)

#define MAC_L3A2R1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R1_RgOffAddr));\
} while(0)

#define MAC_L3A2R1_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R1_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R1_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R1_RgRd(pdata, data);\
} while(0)


#define MAC_L3A2R0_RgOffAddr ((BASE_ADDRESS + 0x918))

#define MAC_L3A2R0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A2R0_RgOffAddr));\
} while(0)

#define MAC_L3A2R0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A2R0_RgOffAddr));\
} while(0)

#define MAC_L3A2R0_L3A20_UdfWr(pdata, data) do {\
		MAC_L3A2R0_RgWr(pdata, data);\
} while(0)

#define MAC_L3A2R0_L3A20_UdfRd(pdata, data) do {\
		MAC_L3A2R0_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R7_RgOffAddr ((BASE_ADDRESS + 0xa64))

#define MAC_L3A1R7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R7_RgOffAddr));\
} while(0)

#define MAC_L3A1R7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R7_RgOffAddr));\
} while(0)

#define MAC_L3A1R7_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R7_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R7_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R7_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R6_RgOffAddr ((BASE_ADDRESS + 0xa34))

#define MAC_L3A1R6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R6_RgOffAddr));\
} while(0)

#define MAC_L3A1R6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R6_RgOffAddr));\
} while(0)

#define MAC_L3A1R6_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R6_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R6_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R6_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R5_RgOffAddr ((BASE_ADDRESS + 0xa04))

#define MAC_L3A1R5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R5_RgOffAddr));\
} while(0)

#define MAC_L3A1R5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R5_RgOffAddr));\
} while(0)

#define MAC_L3A1R5_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R5_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R5_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R5_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R4_RgOffAddr ((BASE_ADDRESS + 0x9d4))

#define MAC_L3A1R4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R4_RgOffAddr));\
} while(0)

#define MAC_L3A1R4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R4_RgOffAddr));\
} while(0)

#define MAC_L3A1R4_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R4_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R4_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R4_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R3_RgOffAddr ((BASE_ADDRESS + 0x9a4))

#define MAC_L3A1R3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R3_RgOffAddr));\
} while(0)

#define MAC_L3A1R3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R3_RgOffAddr));\
} while(0)

#define MAC_L3A1R3_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R3_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R3_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R3_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R2_RgOffAddr ((BASE_ADDRESS + 0x974))

#define MAC_L3A1R2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R2_RgOffAddr));\
} while(0)

#define MAC_L3A1R2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R2_RgOffAddr));\
} while(0)

#define MAC_L3A1R2_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R2_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R2_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R2_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R1_RgOffAddr ((BASE_ADDRESS + 0x944))

#define MAC_L3A1R1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R1_RgOffAddr));\
} while(0)

#define MAC_L3A1R1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R1_RgOffAddr));\
} while(0)

#define MAC_L3A1R1_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R1_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R1_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R1_RgRd(pdata, data);\
} while(0)


#define MAC_L3A1R0_RgOffAddr ((BASE_ADDRESS + 0x914))

#define MAC_L3A1R0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A1R0_RgOffAddr));\
} while(0)

#define MAC_L3A1R0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A1R0_RgOffAddr));\
} while(0)

#define MAC_L3A1R0_L3A10_UdfWr(pdata, data) do {\
		MAC_L3A1R0_RgWr(pdata, data);\
} while(0)

#define MAC_L3A1R0_L3A10_UdfRd(pdata, data) do {\
		MAC_L3A1R0_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R7_RgOffAddr ((BASE_ADDRESS + 0xa60))

#define MAC_L3A0R7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R7_RgOffAddr));\
} while(0)

#define MAC_L3A0R7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R7_RgOffAddr));\
} while(0)

#define MAC_L3A0R7_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R7_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R7_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R7_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R6_RgOffAddr ((BASE_ADDRESS + 0xa30))

#define MAC_L3A0R6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R6_RgOffAddr));\
} while(0)

#define MAC_L3A0R6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R6_RgOffAddr));\
} while(0)

#define MAC_L3A0R6_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R6_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R6_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R6_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R5_RgOffAddr ((BASE_ADDRESS + 0xa00))

#define MAC_L3A0R5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R5_RgOffAddr));\
} while(0)

#define MAC_L3A0R5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R5_RgOffAddr));\
} while(0)

#define MAC_L3A0R5_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R5_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R5_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R5_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R4_RgOffAddr ((BASE_ADDRESS + 0x9d0))

#define MAC_L3A0R4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R4_RgOffAddr));\
} while(0)

#define MAC_L3A0R4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R4_RgOffAddr));\
} while(0)

#define MAC_L3A0R4_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R4_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R4_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R4_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R3_RgOffAddr ((BASE_ADDRESS + 0x9a0))

#define MAC_L3A0R3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R3_RgOffAddr));\
} while(0)

#define MAC_L3A0R3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R3_RgOffAddr));\
} while(0)

#define MAC_L3A0R3_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R3_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R3_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R3_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R2_RgOffAddr ((BASE_ADDRESS + 0x970))

#define MAC_L3A0R2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R2_RgOffAddr));\
} while(0)

#define MAC_L3A0R2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R2_RgOffAddr));\
} while(0)

#define MAC_L3A0R2_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R2_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R2_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R2_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R1_RgOffAddr ((BASE_ADDRESS + 0x940))

#define MAC_L3A0R1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R1_RgOffAddr));\
} while(0)

#define MAC_L3A0R1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R1_RgOffAddr));\
} while(0)

#define MAC_L3A0R1_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R1_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R1_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R1_RgRd(pdata, data);\
} while(0)


#define MAC_L3A0R0_RgOffAddr ((BASE_ADDRESS + 0x910))

#define MAC_L3A0R0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3A0R0_RgOffAddr));\
} while(0)

#define MAC_L3A0R0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3A0R0_RgOffAddr));\
} while(0)

#define MAC_L3A0R0_L3A00_UdfWr(pdata, data) do {\
		MAC_L3A0R0_RgWr(pdata, data);\
} while(0)

#define MAC_L3A0R0_L3A00_UdfRd(pdata, data) do {\
		MAC_L3A0R0_RgRd(pdata, data);\
} while(0)


#define MAC_L4AR7_RgOffAddr ((BASE_ADDRESS + 0xa54))

#define MAC_L4AR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR7_RgOffAddr));\
} while(0)

#define MAC_L4AR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR7_RgOffAddr));\
} while(0)

/*#define MAC_L4AR7_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR7_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR7_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR7_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR7_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR7_RgRd(pdata, v);\
		v = ((v & MAC_L4AR7_L4SP0_Wr_Mask) | ((data & MAC_L4AR7_L4SP0_Mask)<<0));\
		MAC_L4AR7_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR7_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR7_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR7_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR7_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR7_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR7_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR7_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR7_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR7_RgRd(pdata, v);\
		v = ((v & MAC_L4AR7_L4DP0_Wr_Mask) | ((data & MAC_L4AR7_L4DP0_Mask)<<16));\
		MAC_L4AR7_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR7_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR7_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR7_L4DP0_Mask);\
} while(0)


#define MAC_L4AR6_RgOffAddr ((BASE_ADDRESS + 0xa24))

#define MAC_L4AR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR6_RgOffAddr));\
} while(0)

#define MAC_L4AR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR6_RgOffAddr));\
} while(0)

/*#define MAC_L4AR6_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR6_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR6_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR6_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR6_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR6_RgRd(pdata, v);\
		v = ((v & MAC_L4AR6_L4SP0_Wr_Mask) | ((data & MAC_L4AR6_L4SP0_Mask)<<0));\
		MAC_L4AR6_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR6_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR6_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR6_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR6_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR6_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR6_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR6_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR6_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR6_RgRd(pdata, v);\
		v = ((v & MAC_L4AR6_L4DP0_Wr_Mask) | ((data & MAC_L4AR6_L4DP0_Mask)<<16));\
		MAC_L4AR6_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR6_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR6_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR6_L4DP0_Mask);\
} while(0)


#define MAC_L4AR5_RgOffAddr ((BASE_ADDRESS + 0x9f4))

#define MAC_L4AR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR5_RgOffAddr));\
} while(0)

#define MAC_L4AR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR5_RgOffAddr));\
} while(0)

/*#define MAC_L4AR5_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR5_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR5_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR5_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR5_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR5_RgRd(pdata, v);\
		v = ((v & MAC_L4AR5_L4SP0_Wr_Mask) | ((data & MAC_L4AR5_L4SP0_Mask)<<0));\
		MAC_L4AR5_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR5_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR5_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR5_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR5_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR5_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR5_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR5_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR5_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR5_RgRd(pdata, v);\
		v = ((v & MAC_L4AR5_L4DP0_Wr_Mask) | ((data & MAC_L4AR5_L4DP0_Mask)<<16));\
		MAC_L4AR5_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR5_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR5_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR5_L4DP0_Mask);\
} while(0)


#define MAC_L4AR4_RgOffAddr ((BASE_ADDRESS + 0x9c4))

#define MAC_L4AR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR4_RgOffAddr));\
} while(0)

#define MAC_L4AR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR4_RgOffAddr));\
} while(0)

/*#define MAC_L4AR4_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR4_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR4_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR4_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR4_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR4_RgRd(pdata, v);\
		v = ((v & MAC_L4AR4_L4SP0_Wr_Mask) | ((data & MAC_L4AR4_L4SP0_Mask)<<0));\
		MAC_L4AR4_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR4_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR4_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR4_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR4_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR4_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR4_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR4_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR4_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR4_RgRd(pdata, v);\
		v = ((v & MAC_L4AR4_L4DP0_Wr_Mask) | ((data & MAC_L4AR4_L4DP0_Mask)<<16));\
		MAC_L4AR4_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR4_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR4_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR4_L4DP0_Mask);\
} while(0)


#define MAC_L4AR3_RgOffAddr ((BASE_ADDRESS + 0x994))

#define MAC_L4AR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR3_RgOffAddr));\
} while(0)

#define MAC_L4AR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR3_RgOffAddr));\
} while(0)

/*#define MAC_L4AR3_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR3_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR3_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR3_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR3_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR3_RgRd(pdata, v);\
		v = ((v & MAC_L4AR3_L4SP0_Wr_Mask) | ((data & MAC_L4AR3_L4SP0_Mask)<<0));\
		MAC_L4AR3_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR3_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR3_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR3_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR3_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR3_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR3_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR3_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR3_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR3_RgRd(pdata, v);\
		v = ((v & MAC_L4AR3_L4DP0_Wr_Mask) | ((data & MAC_L4AR3_L4DP0_Mask)<<16));\
		MAC_L4AR3_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR3_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR3_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR3_L4DP0_Mask);\
} while(0)


#define MAC_L4AR2_RgOffAddr ((BASE_ADDRESS + 0x964))

#define MAC_L4AR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR2_RgOffAddr));\
} while(0)

#define MAC_L4AR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR2_RgOffAddr));\
} while(0)

/*#define MAC_L4AR2_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR2_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR2_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR2_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR2_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR2_RgRd(pdata, v);\
		v = ((v & MAC_L4AR2_L4SP0_Wr_Mask) | ((data & MAC_L4AR2_L4SP0_Mask)<<0));\
		MAC_L4AR2_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR2_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR2_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR2_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR2_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR2_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR2_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR2_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR2_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR2_RgRd(pdata, v);\
		v = ((v & MAC_L4AR2_L4DP0_Wr_Mask) | ((data & MAC_L4AR2_L4DP0_Mask)<<16));\
		MAC_L4AR2_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR2_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR2_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR2_L4DP0_Mask);\
} while(0)


#define MAC_L4AR1_RgOffAddr ((BASE_ADDRESS + 0x934))

#define MAC_L4AR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR1_RgOffAddr));\
} while(0)

#define MAC_L4AR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR1_RgOffAddr));\
} while(0)

/*#define MAC_L4AR1_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR1_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR1_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR1_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR1_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR1_RgRd(pdata, v);\
		v = ((v & MAC_L4AR1_L4SP0_Wr_Mask) | ((data & MAC_L4AR1_L4SP0_Mask)<<0));\
		MAC_L4AR1_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR1_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR1_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR1_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR1_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR1_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR1_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR1_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR1_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR1_RgRd(pdata, v);\
		v = ((v & MAC_L4AR1_L4DP0_Wr_Mask) | ((data & MAC_L4AR1_L4DP0_Mask)<<16));\
		MAC_L4AR1_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR1_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR1_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR1_L4DP0_Mask);\
} while(0)


#define MAC_L4AR0_RgOffAddr ((BASE_ADDRESS + 0x904))

#define MAC_L4AR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L4AR0_RgOffAddr));\
} while(0)

#define MAC_L4AR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L4AR0_RgOffAddr));\
} while(0)

/*#define MAC_L4AR0_L4SP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR0_L4SP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR0_L4SP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_L4AR0_L4SP0_Wr_Mask (ULONG)(0xffff0000)

#define MAC_L4AR0_L4SP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR0_RgRd(pdata, v);\
		v = ((v & MAC_L4AR0_L4SP0_Wr_Mask) | ((data & MAC_L4AR0_L4SP0_Mask)<<0));\
		MAC_L4AR0_RgWr(pdata, v);\
} while(0)
//HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH
#define MAC_L4AR0_L4SP0_UdfRd(pdata, data) do {\
		MAC_L4AR0_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L4AR0_L4SP0_Mask);\
} while(0)

/*#define MAC_L4AR0_L4DP0_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_L4AR0_L4DP0_Mask (ULONG)(0xffff)

/*#define MAC_L4AR0_L4DP0_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_L4AR0_L4DP0_Wr_Mask (ULONG)(0xffff)

#define MAC_L4AR0_L4DP0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_L4AR0_RgRd(pdata, v);\
		v = ((v & MAC_L4AR0_L4DP0_Wr_Mask) | ((data & MAC_L4AR0_L4DP0_Mask)<<16));\
		MAC_L4AR0_RgWr(pdata, v);\
} while(0)

#define MAC_L4AR0_L4DP0_UdfRd(pdata, data) do {\
		MAC_L4AR0_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L4AR0_L4DP0_Mask);\
} while(0)


#define MAC_L3L4CR7_RgOffAddr ((BASE_ADDRESS + 0xa50))

#define MAC_L3L4CR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR7_RgOffAddr));\
} while(0)

#define MAC_L3L4CR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR7_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR7_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR7_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR7_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR7_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR7_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR7_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR7_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR7_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR7_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR7_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR7_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR7_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR7_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR7_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR7_L3PEN0_Mask)<<0));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR7_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR7_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR7_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3SAM0_Mask)<<2));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR7_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR7_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR7_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR7_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR7_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR7_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3DAM0_Mask)<<4));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR7_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR7_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR7_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR7_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR7_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR7_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR7_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR7_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR7_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR7_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR7_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR7_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR7_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR7_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR7_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR7_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR7_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR7_L4PEN0_Mask)<<16));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR7_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR7_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR7_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR7_L4SPM0_Mask)<<18));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR7_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR7_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR7_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR7_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR7_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR7_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR7_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR7_L4DPM0_Mask)<<20));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR7_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR7_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR7_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR7_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR7_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR7_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR7_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR7_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR7_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR7_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR7_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR7_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR7_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR7_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR7_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR7_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR7_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR6_RgOffAddr ((BASE_ADDRESS + 0xa20))

#define MAC_L3L4CR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR6_RgOffAddr));\
} while(0)

#define MAC_L3L4CR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR6_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR6_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR6_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR6_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR6_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR6_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR6_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR6_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR6_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR6_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR6_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR6_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR6_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR6_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR6_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR6_L3PEN0_Mask)<<0));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR6_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR6_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR6_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3SAM0_Mask)<<2));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR6_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR6_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR6_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR6_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR6_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR6_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3DAM0_Mask)<<4));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR6_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR6_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR6_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR6_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR6_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR6_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR6_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR6_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR6_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR6_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR6_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR6_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR6_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR6_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR6_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR6_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR6_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR6_L4PEN0_Mask)<<16));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR6_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR6_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR6_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR6_L4SPM0_Mask)<<18));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR6_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR6_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR6_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR6_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR6_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR6_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR6_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR6_L4DPM0_Mask)<<20));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR6_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR6_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR6_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR6_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR6_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR6_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR6_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR6_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR6_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR6_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR6_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR6_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR6_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR6_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR6_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR6_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR6_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR5_RgOffAddr ((BASE_ADDRESS + 0x9f0))

#define MAC_L3L4CR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR5_RgOffAddr));\
} while(0)

#define MAC_L3L4CR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR5_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR5_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR5_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR5_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR5_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR5_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR5_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR5_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR5_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR5_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR5_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR5_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR5_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR5_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR5_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR5_L3PEN0_Mask)<<0));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR5_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR5_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR5_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3SAM0_Mask)<<2));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR5_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR5_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR5_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR5_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR5_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR5_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3DAM0_Mask)<<4));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR5_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR5_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR5_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR5_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR5_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR5_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR5_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR5_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR5_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR5_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR5_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR5_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR5_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR5_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR5_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR5_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR5_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR5_L4PEN0_Mask)<<16));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR5_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR5_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR5_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR5_L4SPM0_Mask)<<18));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR5_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR5_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR5_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR5_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR5_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR5_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR5_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR5_L4DPM0_Mask)<<20));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR5_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR5_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR5_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR5_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR5_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR5_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR5_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR5_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR5_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR5_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR5_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR5_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR5_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR5_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR5_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR5_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR5_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR4_RgOffAddr ((BASE_ADDRESS + 0x9c0))

#define MAC_L3L4CR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR4_RgOffAddr));\
} while(0)

#define MAC_L3L4CR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR4_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR4_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR4_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR4_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR4_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR4_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR4_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR4_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR4_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR4_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR4_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR4_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR4_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR4_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR4_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR4_L3PEN0_Mask)<<0));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR4_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR4_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR4_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3SAM0_Mask)<<2));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR4_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR4_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR4_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR4_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR4_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR4_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3DAM0_Mask)<<4));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR4_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR4_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR4_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR4_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR4_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR4_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR4_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR4_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR4_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR4_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR4_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR4_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR4_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR4_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR4_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR4_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR4_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR4_L4PEN0_Mask)<<16));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR4_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR4_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR4_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR4_L4SPM0_Mask)<<18));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR4_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR4_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR4_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR4_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR4_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR4_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR4_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR4_L4DPM0_Mask)<<20));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR4_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR4_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR4_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR4_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR4_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR4_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR4_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR4_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR4_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR4_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR4_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR4_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR4_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR4_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR4_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR4_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR4_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR3_RgOffAddr ((BASE_ADDRESS + 0x990))

#define MAC_L3L4CR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR3_RgOffAddr));\
} while(0)

#define MAC_L3L4CR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR3_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR3_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR3_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR3_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR3_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR3_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR3_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR3_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR3_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR3_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR3_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR3_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR3_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR3_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR3_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR3_L3PEN0_Mask)<<0));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR3_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR3_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR3_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3SAM0_Mask)<<2));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR3_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR3_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR3_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR3_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR3_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR3_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3DAM0_Mask)<<4));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR3_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR3_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR3_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR3_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR3_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR3_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR3_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR3_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR3_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR3_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR3_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR3_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR3_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR3_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR3_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR3_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR3_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR3_L4PEN0_Mask)<<16));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR3_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR3_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR3_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR3_L4SPM0_Mask)<<18));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR3_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR3_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR3_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR3_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR3_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR3_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR3_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR3_L4DPM0_Mask)<<20));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR3_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR3_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR3_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR3_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR3_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR3_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR3_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR3_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR3_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR3_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR3_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR3_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR3_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR3_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR3_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR3_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR3_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR2_RgOffAddr ((BASE_ADDRESS + 0x960))

#define MAC_L3L4CR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR2_RgOffAddr));\
} while(0)

#define MAC_L3L4CR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR2_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR2_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR2_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR2_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR2_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR2_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR2_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR2_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR2_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR2_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR2_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR2_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR2_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR2_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR2_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR2_L3PEN0_Mask)<<0));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR2_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR2_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR2_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3SAM0_Mask)<<2));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR2_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR2_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR2_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR2_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR2_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR2_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3DAM0_Mask)<<4));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR2_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR2_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR2_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR2_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR2_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR2_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR2_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR2_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR2_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR2_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR2_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR2_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR2_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR2_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR2_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR2_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR2_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR2_L4PEN0_Mask)<<16));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR2_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR2_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR2_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR2_L4SPM0_Mask)<<18));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR2_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR2_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR2_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR2_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR2_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR2_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR2_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR2_L4DPM0_Mask)<<20));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR2_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR2_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR2_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR2_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR2_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR2_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR2_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR2_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR2_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR2_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR2_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR2_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR2_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR2_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR2_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR2_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR2_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR1_RgOffAddr ((BASE_ADDRESS + 0x930))

#define MAC_L3L4CR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR1_RgOffAddr));\
} while(0)

#define MAC_L3L4CR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR1_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR1_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR1_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR1_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR1_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR1_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR1_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR1_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR1_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR1_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR1_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR1_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR1_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR1_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR1_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR1_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR1_L3PEN0_Mask)<<0));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR1_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR1_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR1_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3SAM0_Mask)<<2));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR1_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR1_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR1_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR1_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR1_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR1_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3DAM0_Mask)<<4));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR1_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR1_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR1_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR1_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR1_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR1_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR1_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR1_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR1_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR1_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR1_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR1_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR1_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR1_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR1_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR1_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR1_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR1_L4PEN0_Mask)<<16));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR1_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR1_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR1_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR1_L4SPM0_Mask)<<18));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR1_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR1_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR1_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR1_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR1_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR1_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR1_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR1_L4DPM0_Mask)<<20));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR1_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR1_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR1_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR1_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR1_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR1_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR1_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR1_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR1_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR1_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR1_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR1_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR1_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR1_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR1_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR1_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR1_L4DPIM0_Mask);\
} while(0)


#define MAC_L3L4CR0_RgOffAddr ((BASE_ADDRESS + 0x900))

#define MAC_L3L4CR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_L3L4CR0_RgOffAddr));\
} while(0)

#define MAC_L3L4CR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_L3L4CR0_RgOffAddr));\
} while(0)

/*#define  MAC_L3L4CR0_Mask_1 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR0_Mask_1 (ULONG)(0x1)

/*#define MAC_L3L4CR0_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(1)))<<(1)))*/

#define MAC_L3L4CR0_RES_Wr_Mask_1 (ULONG)(0xfffffffd)

/*#define  MAC_L3L4CR0_Mask_17 (ULONG)(~(~0<<(1)))*/

#define  MAC_L3L4CR0_Mask_17 (ULONG)(0x1)

/*#define MAC_L3L4CR0_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(1)))<<(17)))*/

#define MAC_L3L4CR0_RES_Wr_Mask_17 (ULONG)(0xfffdffff)

/*#define  MAC_L3L4CR0_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_L3L4CR0_Mask_22 (ULONG)(0x3ff)

/*#define MAC_L3L4CR0_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_L3L4CR0_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define MAC_L3L4CR0_L3PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_L3L4CR0_L3PEN0_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_L3L4CR0_L3PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3PEN0_Wr_Mask) | ((data & MAC_L3L4CR0_L3PEN0_Mask)<<0));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_L3L4CR0_L3PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3SAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3SAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3SAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_L3L4CR0_L3SAM0_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_L3L4CR0_L3SAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3SAM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3SAM0_Mask)<<2));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3SAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_L3L4CR0_L3SAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3SAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3SAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3SAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_L3L4CR0_L3SAIM0_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_L3L4CR0_L3SAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3SAIM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3SAIM0_Mask)<<3));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3SAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_L3L4CR0_L3SAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3DAM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3DAM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3DAM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_L3L4CR0_L3DAM0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_L3L4CR0_L3DAM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3DAM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3DAM0_Mask)<<4));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3DAM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_L3L4CR0_L3DAM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3DAIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L3DAIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L3DAIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_L3L4CR0_L3DAIM0_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_L3L4CR0_L3DAIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3DAIM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3DAIM0_Mask)<<5));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3DAIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_L3L4CR0_L3DAIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3HSBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR0_L3HSBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR0_L3HSBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (6)))*/

#define MAC_L3L4CR0_L3HSBM0_Wr_Mask (ULONG)(0xfffff83f)

#define MAC_L3L4CR0_L3HSBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3HSBM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3HSBM0_Mask)<<6));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3HSBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_L3L4CR0_L3HSBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L3HDBM0_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_L3L4CR0_L3HDBM0_Mask (ULONG)(0x1f)

/*#define MAC_L3L4CR0_L3HDBM0_Wr_Mask (ULONG)(~((~(~0 << (5))) << (11)))*/

#define MAC_L3L4CR0_L3HDBM0_Wr_Mask (ULONG)(0xffff07ff)

#define MAC_L3L4CR0_L3HDBM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L3HDBM0_Wr_Mask) | ((data & MAC_L3L4CR0_L3HDBM0_Mask)<<11));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L3HDBM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_L3L4CR0_L3HDBM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L4PEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4PEN0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4PEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_L3L4CR0_L4PEN0_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_L3L4CR0_L4PEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L4PEN0_Wr_Mask) | ((data & MAC_L3L4CR0_L4PEN0_Mask)<<16));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L4PEN0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_L3L4CR0_L4PEN0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L4SPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4SPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4SPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_L3L4CR0_L4SPM0_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_L3L4CR0_L4SPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L4SPM0_Wr_Mask) | ((data & MAC_L3L4CR0_L4SPM0_Mask)<<18));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L4SPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_L3L4CR0_L4SPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L4SPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4SPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4SPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_L3L4CR0_L4SPIM0_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_L3L4CR0_L4SPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L4SPIM0_Wr_Mask) | ((data & MAC_L3L4CR0_L4SPIM0_Mask)<<19));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L4SPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_L3L4CR0_L4SPIM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L4DPM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4DPM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4DPM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_L3L4CR0_L4DPM0_Wr_Mask (ULONG)(0xffefffff)

#define MAC_L3L4CR0_L4DPM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L4DPM0_Wr_Mask) | ((data & MAC_L3L4CR0_L4DPM0_Mask)<<20));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L4DPM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_L3L4CR0_L4DPM0_Mask);\
} while(0)

/*#define MAC_L3L4CR0_L4DPIM0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_L3L4CR0_L4DPIM0_Mask (ULONG)(0x1)

/*#define MAC_L3L4CR0_L4DPIM0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_L3L4CR0_L4DPIM0_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_L3L4CR0_L4DPIM0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_L3L4CR0_RgRd(pdata, v);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_1))|((( 0) & (MAC_L3L4CR0_Mask_1))<<1);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_17))|((( 0) & (MAC_L3L4CR0_Mask_17))<<17);\
		v = (v & (MAC_L3L4CR0_RES_Wr_Mask_22))|((( 0) & (MAC_L3L4CR0_Mask_22))<<22);\
		v = ((v & MAC_L3L4CR0_L4DPIM0_Wr_Mask) | ((data & MAC_L3L4CR0_L4DPIM0_Mask)<<21));\
		MAC_L3L4CR0_RgWr(pdata, v);\
} while(0)

#define MAC_L3L4CR0_L4DPIM0_UdfRd(pdata, data) do {\
		MAC_L3L4CR0_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_L3L4CR0_L4DPIM0_Mask);\
} while(0)


#define MAC_GPIOS_RgOffAddr ((BASE_ADDRESS + 0x20c))

#define MAC_GPIOS_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_GPIOS_RgOffAddr));\
} while(0)

#define MAC_GPIOS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_GPIOS_RgOffAddr));\
} while(0)

/*#define MAC_GPIOS_GPO_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GPIOS_GPO_Mask (ULONG)(0xffff)

/*#define MAC_GPIOS_GPO_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_GPIOS_GPO_Wr_Mask (ULONG)(0xffff)

#define MAC_GPIOS_GPO_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_GPIOS_RgRd(pdata, v);\
		v = ((v & MAC_GPIOS_GPO_Wr_Mask) | ((data & MAC_GPIOS_GPO_Mask)<<16));\
		MAC_GPIOS_RgWr(pdata, v);\
} while(0)

#define MAC_GPIOS_GPO_UdfRd(pdata, data) do {\
		MAC_GPIOS_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_GPIOS_GPO_Mask);\
} while(0)

/*#define MAC_GPIOS_GPIS_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GPIOS_GPIS_Mask (ULONG)(0xffff)

#define MAC_GPIOS_GPIS_UdfRd(pdata, data) do {\
		MAC_GPIOS_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_GPIOS_GPIS_Mask);\
} while(0)


#define MAC_PCS_RgOffAddr ((BASE_ADDRESS + 0xf8))

#define MAC_PCS_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PCS_RgOffAddr));\
} while(0)

#define MAC_PCS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PCS_RgOffAddr));\
} while(0)

/*#define  MAC_PCS_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  MAC_PCS_Mask_22 (ULONG)(0x3ff)

/*#define MAC_PCS_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define MAC_PCS_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define  MAC_PCS_Mask_5 (ULONG)(~(~0<<(11)))*/

#define  MAC_PCS_Mask_5 (ULONG)(0x7ff)

/*#define MAC_PCS_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(11)))<<(5)))*/

#define MAC_PCS_RES_Wr_Mask_5 (ULONG)(0xffff001f)

/*#define  MAC_PCS_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MAC_PCS_Mask_3 (ULONG)(0x1)

/*#define MAC_PCS_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MAC_PCS_RES_Wr_Mask_3 (ULONG)(0xfffffff7)

/*#define MAC_PCS_FALSCARDET_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_FALSCARDET_Mask (ULONG)(0x1)

/*#define MAC_PCS_FALSCARDET_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MAC_PCS_FALSCARDET_Wr_Mask (ULONG)(0xffdfffff)

#define MAC_PCS_FALSCARDET_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_FALSCARDET_Wr_Mask) | ((data & MAC_PCS_FALSCARDET_Mask)<<21));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_FALSCARDET_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_PCS_FALSCARDET_Mask);\
} while(0)

/*#define MAC_PCS_JABTO_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_JABTO_Mask (ULONG)(0x1)

/*#define MAC_PCS_JABTO_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_PCS_JABTO_Wr_Mask (ULONG)(0xffefffff)

#define MAC_PCS_JABTO_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_JABTO_Wr_Mask) | ((data & MAC_PCS_JABTO_Mask)<<20));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_JABTO_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_PCS_JABTO_Mask);\
} while(0)

/*#define MAC_PCS_LNKSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LNKSTS_Mask (ULONG)(0x1)

/*#define MAC_PCS_LNKSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_PCS_LNKSTS_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_PCS_LNKSTS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_LNKSTS_Wr_Mask) | ((data & MAC_PCS_LNKSTS_Mask)<<19));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_LNKSTS_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_PCS_LNKSTS_Mask);\
} while(0)

/*#define MAC_PCS_LNKSPEED_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PCS_LNKSPEED_Mask (ULONG)(0x3)

/*#define MAC_PCS_LNKSPEED_Wr_Mask (ULONG)(~((~(~0 << (2))) << (17)))*/

#define MAC_PCS_LNKSPEED_Wr_Mask (ULONG)(0xfff9ffff)

#define MAC_PCS_LNKSPEED_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_LNKSPEED_Wr_Mask) | ((data & MAC_PCS_LNKSPEED_Mask)<<17));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_LNKSPEED_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_PCS_LNKSPEED_Mask);\
} while(0)

/*#define MAC_PCS_LNKMOD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LNKMOD_Mask (ULONG)(0x1)

/*#define MAC_PCS_LNKMOD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_PCS_LNKMOD_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_PCS_LNKMOD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_LNKMOD_Wr_Mask) | ((data & MAC_PCS_LNKMOD_Mask)<<16));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_LNKMOD_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_PCS_LNKMOD_Mask);\
} while(0)

/*#define MAC_PCS_SMIDRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_SMIDRXS_Mask (ULONG)(0x1)

/*#define MAC_PCS_SMIDRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_PCS_SMIDRXS_Wr_Mask (ULONG)(0xffffffef)

#define MAC_PCS_SMIDRXS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_SMIDRXS_Wr_Mask) | ((data & MAC_PCS_SMIDRXS_Mask)<<4));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_SMIDRXS_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_PCS_SMIDRXS_Mask);\
} while(0)

/*#define MAC_PCS_SFTERR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_SFTERR_Mask (ULONG)(0x1)

/*#define MAC_PCS_SFTERR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_PCS_SFTERR_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_PCS_SFTERR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_SFTERR_Wr_Mask) | ((data & MAC_PCS_SFTERR_Mask)<<2));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_SFTERR_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_PCS_SFTERR_Mask);\
} while(0)

/*#define MAC_PCS_LUD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_LUD_Mask (ULONG)(0x1)

/*#define MAC_PCS_LUD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_PCS_LUD_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_PCS_LUD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_LUD_Wr_Mask) | ((data & MAC_PCS_LUD_Mask)<<1));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_LUD_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_PCS_LUD_Mask);\
} while(0)

/*#define MAC_PCS_TC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PCS_TC_Mask (ULONG)(0x1)

/*#define MAC_PCS_TC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_PCS_TC_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_PCS_TC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PCS_RgRd(pdata, v);\
		v = (v & (MAC_PCS_RES_Wr_Mask_22))|((( 0) & (MAC_PCS_Mask_22))<<22);\
		v = (v & (MAC_PCS_RES_Wr_Mask_5))|((( 0) & (MAC_PCS_Mask_5))<<5);\
		v = (v & (MAC_PCS_RES_Wr_Mask_3))|((( 0) & (MAC_PCS_Mask_3))<<3);\
		v = ((v & MAC_PCS_TC_Wr_Mask) | ((data & MAC_PCS_TC_Mask)<<0));\
		MAC_PCS_RgWr(pdata, v);\
} while(0)

#define MAC_PCS_TC_UdfRd(pdata, data) do {\
		MAC_PCS_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PCS_TC_Mask);\
} while(0)


#define MAC_TES_RgOffAddr ((BASE_ADDRESS + 0xf4))

#define MAC_TES_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TES_RgOffAddr));\
} while(0)

/*#define MAC_TES_GFD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TES_GFD_Mask (ULONG)(0x1)

#define MAC_TES_GFD_UdfRd(pdata, data) do {\
		MAC_TES_RgRd(pdata, data);\
		data = ((data >> 15) & MAC_TES_GFD_Mask);\
} while(0)

/*#define MAC_TES_GHD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TES_GHD_Mask (ULONG)(0x1)

#define MAC_TES_GHD_UdfRd(pdata, data) do {\
		MAC_TES_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_TES_GHD_Mask);\
} while(0)


#define MAC_AE_RgOffAddr ((BASE_ADDRESS + 0xf0))

#define MAC_AE_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_AE_RgOffAddr));\
} while(0)

/*#define MAC_AE_NPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AE_NPA_Mask (ULONG)(0x1)

#define MAC_AE_NPA_UdfRd(pdata, data) do {\
		MAC_AE_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_AE_NPA_Mask);\
} while(0)

/*#define MAC_AE_NPR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AE_NPR_Mask (ULONG)(0x1)

#define MAC_AE_NPR_UdfRd(pdata, data) do {\
		MAC_AE_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_AE_NPR_Mask);\
} while(0)


#define MAC_ALPA_RgOffAddr ((BASE_ADDRESS + 0xec))

#define MAC_ALPA_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ALPA_RgOffAddr));\
} while(0)

/*#define MAC_ALPA_NP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_NP_Mask (ULONG)(0x1)

#define MAC_ALPA_NP_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 15) & MAC_ALPA_NP_Mask);\
} while(0)

/*#define MAC_ALPA_ACK_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_ACK_Mask (ULONG)(0x1)

#define MAC_ALPA_ACK_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_ALPA_ACK_Mask);\
} while(0)

/*#define MAC_ALPA_RFE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_ALPA_RFE_Mask (ULONG)(0x3)

#define MAC_ALPA_RFE_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_ALPA_RFE_Mask);\
} while(0)

/*#define MAC_ALPA_PSE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_ALPA_PSE_Mask (ULONG)(0x3)

#define MAC_ALPA_PSE_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_ALPA_PSE_Mask);\
} while(0)

/*#define MAC_ALPA_HD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_HD_Mask (ULONG)(0x1)

#define MAC_ALPA_HD_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_ALPA_HD_Mask);\
} while(0)

/*#define MAC_ALPA_FD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ALPA_FD_Mask (ULONG)(0x1)

#define MAC_ALPA_FD_UdfRd(pdata, data) do {\
		MAC_ALPA_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_ALPA_FD_Mask);\
} while(0)


#define MAC_AAD_RgOffAddr ((BASE_ADDRESS + 0xe8))

#define MAC_AAD_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_AAD_RgOffAddr));\
} while(0)

#define MAC_AAD_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_AAD_RgOffAddr));\
} while(0)

/*#define  MAC_AAD_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_AAD_Mask_16 (ULONG)(0xffff)

/*#define MAC_AAD_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_AAD_RES_Wr_Mask_16 (ULONG)(0xffff)

/*#define  MAC_AAD_Mask_14 (ULONG)(~(~0<<(1)))*/

#define  MAC_AAD_Mask_14 (ULONG)(0x1)

/*#define MAC_AAD_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(1)))<<(14)))*/

#define MAC_AAD_RES_Wr_Mask_14 (ULONG)(0xffffbfff)

/*#define  MAC_AAD_Mask_9 (ULONG)(~(~0<<(3)))*/

#define  MAC_AAD_Mask_9 (ULONG)(0x7)

/*#define MAC_AAD_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(3)))<<(9)))*/

#define MAC_AAD_RES_Wr_Mask_9 (ULONG)(0xfffff1ff)

/*#define  MAC_AAD_Mask_0 (ULONG)(~(~0<<(5)))*/

#define  MAC_AAD_Mask_0 (ULONG)(0x1f)

/*#define MAC_AAD_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(5)))<<(0)))*/

#define MAC_AAD_RES_Wr_Mask_0 (ULONG)(0xffffffe0)

/*#define MAC_AAD_NPS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_NPS_Mask (ULONG)(0x1)

/*#define MAC_AAD_NPS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MAC_AAD_NPS_Wr_Mask (ULONG)(0xffff7fff)

#define MAC_AAD_NPS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AAD_RgRd(pdata, v);\
		v = (v & (MAC_AAD_RES_Wr_Mask_16))|((( 0) & (MAC_AAD_Mask_16))<<16);\
		v = (v & (MAC_AAD_RES_Wr_Mask_14))|((( 0) & (MAC_AAD_Mask_14))<<14);\
		v = (v & (MAC_AAD_RES_Wr_Mask_9))|((( 0) & (MAC_AAD_Mask_9))<<9);\
		v = (v & (MAC_AAD_RES_Wr_Mask_0))|((( 0) & (MAC_AAD_Mask_0))<<0);\
		v = ((v & MAC_AAD_NPS_Wr_Mask) | ((data & MAC_AAD_NPS_Mask)<<15));\
		MAC_AAD_RgWr(pdata, v);\
} while(0)

#define MAC_AAD_NPS_UdfRd(pdata, data) do {\
		MAC_AAD_RgRd(pdata, data);\
		data = ((data >> 15) & MAC_AAD_NPS_Mask);\
} while(0)

/*#define MAC_AAD_RFE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_AAD_RFE_Mask (ULONG)(0x3)

/*#define MAC_AAD_RFE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MAC_AAD_RFE_Wr_Mask (ULONG)(0xffffcfff)

#define MAC_AAD_RFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AAD_RgRd(pdata, v);\
		v = (v & (MAC_AAD_RES_Wr_Mask_16))|((( 0) & (MAC_AAD_Mask_16))<<16);\
		v = (v & (MAC_AAD_RES_Wr_Mask_14))|((( 0) & (MAC_AAD_Mask_14))<<14);\
		v = (v & (MAC_AAD_RES_Wr_Mask_9))|((( 0) & (MAC_AAD_Mask_9))<<9);\
		v = (v & (MAC_AAD_RES_Wr_Mask_0))|((( 0) & (MAC_AAD_Mask_0))<<0);\
		v = ((v & MAC_AAD_RFE_Wr_Mask) | ((data & MAC_AAD_RFE_Mask)<<12));\
		MAC_AAD_RgWr(pdata, v);\
} while(0)

#define MAC_AAD_RFE_UdfRd(pdata, data) do {\
		MAC_AAD_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_AAD_RFE_Mask);\
} while(0)

/*#define MAC_AAD_PSE_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_AAD_PSE_Mask (ULONG)(0x3)

/*#define MAC_AAD_PSE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (7)))*/

#define MAC_AAD_PSE_Wr_Mask (ULONG)(0xfffffe7f)

#define MAC_AAD_PSE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AAD_RgRd(pdata, v);\
		v = (v & (MAC_AAD_RES_Wr_Mask_16))|((( 0) & (MAC_AAD_Mask_16))<<16);\
		v = (v & (MAC_AAD_RES_Wr_Mask_14))|((( 0) & (MAC_AAD_Mask_14))<<14);\
		v = (v & (MAC_AAD_RES_Wr_Mask_9))|((( 0) & (MAC_AAD_Mask_9))<<9);\
		v = (v & (MAC_AAD_RES_Wr_Mask_0))|((( 0) & (MAC_AAD_Mask_0))<<0);\
		v = ((v & MAC_AAD_PSE_Wr_Mask) | ((data & MAC_AAD_PSE_Mask)<<7));\
		MAC_AAD_RgWr(pdata, v);\
} while(0)

#define MAC_AAD_PSE_UdfRd(pdata, data) do {\
		MAC_AAD_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_AAD_PSE_Mask);\
} while(0)

/*#define MAC_AAD_HD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_HD_Mask (ULONG)(0x1)

/*#define MAC_AAD_HD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_AAD_HD_Wr_Mask (ULONG)(0xffffffbf)

#define MAC_AAD_HD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AAD_RgRd(pdata, v);\
		v = (v & (MAC_AAD_RES_Wr_Mask_16))|((( 0) & (MAC_AAD_Mask_16))<<16);\
		v = (v & (MAC_AAD_RES_Wr_Mask_14))|((( 0) & (MAC_AAD_Mask_14))<<14);\
		v = (v & (MAC_AAD_RES_Wr_Mask_9))|((( 0) & (MAC_AAD_Mask_9))<<9);\
		v = (v & (MAC_AAD_RES_Wr_Mask_0))|((( 0) & (MAC_AAD_Mask_0))<<0);\
		v = ((v & MAC_AAD_HD_Wr_Mask) | ((data & MAC_AAD_HD_Mask)<<6));\
		MAC_AAD_RgWr(pdata, v);\
} while(0)

#define MAC_AAD_HD_UdfRd(pdata, data) do {\
		MAC_AAD_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_AAD_HD_Mask);\
} while(0)

/*#define MAC_AAD_FD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AAD_FD_Mask (ULONG)(0x1)

/*#define MAC_AAD_FD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_AAD_FD_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_AAD_FD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AAD_RgRd(pdata, v);\
		v = (v & (MAC_AAD_RES_Wr_Mask_16))|((( 0) & (MAC_AAD_Mask_16))<<16);\
		v = (v & (MAC_AAD_RES_Wr_Mask_14))|((( 0) & (MAC_AAD_Mask_14))<<14);\
		v = (v & (MAC_AAD_RES_Wr_Mask_9))|((( 0) & (MAC_AAD_Mask_9))<<9);\
		v = (v & (MAC_AAD_RES_Wr_Mask_0))|((( 0) & (MAC_AAD_Mask_0))<<0);\
		v = ((v & MAC_AAD_FD_Wr_Mask) | ((data & MAC_AAD_FD_Mask)<<5));\
		MAC_AAD_RgWr(pdata, v);\
} while(0)

#define MAC_AAD_FD_UdfRd(pdata, data) do {\
		MAC_AAD_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_AAD_FD_Mask);\
} while(0)


#define MAC_ANS_RgOffAddr ((BASE_ADDRESS + 0xe4))

#define MAC_ANS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ANS_RgOffAddr));\
} while(0)

/*#define MAC_ANS_ES_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ES_Mask (ULONG)(0x1)

#define MAC_ANS_ES_UdfRd(pdata, data) do {\
		MAC_ANS_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_ANS_ES_Mask);\
} while(0)

/*#define MAC_ANS_ANC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ANC_Mask (ULONG)(0x1)

#define MAC_ANS_ANC_UdfRd(pdata, data) do {\
		MAC_ANS_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_ANS_ANC_Mask);\
} while(0)

/*#define MAC_ANS_ANA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_ANA_Mask (ULONG)(0x1)

#define MAC_ANS_ANA_UdfRd(pdata, data) do {\
		MAC_ANS_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_ANS_ANA_Mask);\
} while(0)

/*#define MAC_ANS_LS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANS_LS_Mask (ULONG)(0x1)

#define MAC_ANS_LS_UdfRd(pdata, data) do {\
		MAC_ANS_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_ANS_LS_Mask);\
} while(0)


#define MAC_ANC_RgOffAddr ((BASE_ADDRESS + 0xe0))

#define MAC_ANC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_ANC_RgOffAddr));\
} while(0)

#define MAC_ANC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ANC_RgOffAddr));\
} while(0)

/*#define  MAC_ANC_Mask_19 (ULONG)(~(~0<<(13)))*/

#define  MAC_ANC_Mask_19 (ULONG)(0x1fff)

/*#define MAC_ANC_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(13)))<<(19)))*/

#define MAC_ANC_RES_Wr_Mask_19 (ULONG)(0x7ffff)

/*#define  MAC_ANC_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  MAC_ANC_Mask_15 (ULONG)(0x1)

/*#define MAC_ANC_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define MAC_ANC_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  MAC_ANC_Mask_13 (ULONG)(~(~0<<(1)))*/

#define  MAC_ANC_Mask_13 (ULONG)(0x1)

/*#define MAC_ANC_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(1)))<<(13)))*/

#define MAC_ANC_RES_Wr_Mask_13 (ULONG)(0xffffdfff)

/*#define  MAC_ANC_Mask_10 (ULONG)(~(~0<<(2)))*/

#define  MAC_ANC_Mask_10 (ULONG)(0x3)

/*#define MAC_ANC_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(2)))<<(10)))*/

#define MAC_ANC_RES_Wr_Mask_10 (ULONG)(0xfffff3ff)

/*#define  MAC_ANC_Mask_0 (ULONG)(~(~0<<(9)))*/

#define  MAC_ANC_Mask_0 (ULONG)(0x1ff)

/*#define MAC_ANC_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(9)))<<(0)))*/

#define MAC_ANC_RES_Wr_Mask_0 (ULONG)(0xfffffe00)

/*#define MAC_ANC_SGMRAL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_SGMRAL_Mask (ULONG)(0x1)

/*#define MAC_ANC_SGMRAL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_ANC_SGMRAL_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_ANC_SGMRAL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_SGMRAL_Wr_Mask) | ((data & MAC_ANC_SGMRAL_Mask)<<18));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_SGMRAL_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_ANC_SGMRAL_Mask);\
} while(0)

/*#define MAC_ANC_LR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_LR_Mask (ULONG)(0x1)

/*#define MAC_ANC_LR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_ANC_LR_Wr_Mask (ULONG)(0xfffdffff)

#define MAC_ANC_LR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_LR_Wr_Mask) | ((data & MAC_ANC_LR_Mask)<<17));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_LR_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_ANC_LR_Mask);\
} while(0)

/*#define MAC_ANC_ECD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ECD_Mask (ULONG)(0x1)

/*#define MAC_ANC_ECD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_ANC_ECD_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_ANC_ECD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_ECD_Wr_Mask) | ((data & MAC_ANC_ECD_Mask)<<16));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_ECD_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_ANC_ECD_Mask);\
} while(0)

/*#define MAC_ANC_ELE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ELE_Mask (ULONG)(0x1)

/*#define MAC_ANC_ELE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MAC_ANC_ELE_Wr_Mask (ULONG)(0xffffbfff)

#define MAC_ANC_ELE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_ELE_Wr_Mask) | ((data & MAC_ANC_ELE_Mask)<<14));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_ELE_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_ANC_ELE_Mask);\
} while(0)

/*#define MAC_ANC_ANE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_ANE_Mask (ULONG)(0x1)

/*#define MAC_ANC_ANE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_ANC_ANE_Wr_Mask (ULONG)(0xffffefff)

#define MAC_ANC_ANE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_ANE_Wr_Mask) | ((data & MAC_ANC_ANE_Mask)<<12));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_ANE_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_ANC_ANE_Mask);\
} while(0)

/*#define MAC_ANC_RAN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ANC_RAN_Mask (ULONG)(0x1)

/*#define MAC_ANC_RAN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_ANC_RAN_Wr_Mask (ULONG)(0xfffffdff)

#define MAC_ANC_RAN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_ANC_RgRd(pdata, v);\
		v = (v & (MAC_ANC_RES_Wr_Mask_19))|((( 0) & (MAC_ANC_Mask_19))<<19);\
		v = (v & (MAC_ANC_RES_Wr_Mask_15))|((( 0) & (MAC_ANC_Mask_15))<<15);\
		v = (v & (MAC_ANC_RES_Wr_Mask_13))|((( 0) & (MAC_ANC_Mask_13))<<13);\
		v = (v & (MAC_ANC_RES_Wr_Mask_10))|((( 0) & (MAC_ANC_Mask_10))<<10);\
		v = (v & (MAC_ANC_RES_Wr_Mask_0))|((( 0) & (MAC_ANC_Mask_0))<<0);\
		v = ((v & MAC_ANC_RAN_Wr_Mask) | ((data & MAC_ANC_RAN_Mask)<<9));\
		MAC_ANC_RgWr(pdata, v);\
} while(0)

#define MAC_ANC_RAN_UdfRd(pdata, data) do {\
		MAC_ANC_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_ANC_RAN_Mask);\
} while(0)


#define MAC_LPC_RgOffAddr ((BASE_ADDRESS + 0xd4))

#define MAC_LPC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_LPC_RgOffAddr));\
} while(0)

#define MAC_LPC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_LPC_RgOffAddr));\
} while(0)

/*#define  MAC_LPC_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MAC_LPC_Mask_26 (ULONG)(0x3f)

/*#define MAC_LPC_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MAC_LPC_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MAC_LPC_TLPIEX_Mask (ULONG)(~(~0<<(10)))*/

#define MAC_LPC_TLPIEX_Mask (ULONG)(0x3ff)

/*#define MAC_LPC_TLPIEX_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MAC_LPC_TLPIEX_Wr_Mask (ULONG)(0xfc00ffff)

#define MAC_LPC_TLPIEX_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPC_RgRd(pdata, v);\
		v = (v & (MAC_LPC_RES_Wr_Mask_26))|((( 0) & (MAC_LPC_Mask_26))<<26);\
		v = ((v & MAC_LPC_TLPIEX_Wr_Mask) | ((data & MAC_LPC_TLPIEX_Mask)<<16));\
		MAC_LPC_RgWr(pdata, v);\
} while(0)

#define MAC_LPC_TLPIEX_UdfRd(pdata, data) do {\
		MAC_LPC_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_LPC_TLPIEX_Mask);\
} while(0)

/*#define MAC_LPC_TWT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_LPC_TWT_Mask (ULONG)(0xffff)

/*#define MAC_LPC_TWT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_LPC_TWT_Wr_Mask (ULONG)(0xffff0000)

#define MAC_LPC_TWT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPC_RgRd(pdata, v);\
		v = (v & (MAC_LPC_RES_Wr_Mask_26))|((( 0) & (MAC_LPC_Mask_26))<<26);\
		v = ((v & MAC_LPC_TWT_Wr_Mask) | ((data & MAC_LPC_TWT_Mask)<<0));\
		MAC_LPC_RgWr(pdata, v);\
} while(0)

#define MAC_LPC_TWT_UdfRd(pdata, data) do {\
		MAC_LPC_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_LPC_TWT_Mask);\
} while(0)


#define MAC_LPS_RgOffAddr ((BASE_ADDRESS + 0xd0))

#define MAC_LPS_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_LPS_RgOffAddr));\
} while(0)

#define MAC_LPS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_LPS_RgOffAddr));\
} while(0)

/*#define  MAC_LPS_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  MAC_LPS_Mask_20 (ULONG)(0xfff)

/*#define MAC_LPS_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define MAC_LPS_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define  MAC_LPS_Mask_10 (ULONG)(~(~0<<(6)))*/

#define  MAC_LPS_Mask_10 (ULONG)(0x3f)

/*#define MAC_LPS_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(6)))<<(10)))*/

#define MAC_LPS_RES_Wr_Mask_10 (ULONG)(0xffff03ff)

/*#define  MAC_LPS_Mask_4 (ULONG)(~(~0<<(4)))*/

#define  MAC_LPS_Mask_4 (ULONG)(0xf)

/*#define MAC_LPS_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(4)))<<(4)))*/

#define MAC_LPS_RES_Wr_Mask_4 (ULONG)(0xffffff0f)

/*#define MAC_LPS_LPITXA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_LPITXA_Mask (ULONG)(0x1)

/*#define MAC_LPS_LPITXA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_LPS_LPITXA_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_LPS_LPITXA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_LPITXA_Wr_Mask) | ((data & MAC_LPS_LPITXA_Mask)<<19));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_LPITXA_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_LPS_LPITXA_Mask);\
} while(0)

/*#define MAC_LPS_PLSEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_PLSEN_Mask (ULONG)(0x1)

/*#define MAC_LPS_PLSEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_LPS_PLSEN_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_LPS_PLSEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_PLSEN_Wr_Mask) | ((data & MAC_LPS_PLSEN_Mask)<<18));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_PLSEN_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_LPS_PLSEN_Mask);\
} while(0)

/*#define MAC_LPS_PLS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_PLS_Mask (ULONG)(0x1)

/*#define MAC_LPS_PLS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_LPS_PLS_Wr_Mask (ULONG)(0xfffdffff)

#define MAC_LPS_PLS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_PLS_Wr_Mask) | ((data & MAC_LPS_PLS_Mask)<<17));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_PLS_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_LPS_PLS_Mask);\
} while(0)

/*#define MAC_LPS_LPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_LPIEN_Mask (ULONG)(0x1)

/*#define MAC_LPS_LPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_LPS_LPIEN_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_LPS_LPIEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_LPIEN_Wr_Mask) | ((data & MAC_LPS_LPIEN_Mask)<<16));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_LPIEN_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_LPS_LPIEN_Mask);\
} while(0)

/*#define MAC_LPS_RLPIST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIST_Mask (ULONG)(0x1)

#define MAC_LPS_RLPIST_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_LPS_RLPIST_Mask);\
} while(0)

/*#define MAC_LPS_TLPIST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIST_Mask (ULONG)(0x1)

#define MAC_LPS_TLPIST_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_LPS_TLPIST_Mask);\
} while(0)

/*#define MAC_LPS_RLPIEX_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIEX_Mask (ULONG)(0x1)

/*#define MAC_LPS_RLPIEX_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_LPS_RLPIEX_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_LPS_RLPIEX_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_RLPIEX_Wr_Mask) | ((data & MAC_LPS_RLPIEX_Mask)<<3));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_RLPIEX_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_LPS_RLPIEX_Mask);\
} while(0)

/*#define MAC_LPS_RLPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_RLPIEN_Mask (ULONG)(0x1)

/*#define MAC_LPS_RLPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_LPS_RLPIEN_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_LPS_RLPIEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_RLPIEN_Wr_Mask) | ((data & MAC_LPS_RLPIEN_Mask)<<2));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_RLPIEN_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_LPS_RLPIEN_Mask);\
} while(0)

/*#define MAC_LPS_TLPIEX_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIEX_Mask (ULONG)(0x1)

/*#define MAC_LPS_TLPIEX_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_LPS_TLPIEX_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_LPS_TLPIEX_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_TLPIEX_Wr_Mask) | ((data & MAC_LPS_TLPIEX_Mask)<<1));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_TLPIEX_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_LPS_TLPIEX_Mask);\
} while(0)

/*#define MAC_LPS_TLPIEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_LPS_TLPIEN_Mask (ULONG)(0x1)

/*#define MAC_LPS_TLPIEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_LPS_TLPIEN_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_LPS_TLPIEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_LPS_RgRd(pdata, v);\
		v = (v & (MAC_LPS_RES_Wr_Mask_20))|((( 0) & (MAC_LPS_Mask_20))<<20);\
		v = (v & (MAC_LPS_RES_Wr_Mask_10))|((( 0) & (MAC_LPS_Mask_10))<<10);\
		v = (v & (MAC_LPS_RES_Wr_Mask_4))|((( 0) & (MAC_LPS_Mask_4))<<4);\
		v = ((v & MAC_LPS_TLPIEN_Wr_Mask) | ((data & MAC_LPS_TLPIEN_Mask)<<0));\
		MAC_LPS_RgWr(pdata, v);\
} while(0)

#define MAC_LPS_TLPIEN_UdfRd(pdata, data) do {\
		MAC_LPS_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_LPS_TLPIEN_Mask);\
} while(0)


#define MAC_PPS_WIDTH3_RgOffAddr ((BASE_ADDRESS + 0xbbc))

#define MAC_PPS_WIDTH3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_WIDTH3_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_WIDTH3_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH3_PPSWIDTH0_UdfWr(pdata, data) do {\
		MAC_PPS_WIDTH3_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_WIDTH3_PPSWIDTH0_UdfRd(pdata, data) do {\
		MAC_PPS_WIDTH3_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_WIDTH2_RgOffAddr ((BASE_ADDRESS + 0xbac))

#define MAC_PPS_WIDTH2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_WIDTH2_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_WIDTH2_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH2_PPSWIDTH0_UdfWr(pdata, data) do {\
		MAC_PPS_WIDTH2_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_WIDTH2_PPSWIDTH0_UdfRd(pdata, data) do {\
		MAC_PPS_WIDTH2_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_WIDTH1_RgOffAddr ((BASE_ADDRESS + 0xb9c))

#define MAC_PPS_WIDTH1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_WIDTH1_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_WIDTH1_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH1_PPSWIDTH0_UdfWr(pdata, data) do {\
		MAC_PPS_WIDTH1_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_WIDTH1_PPSWIDTH0_UdfRd(pdata, data) do {\
		MAC_PPS_WIDTH1_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_WIDTH0_RgOffAddr ((BASE_ADDRESS + 0xb8c))

#define MAC_PPS_WIDTH0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_WIDTH0_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_WIDTH0_RgOffAddr));\
} while(0)

#define MAC_PPS_WIDTH0_PPSWIDTH0_UdfWr(pdata, data) do {\
		MAC_PPS_WIDTH0_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_WIDTH0_PPSWIDTH0_UdfRd(pdata, data) do {\
		MAC_PPS_WIDTH0_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_INTVAL3_RgOffAddr ((BASE_ADDRESS + 0xbb8))

#define MAC_PPS_INTVAL3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_INTVAL3_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_INTVAL3_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL3_PPSINT0_UdfWr(pdata, data) do {\
		MAC_PPS_INTVAL3_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_INTVAL3_PPSINT0_UdfRd(pdata, data) do {\
		MAC_PPS_INTVAL3_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_INTVAL2_RgOffAddr ((BASE_ADDRESS + 0xba8))

#define MAC_PPS_INTVAL2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_INTVAL2_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_INTVAL2_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL2_PPSINT0_UdfWr(pdata, data) do {\
		MAC_PPS_INTVAL2_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_INTVAL2_PPSINT0_UdfRd(pdata, data) do {\
		MAC_PPS_INTVAL2_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_INTVAL1_RgOffAddr ((BASE_ADDRESS + 0xb98))

#define MAC_PPS_INTVAL1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_INTVAL1_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_INTVAL1_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL1_PPSINT0_UdfWr(pdata, data) do {\
		MAC_PPS_INTVAL1_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_INTVAL1_PPSINT0_UdfRd(pdata, data) do {\
		MAC_PPS_INTVAL1_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_INTVAL0_RgOffAddr ((BASE_ADDRESS + 0xb88))

#define MAC_PPS_INTVAL0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_INTVAL0_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_INTVAL0_RgOffAddr));\
} while(0)

#define MAC_PPS_INTVAL0_PPSINT0_UdfWr(pdata, data) do {\
		MAC_PPS_INTVAL0_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_INTVAL0_PPSINT0_UdfRd(pdata, data) do {\
		MAC_PPS_INTVAL0_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_TTNS3_RgOffAddr ((BASE_ADDRESS + 0xbb4))

#define MAC_PPS_TTNS3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTNS3_RgOffAddr));\
} while(0)

#define MAC_PPS_TTNS3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTNS3_RgOffAddr));\
} while(0)

/*#define MAC_PPS_TTNS3_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS3_TTSL0_Mask (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS3_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS3_TTSL0_Wr_Mask (ULONG)(0x80000000)

#define MAC_PPS_TTNS3_TTSL0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS3_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS3_TTSL0_Wr_Mask) | ((data & MAC_PPS_TTNS3_TTSL0_Mask)<<0));\
		MAC_PPS_TTNS3_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS3_TTSL0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS3_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PPS_TTNS3_TTSL0_Mask);\
} while(0)

/*#define MAC_PPS_TTNS3_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS3_TRGTBUSY0_Mask (ULONG)(0x1)

/*#define MAC_PPS_TTNS3_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS3_TRGTBUSY0_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS3_TRGTBUSY0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS3_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS3_TRGTBUSY0_Wr_Mask) | ((data & MAC_PPS_TTNS3_TRGTBUSY0_Mask)<<31));\
		MAC_PPS_TTNS3_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS3_TRGTBUSY0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS3_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_PPS_TTNS3_TRGTBUSY0_Mask);\
} while(0)


#define MAC_PPS_TTNS2_RgOffAddr ((BASE_ADDRESS + 0xba4))

#define MAC_PPS_TTNS2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTNS2_RgOffAddr));\
} while(0)

#define MAC_PPS_TTNS2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTNS2_RgOffAddr));\
} while(0)

/*#define MAC_PPS_TTNS2_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS2_TTSL0_Mask (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS2_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS2_TTSL0_Wr_Mask (ULONG)(0x80000000)

#define MAC_PPS_TTNS2_TTSL0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS2_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS2_TTSL0_Wr_Mask) | ((data & MAC_PPS_TTNS2_TTSL0_Mask)<<0));\
		MAC_PPS_TTNS2_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS2_TTSL0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS2_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PPS_TTNS2_TTSL0_Mask);\
} while(0)

/*#define MAC_PPS_TTNS2_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS2_TRGTBUSY0_Mask (ULONG)(0x1)

/*#define MAC_PPS_TTNS2_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS2_TRGTBUSY0_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS2_TRGTBUSY0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS2_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS2_TRGTBUSY0_Wr_Mask) | ((data & MAC_PPS_TTNS2_TRGTBUSY0_Mask)<<31));\
		MAC_PPS_TTNS2_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS2_TRGTBUSY0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS2_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_PPS_TTNS2_TRGTBUSY0_Mask);\
} while(0)








#define MAC_LMIR_RgOffAddr ((BASE_ADDRESS + 0xbd0))

#define MAC_LMIR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_LMIR_RgOffAddr));\
} while(0)

#define MAC_LMIR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_LMIR_RgOffAddr));\
} while(0)

#define MAC_SPI2R_RgOffAddr ((BASE_ADDRESS + 0xbcc))

#define MAC_SPI2R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_SPI2R_RgOffAddr));\
} while(0)

#define MAC_SPI2R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_SPI2R_RgOffAddr));\
} while(0)

/*#define  MAC_SPI2R_Mask_16 (unsigned int)(~(~0<<(16)))*/

#define  MAC_SPI2R_Mask_16 (unsigned int)(0xffff)

/*#define MAC_SPI2R_RES_Wr_Mask_16 (unsigned int)(~((~(~0<<(16)))<<(16)))*/

#define MAC_SPI2R_RES_Wr_Mask_16 (unsigned int)(0xffff)

/*#define MAC_SPI2R_SPIO_Mask (unsigned int)(~(~0<<(16)))*/

#define MAC_SPI2R_SPIO_Mask (unsigned int)(0xffff)

/*#define MAC_SPI2R_SPIO_Wr_Mask (unsigned int)(~((~(~0 << (16))) << (0)))*/

#define MAC_SPI2R_SPIO_Wr_Mask (unsigned int)(0xffff0000)

#define MAC_SPI2R_SPIO_UdfWr(pdata, data) do {\
		unsigned int v = 0; \
		v = (v & (MAC_SPI2R_RES_Wr_Mask_16))|((( 0) & (MAC_SPI2R_Mask_16))<<16);\
		(v) = ((v & MAC_SPI2R_SPIO_Wr_Mask) | ((data & MAC_SPI2R_SPIO_Mask)<<0));\
		MAC_SPI2R_RgWr(pdata, v);\
} while(0)

#define MAC_SPI2R_SPIO_UdfRd(pdata, data) do {\
		MAC_SPI2R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_SPI2R_SPIO_Mask);\
} while(0)


#define MAC_SPI1R_RgOffAddr ((BASE_ADDRESS + 0xbc8))

#define MAC_SPI1R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_SPI1R_RgOffAddr));\
} while(0)

#define MAC_SPI1R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_SPI1R_RgOffAddr));\
} while(0)

#define MAC_SPI1R_SPIO_UdfWr(pdata, data) do {\
		MAC_SPI1R_RgWr(pdata, data);\
} while(0)

#define MAC_SPI1R_SPIO_UdfRd(pdata, data) do {\
		MAC_SPI1R_RgRd(pdata, data);\
} while(0)


#define MAC_SPI0R_RgOffAddr ((BASE_ADDRESS + 0xbc4))

#define MAC_SPI0R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_SPI0R_RgOffAddr));\
} while(0)

#define MAC_SPI0R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_SPI0R_RgOffAddr));\
} while(0)

#define MAC_SPI0R_SPIO_UdfWr(pdata, data) do {\
		MAC_SPI0R_RgWr(pdata, data);\
} while(0)

#define MAC_SPI0R_SPIO_UdfRd(pdata, data) do {\
		MAC_SPI0R_RgRd(pdata, data);\
} while(0)


#define MAC_PTO_CR_RgOffAddr ((BASE_ADDRESS + 0xbc0))

#define MAC_PTO_CR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PTO_CR_RgOffAddr));\
} while(0)

#define MAC_PTO_CR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PTO_CR_RgOffAddr));\
} while(0)

/*#define  MAC_PTO_CR_Mask_16 (unsigned int)(~(~0<<(16)))*/

#define  MAC_PTO_CR_Mask_16 (unsigned int)(0xffff)

/*#define MAC_PTO_CR_RES_Wr_Mask_16 (unsigned int)(~((~(~0<<(16)))<<(16)))*/

#define MAC_PTO_CR_RES_Wr_Mask_16 (unsigned int)(0xffff)

/*#define  MAC_PTO_CR_Mask_6 (unsigned int)(~(~0<<(2)))*/

#define  MAC_PTO_CR_Mask_6 (unsigned int)(0x3)

/*#define MAC_PTO_CR_RES_Wr_Mask_6 (unsigned int)(~((~(~0<<(2)))<<(6)))*/

#define MAC_PTO_CR_RES_Wr_Mask_6 (unsigned int)(0xffffff3f)

/*#define  MAC_PTO_CR_Mask_3 (unsigned int)(~(~0<<(1)))*/

#define  MAC_PTO_CR_Mask_3 (unsigned int)(0x1)

/*#define MAC_PTO_CR_RES_Wr_Mask_3 (unsigned int)(~((~(~0<<(1)))<<(3)))*/

#define MAC_PTO_CR_RES_Wr_Mask_3 (unsigned int)(0xfffffff7)

/*#define MAC_PTO_CR_DN_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_PTO_CR_DN_Mask (unsigned int)(0xff)

/*#define MAC_PTO_CR_DN_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (8)))*/

#define MAC_PTO_CR_DN_Wr_Mask (unsigned int)(0xffff00ff)

#define MAC_PTO_CR_DN_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_DN_Wr_Mask) | ((data & MAC_PTO_CR_DN_Mask)<<8));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_DN_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_PTO_CR_DN_Mask);\
} while(0)

/*#define MAC_PTO_CR_APDREQTRIG_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_APDREQTRIG_Mask (unsigned int)(0x1)

/*#define MAC_PTO_CR_APDREQTRIG_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (5)))*/

#define MAC_PTO_CR_APDREQTRIG_Wr_Mask (unsigned int)(0xffffffdf)

#define MAC_PTO_CR_APDREQTRIG_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_APDREQTRIG_Wr_Mask) | ((data & MAC_PTO_CR_APDREQTRIG_Mask)<<5));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_APDREQTRIG_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_PTO_CR_APDREQTRIG_Mask);\
} while(0)

/*#define MAC_PTO_CR_ASYNCTRIG_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_ASYNCTRIG_Mask (unsigned int)(0x1)

/*#define MAC_PTO_CR_ASYNCTRIG_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (4)))*/

#define MAC_PTO_CR_ASYNCTRIG_Wr_Mask (unsigned int)(0xffffffef)

#define MAC_PTO_CR_ASYNCTRIG_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_ASYNCTRIG_Wr_Mask) | ((data & MAC_PTO_CR_ASYNCTRIG_Mask)<<4));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_ASYNCTRIG_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_PTO_CR_ASYNCTRIG_Mask);\
} while(0)

/*#define MAC_PTO_CR_APDREQEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_APDREQEN_Mask (unsigned int)(0x1)

/*#define MAC_PTO_CR_APDREQEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (2)))*/

#define MAC_PTO_CR_APDREQEN_Wr_Mask (unsigned int)(0xfffffffb)

#define MAC_PTO_CR_APDREQEN_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_APDREQEN_Wr_Mask) | ((data & MAC_PTO_CR_APDREQEN_Mask)<<2));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_APDREQEN_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_PTO_CR_APDREQEN_Mask);\
} while(0)

/*#define MAC_PTO_CR_ASYNCEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_ASYNCEN_Mask (unsigned int)(0x1)

/*#define MAC_PTO_CR_ASYNCEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (1)))*/

#define MAC_PTO_CR_ASYNCEN_Wr_Mask (unsigned int)(0xfffffffd)

#define MAC_PTO_CR_ASYNCEN_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_ASYNCEN_Wr_Mask) | ((data & MAC_PTO_CR_ASYNCEN_Mask)<<1));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_ASYNCEN_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_PTO_CR_ASYNCEN_Mask);\
} while(0)

/*#define MAC_PTO_CR_PTOEN_Mask (unsigned int)(~(~0<<(1)))*/

#define MAC_PTO_CR_PTOEN_Mask (unsigned int)(0x1)

/*#define MAC_PTO_CR_PTOEN_Wr_Mask (unsigned int)(~((~(~0 << (1))) << (0)))*/

#define MAC_PTO_CR_PTOEN_Wr_Mask (unsigned int)(0xfffffffe)

#define MAC_PTO_CR_PTOEN_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_PTO_CR_RgRd(pdata, v);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_16))|((( 0) & (MAC_PTO_CR_Mask_16))<<16);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_6))|((( 0) & (MAC_PTO_CR_Mask_6))<<6);\
		v = (v & (MAC_PTO_CR_RES_Wr_Mask_3))|((( 0) & (MAC_PTO_CR_Mask_3))<<3);\
		v = ((v & MAC_PTO_CR_PTOEN_Wr_Mask) | ((data & MAC_PTO_CR_PTOEN_Mask)<<0));\
		MAC_PTO_CR_RgWr(pdata, v);\
} while(0)

#define MAC_PTO_CR_PTOEN_UdfRd(pdata, data) do {\
		MAC_PTO_CR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PTO_CR_PTOEN_Mask);\
} while(0)























#define MAC_PPS_TTNS1_RgOffAddr ((BASE_ADDRESS + 0xb94))

#define MAC_PPS_TTNS1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTNS1_RgOffAddr));\
} while(0)

#define MAC_PPS_TTNS1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTNS1_RgOffAddr));\
} while(0)

/*#define MAC_PPS_TTNS1_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS1_TTSL0_Mask (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS1_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS1_TTSL0_Wr_Mask (ULONG)(0x80000000)

#define MAC_PPS_TTNS1_TTSL0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS1_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS1_TTSL0_Wr_Mask) | ((data & MAC_PPS_TTNS1_TTSL0_Mask)<<0));\
		MAC_PPS_TTNS1_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS1_TTSL0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS1_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PPS_TTNS1_TTSL0_Mask);\
} while(0)

/*#define MAC_PPS_TTNS1_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS1_TRGTBUSY0_Mask (ULONG)(0x1)

/*#define MAC_PPS_TTNS1_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS1_TRGTBUSY0_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS1_TRGTBUSY0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS1_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS1_TRGTBUSY0_Wr_Mask) | ((data & MAC_PPS_TTNS1_TRGTBUSY0_Mask)<<31));\
		MAC_PPS_TTNS1_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS1_TRGTBUSY0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS1_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_PPS_TTNS1_TRGTBUSY0_Mask);\
} while(0)


#define MAC_PPS_TTNS0_RgOffAddr ((BASE_ADDRESS + 0xb84))

#define MAC_PPS_TTNS0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTNS0_RgOffAddr));\
} while(0)

#define MAC_PPS_TTNS0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTNS0_RgOffAddr));\
} while(0)

/*#define MAC_PPS_TTNS0_TTSL0_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_PPS_TTNS0_TTSL0_Mask (ULONG)(0x7fffffff)

/*#define MAC_PPS_TTNS0_TTSL0_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_PPS_TTNS0_TTSL0_Wr_Mask (ULONG)(0x80000000)

#define MAC_PPS_TTNS0_TTSL0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS0_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS0_TTSL0_Wr_Mask) | ((data & MAC_PPS_TTNS0_TTSL0_Mask)<<0));\
		MAC_PPS_TTNS0_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS0_TTSL0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS0_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PPS_TTNS0_TTSL0_Mask);\
} while(0)

/*#define MAC_PPS_TTNS0_TRGTBUSY0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPS_TTNS0_TRGTBUSY0_Mask (ULONG)(0x1)

/*#define MAC_PPS_TTNS0_TRGTBUSY0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PPS_TTNS0_TRGTBUSY0_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_PPS_TTNS0_TRGTBUSY0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_PPS_TTNS0_RgRd(pdata, v);\
		v = ((v & MAC_PPS_TTNS0_TRGTBUSY0_Wr_Mask) | ((data & MAC_PPS_TTNS0_TRGTBUSY0_Mask)<<31));\
		MAC_PPS_TTNS0_RgWr(pdata, v);\
} while(0)

#define MAC_PPS_TTNS0_TRGTBUSY0_UdfRd(pdata, data) do {\
		MAC_PPS_TTNS0_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_PPS_TTNS0_TRGTBUSY0_Mask);\
} while(0)


#define MAC_PPS_TTS3_RgOffAddr ((BASE_ADDRESS + 0xbb0))

#define MAC_PPS_TTS3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTS3_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTS3_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS3_TSTRH0_UdfWr(pdata, data) do {\
		MAC_PPS_TTS3_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_TTS3_TSTRH0_UdfRd(pdata, data) do {\
		MAC_PPS_TTS3_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_TTS2_RgOffAddr ((BASE_ADDRESS + 0xba0))

#define MAC_PPS_TTS2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTS2_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTS2_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS2_TSTRH0_UdfWr(pdata, data) do {\
		MAC_PPS_TTS2_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_TTS2_TSTRH0_UdfRd(pdata, data) do {\
		MAC_PPS_TTS2_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_TTS1_RgOffAddr ((BASE_ADDRESS + 0xb90))

#define MAC_PPS_TTS1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTS1_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTS1_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS1_TSTRH0_UdfWr(pdata, data) do {\
		MAC_PPS_TTS1_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_TTS1_TSTRH0_UdfRd(pdata, data) do {\
		MAC_PPS_TTS1_RgRd(pdata, data);\
} while(0)


#define MAC_PPS_TTS0_RgOffAddr ((BASE_ADDRESS + 0xb80))

#define MAC_PPS_TTS0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPS_TTS0_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPS_TTS0_RgOffAddr));\
} while(0)

#define MAC_PPS_TTS0_TSTRH0_UdfWr(pdata, data) do {\
		MAC_PPS_TTS0_RgWr(pdata, data);\
} while(0)

#define MAC_PPS_TTS0_TSTRH0_UdfRd(pdata, data) do {\
		MAC_PPS_TTS0_RgRd(pdata, data);\
} while(0)


#define MAC_PPSC_RgOffAddr ((BASE_ADDRESS + 0xb70))

#define MAC_PPSC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PPSC_RgOffAddr));\
} while(0)

#define MAC_PPSC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PPSC_RgOffAddr));\
} while(0)

/*#define  MAC_PPSC_Mask_31 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_Mask_31 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_31 (ULONG)(~((~(~0<<(1)))<<(31)))*/

#define MAC_PPSC_RES_Wr_Mask_31 (ULONG)(0x7fffffff)

/*#define  MAC_PPSC_Mask_27 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_Mask_27 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(2)))<<(27)))*/

#define MAC_PPSC_RES_Wr_Mask_27 (ULONG)(0xe7ffffff)

/*#define  MAC_PPSC_Mask_23 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_Mask_23 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_23 (ULONG)(~((~(~0<<(1)))<<(23)))*/

#define MAC_PPSC_RES_Wr_Mask_23 (ULONG)(0xff7fffff)

/*#define  MAC_PPSC_Mask_19 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_Mask_19 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(2)))<<(19)))*/

#define MAC_PPSC_RES_Wr_Mask_19 (ULONG)(0xffe7ffff)

/*#define  MAC_PPSC_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_Mask_15 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define MAC_PPSC_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  MAC_PPSC_Mask_11 (ULONG)(~(~0<<(2)))*/

#define  MAC_PPSC_Mask_11 (ULONG)(0x3)

/*#define MAC_PPSC_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(2)))<<(11)))*/

#define MAC_PPSC_RES_Wr_Mask_11 (ULONG)(0xffffe7ff)

/*#define  MAC_PPSC_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MAC_PPSC_Mask_7 (ULONG)(0x1)

/*#define MAC_PPSC_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MAC_PPSC_RES_Wr_Mask_7 (ULONG)(0xffffff7f)

/*#define MAC_PPSC_TRGTMODSEL3_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL3_Mask (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL3_Wr_Mask (ULONG)(~((~(~0 << (2))) << (29)))*/

#define MAC_PPSC_TRGTMODSEL3_Wr_Mask (ULONG)(0x9fffffff)

#define MAC_PPSC_TRGTMODSEL3_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_TRGTMODSEL3_Wr_Mask) | ((data & MAC_PPSC_TRGTMODSEL3_Mask)<<29));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_TRGTMODSEL3_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 29) & MAC_PPSC_TRGTMODSEL3_Mask);\
} while(0)

/*#define MAC_PPSC_PPSCMD3_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD3_Mask (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD3_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MAC_PPSC_PPSCMD3_Wr_Mask (ULONG)(0xf8ffffff)

#define MAC_PPSC_PPSCMD3_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_PPSCMD3_Wr_Mask) | ((data & MAC_PPSC_PPSCMD3_Mask)<<24));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_PPSCMD3_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_PPSC_PPSCMD3_Mask);\
} while(0)

/*#define MAC_PPSC_TRGTMODSEL2_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL2_Mask (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL2_Wr_Mask (ULONG)(~((~(~0 << (2))) << (21)))*/

#define MAC_PPSC_TRGTMODSEL2_Wr_Mask (ULONG)(0xff9fffff)

#define MAC_PPSC_TRGTMODSEL2_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_TRGTMODSEL2_Wr_Mask) | ((data & MAC_PPSC_TRGTMODSEL2_Mask)<<21));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_TRGTMODSEL2_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_PPSC_TRGTMODSEL2_Mask);\
} while(0)

/*#define MAC_PPSC_PPSCMD2_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD2_Mask (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD2_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_PPSC_PPSCMD2_Wr_Mask (ULONG)(0xfff8ffff)

#define MAC_PPSC_PPSCMD2_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_PPSCMD2_Wr_Mask) | ((data & MAC_PPSC_PPSCMD2_Mask)<<16));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_PPSCMD2_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_PPSC_PPSCMD2_Mask);\
} while(0)

/*#define MAC_PPSC_TRGTMODSEL1_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL1_Mask (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL1_Wr_Mask (ULONG)(~((~(~0 << (2))) << (13)))*/

#define MAC_PPSC_TRGTMODSEL1_Wr_Mask (ULONG)(0xffff9fff)

#define MAC_PPSC_TRGTMODSEL1_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_TRGTMODSEL1_Wr_Mask) | ((data & MAC_PPSC_TRGTMODSEL1_Mask)<<13));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_TRGTMODSEL1_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 13) & MAC_PPSC_TRGTMODSEL1_Mask);\
} while(0)

/*#define MAC_PPSC_PPSCMD1_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PPSC_PPSCMD1_Mask (ULONG)(0x7)

/*#define MAC_PPSC_PPSCMD1_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MAC_PPSC_PPSCMD1_Wr_Mask (ULONG)(0xfffff8ff)

#define MAC_PPSC_PPSCMD1_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_PPSCMD1_Wr_Mask) | ((data & MAC_PPSC_PPSCMD1_Mask)<<8));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_PPSCMD1_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_PPSC_PPSCMD1_Mask);\
} while(0)

/*#define MAC_PPSC_TRGTMODSEL0_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_PPSC_TRGTMODSEL0_Mask (ULONG)(0x3)

/*#define MAC_PPSC_TRGTMODSEL0_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MAC_PPSC_TRGTMODSEL0_Wr_Mask (ULONG)(0xffffff9f)

#define MAC_PPSC_TRGTMODSEL0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_TRGTMODSEL0_Wr_Mask) | ((data & MAC_PPSC_TRGTMODSEL0_Mask)<<5));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_TRGTMODSEL0_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_PPSC_TRGTMODSEL0_Mask);\
} while(0)

/*#define MAC_PPSC_PPSEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PPSC_PPSEN0_Mask (ULONG)(0x1)

/*#define MAC_PPSC_PPSEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_PPSC_PPSEN0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_PPSC_PPSEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_PPSEN0_Wr_Mask) | ((data & MAC_PPSC_PPSEN0_Mask)<<4));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_PPSEN0_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_PPSC_PPSEN0_Mask);\
} while(0)

/*#define MAC_PPSC_PPSCTRL0_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_PPSC_PPSCTRL0_Mask (ULONG)(0xf)

/*#define MAC_PPSC_PPSCTRL0_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define MAC_PPSC_PPSCTRL0_Wr_Mask (ULONG)(0xfffffff0)

#define MAC_PPSC_PPSCTRL0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PPSC_RgRd(pdata, v);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_31))|((( 0) & (MAC_PPSC_Mask_31))<<31);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_27))|((( 0) & (MAC_PPSC_Mask_27))<<27);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_23))|((( 0) & (MAC_PPSC_Mask_23))<<23);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_19))|((( 0) & (MAC_PPSC_Mask_19))<<19);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_15))|((( 0) & (MAC_PPSC_Mask_15))<<15);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_11))|((( 0) & (MAC_PPSC_Mask_11))<<11);\
		v = (v & (MAC_PPSC_RES_Wr_Mask_7))|((( 0) & (MAC_PPSC_Mask_7))<<7);\
		v = ((v & MAC_PPSC_PPSCTRL0_Wr_Mask) | ((data & MAC_PPSC_PPSCTRL0_Mask)<<0));\
		MAC_PPSC_RgWr(pdata, v);\
} while(0)

#define MAC_PPSC_PPSCTRL0_UdfRd(pdata, data) do {\
		MAC_PPSC_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PPSC_PPSCTRL0_Mask);\
} while(0)


#define MAC_TEAC_RgOffAddr ((BASE_ADDRESS + 0xb54))

#define MAC_TEAC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TEAC_RgOffAddr));\
} while(0)

#define MAC_TEAC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TEAC_RgOffAddr));\
} while(0)

/*#define  MAC_TEAC_Mask_31 (ULONG)(~(~0<<(1)))*/

#define  MAC_TEAC_Mask_31 (ULONG)(0x1)

/*#define MAC_TEAC_RES_Wr_Mask_31 (ULONG)(~((~(~0<<(1)))<<(31)))*/

#define MAC_TEAC_RES_Wr_Mask_31 (ULONG)(0x7fffffff)

/*#define MAC_TEAC_OSTIAC_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_TEAC_OSTIAC_Mask (ULONG)(0x7fffffff)

/*#define MAC_TEAC_OSTIAC_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_TEAC_OSTIAC_Wr_Mask (ULONG)(0x80000000)

#define MAC_TEAC_OSTIAC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MAC_TEAC_RES_Wr_Mask_31))|((( 0) & (MAC_TEAC_Mask_31))<<31);\
		(v) = ((v & MAC_TEAC_OSTIAC_Wr_Mask) | ((data & MAC_TEAC_OSTIAC_Mask)<<0));\
		MAC_TEAC_RgWr(pdata, v);\
} while(0)

#define MAC_TEAC_OSTIAC_UdfRd(pdata, data) do {\
		MAC_TEAC_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TEAC_OSTIAC_Mask);\
} while(0)


#define MAC_TIAC_RgOffAddr ((BASE_ADDRESS + 0xb50))

#define MAC_TIAC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TIAC_RgOffAddr));\
} while(0)

#define MAC_TIAC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TIAC_RgOffAddr));\
} while(0)

#define MAC_TIAC_OSTIAC_UdfWr(pdata, data) do {\
		MAC_TIAC_RgWr(pdata, data);\
} while(0)

#define MAC_TIAC_OSTIAC_UdfRd(pdata, data) do {\
		MAC_TIAC_RgRd(pdata, data);\
} while(0)


#define MAC_ATS_RgOffAddr ((BASE_ADDRESS + 0xb4c))

#define MAC_ATS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ATS_RgOffAddr));\
} while(0)

#define MAC_ATS_AUXTSHI_UdfRd(pdata, data) do {\
		MAC_ATS_RgRd(pdata, data);\
} while(0)


#define MAC_ATN_RgOffAddr ((BASE_ADDRESS + 0xb48))

#define MAC_ATN_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ATN_RgOffAddr));\
} while(0)

/*#define MAC_ATN_AUXTSLO_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_ATN_AUXTSLO_Mask (ULONG)(0x7fffffff)

#define MAC_ATN_AUXTSLO_UdfRd(pdata, data) do {\
		MAC_ATN_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_ATN_AUXTSLO_Mask);\
} while(0)


#define MAC_AC_RgOffAddr ((BASE_ADDRESS + 0xb40))

#define MAC_AC_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_AC_RgOffAddr));\
} while(0)

#define MAC_AC_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_AC_RgOffAddr));\
} while(0)

/*#define  MAC_AC_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  MAC_AC_Mask_8 (ULONG)(0xffffff)

/*#define MAC_AC_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define MAC_AC_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define  MAC_AC_Mask_1 (ULONG)(~(~0<<(3)))*/

#define  MAC_AC_Mask_1 (ULONG)(0x7)

/*#define MAC_AC_RES_Wr_Mask_1 (ULONG)(~((~(~0<<(3)))<<(1)))*/

#define MAC_AC_RES_Wr_Mask_1 (ULONG)(0xfffffff1)

/*#define MAC_AC_ATSEN3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN3_Mask (ULONG)(0x1)

/*#define MAC_AC_ATSEN3_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_AC_ATSEN3_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_AC_ATSEN3_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AC_RgRd(pdata, v);\
		v = (v & (MAC_AC_RES_Wr_Mask_8))|((( 0) & (MAC_AC_Mask_8))<<8);\
		v = (v & (MAC_AC_RES_Wr_Mask_1))|((( 0) & (MAC_AC_Mask_1))<<1);\
		v = ((v & MAC_AC_ATSEN3_Wr_Mask) | ((data & MAC_AC_ATSEN3_Mask)<<7));\
		MAC_AC_RgWr(pdata, v);\
} while(0)

#define MAC_AC_ATSEN3_UdfRd(pdata, data) do {\
		MAC_AC_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_AC_ATSEN3_Mask);\
} while(0)

/*#define MAC_AC_ATSEN2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN2_Mask (ULONG)(0x1)

/*#define MAC_AC_ATSEN2_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_AC_ATSEN2_Wr_Mask (ULONG)(0xffffffbf)

#define MAC_AC_ATSEN2_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AC_RgRd(pdata, v);\
		v = (v & (MAC_AC_RES_Wr_Mask_8))|((( 0) & (MAC_AC_Mask_8))<<8);\
		v = (v & (MAC_AC_RES_Wr_Mask_1))|((( 0) & (MAC_AC_Mask_1))<<1);\
		v = ((v & MAC_AC_ATSEN2_Wr_Mask) | ((data & MAC_AC_ATSEN2_Mask)<<6));\
		MAC_AC_RgWr(pdata, v);\
} while(0)

#define MAC_AC_ATSEN2_UdfRd(pdata, data) do {\
		MAC_AC_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_AC_ATSEN2_Mask);\
} while(0)

/*#define MAC_AC_ATSEN1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN1_Mask (ULONG)(0x1)

/*#define MAC_AC_ATSEN1_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_AC_ATSEN1_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_AC_ATSEN1_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AC_RgRd(pdata, v);\
		v = (v & (MAC_AC_RES_Wr_Mask_8))|((( 0) & (MAC_AC_Mask_8))<<8);\
		v = (v & (MAC_AC_RES_Wr_Mask_1))|((( 0) & (MAC_AC_Mask_1))<<1);\
		v = ((v & MAC_AC_ATSEN1_Wr_Mask) | ((data & MAC_AC_ATSEN1_Mask)<<5));\
		MAC_AC_RgWr(pdata, v);\
} while(0)

#define MAC_AC_ATSEN1_UdfRd(pdata, data) do {\
		MAC_AC_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_AC_ATSEN1_Mask);\
} while(0)

/*#define MAC_AC_ATSEN0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSEN0_Mask (ULONG)(0x1)

/*#define MAC_AC_ATSEN0_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_AC_ATSEN0_Wr_Mask (ULONG)(0xffffffef)

#define MAC_AC_ATSEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AC_RgRd(pdata, v);\
		v = (v & (MAC_AC_RES_Wr_Mask_8))|((( 0) & (MAC_AC_Mask_8))<<8);\
		v = (v & (MAC_AC_RES_Wr_Mask_1))|((( 0) & (MAC_AC_Mask_1))<<1);\
		v = ((v & MAC_AC_ATSEN0_Wr_Mask) | ((data & MAC_AC_ATSEN0_Mask)<<4));\
		MAC_AC_RgWr(pdata, v);\
} while(0)

#define MAC_AC_ATSEN0_UdfRd(pdata, data) do {\
		MAC_AC_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_AC_ATSEN0_Mask);\
} while(0)

/*#define MAC_AC_ATSFC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_AC_ATSFC_Mask (ULONG)(0x1)

/*#define MAC_AC_ATSFC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_AC_ATSFC_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_AC_ATSFC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_AC_RgRd(pdata, v);\
		v = (v & (MAC_AC_RES_Wr_Mask_8))|((( 0) & (MAC_AC_Mask_8))<<8);\
		v = (v & (MAC_AC_RES_Wr_Mask_1))|((( 0) & (MAC_AC_Mask_1))<<1);\
		v = ((v & MAC_AC_ATSFC_Wr_Mask) | ((data & MAC_AC_ATSFC_Mask)<<0));\
		MAC_AC_RgWr(pdata, v);\
} while(0)

#define MAC_AC_ATSFC_UdfRd(pdata, data) do {\
		MAC_AC_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_AC_ATSFC_Mask);\
} while(0)


#define MAC_TTN_RgOffAddr ((BASE_ADDRESS + 0xb34))

#define MAC_TTN_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TTN_RgOffAddr));\
} while(0)

#define MAC_TTN_TXTSSTSHI_UdfRd(pdata, data) do {\
		MAC_TTN_RgRd(pdata, data);\
} while(0)


#define MAC_TTSN_RgOffAddr ((BASE_ADDRESS + 0xb30))

#define MAC_TTSN_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TTSN_RgOffAddr));\
} while(0)

/*#define MAC_TTSN_TXTSSTSMIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TTSN_TXTSSTSMIS_Mask (ULONG)(0x1)

#define MAC_TTSN_TXTSSTSMIS_UdfRd(pdata, data) do {\
		MAC_TTSN_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_TTSN_TXTSSTSMIS_Mask);\
} while(0)

/*#define MAC_TTSN_TXTSSTSLO_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_TTSN_TXTSSTSLO_Mask (ULONG)(0x7fffffff)

#define MAC_TTSN_TXTSSTSLO_UdfRd(pdata, data) do {\
		MAC_TTSN_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TTSN_TXTSSTSLO_Mask);\
} while(0)


#define MAC_TSR_RgOffAddr ((BASE_ADDRESS + 0xb20))

#define MAC_TSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TSR_RgOffAddr));\
} while(0)

/*#define MAC_TSR_ATSNS_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_TSR_ATSNS_Mask (ULONG)(0x1f)

#define MAC_TSR_ATSNS_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 25) & MAC_TSR_ATSNS_Mask);\
} while(0)

/*#define MAC_TSR_ATSSTM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_ATSSTM_Mask (ULONG)(0x1)

#define MAC_TSR_ATSSTM_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_TSR_ATSSTM_Mask);\
} while(0)

/*#define MAC_TSR_ATSSTN_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_TSR_ATSSTN_Mask (ULONG)(0xf)

#define MAC_TSR_ATSSTN_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_TSR_ATSSTN_Mask);\
} while(0)

/*#define MAC_TSR_TSTRGTERR3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR3_Mask (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR3_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_TSR_TSTRGTERR3_Mask);\
} while(0)

/*#define MAC_TSR_TSTARGT3_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT3_Mask (ULONG)(0x1)

#define MAC_TSR_TSTARGT3_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_TSR_TSTARGT3_Mask);\
} while(0)

/*#define MAC_TSR_TSTRGTERR2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR2_Mask (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR2_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_TSR_TSTRGTERR2_Mask);\
} while(0)

/*#define MAC_TSR_TSTARGT2_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT2_Mask (ULONG)(0x1)

#define MAC_TSR_TSTARGT2_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_TSR_TSTARGT2_Mask);\
} while(0)

/*#define MAC_TSR_TSTRGTERR1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR1_Mask (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR1_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_TSR_TSTRGTERR1_Mask);\
} while(0)

/*#define MAC_TSR_TSTARGT1_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT1_Mask (ULONG)(0x1)

#define MAC_TSR_TSTARGT1_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_TSR_TSTARGT1_Mask);\
} while(0)

/*#define MAC_TSR_TSTRGTERR0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTRGTERR0_Mask (ULONG)(0x1)

#define MAC_TSR_TSTRGTERR0_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_TSR_TSTRGTERR0_Mask);\
} while(0)

/*#define MAC_TSR_AUXTSTRIG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_AUXTSTRIG_Mask (ULONG)(0x1)

#define MAC_TSR_AUXTSTRIG_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_TSR_AUXTSTRIG_Mask);\
} while(0)

/*#define MAC_TSR_TSTARGT0_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSTARGT0_Mask (ULONG)(0x1)

#define MAC_TSR_TSTARGT0_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_TSR_TSTARGT0_Mask);\
} while(0)

/*#define MAC_TSR_TSSOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TSR_TSSOVF_Mask (ULONG)(0x1)

#define MAC_TSR_TSSOVF_UdfRd(pdata, data) do {\
		MAC_TSR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TSR_TSSOVF_Mask);\
} while(0)


#define MAC_STHWR_RgOffAddr ((BASE_ADDRESS + 0xb1c))

#define MAC_STHWR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_STHWR_RgOffAddr));\
} while(0)

#define MAC_STHWR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_STHWR_RgOffAddr));\
} while(0)

/*#define  MAC_STHWR_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_STHWR_Mask_16 (ULONG)(0xffff)

/*#define MAC_STHWR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_STHWR_RES_Wr_Mask_16 (ULONG)(0xffff)

/*#define MAC_STHWR_TSHWR_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_STHWR_TSHWR_Mask (ULONG)(0xffff)

/*#define MAC_STHWR_TSHWR_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_STHWR_TSHWR_Wr_Mask (ULONG)(0xffff0000)

#define MAC_STHWR_TSHWR_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MAC_STHWR_RES_Wr_Mask_16))|((( 0) & (MAC_STHWR_Mask_16))<<16);\
		(v) = ((v & MAC_STHWR_TSHWR_Wr_Mask) | ((data & MAC_STHWR_TSHWR_Mask)<<0));\
		MAC_STHWR_RgWr(pdata, v);\
} while(0)

#define MAC_STHWR_TSHWR_UdfRd(pdata, data) do {\
		MAC_STHWR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_STHWR_TSHWR_Mask);\
} while(0)


#define MAC_TAR_RgOffAddr ((BASE_ADDRESS + 0xb18))

#define MAC_TAR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TAR_RgOffAddr));\
} while(0)

#define MAC_TAR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TAR_RgOffAddr));\
} while(0)

#define MAC_TAR_TSAR_UdfWr(pdata, data) do {\
		MAC_TAR_RgWr(pdata, data);\
} while(0)

#define MAC_TAR_TSAR_UdfRd(pdata, data) do {\
		MAC_TAR_RgRd(pdata, data);\
} while(0)


#define MAC_STNSUR_RgOffAddr ((BASE_ADDRESS + 0xb14))

#define MAC_STNSUR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_STNSUR_RgOffAddr));\
} while(0)

#define MAC_STNSUR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_STNSUR_RgOffAddr));\
} while(0)

/*#define MAC_STNSUR_ADDSUB_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_STNSUR_ADDSUB_Mask (ULONG)(0x1)

/*#define MAC_STNSUR_ADDSUB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_STNSUR_ADDSUB_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_STNSUR_ADDSUB_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_STNSUR_RgRd(pdata, v);\
		v = ((v & MAC_STNSUR_ADDSUB_Wr_Mask) | ((data & MAC_STNSUR_ADDSUB_Mask)<<31));\
		MAC_STNSUR_RgWr(pdata, v);\
} while(0)

#define MAC_STNSUR_ADDSUB_UdfRd(pdata, data) do {\
		MAC_STNSUR_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_STNSUR_ADDSUB_Mask);\
} while(0)

/*#define MAC_STNSUR_TSSS_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_STNSUR_TSSS_Mask (ULONG)(0x7fffffff)

/*#define MAC_STNSUR_TSSS_Wr_Mask (ULONG)(~((~(~0 << (31))) << (0)))*/

#define MAC_STNSUR_TSSS_Wr_Mask (ULONG)(0x80000000)

#define MAC_STNSUR_TSSS_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_STNSUR_RgRd(pdata, v);\
		v = ((v & MAC_STNSUR_TSSS_Wr_Mask) | ((data & MAC_STNSUR_TSSS_Mask)<<0));\
		MAC_STNSUR_RgWr(pdata, v);\
} while(0)

#define MAC_STNSUR_TSSS_UdfRd(pdata, data) do {\
		MAC_STNSUR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_STNSUR_TSSS_Mask);\
} while(0)


#define MAC_STSUR_RgOffAddr ((BASE_ADDRESS + 0xb10))

#define MAC_STSUR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_STSUR_RgOffAddr));\
} while(0)

#define MAC_STSUR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_STSUR_RgOffAddr));\
} while(0)

#define MAC_STSUR_TSS_UdfWr(pdata, data) do {\
		MAC_STSUR_RgWr(pdata, data);\
} while(0)

#define MAC_STSUR_TSS_UdfRd(pdata, data) do {\
		MAC_STSUR_RgRd(pdata, data);\
} while(0)


#define MAC_STNSR_RgOffAddr ((BASE_ADDRESS + 0xb0c))

#define MAC_STNSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_STNSR_RgOffAddr));\
} while(0)

/*#define MAC_STNSR_TSSS_Mask (ULONG)(~(~0<<(31)))*/

#define MAC_STNSR_TSSS_Mask (ULONG)(0x7fffffff)

#define MAC_STNSR_TSSS_UdfRd(pdata, data) do {\
		MAC_STNSR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_STNSR_TSSS_Mask);\
} while(0)


#define MAC_STSR_RgOffAddr ((BASE_ADDRESS + 0xb08))

#define MAC_STSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_STSR_RgOffAddr));\
} while(0)

#define MAC_STSR_TSS_UdfRd(pdata, data) do {\
		MAC_STSR_RgRd(pdata, data);\
} while(0)


#define MAC_SSIR_RgOffAddr ((BASE_ADDRESS + 0xb04))

#define MAC_SSIR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_SSIR_RgOffAddr));\
} while(0)

#define MAC_SSIR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_SSIR_RgOffAddr));\
} while(0)

/*#define  MAC_SSIR_Mask_24 (unsigned int)(~(~0<<(8)))*/

#define  MAC_SSIR_Mask_24 (unsigned int)(0xff)

/*#define MAC_SSIR_RES_Wr_Mask_24 (unsigned int)(~((~(~0<<(8)))<<(24)))*/

#define MAC_SSIR_RES_Wr_Mask_24 (unsigned int)(0xffffff)

/*#define  MAC_SSIR_Mask_0 (unsigned int)(~(~0<<(8)))*/

#define  MAC_SSIR_Mask_0 (unsigned int)(0xff)

/*#define MAC_SSIR_RES_Wr_Mask_0 (unsigned int)(~((~(~0<<(8)))<<(0)))*/

#define MAC_SSIR_RES_Wr_Mask_0 (unsigned int)(0xffffff00)

/*#define MAC_SSIR_SSINC_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_SSIR_SSINC_Mask (unsigned int)(0xff)

/*#define MAC_SSIR_SSINC_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (16)))*/

#define MAC_SSIR_SSINC_Wr_Mask (unsigned int)(0xff00ffff)

#define MAC_SSIR_SSINC_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_SSIR_RgRd(pdata, v);\
		v = (v & (MAC_SSIR_RES_Wr_Mask_24))|((( 0) & (MAC_SSIR_Mask_24))<<24);\
		v = (v & (MAC_SSIR_RES_Wr_Mask_0))|((( 0) & (MAC_SSIR_Mask_0))<<0);\
		v = ((v & MAC_SSIR_SSINC_Wr_Mask) | ((data & MAC_SSIR_SSINC_Mask)<<16));\
		MAC_SSIR_RgWr(pdata, v);\
} while(0)

#define MAC_SSIR_SSINC_UdfRd(pdata, data) do {\
		MAC_SSIR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_SSIR_SSINC_Mask);\
} while(0)

/*#define MAC_SSIR_SNSINC_Mask (unsigned int)(~(~0<<(8)))*/

#define MAC_SSIR_SNSINC_Mask (unsigned int)(0xff)

/*#define MAC_SSIR_SNSINC_Wr_Mask (unsigned int)(~((~(~0 << (8))) << (8)))*/

#define MAC_SSIR_SNSINC_Wr_Mask (unsigned int)(0xffff00ff)

#define MAC_SSIR_SNSINC_UdfWr(pdata, data) do {\
		unsigned int v;\
		MAC_SSIR_RgRd(pdata, v);\
		v = (v & (MAC_SSIR_RES_Wr_Mask_24))|((( 0) & (MAC_SSIR_Mask_24))<<24);\
		v = (v & (MAC_SSIR_RES_Wr_Mask_0))|((( 0) & (MAC_SSIR_Mask_0))<<0);\
		v = ((v & MAC_SSIR_SNSINC_Wr_Mask) | ((data & MAC_SSIR_SNSINC_Mask)<<8));\
		MAC_SSIR_RgWr(pdata, v);\
} while(0)

#define MAC_SSIR_SNSINC_UdfRd(pdata, data) do {\
		MAC_SSIR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_SSIR_SNSINC_Mask);\
} while(0)

#define MAC_TCR_RgOffAddr ((BASE_ADDRESS + 0xb00))

#define MAC_TCR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TCR_RgOffAddr));\
} while(0)

#define MAC_TCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TCR_RgOffAddr));\
} while(0)

/*#define  MAC_TCR_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_Mask_29 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MAC_TCR_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define  MAC_TCR_Mask_25 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_Mask_25 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(3)))<<(25)))*/

#define MAC_TCR_RES_Wr_Mask_25 (ULONG)(0xf1ffffff)

/*#define  MAC_TCR_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MAC_TCR_Mask_21 (ULONG)(0x7)

/*#define MAC_TCR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MAC_TCR_RES_Wr_Mask_21 (ULONG)(0xff1fffff)

/*#define  MAC_TCR_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MAC_TCR_Mask_19 (ULONG)(0x1)

/*#define MAC_TCR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MAC_TCR_RES_Wr_Mask_19 (ULONG)(0xfff7ffff)

/*#define  MAC_TCR_Mask_6 (ULONG)(~(~0<<(2)))*/

#define  MAC_TCR_Mask_6 (ULONG)(0x3)

/*#define MAC_TCR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(2)))<<(6)))*/

#define MAC_TCR_RES_Wr_Mask_6 (ULONG)(0xffffff3f)

/*#define MAC_TCR_AV8021ASMEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_AV8021ASMEN_Mask (ULONG)(0x1)

/*#define MAC_TCR_AV8021ASMEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MAC_TCR_AV8021ASMEN_Wr_Mask (ULONG)(0xefffffff)

#define MAC_TCR_AV8021ASMEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_AV8021ASMEN_Wr_Mask) | ((data & MAC_TCR_AV8021ASMEN_Mask)<<28));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_AV8021ASMEN_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 28) & MAC_TCR_AV8021ASMEN_Mask);\
} while(0)

/*#define MAC_TCR_TXTSSTSM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TXTSSTSM_Mask (ULONG)(0x1)

/*#define MAC_TCR_TXTSSTSM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MAC_TCR_TXTSSTSM_Wr_Mask (ULONG)(0xfeffffff)

#define MAC_TCR_TXTSSTSM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TXTSSTSM_Wr_Mask) | ((data & MAC_TCR_TXTSSTSM_Mask)<<24));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TXTSSTSM_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_TCR_TXTSSTSM_Mask);\
} while(0)

/*#define MAC_TCR_ESTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_ESTI_Mask (ULONG)(0x1)

/*#define MAC_TCR_ESTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_TCR_ESTI_Wr_Mask (ULONG)(0xffefffff)

#define MAC_TCR_ESTI_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_ESTI_Wr_Mask) | ((data & MAC_TCR_ESTI_Mask)<<20));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_ESTI_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_TCR_ESTI_Mask);\
} while(0)

/*#define MAC_TCR_TSENMACADDR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENMACADDR_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSENMACADDR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_TCR_TSENMACADDR_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_TCR_TSENMACADDR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSENMACADDR_Wr_Mask) | ((data & MAC_TCR_TSENMACADDR_Mask)<<18));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSENMACADDR_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_TCR_TSENMACADDR_Mask);\
} while(0)

/*#define MAC_TCR_SNAPTYPSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_TCR_SNAPTYPSEL_Mask (ULONG)(0x3)

/*#define MAC_TCR_SNAPTYPSEL_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_TCR_SNAPTYPSEL_Wr_Mask (ULONG)(0xfffcffff)

#define MAC_TCR_SNAPTYPSEL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_SNAPTYPSEL_Wr_Mask) | ((data & MAC_TCR_SNAPTYPSEL_Mask)<<16));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_SNAPTYPSEL_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_TCR_SNAPTYPSEL_Mask);\
} while(0)

/*#define MAC_TCR_TSMSTRENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSMSTRENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSMSTRENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MAC_TCR_TSMSTRENA_Wr_Mask (ULONG)(0xffff7fff)

#define MAC_TCR_TSMSTRENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSMSTRENA_Wr_Mask) | ((data & MAC_TCR_TSMSTRENA_Mask)<<15));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSMSTRENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 15) & MAC_TCR_TSMSTRENA_Mask);\
} while(0)

/*#define MAC_TCR_TSEVNTENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSEVNTENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSEVNTENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MAC_TCR_TSEVNTENA_Wr_Mask (ULONG)(0xffffbfff)

#define MAC_TCR_TSEVNTENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSEVNTENA_Wr_Mask) | ((data & MAC_TCR_TSEVNTENA_Mask)<<14));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSEVNTENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_TCR_TSEVNTENA_Mask);\
} while(0)

/*#define MAC_TCR_TSIPV4ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPV4ENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSIPV4ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MAC_TCR_TSIPV4ENA_Wr_Mask (ULONG)(0xffffdfff)

#define MAC_TCR_TSIPV4ENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSIPV4ENA_Wr_Mask) | ((data & MAC_TCR_TSIPV4ENA_Mask)<<13));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSIPV4ENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 13) & MAC_TCR_TSIPV4ENA_Mask);\
} while(0)

/*#define MAC_TCR_TSIPV6ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPV6ENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSIPV6ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_TCR_TSIPV6ENA_Wr_Mask (ULONG)(0xffffefff)

#define MAC_TCR_TSIPV6ENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSIPV6ENA_Wr_Mask) | ((data & MAC_TCR_TSIPV6ENA_Mask)<<12));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSIPV6ENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_TCR_TSIPV6ENA_Mask);\
} while(0)

/*#define MAC_TCR_TSIPENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSIPENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSIPENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MAC_TCR_TSIPENA_Wr_Mask (ULONG)(0xfffff7ff)

#define MAC_TCR_TSIPENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSIPENA_Wr_Mask) | ((data & MAC_TCR_TSIPENA_Mask)<<11));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSIPENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_TCR_TSIPENA_Mask);\
} while(0)

/*#define MAC_TCR_TSVER2ENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSVER2ENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSVER2ENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MAC_TCR_TSVER2ENA_Wr_Mask (ULONG)(0xfffffbff)

#define MAC_TCR_TSVER2ENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSVER2ENA_Wr_Mask) | ((data & MAC_TCR_TSVER2ENA_Mask)<<10));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSVER2ENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 10) & MAC_TCR_TSVER2ENA_Mask);\
} while(0)

/*#define MAC_TCR_TSCTRLSSR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSCTRLSSR_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSCTRLSSR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_TCR_TSCTRLSSR_Wr_Mask (ULONG)(0xfffffdff)

#define MAC_TCR_TSCTRLSSR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSCTRLSSR_Wr_Mask) | ((data & MAC_TCR_TSCTRLSSR_Mask)<<9));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSCTRLSSR_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_TCR_TSCTRLSSR_Mask);\
} while(0)

/*#define MAC_TCR_TSENALL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENALL_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSENALL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MAC_TCR_TSENALL_Wr_Mask (ULONG)(0xfffffeff)

#define MAC_TCR_TSENALL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSENALL_Wr_Mask) | ((data & MAC_TCR_TSENALL_Mask)<<8));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSENALL_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_TCR_TSENALL_Mask);\
} while(0)

/*#define MAC_TCR_TSADDREG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSADDREG_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSADDREG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_TCR_TSADDREG_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_TCR_TSADDREG_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSADDREG_Wr_Mask) | ((data & MAC_TCR_TSADDREG_Mask)<<5));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSADDREG_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_TCR_TSADDREG_Mask);\
} while(0)

/*#define MAC_TCR_TSTRIG_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSTRIG_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSTRIG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_TCR_TSTRIG_Wr_Mask (ULONG)(0xffffffef)

#define MAC_TCR_TSTRIG_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSTRIG_Wr_Mask) | ((data & MAC_TCR_TSTRIG_Mask)<<4));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSTRIG_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_TCR_TSTRIG_Mask);\
} while(0)

/*#define MAC_TCR_TSUPDT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSUPDT_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSUPDT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_TCR_TSUPDT_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_TCR_TSUPDT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSUPDT_Wr_Mask) | ((data & MAC_TCR_TSUPDT_Mask)<<3));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSUPDT_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_TCR_TSUPDT_Mask);\
} while(0)

/*#define MAC_TCR_TSINIT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSINIT_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSINIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_TCR_TSINIT_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_TCR_TSINIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSINIT_Wr_Mask) | ((data & MAC_TCR_TSINIT_Mask)<<2));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSINIT_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_TCR_TSINIT_Mask);\
} while(0)

/*#define MAC_TCR_TSCFUPDT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSCFUPDT_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSCFUPDT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_TCR_TSCFUPDT_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_TCR_TSCFUPDT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSCFUPDT_Wr_Mask) | ((data & MAC_TCR_TSCFUPDT_Mask)<<1));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSCFUPDT_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_TCR_TSCFUPDT_Mask);\
} while(0)

/*#define MAC_TCR_TSENA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_TCR_TSENA_Mask (ULONG)(0x1)

/*#define MAC_TCR_TSENA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_TCR_TSENA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_TCR_TSENA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_TCR_RgRd(pdata, v);\
		v = (v & (MAC_TCR_RES_Wr_Mask_29))|((( 0) & (MAC_TCR_Mask_29))<<29);\
		v = (v & (MAC_TCR_RES_Wr_Mask_25))|((( 0) & (MAC_TCR_Mask_25))<<25);\
		v = (v & (MAC_TCR_RES_Wr_Mask_21))|((( 0) & (MAC_TCR_Mask_21))<<21);\
		v = (v & (MAC_TCR_RES_Wr_Mask_19))|((( 0) & (MAC_TCR_Mask_19))<<19);\
		v = (v & (MAC_TCR_RES_Wr_Mask_6))|((( 0) & (MAC_TCR_Mask_6))<<6);\
		v = ((v & MAC_TCR_TSENA_Wr_Mask) | ((data & MAC_TCR_TSENA_Mask)<<0));\
		MAC_TCR_RgWr(pdata, v);\
} while(0)

#define MAC_TCR_TSENA_UdfRd(pdata, data) do {\
		MAC_TCR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TCR_TSENA_Mask);\
} while(0)


#define MTL_DSR_RgOffAddr ((BASE_ADDRESS + 0xc0c))

#define MTL_DSR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_DSR_RgOffAddr));\
} while(0)

#define MTL_DSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_DSR_RgOffAddr));\
} while(0)

/*#define  MTL_DSR_Mask_10 (ULONG)(~(~0<<(6)))*/

#define  MTL_DSR_Mask_10 (ULONG)(0x3f)

/*#define MTL_DSR_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(6)))<<(10)))*/

#define MTL_DSR_RES_Wr_Mask_10 (ULONG)(0xffff03ff)

/*#define  MTL_DSR_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_DSR_Mask_5 (ULONG)(0x7)

/*#define MTL_DSR_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_DSR_RES_Wr_Mask_5 (ULONG)(0xffffff1f)

/*#define MTL_DSR_LOCR_Mask (ULONG)(~(~0<<(16)))*/

#define MTL_DSR_LOCR_Mask (ULONG)(0xffff)

#define MTL_DSR_LOCR_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_DSR_LOCR_Mask);\
} while(0)

/*#define MTL_DSR_STSI_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_STSI_Mask (ULONG)(0x1)

#define MTL_DSR_STSI_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 9) & MTL_DSR_STSI_Mask);\
} while(0)

/*#define MTL_DSR_PKTI_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_PKTI_Mask (ULONG)(0x1)

#define MTL_DSR_PKTI_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_DSR_PKTI_Mask);\
} while(0)

/*#define MTL_DSR_BYTEEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_DSR_BYTEEN_Mask (ULONG)(0x3)

/*#define MTL_DSR_BYTEEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (3)))*/

#define MTL_DSR_BYTEEN_Wr_Mask (ULONG)(0xffffffe7)

#define MTL_DSR_BYTEEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_DSR_RgRd(pdata, v);\
		v = (v & (MTL_DSR_RES_Wr_Mask_10))|((( 0) & (MTL_DSR_Mask_10))<<10);\
		v = (v & (MTL_DSR_RES_Wr_Mask_5))|((( 0) & (MTL_DSR_Mask_5))<<5);\
		v = ((v & MTL_DSR_BYTEEN_Wr_Mask) | ((data & MTL_DSR_BYTEEN_Mask)<<3));\
		MTL_DSR_RgWr(pdata, v);\
} while(0)

#define MTL_DSR_BYTEEN_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_DSR_BYTEEN_Mask);\
} while(0)

/*#define MTL_DSR_PKTSTATE_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_DSR_PKTSTATE_Mask (ULONG)(0x3)

#define MTL_DSR_PKTSTATE_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_DSR_PKTSTATE_Mask);\
} while(0)

/*#define MTL_DSR_FIFOBUSY_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_DSR_FIFOBUSY_Mask (ULONG)(0x1)

#define MTL_DSR_FIFOBUSY_UdfRd(pdata, data) do {\
		MTL_DSR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_DSR_FIFOBUSY_Mask);\
} while(0)


#define MAC_RWPFFR_RgOffAddr ((BASE_ADDRESS + 0xc4))

#define MAC_RWPFFR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RWPFFR_RgOffAddr));\
} while(0)

#define MAC_RWPFFR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RWPFFR_RgOffAddr));\
} while(0)

#define MAC_RWPFFR_MAC_RWPFF_UdfWr(pdata, data) do {\
		MAC_RWPFFR_RgWr(pdata, data);\
} while(0)

#define MAC_RWPFFR_MAC_RWPFF_UdfRd(pdata, data) do {\
		MAC_RWPFFR_RgRd(pdata, data);\
} while(0)


#define MAC_RTSR_RgOffAddr ((BASE_ADDRESS + 0xb8))

#define MAC_RTSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RTSR_RgOffAddr));\
} while(0)

/*#define MAC_RTSR_RWT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_RWT_Mask (ULONG)(0x1)

#define MAC_RTSR_RWT_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RTSR_RWT_Mask);\
} while(0)

/*#define MAC_RTSR_EXCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_EXCOL_Mask (ULONG)(0x1)

#define MAC_RTSR_EXCOL_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_RTSR_EXCOL_Mask);\
} while(0)

/*#define MAC_RTSR_LCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_LCOL_Mask (ULONG)(0x1)

#define MAC_RTSR_LCOL_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_RTSR_LCOL_Mask);\
} while(0)

/*#define MAC_RTSR_EXDEF_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_EXDEF_Mask (ULONG)(0x1)

#define MAC_RTSR_EXDEF_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_RTSR_EXDEF_Mask);\
} while(0)

/*#define MAC_RTSR_LCARR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_LCARR_Mask (ULONG)(0x1)

#define MAC_RTSR_LCARR_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_RTSR_LCARR_Mask);\
} while(0)

/*#define MAC_RTSR_NCARR_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_NCARR_Mask (ULONG)(0x1)

#define MAC_RTSR_NCARR_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_RTSR_NCARR_Mask);\
} while(0)

/*#define MAC_RTSR_TJT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RTSR_TJT_Mask (ULONG)(0x1)

#define MAC_RTSR_TJT_UdfRd(pdata, data) do {\
		MAC_RTSR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RTSR_TJT_Mask);\
} while(0)


#define MTL_IER_RgOffAddr ((BASE_ADDRESS + 0xc1c))

#define MTL_IER_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_IER_RgOffAddr));\
} while(0)

#define MTL_IER_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_IER_RgOffAddr));\
} while(0)

/*#define  MTL_IER_Mask_17 (ULONG)(~(~0<<(15)))*/

#define  MTL_IER_Mask_17 (ULONG)(0x7fff)

/*#define MTL_IER_RES_Wr_Mask_17 (ULONG)(~((~(~0<<(15)))<<(17)))*/

#define MTL_IER_RES_Wr_Mask_17 (ULONG)(0x1ffff)

/*#define MTL_IER_MACIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_MACIE_Mask (ULONG)(0x1)

/*#define MTL_IER_MACIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MTL_IER_MACIE_Wr_Mask (ULONG)(0xfffeffff)

#define MTL_IER_MACIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_MACIE_Wr_Mask) | ((data & MTL_IER_MACIE_Mask)<<16));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_MACIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_IER_MACIE_Mask);\
} while(0)

/*#define MTL_IER_Q7RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q7RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q7RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MTL_IER_Q7RXOIE_Wr_Mask (ULONG)(0xffff7fff)

#define MTL_IER_Q7RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q7RXOIE_Wr_Mask) | ((data & MTL_IER_Q7RXOIE_Mask)<<15));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q7RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 15) & MTL_IER_Q7RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q7TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q7TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q7TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MTL_IER_Q7TXUIE_Wr_Mask (ULONG)(0xffffbfff)

#define MTL_IER_Q7TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q7TXUIE_Wr_Mask) | ((data & MTL_IER_Q7TXUIE_Mask)<<14));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q7TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 14) & MTL_IER_Q7TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q6RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q6RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q6RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MTL_IER_Q6RXOIE_Wr_Mask (ULONG)(0xffffdfff)

#define MTL_IER_Q6RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q6RXOIE_Wr_Mask) | ((data & MTL_IER_Q6RXOIE_Mask)<<13));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q6RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 13) & MTL_IER_Q6RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q6TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q6TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q6TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_IER_Q6TXUIE_Wr_Mask (ULONG)(0xffffefff)

#define MTL_IER_Q6TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q6TXUIE_Wr_Mask) | ((data & MTL_IER_Q6TXUIE_Mask)<<12));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q6TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 12) & MTL_IER_Q6TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q5RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q5RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q5RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_IER_Q5RXOIE_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_IER_Q5RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q5RXOIE_Wr_Mask) | ((data & MTL_IER_Q5RXOIE_Mask)<<11));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q5RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_IER_Q5RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q5TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q5TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q5TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MTL_IER_Q5TXUIE_Wr_Mask (ULONG)(0xfffffbff)

#define MTL_IER_Q5TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q5TXUIE_Wr_Mask) | ((data & MTL_IER_Q5TXUIE_Mask)<<10));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q5TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 10) & MTL_IER_Q5TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q4RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q4RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q4RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MTL_IER_Q4RXOIE_Wr_Mask (ULONG)(0xfffffdff)

#define MTL_IER_Q4RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q4RXOIE_Wr_Mask) | ((data & MTL_IER_Q4RXOIE_Mask)<<9));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q4RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 9) & MTL_IER_Q4RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q4TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q4TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q4TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MTL_IER_Q4TXUIE_Wr_Mask (ULONG)(0xfffffeff)

#define MTL_IER_Q4TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q4TXUIE_Wr_Mask) | ((data & MTL_IER_Q4TXUIE_Mask)<<8));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q4TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_IER_Q4TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q3RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q3RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q3RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MTL_IER_Q3RXOIE_Wr_Mask (ULONG)(0xffffff7f)

#define MTL_IER_Q3RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q3RXOIE_Wr_Mask) | ((data & MTL_IER_Q3RXOIE_Mask)<<7));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q3RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 7) & MTL_IER_Q3RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q3TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q3TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q3TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MTL_IER_Q3TXUIE_Wr_Mask (ULONG)(0xffffffbf)

#define MTL_IER_Q3TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q3TXUIE_Wr_Mask) | ((data & MTL_IER_Q3TXUIE_Mask)<<6));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q3TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 6) & MTL_IER_Q3TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q2RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q2RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q2RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MTL_IER_Q2RXOIE_Wr_Mask (ULONG)(0xffffffdf)

#define MTL_IER_Q2RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q2RXOIE_Wr_Mask) | ((data & MTL_IER_Q2RXOIE_Mask)<<5));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q2RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_IER_Q2RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q2TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q2TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q2TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_IER_Q2TXUIE_Wr_Mask (ULONG)(0xffffffef)

#define MTL_IER_Q2TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q2TXUIE_Wr_Mask) | ((data & MTL_IER_Q2TXUIE_Mask)<<4));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q2TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_IER_Q2TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q1RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q1RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q1RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_IER_Q1RXOIE_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_IER_Q1RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q1RXOIE_Wr_Mask) | ((data & MTL_IER_Q1RXOIE_Mask)<<3));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q1RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_IER_Q1RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q1TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q1TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q1TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_IER_Q1TXUIE_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_IER_Q1TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q1TXUIE_Wr_Mask) | ((data & MTL_IER_Q1TXUIE_Mask)<<2));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q1TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_IER_Q1TXUIE_Mask);\
} while(0)

/*#define MTL_IER_Q0RXOIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q0RXOIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q0RXOIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_IER_Q0RXOIE_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_IER_Q0RXOIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q0RXOIE_Wr_Mask) | ((data & MTL_IER_Q0RXOIE_Mask)<<1));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q0RXOIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_IER_Q0RXOIE_Mask);\
} while(0)

/*#define MTL_IER_Q0TXUIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_IER_Q0TXUIE_Mask (ULONG)(0x1)

/*#define MTL_IER_Q0TXUIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_IER_Q0TXUIE_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_IER_Q0TXUIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_IER_RgRd(pdata, v);\
		v = (v & (MTL_IER_RES_Wr_Mask_17))|((( 0) & (MTL_IER_Mask_17))<<17);\
		v = ((v & MTL_IER_Q0TXUIE_Wr_Mask) | ((data & MTL_IER_Q0TXUIE_Mask)<<0));\
		MTL_IER_RgWr(pdata, v);\
} while(0)

#define MTL_IER_Q0TXUIE_UdfRd(pdata, data) do {\
		MTL_IER_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_IER_Q0TXUIE_Mask);\
} while(0)


#define MTL_QRCR7_RgOffAddr ((BASE_ADDRESS + 0xefc))

#define MTL_QRCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR7_RgOffAddr));\
} while(0)

#define MTL_QRCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR7_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR7_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR7_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR7_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR7_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR7_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR7_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR7_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR7_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR7_RgRd(pdata, v);\
		v = (v & (MTL_QRCR7_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR7_Mask_4))<<4);\
		v = ((v & MTL_QRCR7_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR7_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR7_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR7_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR7_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR7_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR7_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR7_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR7_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR7_RgRd(pdata, v);\
		v = (v & (MTL_QRCR7_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR7_Mask_4))<<4);\
		v = ((v & MTL_QRCR7_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR7_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR7_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR7_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR7_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR6_RgOffAddr ((BASE_ADDRESS + 0xebc))

#define MTL_QRCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR6_RgOffAddr));\
} while(0)

#define MTL_QRCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR6_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR6_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR6_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR6_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR6_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR6_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR6_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR6_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR6_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR6_RgRd(pdata, v);\
		v = (v & (MTL_QRCR6_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR6_Mask_4))<<4);\
		v = ((v & MTL_QRCR6_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR6_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR6_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR6_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR6_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR6_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR6_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR6_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR6_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR6_RgRd(pdata, v);\
		v = (v & (MTL_QRCR6_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR6_Mask_4))<<4);\
		v = ((v & MTL_QRCR6_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR6_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR6_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR6_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR6_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR5_RgOffAddr ((BASE_ADDRESS + 0xe7c))

#define MTL_QRCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR5_RgOffAddr));\
} while(0)

#define MTL_QRCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR5_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR5_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR5_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR5_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR5_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR5_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR5_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR5_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR5_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR5_RgRd(pdata, v);\
		v = (v & (MTL_QRCR5_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR5_Mask_4))<<4);\
		v = ((v & MTL_QRCR5_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR5_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR5_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR5_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR5_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR5_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR5_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR5_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR5_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR5_RgRd(pdata, v);\
		v = (v & (MTL_QRCR5_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR5_Mask_4))<<4);\
		v = ((v & MTL_QRCR5_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR5_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR5_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR5_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR5_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR4_RgOffAddr ((BASE_ADDRESS + 0xe3c))

#define MTL_QRCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR4_RgOffAddr));\
} while(0)

#define MTL_QRCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR4_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR4_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR4_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR4_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR4_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR4_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR4_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR4_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR4_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR4_RgRd(pdata, v);\
		v = (v & (MTL_QRCR4_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR4_Mask_4))<<4);\
		v = ((v & MTL_QRCR4_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR4_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR4_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR4_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR4_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR4_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR4_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR4_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR4_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR4_RgRd(pdata, v);\
		v = (v & (MTL_QRCR4_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR4_Mask_4))<<4);\
		v = ((v & MTL_QRCR4_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR4_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR4_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR4_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR4_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR3_RgOffAddr ((BASE_ADDRESS + 0xdfc))

#define MTL_QRCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR3_RgOffAddr));\
} while(0)

#define MTL_QRCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR3_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR3_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR3_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR3_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR3_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR3_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR3_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR3_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR3_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR3_RgRd(pdata, v);\
		v = (v & (MTL_QRCR3_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR3_Mask_4))<<4);\
		v = ((v & MTL_QRCR3_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR3_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR3_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR3_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR3_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR3_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR3_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR3_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR3_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR3_RgRd(pdata, v);\
		v = (v & (MTL_QRCR3_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR3_Mask_4))<<4);\
		v = ((v & MTL_QRCR3_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR3_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR3_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR3_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR3_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR2_RgOffAddr ((BASE_ADDRESS + 0xdbc))

#define MTL_QRCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR2_RgOffAddr));\
} while(0)

#define MTL_QRCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR2_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR2_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR2_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR2_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR2_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR2_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR2_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR2_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR2_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR2_RgRd(pdata, v);\
		v = (v & (MTL_QRCR2_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR2_Mask_4))<<4);\
		v = ((v & MTL_QRCR2_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR2_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR2_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR2_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR2_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR2_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR2_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR2_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR2_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR2_RgRd(pdata, v);\
		v = (v & (MTL_QRCR2_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR2_Mask_4))<<4);\
		v = ((v & MTL_QRCR2_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR2_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR2_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR2_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR2_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRCR1_RgOffAddr ((BASE_ADDRESS + 0xd7c))

#define MTL_QRCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QRCR1_RgOffAddr));\
} while(0)

#define MTL_QRCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QRCR1_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_QRCR1_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_QRCR1_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_QRCR1_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_QRCR1_RXQ_WEGT_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QRCR1_RXQ_WEGT_Mask (ULONG)(0x7)

/*#define MTL_QRCR1_RXQ_WEGT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_QRCR1_RXQ_WEGT_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_QRCR1_RXQ_WEGT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR1_RgRd(pdata, v);\
		v = (v & (MTL_QRCR1_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR1_Mask_4))<<4);\
		v = ((v & MTL_QRCR1_RXQ_WEGT_Wr_Mask) | ((data & MTL_QRCR1_RXQ_WEGT_Mask)<<0));\
		MTL_QRCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR1_RXQ_WEGT_UdfRd(pdata, data) do {\
		MTL_QRCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRCR1_RXQ_WEGT_Mask);\
} while(0)

/*#define MTL_QRCR1_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRCR1_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_QRCR1_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QRCR1_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QRCR1_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QRCR1_RgRd(pdata, v);\
		v = (v & (MTL_QRCR1_RES_Wr_Mask_4))|((( 0) & (MTL_QRCR1_Mask_4))<<4);\
		v = ((v & MTL_QRCR1_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_QRCR1_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_QRCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QRCR1_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_QRCR1_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QRCR1_RXQ_PKT_ARBIT_Mask);\
} while(0)


#define MTL_QRDR7_RgOffAddr ((BASE_ADDRESS + 0xef8))

#define MTL_QRDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR7_RgOffAddr));\
} while(0)

/*#define MTL_QRDR7_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR7_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR7_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR7_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR7_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR7_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR7_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR7_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR7_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR7_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR7_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR7_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR7_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR7_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR7_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR7_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR7_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR7_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR7_PRXQ_Mask);\
} while(0)


#define MTL_QRDR6_RgOffAddr ((BASE_ADDRESS + 0xeb8))

#define MTL_QRDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR6_RgOffAddr));\
} while(0)

/*#define MTL_QRDR6_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR6_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR6_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR6_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR6_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR6_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR6_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR6_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR6_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR6_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR6_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR6_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR6_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR6_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR6_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR6_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR6_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR6_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR6_PRXQ_Mask);\
} while(0)


#define MTL_QRDR5_RgOffAddr ((BASE_ADDRESS + 0xe78))

#define MTL_QRDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR5_RgOffAddr));\
} while(0)

/*#define MTL_QRDR5_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR5_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR5_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR5_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR5_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR5_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR5_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR5_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR5_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR5_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR5_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR5_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR5_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR5_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR5_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR5_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR5_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR5_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR5_PRXQ_Mask);\
} while(0)


#define MTL_QRDR4_RgOffAddr ((BASE_ADDRESS + 0xe38))

#define MTL_QRDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR4_RgOffAddr));\
} while(0)

/*#define MTL_QRDR4_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR4_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR4_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR4_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR4_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR4_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR4_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR4_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR4_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR4_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR4_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR4_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR4_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR4_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR4_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR4_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR4_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR4_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR4_PRXQ_Mask);\
} while(0)


#define MTL_QRDR3_RgOffAddr ((BASE_ADDRESS + 0xdf8))

#define MTL_QRDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR3_RgOffAddr));\
} while(0)

/*#define MTL_QRDR3_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR3_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR3_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR3_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR3_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR3_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR3_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR3_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR3_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR3_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR3_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR3_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR3_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR3_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR3_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR3_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR3_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR3_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR3_PRXQ_Mask);\
} while(0)


#define MTL_QRDR2_RgOffAddr ((BASE_ADDRESS + 0xdb8))

#define MTL_QRDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR2_RgOffAddr));\
} while(0)

/*#define MTL_QRDR2_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR2_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR2_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR2_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR2_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR2_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR2_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR2_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR2_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR2_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR2_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR2_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR2_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR2_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR2_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR2_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR2_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR2_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR2_PRXQ_Mask);\
} while(0)


#define MTL_QRDR1_RgOffAddr ((BASE_ADDRESS + 0xd78))

#define MTL_QRDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QRDR1_RgOffAddr));\
} while(0)

/*#define MTL_QRDR1_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QRDR1_RWCSTS_Mask (ULONG)(0x1)

#define MTL_QRDR1_RWCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QRDR1_RWCSTS_Mask);\
} while(0)

/*#define MTL_QRDR1_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR1_RRCSTS_Mask (ULONG)(0x3)

#define MTL_QRDR1_RRCSTS_UdfRd(pdata, data) do {\
		MTL_QRDR1_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QRDR1_RRCSTS_Mask);\
} while(0)

/*#define MTL_QRDR1_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QRDR1_RXQSTS_Mask (ULONG)(0x3)

#define MTL_QRDR1_RXQSTS_UdfRd(pdata, data) do {\
		MTL_QRDR1_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QRDR1_RXQSTS_Mask);\
} while(0)

/*#define MTL_QRDR1_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QRDR1_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_QRDR1_PRXQ_UdfRd(pdata, data) do {\
		MTL_QRDR1_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QRDR1_PRXQ_Mask);\
} while(0)


#define MTL_QOCR7_RgOffAddr ((BASE_ADDRESS + 0xef4))

#define MTL_QOCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR7_RgOffAddr));\
} while(0)

#define MTL_QOCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR7_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR7_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR7_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR7_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR7_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR7_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR7_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR7_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR7_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR7_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR7_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR7_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR7_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR7_RgRd(pdata, v);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR7_Mask_12))<<12);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR7_Mask_28))<<28);\
		v = ((v & MTL_QOCR7_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR7_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR7_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR7_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR7_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR7_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR7_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR7_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR7_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR7_RgRd(pdata, v);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR7_Mask_12))<<12);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR7_Mask_28))<<28);\
		v = ((v & MTL_QOCR7_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR7_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR7_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR7_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR7_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR7_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR7_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR7_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR7_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR7_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR7_RgRd(pdata, v);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR7_Mask_12))<<12);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR7_Mask_28))<<28);\
		v = ((v & MTL_QOCR7_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR7_MISPKTCNT_Mask)<<16));\
		MTL_QOCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR7_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR7_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR7_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR7_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR7_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR7_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR7_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR7_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR7_RgRd(pdata, v);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR7_Mask_12))<<12);\
		v = (v & (MTL_QOCR7_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR7_Mask_28))<<28);\
		v = ((v & MTL_QOCR7_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR7_MISCNTOVF_Mask)<<27));\
		MTL_QOCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR7_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR7_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR7_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR6_RgOffAddr ((BASE_ADDRESS + 0xeb4))

#define MTL_QOCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR6_RgOffAddr));\
} while(0)

#define MTL_QOCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR6_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR6_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR6_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR6_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR6_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR6_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR6_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR6_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR6_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR6_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR6_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR6_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR6_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR6_RgRd(pdata, v);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR6_Mask_12))<<12);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR6_Mask_28))<<28);\
		v = ((v & MTL_QOCR6_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR6_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR6_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR6_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR6_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR6_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR6_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR6_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR6_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR6_RgRd(pdata, v);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR6_Mask_12))<<12);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR6_Mask_28))<<28);\
		v = ((v & MTL_QOCR6_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR6_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR6_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR6_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR6_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR6_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR6_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR6_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR6_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR6_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR6_RgRd(pdata, v);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR6_Mask_12))<<12);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR6_Mask_28))<<28);\
		v = ((v & MTL_QOCR6_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR6_MISPKTCNT_Mask)<<16));\
		MTL_QOCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR6_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR6_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR6_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR6_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR6_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR6_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR6_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR6_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR6_RgRd(pdata, v);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR6_Mask_12))<<12);\
		v = (v & (MTL_QOCR6_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR6_Mask_28))<<28);\
		v = ((v & MTL_QOCR6_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR6_MISCNTOVF_Mask)<<27));\
		MTL_QOCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR6_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR6_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR6_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR5_RgOffAddr ((BASE_ADDRESS + 0xe74))

#define MTL_QOCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR5_RgOffAddr));\
} while(0)

#define MTL_QOCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR5_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR5_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR5_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR5_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR5_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR5_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR5_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR5_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR5_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR5_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR5_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR5_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR5_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR5_RgRd(pdata, v);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR5_Mask_12))<<12);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR5_Mask_28))<<28);\
		v = ((v & MTL_QOCR5_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR5_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR5_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR5_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR5_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR5_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR5_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR5_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR5_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR5_RgRd(pdata, v);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR5_Mask_12))<<12);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR5_Mask_28))<<28);\
		v = ((v & MTL_QOCR5_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR5_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR5_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR5_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR5_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR5_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR5_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR5_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR5_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR5_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR5_RgRd(pdata, v);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR5_Mask_12))<<12);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR5_Mask_28))<<28);\
		v = ((v & MTL_QOCR5_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR5_MISPKTCNT_Mask)<<16));\
		MTL_QOCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR5_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR5_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR5_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR5_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR5_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR5_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR5_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR5_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR5_RgRd(pdata, v);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR5_Mask_12))<<12);\
		v = (v & (MTL_QOCR5_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR5_Mask_28))<<28);\
		v = ((v & MTL_QOCR5_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR5_MISCNTOVF_Mask)<<27));\
		MTL_QOCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR5_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR5_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR5_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR4_RgOffAddr ((BASE_ADDRESS + 0xe34))

#define MTL_QOCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR4_RgOffAddr));\
} while(0)

#define MTL_QOCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR4_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR4_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR4_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR4_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR4_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR4_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR4_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR4_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR4_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR4_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR4_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR4_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR4_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR4_RgRd(pdata, v);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR4_Mask_12))<<12);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR4_Mask_28))<<28);\
		v = ((v & MTL_QOCR4_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR4_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR4_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR4_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR4_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR4_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR4_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR4_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR4_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR4_RgRd(pdata, v);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR4_Mask_12))<<12);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR4_Mask_28))<<28);\
		v = ((v & MTL_QOCR4_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR4_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR4_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR4_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR4_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR4_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR4_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR4_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR4_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR4_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR4_RgRd(pdata, v);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR4_Mask_12))<<12);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR4_Mask_28))<<28);\
		v = ((v & MTL_QOCR4_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR4_MISPKTCNT_Mask)<<16));\
		MTL_QOCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR4_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR4_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR4_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR4_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR4_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR4_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR4_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR4_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR4_RgRd(pdata, v);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR4_Mask_12))<<12);\
		v = (v & (MTL_QOCR4_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR4_Mask_28))<<28);\
		v = ((v & MTL_QOCR4_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR4_MISCNTOVF_Mask)<<27));\
		MTL_QOCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR4_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR4_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR4_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR3_RgOffAddr ((BASE_ADDRESS + 0xdf4))

#define MTL_QOCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR3_RgOffAddr));\
} while(0)

#define MTL_QOCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR3_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR3_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR3_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR3_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR3_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR3_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR3_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR3_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR3_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR3_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR3_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR3_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR3_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR3_RgRd(pdata, v);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR3_Mask_12))<<12);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR3_Mask_28))<<28);\
		v = ((v & MTL_QOCR3_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR3_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR3_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR3_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR3_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR3_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR3_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR3_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR3_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR3_RgRd(pdata, v);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR3_Mask_12))<<12);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR3_Mask_28))<<28);\
		v = ((v & MTL_QOCR3_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR3_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR3_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR3_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR3_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR3_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR3_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR3_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR3_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR3_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR3_RgRd(pdata, v);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR3_Mask_12))<<12);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR3_Mask_28))<<28);\
		v = ((v & MTL_QOCR3_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR3_MISPKTCNT_Mask)<<16));\
		MTL_QOCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR3_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR3_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR3_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR3_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR3_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR3_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR3_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR3_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR3_RgRd(pdata, v);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR3_Mask_12))<<12);\
		v = (v & (MTL_QOCR3_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR3_Mask_28))<<28);\
		v = ((v & MTL_QOCR3_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR3_MISCNTOVF_Mask)<<27));\
		MTL_QOCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR3_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR3_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR3_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR2_RgOffAddr ((BASE_ADDRESS + 0xdb4))

#define MTL_QOCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR2_RgOffAddr));\
} while(0)

#define MTL_QOCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR2_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR2_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR2_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR2_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR2_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR2_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR2_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR2_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR2_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR2_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR2_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR2_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR2_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR2_RgRd(pdata, v);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR2_Mask_12))<<12);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR2_Mask_28))<<28);\
		v = ((v & MTL_QOCR2_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR2_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR2_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR2_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR2_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR2_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR2_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR2_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR2_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR2_RgRd(pdata, v);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR2_Mask_12))<<12);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR2_Mask_28))<<28);\
		v = ((v & MTL_QOCR2_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR2_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR2_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR2_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR2_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR2_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR2_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR2_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR2_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR2_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR2_RgRd(pdata, v);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR2_Mask_12))<<12);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR2_Mask_28))<<28);\
		v = ((v & MTL_QOCR2_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR2_MISPKTCNT_Mask)<<16));\
		MTL_QOCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR2_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR2_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR2_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR2_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR2_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR2_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR2_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR2_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR2_RgRd(pdata, v);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR2_Mask_12))<<12);\
		v = (v & (MTL_QOCR2_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR2_Mask_28))<<28);\
		v = ((v & MTL_QOCR2_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR2_MISCNTOVF_Mask)<<27));\
		MTL_QOCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR2_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR2_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR2_MISCNTOVF_Mask);\
} while(0)


#define MTL_QOCR1_RgOffAddr ((BASE_ADDRESS + 0xd74))

#define MTL_QOCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QOCR1_RgOffAddr));\
} while(0)

#define MTL_QOCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QOCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QOCR1_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR1_Mask_12 (ULONG)(0xf)

/*#define MTL_QOCR1_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MTL_QOCR1_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MTL_QOCR1_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MTL_QOCR1_Mask_28 (ULONG)(0xf)

/*#define MTL_QOCR1_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MTL_QOCR1_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define MTL_QOCR1_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR1_OVFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR1_OVFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QOCR1_OVFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QOCR1_OVFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR1_RgRd(pdata, v);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR1_Mask_12))<<12);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR1_Mask_28))<<28);\
		v = ((v & MTL_QOCR1_OVFPKTCNT_Wr_Mask) | ((data & MTL_QOCR1_OVFPKTCNT_Mask)<<0));\
		MTL_QOCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR1_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QOCR1_OVFPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR1_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR1_OVFCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR1_OVFCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_QOCR1_OVFCNTOVF_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_QOCR1_OVFCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR1_RgRd(pdata, v);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR1_Mask_12))<<12);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR1_Mask_28))<<28);\
		v = ((v & MTL_QOCR1_OVFCNTOVF_Wr_Mask) | ((data & MTL_QOCR1_OVFCNTOVF_Mask)<<11));\
		MTL_QOCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR1_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR1_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QOCR1_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_QOCR1_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QOCR1_MISPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QOCR1_MISPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (16)))*/

#define MTL_QOCR1_MISPKTCNT_Wr_Mask (ULONG)(0xf800ffff)

#define MTL_QOCR1_MISPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR1_RgRd(pdata, v);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR1_Mask_12))<<12);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR1_Mask_28))<<28);\
		v = ((v & MTL_QOCR1_MISPKTCNT_Wr_Mask) | ((data & MTL_QOCR1_MISPKTCNT_Mask)<<16));\
		MTL_QOCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR1_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_QOCR1_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QOCR1_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_QOCR1_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QOCR1_MISCNTOVF_Mask (ULONG)(0x1)

/*#define MTL_QOCR1_MISCNTOVF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MTL_QOCR1_MISCNTOVF_Wr_Mask (ULONG)(0xf7ffffff)

#define MTL_QOCR1_MISCNTOVF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QOCR1_RgRd(pdata, v);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_12))|((( 0) & (MTL_QOCR1_Mask_12))<<12);\
		v = (v & (MTL_QOCR1_RES_Wr_Mask_28))|((( 0) & (MTL_QOCR1_Mask_28))<<28);\
		v = ((v & MTL_QOCR1_MISCNTOVF_Wr_Mask) | ((data & MTL_QOCR1_MISCNTOVF_Mask)<<27));\
		MTL_QOCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QOCR1_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_QOCR1_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_QOCR1_MISCNTOVF_Mask);\
} while(0)

#define MTL_QLCR7_RgOffAddr ((BASE_ADDRESS + 0xee4))

#define MTL_QLCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR7_RgOffAddr));\
} while(0)

#define MTL_QLCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR7_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR7_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR7_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR7_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR7_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR7_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR7_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR7_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR7_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR7_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR7_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR7_LC_Wr_Mask) | ((data & MTL_QLCR7_LC_Mask)<<0));\
		MTL_QLCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR7_LC_UdfRd(pdata, data) do {\
		MTL_QLCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR7_LC_Mask);\
} while(0)


#define MTL_QLCR6_RgOffAddr ((BASE_ADDRESS + 0xea4))

#define MTL_QLCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR6_RgOffAddr));\
} while(0)

#define MTL_QLCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR6_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR6_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR6_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR6_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR6_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR6_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR6_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR6_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR6_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR6_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR6_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR6_LC_Wr_Mask) | ((data & MTL_QLCR6_LC_Mask)<<0));\
		MTL_QLCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR6_LC_UdfRd(pdata, data) do {\
		MTL_QLCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR6_LC_Mask);\
} while(0)


#define MTL_QLCR5_RgOffAddr ((BASE_ADDRESS + 0xe64))

#define MTL_QLCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR5_RgOffAddr));\
} while(0)

#define MTL_QLCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR5_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR5_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR5_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR5_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR5_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR5_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR5_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR5_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR5_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR5_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR5_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR5_LC_Wr_Mask) | ((data & MTL_QLCR5_LC_Mask)<<0));\
		MTL_QLCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR5_LC_UdfRd(pdata, data) do {\
		MTL_QLCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR5_LC_Mask);\
} while(0)


#define MTL_QLCR4_RgOffAddr ((BASE_ADDRESS + 0xe24))

#define MTL_QLCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR4_RgOffAddr));\
} while(0)

#define MTL_QLCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR4_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR4_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR4_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR4_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR4_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR4_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR4_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR4_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR4_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR4_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR4_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR4_LC_Wr_Mask) | ((data & MTL_QLCR4_LC_Mask)<<0));\
		MTL_QLCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR4_LC_UdfRd(pdata, data) do {\
		MTL_QLCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR4_LC_Mask);\
} while(0)


#define MTL_QLCR3_RgOffAddr ((BASE_ADDRESS + 0xde4))

#define MTL_QLCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR3_RgOffAddr));\
} while(0)

#define MTL_QLCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR3_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR3_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR3_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR3_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR3_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR3_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR3_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR3_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR3_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR3_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR3_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR3_LC_Wr_Mask) | ((data & MTL_QLCR3_LC_Mask)<<0));\
		MTL_QLCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR3_LC_UdfRd(pdata, data) do {\
		MTL_QLCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR3_LC_Mask);\
} while(0)


#define MTL_QLCR2_RgOffAddr ((BASE_ADDRESS + 0xda4))

#define MTL_QLCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR2_RgOffAddr));\
} while(0)

#define MTL_QLCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR2_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR2_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR2_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR2_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR2_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR2_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR2_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR2_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR2_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR2_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR2_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR2_LC_Wr_Mask) | ((data & MTL_QLCR2_LC_Mask)<<0));\
		MTL_QLCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR2_LC_UdfRd(pdata, data) do {\
		MTL_QLCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR2_LC_Mask);\
} while(0)


#define MTL_QLCR1_RgOffAddr ((BASE_ADDRESS + 0xd64))

#define MTL_QLCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QLCR1_RgOffAddr));\
} while(0)

#define MTL_QLCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QLCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QLCR1_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QLCR1_Mask_29 (ULONG)(0x7)

/*#define MTL_QLCR1_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QLCR1_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QLCR1_LC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QLCR1_LC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QLCR1_LC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QLCR1_LC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QLCR1_LC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QLCR1_RES_Wr_Mask_29))|((( 0) & (MTL_QLCR1_Mask_29))<<29);\
		(v) = ((v & MTL_QLCR1_LC_Wr_Mask) | ((data & MTL_QLCR1_LC_Mask)<<0));\
		MTL_QLCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QLCR1_LC_UdfRd(pdata, data) do {\
		MTL_QLCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QLCR1_LC_Mask);\
} while(0)


#define MTL_QHCR7_RgOffAddr ((BASE_ADDRESS + 0xee0))

#define MTL_QHCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR7_RgOffAddr));\
} while(0)

#define MTL_QHCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR7_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR7_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR7_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR7_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR7_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR7_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR7_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR7_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR7_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR7_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR7_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR7_HC_Wr_Mask) | ((data & MTL_QHCR7_HC_Mask)<<0));\
		MTL_QHCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR7_HC_UdfRd(pdata, data) do {\
		MTL_QHCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR7_HC_Mask);\
} while(0)


#define MTL_QHCR6_RgOffAddr ((BASE_ADDRESS + 0xea0))

#define MTL_QHCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR6_RgOffAddr));\
} while(0)

#define MTL_QHCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR6_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR6_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR6_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR6_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR6_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR6_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR6_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR6_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR6_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR6_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR6_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR6_HC_Wr_Mask) | ((data & MTL_QHCR6_HC_Mask)<<0));\
		MTL_QHCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR6_HC_UdfRd(pdata, data) do {\
		MTL_QHCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR6_HC_Mask);\
} while(0)


#define MTL_QHCR5_RgOffAddr ((BASE_ADDRESS + 0xe60))

#define MTL_QHCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR5_RgOffAddr));\
} while(0)

#define MTL_QHCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR5_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR5_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR5_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR5_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR5_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR5_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR5_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR5_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR5_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR5_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR5_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR5_HC_Wr_Mask) | ((data & MTL_QHCR5_HC_Mask)<<0));\
		MTL_QHCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR5_HC_UdfRd(pdata, data) do {\
		MTL_QHCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR5_HC_Mask);\
} while(0)


#define MTL_QHCR4_RgOffAddr ((BASE_ADDRESS + 0xe20))

#define MTL_QHCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR4_RgOffAddr));\
} while(0)

#define MTL_QHCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR4_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR4_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR4_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR4_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR4_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR4_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR4_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR4_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR4_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR4_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR4_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR4_HC_Wr_Mask) | ((data & MTL_QHCR4_HC_Mask)<<0));\
		MTL_QHCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR4_HC_UdfRd(pdata, data) do {\
		MTL_QHCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR4_HC_Mask);\
} while(0)


#define MTL_QHCR3_RgOffAddr ((BASE_ADDRESS + 0xde0))

#define MTL_QHCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR3_RgOffAddr));\
} while(0)

#define MTL_QHCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR3_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR3_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR3_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR3_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR3_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR3_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR3_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR3_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR3_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR3_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR3_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR3_HC_Wr_Mask) | ((data & MTL_QHCR3_HC_Mask)<<0));\
		MTL_QHCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR3_HC_UdfRd(pdata, data) do {\
		MTL_QHCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR3_HC_Mask);\
} while(0)


#define MTL_QHCR2_RgOffAddr ((BASE_ADDRESS + 0xda0))

#define MTL_QHCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR2_RgOffAddr));\
} while(0)

#define MTL_QHCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR2_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR2_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR2_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR2_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR2_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR2_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR2_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR2_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR2_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR2_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR2_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR2_HC_Wr_Mask) | ((data & MTL_QHCR2_HC_Mask)<<0));\
		MTL_QHCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR2_HC_UdfRd(pdata, data) do {\
		MTL_QHCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR2_HC_Mask);\
} while(0)


#define MTL_QHCR1_RgOffAddr ((BASE_ADDRESS + 0xd60))

#define MTL_QHCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QHCR1_RgOffAddr));\
} while(0)

#define MTL_QHCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QHCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QHCR1_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_QHCR1_Mask_29 (ULONG)(0x7)

/*#define MTL_QHCR1_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_QHCR1_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define MTL_QHCR1_HC_Mask (ULONG)(~(~0<<(29)))*/

#define MTL_QHCR1_HC_Mask (ULONG)(0x1fffffff)

/*#define MTL_QHCR1_HC_Wr_Mask (ULONG)(~((~(~0 << (29))) << (0)))*/

#define MTL_QHCR1_HC_Wr_Mask (ULONG)(0xe0000000)

#define MTL_QHCR1_HC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QHCR1_RES_Wr_Mask_29))|((( 0) & (MTL_QHCR1_Mask_29))<<29);\
		(v) = ((v & MTL_QHCR1_HC_Wr_Mask) | ((data & MTL_QHCR1_HC_Mask)<<0));\
		MTL_QHCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QHCR1_HC_UdfRd(pdata, data) do {\
		MTL_QHCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QHCR1_HC_Mask);\
} while(0)


#define MTL_QSSCR7_RgOffAddr ((BASE_ADDRESS + 0xedc))

#define MTL_QSSCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR7_RgOffAddr));\
} while(0)

#define MTL_QSSCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR7_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR7_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR7_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR7_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR7_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR7_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR7_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR7_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR7_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR7_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR7_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR7_SSC_Wr_Mask) | ((data & MTL_QSSCR7_SSC_Mask)<<0));\
		MTL_QSSCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR7_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR7_SSC_Mask);\
} while(0)


#define MTL_QSSCR6_RgOffAddr ((BASE_ADDRESS + 0xe9c))

#define MTL_QSSCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR6_RgOffAddr));\
} while(0)

#define MTL_QSSCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR6_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR6_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR6_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR6_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR6_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR6_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR6_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR6_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR6_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR6_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR6_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR6_SSC_Wr_Mask) | ((data & MTL_QSSCR6_SSC_Mask)<<0));\
		MTL_QSSCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR6_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR6_SSC_Mask);\
} while(0)


#define MTL_QSSCR5_RgOffAddr ((BASE_ADDRESS + 0xe5c))

#define MTL_QSSCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR5_RgOffAddr));\
} while(0)

#define MTL_QSSCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR5_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR5_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR5_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR5_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR5_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR5_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR5_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR5_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR5_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR5_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR5_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR5_SSC_Wr_Mask) | ((data & MTL_QSSCR5_SSC_Mask)<<0));\
		MTL_QSSCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR5_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR5_SSC_Mask);\
} while(0)


#define MTL_QSSCR4_RgOffAddr ((BASE_ADDRESS + 0xe1c))

#define MTL_QSSCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR4_RgOffAddr));\
} while(0)

#define MTL_QSSCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR4_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR4_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR4_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR4_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR4_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR4_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR4_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR4_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR4_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR4_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR4_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR4_SSC_Wr_Mask) | ((data & MTL_QSSCR4_SSC_Mask)<<0));\
		MTL_QSSCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR4_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR4_SSC_Mask);\
} while(0)


#define MTL_QSSCR3_RgOffAddr ((BASE_ADDRESS + 0xddc))

#define MTL_QSSCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR3_RgOffAddr));\
} while(0)

#define MTL_QSSCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR3_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR3_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR3_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR3_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR3_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR3_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR3_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR3_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR3_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR3_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR3_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR3_SSC_Wr_Mask) | ((data & MTL_QSSCR3_SSC_Mask)<<0));\
		MTL_QSSCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR3_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR3_SSC_Mask);\
} while(0)


#define MTL_QSSCR2_RgOffAddr ((BASE_ADDRESS + 0xd9c))

#define MTL_QSSCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR2_RgOffAddr));\
} while(0)

#define MTL_QSSCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR2_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR2_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR2_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR2_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR2_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR2_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR2_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR2_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR2_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR2_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR2_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR2_SSC_Wr_Mask) | ((data & MTL_QSSCR2_SSC_Mask)<<0));\
		MTL_QSSCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR2_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR2_SSC_Mask);\
} while(0)


#define MTL_QSSCR1_RgOffAddr ((BASE_ADDRESS + 0xd5c))

#define MTL_QSSCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QSSCR1_RgOffAddr));\
} while(0)

#define MTL_QSSCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QSSCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QSSCR1_Mask_14 (ULONG)(~(~0<<(18)))*/

#define  MTL_QSSCR1_Mask_14 (ULONG)(0x3ffff)

/*#define MTL_QSSCR1_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(18)))<<(14)))*/

#define MTL_QSSCR1_RES_Wr_Mask_14 (ULONG)(0x3fff)

/*#define MTL_QSSCR1_SSC_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_QSSCR1_SSC_Mask (ULONG)(0x3fff)

/*#define MTL_QSSCR1_SSC_Wr_Mask (ULONG)(~((~(~0 << (14))) << (0)))*/

#define MTL_QSSCR1_SSC_Wr_Mask (ULONG)(0xffffc000)

#define MTL_QSSCR1_SSC_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QSSCR1_RES_Wr_Mask_14))|((( 0) & (MTL_QSSCR1_Mask_14))<<14);\
		(v) = ((v & MTL_QSSCR1_SSC_Wr_Mask) | ((data & MTL_QSSCR1_SSC_Mask)<<0));\
		MTL_QSSCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QSSCR1_SSC_UdfRd(pdata, data) do {\
		MTL_QSSCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QSSCR1_SSC_Mask);\
} while(0)


#define MTL_QW7_RgOffAddr ((BASE_ADDRESS + 0xed8))

#define MTL_QW7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW7_RgOffAddr));\
} while(0)

#define MTL_QW7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW7_RgOffAddr));\
} while(0)

/*#define  MTL_QW7_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW7_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW7_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW7_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW7_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW7_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW7_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW7_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW7_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW7_RES_Wr_Mask_21))|((( 0) & (MTL_QW7_Mask_21))<<21);\
		(v) = ((v & MTL_QW7_ISCQW_Wr_Mask) | ((data & MTL_QW7_ISCQW_Mask)<<0));\
		MTL_QW7_RgWr(pdata, v);\
} while(0)

#define MTL_QW7_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW7_ISCQW_Mask);\
} while(0)


#define MTL_QW6_RgOffAddr ((BASE_ADDRESS + 0xe98))

#define MTL_QW6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW6_RgOffAddr));\
} while(0)

#define MTL_QW6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW6_RgOffAddr));\
} while(0)

/*#define  MTL_QW6_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW6_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW6_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW6_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW6_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW6_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW6_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW6_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW6_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW6_RES_Wr_Mask_21))|((( 0) & (MTL_QW6_Mask_21))<<21);\
		(v) = ((v & MTL_QW6_ISCQW_Wr_Mask) | ((data & MTL_QW6_ISCQW_Mask)<<0));\
		MTL_QW6_RgWr(pdata, v);\
} while(0)

#define MTL_QW6_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW6_ISCQW_Mask);\
} while(0)


#define MTL_QW5_RgOffAddr ((BASE_ADDRESS + 0xe58))

#define MTL_QW5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW5_RgOffAddr));\
} while(0)

#define MTL_QW5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW5_RgOffAddr));\
} while(0)

/*#define  MTL_QW5_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW5_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW5_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW5_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW5_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW5_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW5_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW5_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW5_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW5_RES_Wr_Mask_21))|((( 0) & (MTL_QW5_Mask_21))<<21);\
		(v) = ((v & MTL_QW5_ISCQW_Wr_Mask) | ((data & MTL_QW5_ISCQW_Mask)<<0));\
		MTL_QW5_RgWr(pdata, v);\
} while(0)

#define MTL_QW5_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW5_ISCQW_Mask);\
} while(0)


#define MTL_QW4_RgOffAddr ((BASE_ADDRESS + 0xe18))

#define MTL_QW4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW4_RgOffAddr));\
} while(0)

#define MTL_QW4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW4_RgOffAddr));\
} while(0)

/*#define  MTL_QW4_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW4_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW4_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW4_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW4_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW4_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW4_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW4_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW4_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW4_RES_Wr_Mask_21))|((( 0) & (MTL_QW4_Mask_21))<<21);\
		(v) = ((v & MTL_QW4_ISCQW_Wr_Mask) | ((data & MTL_QW4_ISCQW_Mask)<<0));\
		MTL_QW4_RgWr(pdata, v);\
} while(0)

#define MTL_QW4_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW4_ISCQW_Mask);\
} while(0)


#define MTL_QW3_RgOffAddr ((BASE_ADDRESS + 0xdd8))

#define MTL_QW3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW3_RgOffAddr));\
} while(0)

#define MTL_QW3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW3_RgOffAddr));\
} while(0)

/*#define  MTL_QW3_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW3_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW3_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW3_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW3_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW3_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW3_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW3_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW3_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW3_RES_Wr_Mask_21))|((( 0) & (MTL_QW3_Mask_21))<<21);\
		(v) = ((v & MTL_QW3_ISCQW_Wr_Mask) | ((data & MTL_QW3_ISCQW_Mask)<<0));\
		MTL_QW3_RgWr(pdata, v);\
} while(0)

#define MTL_QW3_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW3_ISCQW_Mask);\
} while(0)


#define MTL_QW2_RgOffAddr ((BASE_ADDRESS + 0xd98))

#define MTL_QW2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW2_RgOffAddr));\
} while(0)

#define MTL_QW2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW2_RgOffAddr));\
} while(0)

/*#define  MTL_QW2_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW2_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW2_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW2_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW2_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW2_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW2_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW2_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW2_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW2_RES_Wr_Mask_21))|((( 0) & (MTL_QW2_Mask_21))<<21);\
		(v) = ((v & MTL_QW2_ISCQW_Wr_Mask) | ((data & MTL_QW2_ISCQW_Mask)<<0));\
		MTL_QW2_RgWr(pdata, v);\
} while(0)

#define MTL_QW2_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW2_ISCQW_Mask);\
} while(0)


#define MTL_QW1_RgOffAddr ((BASE_ADDRESS + 0xd58))

#define MTL_QW1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QW1_RgOffAddr));\
} while(0)

#define MTL_QW1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QW1_RgOffAddr));\
} while(0)

/*#define  MTL_QW1_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_QW1_Mask_21 (ULONG)(0x7ff)

/*#define MTL_QW1_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_QW1_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_QW1_ISCQW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_QW1_ISCQW_Mask (ULONG)(0x1fffff)

/*#define MTL_QW1_ISCQW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_QW1_ISCQW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_QW1_ISCQW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_QW1_RES_Wr_Mask_21))|((( 0) & (MTL_QW1_Mask_21))<<21);\
		(v) = ((v & MTL_QW1_ISCQW_Wr_Mask) | ((data & MTL_QW1_ISCQW_Mask)<<0));\
		MTL_QW1_RgWr(pdata, v);\
} while(0)

#define MTL_QW1_ISCQW_UdfRd(pdata, data) do {\
		MTL_QW1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QW1_ISCQW_Mask);\
} while(0)


#define MTL_QESR7_RgOffAddr ((BASE_ADDRESS + 0xed4))

#define MTL_QESR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR7_RgOffAddr));\
} while(0)

/*#define MTL_QESR7_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR7_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR7_ABS_UdfRd(pdata, data) do {\
		MTL_QESR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR7_ABS_Mask);\
} while(0)

/*#define MTL_QESR7_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR7_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR7_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR7_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR7_ABSU_Mask);\
} while(0)


#define MTL_QESR6_RgOffAddr ((BASE_ADDRESS + 0xe94))

#define MTL_QESR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR6_RgOffAddr));\
} while(0)

/*#define MTL_QESR6_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR6_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR6_ABS_UdfRd(pdata, data) do {\
		MTL_QESR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR6_ABS_Mask);\
} while(0)

/*#define MTL_QESR6_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR6_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR6_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR6_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR6_ABSU_Mask);\
} while(0)


#define MTL_QESR5_RgOffAddr ((BASE_ADDRESS + 0xe54))

#define MTL_QESR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR5_RgOffAddr));\
} while(0)

/*#define MTL_QESR5_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR5_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR5_ABS_UdfRd(pdata, data) do {\
		MTL_QESR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR5_ABS_Mask);\
} while(0)

/*#define MTL_QESR5_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR5_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR5_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR5_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR5_ABSU_Mask);\
} while(0)


#define MTL_QESR4_RgOffAddr ((BASE_ADDRESS + 0xe14))

#define MTL_QESR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR4_RgOffAddr));\
} while(0)

/*#define MTL_QESR4_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR4_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR4_ABS_UdfRd(pdata, data) do {\
		MTL_QESR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR4_ABS_Mask);\
} while(0)

/*#define MTL_QESR4_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR4_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR4_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR4_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR4_ABSU_Mask);\
} while(0)


#define MTL_QESR3_RgOffAddr ((BASE_ADDRESS + 0xdd4))

#define MTL_QESR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR3_RgOffAddr));\
} while(0)

/*#define MTL_QESR3_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR3_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR3_ABS_UdfRd(pdata, data) do {\
		MTL_QESR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR3_ABS_Mask);\
} while(0)

/*#define MTL_QESR3_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR3_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR3_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR3_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR3_ABSU_Mask);\
} while(0)


#define MTL_QESR2_RgOffAddr ((BASE_ADDRESS + 0xd94))

#define MTL_QESR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR2_RgOffAddr));\
} while(0)

/*#define MTL_QESR2_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR2_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR2_ABS_UdfRd(pdata, data) do {\
		MTL_QESR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR2_ABS_Mask);\
} while(0)

/*#define MTL_QESR2_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR2_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR2_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR2_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR2_ABSU_Mask);\
} while(0)


#define MTL_QESR1_RgOffAddr ((BASE_ADDRESS + 0xd54))

#define MTL_QESR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QESR1_RgOffAddr));\
} while(0)

/*#define MTL_QESR1_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_QESR1_ABS_Mask (ULONG)(0xffffff)

#define MTL_QESR1_ABS_UdfRd(pdata, data) do {\
		MTL_QESR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QESR1_ABS_Mask);\
} while(0)

/*#define MTL_QESR1_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QESR1_ABSU_Mask (ULONG)(0x1)

#define MTL_QESR1_ABSU_UdfRd(pdata, data) do {\
		MTL_QESR1_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QESR1_ABSU_Mask);\
} while(0)


#define MTL_QECR7_RgOffAddr ((BASE_ADDRESS + 0xed0))

#define MTL_QECR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR7_RgOffAddr));\
} while(0)

#define MTL_QECR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR7_RgOffAddr));\
} while(0)

/*#define  MTL_QECR7_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR7_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR7_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR7_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR7_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR7_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR7_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR7_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR7_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR7_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR7_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR7_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR7_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR7_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR7_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR7_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR7_RgRd(pdata, v);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_0))|((( 0) & (MTL_QECR7_Mask_0))<<0);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_7))|((( 0) & (MTL_QECR7_Mask_7))<<7);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_25))|((( 0) & (MTL_QECR7_Mask_25))<<25);\
		v = ((v & MTL_QECR7_AVALG_Wr_Mask) | ((data & MTL_QECR7_AVALG_Mask)<<2));\
		MTL_QECR7_RgWr(pdata, v);\
} while(0)

#define MTL_QECR7_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR7_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR7_AVALG_Mask);\
} while(0)

/*#define MTL_QECR7_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR7_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR7_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR7_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR7_RgRd(pdata, v);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_0))|((( 0) & (MTL_QECR7_Mask_0))<<0);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_7))|((( 0) & (MTL_QECR7_Mask_7))<<7);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_25))|((( 0) & (MTL_QECR7_Mask_25))<<25);\
		v = ((v & MTL_QECR7_CC_Wr_Mask) | ((data & MTL_QECR7_CC_Mask)<<3));\
		MTL_QECR7_RgWr(pdata, v);\
} while(0)

#define MTL_QECR7_CC_UdfRd(pdata, data) do {\
		MTL_QECR7_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR7_CC_Mask);\
} while(0)

/*#define MTL_QECR7_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR7_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR7_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR7_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR7_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR7_RgRd(pdata, v);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_0))|((( 0) & (MTL_QECR7_Mask_0))<<0);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_7))|((( 0) & (MTL_QECR7_Mask_7))<<7);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_25))|((( 0) & (MTL_QECR7_Mask_25))<<25);\
		v = ((v & MTL_QECR7_SLC_Wr_Mask) | ((data & MTL_QECR7_SLC_Mask)<<4));\
		MTL_QECR7_RgWr(pdata, v);\
} while(0)

#define MTL_QECR7_SLC_UdfRd(pdata, data) do {\
		MTL_QECR7_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR7_SLC_Mask);\
} while(0)

/*#define MTL_QECR7_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR7_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR7_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR7_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR7_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR7_RgRd(pdata, v);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_0))|((( 0) & (MTL_QECR7_Mask_0))<<0);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_7))|((( 0) & (MTL_QECR7_Mask_7))<<7);\
		v = (v & (MTL_QECR7_RES_Wr_Mask_25))|((( 0) & (MTL_QECR7_Mask_25))<<25);\
		v = ((v & MTL_QECR7_ABPSSIE_Wr_Mask) | ((data & MTL_QECR7_ABPSSIE_Mask)<<24));\
		MTL_QECR7_RgWr(pdata, v);\
} while(0)

#define MTL_QECR7_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR7_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR7_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR6_RgOffAddr ((BASE_ADDRESS + 0xe90))

#define MTL_QECR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR6_RgOffAddr));\
} while(0)

#define MTL_QECR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR6_RgOffAddr));\
} while(0)

/*#define  MTL_QECR6_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR6_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR6_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR6_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR6_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR6_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR6_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR6_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR6_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR6_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR6_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR6_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR6_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR6_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR6_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR6_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR6_RgRd(pdata, v);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_0))|((( 0) & (MTL_QECR6_Mask_0))<<0);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_7))|((( 0) & (MTL_QECR6_Mask_7))<<7);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_25))|((( 0) & (MTL_QECR6_Mask_25))<<25);\
		v = ((v & MTL_QECR6_AVALG_Wr_Mask) | ((data & MTL_QECR6_AVALG_Mask)<<2));\
		MTL_QECR6_RgWr(pdata, v);\
} while(0)

#define MTL_QECR6_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR6_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR6_AVALG_Mask);\
} while(0)

/*#define MTL_QECR6_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR6_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR6_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR6_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR6_RgRd(pdata, v);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_0))|((( 0) & (MTL_QECR6_Mask_0))<<0);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_7))|((( 0) & (MTL_QECR6_Mask_7))<<7);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_25))|((( 0) & (MTL_QECR6_Mask_25))<<25);\
		v = ((v & MTL_QECR6_CC_Wr_Mask) | ((data & MTL_QECR6_CC_Mask)<<3));\
		MTL_QECR6_RgWr(pdata, v);\
} while(0)

#define MTL_QECR6_CC_UdfRd(pdata, data) do {\
		MTL_QECR6_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR6_CC_Mask);\
} while(0)

/*#define MTL_QECR6_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR6_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR6_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR6_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR6_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR6_RgRd(pdata, v);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_0))|((( 0) & (MTL_QECR6_Mask_0))<<0);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_7))|((( 0) & (MTL_QECR6_Mask_7))<<7);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_25))|((( 0) & (MTL_QECR6_Mask_25))<<25);\
		v = ((v & MTL_QECR6_SLC_Wr_Mask) | ((data & MTL_QECR6_SLC_Mask)<<4));\
		MTL_QECR6_RgWr(pdata, v);\
} while(0)

#define MTL_QECR6_SLC_UdfRd(pdata, data) do {\
		MTL_QECR6_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR6_SLC_Mask);\
} while(0)

/*#define MTL_QECR6_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR6_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR6_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR6_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR6_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR6_RgRd(pdata, v);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_0))|((( 0) & (MTL_QECR6_Mask_0))<<0);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_7))|((( 0) & (MTL_QECR6_Mask_7))<<7);\
		v = (v & (MTL_QECR6_RES_Wr_Mask_25))|((( 0) & (MTL_QECR6_Mask_25))<<25);\
		v = ((v & MTL_QECR6_ABPSSIE_Wr_Mask) | ((data & MTL_QECR6_ABPSSIE_Mask)<<24));\
		MTL_QECR6_RgWr(pdata, v);\
} while(0)

#define MTL_QECR6_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR6_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR6_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR5_RgOffAddr ((BASE_ADDRESS + 0xe50))

#define MTL_QECR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR5_RgOffAddr));\
} while(0)

#define MTL_QECR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR5_RgOffAddr));\
} while(0)

/*#define  MTL_QECR5_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR5_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR5_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR5_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR5_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR5_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR5_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR5_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR5_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR5_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR5_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR5_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR5_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR5_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR5_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR5_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR5_RgRd(pdata, v);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_0))|((( 0) & (MTL_QECR5_Mask_0))<<0);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_7))|((( 0) & (MTL_QECR5_Mask_7))<<7);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_25))|((( 0) & (MTL_QECR5_Mask_25))<<25);\
		v = ((v & MTL_QECR5_AVALG_Wr_Mask) | ((data & MTL_QECR5_AVALG_Mask)<<2));\
		MTL_QECR5_RgWr(pdata, v);\
} while(0)

#define MTL_QECR5_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR5_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR5_AVALG_Mask);\
} while(0)

/*#define MTL_QECR5_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR5_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR5_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR5_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR5_RgRd(pdata, v);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_0))|((( 0) & (MTL_QECR5_Mask_0))<<0);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_7))|((( 0) & (MTL_QECR5_Mask_7))<<7);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_25))|((( 0) & (MTL_QECR5_Mask_25))<<25);\
		v = ((v & MTL_QECR5_CC_Wr_Mask) | ((data & MTL_QECR5_CC_Mask)<<3));\
		MTL_QECR5_RgWr(pdata, v);\
} while(0)

#define MTL_QECR5_CC_UdfRd(pdata, data) do {\
		MTL_QECR5_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR5_CC_Mask);\
} while(0)

/*#define MTL_QECR5_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR5_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR5_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR5_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR5_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR5_RgRd(pdata, v);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_0))|((( 0) & (MTL_QECR5_Mask_0))<<0);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_7))|((( 0) & (MTL_QECR5_Mask_7))<<7);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_25))|((( 0) & (MTL_QECR5_Mask_25))<<25);\
		v = ((v & MTL_QECR5_SLC_Wr_Mask) | ((data & MTL_QECR5_SLC_Mask)<<4));\
		MTL_QECR5_RgWr(pdata, v);\
} while(0)

#define MTL_QECR5_SLC_UdfRd(pdata, data) do {\
		MTL_QECR5_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR5_SLC_Mask);\
} while(0)

/*#define MTL_QECR5_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR5_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR5_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR5_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR5_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR5_RgRd(pdata, v);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_0))|((( 0) & (MTL_QECR5_Mask_0))<<0);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_7))|((( 0) & (MTL_QECR5_Mask_7))<<7);\
		v = (v & (MTL_QECR5_RES_Wr_Mask_25))|((( 0) & (MTL_QECR5_Mask_25))<<25);\
		v = ((v & MTL_QECR5_ABPSSIE_Wr_Mask) | ((data & MTL_QECR5_ABPSSIE_Mask)<<24));\
		MTL_QECR5_RgWr(pdata, v);\
} while(0)

#define MTL_QECR5_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR5_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR5_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR4_RgOffAddr ((BASE_ADDRESS + 0xe10))

#define MTL_QECR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR4_RgOffAddr));\
} while(0)

#define MTL_QECR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR4_RgOffAddr));\
} while(0)

/*#define  MTL_QECR4_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR4_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR4_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR4_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR4_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR4_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR4_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR4_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR4_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR4_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR4_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR4_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR4_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR4_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR4_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR4_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR4_RgRd(pdata, v);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_0))|((( 0) & (MTL_QECR4_Mask_0))<<0);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_7))|((( 0) & (MTL_QECR4_Mask_7))<<7);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_25))|((( 0) & (MTL_QECR4_Mask_25))<<25);\
		v = ((v & MTL_QECR4_AVALG_Wr_Mask) | ((data & MTL_QECR4_AVALG_Mask)<<2));\
		MTL_QECR4_RgWr(pdata, v);\
} while(0)

#define MTL_QECR4_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR4_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR4_AVALG_Mask);\
} while(0)

/*#define MTL_QECR4_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR4_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR4_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR4_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR4_RgRd(pdata, v);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_0))|((( 0) & (MTL_QECR4_Mask_0))<<0);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_7))|((( 0) & (MTL_QECR4_Mask_7))<<7);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_25))|((( 0) & (MTL_QECR4_Mask_25))<<25);\
		v = ((v & MTL_QECR4_CC_Wr_Mask) | ((data & MTL_QECR4_CC_Mask)<<3));\
		MTL_QECR4_RgWr(pdata, v);\
} while(0)

#define MTL_QECR4_CC_UdfRd(pdata, data) do {\
		MTL_QECR4_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR4_CC_Mask);\
} while(0)

/*#define MTL_QECR4_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR4_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR4_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR4_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR4_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR4_RgRd(pdata, v);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_0))|((( 0) & (MTL_QECR4_Mask_0))<<0);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_7))|((( 0) & (MTL_QECR4_Mask_7))<<7);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_25))|((( 0) & (MTL_QECR4_Mask_25))<<25);\
		v = ((v & MTL_QECR4_SLC_Wr_Mask) | ((data & MTL_QECR4_SLC_Mask)<<4));\
		MTL_QECR4_RgWr(pdata, v);\
} while(0)

#define MTL_QECR4_SLC_UdfRd(pdata, data) do {\
		MTL_QECR4_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR4_SLC_Mask);\
} while(0)

/*#define MTL_QECR4_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR4_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR4_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR4_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR4_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR4_RgRd(pdata, v);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_0))|((( 0) & (MTL_QECR4_Mask_0))<<0);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_7))|((( 0) & (MTL_QECR4_Mask_7))<<7);\
		v = (v & (MTL_QECR4_RES_Wr_Mask_25))|((( 0) & (MTL_QECR4_Mask_25))<<25);\
		v = ((v & MTL_QECR4_ABPSSIE_Wr_Mask) | ((data & MTL_QECR4_ABPSSIE_Mask)<<24));\
		MTL_QECR4_RgWr(pdata, v);\
} while(0)

#define MTL_QECR4_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR4_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR4_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR3_RgOffAddr ((BASE_ADDRESS + 0xdd0))

#define MTL_QECR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR3_RgOffAddr));\
} while(0)

#define MTL_QECR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR3_RgOffAddr));\
} while(0)

/*#define  MTL_QECR3_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR3_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR3_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR3_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR3_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR3_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR3_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR3_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR3_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR3_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR3_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR3_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR3_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR3_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR3_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR3_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR3_RgRd(pdata, v);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_0))|((( 0) & (MTL_QECR3_Mask_0))<<0);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_7))|((( 0) & (MTL_QECR3_Mask_7))<<7);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_25))|((( 0) & (MTL_QECR3_Mask_25))<<25);\
		v = ((v & MTL_QECR3_AVALG_Wr_Mask) | ((data & MTL_QECR3_AVALG_Mask)<<2));\
		MTL_QECR3_RgWr(pdata, v);\
} while(0)

#define MTL_QECR3_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR3_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR3_AVALG_Mask);\
} while(0)

/*#define MTL_QECR3_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR3_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR3_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR3_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR3_RgRd(pdata, v);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_0))|((( 0) & (MTL_QECR3_Mask_0))<<0);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_7))|((( 0) & (MTL_QECR3_Mask_7))<<7);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_25))|((( 0) & (MTL_QECR3_Mask_25))<<25);\
		v = ((v & MTL_QECR3_CC_Wr_Mask) | ((data & MTL_QECR3_CC_Mask)<<3));\
		MTL_QECR3_RgWr(pdata, v);\
} while(0)

#define MTL_QECR3_CC_UdfRd(pdata, data) do {\
		MTL_QECR3_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR3_CC_Mask);\
} while(0)

/*#define MTL_QECR3_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR3_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR3_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR3_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR3_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR3_RgRd(pdata, v);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_0))|((( 0) & (MTL_QECR3_Mask_0))<<0);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_7))|((( 0) & (MTL_QECR3_Mask_7))<<7);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_25))|((( 0) & (MTL_QECR3_Mask_25))<<25);\
		v = ((v & MTL_QECR3_SLC_Wr_Mask) | ((data & MTL_QECR3_SLC_Mask)<<4));\
		MTL_QECR3_RgWr(pdata, v);\
} while(0)

#define MTL_QECR3_SLC_UdfRd(pdata, data) do {\
		MTL_QECR3_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR3_SLC_Mask);\
} while(0)

/*#define MTL_QECR3_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR3_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR3_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR3_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR3_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR3_RgRd(pdata, v);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_0))|((( 0) & (MTL_QECR3_Mask_0))<<0);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_7))|((( 0) & (MTL_QECR3_Mask_7))<<7);\
		v = (v & (MTL_QECR3_RES_Wr_Mask_25))|((( 0) & (MTL_QECR3_Mask_25))<<25);\
		v = ((v & MTL_QECR3_ABPSSIE_Wr_Mask) | ((data & MTL_QECR3_ABPSSIE_Mask)<<24));\
		MTL_QECR3_RgWr(pdata, v);\
} while(0)

#define MTL_QECR3_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR3_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR3_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR2_RgOffAddr ((BASE_ADDRESS + 0xd90))

#define MTL_QECR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR2_RgOffAddr));\
} while(0)

#define MTL_QECR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR2_RgOffAddr));\
} while(0)

/*#define  MTL_QECR2_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR2_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR2_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR2_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR2_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR2_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR2_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR2_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR2_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR2_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR2_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR2_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR2_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR2_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR2_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR2_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR2_RgRd(pdata, v);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_0))|((( 0) & (MTL_QECR2_Mask_0))<<0);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_7))|((( 0) & (MTL_QECR2_Mask_7))<<7);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_25))|((( 0) & (MTL_QECR2_Mask_25))<<25);\
		v = ((v & MTL_QECR2_AVALG_Wr_Mask) | ((data & MTL_QECR2_AVALG_Mask)<<2));\
		MTL_QECR2_RgWr(pdata, v);\
} while(0)

#define MTL_QECR2_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR2_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR2_AVALG_Mask);\
} while(0)

/*#define MTL_QECR2_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR2_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR2_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR2_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR2_RgRd(pdata, v);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_0))|((( 0) & (MTL_QECR2_Mask_0))<<0);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_7))|((( 0) & (MTL_QECR2_Mask_7))<<7);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_25))|((( 0) & (MTL_QECR2_Mask_25))<<25);\
		v = ((v & MTL_QECR2_CC_Wr_Mask) | ((data & MTL_QECR2_CC_Mask)<<3));\
		MTL_QECR2_RgWr(pdata, v);\
} while(0)

#define MTL_QECR2_CC_UdfRd(pdata, data) do {\
		MTL_QECR2_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR2_CC_Mask);\
} while(0)

/*#define MTL_QECR2_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR2_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR2_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR2_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR2_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR2_RgRd(pdata, v);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_0))|((( 0) & (MTL_QECR2_Mask_0))<<0);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_7))|((( 0) & (MTL_QECR2_Mask_7))<<7);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_25))|((( 0) & (MTL_QECR2_Mask_25))<<25);\
		v = ((v & MTL_QECR2_SLC_Wr_Mask) | ((data & MTL_QECR2_SLC_Mask)<<4));\
		MTL_QECR2_RgWr(pdata, v);\
} while(0)

#define MTL_QECR2_SLC_UdfRd(pdata, data) do {\
		MTL_QECR2_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR2_SLC_Mask);\
} while(0)

/*#define MTL_QECR2_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR2_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR2_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR2_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR2_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR2_RgRd(pdata, v);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_0))|((( 0) & (MTL_QECR2_Mask_0))<<0);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_7))|((( 0) & (MTL_QECR2_Mask_7))<<7);\
		v = (v & (MTL_QECR2_RES_Wr_Mask_25))|((( 0) & (MTL_QECR2_Mask_25))<<25);\
		v = ((v & MTL_QECR2_ABPSSIE_Wr_Mask) | ((data & MTL_QECR2_ABPSSIE_Mask)<<24));\
		MTL_QECR2_RgWr(pdata, v);\
} while(0)

#define MTL_QECR2_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR2_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR2_ABPSSIE_Mask);\
} while(0)


#define MTL_QECR1_RgOffAddr ((BASE_ADDRESS + 0xd50))

#define MTL_QECR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QECR1_RgOffAddr));\
} while(0)

#define MTL_QECR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QECR1_RgOffAddr));\
} while(0)

/*#define  MTL_QECR1_Mask_0 (ULONG)(~(~0<<(2)))*/

#define  MTL_QECR1_Mask_0 (ULONG)(0x3)

/*#define MTL_QECR1_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(2)))<<(0)))*/

#define MTL_QECR1_RES_Wr_Mask_0 (ULONG)(0xfffffffc)

/*#define  MTL_QECR1_Mask_7 (ULONG)(~(~0<<(17)))*/

#define  MTL_QECR1_Mask_7 (ULONG)(0x1ffff)

/*#define MTL_QECR1_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(17)))<<(7)))*/

#define MTL_QECR1_RES_Wr_Mask_7 (ULONG)(0xff00007f)

/*#define  MTL_QECR1_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_QECR1_Mask_25 (ULONG)(0x7f)

/*#define MTL_QECR1_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_QECR1_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MTL_QECR1_AVALG_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_AVALG_Mask (ULONG)(0x1)

/*#define MTL_QECR1_AVALG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MTL_QECR1_AVALG_Wr_Mask (ULONG)(0xfffffffb)

#define MTL_QECR1_AVALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR1_RgRd(pdata, v);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_0))|((( 0) & (MTL_QECR1_Mask_0))<<0);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_7))|((( 0) & (MTL_QECR1_Mask_7))<<7);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_25))|((( 0) & (MTL_QECR1_Mask_25))<<25);\
		v = ((v & MTL_QECR1_AVALG_Wr_Mask) | ((data & MTL_QECR1_AVALG_Mask)<<2));\
		MTL_QECR1_RgWr(pdata, v);\
} while(0)

#define MTL_QECR1_AVALG_UdfRd(pdata, data) do {\
		MTL_QECR1_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QECR1_AVALG_Mask);\
} while(0)

/*#define MTL_QECR1_CC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_CC_Mask (ULONG)(0x1)

/*#define MTL_QECR1_CC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_QECR1_CC_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_QECR1_CC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR1_RgRd(pdata, v);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_0))|((( 0) & (MTL_QECR1_Mask_0))<<0);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_7))|((( 0) & (MTL_QECR1_Mask_7))<<7);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_25))|((( 0) & (MTL_QECR1_Mask_25))<<25);\
		v = ((v & MTL_QECR1_CC_Wr_Mask) | ((data & MTL_QECR1_CC_Mask)<<3));\
		MTL_QECR1_RgWr(pdata, v);\
} while(0)

#define MTL_QECR1_CC_UdfRd(pdata, data) do {\
		MTL_QECR1_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QECR1_CC_Mask);\
} while(0)

/*#define MTL_QECR1_SLC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QECR1_SLC_Mask (ULONG)(0x7)

/*#define MTL_QECR1_SLC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QECR1_SLC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QECR1_SLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR1_RgRd(pdata, v);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_0))|((( 0) & (MTL_QECR1_Mask_0))<<0);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_7))|((( 0) & (MTL_QECR1_Mask_7))<<7);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_25))|((( 0) & (MTL_QECR1_Mask_25))<<25);\
		v = ((v & MTL_QECR1_SLC_Wr_Mask) | ((data & MTL_QECR1_SLC_Mask)<<4));\
		MTL_QECR1_RgWr(pdata, v);\
} while(0)

#define MTL_QECR1_SLC_UdfRd(pdata, data) do {\
		MTL_QECR1_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QECR1_SLC_Mask);\
} while(0)

/*#define MTL_QECR1_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QECR1_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_QECR1_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_QECR1_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_QECR1_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QECR1_RgRd(pdata, v);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_0))|((( 0) & (MTL_QECR1_Mask_0))<<0);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_7))|((( 0) & (MTL_QECR1_Mask_7))<<7);\
		v = (v & (MTL_QECR1_RES_Wr_Mask_25))|((( 0) & (MTL_QECR1_Mask_25))<<25);\
		v = ((v & MTL_QECR1_ABPSSIE_Wr_Mask) | ((data & MTL_QECR1_ABPSSIE_Mask)<<24));\
		MTL_QECR1_RgWr(pdata, v);\
} while(0)

#define MTL_QECR1_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_QECR1_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_QECR1_ABPSSIE_Mask);\
} while(0)


#define MTL_QTDR7_RgOffAddr ((BASE_ADDRESS + 0xec8))

#define MTL_QTDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR7_RgOffAddr));\
} while(0)

/*#define MTL_QTDR7_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR7_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR7_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR7_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR7_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR7_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR7_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR7_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR7_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR7_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR7_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR7_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR7_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR7_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR7_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR7_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR7_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR7_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR7_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR7_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR7_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR7_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR7_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR7_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR7_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR7_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR6_RgOffAddr ((BASE_ADDRESS + 0xe88))

#define MTL_QTDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR6_RgOffAddr));\
} while(0)

/*#define MTL_QTDR6_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR6_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR6_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR6_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR6_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR6_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR6_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR6_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR6_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR6_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR6_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR6_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR6_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR6_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR6_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR6_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR6_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR6_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR6_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR6_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR6_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR6_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR6_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR6_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR6_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR6_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR5_RgOffAddr ((BASE_ADDRESS + 0xe48))

#define MTL_QTDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR5_RgOffAddr));\
} while(0)

/*#define MTL_QTDR5_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR5_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR5_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR5_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR5_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR5_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR5_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR5_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR5_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR5_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR5_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR5_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR5_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR5_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR5_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR5_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR5_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR5_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR5_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR5_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR5_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR5_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR5_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR5_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR5_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR5_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR4_RgOffAddr ((BASE_ADDRESS + 0xe08))

#define MTL_QTDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR4_RgOffAddr));\
} while(0)

/*#define MTL_QTDR4_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR4_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR4_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR4_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR4_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR4_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR4_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR4_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR4_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR4_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR4_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR4_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR4_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR4_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR4_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR4_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR4_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR4_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR4_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR4_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR4_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR4_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR4_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR4_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR4_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR4_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR3_RgOffAddr ((BASE_ADDRESS + 0xdc8))

#define MTL_QTDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR3_RgOffAddr));\
} while(0)

/*#define MTL_QTDR3_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR3_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR3_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR3_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR3_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR3_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR3_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR3_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR3_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR3_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR3_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR3_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR3_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR3_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR3_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR3_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR3_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR3_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR3_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR3_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR3_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR3_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR3_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR3_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR3_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR3_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR2_RgOffAddr ((BASE_ADDRESS + 0xd88))

#define MTL_QTDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR2_RgOffAddr));\
} while(0)

/*#define MTL_QTDR2_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR2_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR2_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR2_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR2_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR2_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR2_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR2_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR2_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR2_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR2_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR2_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR2_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR2_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR2_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR2_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR2_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR2_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR2_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR2_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR2_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR2_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR2_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR2_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR2_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR2_STXSTSF_Mask);\
} while(0)


#define MTL_QTDR1_RgOffAddr ((BASE_ADDRESS + 0xd48))

#define MTL_QTDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTDR1_RgOffAddr));\
} while(0)

/*#define MTL_QTDR1_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_QTDR1_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTDR1_TXQPAUSED_Mask);\
} while(0)

/*#define MTL_QTDR1_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTDR1_TRCSTS_Mask (ULONG)(0x3)

#define MTL_QTDR1_TRCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTDR1_TRCSTS_Mask);\
} while(0)

/*#define MTL_QTDR1_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TWCSTS_Mask (ULONG)(0x1)

#define MTL_QTDR1_TWCSTS_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_QTDR1_TWCSTS_Mask);\
} while(0)

/*#define MTL_QTDR1_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXQSTS_Mask (ULONG)(0x1)

#define MTL_QTDR1_TXQSTS_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTDR1_TXQSTS_Mask);\
} while(0)

/*#define MTL_QTDR1_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTDR1_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_QTDR1_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_QTDR1_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_QTDR1_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR1_PTXQ_Mask (ULONG)(0x7)

#define MTL_QTDR1_PTXQ_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTDR1_PTXQ_Mask);\
} while(0)

/*#define MTL_QTDR1_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTDR1_STXSTSF_Mask (ULONG)(0x7)

#define MTL_QTDR1_STXSTSF_UdfRd(pdata, data) do {\
		MTL_QTDR1_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_QTDR1_STXSTSF_Mask);\
} while(0)


#define MTL_QUCR7_RgOffAddr ((BASE_ADDRESS + 0xec4))

#define MTL_QUCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR7_RgOffAddr));\
} while(0)

#define MTL_QUCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR7_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR7_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR7_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR7_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR7_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR7_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR7_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR7_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR7_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR7_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR7_RgRd(pdata, v);\
		v = (v & (MTL_QUCR7_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR7_Mask_12))<<12);\
		v = ((v & MTL_QUCR7_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR7_UFPKTCNT_Mask)<<0));\
		MTL_QUCR7_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR7_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR7_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR7_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR7_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR7_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR7_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR7_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR6_RgOffAddr ((BASE_ADDRESS + 0xe84))

#define MTL_QUCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR6_RgOffAddr));\
} while(0)

#define MTL_QUCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR6_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR6_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR6_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR6_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR6_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR6_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR6_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR6_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR6_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR6_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR6_RgRd(pdata, v);\
		v = (v & (MTL_QUCR6_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR6_Mask_12))<<12);\
		v = ((v & MTL_QUCR6_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR6_UFPKTCNT_Mask)<<0));\
		MTL_QUCR6_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR6_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR6_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR6_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR6_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR6_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR6_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR6_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR5_RgOffAddr ((BASE_ADDRESS + 0xe44))

#define MTL_QUCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR5_RgOffAddr));\
} while(0)

#define MTL_QUCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR5_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR5_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR5_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR5_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR5_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR5_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR5_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR5_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR5_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR5_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR5_RgRd(pdata, v);\
		v = (v & (MTL_QUCR5_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR5_Mask_12))<<12);\
		v = ((v & MTL_QUCR5_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR5_UFPKTCNT_Mask)<<0));\
		MTL_QUCR5_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR5_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR5_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR5_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR5_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR5_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR5_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR5_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR4_RgOffAddr ((BASE_ADDRESS + 0xe04))

#define MTL_QUCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR4_RgOffAddr));\
} while(0)

#define MTL_QUCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR4_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR4_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR4_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR4_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR4_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR4_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR4_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR4_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR4_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR4_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR4_RgRd(pdata, v);\
		v = (v & (MTL_QUCR4_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR4_Mask_12))<<12);\
		v = ((v & MTL_QUCR4_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR4_UFPKTCNT_Mask)<<0));\
		MTL_QUCR4_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR4_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR4_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR4_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR4_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR4_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR4_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR4_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR3_RgOffAddr ((BASE_ADDRESS + 0xdc4))

#define MTL_QUCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR3_RgOffAddr));\
} while(0)

#define MTL_QUCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR3_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR3_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR3_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR3_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR3_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR3_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR3_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR3_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR3_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR3_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR3_RgRd(pdata, v);\
		v = (v & (MTL_QUCR3_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR3_Mask_12))<<12);\
		v = ((v & MTL_QUCR3_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR3_UFPKTCNT_Mask)<<0));\
		MTL_QUCR3_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR3_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR3_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR3_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR3_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR3_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR3_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR3_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR2_RgOffAddr ((BASE_ADDRESS + 0xd84))

#define MTL_QUCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR2_RgOffAddr));\
} while(0)

#define MTL_QUCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR2_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR2_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR2_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR2_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR2_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR2_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR2_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR2_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR2_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR2_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR2_RgRd(pdata, v);\
		v = (v & (MTL_QUCR2_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR2_Mask_12))<<12);\
		v = ((v & MTL_QUCR2_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR2_UFPKTCNT_Mask)<<0));\
		MTL_QUCR2_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR2_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR2_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR2_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR2_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR2_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR2_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR2_UFCNTOVF_Mask);\
} while(0)


#define MTL_QUCR1_RgOffAddr ((BASE_ADDRESS + 0xd44))

#define MTL_QUCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QUCR1_RgOffAddr));\
} while(0)

#define MTL_QUCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QUCR1_RgOffAddr));\
} while(0)

/*#define  MTL_QUCR1_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_QUCR1_Mask_12 (ULONG)(0xfffff)

/*#define MTL_QUCR1_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_QUCR1_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_QUCR1_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_QUCR1_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_QUCR1_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_QUCR1_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_QUCR1_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QUCR1_RgRd(pdata, v);\
		v = (v & (MTL_QUCR1_RES_Wr_Mask_12))|((( 0) & (MTL_QUCR1_Mask_12))<<12);\
		v = ((v & MTL_QUCR1_UFPKTCNT_Wr_Mask) | ((data & MTL_QUCR1_UFPKTCNT_Mask)<<0));\
		MTL_QUCR1_RgWr(pdata, v);\
} while(0)

#define MTL_QUCR1_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_QUCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QUCR1_UFPKTCNT_Mask);\
} while(0)

/*#define MTL_QUCR1_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QUCR1_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_QUCR1_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_QUCR1_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_QUCR1_UFCNTOVF_Mask);\
} while(0)


#define MTL_QTOMR7_RgOffAddr ((BASE_ADDRESS + 0xec0))

#define MTL_QTOMR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR7_RgOffAddr));\
} while(0)

#define MTL_QTOMR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR7_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR7_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR7_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR7_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR7_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR7_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR7_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR7_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR7_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR7_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR7_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR7_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR7_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR7_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR7_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR7_Mask_7))<<7);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR7_Mask_26))<<26);\
		v = ((v & MTL_QTOMR7_FTQ_Wr_Mask) | ((data & MTL_QTOMR7_FTQ_Mask)<<0));\
		MTL_QTOMR7_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR7_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR7_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR7_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR7_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR7_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR7_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR7_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR7_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR7_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR7_Mask_7))<<7);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR7_Mask_26))<<26);\
		v = ((v & MTL_QTOMR7_TSF_Wr_Mask) | ((data & MTL_QTOMR7_TSF_Mask)<<1));\
		MTL_QTOMR7_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR7_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR7_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR7_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR7_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR7_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR7_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR7_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR7_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR7_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR7_Mask_7))<<7);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR7_Mask_26))<<26);\
		v = ((v & MTL_QTOMR7_TXQEN_Wr_Mask) | ((data & MTL_QTOMR7_TXQEN_Mask)<<2));\
		MTL_QTOMR7_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR7_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR7_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR7_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR7_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR7_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR7_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR7_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR7_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR7_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR7_Mask_7))<<7);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR7_Mask_26))<<26);\
		v = ((v & MTL_QTOMR7_TTC_Wr_Mask) | ((data & MTL_QTOMR7_TTC_Mask)<<4));\
		MTL_QTOMR7_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR7_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR7_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR7_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR7_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR7_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR7_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR7_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR7_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR7_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR7_Mask_7))<<7);\
		v = (v & (MTL_QTOMR7_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR7_Mask_26))<<26);\
		v = ((v & MTL_QTOMR7_TQS_Wr_Mask) | ((data & MTL_QTOMR7_TQS_Mask)<<16));\
		MTL_QTOMR7_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR7_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR7_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR7_TQS_Mask);\
} while(0)


#define MTL_QTOMR6_RgOffAddr ((BASE_ADDRESS + 0xe80))

#define MTL_QTOMR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR6_RgOffAddr));\
} while(0)

#define MTL_QTOMR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR6_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR6_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR6_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR6_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR6_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR6_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR6_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR6_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR6_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR6_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR6_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR6_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR6_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR6_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR6_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR6_Mask_7))<<7);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR6_Mask_26))<<26);\
		v = ((v & MTL_QTOMR6_FTQ_Wr_Mask) | ((data & MTL_QTOMR6_FTQ_Mask)<<0));\
		MTL_QTOMR6_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR6_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR6_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR6_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR6_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR6_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR6_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR6_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR6_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR6_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR6_Mask_7))<<7);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR6_Mask_26))<<26);\
		v = ((v & MTL_QTOMR6_TSF_Wr_Mask) | ((data & MTL_QTOMR6_TSF_Mask)<<1));\
		MTL_QTOMR6_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR6_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR6_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR6_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR6_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR6_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR6_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR6_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR6_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR6_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR6_Mask_7))<<7);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR6_Mask_26))<<26);\
		v = ((v & MTL_QTOMR6_TXQEN_Wr_Mask) | ((data & MTL_QTOMR6_TXQEN_Mask)<<2));\
		MTL_QTOMR6_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR6_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR6_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR6_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR6_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR6_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR6_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR6_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR6_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR6_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR6_Mask_7))<<7);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR6_Mask_26))<<26);\
		v = ((v & MTL_QTOMR6_TTC_Wr_Mask) | ((data & MTL_QTOMR6_TTC_Mask)<<4));\
		MTL_QTOMR6_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR6_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR6_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR6_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR6_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR6_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR6_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR6_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR6_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR6_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR6_Mask_7))<<7);\
		v = (v & (MTL_QTOMR6_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR6_Mask_26))<<26);\
		v = ((v & MTL_QTOMR6_TQS_Wr_Mask) | ((data & MTL_QTOMR6_TQS_Mask)<<16));\
		MTL_QTOMR6_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR6_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR6_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR6_TQS_Mask);\
} while(0)


#define MTL_QTOMR5_RgOffAddr ((BASE_ADDRESS + 0xe40))

#define MTL_QTOMR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR5_RgOffAddr));\
} while(0)

#define MTL_QTOMR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR5_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR5_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR5_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR5_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR5_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR5_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR5_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR5_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR5_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR5_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR5_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR5_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR5_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR5_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR5_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR5_Mask_7))<<7);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR5_Mask_26))<<26);\
		v = ((v & MTL_QTOMR5_FTQ_Wr_Mask) | ((data & MTL_QTOMR5_FTQ_Mask)<<0));\
		MTL_QTOMR5_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR5_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR5_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR5_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR5_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR5_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR5_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR5_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR5_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR5_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR5_Mask_7))<<7);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR5_Mask_26))<<26);\
		v = ((v & MTL_QTOMR5_TSF_Wr_Mask) | ((data & MTL_QTOMR5_TSF_Mask)<<1));\
		MTL_QTOMR5_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR5_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR5_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR5_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR5_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR5_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR5_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR5_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR5_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR5_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR5_Mask_7))<<7);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR5_Mask_26))<<26);\
		v = ((v & MTL_QTOMR5_TXQEN_Wr_Mask) | ((data & MTL_QTOMR5_TXQEN_Mask)<<2));\
		MTL_QTOMR5_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR5_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR5_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR5_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR5_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR5_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR5_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR5_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR5_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR5_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR5_Mask_7))<<7);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR5_Mask_26))<<26);\
		v = ((v & MTL_QTOMR5_TTC_Wr_Mask) | ((data & MTL_QTOMR5_TTC_Mask)<<4));\
		MTL_QTOMR5_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR5_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR5_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR5_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR5_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR5_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR5_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR5_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR5_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR5_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR5_Mask_7))<<7);\
		v = (v & (MTL_QTOMR5_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR5_Mask_26))<<26);\
		v = ((v & MTL_QTOMR5_TQS_Wr_Mask) | ((data & MTL_QTOMR5_TQS_Mask)<<16));\
		MTL_QTOMR5_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR5_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR5_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR5_TQS_Mask);\
} while(0)


#define MTL_QTOMR4_RgOffAddr ((BASE_ADDRESS + 0xe00))

#define MTL_QTOMR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR4_RgOffAddr));\
} while(0)

#define MTL_QTOMR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR4_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR4_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR4_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR4_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR4_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR4_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR4_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR4_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR4_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR4_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR4_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR4_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR4_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR4_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR4_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR4_Mask_7))<<7);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR4_Mask_26))<<26);\
		v = ((v & MTL_QTOMR4_FTQ_Wr_Mask) | ((data & MTL_QTOMR4_FTQ_Mask)<<0));\
		MTL_QTOMR4_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR4_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR4_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR4_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR4_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR4_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR4_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR4_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR4_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR4_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR4_Mask_7))<<7);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR4_Mask_26))<<26);\
		v = ((v & MTL_QTOMR4_TSF_Wr_Mask) | ((data & MTL_QTOMR4_TSF_Mask)<<1));\
		MTL_QTOMR4_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR4_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR4_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR4_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR4_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR4_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR4_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR4_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR4_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR4_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR4_Mask_7))<<7);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR4_Mask_26))<<26);\
		v = ((v & MTL_QTOMR4_TXQEN_Wr_Mask) | ((data & MTL_QTOMR4_TXQEN_Mask)<<2));\
		MTL_QTOMR4_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR4_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR4_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR4_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR4_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR4_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR4_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR4_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR4_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR4_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR4_Mask_7))<<7);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR4_Mask_26))<<26);\
		v = ((v & MTL_QTOMR4_TTC_Wr_Mask) | ((data & MTL_QTOMR4_TTC_Mask)<<4));\
		MTL_QTOMR4_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR4_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR4_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR4_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR4_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR4_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR4_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR4_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR4_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR4_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR4_Mask_7))<<7);\
		v = (v & (MTL_QTOMR4_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR4_Mask_26))<<26);\
		v = ((v & MTL_QTOMR4_TQS_Wr_Mask) | ((data & MTL_QTOMR4_TQS_Mask)<<16));\
		MTL_QTOMR4_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR4_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR4_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR4_TQS_Mask);\
} while(0)


#define MTL_QTOMR3_RgOffAddr ((BASE_ADDRESS + 0xdc0))

#define MTL_QTOMR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR3_RgOffAddr));\
} while(0)

#define MTL_QTOMR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR3_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR3_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR3_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR3_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR3_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR3_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR3_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR3_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR3_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR3_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR3_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR3_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR3_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR3_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR3_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR3_Mask_7))<<7);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR3_Mask_26))<<26);\
		v = ((v & MTL_QTOMR3_FTQ_Wr_Mask) | ((data & MTL_QTOMR3_FTQ_Mask)<<0));\
		MTL_QTOMR3_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR3_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR3_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR3_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR3_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR3_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR3_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR3_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR3_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR3_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR3_Mask_7))<<7);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR3_Mask_26))<<26);\
		v = ((v & MTL_QTOMR3_TSF_Wr_Mask) | ((data & MTL_QTOMR3_TSF_Mask)<<1));\
		MTL_QTOMR3_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR3_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR3_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR3_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR3_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR3_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR3_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR3_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR3_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR3_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR3_Mask_7))<<7);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR3_Mask_26))<<26);\
		v = ((v & MTL_QTOMR3_TXQEN_Wr_Mask) | ((data & MTL_QTOMR3_TXQEN_Mask)<<2));\
		MTL_QTOMR3_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR3_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR3_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR3_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR3_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR3_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR3_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR3_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR3_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR3_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR3_Mask_7))<<7);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR3_Mask_26))<<26);\
		v = ((v & MTL_QTOMR3_TTC_Wr_Mask) | ((data & MTL_QTOMR3_TTC_Mask)<<4));\
		MTL_QTOMR3_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR3_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR3_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR3_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR3_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR3_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR3_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR3_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR3_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR3_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR3_Mask_7))<<7);\
		v = (v & (MTL_QTOMR3_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR3_Mask_26))<<26);\
		v = ((v & MTL_QTOMR3_TQS_Wr_Mask) | ((data & MTL_QTOMR3_TQS_Mask)<<16));\
		MTL_QTOMR3_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR3_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR3_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR3_TQS_Mask);\
} while(0)


#define MTL_QTOMR2_RgOffAddr ((BASE_ADDRESS + 0xd80))

#define MTL_QTOMR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR2_RgOffAddr));\
} while(0)

#define MTL_QTOMR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR2_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR2_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR2_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR2_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR2_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR2_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR2_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR2_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR2_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR2_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR2_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR2_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR2_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR2_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR2_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR2_Mask_7))<<7);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR2_Mask_26))<<26);\
		v = ((v & MTL_QTOMR2_FTQ_Wr_Mask) | ((data & MTL_QTOMR2_FTQ_Mask)<<0));\
		MTL_QTOMR2_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR2_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR2_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR2_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR2_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR2_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR2_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR2_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR2_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR2_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR2_Mask_7))<<7);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR2_Mask_26))<<26);\
		v = ((v & MTL_QTOMR2_TSF_Wr_Mask) | ((data & MTL_QTOMR2_TSF_Mask)<<1));\
		MTL_QTOMR2_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR2_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR2_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR2_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR2_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR2_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR2_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR2_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR2_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR2_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR2_Mask_7))<<7);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR2_Mask_26))<<26);\
		v = ((v & MTL_QTOMR2_TXQEN_Wr_Mask) | ((data & MTL_QTOMR2_TXQEN_Mask)<<2));\
		MTL_QTOMR2_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR2_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR2_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR2_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR2_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR2_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR2_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR2_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR2_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR2_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR2_Mask_7))<<7);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR2_Mask_26))<<26);\
		v = ((v & MTL_QTOMR2_TTC_Wr_Mask) | ((data & MTL_QTOMR2_TTC_Mask)<<4));\
		MTL_QTOMR2_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR2_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR2_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR2_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR2_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR2_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR2_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR2_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR2_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR2_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR2_Mask_7))<<7);\
		v = (v & (MTL_QTOMR2_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR2_Mask_26))<<26);\
		v = ((v & MTL_QTOMR2_TQS_Wr_Mask) | ((data & MTL_QTOMR2_TQS_Mask)<<16));\
		MTL_QTOMR2_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR2_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR2_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR2_TQS_Mask);\
} while(0)


#define MTL_QTOMR1_RgOffAddr ((BASE_ADDRESS + 0xd40))

#define MTL_QTOMR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_QTOMR1_RgOffAddr));\
} while(0)

#define MTL_QTOMR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_QTOMR1_RgOffAddr));\
} while(0)

/*#define  MTL_QTOMR1_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_QTOMR1_Mask_7 (ULONG)(0x1ff)

/*#define MTL_QTOMR1_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_QTOMR1_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define  MTL_QTOMR1_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_QTOMR1_Mask_26 (ULONG)(0x3f)

/*#define MTL_QTOMR1_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_QTOMR1_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MTL_QTOMR1_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR1_FTQ_Mask (ULONG)(0x1)

/*#define MTL_QTOMR1_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_QTOMR1_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_QTOMR1_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR1_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR1_Mask_7))<<7);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR1_Mask_26))<<26);\
		v = ((v & MTL_QTOMR1_FTQ_Wr_Mask) | ((data & MTL_QTOMR1_FTQ_Mask)<<0));\
		MTL_QTOMR1_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR1_FTQ_UdfRd(pdata, data) do {\
		MTL_QTOMR1_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_QTOMR1_FTQ_Mask);\
} while(0)

/*#define MTL_QTOMR1_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_QTOMR1_TSF_Mask (ULONG)(0x1)

/*#define MTL_QTOMR1_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_QTOMR1_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_QTOMR1_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR1_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR1_Mask_7))<<7);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR1_Mask_26))<<26);\
		v = ((v & MTL_QTOMR1_TSF_Wr_Mask) | ((data & MTL_QTOMR1_TSF_Mask)<<1));\
		MTL_QTOMR1_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR1_TSF_UdfRd(pdata, data) do {\
		MTL_QTOMR1_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_QTOMR1_TSF_Mask);\
} while(0)

/*#define MTL_QTOMR1_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_QTOMR1_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_QTOMR1_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_QTOMR1_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_QTOMR1_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR1_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR1_Mask_7))<<7);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR1_Mask_26))<<26);\
		v = ((v & MTL_QTOMR1_TXQEN_Wr_Mask) | ((data & MTL_QTOMR1_TXQEN_Mask)<<2));\
		MTL_QTOMR1_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR1_TXQEN_UdfRd(pdata, data) do {\
		MTL_QTOMR1_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_QTOMR1_TXQEN_Mask);\
} while(0)

/*#define MTL_QTOMR1_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_QTOMR1_TTC_Mask (ULONG)(0x7)

/*#define MTL_QTOMR1_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_QTOMR1_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_QTOMR1_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR1_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR1_Mask_7))<<7);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR1_Mask_26))<<26);\
		v = ((v & MTL_QTOMR1_TTC_Wr_Mask) | ((data & MTL_QTOMR1_TTC_Mask)<<4));\
		MTL_QTOMR1_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR1_TTC_UdfRd(pdata, data) do {\
		MTL_QTOMR1_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_QTOMR1_TTC_Mask);\
} while(0)

/*#define MTL_QTOMR1_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_QTOMR1_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_QTOMR1_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_QTOMR1_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_QTOMR1_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_QTOMR1_RgRd(pdata, v);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_7))|((( 0) & (MTL_QTOMR1_Mask_7))<<7);\
		v = (v & (MTL_QTOMR1_RES_Wr_Mask_26))|((( 0) & (MTL_QTOMR1_Mask_26))<<26);\
		v = ((v & MTL_QTOMR1_TQS_Wr_Mask) | ((data & MTL_QTOMR1_TQS_Mask)<<16));\
		MTL_QTOMR1_RgWr(pdata, v);\
} while(0)

#define MTL_QTOMR1_TQS_UdfRd(pdata, data) do {\
		MTL_QTOMR1_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_QTOMR1_TQS_Mask);\
} while(0)


#define MAC_PMTCSR_RgOffAddr ((BASE_ADDRESS + 0xc0))

#define MAC_PMTCSR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_PMTCSR_RgOffAddr));\
} while(0)

#define MAC_PMTCSR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_PMTCSR_RgOffAddr));\
} while(0)

/*#define  MAC_PMTCSR_Mask_27 (ULONG)(~(~0<<(4)))*/

#define  MAC_PMTCSR_Mask_27 (ULONG)(0xf)

/*#define MAC_PMTCSR_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(4)))<<(27)))*/

#define MAC_PMTCSR_RES_Wr_Mask_27 (ULONG)(0x87ffffff)

/*#define  MAC_PMTCSR_Mask_10 (ULONG)(~(~0<<(14)))*/

#define  MAC_PMTCSR_Mask_10 (ULONG)(0x3fff)

/*#define MAC_PMTCSR_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(14)))<<(10)))*/

#define MAC_PMTCSR_RES_Wr_Mask_10 (ULONG)(0xff0003ff)

/*#define  MAC_PMTCSR_Mask_7 (ULONG)(~(~0<<(2)))*/

#define  MAC_PMTCSR_Mask_7 (ULONG)(0x3)

/*#define MAC_PMTCSR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(2)))<<(7)))*/

#define MAC_PMTCSR_RES_Wr_Mask_7 (ULONG)(0xfffffe7f)

/*#define  MAC_PMTCSR_Mask_3 (ULONG)(~(~0<<(2)))*/

#define  MAC_PMTCSR_Mask_3 (ULONG)(0x3)

/*#define MAC_PMTCSR_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(2)))<<(3)))*/

#define MAC_PMTCSR_RES_Wr_Mask_3 (ULONG)(0xffffffe7)

/*#define MAC_PMTCSR_RWKFILTRST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKFILTRST_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKFILTRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_PMTCSR_RWKFILTRST_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_PMTCSR_RWKFILTRST_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_RWKFILTRST_Wr_Mask) | ((data & MAC_PMTCSR_RWKFILTRST_Mask)<<31));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_RWKFILTRST_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_PMTCSR_RWKFILTRST_Mask);\
} while(0)

/*#define MAC_PMTCSR_RWKPTR_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_PMTCSR_RWKPTR_Mask (ULONG)(0x7)

#define MAC_PMTCSR_RWKPTR_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_PMTCSR_RWKPTR_Mask);\
} while(0)

/*#define MAC_PMTCSR_GLBLUCAST_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_GLBLUCAST_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_GLBLUCAST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MAC_PMTCSR_GLBLUCAST_Wr_Mask (ULONG)(0xfffffdff)

#define MAC_PMTCSR_GLBLUCAST_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_GLBLUCAST_Wr_Mask) | ((data & MAC_PMTCSR_GLBLUCAST_Mask)<<9));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_GLBLUCAST_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_PMTCSR_GLBLUCAST_Mask);\
} while(0)

/*#define MAC_PMTCSR_RWKPRCVD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKPRCVD_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKPRCVD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MAC_PMTCSR_RWKPRCVD_Wr_Mask (ULONG)(0xffffffbf)

#define MAC_PMTCSR_RWKPRCVD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_RWKPRCVD_Wr_Mask) | ((data & MAC_PMTCSR_RWKPRCVD_Mask)<<6));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_RWKPRCVD_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_PMTCSR_RWKPRCVD_Mask);\
} while(0)

/*#define MAC_PMTCSR_MGKPRCVD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_MGKPRCVD_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_MGKPRCVD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_PMTCSR_MGKPRCVD_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_PMTCSR_MGKPRCVD_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_MGKPRCVD_Wr_Mask) | ((data & MAC_PMTCSR_MGKPRCVD_Mask)<<5));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_MGKPRCVD_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_PMTCSR_MGKPRCVD_Mask);\
} while(0)

/*#define MAC_PMTCSR_RWKPKTEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_RWKPKTEN_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_RWKPKTEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_PMTCSR_RWKPKTEN_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_PMTCSR_RWKPKTEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_RWKPKTEN_Wr_Mask) | ((data & MAC_PMTCSR_RWKPKTEN_Mask)<<2));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_RWKPKTEN_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_PMTCSR_RWKPKTEN_Mask);\
} while(0)

/*#define MAC_PMTCSR_MGKPKTEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_MGKPKTEN_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_MGKPKTEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_PMTCSR_MGKPKTEN_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_PMTCSR_MGKPKTEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_MGKPKTEN_Wr_Mask) | ((data & MAC_PMTCSR_MGKPKTEN_Mask)<<1));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_MGKPKTEN_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_PMTCSR_MGKPKTEN_Mask);\
} while(0)

/*#define MAC_PMTCSR_PWRDWN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_PMTCSR_PWRDWN_Mask (ULONG)(0x1)

/*#define MAC_PMTCSR_PWRDWN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_PMTCSR_PWRDWN_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_PMTCSR_PWRDWN_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_PMTCSR_RgRd(pdata, v);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_27))|((( 0) & (MAC_PMTCSR_Mask_27))<<27);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_10))|((( 0) & (MAC_PMTCSR_Mask_10))<<10);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_7))|((( 0) & (MAC_PMTCSR_Mask_7))<<7);\
		v = (v & (MAC_PMTCSR_RES_Wr_Mask_3))|((( 0) & (MAC_PMTCSR_Mask_3))<<3);\
		v = ((v & MAC_PMTCSR_PWRDWN_Wr_Mask) | ((data & MAC_PMTCSR_PWRDWN_Mask)<<0));\
		MAC_PMTCSR_RgWr(pdata, v);\
} while(0)

#define MAC_PMTCSR_PWRDWN_UdfRd(pdata, data) do {\
		MAC_PMTCSR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_PMTCSR_PWRDWN_Mask);\
} while(0)


#define MMC_RXICMP_ERR_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x884))

#define MMC_RXICMP_ERR_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXICMP_ERR_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXICMP_ERR_OCTETS_RXICMP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXICMP_ERR_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXICMP_GD_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x880))

#define MMC_RXICMP_GD_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXICMP_GD_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXICMP_GD_OCTETS_RXICMP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXICMP_GD_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXTCP_ERR_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x87c))

#define MMC_RXTCP_ERR_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXTCP_ERR_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXTCP_ERR_OCTETS_RXTCP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXTCP_ERR_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXTCP_GD_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x878))

#define MMC_RXTCP_GD_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXTCP_GD_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXTCP_GD_OCTETS_RXTCP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXTCP_GD_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXUDP_ERR_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x874))

#define MMC_RXUDP_ERR_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUDP_ERR_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXUDP_ERR_OCTETS_RXUDP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXUDP_ERR_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXUDP_GD_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x870))

#define MMC_RXUDP_GD_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUDP_GD_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXUDP_GD_OCTETS_RXUDP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXUDP_GD_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_NOPAY_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x86c))

#define MMC_RXIPV6_NOPAY_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_NOPAY_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_NOPAY_OCTETS_RXIPV6_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_NOPAY_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_HDRERR_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x868))

#define MMC_RXIPV6_HDRERR_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_HDRERR_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_HDRERR_OCTETS_RXIPV6_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_HDRERR_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_GD_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x864))

#define MMC_RXIPV6_GD_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_GD_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_GD_OCTETS_RXIPV6_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_GD_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_UDSBL_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x860))

#define MMC_RXIPV4_UDSBL_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_UDSBL_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_UDSBL_OCTETS_RXIPV4_UDSBL_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_UDSBL_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_FRAG_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x85c))

#define MMC_RXIPV4_FRAG_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_FRAG_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_FRAG_OCTETS_RXIPV4_FRAG_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_FRAG_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_NOPAY_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x858))

#define MMC_RXIPV4_NOPAY_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_NOPAY_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_NOPAY_OCTETS_RXIPV4_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_NOPAY_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_HDRERR_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x854))

#define MMC_RXIPV4_HDRERR_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_HDRERR_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_HDRERR_OCTETS_RXIPV4_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_HDRERR_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_GD_OCTETS_RgOffAddr ((BASE_ADDRESS + 0x850))

#define MMC_RXIPV4_GD_OCTETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_GD_OCTETS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_GD_OCTETS_RXIPV4_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_GD_OCTETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXICMP_ERR_PKTS_RgOffAddr ((BASE_ADDRESS + 0x844))

#define MMC_RXICMP_ERR_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXICMP_ERR_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXICMP_ERR_PKTS_RXICMP_ERR_PKTS_UdfRd(pdata, data) do {\
		MMC_RXICMP_ERR_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXICMP_GD_PKTS_RgOffAddr ((BASE_ADDRESS + 0x840))

#define MMC_RXICMP_GD_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXICMP_GD_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXICMP_GD_PKTS_RXICMP_GD_PKTS_UdfRd(pdata, data) do {\
		MMC_RXICMP_GD_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXTCP_ERR_PKTS_RgOffAddr ((BASE_ADDRESS + 0x83c))

#define MMC_RXTCP_ERR_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXTCP_ERR_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXTCP_ERR_PKTS_RXTCP_ERR_PKTS_UdfRd(pdata, data) do {\
		MMC_RXTCP_ERR_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXTCP_GD_PKTS_RgOffAddr ((BASE_ADDRESS + 0x838))

#define MMC_RXTCP_GD_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXTCP_GD_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXTCP_GD_PKTS_RXTCP_GD_PKTS_UdfRd(pdata, data) do {\
		MMC_RXTCP_GD_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXUDP_ERR_PKTS_RgOffAddr ((BASE_ADDRESS + 0x834))

#define MMC_RXUDP_ERR_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUDP_ERR_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXUDP_ERR_PKTS_RXUDP_ERR_PKTS_UdfRd(pdata, data) do {\
		MMC_RXUDP_ERR_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXUDP_GD_PKTS_RgOffAddr ((BASE_ADDRESS + 0x830))

#define MMC_RXUDP_GD_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUDP_GD_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXUDP_GD_PKTS_RXUDP_GD_PKTS_UdfRd(pdata, data) do {\
		MMC_RXUDP_GD_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_NOPAY_PKTS_RgOffAddr ((BASE_ADDRESS + 0x82c))

#define MMC_RXIPV6_NOPAY_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_NOPAY_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_NOPAY_PKTS_RXIPV6_NOPAY_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_NOPAY_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_HDRERR_PKTS_RgOffAddr ((BASE_ADDRESS + 0x828))

#define MMC_RXIPV6_HDRERR_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_HDRERR_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_HDRERR_PKTS_RXIPV6_HDRERR_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_HDRERR_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV6_GD_PKTS_RgOffAddr ((BASE_ADDRESS + 0x824))

#define MMC_RXIPV6_GD_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV6_GD_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV6_GD_PKTS_RXIPV6_GD_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV6_GD_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_UBSBL_PKTS_RgOffAddr ((BASE_ADDRESS + 0x820))

#define MMC_RXIPV4_UBSBL_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_UBSBL_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_UBSBL_PKTS_RXIPV4_UBSBL_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_UBSBL_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_FRAG_PKTS_RgOffAddr ((BASE_ADDRESS + 0x81c))

#define MMC_RXIPV4_FRAG_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_FRAG_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_FRAG_PKTS_RXIPV4_FRAG_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_FRAG_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_NOPAY_PKTS_RgOffAddr ((BASE_ADDRESS + 0x818))

#define MMC_RXIPV4_NOPAY_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_NOPAY_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_NOPAY_PKTS_RXIPV4_NOPAY_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_NOPAY_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_HDRERR_PKTS_RgOffAddr ((BASE_ADDRESS + 0x814))

#define MMC_RXIPV4_HDRERR_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_HDRERR_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_HDRERR_PKTS_RXIPV4_HDRERR_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_HDRERR_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXIPV4_GD_PKTS_RgOffAddr ((BASE_ADDRESS + 0x810))

#define MMC_RXIPV4_GD_PKTS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXIPV4_GD_PKTS_RgOffAddr));\
} while(0)

#define MMC_RXIPV4_GD_PKTS_RXIPV4_GD_PKTS_UdfRd(pdata, data) do {\
		MMC_RXIPV4_GD_PKTS_RgRd(pdata, data);\
} while(0)


#define MMC_RXCTRLPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x7e4))

#define MMC_RXCTRLPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXCTRLPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_RXCTRLPACKETS_G_RXCTRLPACKETS_G_UdfRd(pdata, data) do {\
		MMC_RXCTRLPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXRCVERROR_RgOffAddr ((BASE_ADDRESS + 0x7e0))

#define MMC_RXRCVERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXRCVERROR_RgOffAddr));\
} while(0)

#define MMC_RXRCVERROR_RXRCVERROR_UdfRd(pdata, data) do {\
		MMC_RXRCVERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXWATCHDOGERROR_RgOffAddr ((BASE_ADDRESS + 0x7dc))

#define MMC_RXWATCHDOGERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXWATCHDOGERROR_RgOffAddr));\
} while(0)

#define MMC_RXWATCHDOGERROR_RXWATCHDOGERROR_UdfRd(pdata, data) do {\
		MMC_RXWATCHDOGERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXVLANPACKETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7d8))

#define MMC_RXVLANPACKETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXVLANPACKETS_GB_RgOffAddr));\
} while(0)

#define MMC_RXVLANPACKETS_GB_RXVLANPACKETS_GB_UdfRd(pdata, data) do {\
		MMC_RXVLANPACKETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RXFIFOOVERFLOW_RgOffAddr ((BASE_ADDRESS + 0x7d4))

#define MMC_RXFIFOOVERFLOW_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXFIFOOVERFLOW_RgOffAddr));\
} while(0)

#define MMC_RXFIFOOVERFLOW_RXFIFOOVERFLOW_UdfRd(pdata, data) do {\
		MMC_RXFIFOOVERFLOW_RgRd(pdata, data);\
} while(0)


#define MMC_RXPAUSEPACKETS_RgOffAddr ((BASE_ADDRESS + 0x7d0))

#define MMC_RXPAUSEPACKETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXPAUSEPACKETS_RgOffAddr));\
} while(0)

#define MMC_RXPAUSEPACKETS_RXPAUSEPACKETS_UdfRd(pdata, data) do {\
		MMC_RXPAUSEPACKETS_RgRd(pdata, data);\
} while(0)


#define MMC_RXOUTOFRANGETYPE_RgOffAddr ((BASE_ADDRESS + 0x7cc))

#define MMC_RXOUTOFRANGETYPE_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXOUTOFRANGETYPE_RgOffAddr));\
} while(0)

#define MMC_RXOUTOFRANGETYPE_RXOUTOFRANGETYPE_UdfRd(pdata, data) do {\
		MMC_RXOUTOFRANGETYPE_RgRd(pdata, data);\
} while(0)


#define MMC_RXLENGTHERROR_RgOffAddr ((BASE_ADDRESS + 0x7c8))

#define MMC_RXLENGTHERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXLENGTHERROR_RgOffAddr));\
} while(0)

#define MMC_RXLENGTHERROR_RXLENGTHERROR_UdfRd(pdata, data) do {\
		MMC_RXLENGTHERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXUNICASTPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x7c4))

#define MMC_RXUNICASTPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUNICASTPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_RXUNICASTPACKETS_G_RXUNICASTPACKETS_G_UdfRd(pdata, data) do {\
		MMC_RXUNICASTPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_RX1024TOMAXOCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7c0))

#define MMC_RX1024TOMAXOCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX1024TOMAXOCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX1024TOMAXOCTETS_GB_RX1024TOMAXOCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX1024TOMAXOCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RX512TO1023OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7bc))

#define MMC_RX512TO1023OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX512TO1023OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX512TO1023OCTETS_GB_RX512TO1023OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX512TO1023OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RX256TO511OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7b8))

#define MMC_RX256TO511OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX256TO511OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX256TO511OCTETS_GB_RX256TO511OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX256TO511OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RX128TO255OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7b4))

#define MMC_RX128TO255OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX128TO255OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX128TO255OCTETS_GB_RX128TO255OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX128TO255OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RX65TO127OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7b0))

#define MMC_RX65TO127OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX65TO127OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX65TO127OCTETS_GB_RX65TO127OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX65TO127OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RX64OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x7ac))

#define MMC_RX64OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RX64OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_RX64OCTETS_GB_RX64OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_RX64OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RXOVERSIZE_G_RgOffAddr ((BASE_ADDRESS + 0x7a8))

#define MMC_RXOVERSIZE_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXOVERSIZE_G_RgOffAddr));\
} while(0)

#define MMC_RXOVERSIZE_G_RXOVERSIZE_G_UdfRd(pdata, data) do {\
		MMC_RXOVERSIZE_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXUNDERSIZE_G_RgOffAddr ((BASE_ADDRESS + 0x7a4))

#define MMC_RXUNDERSIZE_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXUNDERSIZE_G_RgOffAddr));\
} while(0)

#define MMC_RXUNDERSIZE_G_RXUNDERSIZE_G_UdfRd(pdata, data) do {\
		MMC_RXUNDERSIZE_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXJABBERERROR_RgOffAddr ((BASE_ADDRESS + 0x7a0))

#define MMC_RXJABBERERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXJABBERERROR_RgOffAddr));\
} while(0)

#define MMC_RXJABBERERROR_RXJABBERERROR_UdfRd(pdata, data) do {\
		MMC_RXJABBERERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXRUNTERROR_RgOffAddr ((BASE_ADDRESS + 0x79c))

#define MMC_RXRUNTERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXRUNTERROR_RgOffAddr));\
} while(0)

#define MMC_RXRUNTERROR_RXRUNTERROR_UdfRd(pdata, data) do {\
		MMC_RXRUNTERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXALIGNMENTERROR_RgOffAddr ((BASE_ADDRESS + 0x798))

#define MMC_RXALIGNMENTERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXALIGNMENTERROR_RgOffAddr));\
} while(0)

#define MMC_RXALIGNMENTERROR_RXALIGNMENTERROR_UdfRd(pdata, data) do {\
		MMC_RXALIGNMENTERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXCRCERROR_RgOffAddr ((BASE_ADDRESS + 0x794))

#define MMC_RXCRCERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXCRCERROR_RgOffAddr));\
} while(0)

#define MMC_RXCRCERROR_RXCRCERROR_UdfRd(pdata, data) do {\
		MMC_RXCRCERROR_RgRd(pdata, data);\
} while(0)


#define MMC_RXMULTICASTPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x790))

#define MMC_RXMULTICASTPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXMULTICASTPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_RXMULTICASTPACKETS_G_RXMULTICASTPACKETS_G_UdfRd(pdata, data) do {\
		MMC_RXMULTICASTPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXBROADCASTPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x78c))

#define MMC_RXBROADCASTPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXBROADCASTPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_RXBROADCASTPACKETS_G_RXBROADCASTPACKETS_G_UdfRd(pdata, data) do {\
		MMC_RXBROADCASTPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXOCTETCOUNT_G_RgOffAddr ((BASE_ADDRESS + 0x788))

#define MMC_RXOCTETCOUNT_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXOCTETCOUNT_G_RgOffAddr));\
} while(0)

#define MMC_RXOCTETCOUNT_G_RXOCTETCOUNT_G_UdfRd(pdata, data) do {\
		MMC_RXOCTETCOUNT_G_RgRd(pdata, data);\
} while(0)


#define MMC_RXOCTETCOUNT_GB_RgOffAddr ((BASE_ADDRESS + 0x784))

#define MMC_RXOCTETCOUNT_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXOCTETCOUNT_GB_RgOffAddr));\
} while(0)

#define MMC_RXOCTETCOUNT_GB_RXOCTETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_RXOCTETCOUNT_GB_RgRd(pdata, data);\
} while(0)


#define MMC_RXPACKETCOUNT_GB_RgOffAddr ((BASE_ADDRESS + 0x780))

#define MMC_RXPACKETCOUNT_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_RXPACKETCOUNT_GB_RgOffAddr));\
} while(0)

#define MMC_RXPACKETCOUNT_GB_RXPACKETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_RXPACKETCOUNT_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TXOVERSIZE_G_RgOffAddr ((BASE_ADDRESS + 0x778))

#define MMC_TXOVERSIZE_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXOVERSIZE_G_RgOffAddr));\
} while(0)

#define MMC_TXOVERSIZE_G_TXOVERSIZE_G_UdfRd(pdata, data) do {\
		MMC_TXOVERSIZE_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXVLANPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x774))

#define MMC_TXVLANPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXVLANPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_TXVLANPACKETS_G_TXVLANPACKETS_G_UdfRd(pdata, data) do {\
		MMC_TXVLANPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXPAUSEPACKETS_RgOffAddr ((BASE_ADDRESS + 0x770))

#define MMC_TXPAUSEPACKETS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXPAUSEPACKETS_RgOffAddr));\
} while(0)

#define MMC_TXPAUSEPACKETS_TXPAUSEPACKETS_UdfRd(pdata, data) do {\
		MMC_TXPAUSEPACKETS_RgRd(pdata, data);\
} while(0)


#define MMC_TXEXCESSDEF_RgOffAddr ((BASE_ADDRESS + 0x76c))

#define MMC_TXEXCESSDEF_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXEXCESSDEF_RgOffAddr));\
} while(0)

#define MMC_TXEXCESSDEF_TXEXCESSDEF_UdfRd(pdata, data) do {\
		MMC_TXEXCESSDEF_RgRd(pdata, data);\
} while(0)


#define MMC_TXPACKETSCOUNT_G_RgOffAddr ((BASE_ADDRESS + 0x768))

#define MMC_TXPACKETSCOUNT_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXPACKETSCOUNT_G_RgOffAddr));\
} while(0)

#define MMC_TXPACKETSCOUNT_G_TXPACKETSCOUNT_G_UdfRd(pdata, data) do {\
		MMC_TXPACKETSCOUNT_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXOCTETCOUNT_G_RgOffAddr ((BASE_ADDRESS + 0x764))

#define MMC_TXOCTETCOUNT_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXOCTETCOUNT_G_RgOffAddr));\
} while(0)

#define MMC_TXOCTETCOUNT_G_TXOCTETCOUNT_G_UdfRd(pdata, data) do {\
		MMC_TXOCTETCOUNT_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXCARRIERERROR_RgOffAddr ((BASE_ADDRESS + 0x760))

#define MMC_TXCARRIERERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXCARRIERERROR_RgOffAddr));\
} while(0)

#define MMC_TXCARRIERERROR_TXCARRIERERROR_UdfRd(pdata, data) do {\
		MMC_TXCARRIERERROR_RgRd(pdata, data);\
} while(0)


#define MMC_TXEXESSCOL_RgOffAddr ((BASE_ADDRESS + 0x75c))

#define MMC_TXEXESSCOL_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXEXESSCOL_RgOffAddr));\
} while(0)

#define MMC_TXEXESSCOL_TXEXESSCOL_UdfRd(pdata, data) do {\
		MMC_TXEXESSCOL_RgRd(pdata, data);\
} while(0)


#define MMC_TXLATECOL_RgOffAddr ((BASE_ADDRESS + 0x758))

#define MMC_TXLATECOL_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXLATECOL_RgOffAddr));\
} while(0)

#define MMC_TXLATECOL_TXLATECOL_UdfRd(pdata, data) do {\
		MMC_TXLATECOL_RgRd(pdata, data);\
} while(0)


#define MMC_TXDEFERRED_RgOffAddr ((BASE_ADDRESS + 0x754))

#define MMC_TXDEFERRED_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXDEFERRED_RgOffAddr));\
} while(0)

#define MMC_TXDEFERRED_TXDEFERRED_UdfRd(pdata, data) do {\
		MMC_TXDEFERRED_RgRd(pdata, data);\
} while(0)


#define MMC_TXMULTICOL_G_RgOffAddr ((BASE_ADDRESS + 0x750))

#define MMC_TXMULTICOL_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXMULTICOL_G_RgOffAddr));\
} while(0)

#define MMC_TXMULTICOL_G_TXMULTICOL_G_UdfRd(pdata, data) do {\
		MMC_TXMULTICOL_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXSINGLECOL_G_RgOffAddr ((BASE_ADDRESS + 0x74c))

#define MMC_TXSINGLECOL_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXSINGLECOL_G_RgOffAddr));\
} while(0)

#define MMC_TXSINGLECOL_G_TXSINGLECOL_G_UdfRd(pdata, data) do {\
		MMC_TXSINGLECOL_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXUNDERFLOWERROR_RgOffAddr ((BASE_ADDRESS + 0x748))

#define MMC_TXUNDERFLOWERROR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXUNDERFLOWERROR_RgOffAddr));\
} while(0)

#define MMC_TXUNDERFLOWERROR_TXUNDERFLOWERROR_UdfRd(pdata, data) do {\
		MMC_TXUNDERFLOWERROR_RgRd(pdata, data);\
} while(0)


#define MMC_TXBROADCASTPACKETS_GB_RgOffAddr ((BASE_ADDRESS + 0x744))

#define MMC_TXBROADCASTPACKETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXBROADCASTPACKETS_GB_RgOffAddr));\
} while(0)

#define MMC_TXBROADCASTPACKETS_GB_TXBROADCASTPACKETS_GB_UdfRd(pdata, data) do {\
		MMC_TXBROADCASTPACKETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TXMULTICASTPACKETS_GB_RgOffAddr ((BASE_ADDRESS + 0x740))

#define MMC_TXMULTICASTPACKETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXMULTICASTPACKETS_GB_RgOffAddr));\
} while(0)

#define MMC_TXMULTICASTPACKETS_GB_TXMULTICASTPACKETS_GB_UdfRd(pdata, data) do {\
		MMC_TXMULTICASTPACKETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TXUNICASTPACKETS_GB_RgOffAddr ((BASE_ADDRESS + 0x73c))

#define MMC_TXUNICASTPACKETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXUNICASTPACKETS_GB_RgOffAddr));\
} while(0)

#define MMC_TXUNICASTPACKETS_GB_TXUNICASTPACKETS_GB_UdfRd(pdata, data) do {\
		MMC_TXUNICASTPACKETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX1024TOMAXOCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x738))

#define MMC_TX1024TOMAXOCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX1024TOMAXOCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX1024TOMAXOCTETS_GB_TX1024TOMAXOCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX1024TOMAXOCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX512TO1023OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x734))

#define MMC_TX512TO1023OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX512TO1023OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX512TO1023OCTETS_GB_TX512TO1023OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX512TO1023OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX256TO511OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x730))

#define MMC_TX256TO511OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX256TO511OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX256TO511OCTETS_GB_TX256TO511OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX256TO511OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX128TO255OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x72c))

#define MMC_TX128TO255OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX128TO255OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX128TO255OCTETS_GB_TX128TO255OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX128TO255OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX65TO127OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x728))

#define MMC_TX65TO127OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX65TO127OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX65TO127OCTETS_GB_TX65TO127OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX65TO127OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TX64OCTETS_GB_RgOffAddr ((BASE_ADDRESS + 0x724))

#define MMC_TX64OCTETS_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TX64OCTETS_GB_RgOffAddr));\
} while(0)

#define MMC_TX64OCTETS_GB_TX64OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_TX64OCTETS_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TXMULTICASTPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x720))

#define MMC_TXMULTICASTPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXMULTICASTPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_TXMULTICASTPACKETS_G_TXMULTICASTPACKETS_G_UdfRd(pdata, data) do {\
		MMC_TXMULTICASTPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXBROADCASTPACKETS_G_RgOffAddr ((BASE_ADDRESS + 0x71c))

#define MMC_TXBROADCASTPACKETS_G_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXBROADCASTPACKETS_G_RgOffAddr));\
} while(0)

#define MMC_TXBROADCASTPACKETS_G_TXBROADCASTPACKETS_G_UdfRd(pdata, data) do {\
		MMC_TXBROADCASTPACKETS_G_RgRd(pdata, data);\
} while(0)


#define MMC_TXPACKETCOUNT_GB_RgOffAddr ((BASE_ADDRESS + 0x718))

#define MMC_TXPACKETCOUNT_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXPACKETCOUNT_GB_RgOffAddr));\
} while(0)

#define MMC_TXPACKETCOUNT_GB_TXPACKETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_TXPACKETCOUNT_GB_RgRd(pdata, data);\
} while(0)


#define MMC_TXOCTETCOUNT_GB_RgOffAddr ((BASE_ADDRESS + 0x714))

#define MMC_TXOCTETCOUNT_GB_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_TXOCTETCOUNT_GB_RgOffAddr));\
} while(0)

#define MMC_TXOCTETCOUNT_GB_TXOCTETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_TXOCTETCOUNT_GB_RgRd(pdata, data);\
} while(0)


#define MMC_IPC_INTR_RX_RgOffAddr ((BASE_ADDRESS + 0x808))

#define MMC_IPC_INTR_RX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_IPC_INTR_RX_RgOffAddr));\
} while(0)

/*#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 29) & MMC_IPC_INTR_RX_RXICMP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 28) & MMC_IPC_INTR_RX_RXICMP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 27) & MMC_IPC_INTR_RX_RXTCP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 26) & MMC_IPC_INTR_RX_RXTCP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 25) & MMC_IPC_INTR_RX_RXUDP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 24) & MMC_IPC_INTR_RX_RXUDP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_IPC_INTR_RX_RXIPV6_NOPAY_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_IPC_INTR_RX_RXIPV6_HDRERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_IPC_INTR_RX_RXIPV6_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_IPC_INTR_RX_RXIPV4_UDSBL_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_IPC_INTR_RX_RXIPV4_FRAG_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_IPC_INTR_RX_RXIPV4_NOPAY_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_IPC_INTR_RX_RXIPV4_HDRERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_IPC_INTR_RX_RXIPV4_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_IPC_INTR_RX_RXICMP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXICMP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_IPC_INTR_RX_RXICMP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_IPC_INTR_RX_RXTCP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXTCP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_IPC_INTR_RX_RXTCP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_IPC_INTR_RX_RXUDP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXUDP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_IPC_INTR_RX_RXUDP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_IPC_INTR_RX_RXIPV6_NOPAY_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_IPC_INTR_RX_RXIPV6_HDRERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_IPC_INTR_RX_RXIPV6_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_IPC_INTR_RX_RXIPV4_UDSBL_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_IPC_INTR_RX_RXIPV4_FRAG_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_IPC_INTR_RX_RXIPV4_NOPAY_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_IPC_INTR_RX_RXIPV4_HDRERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_Mask (ULONG)(0x1)

#define MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_IPC_INTR_RX_RXIPV4_GD_FRMS_Mask);\
} while(0)


#define MMC_IPC_INTR_MASK_RX_RgOffAddr ((BASE_ADDRESS + 0x800))

#define MMC_IPC_INTR_MASK_RX_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_IPC_INTR_MASK_RX_RgOffAddr));\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_IPC_INTR_MASK_RX_RgOffAddr));\
} while(0)

/*#define  MMC_IPC_INTR_MASK_RX_Mask_30 (ULONG)(~(~0<<(2)))*/

#define  MMC_IPC_INTR_MASK_RX_Mask_30 (ULONG)(0x3)

/*#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(2)))<<(30)))*/

#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30 (ULONG)(0x3fffffff)

/*#define  MMC_IPC_INTR_MASK_RX_Mask_14 (ULONG)(~(~0<<(2)))*/

#define  MMC_IPC_INTR_MASK_RX_Mask_14 (ULONG)(0x3)

/*#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14 (ULONG)(~((~(~0<<(2)))<<(14)))*/

#define MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14 (ULONG)(0xffff3fff)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (29)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Wr_Mask (ULONG)(0xdfffffff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Mask)<<29));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 29) & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Wr_Mask (ULONG)(0xefffffff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Mask)<<28));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 28) & MMC_IPC_INTR_MASK_RX_RXICMP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Wr_Mask (ULONG)(0xf7ffffff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Mask)<<27));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 27) & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Wr_Mask (ULONG)(0xfbffffff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Mask)<<26));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 26) & MMC_IPC_INTR_MASK_RX_RXTCP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Wr_Mask (ULONG)(0xfdffffff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Mask)<<25));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 25) & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Wr_Mask (ULONG)(0xfeffffff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Mask)<<24));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 24) & MMC_IPC_INTR_MASK_RX_RXUDP_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Wr_Mask (ULONG)(0xff7fffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Mask)<<23));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Wr_Mask (ULONG)(0xffbfffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Mask)<<22));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Wr_Mask (ULONG)(0xffdfffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Mask)<<21));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Wr_Mask (ULONG)(0xffefffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Mask)<<20));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Wr_Mask (ULONG)(0xfff7ffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Mask)<<19));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Wr_Mask (ULONG)(0xfffbffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Mask)<<18));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Wr_Mask (ULONG)(0xfffdffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Mask)<<17));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Wr_Mask (ULONG)(0xfffeffff)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Mask)<<16));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_OCTETS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Wr_Mask (ULONG)(0xffffdfff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Mask)<<13));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_IPC_INTR_MASK_RX_RXICMP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Wr_Mask (ULONG)(0xffffefff)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Mask)<<12));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_IPC_INTR_MASK_RX_RXICMP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Wr_Mask (ULONG)(0xfffff7ff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Mask)<<11));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_IPC_INTR_MASK_RX_RXTCP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Wr_Mask (ULONG)(0xfffffbff)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Mask)<<10));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_IPC_INTR_MASK_RX_RXTCP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Wr_Mask (ULONG)(0xfffffdff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Mask)<<9));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_IPC_INTR_MASK_RX_RXUDP_ERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Mask)<<8));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_IPC_INTR_MASK_RX_RXUDP_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Wr_Mask (ULONG)(0xffffff7f)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Mask)<<7));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_IPC_INTR_MASK_RX_RXIPV6_NOPAY_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Wr_Mask (ULONG)(0xffffffbf)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Mask)<<6));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_IPC_INTR_MASK_RX_RXIPV6_HDRERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Mask)<<5));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_IPC_INTR_MASK_RX_RXIPV6_GD_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Wr_Mask (ULONG)(0xffffffef)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Mask)<<4));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_IPC_INTR_MASK_RX_RXIPV4_UDSBL_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Mask)<<3));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_IPC_INTR_MASK_RX_RXIPV4_FRAG_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Mask)<<2));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_IPC_INTR_MASK_RX_RXIPV4_NOPAY_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Mask)<<1));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_IPC_INTR_MASK_RX_RXIPV4_HDRERR_FRMS_Mask);\
} while(0)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Mask (ULONG)(0x1)

/*#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_30))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_30))<<30);\
		v = (v & (MMC_IPC_INTR_MASK_RX_RES_Wr_Mask_14))|((( 0) & (MMC_IPC_INTR_MASK_RX_Mask_14))<<14);\
		v = ((v & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Wr_Mask) | ((data & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Mask)<<0));\
		MMC_IPC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_UdfRd(pdata, data) do {\
		MMC_IPC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_IPC_INTR_MASK_RX_RXIPV4_GD_FRMS_Mask);\
} while(0)


#define MMC_INTR_MASK_TX_RgOffAddr ((BASE_ADDRESS + 0x710))

#define MMC_INTR_MASK_TX_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_INTR_MASK_TX_RgOffAddr));\
} while(0)

#define MMC_INTR_MASK_TX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_INTR_MASK_TX_RgOffAddr));\
} while(0)

/*#define  MMC_INTR_MASK_TX_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MMC_INTR_MASK_TX_Mask_25 (ULONG)(0x7f)

/*#define MMC_INTR_MASK_TX_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MMC_INTR_MASK_TX_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_Wr_Mask (ULONG)(0xfeffffff)

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXVLANFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXVLANFRAMES_G_Mask)<<24));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXVLANFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 24) & MMC_INTR_MASK_TX_TXVLANFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_Wr_Mask (ULONG)(0xff7fffff)

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXPAUSEFRAMES_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXPAUSEFRAMES_Mask)<<23));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXPAUSEFRAMES_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_INTR_MASK_TX_TXPAUSEFRAMES_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXEXCESSDEF_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXEXCESSDEF_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXEXCESSDEF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_MASK_TX_TXEXCESSDEF_Wr_Mask (ULONG)(0xffbfffff)

#define MMC_INTR_MASK_TX_TXEXCESSDEF_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXEXCESSDEF_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXEXCESSDEF_Mask)<<22));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXEXCESSDEF_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_INTR_MASK_TX_TXEXCESSDEF_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Wr_Mask (ULONG)(0xffdfffff)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Mask)<<21));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_INTR_MASK_TX_TXFRAMECOUNT_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Wr_Mask (ULONG)(0xffefffff)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Mask)<<20));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_INTR_MASK_TX_TXOCTETCOUNT_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXCARRIERERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXCARRIERERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXCARRIERERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_MASK_TX_TXCARRIERERROR_Wr_Mask (ULONG)(0xfff7ffff)

#define MMC_INTR_MASK_TX_TXCARRIERERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXCARRIERERROR_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXCARRIERERROR_Mask)<<19));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXCARRIERERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_INTR_MASK_TX_TXCARRIERERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXEXESSCOL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXEXESSCOL_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXEXESSCOL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_MASK_TX_TXEXESSCOL_Wr_Mask (ULONG)(0xfffbffff)

#define MMC_INTR_MASK_TX_TXEXESSCOL_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXEXESSCOL_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXEXESSCOL_Mask)<<18));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXEXESSCOL_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_INTR_MASK_TX_TXEXESSCOL_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXLATECOL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXLATECOL_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXLATECOL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_MASK_TX_TXLATECOL_Wr_Mask (ULONG)(0xfffdffff)

#define MMC_INTR_MASK_TX_TXLATECOL_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXLATECOL_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXLATECOL_Mask)<<17));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXLATECOL_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_INTR_MASK_TX_TXLATECOL_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXDEFERRED_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXDEFERRED_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXDEFERRED_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_MASK_TX_TXDEFERRED_Wr_Mask (ULONG)(0xfffeffff)

#define MMC_INTR_MASK_TX_TXDEFERRED_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXDEFERRED_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXDEFERRED_Mask)<<16));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXDEFERRED_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_INTR_MASK_TX_TXDEFERRED_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXMULTICOL_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICOL_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICOL_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_MASK_TX_TXMULTICOL_G_Wr_Mask (ULONG)(0xffff7fff)

#define MMC_INTR_MASK_TX_TXMULTICOL_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICOL_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXMULTICOL_G_Mask)<<15));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXMULTICOL_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 15) & MMC_INTR_MASK_TX_TXMULTICOL_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_Wr_Mask (ULONG)(0xffffbfff)

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXSINGLECOL_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXSINGLECOL_G_Mask)<<14));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXSINGLECOL_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 14) & MMC_INTR_MASK_TX_TXSINGLECOL_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Wr_Mask (ULONG)(0xffffdfff)

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Mask)<<13));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXUNDERFLOWERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_INTR_MASK_TX_TXUNDERFLOWERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Wr_Mask (ULONG)(0xffffefff)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Mask)<<12));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Wr_Mask (ULONG)(0xfffff7ff)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Mask)<<11));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Wr_Mask (ULONG)(0xfffffbff)

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Mask)<<10));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_INTR_MASK_TX_TXUNICASTFRAMES_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(0xfffffdff)

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Mask)<<9));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_INTR_MASK_TX_TX1024TOMAXOCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Mask)<<8));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_INTR_MASK_TX_TX512TO1023OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Wr_Mask (ULONG)(0xffffff7f)

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Mask)<<7));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_INTR_MASK_TX_TX256TO511OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Wr_Mask (ULONG)(0xffffffbf)

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Mask)<<6));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_INTR_MASK_TX_TX128TO255OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Mask)<<5));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_INTR_MASK_TX_TX65TO127OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_Wr_Mask (ULONG)(0xffffffef)

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TX64OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TX64OCTETS_GB_Mask)<<4));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TX64OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_INTR_MASK_TX_TX64OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Mask)<<3));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_INTR_MASK_TX_TXMULTICASTFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Mask)<<2));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_INTR_MASK_TX_TXBROADCASTFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Mask)<<1));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_INTR_MASK_TX_TXFRAMECOUNT_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_TX_RES_Wr_Mask_25))|((( 0) & (MMC_INTR_MASK_TX_Mask_25))<<25);\
		v = ((v & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Wr_Mask) | ((data & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Mask)<<0));\
		MMC_INTR_MASK_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_TX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_INTR_MASK_TX_TXOCTETCOUNT_GB_Mask);\
} while(0)


#define MMC_INTR_MASK_RX_RgOffAddr ((BASE_ADDRESS + 0x70c))

#define MMC_INTR_MASK_RX_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_INTR_MASK_RX_RgOffAddr));\
} while(0)

#define MMC_INTR_MASK_RX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_INTR_MASK_RX_RgOffAddr));\
} while(0)

/*#define  MMC_INTR_MASK_RX_Mask_24 (ULONG)(~(~0<<(8)))*/

#define  MMC_INTR_MASK_RX_Mask_24 (ULONG)(0xff)

/*#define MMC_INTR_MASK_RX_RES_Wr_Mask_24 (ULONG)(~((~(~0<<(8)))<<(24)))*/

#define MMC_INTR_MASK_RX_RES_Wr_Mask_24 (ULONG)(0xffffff)

/*#define MMC_INTR_MASK_RX_RXWATCHDOG_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXWATCHDOG_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXWATCHDOG_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_MASK_RX_RXWATCHDOG_Wr_Mask (ULONG)(0xff7fffff)

#define MMC_INTR_MASK_RX_RXWATCHDOG_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXWATCHDOG_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXWATCHDOG_Mask)<<23));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXWATCHDOG_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_INTR_MASK_RX_RXWATCHDOG_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Wr_Mask (ULONG)(0xffbfffff)

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Mask)<<22));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXVLANFRAMES_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_INTR_MASK_RX_RXVLANFRAMES_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Wr_Mask (ULONG)(0xffdfffff)

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Mask)<<21));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXFIFOOVERFLOW_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_INTR_MASK_RX_RXFIFOOVERFLOW_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_Wr_Mask (ULONG)(0xffefffff)

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXPAUSEFRAMES_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXPAUSEFRAMES_Mask)<<20));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXPAUSEFRAMES_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_INTR_MASK_RX_RXPAUSEFRAMES_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Wr_Mask (ULONG)(0xfff7ffff)

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Mask)<<19));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_INTR_MASK_RX_RXOUTOFRANGETYPE_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXLENGTHERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXLENGTHERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXLENGTHERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_MASK_RX_RXLENGTHERROR_Wr_Mask (ULONG)(0xfffbffff)

#define MMC_INTR_MASK_RX_RXLENGTHERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXLENGTHERROR_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXLENGTHERROR_Mask)<<18));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXLENGTHERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_INTR_MASK_RX_RXLENGTHERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Wr_Mask (ULONG)(0xfffdffff)

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Mask)<<17));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_INTR_MASK_RX_RXUNICASTFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Wr_Mask (ULONG)(0xfffeffff)

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Mask)<<16));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_INTR_MASK_RX_RX1024TOMAXOCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Wr_Mask (ULONG)(0xffff7fff)

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Mask)<<15));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 15) & MMC_INTR_MASK_RX_RX512TO1023OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Wr_Mask (ULONG)(0xffffbfff)

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Mask)<<14));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 14) & MMC_INTR_MASK_RX_RX256TO511OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Wr_Mask (ULONG)(0xffffdfff)

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Mask)<<13));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_INTR_MASK_RX_RX128TO255OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Wr_Mask (ULONG)(0xffffefff)

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Mask)<<12));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_INTR_MASK_RX_RX65TO127OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_Wr_Mask (ULONG)(0xfffff7ff)

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RX64OCTETS_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RX64OCTETS_GB_Mask)<<11));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RX64OCTETS_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_INTR_MASK_RX_RX64OCTETS_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_Wr_Mask (ULONG)(0xfffffbff)

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXOVERSIZE_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXOVERSIZE_G_Mask)<<10));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXOVERSIZE_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_INTR_MASK_RX_RXOVERSIZE_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_Wr_Mask (ULONG)(0xfffffdff)

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXUNDERSIZE_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXUNDERSIZE_G_Mask)<<9));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXUNDERSIZE_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_INTR_MASK_RX_RXUNDERSIZE_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXJABBERERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXJABBERERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXJABBERERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_MASK_RX_RXJABBERERROR_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_INTR_MASK_RX_RXJABBERERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXJABBERERROR_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXJABBERERROR_Mask)<<8));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXJABBERERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_INTR_MASK_RX_RXJABBERERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXRUNTERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXRUNTERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXRUNTERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_MASK_RX_RXRUNTERROR_Wr_Mask (ULONG)(0xffffff7f)

#define MMC_INTR_MASK_RX_RXRUNTERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXRUNTERROR_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXRUNTERROR_Mask)<<7));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXRUNTERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_INTR_MASK_RX_RXRUNTERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_Wr_Mask (ULONG)(0xffffffbf)

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXALIGNMENTERROR_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXALIGNMENTERROR_Mask)<<6));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXALIGNMENTERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_INTR_MASK_RX_RXALIGNMENTERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXCRCERROR_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXCRCERROR_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXCRCERROR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_MASK_RX_RXCRCERROR_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_INTR_MASK_RX_RXCRCERROR_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXCRCERROR_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXCRCERROR_Mask)<<5));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXCRCERROR_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_INTR_MASK_RX_RXCRCERROR_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Wr_Mask (ULONG)(0xffffffef)

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Mask)<<4));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_INTR_MASK_RX_RXMULTICASTFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Mask)<<3));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_INTR_MASK_RX_RXBROADCASTFRAMES_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Mask)<<2));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_G_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_INTR_MASK_RX_RXOCTETCOUNT_G_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Mask)<<1));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_INTR_MASK_RX_RXOCTETCOUNT_GB_Mask);\
} while(0)

/*#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Mask (ULONG)(0x1)

/*#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_MASK_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_MASK_RX_RES_Wr_Mask_24))|((( 0) & (MMC_INTR_MASK_RX_Mask_24))<<24);\
		v = ((v & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Wr_Mask) | ((data & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Mask)<<0));\
		MMC_INTR_MASK_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_UdfRd(pdata, data) do {\
		MMC_INTR_MASK_RX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_INTR_MASK_RX_RXFRAMECOUNT_GB_Mask);\
} while(0)


#define MMC_INTR_TX_RgOffAddr ((BASE_ADDRESS + 0x708))

#define MMC_INTR_TX_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_INTR_TX_RgOffAddr));\
} while(0)

#define MMC_INTR_TX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_INTR_TX_RgOffAddr));\
} while(0)

/*#define  MMC_INTR_TX_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MMC_INTR_TX_Mask_26 (ULONG)(0x3f)

/*#define MMC_INTR_TX_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MMC_INTR_TX_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MMC_INTR_TX_TXOSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXOSIZEGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXOSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_INTR_TX_TXOSIZEGPIS_Wr_Mask (ULONG)(0xfdffffff)

#define MMC_INTR_TX_TXOSIZEGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXOSIZEGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXOSIZEGPIS_Mask)<<25));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXOSIZEGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 25) & MMC_INTR_TX_TXOSIZEGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXVLANGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXVLANGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXVLANGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_TX_TXVLANGPIS_Wr_Mask (ULONG)(0xfeffffff)

#define MMC_INTR_TX_TXVLANGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXVLANGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXVLANGPIS_Mask)<<24));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXVLANGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 24) & MMC_INTR_TX_TXVLANGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXPAUSPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXPAUSPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXPAUSPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_TX_TXPAUSPIS_Wr_Mask (ULONG)(0xff7fffff)

#define MMC_INTR_TX_TXPAUSPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXPAUSPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXPAUSPIS_Mask)<<23));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXPAUSPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_INTR_TX_TXPAUSPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXEXDEFPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXEXDEFPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXEXDEFPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_TX_TXEXDEFPIS_Wr_Mask (ULONG)(0xffbfffff)

#define MMC_INTR_TX_TXEXDEFPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXEXDEFPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXEXDEFPIS_Mask)<<22));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXEXDEFPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_INTR_TX_TXEXDEFPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXGPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGPKTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_TX_TXGPKTIS_Wr_Mask (ULONG)(0xffdfffff)

#define MMC_INTR_TX_TXGPKTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXGPKTIS_Wr_Mask) | ((data & MMC_INTR_TX_TXGPKTIS_Mask)<<21));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXGPKTIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_INTR_TX_TXGPKTIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXGOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGOCTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_TX_TXGOCTIS_Wr_Mask (ULONG)(0xffefffff)

#define MMC_INTR_TX_TXGOCTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXGOCTIS_Wr_Mask) | ((data & MMC_INTR_TX_TXGOCTIS_Mask)<<20));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXGOCTIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_INTR_TX_TXGOCTIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXCARERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXCARERPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXCARERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_TX_TXCARERPIS_Wr_Mask (ULONG)(0xfff7ffff)

#define MMC_INTR_TX_TXCARERPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXCARERPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXCARERPIS_Mask)<<19));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXCARERPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_INTR_TX_TXCARERPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXEXCOLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXEXCOLPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXEXCOLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_TX_TXEXCOLPIS_Wr_Mask (ULONG)(0xfffbffff)

#define MMC_INTR_TX_TXEXCOLPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXEXCOLPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXEXCOLPIS_Mask)<<18));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXEXCOLPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_INTR_TX_TXEXCOLPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXLATCOLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXLATCOLPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXLATCOLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_TX_TXLATCOLPIS_Wr_Mask (ULONG)(0xfffdffff)

#define MMC_INTR_TX_TXLATCOLPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXLATCOLPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXLATCOLPIS_Mask)<<17));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXLATCOLPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_INTR_TX_TXLATCOLPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXDEFPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXDEFPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXDEFPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_TX_TXDEFPIS_Wr_Mask (ULONG)(0xfffeffff)

#define MMC_INTR_TX_TXDEFPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXDEFPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXDEFPIS_Mask)<<16));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXDEFPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_INTR_TX_TXDEFPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXMCOLGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCOLGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCOLGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_TX_TXMCOLGPIS_Wr_Mask (ULONG)(0xffff7fff)

#define MMC_INTR_TX_TXMCOLGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXMCOLGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXMCOLGPIS_Mask)<<15));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXMCOLGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 15) & MMC_INTR_TX_TXMCOLGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXSCOLGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXSCOLGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXSCOLGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_TX_TXSCOLGPIS_Wr_Mask (ULONG)(0xffffbfff)

#define MMC_INTR_TX_TXSCOLGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXSCOLGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXSCOLGPIS_Mask)<<14));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXSCOLGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 14) & MMC_INTR_TX_TXSCOLGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXUFLOWERFIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXUFLOWERFIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXUFLOWERFIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_TX_TXUFLOWERFIS_Wr_Mask (ULONG)(0xffffdfff)

#define MMC_INTR_TX_TXUFLOWERFIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXUFLOWERFIS_Wr_Mask) | ((data & MMC_INTR_TX_TXUFLOWERFIS_Mask)<<13));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXUFLOWERFIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_INTR_TX_TXUFLOWERFIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXBCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXBCGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXBCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_TX_TXBCGBPIS_Wr_Mask (ULONG)(0xffffefff)

#define MMC_INTR_TX_TXBCGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXBCGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXBCGBPIS_Mask)<<12));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXBCGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_INTR_TX_TXBCGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXMCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_TX_TXMCGBPIS_Wr_Mask (ULONG)(0xfffff7ff)

#define MMC_INTR_TX_TXMCGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXMCGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXMCGBPIS_Mask)<<11));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXMCGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_INTR_TX_TXMCGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXUCGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXUCGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXUCGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_TX_TXUCGBPIS_Wr_Mask (ULONG)(0xfffffbff)

#define MMC_INTR_TX_TXUCGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXUCGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXUCGBPIS_Mask)<<10));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXUCGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_INTR_TX_TXUCGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_Wr_Mask (ULONG)(0xfffffdff)

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX1024TMAXOCTGBFIS_Wr_Mask) | ((data & MMC_INTR_TX_TX1024TMAXOCTGBFIS_Mask)<<9));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX1024TMAXOCTGBFIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_INTR_TX_TX1024TMAXOCTGBFIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX512T1023OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX512T1023OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX512T1023OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_TX_TX512T1023OCTGBPIS_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_INTR_TX_TX512T1023OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX512T1023OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TX512T1023OCTGBPIS_Mask)<<8));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX512T1023OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_INTR_TX_TX512T1023OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX256T511OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX256T511OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX256T511OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_TX_TX256T511OCTGBPIS_Wr_Mask (ULONG)(0xffffff7f)

#define MMC_INTR_TX_TX256T511OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX256T511OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TX256T511OCTGBPIS_Mask)<<7));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX256T511OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_INTR_TX_TX256T511OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX128T255OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX128T255OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX128T255OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_TX_TX128T255OCTGBPIS_Wr_Mask (ULONG)(0xffffffbf)

#define MMC_INTR_TX_TX128T255OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX128T255OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TX128T255OCTGBPIS_Mask)<<6));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX128T255OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_INTR_TX_TX128T255OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX65T127OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX65T127OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX65T127OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_TX_TX65T127OCTGBPIS_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_INTR_TX_TX65T127OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX65T127OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TX65T127OCTGBPIS_Mask)<<5));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX65T127OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_INTR_TX_TX65T127OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TX64OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TX64OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TX64OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_TX_TX64OCTGBPIS_Wr_Mask (ULONG)(0xffffffef)

#define MMC_INTR_TX_TX64OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TX64OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_TX_TX64OCTGBPIS_Mask)<<4));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TX64OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_INTR_TX_TX64OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXMCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXMCGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXMCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_TX_TXMCGPIS_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_INTR_TX_TXMCGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXMCGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXMCGPIS_Mask)<<3));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXMCGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_INTR_TX_TXMCGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXBCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXBCGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXBCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_TX_TXBCGPIS_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_INTR_TX_TXBCGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXBCGPIS_Wr_Mask) | ((data & MMC_INTR_TX_TXBCGPIS_Mask)<<2));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXBCGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_INTR_TX_TXBCGPIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXGBPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGBPKTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGBPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_TX_TXGBPKTIS_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_INTR_TX_TXGBPKTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXGBPKTIS_Wr_Mask) | ((data & MMC_INTR_TX_TXGBPKTIS_Mask)<<1));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXGBPKTIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_INTR_TX_TXGBPKTIS_Mask);\
} while(0)

/*#define MMC_INTR_TX_TXGBOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_TX_TXGBOCTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_TX_TXGBOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_TX_TXGBOCTIS_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_INTR_TX_TXGBOCTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_TX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_TX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_TX_Mask_26))<<26);\
		v = ((v & MMC_INTR_TX_TXGBOCTIS_Wr_Mask) | ((data & MMC_INTR_TX_TXGBOCTIS_Mask)<<0));\
		MMC_INTR_TX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_TX_TXGBOCTIS_UdfRd(pdata, data) do {\
		MMC_INTR_TX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_INTR_TX_TXGBOCTIS_Mask);\
} while(0)


#define MMC_INTR_RX_RgOffAddr ((BASE_ADDRESS + 0x704))

#define MMC_INTR_RX_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_INTR_RX_RgOffAddr));\
} while(0)

#define MMC_INTR_RX_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_INTR_RX_RgOffAddr));\
} while(0)

/*#define  MMC_INTR_RX_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MMC_INTR_RX_Mask_26 (ULONG)(0x3f)

/*#define MMC_INTR_RX_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MMC_INTR_RX_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define MMC_INTR_RX_RXCTRLPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXCTRLPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXCTRLPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MMC_INTR_RX_RXCTRLPIS_Wr_Mask (ULONG)(0xfdffffff)

#define MMC_INTR_RX_RXCTRLPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXCTRLPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXCTRLPIS_Mask)<<25));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXCTRLPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 25) & MMC_INTR_RX_RXCTRLPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXRCVERRPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXRCVERRPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXRCVERRPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MMC_INTR_RX_RXRCVERRPIS_Wr_Mask (ULONG)(0xfeffffff)

#define MMC_INTR_RX_RXRCVERRPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXRCVERRPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXRCVERRPIS_Mask)<<24));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXRCVERRPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 24) & MMC_INTR_RX_RXRCVERRPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXWDOGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXWDOGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXWDOGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (23)))*/

#define MMC_INTR_RX_RXWDOGPIS_Wr_Mask (ULONG)(0xff7fffff)

#define MMC_INTR_RX_RXWDOGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXWDOGPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXWDOGPIS_Mask)<<23));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXWDOGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 23) & MMC_INTR_RX_RXWDOGPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXVLANGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXVLANGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXVLANGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (22)))*/

#define MMC_INTR_RX_RXVLANGBPIS_Wr_Mask (ULONG)(0xffbfffff)

#define MMC_INTR_RX_RXVLANGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXVLANGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXVLANGBPIS_Mask)<<22));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXVLANGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 22) & MMC_INTR_RX_RXVLANGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXFOVPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXFOVPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXFOVPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (21)))*/

#define MMC_INTR_RX_RXFOVPIS_Wr_Mask (ULONG)(0xffdfffff)

#define MMC_INTR_RX_RXFOVPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXFOVPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXFOVPIS_Mask)<<21));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXFOVPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 21) & MMC_INTR_RX_RXFOVPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXPAUSPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXPAUSPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXPAUSPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MMC_INTR_RX_RXPAUSPIS_Wr_Mask (ULONG)(0xffefffff)

#define MMC_INTR_RX_RXPAUSPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXPAUSPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXPAUSPIS_Mask)<<20));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXPAUSPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 20) & MMC_INTR_RX_RXPAUSPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXORANGEPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXORANGEPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXORANGEPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MMC_INTR_RX_RXORANGEPIS_Wr_Mask (ULONG)(0xfff7ffff)

#define MMC_INTR_RX_RXORANGEPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXORANGEPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXORANGEPIS_Mask)<<19));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXORANGEPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 19) & MMC_INTR_RX_RXORANGEPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXLENERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXLENERPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXLENERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MMC_INTR_RX_RXLENERPIS_Wr_Mask (ULONG)(0xfffbffff)

#define MMC_INTR_RX_RXLENERPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXLENERPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXLENERPIS_Mask)<<18));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXLENERPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 18) & MMC_INTR_RX_RXLENERPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXUCBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXUCBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXUCBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MMC_INTR_RX_RXUCBPIS_Wr_Mask (ULONG)(0xfffdffff)

#define MMC_INTR_RX_RXUCBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXUCBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXUCBPIS_Mask)<<17));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXUCBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 17) & MMC_INTR_RX_RXUCBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_Wr_Mask (ULONG)(0xfffeffff)

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX1024TMAXOCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX1024TMAXOCTGBPIS_Mask)<<16));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX1024TMAXOCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 16) & MMC_INTR_RX_RX1024TMAXOCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX512T1023OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX512T1023OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX512T1023OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MMC_INTR_RX_RX512T1023OCTGBPIS_Wr_Mask (ULONG)(0xffff7fff)

#define MMC_INTR_RX_RX512T1023OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX512T1023OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX512T1023OCTGBPIS_Mask)<<15));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX512T1023OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 15) & MMC_INTR_RX_RX512T1023OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX256T511OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX256T511OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX256T511OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MMC_INTR_RX_RX256T511OCTGBPIS_Wr_Mask (ULONG)(0xffffbfff)

#define MMC_INTR_RX_RX256T511OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX256T511OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX256T511OCTGBPIS_Mask)<<14));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX256T511OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 14) & MMC_INTR_RX_RX256T511OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX128T255OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX128T255OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX128T255OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define MMC_INTR_RX_RX128T255OCTGBPIS_Wr_Mask (ULONG)(0xffffdfff)

#define MMC_INTR_RX_RX128T255OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX128T255OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX128T255OCTGBPIS_Mask)<<13));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX128T255OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 13) & MMC_INTR_RX_RX128T255OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX65T127OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX65T127OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX65T127OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MMC_INTR_RX_RX65T127OCTGBPIS_Wr_Mask (ULONG)(0xffffefff)

#define MMC_INTR_RX_RX65T127OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX65T127OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX65T127OCTGBPIS_Mask)<<12));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX65T127OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 12) & MMC_INTR_RX_RX65T127OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RX64OCTGBPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RX64OCTGBPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RX64OCTGBPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MMC_INTR_RX_RX64OCTGBPIS_Wr_Mask (ULONG)(0xfffff7ff)

#define MMC_INTR_RX_RX64OCTGBPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RX64OCTGBPIS_Wr_Mask) | ((data & MMC_INTR_RX_RX64OCTGBPIS_Mask)<<11));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RX64OCTGBPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 11) & MMC_INTR_RX_RX64OCTGBPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXOSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXOSIZEGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXOSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MMC_INTR_RX_RXOSIZEGPIS_Wr_Mask (ULONG)(0xfffffbff)

#define MMC_INTR_RX_RXOSIZEGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXOSIZEGPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXOSIZEGPIS_Mask)<<10));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXOSIZEGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 10) & MMC_INTR_RX_RXOSIZEGPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXUSIZEGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXUSIZEGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXUSIZEGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MMC_INTR_RX_RXUSIZEGPIS_Wr_Mask (ULONG)(0xfffffdff)

#define MMC_INTR_RX_RXUSIZEGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXUSIZEGPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXUSIZEGPIS_Mask)<<9));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXUSIZEGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 9) & MMC_INTR_RX_RXUSIZEGPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXJABERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXJABERPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXJABERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_INTR_RX_RXJABERPIS_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_INTR_RX_RXJABERPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXJABERPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXJABERPIS_Mask)<<8));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXJABERPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_INTR_RX_RXJABERPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXRUNTRIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXRUNTRIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXRUNTRIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MMC_INTR_RX_RXRUNTRIS_Wr_Mask (ULONG)(0xffffff7f)

#define MMC_INTR_RX_RXRUNTRIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXRUNTRIS_Wr_Mask) | ((data & MMC_INTR_RX_RXRUNTRIS_Mask)<<7));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXRUNTRIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 7) & MMC_INTR_RX_RXRUNTRIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXALGNERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXALGNERPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXALGNERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MMC_INTR_RX_RXALGNERPIS_Wr_Mask (ULONG)(0xffffffbf)

#define MMC_INTR_RX_RXALGNERPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXALGNERPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXALGNERPIS_Mask)<<6));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXALGNERPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 6) & MMC_INTR_RX_RXALGNERPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXCRCERPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXCRCERPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXCRCERPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_INTR_RX_RXCRCERPIS_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_INTR_RX_RXCRCERPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXCRCERPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXCRCERPIS_Mask)<<5));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXCRCERPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_INTR_RX_RXCRCERPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXMCGPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXMCGPIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXMCGPIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_INTR_RX_RXMCGPIS_Wr_Mask (ULONG)(0xffffffef)

#define MMC_INTR_RX_RXMCGPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXMCGPIS_Wr_Mask) | ((data & MMC_INTR_RX_RXMCGPIS_Mask)<<4));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXMCGPIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_INTR_RX_RXMCGPIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXBCGTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXBCGTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXBCGTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_INTR_RX_RXBCGTIS_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_INTR_RX_RXBCGTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXBCGTIS_Wr_Mask) | ((data & MMC_INTR_RX_RXBCGTIS_Mask)<<3));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXBCGTIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_INTR_RX_RXBCGTIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXGOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGOCTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_INTR_RX_RXGOCTIS_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_INTR_RX_RXGOCTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXGOCTIS_Wr_Mask) | ((data & MMC_INTR_RX_RXGOCTIS_Mask)<<2));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXGOCTIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_INTR_RX_RXGOCTIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXGBOCTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGBOCTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGBOCTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_INTR_RX_RXGBOCTIS_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_INTR_RX_RXGBOCTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXGBOCTIS_Wr_Mask) | ((data & MMC_INTR_RX_RXGBOCTIS_Mask)<<1));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXGBOCTIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_INTR_RX_RXGBOCTIS_Mask);\
} while(0)

/*#define MMC_INTR_RX_RXGBPKTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_INTR_RX_RXGBPKTIS_Mask (ULONG)(0x1)

/*#define MMC_INTR_RX_RXGBPKTIS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_INTR_RX_RXGBPKTIS_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_INTR_RX_RXGBPKTIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_INTR_RX_RgRd(pdata, v);\
		v = (v & (MMC_INTR_RX_RES_Wr_Mask_26))|((( 0) & (MMC_INTR_RX_Mask_26))<<26);\
		v = ((v & MMC_INTR_RX_RXGBPKTIS_Wr_Mask) | ((data & MMC_INTR_RX_RXGBPKTIS_Mask)<<0));\
		MMC_INTR_RX_RgWr(pdata, v);\
} while(0)

#define MMC_INTR_RX_RXGBPKTIS_UdfRd(pdata, data) do {\
		MMC_INTR_RX_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_INTR_RX_RXGBPKTIS_Mask);\
} while(0)


#define MMC_CNTRL_RgOffAddr ((BASE_ADDRESS + 0x700))

#define MMC_CNTRL_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MMC_CNTRL_RgOffAddr));\
} while(0)

#define MMC_CNTRL_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MMC_CNTRL_RgOffAddr));\
} while(0)

/*#define  MMC_CNTRL_Mask_9 (ULONG)(~(~0<<(23)))*/

#define  MMC_CNTRL_Mask_9 (ULONG)(0x7fffff)

/*#define MMC_CNTRL_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(23)))<<(9)))*/

#define MMC_CNTRL_RES_Wr_Mask_9 (ULONG)(0x1ff)

/*#define  MMC_CNTRL_Mask_6 (ULONG)(~(~0<<(2)))*/

#define  MMC_CNTRL_Mask_6 (ULONG)(0x3)

/*#define MMC_CNTRL_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(2)))<<(6)))*/

#define MMC_CNTRL_RES_Wr_Mask_6 (ULONG)(0xffffff3f)

/*#define MMC_CNTRL_UCDBC_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_UCDBC_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_UCDBC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MMC_CNTRL_UCDBC_Wr_Mask (ULONG)(0xfffffeff)

#define MMC_CNTRL_UCDBC_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_UCDBC_Wr_Mask) | ((data & MMC_CNTRL_UCDBC_Mask)<<8));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_UCDBC_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 8) & MMC_CNTRL_UCDBC_Mask);\
} while(0)

/*#define MMC_CNTRL_CNPRSTLVL_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNPRSTLVL_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_CNPRSTLVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MMC_CNTRL_CNPRSTLVL_Wr_Mask (ULONG)(0xffffffdf)

#define MMC_CNTRL_CNPRSTLVL_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_CNPRSTLVL_Wr_Mask) | ((data & MMC_CNTRL_CNPRSTLVL_Mask)<<5));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_CNPRSTLVL_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 5) & MMC_CNTRL_CNPRSTLVL_Mask);\
} while(0)

/*#define MMC_CNTRL_CNTPRST_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTPRST_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_CNTPRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MMC_CNTRL_CNTPRST_Wr_Mask (ULONG)(0xffffffef)

#define MMC_CNTRL_CNTPRST_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_CNTPRST_Wr_Mask) | ((data & MMC_CNTRL_CNTPRST_Mask)<<4));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_CNTPRST_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 4) & MMC_CNTRL_CNTPRST_Mask);\
} while(0)

/*#define MMC_CNTRL_CNTFREEZ_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTFREEZ_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_CNTFREEZ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MMC_CNTRL_CNTFREEZ_Wr_Mask (ULONG)(0xfffffff7)

#define MMC_CNTRL_CNTFREEZ_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_CNTFREEZ_Wr_Mask) | ((data & MMC_CNTRL_CNTFREEZ_Mask)<<3));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_CNTFREEZ_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 3) & MMC_CNTRL_CNTFREEZ_Mask);\
} while(0)

/*#define MMC_CNTRL_RSTONRD_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_RSTONRD_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_RSTONRD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MMC_CNTRL_RSTONRD_Wr_Mask (ULONG)(0xfffffffb)

#define MMC_CNTRL_RSTONRD_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_RSTONRD_Wr_Mask) | ((data & MMC_CNTRL_RSTONRD_Mask)<<2));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_RSTONRD_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 2) & MMC_CNTRL_RSTONRD_Mask);\
} while(0)

/*#define MMC_CNTRL_CNTSTOPRO_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTSTOPRO_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_CNTSTOPRO_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MMC_CNTRL_CNTSTOPRO_Wr_Mask (ULONG)(0xfffffffd)

#define MMC_CNTRL_CNTSTOPRO_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_CNTSTOPRO_Wr_Mask) | ((data & MMC_CNTRL_CNTSTOPRO_Mask)<<1));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_CNTSTOPRO_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 1) & MMC_CNTRL_CNTSTOPRO_Mask);\
} while(0)

/*#define MMC_CNTRL_CNTRST_Mask (ULONG)(~(~0<<(1)))*/

#define MMC_CNTRL_CNTRST_Mask (ULONG)(0x1)

/*#define MMC_CNTRL_CNTRST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MMC_CNTRL_CNTRST_Wr_Mask (ULONG)(0xfffffffe)

#define MMC_CNTRL_CNTRST_UdfWr(pdata, data) do {\
		ULONG v;\
		MMC_CNTRL_RgRd(pdata, v);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_9))|((( 0) & (MMC_CNTRL_Mask_9))<<9);\
		v = (v & (MMC_CNTRL_RES_Wr_Mask_6))|((( 0) & (MMC_CNTRL_Mask_6))<<6);\
		v = ((v & MMC_CNTRL_CNTRST_Wr_Mask) | ((data & MMC_CNTRL_CNTRST_Mask)<<0));\
		MMC_CNTRL_RgWr(pdata, v);\
} while(0)

#define MMC_CNTRL_CNTRST_UdfRd(pdata, data) do {\
		MMC_CNTRL_RgRd(pdata, data);\
		data = ((data >> 0) & MMC_CNTRL_CNTRST_Mask);\
} while(0)


#define MAC_MA1LR_RgOffAddr ((BASE_ADDRESS + 0x30c))

#define MAC_MA1LR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_MA1LR_RgOffAddr));\
} while(0)

#define MAC_MA1LR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_MA1LR_RgOffAddr));\
} while(0)

#define MAC_MA1LR_ADDRLO_UdfWr(pdata, data) do {\
		MAC_MA1LR_RgWr(pdata, data);\
} while(0)

#define MAC_MA1LR_ADDRLO_UdfRd(pdata, data) do {\
		MAC_MA1LR_RgRd(pdata, data);\
} while(0)


#define MAC_MA1HR_RgOffAddr ((BASE_ADDRESS + 0x308))

#define MAC_MA1HR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_MA1HR_RgOffAddr));\
} while(0)

#define MAC_MA1HR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_MA1HR_RgOffAddr));\
} while(0)

/*#define  MAC_MA1HR_Mask_19 (ULONG)(~(~0<<(5)))*/

#define  MAC_MA1HR_Mask_19 (ULONG)(0x1f)

/*#define MAC_MA1HR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(5)))<<(19)))*/

#define MAC_MA1HR_RES_Wr_Mask_19 (ULONG)(0xff07ffff)

/*#define MAC_MA1HR_AE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA1HR_AE_Mask (ULONG)(0x1)

/*#define MAC_MA1HR_AE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_MA1HR_AE_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_MA1HR_AE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA1HR_RgRd(pdata, v);\
		v = (v & (MAC_MA1HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA1HR_Mask_19))<<19);\
		v = ((v & MAC_MA1HR_AE_Wr_Mask) | ((data & MAC_MA1HR_AE_Mask)<<31));\
		MAC_MA1HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA1HR_AE_UdfRd(pdata, data) do {\
		MAC_MA1HR_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_MA1HR_AE_Mask);\
} while(0)

/*#define MAC_MA1HR_SA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA1HR_SA_Mask (ULONG)(0x1)

/*#define MAC_MA1HR_SA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (30)))*/

#define MAC_MA1HR_SA_Wr_Mask (ULONG)(0xbfffffff)

#define MAC_MA1HR_SA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA1HR_RgRd(pdata, v);\
		v = (v & (MAC_MA1HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA1HR_Mask_19))<<19);\
		v = ((v & MAC_MA1HR_SA_Wr_Mask) | ((data & MAC_MA1HR_SA_Mask)<<30));\
		MAC_MA1HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA1HR_SA_UdfRd(pdata, data) do {\
		MAC_MA1HR_RgRd(pdata, data);\
		data = ((data >> 30) & MAC_MA1HR_SA_Mask);\
} while(0)

/*#define MAC_MA1HR_MBC_Mask (ULONG)(~(~0<<(6)))*/

#define MAC_MA1HR_MBC_Mask (ULONG)(0x3f)

/*#define MAC_MA1HR_MBC_Wr_Mask (ULONG)(~((~(~0 << (6))) << (24)))*/

#define MAC_MA1HR_MBC_Wr_Mask (ULONG)(0xc0ffffff)

#define MAC_MA1HR_MBC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA1HR_RgRd(pdata, v);\
		v = (v & (MAC_MA1HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA1HR_Mask_19))<<19);\
		v = ((v & MAC_MA1HR_MBC_Wr_Mask) | ((data & MAC_MA1HR_MBC_Mask)<<24));\
		MAC_MA1HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA1HR_MBC_UdfRd(pdata, data) do {\
		MAC_MA1HR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_MA1HR_MBC_Mask);\
} while(0)

/*#define MAC_MA1HR_DCS_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_MA1HR_DCS_Mask (ULONG)(0x7)

/*#define MAC_MA1HR_DCS_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_MA1HR_DCS_Wr_Mask (ULONG)(0xfff8ffff)

#define MAC_MA1HR_DCS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA1HR_RgRd(pdata, v);\
		v = (v & (MAC_MA1HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA1HR_Mask_19))<<19);\
		v = ((v & MAC_MA1HR_DCS_Wr_Mask) | ((data & MAC_MA1HR_DCS_Mask)<<16));\
		MAC_MA1HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA1HR_DCS_UdfRd(pdata, data) do {\
		MAC_MA1HR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_MA1HR_DCS_Mask);\
} while(0)

/*#define MAC_MA1HR_ADDRHI_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_MA1HR_ADDRHI_Mask (ULONG)(0xffff)

/*#define MAC_MA1HR_ADDRHI_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_MA1HR_ADDRHI_Wr_Mask (ULONG)(0xffff0000)

#define MAC_MA1HR_ADDRHI_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA1HR_RgRd(pdata, v);\
		v = (v & (MAC_MA1HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA1HR_Mask_19))<<19);\
		v = ((v & MAC_MA1HR_ADDRHI_Wr_Mask) | ((data & MAC_MA1HR_ADDRHI_Mask)<<0));\
		MAC_MA1HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA1HR_ADDRHI_UdfRd(pdata, data) do {\
		MAC_MA1HR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_MA1HR_ADDRHI_Mask);\
} while(0)


#define MAC_MA0LR_RgOffAddr ((BASE_ADDRESS + 0x304))

#define MAC_MA0LR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_MA0LR_RgOffAddr));\
} while(0)

#define MAC_MA0LR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_MA0LR_RgOffAddr));\
} while(0)

#define MAC_MA0LR_ADDRLO_UdfWr(pdata, data) do {\
		MAC_MA0LR_RgWr(pdata, data);\
} while(0)

#define MAC_MA0LR_ADDRLO_UdfRd(pdata, data) do {\
		MAC_MA0LR_RgRd(pdata, data);\
} while(0)


#define MAC_MA0HR_RgOffAddr ((BASE_ADDRESS + 0x300))

#define MAC_MA0HR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_MA0HR_RgOffAddr));\
} while(0)

#define MAC_MA0HR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_MA0HR_RgOffAddr));\
} while(0)

/*#define  MAC_MA0HR_Mask_19 (ULONG)(~(~0<<(12)))*/

#define  MAC_MA0HR_Mask_19 (ULONG)(0xfff)

/*#define MAC_MA0HR_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(12)))<<(19)))*/

#define MAC_MA0HR_RES_Wr_Mask_19 (ULONG)(0x8007ffff)

/*#define MAC_MA0HR_AE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MA0HR_AE_Mask (ULONG)(0x1)

/*#define MAC_MA0HR_AE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_MA0HR_AE_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_MA0HR_AE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA0HR_RgRd(pdata, v);\
		v = (v & (MAC_MA0HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA0HR_Mask_19))<<19);\
		v = ((v & MAC_MA0HR_AE_Wr_Mask) | ((data & MAC_MA0HR_AE_Mask)<<31));\
		MAC_MA0HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA0HR_AE_UdfRd(pdata, data) do {\
		MAC_MA0HR_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_MA0HR_AE_Mask);\
} while(0)

/*#define MAC_MA0HR_DCS_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_MA0HR_DCS_Mask (ULONG)(0x7)

/*#define MAC_MA0HR_DCS_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MAC_MA0HR_DCS_Wr_Mask (ULONG)(0xfff8ffff)

#define MAC_MA0HR_DCS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA0HR_RgRd(pdata, v);\
		v = (v & (MAC_MA0HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA0HR_Mask_19))<<19);\
		v = ((v & MAC_MA0HR_DCS_Wr_Mask) | ((data & MAC_MA0HR_DCS_Mask)<<16));\
		MAC_MA0HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA0HR_DCS_UdfRd(pdata, data) do {\
		MAC_MA0HR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_MA0HR_DCS_Mask);\
} while(0)

/*#define MAC_MA0HR_ADDRHI_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_MA0HR_ADDRHI_Mask (ULONG)(0xffff)

/*#define MAC_MA0HR_ADDRHI_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_MA0HR_ADDRHI_Wr_Mask (ULONG)(0xffff0000)

#define MAC_MA0HR_ADDRHI_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_MA0HR_RgRd(pdata, v);\
		v = (v & (MAC_MA0HR_RES_Wr_Mask_19))|((( 0) & (MAC_MA0HR_Mask_19))<<19);\
		v = ((v & MAC_MA0HR_ADDRHI_Wr_Mask) | ((data & MAC_MA0HR_ADDRHI_Mask)<<0));\
		MAC_MA0HR_RgWr(pdata, v);\
} while(0)

#define MAC_MA0HR_ADDRHI_UdfRd(pdata, data) do {\
		MAC_MA0HR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_MA0HR_ADDRHI_Mask);\
} while(0)


#define MAC_GPIOR_RgOffAddr ((BASE_ADDRESS + 0x208))

#define MAC_GPIOR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_GPIOR_RgOffAddr));\
} while(0)

#define MAC_GPIOR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_GPIOR_RgOffAddr));\
} while(0)

/*#define  MAC_GPIOR_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_Mask_28 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define MAC_GPIOR_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define  MAC_GPIOR_Mask_20 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_Mask_20 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(4)))<<(20)))*/

#define MAC_GPIOR_RES_Wr_Mask_20 (ULONG)(0xff0fffff)

/*#define  MAC_GPIOR_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_Mask_12 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MAC_GPIOR_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MAC_GPIOR_Mask_4 (ULONG)(~(~0<<(4)))*/

#define  MAC_GPIOR_Mask_4 (ULONG)(0xf)

/*#define MAC_GPIOR_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(4)))<<(4)))*/

#define MAC_GPIOR_RES_Wr_Mask_4 (ULONG)(0xffffff0f)

/*#define MAC_GPIOR_GPIT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIT_Mask (ULONG)(0xf)

/*#define MAC_GPIOR_GPIT_Wr_Mask (ULONG)(~((~(~0 << (4))) << (24)))*/

#define MAC_GPIOR_GPIT_Wr_Mask (ULONG)(0xf0ffffff)

#define MAC_GPIOR_GPIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GPIOR_RgRd(pdata, v);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_28))|((( 0) & (MAC_GPIOR_Mask_28))<<28);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_20))|((( 0) & (MAC_GPIOR_Mask_20))<<20);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_12))|((( 0) & (MAC_GPIOR_Mask_12))<<12);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_4))|((( 0) & (MAC_GPIOR_Mask_4))<<4);\
		v = ((v & MAC_GPIOR_GPIT_Wr_Mask) | ((data & MAC_GPIOR_GPIT_Mask)<<24));\
		MAC_GPIOR_RgWr(pdata, v);\
} while(0)

#define MAC_GPIOR_GPIT_UdfRd(pdata, data) do {\
		MAC_GPIOR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_GPIOR_GPIT_Mask);\
} while(0)

/*#define MAC_GPIOR_GPIE_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIE_Mask (ULONG)(0xf)

/*#define MAC_GPIOR_GPIE_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define MAC_GPIOR_GPIE_Wr_Mask (ULONG)(0xfff0ffff)

#define MAC_GPIOR_GPIE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GPIOR_RgRd(pdata, v);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_28))|((( 0) & (MAC_GPIOR_Mask_28))<<28);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_20))|((( 0) & (MAC_GPIOR_Mask_20))<<20);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_12))|((( 0) & (MAC_GPIOR_Mask_12))<<12);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_4))|((( 0) & (MAC_GPIOR_Mask_4))<<4);\
		v = ((v & MAC_GPIOR_GPIE_Wr_Mask) | ((data & MAC_GPIOR_GPIE_Mask)<<16));\
		MAC_GPIOR_RgWr(pdata, v);\
} while(0)

#define MAC_GPIOR_GPIE_UdfRd(pdata, data) do {\
		MAC_GPIOR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_GPIOR_GPIE_Mask);\
} while(0)

/*#define MAC_GPIOR_GPO_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPO_Mask (ULONG)(0xf)

/*#define MAC_GPIOR_GPO_Wr_Mask (ULONG)(~((~(~0 << (4))) << (8)))*/

#define MAC_GPIOR_GPO_Wr_Mask (ULONG)(0xfffff0ff)

#define MAC_GPIOR_GPO_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GPIOR_RgRd(pdata, v);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_28))|((( 0) & (MAC_GPIOR_Mask_28))<<28);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_20))|((( 0) & (MAC_GPIOR_Mask_20))<<20);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_12))|((( 0) & (MAC_GPIOR_Mask_12))<<12);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_4))|((( 0) & (MAC_GPIOR_Mask_4))<<4);\
		v = ((v & MAC_GPIOR_GPO_Wr_Mask) | ((data & MAC_GPIOR_GPO_Mask)<<8));\
		MAC_GPIOR_RgWr(pdata, v);\
} while(0)

#define MAC_GPIOR_GPO_UdfRd(pdata, data) do {\
		MAC_GPIOR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_GPIOR_GPO_Mask);\
} while(0)

/*#define MAC_GPIOR_GPIS_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GPIOR_GPIS_Mask (ULONG)(0xf)

/*#define MAC_GPIOR_GPIS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define MAC_GPIOR_GPIS_Wr_Mask (ULONG)(0xfffffff0)

#define MAC_GPIOR_GPIS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GPIOR_RgRd(pdata, v);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_28))|((( 0) & (MAC_GPIOR_Mask_28))<<28);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_20))|((( 0) & (MAC_GPIOR_Mask_20))<<20);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_12))|((( 0) & (MAC_GPIOR_Mask_12))<<12);\
		v = (v & (MAC_GPIOR_RES_Wr_Mask_4))|((( 0) & (MAC_GPIOR_Mask_4))<<4);\
		v = ((v & MAC_GPIOR_GPIS_Wr_Mask) | ((data & MAC_GPIOR_GPIS_Mask)<<0));\
		MAC_GPIOR_RgWr(pdata, v);\
} while(0)

#define MAC_GPIOR_GPIS_UdfRd(pdata, data) do {\
		MAC_GPIOR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_GPIOR_GPIS_Mask);\
} while(0)


#define MAC_GMIIDR_RgOffAddr ((BASE_ADDRESS + 0x204))

#define MAC_GMIIDR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_GMIIDR_RgOffAddr));\
} while(0)

#define MAC_GMIIDR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_GMIIDR_RgOffAddr));\
} while(0)

/*#define MAC_GMIIDR_RA_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GMIIDR_RA_Mask (ULONG)(0xffff)

/*#define MAC_GMIIDR_RA_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_GMIIDR_RA_Wr_Mask (ULONG)(0xffff)

#define MAC_GMIIDR_RA_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_GMIIDR_RgRd(pdata, v);\
		v = ((v & MAC_GMIIDR_RA_Wr_Mask) | ((data & MAC_GMIIDR_RA_Mask)<<16));\
		MAC_GMIIDR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIDR_RA_UdfRd(pdata, data) do {\
		MAC_GMIIDR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_GMIIDR_RA_Mask);\
} while(0)

/*#define MAC_GMIIDR_GD_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_GMIIDR_GD_Mask (ULONG)(0xffff)

/*#define MAC_GMIIDR_GD_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_GMIIDR_GD_Wr_Mask (ULONG)(0xffff0000)

#define MAC_GMIIDR_GD_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_GMIIDR_RgRd(pdata, v);\
		v = ((v & MAC_GMIIDR_GD_Wr_Mask) | ((data & MAC_GMIIDR_GD_Mask)<<0));\
		MAC_GMIIDR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIDR_GD_UdfRd(pdata, data) do {\
		MAC_GMIIDR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_GMIIDR_GD_Mask);\
} while(0)


#define MAC_GMIIAR_RgOffAddr ((BASE_ADDRESS + 0x200))

#define MAC_GMIIAR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_GMIIAR_RgOffAddr));\
} while(0)

#define MAC_GMIIAR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_GMIIAR_RgOffAddr));\
} while(0)

/*#define  MAC_GMIIAR_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MAC_GMIIAR_Mask_26 (ULONG)(0x3f)

/*#define MAC_GMIIAR_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MAC_GMIIAR_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define  MAC_GMIIAR_Mask_12 (ULONG)(~(~0<<(4)))*/

#define  MAC_GMIIAR_Mask_12 (ULONG)(0xf)

/*#define MAC_GMIIAR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(4)))<<(12)))*/

#define MAC_GMIIAR_RES_Wr_Mask_12 (ULONG)(0xffff0fff)

/*#define  MAC_GMIIAR_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MAC_GMIIAR_Mask_5 (ULONG)(0x7)

/*#define MAC_GMIIAR_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MAC_GMIIAR_RES_Wr_Mask_5 (ULONG)(0xffffff1f)

/*#define MAC_GMIIAR_PA_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_GMIIAR_PA_Mask (ULONG)(0x1f)

/*#define MAC_GMIIAR_PA_Wr_Mask (ULONG)(~((~(~0 << (5))) << (21)))*/

#define MAC_GMIIAR_PA_Wr_Mask (ULONG)(0xfc1fffff)

#define MAC_GMIIAR_PA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_PA_Wr_Mask) | ((data & MAC_GMIIAR_PA_Mask)<<21));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_PA_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_GMIIAR_PA_Mask);\
} while(0)

/*#define MAC_GMIIAR_GR_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_GMIIAR_GR_Mask (ULONG)(0x1f)

/*#define MAC_GMIIAR_GR_Wr_Mask (ULONG)(~((~(~0 << (5))) << (16)))*/

#define MAC_GMIIAR_GR_Wr_Mask (ULONG)(0xffe0ffff)

#define MAC_GMIIAR_GR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_GR_Wr_Mask) | ((data & MAC_GMIIAR_GR_Mask)<<16));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_GR_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_GMIIAR_GR_Mask);\
} while(0)

/*#define MAC_GMIIAR_CR_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_GMIIAR_CR_Mask (ULONG)(0xf)

/*#define MAC_GMIIAR_CR_Wr_Mask (ULONG)(~((~(~0 << (4))) << (8)))*/

#define MAC_GMIIAR_CR_Wr_Mask (ULONG)(0xfffff0ff)

#define MAC_GMIIAR_CR_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_CR_Wr_Mask) | ((data & MAC_GMIIAR_CR_Mask)<<8));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_CR_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_GMIIAR_CR_Mask);\
} while(0)

/*#define MAC_GMIIAR_SKAP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_SKAP_Mask (ULONG)(0x1)

/*#define MAC_GMIIAR_SKAP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_GMIIAR_SKAP_Wr_Mask (ULONG)(0xffffffef)

#define MAC_GMIIAR_SKAP_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_SKAP_Wr_Mask) | ((data & MAC_GMIIAR_SKAP_Mask)<<4));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_SKAP_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_GMIIAR_SKAP_Mask);\
} while(0)

/*#define MAC_GMIIAR_GOC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_GMIIAR_GOC_Mask (ULONG)(0x3)

/*#define MAC_GMIIAR_GOC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MAC_GMIIAR_GOC_Wr_Mask (ULONG)(0xfffffff3)

#define MAC_GMIIAR_GOC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_GOC_Wr_Mask) | ((data & MAC_GMIIAR_GOC_Mask)<<2));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_GOC_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_GMIIAR_GOC_Mask);\
} while(0)

/*#define MAC_GMIIAR_C45E_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_C45E_Mask (ULONG)(0x1)

/*#define MAC_GMIIAR_C45E_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_GMIIAR_C45E_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_GMIIAR_C45E_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_C45E_Wr_Mask) | ((data & MAC_GMIIAR_C45E_Mask)<<1));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_C45E_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_GMIIAR_C45E_Mask);\
} while(0)

/*#define MAC_GMIIAR_GB_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_GMIIAR_GB_Mask (ULONG)(0x1)

/*#define MAC_GMIIAR_GB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_GMIIAR_GB_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_GMIIAR_GB_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_GMIIAR_RgRd(pdata, v);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_26))|((( 0) & (MAC_GMIIAR_Mask_26))<<26);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_12))|((( 0) & (MAC_GMIIAR_Mask_12))<<12);\
		v = (v & (MAC_GMIIAR_RES_Wr_Mask_5))|((( 0) & (MAC_GMIIAR_Mask_5))<<5);\
		v = ((v & MAC_GMIIAR_GB_Wr_Mask) | ((data & MAC_GMIIAR_GB_Mask)<<0));\
		MAC_GMIIAR_RgWr(pdata, v);\
} while(0)

#define MAC_GMIIAR_GB_UdfRd(pdata, data) do {\
		MAC_GMIIAR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_GMIIAR_GB_Mask);\
} while(0)


#define MAC_HFR2_RgOffAddr ((BASE_ADDRESS + 0x124))

#define MAC_HFR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HFR2_RgOffAddr));\
} while(0)

#define MAC_HFR2_BaseRgRd(base, data) do {\
		(data) = ioread32((void *)((base) + MAC_HFR2_RgOffAddr));\
} while(0)


/*#define MAC_HFR2_AUXSNAPNUM_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR2_AUXSNAPNUM_Mask (ULONG)(0x7)

#define MAC_HFR2_AUXSNAPNUM_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 28) & MAC_HFR2_AUXSNAPNUM_Mask);\
} while(0)

/*#define MAC_HFR2_PPSOUTNUM_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR2_PPSOUTNUM_Mask (ULONG)(0x7)

#define MAC_HFR2_PPSOUTNUM_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_HFR2_PPSOUTNUM_Mask);\
} while(0)

/*#define MAC_HFR2_TXCHCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_TXCHCNT_Mask (ULONG)(0xf)

#define MAC_HFR2_TXCHCNT_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_HFR2_TXCHCNT_Mask);\
} while(0)

/*#define MAC_HFR2_RXCHCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_RXCHCNT_Mask (ULONG)(0xf)

#define MAC_HFR2_RXCHCNT_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_HFR2_RXCHCNT_Mask);\
} while(0)

/*#define MAC_HFR2_TXQCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_TXQCNT_Mask (ULONG)(0xf)

#define MAC_HFR2_TXQCNT_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_HFR2_TXQCNT_Mask);\
} while(0)

/*#define MAC_HFR2_RXQCNT_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR2_RXQCNT_Mask (ULONG)(0xf)

#define MAC_HFR2_RXQCNT_UdfRd(pdata, data) do {\
		MAC_HFR2_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_HFR2_RXQCNT_Mask);\
} while(0)


#define MAC_HFR1_RgOffAddr ((BASE_ADDRESS + 0x120))

#define MAC_HFR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HFR1_RgOffAddr));\
} while(0)

/*#define MAC_HFR1_L3L4FILTERNUM_Mask (ULONG)(~(~0<<(4)))*/

#define MAC_HFR1_L3L4FILTERNUM_Mask (ULONG)(0xf)

#define MAC_HFR1_L3L4FILTERNUM_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 27) & MAC_HFR1_L3L4FILTERNUM_Mask);\
} while(0)

/*#define MAC_HFR1_HASHTBLSZ_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_HFR1_HASHTBLSZ_Mask (ULONG)(0x3)

#define MAC_HFR1_HASHTBLSZ_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_HFR1_HASHTBLSZ_Mask);\
} while(0)

/*#define MAC_HFR1_LPMODEEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_LPMODEEN_Mask (ULONG)(0x1)

#define MAC_HFR1_LPMODEEN_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 23) & MAC_HFR1_LPMODEEN_Mask);\
} while(0)

/*#define MAC_HFR1_AVSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_AVSEL_Mask (ULONG)(0x1)

#define MAC_HFR1_AVSEL_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_HFR1_AVSEL_Mask);\
} while(0)

/*#define MAC_HFR1_DMADEBUGEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_DMADEBUGEN_Mask (ULONG)(0x1)

#define MAC_HFR1_DMADEBUGEN_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_HFR1_DMADEBUGEN_Mask);\
} while(0)

/*#define MAC_HFR1_TSOEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_TSOEN_Mask (ULONG)(0x1)

#define MAC_HFR1_TSOEN_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_HFR1_TSOEN_Mask);\
} while(0)

/*#define MAC_HFR1_SPHEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_SPHEN_Mask (ULONG)(0x1)

#define MAC_HFR1_SPHEN_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_HFR1_SPHEN_Mask);\
} while(0)

/*#define MAC_HFR1_DCBEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_DCBEN_Mask (ULONG)(0x1)

#define MAC_HFR1_DCBEN_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_HFR1_DCBEN_Mask);\
} while(0)

/*#define MAC_HFR1_ADVTHWORD_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR1_ADVTHWORD_Mask (ULONG)(0x1)

#define MAC_HFR1_ADVTHWORD_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 13) & MAC_HFR1_ADVTHWORD_Mask);\
} while(0)

/*#define MAC_HFR1_TXFIFOSIZE_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR1_TXFIFOSIZE_Mask (ULONG)(0x1f)

#define MAC_HFR1_TXFIFOSIZE_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_HFR1_TXFIFOSIZE_Mask);\
} while(0)

/*#define MAC_HFR1_RXFIFOSIZE_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR1_RXFIFOSIZE_Mask (ULONG)(0x1f)

#define MAC_HFR1_RXFIFOSIZE_UdfRd(pdata, data) do {\
		MAC_HFR1_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_HFR1_RXFIFOSIZE_Mask);\
} while(0)


#define MAC_HFR0_RgOffAddr ((BASE_ADDRESS + 0x11c))

#define MAC_HFR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HFR0_RgOffAddr));\
} while(0)

/*#define MAC_HFR0_ACTPHYSEL_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_HFR0_ACTPHYSEL_Mask (ULONG)(0x7)

#define MAC_HFR0_ACTPHYSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 28) & MAC_HFR0_ACTPHYSEL_Mask);\
} while(0)

/*#define MAC_HFR0_SAVLANINS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_SAVLANINS_Mask (ULONG)(0x1)

#define MAC_HFR0_SAVLANINS_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 27) & MAC_HFR0_SAVLANINS_Mask);\
} while(0)

/*#define MAC_HFR0_TSINTSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_HFR0_TSINTSEL_Mask (ULONG)(0x3)

#define MAC_HFR0_TSINTSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 25) & MAC_HFR0_TSINTSEL_Mask);\
} while(0)

/*#define MAC_HFR0_MACADR64SEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MACADR64SEL_Mask (ULONG)(0x1)

#define MAC_HFR0_MACADR64SEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_HFR0_MACADR64SEL_Mask);\
} while(0)

/*#define MAC_HFR0_MACADR32SEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MACADR32SEL_Mask (ULONG)(0x1)

#define MAC_HFR0_MACADR32SEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 23) & MAC_HFR0_MACADR32SEL_Mask);\
} while(0)

/*#define MAC_HFR0_ADDMACADRSEL_Mask (ULONG)(~(~0<<(5)))*/

#define MAC_HFR0_ADDMACADRSEL_Mask (ULONG)(0x1f)

#define MAC_HFR0_ADDMACADRSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_HFR0_ADDMACADRSEL_Mask);\
} while(0)

/*#define MAC_HFR0_RXCOE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_RXCOE_Mask (ULONG)(0x1)

#define MAC_HFR0_RXCOE_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_HFR0_RXCOE_Mask);\
} while(0)

/*#define MAC_HFR0_TXCOESEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_TXCOESEL_Mask (ULONG)(0x1)

#define MAC_HFR0_TXCOESEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_HFR0_TXCOESEL_Mask);\
} while(0)

/*#define MAC_HFR0_EEESEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_EEESEL_Mask (ULONG)(0x1)

#define MAC_HFR0_EEESEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 13) & MAC_HFR0_EEESEL_Mask);\
} while(0)

/*#define MAC_HFR0_TSSSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_TSSSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_TSSSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_HFR0_TSSSEL_Mask);\
} while(0)

/*#define MAC_HFR0_ARPOFFLDEN_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_ARPOFFLDEN_Mask (ULONG)(0x1)

#define MAC_HFR0_ARPOFFLDEN_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_HFR0_ARPOFFLDEN_Mask);\
} while(0)

/*#define MAC_HFR0_MMCSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MMCSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_MMCSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_HFR0_MMCSEL_Mask);\
} while(0)

/*#define MAC_HFR0_MGKSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MGKSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_MGKSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_HFR0_MGKSEL_Mask);\
} while(0)

/*#define MAC_HFR0_RWKSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_RWKSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_RWKSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_HFR0_RWKSEL_Mask);\
} while(0)

/*#define MAC_HFR0_SMASEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_SMASEL_Mask (ULONG)(0x1)

#define MAC_HFR0_SMASEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_HFR0_SMASEL_Mask);\
} while(0)

/*#define MAC_HFR0_VLANHASEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_VLANHASEL_Mask (ULONG)(0x1)

#define MAC_HFR0_VLANHASEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_HFR0_VLANHASEL_Mask);\
} while(0)

/*#define MAC_HFR0_PCSSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_PCSSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_PCSSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_HFR0_PCSSEL_Mask);\
} while(0)

/*#define MAC_HFR0_HDSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_HDSEL_Mask (ULONG)(0x1)

#define MAC_HFR0_HDSEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_HFR0_HDSEL_Mask);\
} while(0)

/*#define MAC_HFR0_GMIISEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_GMIISEL_Mask (ULONG)(0x1)

#define MAC_HFR0_GMIISEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_HFR0_GMIISEL_Mask);\
} while(0)

/*#define MAC_HFR0_MIISEL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_HFR0_MIISEL_Mask (ULONG)(0x1)

#define MAC_HFR0_MIISEL_UdfRd(pdata, data) do {\
		MAC_HFR0_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_HFR0_MIISEL_Mask);\
} while(0)


#define MAC_MDR_RgOffAddr ((BASE_ADDRESS + 0x114))

#define MAC_MDR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_MDR_RgOffAddr));\
} while(0)

/*#define MAC_MDR_TFCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_MDR_TFCSTS_Mask (ULONG)(0x3)

#define MAC_MDR_TFCSTS_UdfRd(pdata, data) do {\
		MAC_MDR_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_MDR_TFCSTS_Mask);\
} while(0)

/*#define MAC_MDR_TPESTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MDR_TPESTS_Mask (ULONG)(0x1)

#define MAC_MDR_TPESTS_UdfRd(pdata, data) do {\
		MAC_MDR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_MDR_TPESTS_Mask);\
} while(0)

/*#define MAC_MDR_RFCFCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_MDR_RFCFCSTS_Mask (ULONG)(0x3)

#define MAC_MDR_RFCFCSTS_UdfRd(pdata, data) do {\
		MAC_MDR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_MDR_RFCFCSTS_Mask);\
} while(0)

/*#define MAC_MDR_RPESTS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_MDR_RPESTS_Mask (ULONG)(0x1)

#define MAC_MDR_RPESTS_UdfRd(pdata, data) do {\
		MAC_MDR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_MDR_RPESTS_Mask);\
} while(0)


#define MAC_VR_RgOffAddr ((BASE_ADDRESS + 0x110))

#define MAC_VR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_VR_RgOffAddr));\
} while(0)

/*#define MAC_VR_USERVER_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_VR_USERVER_Mask (ULONG)(0xff)

#define MAC_VR_USERVER_UdfRd(pdata, data) do {\
		MAC_VR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_VR_USERVER_Mask);\
} while(0)

/*#define MAC_VR_SNPSVER_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_VR_SNPSVER_Mask (ULONG)(0xff)

#define MAC_VR_SNPSVER_UdfRd(pdata, data) do {\
		MAC_VR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_VR_SNPSVER_Mask);\
} while(0)


#define MAC_HTR7_RgOffAddr ((BASE_ADDRESS + 0x2c))

#define MAC_HTR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR7_RgOffAddr));\
} while(0)

#define MAC_HTR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR7_RgOffAddr));\
} while(0)

#define MAC_HTR7_HT_UdfWr(pdata, data) do {\
		MAC_HTR7_RgWr(pdata, data);\
} while(0)

#define MAC_HTR7_HT_UdfRd(pdata, data) do {\
		MAC_HTR7_RgRd(pdata, data);\
} while(0)


#define MAC_HTR6_RgOffAddr ((BASE_ADDRESS + 0x28))

#define MAC_HTR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR6_RgOffAddr));\
} while(0)

#define MAC_HTR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR6_RgOffAddr));\
} while(0)

#define MAC_HTR6_HT_UdfWr(pdata, data) do {\
		MAC_HTR6_RgWr(pdata, data);\
} while(0)

#define MAC_HTR6_HT_UdfRd(pdata, data) do {\
		MAC_HTR6_RgRd(pdata, data);\
} while(0)


#define MAC_HTR5_RgOffAddr ((BASE_ADDRESS + 0x24))

#define MAC_HTR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR5_RgOffAddr));\
} while(0)

#define MAC_HTR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR5_RgOffAddr));\
} while(0)

#define MAC_HTR5_HT_UdfWr(pdata, data) do {\
		MAC_HTR5_RgWr(pdata, data);\
} while(0)

#define MAC_HTR5_HT_UdfRd(pdata, data) do {\
		MAC_HTR5_RgRd(pdata, data);\
} while(0)


#define MAC_HTR4_RgOffAddr ((BASE_ADDRESS + 0x20))

#define MAC_HTR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR4_RgOffAddr));\
} while(0)

#define MAC_HTR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR4_RgOffAddr));\
} while(0)

#define MAC_HTR4_HT_UdfWr(pdata, data) do {\
		MAC_HTR4_RgWr(pdata, data);\
} while(0)

#define MAC_HTR4_HT_UdfRd(pdata, data) do {\
		MAC_HTR4_RgRd(pdata, data);\
} while(0)


#define MAC_HTR3_RgOffAddr ((BASE_ADDRESS + 0x1c))

#define MAC_HTR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR3_RgOffAddr));\
} while(0)

#define MAC_HTR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR3_RgOffAddr));\
} while(0)

#define MAC_HTR3_HT_UdfWr(pdata, data) do {\
		MAC_HTR3_RgWr(pdata, data);\
} while(0)

#define MAC_HTR3_HT_UdfRd(pdata, data) do {\
		MAC_HTR3_RgRd(pdata, data);\
} while(0)


#define MAC_HTR2_RgOffAddr ((BASE_ADDRESS + 0x18))

#define MAC_HTR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR2_RgOffAddr));\
} while(0)

#define MAC_HTR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR2_RgOffAddr));\
} while(0)

#define MAC_HTR2_HT_UdfWr(pdata, data) do {\
		MAC_HTR2_RgWr(pdata, data);\
} while(0)

#define MAC_HTR2_HT_UdfRd(pdata, data) do {\
		MAC_HTR2_RgRd(pdata, data);\
} while(0)


#define MAC_HTR1_RgOffAddr ((BASE_ADDRESS + 0x14))

#define MAC_HTR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR1_RgOffAddr));\
} while(0)

#define MAC_HTR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR1_RgOffAddr));\
} while(0)

#define MAC_HTR1_HT_UdfWr(pdata, data) do {\
		MAC_HTR1_RgWr(pdata, data);\
} while(0)

#define MAC_HTR1_HT_UdfRd(pdata, data) do {\
		MAC_HTR1_RgRd(pdata, data);\
} while(0)


#define MAC_HTR0_RgOffAddr ((BASE_ADDRESS + 0x10))

#define MAC_HTR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_HTR0_RgOffAddr));\
} while(0)

#define MAC_HTR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_HTR0_RgOffAddr));\
} while(0)

#define MAC_HTR0_HT_UdfWr(pdata, data) do {\
		MAC_HTR0_RgWr(pdata, data);\
} while(0)

#define MAC_HTR0_HT_UdfRd(pdata, data) do {\
		MAC_HTR0_RgRd(pdata, data);\
} while(0)


#define DMA_RIWTR7_RgOffAddr ((BASE_ADDRESS + 0x14b8))

#define DMA_RIWTR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR7_RgOffAddr));\
} while(0)

#define DMA_RIWTR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR7_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR7_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR7_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR7_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR7_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR7_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR7_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR7_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR7_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR7_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR7_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR7_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR7_RWT_Wr_Mask) | ((data & DMA_RIWTR7_RWT_Mask)<<0));\
		DMA_RIWTR7_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR7_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR7_RWT_Mask);\
} while(0)


#define DMA_RIWTR6_RgOffAddr ((BASE_ADDRESS + 0x1438))

#define DMA_RIWTR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR6_RgOffAddr));\
} while(0)

#define DMA_RIWTR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR6_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR6_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR6_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR6_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR6_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR6_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR6_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR6_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR6_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR6_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR6_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR6_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR6_RWT_Wr_Mask) | ((data & DMA_RIWTR6_RWT_Mask)<<0));\
		DMA_RIWTR6_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR6_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR6_RWT_Mask);\
} while(0)


#define DMA_RIWTR5_RgOffAddr ((BASE_ADDRESS + 0x13b8))

#define DMA_RIWTR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR5_RgOffAddr));\
} while(0)

#define DMA_RIWTR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR5_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR5_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR5_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR5_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR5_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR5_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR5_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR5_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR5_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR5_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR5_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR5_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR5_RWT_Wr_Mask) | ((data & DMA_RIWTR5_RWT_Mask)<<0));\
		DMA_RIWTR5_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR5_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR5_RWT_Mask);\
} while(0)


#define DMA_RIWTR4_RgOffAddr ((BASE_ADDRESS + 0x1338))

#define DMA_RIWTR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR4_RgOffAddr));\
} while(0)

#define DMA_RIWTR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR4_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR4_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR4_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR4_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR4_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR4_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR4_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR4_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR4_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR4_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR4_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR4_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR4_RWT_Wr_Mask) | ((data & DMA_RIWTR4_RWT_Mask)<<0));\
		DMA_RIWTR4_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR4_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR4_RWT_Mask);\
} while(0)


#define DMA_RIWTR3_RgOffAddr ((BASE_ADDRESS + 0x12b8))

#define DMA_RIWTR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR3_RgOffAddr));\
} while(0)

#define DMA_RIWTR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR3_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR3_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR3_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR3_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR3_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR3_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR3_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR3_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR3_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR3_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR3_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR3_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR3_RWT_Wr_Mask) | ((data & DMA_RIWTR3_RWT_Mask)<<0));\
		DMA_RIWTR3_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR3_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR3_RWT_Mask);\
} while(0)


#define DMA_RIWTR2_RgOffAddr ((BASE_ADDRESS + 0x1238))

#define DMA_RIWTR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR2_RgOffAddr));\
} while(0)

#define DMA_RIWTR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR2_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR2_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR2_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR2_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR2_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR2_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR2_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR2_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR2_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR2_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR2_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR2_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR2_RWT_Wr_Mask) | ((data & DMA_RIWTR2_RWT_Mask)<<0));\
		DMA_RIWTR2_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR2_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR2_RWT_Mask);\
} while(0)


#define DMA_RIWTR1_RgOffAddr ((BASE_ADDRESS + 0x11b8))

#define DMA_RIWTR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR1_RgOffAddr));\
} while(0)

#define DMA_RIWTR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR1_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR1_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR1_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR1_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR1_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR1_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR1_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR1_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR1_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR1_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR1_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR1_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR1_RWT_Wr_Mask) | ((data & DMA_RIWTR1_RWT_Mask)<<0));\
		DMA_RIWTR1_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR1_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR1_RWT_Mask);\
} while(0)


#define DMA_RIWTR0_RgOffAddr ((BASE_ADDRESS + 0x1138))

#define DMA_RIWTR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RIWTR0_RgOffAddr));\
} while(0)

#define DMA_RIWTR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RIWTR0_RgOffAddr));\
} while(0)

/*#define  DMA_RIWTR0_Mask_8 (ULONG)(~(~0<<(24)))*/

#define  DMA_RIWTR0_Mask_8 (ULONG)(0xffffff)

/*#define DMA_RIWTR0_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(24)))<<(8)))*/

#define DMA_RIWTR0_RES_Wr_Mask_8 (ULONG)(0xff)

/*#define DMA_RIWTR0_RWT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_RIWTR0_RWT_Mask (ULONG)(0xff)

/*#define DMA_RIWTR0_RWT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define DMA_RIWTR0_RWT_Wr_Mask (ULONG)(0xffffff00)

#define DMA_RIWTR0_RWT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RIWTR0_RES_Wr_Mask_8))|((( 0) & (DMA_RIWTR0_Mask_8))<<8);\
		(v) = ((v & DMA_RIWTR0_RWT_Wr_Mask) | ((data & DMA_RIWTR0_RWT_Mask)<<0));\
		DMA_RIWTR0_RgWr(pdata, v);\
} while(0)

#define DMA_RIWTR0_RWT_UdfRd(pdata, data) do {\
		DMA_RIWTR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RIWTR0_RWT_Mask);\
} while(0)


#define DMA_RDRLR7_RgOffAddr ((BASE_ADDRESS + 0x14b0))

#define DMA_RDRLR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR7_RgOffAddr));\
} while(0)

#define DMA_RDRLR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR7_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR7_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR7_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR7_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR7_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR7_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR7_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR7_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR7_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR7_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR7_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR7_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR7_RDRL_Wr_Mask) | ((data & DMA_RDRLR7_RDRL_Mask)<<0));\
		DMA_RDRLR7_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR7_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR7_RDRL_Mask);\
} while(0)


#define DMA_RDRLR6_RgOffAddr ((BASE_ADDRESS + 0x1430))

#define DMA_RDRLR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR6_RgOffAddr));\
} while(0)

#define DMA_RDRLR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR6_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR6_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR6_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR6_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR6_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR6_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR6_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR6_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR6_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR6_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR6_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR6_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR6_RDRL_Wr_Mask) | ((data & DMA_RDRLR6_RDRL_Mask)<<0));\
		DMA_RDRLR6_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR6_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR6_RDRL_Mask);\
} while(0)


#define DMA_RDRLR5_RgOffAddr ((BASE_ADDRESS + 0x13b0))

#define DMA_RDRLR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR5_RgOffAddr));\
} while(0)

#define DMA_RDRLR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR5_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR5_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR5_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR5_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR5_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR5_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR5_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR5_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR5_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR5_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR5_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR5_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR5_RDRL_Wr_Mask) | ((data & DMA_RDRLR5_RDRL_Mask)<<0));\
		DMA_RDRLR5_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR5_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR5_RDRL_Mask);\
} while(0)


#define DMA_RDRLR4_RgOffAddr ((BASE_ADDRESS + 0x1330))

#define DMA_RDRLR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR4_RgOffAddr));\
} while(0)

#define DMA_RDRLR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR4_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR4_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR4_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR4_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR4_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR4_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR4_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR4_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR4_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR4_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR4_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR4_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR4_RDRL_Wr_Mask) | ((data & DMA_RDRLR4_RDRL_Mask)<<0));\
		DMA_RDRLR4_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR4_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR4_RDRL_Mask);\
} while(0)


#define DMA_RDRLR3_RgOffAddr ((BASE_ADDRESS + 0x12b0))

#define DMA_RDRLR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR3_RgOffAddr));\
} while(0)

#define DMA_RDRLR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR3_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR3_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR3_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR3_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR3_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR3_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR3_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR3_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR3_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR3_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR3_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR3_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR3_RDRL_Wr_Mask) | ((data & DMA_RDRLR3_RDRL_Mask)<<0));\
		DMA_RDRLR3_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR3_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR3_RDRL_Mask);\
} while(0)


#define DMA_RDRLR2_RgOffAddr ((BASE_ADDRESS + 0x1230))

#define DMA_RDRLR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR2_RgOffAddr));\
} while(0)

#define DMA_RDRLR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR2_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR2_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR2_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR2_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR2_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR2_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR2_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR2_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR2_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR2_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR2_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR2_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR2_RDRL_Wr_Mask) | ((data & DMA_RDRLR2_RDRL_Mask)<<0));\
		DMA_RDRLR2_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR2_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR2_RDRL_Mask);\
} while(0)


#define DMA_RDRLR1_RgOffAddr ((BASE_ADDRESS + 0x11b0))

#define DMA_RDRLR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR1_RgOffAddr));\
} while(0)

#define DMA_RDRLR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR1_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR1_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR1_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR1_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR1_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR1_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR1_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR1_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR1_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR1_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR1_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR1_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR1_RDRL_Wr_Mask) | ((data & DMA_RDRLR1_RDRL_Mask)<<0));\
		DMA_RDRLR1_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR1_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR1_RDRL_Mask);\
} while(0)


#define DMA_RDRLR0_RgOffAddr ((BASE_ADDRESS + 0x1130))

#define DMA_RDRLR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDRLR0_RgOffAddr));\
} while(0)

#define DMA_RDRLR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDRLR0_RgOffAddr));\
} while(0)

/*#define  DMA_RDRLR0_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_RDRLR0_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_RDRLR0_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_RDRLR0_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_RDRLR0_RDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_RDRLR0_RDRL_Mask (ULONG)(0x3ff)

/*#define DMA_RDRLR0_RDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_RDRLR0_RDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_RDRLR0_RDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_RDRLR0_RES_Wr_Mask_10))|((( 0) & (DMA_RDRLR0_Mask_10))<<10);\
		(v) = ((v & DMA_RDRLR0_RDRL_Wr_Mask) | ((data & DMA_RDRLR0_RDRL_Mask)<<0));\
		DMA_RDRLR0_RgWr(pdata, v);\
} while(0)

#define DMA_RDRLR0_RDRL_UdfRd(pdata, data) do {\
		DMA_RDRLR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RDRLR0_RDRL_Mask);\
} while(0)


#define DMA_TDRLR7_RgOffAddr ((BASE_ADDRESS + 0x14ac))

#define DMA_TDRLR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR7_RgOffAddr));\
} while(0)

#define DMA_TDRLR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR7_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR7_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR7_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR7_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR7_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR7_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR7_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR7_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR7_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR7_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR7_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR7_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR7_TDRL_Wr_Mask) | ((data & DMA_TDRLR7_TDRL_Mask)<<0));\
		DMA_TDRLR7_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR7_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR7_TDRL_Mask);\
} while(0)


#define DMA_TDRLR6_RgOffAddr ((BASE_ADDRESS + 0x142c))

#define DMA_TDRLR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR6_RgOffAddr));\
} while(0)

#define DMA_TDRLR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR6_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR6_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR6_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR6_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR6_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR6_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR6_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR6_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR6_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR6_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR6_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR6_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR6_TDRL_Wr_Mask) | ((data & DMA_TDRLR6_TDRL_Mask)<<0));\
		DMA_TDRLR6_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR6_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR6_TDRL_Mask);\
} while(0)


#define DMA_TDRLR5_RgOffAddr ((BASE_ADDRESS + 0x13ac))

#define DMA_TDRLR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR5_RgOffAddr));\
} while(0)

#define DMA_TDRLR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR5_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR5_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR5_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR5_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR5_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR5_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR5_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR5_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR5_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR5_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR5_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR5_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR5_TDRL_Wr_Mask) | ((data & DMA_TDRLR5_TDRL_Mask)<<0));\
		DMA_TDRLR5_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR5_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR5_TDRL_Mask);\
} while(0)


#define DMA_TDRLR4_RgOffAddr ((BASE_ADDRESS + 0x132c))

#define DMA_TDRLR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR4_RgOffAddr));\
} while(0)

#define DMA_TDRLR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR4_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR4_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR4_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR4_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR4_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR4_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR4_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR4_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR4_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR4_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR4_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR4_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR4_TDRL_Wr_Mask) | ((data & DMA_TDRLR4_TDRL_Mask)<<0));\
		DMA_TDRLR4_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR4_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR4_TDRL_Mask);\
} while(0)


#define DMA_TDRLR3_RgOffAddr ((BASE_ADDRESS + 0x12ac))

#define DMA_TDRLR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR3_RgOffAddr));\
} while(0)

#define DMA_TDRLR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR3_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR3_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR3_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR3_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR3_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR3_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR3_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR3_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR3_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR3_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR3_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR3_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR3_TDRL_Wr_Mask) | ((data & DMA_TDRLR3_TDRL_Mask)<<0));\
		DMA_TDRLR3_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR3_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR3_TDRL_Mask);\
} while(0)


#define DMA_TDRLR2_RgOffAddr ((BASE_ADDRESS + 0x122c))

#define DMA_TDRLR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR2_RgOffAddr));\
} while(0)

#define DMA_TDRLR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR2_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR2_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR2_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR2_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR2_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR2_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR2_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR2_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR2_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR2_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR2_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR2_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR2_TDRL_Wr_Mask) | ((data & DMA_TDRLR2_TDRL_Mask)<<0));\
		DMA_TDRLR2_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR2_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR2_TDRL_Mask);\
} while(0)


#define DMA_TDRLR1_RgOffAddr ((BASE_ADDRESS + 0x11ac))

#define DMA_TDRLR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR1_RgOffAddr));\
} while(0)

#define DMA_TDRLR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR1_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR1_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR1_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR1_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR1_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR1_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR1_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR1_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR1_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR1_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR1_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR1_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR1_TDRL_Wr_Mask) | ((data & DMA_TDRLR1_TDRL_Mask)<<0));\
		DMA_TDRLR1_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR1_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR1_TDRL_Mask);\
} while(0)


#define DMA_TDRLR0_RgOffAddr ((BASE_ADDRESS + 0x112c))

#define DMA_TDRLR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDRLR0_RgOffAddr));\
} while(0)

#define DMA_TDRLR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDRLR0_RgOffAddr));\
} while(0)

/*#define  DMA_TDRLR0_Mask_10 (ULONG)(~(~0<<(22)))*/

#define  DMA_TDRLR0_Mask_10 (ULONG)(0x3fffff)

/*#define DMA_TDRLR0_RES_Wr_Mask_10 (ULONG)(~((~(~0<<(22)))<<(10)))*/

#define DMA_TDRLR0_RES_Wr_Mask_10 (ULONG)(0x3ff)

/*#define DMA_TDRLR0_TDRL_Mask (ULONG)(~(~0<<(10)))*/

#define DMA_TDRLR0_TDRL_Mask (ULONG)(0x3ff)

/*#define DMA_TDRLR0_TDRL_Wr_Mask (ULONG)(~((~(~0 << (10))) << (0)))*/

#define DMA_TDRLR0_TDRL_Wr_Mask (ULONG)(0xfffffc00)

#define DMA_TDRLR0_TDRL_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (DMA_TDRLR0_RES_Wr_Mask_10))|((( 0) & (DMA_TDRLR0_Mask_10))<<10);\
		(v) = ((v & DMA_TDRLR0_TDRL_Wr_Mask) | ((data & DMA_TDRLR0_TDRL_Mask)<<0));\
		DMA_TDRLR0_RgWr(pdata, v);\
} while(0)

#define DMA_TDRLR0_TDRL_UdfRd(pdata, data) do {\
		DMA_TDRLR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TDRLR0_TDRL_Mask);\
} while(0)


#define DMA_RDTP_RPDR7_RgOffAddr ((BASE_ADDRESS + 0x14a8))

#define DMA_RDTP_RPDR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR7_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR7_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR7_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR7_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR7_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR7_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR6_RgOffAddr ((BASE_ADDRESS + 0x1428))

#define DMA_RDTP_RPDR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR6_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR6_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR6_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR6_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR6_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR6_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR5_RgOffAddr ((BASE_ADDRESS + 0x13a8))

#define DMA_RDTP_RPDR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR5_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR5_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR5_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR5_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR5_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR5_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR4_RgOffAddr ((BASE_ADDRESS + 0x1328))

#define DMA_RDTP_RPDR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR4_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR4_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR4_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR4_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR4_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR4_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR3_RgOffAddr ((BASE_ADDRESS + 0x12a8))

#define DMA_RDTP_RPDR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR3_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR3_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR3_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR3_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR3_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR3_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR2_RgOffAddr ((BASE_ADDRESS + 0x1228))

#define DMA_RDTP_RPDR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR2_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR2_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR2_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR2_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR2_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR2_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR1_RgOffAddr ((BASE_ADDRESS + 0x11a8))

#define DMA_RDTP_RPDR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR1_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR1_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR1_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR1_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR1_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR1_RgRd(pdata, data);\
} while(0)


#define DMA_RDTP_RPDR0_RgOffAddr ((BASE_ADDRESS + 0x1128))

#define DMA_RDTP_RPDR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDTP_RPDR0_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDTP_RPDR0_RgOffAddr));\
} while(0)

#define DMA_RDTP_RPDR0_RDT_UdfWr(pdata, data) do {\
		DMA_RDTP_RPDR0_RgWr(pdata, data);\
} while(0)

#define DMA_RDTP_RPDR0_RDT_UdfRd(pdata, data) do {\
		DMA_RDTP_RPDR0_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR7_RgOffAddr ((BASE_ADDRESS + 0x14a0))

#define DMA_TDTP_TPDR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR7_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR7_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR7_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR7_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR7_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR7_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR6_RgOffAddr ((BASE_ADDRESS + 0x1420))

#define DMA_TDTP_TPDR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR6_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR6_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR6_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR6_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR6_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR6_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR5_RgOffAddr ((BASE_ADDRESS + 0x13a0))

#define DMA_TDTP_TPDR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR5_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR5_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR5_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR5_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR5_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR5_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR4_RgOffAddr ((BASE_ADDRESS + 0x1320))

#define DMA_TDTP_TPDR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR4_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR4_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR4_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR4_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR4_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR4_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR3_RgOffAddr ((BASE_ADDRESS + 0x12a0))

#define DMA_TDTP_TPDR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR3_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR3_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR3_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR3_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR3_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR3_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR2_RgOffAddr ((BASE_ADDRESS + 0x1220))

#define DMA_TDTP_TPDR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR2_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR2_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR2_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR2_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR2_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR2_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR1_RgOffAddr ((BASE_ADDRESS + 0x11a0))

#define DMA_TDTP_TPDR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR1_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR1_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR1_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR1_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR1_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR1_RgRd(pdata, data);\
} while(0)


#define DMA_TDTP_TPDR0_RgOffAddr ((BASE_ADDRESS + 0x1120))

#define DMA_TDTP_TPDR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDTP_TPDR0_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDTP_TPDR0_RgOffAddr));\
} while(0)

#define DMA_TDTP_TPDR0_TDT_UdfWr(pdata, data) do {\
		DMA_TDTP_TPDR0_RgWr(pdata, data);\
} while(0)

#define DMA_TDTP_TPDR0_TDT_UdfRd(pdata, data) do {\
		DMA_TDTP_TPDR0_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR7_RgOffAddr ((BASE_ADDRESS + 0x149c))

#define DMA_RDLAR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR7_RgOffAddr));\
} while(0)

#define DMA_RDLAR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR7_RgOffAddr));\
} while(0)

#define DMA_RDLAR7_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR7_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR7_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR7_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR6_RgOffAddr ((BASE_ADDRESS + 0x141c))

#define DMA_RDLAR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR6_RgOffAddr));\
} while(0)

#define DMA_RDLAR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR6_RgOffAddr));\
} while(0)

#define DMA_RDLAR6_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR6_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR6_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR6_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR5_RgOffAddr ((BASE_ADDRESS + 0x139c))

#define DMA_RDLAR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR5_RgOffAddr));\
} while(0)

#define DMA_RDLAR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR5_RgOffAddr));\
} while(0)

#define DMA_RDLAR5_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR5_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR5_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR5_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR4_RgOffAddr ((BASE_ADDRESS + 0x131c))

#define DMA_RDLAR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR4_RgOffAddr));\
} while(0)

#define DMA_RDLAR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR4_RgOffAddr));\
} while(0)

#define DMA_RDLAR4_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR4_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR4_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR4_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR3_RgOffAddr ((BASE_ADDRESS + 0x129c))

#define DMA_RDLAR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR3_RgOffAddr));\
} while(0)

#define DMA_RDLAR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR3_RgOffAddr));\
} while(0)

#define DMA_RDLAR3_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR3_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR3_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR3_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR2_RgOffAddr ((BASE_ADDRESS + 0x121c))

#define DMA_RDLAR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR2_RgOffAddr));\
} while(0)

#define DMA_RDLAR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR2_RgOffAddr));\
} while(0)

#define DMA_RDLAR2_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR2_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR2_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR2_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR1_RgOffAddr ((BASE_ADDRESS + 0x119c))

#define DMA_RDLAR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR1_RgOffAddr));\
} while(0)

#define DMA_RDLAR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR1_RgOffAddr));\
} while(0)

#define DMA_RDLAR1_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR1_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR1_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR1_RgRd(pdata, data);\
} while(0)


#define DMA_RDLAR0_RgOffAddr ((BASE_ADDRESS + 0x111c))

#define DMA_RDLAR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RDLAR0_RgOffAddr));\
} while(0)

#define DMA_RDLAR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RDLAR0_RgOffAddr));\
} while(0)

#define DMA_RDLAR0_RDESLA_UdfWr(pdata, data) do {\
		DMA_RDLAR0_RgWr(pdata, data);\
} while(0)

#define DMA_RDLAR0_RDESLA_UdfRd(pdata, data) do {\
		DMA_RDLAR0_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR7_RgOffAddr ((BASE_ADDRESS + 0x1494))

#define DMA_TDLAR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR7_RgOffAddr));\
} while(0)

#define DMA_TDLAR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR7_RgOffAddr));\
} while(0)

#define DMA_TDLAR7_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR7_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR7_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR7_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR6_RgOffAddr ((BASE_ADDRESS + 0x1414))

#define DMA_TDLAR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR6_RgOffAddr));\
} while(0)

#define DMA_TDLAR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR6_RgOffAddr));\
} while(0)

#define DMA_TDLAR6_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR6_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR6_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR6_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR5_RgOffAddr ((BASE_ADDRESS + 0x1394))

#define DMA_TDLAR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR5_RgOffAddr));\
} while(0)

#define DMA_TDLAR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR5_RgOffAddr));\
} while(0)

#define DMA_TDLAR5_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR5_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR5_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR5_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR4_RgOffAddr ((BASE_ADDRESS + 0x1314))

#define DMA_TDLAR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR4_RgOffAddr));\
} while(0)

#define DMA_TDLAR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR4_RgOffAddr));\
} while(0)

#define DMA_TDLAR4_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR4_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR4_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR4_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR3_RgOffAddr ((BASE_ADDRESS + 0x1294))

#define DMA_TDLAR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR3_RgOffAddr));\
} while(0)

#define DMA_TDLAR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR3_RgOffAddr));\
} while(0)

#define DMA_TDLAR3_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR3_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR3_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR3_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR2_RgOffAddr ((BASE_ADDRESS + 0x1214))

#define DMA_TDLAR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR2_RgOffAddr));\
} while(0)

#define DMA_TDLAR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR2_RgOffAddr));\
} while(0)

#define DMA_TDLAR2_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR2_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR2_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR2_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR1_RgOffAddr ((BASE_ADDRESS + 0x1194))

#define DMA_TDLAR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR1_RgOffAddr));\
} while(0)

#define DMA_TDLAR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR1_RgOffAddr));\
} while(0)

#define DMA_TDLAR1_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR1_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR1_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR1_RgRd(pdata, data);\
} while(0)


#define DMA_TDLAR0_RgOffAddr ((BASE_ADDRESS + 0x1114))

#define DMA_TDLAR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TDLAR0_RgOffAddr));\
} while(0)

#define DMA_TDLAR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TDLAR0_RgOffAddr));\
} while(0)

#define DMA_TDLAR0_TDESLA_UdfWr(pdata, data) do {\
		DMA_TDLAR0_RgWr(pdata, data);\
} while(0)

#define DMA_TDLAR0_TDESLA_UdfRd(pdata, data) do {\
		DMA_TDLAR0_RgRd(pdata, data);\
} while(0)


#define MAC_IMR_RgOffAddr ((BASE_ADDRESS + 0xb4))

#define MAC_IMR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_IMR_RgOffAddr));\
} while(0)

#define MAC_IMR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_IMR_RgOffAddr));\
} while(0)

/*#define  MAC_IMR_Mask_13 (ULONG)(~(~0<<(19)))*/

#define  MAC_IMR_Mask_13 (ULONG)(0x7ffff)

/*#define MAC_IMR_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(19)))<<(13)))*/

#define MAC_IMR_RES_Wr_Mask_13 (ULONG)(0x1fff)

/*#define  MAC_IMR_Mask_6 (ULONG)(~(~0<<(6)))*/

#define  MAC_IMR_Mask_6 (ULONG)(0x3f)

/*#define MAC_IMR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(6)))<<(6)))*/

#define MAC_IMR_RES_Wr_Mask_6 (ULONG)(0xfffff03f)

/*#define MAC_IMR_TSIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_TSIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_TSIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MAC_IMR_TSIM_Wr_Mask (ULONG)(0xffffefff)

#define MAC_IMR_TSIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_TSIM_Wr_Mask) | ((data & MAC_IMR_TSIM_Mask)<<12));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_TSIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_IMR_TSIM_Mask);\
} while(0)

/*#define MAC_IMR_LPIIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_LPIIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_LPIIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MAC_IMR_LPIIM_Wr_Mask (ULONG)(0xffffffdf)

#define MAC_IMR_LPIIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_LPIIM_Wr_Mask) | ((data & MAC_IMR_LPIIM_Mask)<<5));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_LPIIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_IMR_LPIIM_Mask);\
} while(0)

/*#define MAC_IMR_PMTIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PMTIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_PMTIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MAC_IMR_PMTIM_Wr_Mask (ULONG)(0xffffffef)

#define MAC_IMR_PMTIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_PMTIM_Wr_Mask) | ((data & MAC_IMR_PMTIM_Mask)<<4));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_PMTIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_IMR_PMTIM_Mask);\
} while(0)

/*#define MAC_IMR_PHYIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PHYIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_PHYIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MAC_IMR_PHYIM_Wr_Mask (ULONG)(0xfffffff7)

#define MAC_IMR_PHYIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_PHYIM_Wr_Mask) | ((data & MAC_IMR_PHYIM_Mask)<<3));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_PHYIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_IMR_PHYIM_Mask);\
} while(0)

/*#define MAC_IMR_PCSANCIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PCSANCIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_PCSANCIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define MAC_IMR_PCSANCIM_Wr_Mask (ULONG)(0xfffffffb)

#define MAC_IMR_PCSANCIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_PCSANCIM_Wr_Mask) | ((data & MAC_IMR_PCSANCIM_Mask)<<2));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_PCSANCIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_IMR_PCSANCIM_Mask);\
} while(0)

/*#define MAC_IMR_PCSLCHGIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_PCSLCHGIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_PCSLCHGIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_IMR_PCSLCHGIM_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_IMR_PCSLCHGIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_PCSLCHGIM_Wr_Mask) | ((data & MAC_IMR_PCSLCHGIM_Mask)<<1));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_PCSLCHGIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_IMR_PCSLCHGIM_Mask);\
} while(0)

/*#define MAC_IMR_RGSMIIIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IMR_RGSMIIIM_Mask (ULONG)(0x1)

/*#define MAC_IMR_RGSMIIIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_IMR_RGSMIIIM_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_IMR_RGSMIIIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IMR_RgRd(pdata, v);\
		v = (v & (MAC_IMR_RES_Wr_Mask_13))|((( 0) & (MAC_IMR_Mask_13))<<13);\
		v = (v & (MAC_IMR_RES_Wr_Mask_6))|((( 0) & (MAC_IMR_Mask_6))<<6);\
		v = ((v & MAC_IMR_RGSMIIIM_Wr_Mask) | ((data & MAC_IMR_RGSMIIIM_Mask)<<0));\
		MAC_IMR_RgWr(pdata, v);\
} while(0)

#define MAC_IMR_RGSMIIIM_UdfRd(pdata, data) do {\
		MAC_IMR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_IMR_RGSMIIIM_Mask);\
} while(0)


#define MAC_ISR_RgOffAddr ((BASE_ADDRESS + 0xb0))

#define MAC_ISR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_ISR_RgOffAddr));\
} while(0)

/*#define MAC_ISR_RWT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_RWT_Mask (ULONG)(0x1)

#define MAC_ISR_RWT_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_ISR_RWT_Mask);\
} while(0)

/*#define MAC_ISR_TJT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_TJT_Mask (ULONG)(0x1)

#define MAC_ISR_TJT_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 13) & MAC_ISR_TJT_Mask);\
} while(0)

/*#define MAC_ISR_TSIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_TSIS_Mask (ULONG)(0x1)

#define MAC_ISR_TSIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_ISR_TSIS_Mask);\
} while(0)

/*#define MAC_ISR_MMCRXIPIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCRXIPIS_Mask (ULONG)(0x1)

#define MAC_ISR_MMCRXIPIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 11) & MAC_ISR_MMCRXIPIS_Mask);\
} while(0)

/*#define MAC_ISR_MMCTXIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCTXIS_Mask (ULONG)(0x1)

#define MAC_ISR_MMCTXIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 10) & MAC_ISR_MMCTXIS_Mask);\
} while(0)

/*#define MAC_ISR_MMCRXIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCRXIS_Mask (ULONG)(0x1)

#define MAC_ISR_MMCRXIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 9) & MAC_ISR_MMCRXIS_Mask);\
} while(0)

/*#define MAC_ISR_MMCIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_MMCIS_Mask (ULONG)(0x1)

#define MAC_ISR_MMCIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_ISR_MMCIS_Mask);\
} while(0)

/*#define MAC_ISR_LPIIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_LPIIS_Mask (ULONG)(0x1)

#define MAC_ISR_LPIIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 5) & MAC_ISR_LPIIS_Mask);\
} while(0)

/*#define MAC_ISR_PMTIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PMTIS_Mask (ULONG)(0x1)

#define MAC_ISR_PMTIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_ISR_PMTIS_Mask);\
} while(0)

/*#define MAC_ISR_PHYIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PHYIS_Mask (ULONG)(0x1)

#define MAC_ISR_PHYIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 3) & MAC_ISR_PHYIS_Mask);\
} while(0)

/*#define MAC_ISR_PCSANCIA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PCSANCIA_Mask (ULONG)(0x1)

#define MAC_ISR_PCSANCIA_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_ISR_PCSANCIA_Mask);\
} while(0)

/*#define MAC_ISR_PCSLCHGIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_PCSLCHGIS_Mask (ULONG)(0x1)

#define MAC_ISR_PCSLCHGIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_ISR_PCSLCHGIS_Mask);\
} while(0)

/*#define MAC_ISR_RGSMIIIS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_ISR_RGSMIIIS_Mask (ULONG)(0x1)

#define MAC_ISR_RGSMIIIS_UdfRd(pdata, data) do {\
		MAC_ISR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_ISR_RGSMIIIS_Mask);\
} while(0)


#define MTL_ISR_RgOffAddr ((BASE_ADDRESS + 0xc20))

#define MTL_ISR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_ISR_RgOffAddr));\
} while(0)

/*#define MTL_ISR_MACIS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_MACIS_Mask (ULONG)(0x1)

#define MTL_ISR_MACIS_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_ISR_MACIS_Mask);\
} while(0)

/*#define MTL_ISR_Q7RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q7RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q7RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 15) & MTL_ISR_Q7RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q7TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q7TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q7TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 14) & MTL_ISR_Q7TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q6RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q6RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q6RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 13) & MTL_ISR_Q6RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q6TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q6TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q6TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 12) & MTL_ISR_Q6TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q5RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q5RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q5RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_ISR_Q5RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q5TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q5TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q5TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 10) & MTL_ISR_Q5TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q4RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q4RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q4RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 9) & MTL_ISR_Q4RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q4TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q4TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q4TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_ISR_Q4TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q3RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q3RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q3RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 7) & MTL_ISR_Q3RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q3TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q3TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q3TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 6) & MTL_ISR_Q3TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q2RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q2RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q2RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_ISR_Q2RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q2TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q2TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q2TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_ISR_Q2TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q1RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q1RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q1RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_ISR_Q1RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q1TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q1TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q1TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_ISR_Q1TXU_Mask);\
} while(0)

/*#define MTL_ISR_Q0RXO_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q0RXO_Mask (ULONG)(0x1)

#define MTL_ISR_Q0RXO_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_ISR_Q0RXO_Mask);\
} while(0)

/*#define MTL_ISR_Q0TXU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_ISR_Q0TXU_Mask (ULONG)(0x1)

#define MTL_ISR_Q0TXU_UdfRd(pdata, data) do {\
		MTL_ISR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_ISR_Q0TXU_Mask);\
} while(0)


#define DMA_ISR_RgOffAddr ((BASE_ADDRESS + 0x1008))

#define DMA_ISR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_ISR_RgOffAddr));\
} while(0)

/*#define DMA_ISR_MACIS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_MACIS_Mask (ULONG)(0x1)

#define DMA_ISR_MACIS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 17) & DMA_ISR_MACIS_Mask);\
} while(0)

/*#define DMA_ISR_MTLIS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_MTLIS_Mask (ULONG)(0x1)

#define DMA_ISR_MTLIS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_ISR_MTLIS_Mask);\
} while(0)

/*#define DMA_ISR_DC7IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC7IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC7IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 7) & DMA_ISR_DC7IS_Mask);\
} while(0)

/*#define DMA_ISR_DC6IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC6IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC6IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 6) & DMA_ISR_DC6IS_Mask);\
} while(0)

/*#define DMA_ISR_DC5IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC5IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC5IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 5) & DMA_ISR_DC5IS_Mask);\
} while(0)

/*#define DMA_ISR_DC4IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC4IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC4IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_ISR_DC4IS_Mask);\
} while(0)

/*#define DMA_ISR_DC3IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC3IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC3IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 3) & DMA_ISR_DC3IS_Mask);\
} while(0)

/*#define DMA_ISR_DC2IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC2IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC2IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 2) & DMA_ISR_DC2IS_Mask);\
} while(0)

/*#define DMA_ISR_DC1IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC1IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC1IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_ISR_DC1IS_Mask);\
} while(0)

/*#define DMA_ISR_DC0IS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_ISR_DC0IS_Mask (ULONG)(0x1)

#define DMA_ISR_DC0IS_UdfRd(pdata, data) do {\
		DMA_ISR_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_ISR_DC0IS_Mask);\
} while(0)


#define DMA_DSR2_RgOffAddr ((BASE_ADDRESS + 0x1014))

#define DMA_DSR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_DSR2_RgOffAddr));\
} while(0)

/*#define DMA_DSR2_TPS7_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR2_TPS7_Mask (ULONG)(0xf)

#define DMA_DSR2_TPS7_UdfRd(pdata, data) do {\
		DMA_DSR2_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_DSR2_TPS7_Mask);\
} while(0)

/*#define DMA_DSR2_RPS7_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR2_RPS7_Mask (ULONG)(0xf)

#define DMA_DSR2_RPS7_UdfRd(pdata, data) do {\
		DMA_DSR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_DSR2_RPS7_Mask);\
} while(0)


#define DMA_DSR1_RgOffAddr ((BASE_ADDRESS + 0x1010))

#define DMA_DSR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_DSR1_RgOffAddr));\
} while(0)

/*#define DMA_DSR1_TPS6_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS6_Mask (ULONG)(0xf)

#define DMA_DSR1_TPS6_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 28) & DMA_DSR1_TPS6_Mask);\
} while(0)

/*#define DMA_DSR1_RPS6_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS6_Mask (ULONG)(0xf)

#define DMA_DSR1_RPS6_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 24) & DMA_DSR1_RPS6_Mask);\
} while(0)

/*#define DMA_DSR1_TPS5_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS5_Mask (ULONG)(0xf)

#define DMA_DSR1_TPS5_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 20) & DMA_DSR1_TPS5_Mask);\
} while(0)

/*#define DMA_DSR1_RPS5_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS5_Mask (ULONG)(0xf)

#define DMA_DSR1_RPS5_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_DSR1_RPS5_Mask);\
} while(0)

/*#define DMA_DSR1_TPS4_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS4_Mask (ULONG)(0xf)

#define DMA_DSR1_TPS4_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_DSR1_TPS4_Mask);\
} while(0)

/*#define DMA_DSR1_RPS4_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS4_Mask (ULONG)(0xf)

#define DMA_DSR1_RPS4_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 8) & DMA_DSR1_RPS4_Mask);\
} while(0)

/*#define DMA_DSR1_TPS3_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_TPS3_Mask (ULONG)(0xf)

#define DMA_DSR1_TPS3_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_DSR1_TPS3_Mask);\
} while(0)

/*#define DMA_DSR1_RPS3_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR1_RPS3_Mask (ULONG)(0xf)

#define DMA_DSR1_RPS3_UdfRd(pdata, data) do {\
		DMA_DSR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_DSR1_RPS3_Mask);\
} while(0)


#define DMA_DSR0_RgOffAddr ((BASE_ADDRESS + 0x100c))

#define DMA_DSR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_DSR0_RgOffAddr));\
} while(0)

/*#define DMA_DSR0_TPS2_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS2_Mask (ULONG)(0xf)

#define DMA_DSR0_TPS2_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 28) & DMA_DSR0_TPS2_Mask);\
} while(0)

/*#define DMA_DSR0_RPS2_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS2_Mask (ULONG)(0xf)

#define DMA_DSR0_RPS2_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 24) & DMA_DSR0_RPS2_Mask);\
} while(0)

/*#define DMA_DSR0_TPS1_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS1_Mask (ULONG)(0xf)

#define DMA_DSR0_TPS1_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 20) & DMA_DSR0_TPS1_Mask);\
} while(0)

/*#define DMA_DSR0_RPS1_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS1_Mask (ULONG)(0xf)

#define DMA_DSR0_RPS1_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_DSR0_RPS1_Mask);\
} while(0)

/*#define DMA_DSR0_TPS0_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_TPS0_Mask (ULONG)(0xf)

#define DMA_DSR0_TPS0_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_DSR0_TPS0_Mask);\
} while(0)

/*#define DMA_DSR0_RPS0_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_DSR0_RPS0_Mask (ULONG)(0xf)

#define DMA_DSR0_RPS0_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 8) & DMA_DSR0_RPS0_Mask);\
} while(0)

/*#define DMA_DSR0_AXRHSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_DSR0_AXRHSTS_Mask (ULONG)(0x1)

#define DMA_DSR0_AXRHSTS_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_DSR0_AXRHSTS_Mask);\
} while(0)

/*#define DMA_DSR0_AXWHSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_DSR0_AXWHSTS_Mask (ULONG)(0x1)

#define DMA_DSR0_AXWHSTS_UdfRd(pdata, data) do {\
		DMA_DSR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_DSR0_AXWHSTS_Mask);\
} while(0)


#define MTL_Q0RDR_RgOffAddr ((BASE_ADDRESS + 0xd38))

#define MTL_Q0RDR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0RDR_RgOffAddr));\
} while(0)

/*#define MTL_Q0RDR_PRXQ_Mask (ULONG)(~(~0<<(14)))*/

#define MTL_Q0RDR_PRXQ_Mask (ULONG)(0x3fff)

#define MTL_Q0RDR_PRXQ_UdfRd(pdata, data) do {\
		MTL_Q0RDR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_Q0RDR_PRXQ_Mask);\
} while(0)

/*#define MTL_Q0RDR_RXQSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0RDR_RXQSTS_Mask (ULONG)(0x3)

#define MTL_Q0RDR_RXQSTS_UdfRd(pdata, data) do {\
		MTL_Q0RDR_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_Q0RDR_RXQSTS_Mask);\
} while(0)

/*#define MTL_Q0RDR_RRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0RDR_RRCSTS_Mask (ULONG)(0x3)

#define MTL_Q0RDR_RRCSTS_UdfRd(pdata, data) do {\
		MTL_Q0RDR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_Q0RDR_RRCSTS_Mask);\
} while(0)

/*#define MTL_Q0RDR_RWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0RDR_RWCSTS_Mask (ULONG)(0x1)

#define MTL_Q0RDR_RWCSTS_UdfRd(pdata, data) do {\
		MTL_Q0RDR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0RDR_RWCSTS_Mask);\
} while(0)


#define MTL_Q0ESR_RgOffAddr ((BASE_ADDRESS + 0xd14))

#define MTL_Q0ESR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0ESR_RgOffAddr));\
} while(0)

/*#define MTL_Q0ESR_ABSU_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ESR_ABSU_Mask (ULONG)(0x1)

#define MTL_Q0ESR_ABSU_UdfRd(pdata, data) do {\
		MTL_Q0ESR_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_Q0ESR_ABSU_Mask);\
} while(0)

/*#define MTL_Q0ESR_ABS_Mask (ULONG)(~(~0<<(24)))*/

#define MTL_Q0ESR_ABS_Mask (ULONG)(0xffffff)

#define MTL_Q0ESR_ABS_UdfRd(pdata, data) do {\
		MTL_Q0ESR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0ESR_ABS_Mask);\
} while(0)


#define MTL_Q0TDR_RgOffAddr ((BASE_ADDRESS + 0xd08))

#define MTL_Q0TDR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0TDR_RgOffAddr));\
} while(0)

/*#define MTL_Q0TDR_STXSTSF_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TDR_STXSTSF_Mask (ULONG)(0x7)

#define MTL_Q0TDR_STXSTSF_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_Q0TDR_STXSTSF_Mask);\
} while(0)

/*#define MTL_Q0TDR_PTXQ_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TDR_PTXQ_Mask (ULONG)(0x7)

#define MTL_Q0TDR_PTXQ_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_Q0TDR_PTXQ_Mask);\
} while(0)

/*#define MTL_Q0TDR_TXSTSFSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXSTSFSTS_Mask (ULONG)(0x1)

#define MTL_Q0TDR_TXSTSFSTS_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_Q0TDR_TXSTSFSTS_Mask);\
} while(0)

/*#define MTL_Q0TDR_TXQSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXQSTS_Mask (ULONG)(0x1)

#define MTL_Q0TDR_TXQSTS_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_Q0TDR_TXQSTS_Mask);\
} while(0)

/*#define MTL_Q0TDR_TWCSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TWCSTS_Mask (ULONG)(0x1)

#define MTL_Q0TDR_TWCSTS_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_Q0TDR_TWCSTS_Mask);\
} while(0)

/*#define MTL_Q0TDR_TRCSTS_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0TDR_TRCSTS_Mask (ULONG)(0x3)

#define MTL_Q0TDR_TRCSTS_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_Q0TDR_TRCSTS_Mask);\
} while(0)

/*#define MTL_Q0TDR_TXQPAUSED_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TDR_TXQPAUSED_Mask (ULONG)(0x1)

#define MTL_Q0TDR_TXQPAUSED_UdfRd(pdata, data) do {\
		MTL_Q0TDR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0TDR_TXQPAUSED_Mask);\
} while(0)


#define DMA_CHRBAR7_RgOffAddr ((BASE_ADDRESS + 0x14dc))

#define DMA_CHRBAR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR7_RgOffAddr));\
} while(0)

#define DMA_CHRBAR7_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR7_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR6_RgOffAddr ((BASE_ADDRESS + 0x145c))

#define DMA_CHRBAR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR6_RgOffAddr));\
} while(0)

#define DMA_CHRBAR6_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR6_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR5_RgOffAddr ((BASE_ADDRESS + 0x13dc))

#define DMA_CHRBAR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR5_RgOffAddr));\
} while(0)

#define DMA_CHRBAR5_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR5_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR4_RgOffAddr ((BASE_ADDRESS + 0x135c))

#define DMA_CHRBAR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR4_RgOffAddr));\
} while(0)

#define DMA_CHRBAR4_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR4_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR3_RgOffAddr ((BASE_ADDRESS + 0x12dc))

#define DMA_CHRBAR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR3_RgOffAddr));\
} while(0)

#define DMA_CHRBAR3_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR3_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR2_RgOffAddr ((BASE_ADDRESS + 0x125c))

#define DMA_CHRBAR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR2_RgOffAddr));\
} while(0)

#define DMA_CHRBAR2_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR2_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR1_RgOffAddr ((BASE_ADDRESS + 0x11dc))

#define DMA_CHRBAR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR1_RgOffAddr));\
} while(0)

#define DMA_CHRBAR1_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR1_RgRd(pdata, data);\
} while(0)


#define DMA_CHRBAR0_RgOffAddr ((BASE_ADDRESS + 0x115c))

#define DMA_CHRBAR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRBAR0_RgOffAddr));\
} while(0)

#define DMA_CHRBAR0_CURRBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHRBAR0_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR7_RgOffAddr ((BASE_ADDRESS + 0x14d4))

#define DMA_CHTBAR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR7_RgOffAddr));\
} while(0)

#define DMA_CHTBAR7_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR7_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR6_RgOffAddr ((BASE_ADDRESS + 0x1454))

#define DMA_CHTBAR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR6_RgOffAddr));\
} while(0)

#define DMA_CHTBAR6_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR6_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR5_RgOffAddr ((BASE_ADDRESS + 0x13d4))

#define DMA_CHTBAR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR5_RgOffAddr));\
} while(0)

#define DMA_CHTBAR5_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR5_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR4_RgOffAddr ((BASE_ADDRESS + 0x1354))

#define DMA_CHTBAR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR4_RgOffAddr));\
} while(0)

#define DMA_CHTBAR4_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR4_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR3_RgOffAddr ((BASE_ADDRESS + 0x12d4))

#define DMA_CHTBAR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR3_RgOffAddr));\
} while(0)

#define DMA_CHTBAR3_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR3_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR2_RgOffAddr ((BASE_ADDRESS + 0x1254))

#define DMA_CHTBAR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR2_RgOffAddr));\
} while(0)

#define DMA_CHTBAR2_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR2_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR1_RgOffAddr ((BASE_ADDRESS + 0x11d4))

#define DMA_CHTBAR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR1_RgOffAddr));\
} while(0)

#define DMA_CHTBAR1_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR1_RgRd(pdata, data);\
} while(0)


#define DMA_CHTBAR0_RgOffAddr ((BASE_ADDRESS + 0x1154))

#define DMA_CHTBAR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTBAR0_RgOffAddr));\
} while(0)

#define DMA_CHTBAR0_CURTBUFAPTR_UdfRd(pdata, data) do {\
		DMA_CHTBAR0_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR7_RgOffAddr ((BASE_ADDRESS + 0x14cc))

#define DMA_CHRDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR7_RgOffAddr));\
} while(0)

#define DMA_CHRDR7_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR7_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR6_RgOffAddr ((BASE_ADDRESS + 0x144c))

#define DMA_CHRDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR6_RgOffAddr));\
} while(0)

#define DMA_CHRDR6_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR6_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR5_RgOffAddr ((BASE_ADDRESS + 0x13cc))

#define DMA_CHRDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR5_RgOffAddr));\
} while(0)

#define DMA_CHRDR5_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR5_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR4_RgOffAddr ((BASE_ADDRESS + 0x134c))

#define DMA_CHRDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR4_RgOffAddr));\
} while(0)

#define DMA_CHRDR4_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR4_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR3_RgOffAddr ((BASE_ADDRESS + 0x12cc))

#define DMA_CHRDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR3_RgOffAddr));\
} while(0)

#define DMA_CHRDR3_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR3_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR2_RgOffAddr ((BASE_ADDRESS + 0x124c))

#define DMA_CHRDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR2_RgOffAddr));\
} while(0)

#define DMA_CHRDR2_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR2_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR1_RgOffAddr ((BASE_ADDRESS + 0x11cc))

#define DMA_CHRDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR1_RgOffAddr));\
} while(0)

#define DMA_CHRDR1_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR1_RgRd(pdata, data);\
} while(0)


#define DMA_CHRDR0_RgOffAddr ((BASE_ADDRESS + 0x114c))

#define DMA_CHRDR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHRDR0_RgOffAddr));\
} while(0)

#define DMA_CHRDR0_CURRDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHRDR0_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR7_RgOffAddr ((BASE_ADDRESS + 0x14c4))

#define DMA_CHTDR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR7_RgOffAddr));\
} while(0)

#define DMA_CHTDR7_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR7_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR6_RgOffAddr ((BASE_ADDRESS + 0x1444))

#define DMA_CHTDR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR6_RgOffAddr));\
} while(0)

#define DMA_CHTDR6_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR6_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR5_RgOffAddr ((BASE_ADDRESS + 0x13c4))

#define DMA_CHTDR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR5_RgOffAddr));\
} while(0)

#define DMA_CHTDR5_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR5_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR4_RgOffAddr ((BASE_ADDRESS + 0x1344))

#define DMA_CHTDR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR4_RgOffAddr));\
} while(0)

#define DMA_CHTDR4_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR4_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR3_RgOffAddr ((BASE_ADDRESS + 0x12c4))

#define DMA_CHTDR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR3_RgOffAddr));\
} while(0)

#define DMA_CHTDR3_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR3_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR2_RgOffAddr ((BASE_ADDRESS + 0x1244))

#define DMA_CHTDR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR2_RgOffAddr));\
} while(0)

#define DMA_CHTDR2_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR2_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR1_RgOffAddr ((BASE_ADDRESS + 0x11c4))

#define DMA_CHTDR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR1_RgOffAddr));\
} while(0)

#define DMA_CHTDR1_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR1_RgRd(pdata, data);\
} while(0)


#define DMA_CHTDR0_RgOffAddr ((BASE_ADDRESS + 0x1144))

#define DMA_CHTDR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_CHTDR0_RgOffAddr));\
} while(0)

#define DMA_CHTDR0_CURTDESAPTR_UdfRd(pdata, data) do {\
		DMA_CHTDR0_RgRd(pdata, data);\
} while(0)


#define DMA_SFCSR7_RgOffAddr ((BASE_ADDRESS + 0x14bc))

#define DMA_SFCSR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR7_RgOffAddr));\
} while(0)

#define DMA_SFCSR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR7_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR7_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR7_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR7_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR7_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR7_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR7_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR7_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR7_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR7_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR7_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR7_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR7_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR7_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR7_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR7_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR7_Mask_2))<<2);\
		v = (v & (DMA_SFCSR7_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR7_Mask_20))<<20);\
		v = ((v & DMA_SFCSR7_ESC_Wr_Mask) | ((data & DMA_SFCSR7_ESC_Mask)<<0));\
		DMA_SFCSR7_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR7_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR7_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR7_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR7_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR7_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR7_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR7_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR7_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR7_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR7_Mask_2))<<2);\
		v = (v & (DMA_SFCSR7_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR7_Mask_20))<<20);\
		v = ((v & DMA_SFCSR7_ASC_Wr_Mask) | ((data & DMA_SFCSR7_ASC_Mask)<<1));\
		DMA_SFCSR7_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR7_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR7_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR7_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR7_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR7_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR7_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR7_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR7_RSN_Mask);\
} while(0)


#define DMA_SFCSR6_RgOffAddr ((BASE_ADDRESS + 0x143c))

#define DMA_SFCSR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR6_RgOffAddr));\
} while(0)

#define DMA_SFCSR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR6_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR6_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR6_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR6_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR6_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR6_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR6_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR6_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR6_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR6_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR6_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR6_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR6_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR6_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR6_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR6_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR6_Mask_2))<<2);\
		v = (v & (DMA_SFCSR6_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR6_Mask_20))<<20);\
		v = ((v & DMA_SFCSR6_ESC_Wr_Mask) | ((data & DMA_SFCSR6_ESC_Mask)<<0));\
		DMA_SFCSR6_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR6_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR6_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR6_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR6_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR6_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR6_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR6_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR6_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR6_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR6_Mask_2))<<2);\
		v = (v & (DMA_SFCSR6_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR6_Mask_20))<<20);\
		v = ((v & DMA_SFCSR6_ASC_Wr_Mask) | ((data & DMA_SFCSR6_ASC_Mask)<<1));\
		DMA_SFCSR6_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR6_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR6_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR6_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR6_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR6_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR6_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR6_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR6_RSN_Mask);\
} while(0)


#define DMA_SFCSR5_RgOffAddr ((BASE_ADDRESS + 0x13bc))

#define DMA_SFCSR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR5_RgOffAddr));\
} while(0)

#define DMA_SFCSR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR5_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR5_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR5_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR5_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR5_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR5_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR5_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR5_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR5_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR5_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR5_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR5_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR5_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR5_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR5_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR5_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR5_Mask_2))<<2);\
		v = (v & (DMA_SFCSR5_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR5_Mask_20))<<20);\
		v = ((v & DMA_SFCSR5_ESC_Wr_Mask) | ((data & DMA_SFCSR5_ESC_Mask)<<0));\
		DMA_SFCSR5_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR5_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR5_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR5_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR5_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR5_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR5_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR5_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR5_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR5_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR5_Mask_2))<<2);\
		v = (v & (DMA_SFCSR5_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR5_Mask_20))<<20);\
		v = ((v & DMA_SFCSR5_ASC_Wr_Mask) | ((data & DMA_SFCSR5_ASC_Mask)<<1));\
		DMA_SFCSR5_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR5_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR5_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR5_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR5_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR5_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR5_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR5_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR5_RSN_Mask);\
} while(0)


#define DMA_SFCSR4_RgOffAddr ((BASE_ADDRESS + 0x133c))

#define DMA_SFCSR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR4_RgOffAddr));\
} while(0)

#define DMA_SFCSR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR4_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR4_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR4_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR4_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR4_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR4_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR4_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR4_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR4_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR4_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR4_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR4_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR4_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR4_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR4_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR4_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR4_Mask_2))<<2);\
		v = (v & (DMA_SFCSR4_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR4_Mask_20))<<20);\
		v = ((v & DMA_SFCSR4_ESC_Wr_Mask) | ((data & DMA_SFCSR4_ESC_Mask)<<0));\
		DMA_SFCSR4_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR4_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR4_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR4_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR4_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR4_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR4_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR4_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR4_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR4_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR4_Mask_2))<<2);\
		v = (v & (DMA_SFCSR4_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR4_Mask_20))<<20);\
		v = ((v & DMA_SFCSR4_ASC_Wr_Mask) | ((data & DMA_SFCSR4_ASC_Mask)<<1));\
		DMA_SFCSR4_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR4_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR4_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR4_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR4_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR4_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR4_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR4_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR4_RSN_Mask);\
} while(0)


#define DMA_SFCSR3_RgOffAddr ((BASE_ADDRESS + 0x12bc))

#define DMA_SFCSR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR3_RgOffAddr));\
} while(0)

#define DMA_SFCSR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR3_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR3_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR3_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR3_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR3_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR3_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR3_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR3_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR3_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR3_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR3_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR3_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR3_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR3_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR3_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR3_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR3_Mask_2))<<2);\
		v = (v & (DMA_SFCSR3_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR3_Mask_20))<<20);\
		v = ((v & DMA_SFCSR3_ESC_Wr_Mask) | ((data & DMA_SFCSR3_ESC_Mask)<<0));\
		DMA_SFCSR3_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR3_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR3_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR3_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR3_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR3_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR3_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR3_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR3_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR3_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR3_Mask_2))<<2);\
		v = (v & (DMA_SFCSR3_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR3_Mask_20))<<20);\
		v = ((v & DMA_SFCSR3_ASC_Wr_Mask) | ((data & DMA_SFCSR3_ASC_Mask)<<1));\
		DMA_SFCSR3_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR3_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR3_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR3_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR3_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR3_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR3_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR3_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR3_RSN_Mask);\
} while(0)


#define DMA_SFCSR2_RgOffAddr ((BASE_ADDRESS + 0x123c))

#define DMA_SFCSR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR2_RgOffAddr));\
} while(0)

#define DMA_SFCSR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR2_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR2_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR2_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR2_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR2_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR2_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR2_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR2_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR2_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR2_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR2_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR2_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR2_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR2_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR2_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR2_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR2_Mask_2))<<2);\
		v = (v & (DMA_SFCSR2_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR2_Mask_20))<<20);\
		v = ((v & DMA_SFCSR2_ESC_Wr_Mask) | ((data & DMA_SFCSR2_ESC_Mask)<<0));\
		DMA_SFCSR2_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR2_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR2_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR2_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR2_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR2_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR2_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR2_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR2_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR2_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR2_Mask_2))<<2);\
		v = (v & (DMA_SFCSR2_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR2_Mask_20))<<20);\
		v = ((v & DMA_SFCSR2_ASC_Wr_Mask) | ((data & DMA_SFCSR2_ASC_Mask)<<1));\
		DMA_SFCSR2_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR2_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR2_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR2_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR2_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR2_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR2_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR2_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR2_RSN_Mask);\
} while(0)


#define DMA_SFCSR1_RgOffAddr ((BASE_ADDRESS + 0x11bc))

#define DMA_SFCSR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR1_RgOffAddr));\
} while(0)

#define DMA_SFCSR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR1_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR1_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR1_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR1_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR1_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR1_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR1_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR1_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR1_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR1_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR1_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR1_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR1_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR1_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR1_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR1_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR1_Mask_2))<<2);\
		v = (v & (DMA_SFCSR1_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR1_Mask_20))<<20);\
		v = ((v & DMA_SFCSR1_ESC_Wr_Mask) | ((data & DMA_SFCSR1_ESC_Mask)<<0));\
		DMA_SFCSR1_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR1_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR1_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR1_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR1_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR1_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR1_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR1_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR1_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR1_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR1_Mask_2))<<2);\
		v = (v & (DMA_SFCSR1_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR1_Mask_20))<<20);\
		v = ((v & DMA_SFCSR1_ASC_Wr_Mask) | ((data & DMA_SFCSR1_ASC_Mask)<<1));\
		DMA_SFCSR1_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR1_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR1_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR1_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR1_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR1_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR1_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR1_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR1_RSN_Mask);\
} while(0)


#define DMA_SFCSR0_RgOffAddr ((BASE_ADDRESS + 0x113c))

#define DMA_SFCSR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SFCSR0_RgOffAddr));\
} while(0)

#define DMA_SFCSR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SFCSR0_RgOffAddr));\
} while(0)

/*#define  DMA_SFCSR0_Mask_2 (ULONG)(~(~0<<(14)))*/

#define  DMA_SFCSR0_Mask_2 (ULONG)(0x3fff)

/*#define DMA_SFCSR0_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(14)))<<(2)))*/

#define DMA_SFCSR0_RES_Wr_Mask_2 (ULONG)(0xffff0003)

/*#define  DMA_SFCSR0_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_SFCSR0_Mask_20 (ULONG)(0xfff)

/*#define DMA_SFCSR0_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_SFCSR0_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_SFCSR0_ESC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR0_ESC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR0_ESC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SFCSR0_ESC_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SFCSR0_ESC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR0_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR0_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR0_Mask_2))<<2);\
		v = (v & (DMA_SFCSR0_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR0_Mask_20))<<20);\
		v = ((v & DMA_SFCSR0_ESC_Wr_Mask) | ((data & DMA_SFCSR0_ESC_Mask)<<0));\
		DMA_SFCSR0_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR0_ESC_UdfRd(pdata, data) do {\
		DMA_SFCSR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SFCSR0_ESC_Mask);\
} while(0)

/*#define DMA_SFCSR0_ASC_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SFCSR0_ASC_Mask (ULONG)(0x1)

/*#define DMA_SFCSR0_ASC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SFCSR0_ASC_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SFCSR0_ASC_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SFCSR0_RgRd(pdata, v);\
		v = (v & (DMA_SFCSR0_RES_Wr_Mask_2))|((( 0) & (DMA_SFCSR0_Mask_2))<<2);\
		v = (v & (DMA_SFCSR0_RES_Wr_Mask_20))|((( 0) & (DMA_SFCSR0_Mask_20))<<20);\
		v = ((v & DMA_SFCSR0_ASC_Wr_Mask) | ((data & DMA_SFCSR0_ASC_Mask)<<1));\
		DMA_SFCSR0_RgWr(pdata, v);\
} while(0)

#define DMA_SFCSR0_ASC_UdfRd(pdata, data) do {\
		DMA_SFCSR0_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SFCSR0_ASC_Mask);\
} while(0)

/*#define DMA_SFCSR0_RSN_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_SFCSR0_RSN_Mask (ULONG)(0xf)

#define DMA_SFCSR0_RSN_UdfRd(pdata, data) do {\
		DMA_SFCSR0_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SFCSR0_RSN_Mask);\
} while(0)


#define MAC_IVLANTIRR_RgOffAddr ((BASE_ADDRESS + 0x64))

#define MAC_IVLANTIRR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_IVLANTIRR_RgOffAddr));\
} while(0)

#define MAC_IVLANTIRR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_IVLANTIRR_RgOffAddr));\
} while(0)

/*#define  MAC_IVLANTIRR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MAC_IVLANTIRR_Mask_21 (ULONG)(0x7ff)

/*#define MAC_IVLANTIRR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MAC_IVLANTIRR_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MAC_IVLANTIRR_VLTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_VLTI_Mask (ULONG)(0x1)

/*#define MAC_IVLANTIRR_VLTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_IVLANTIRR_VLTI_Wr_Mask (ULONG)(0xffefffff)

#define MAC_IVLANTIRR_VLTI_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_IVLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_IVLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_IVLANTIRR_VLTI_Wr_Mask) | ((data & MAC_IVLANTIRR_VLTI_Mask)<<20));\
		MAC_IVLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_IVLANTIRR_VLTI_UdfRd(pdata, data) do {\
		MAC_IVLANTIRR_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_IVLANTIRR_VLTI_Mask);\
} while(0)

/*#define MAC_IVLANTIRR_CSVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_CSVL_Mask (ULONG)(0x1)

/*#define MAC_IVLANTIRR_CSVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_IVLANTIRR_CSVL_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_IVLANTIRR_CSVL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_IVLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_IVLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_IVLANTIRR_CSVL_Wr_Mask) | ((data & MAC_IVLANTIRR_CSVL_Mask)<<19));\
		MAC_IVLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_IVLANTIRR_CSVL_UdfRd(pdata, data) do {\
		MAC_IVLANTIRR_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_IVLANTIRR_CSVL_Mask);\
} while(0)

/*#define MAC_IVLANTIRR_VLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_IVLANTIRR_VLP_Mask (ULONG)(0x1)

/*#define MAC_IVLANTIRR_VLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_IVLANTIRR_VLP_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_IVLANTIRR_VLP_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_IVLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_IVLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_IVLANTIRR_VLP_Wr_Mask) | ((data & MAC_IVLANTIRR_VLP_Mask)<<18));\
		MAC_IVLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_IVLANTIRR_VLP_UdfRd(pdata, data) do {\
		MAC_IVLANTIRR_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_IVLANTIRR_VLP_Mask);\
} while(0)

/*#define MAC_IVLANTIRR_VLC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_IVLANTIRR_VLC_Mask (ULONG)(0x3)

/*#define MAC_IVLANTIRR_VLC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_IVLANTIRR_VLC_Wr_Mask (ULONG)(0xfffcffff)

#define MAC_IVLANTIRR_VLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_IVLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_IVLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_IVLANTIRR_VLC_Wr_Mask) | ((data & MAC_IVLANTIRR_VLC_Mask)<<16));\
		MAC_IVLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_IVLANTIRR_VLC_UdfRd(pdata, data) do {\
		MAC_IVLANTIRR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_IVLANTIRR_VLC_Mask);\
} while(0)

/*#define MAC_IVLANTIRR_VLT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_IVLANTIRR_VLT_Mask (ULONG)(0xffff)

/*#define MAC_IVLANTIRR_VLT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_IVLANTIRR_VLT_Wr_Mask (ULONG)(0xffff0000)

#define MAC_IVLANTIRR_VLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_IVLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_IVLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_IVLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_IVLANTIRR_VLT_Wr_Mask) | ((data & MAC_IVLANTIRR_VLT_Mask)<<0));\
		MAC_IVLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_IVLANTIRR_VLT_UdfRd(pdata, data) do {\
		MAC_IVLANTIRR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_IVLANTIRR_VLT_Mask);\
} while(0)


#define MAC_VLANTIRR_RgOffAddr ((BASE_ADDRESS + 0x60))

#define MAC_VLANTIRR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_VLANTIRR_RgOffAddr));\
} while(0)

#define MAC_VLANTIRR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_VLANTIRR_RgOffAddr));\
} while(0)

/*#define  MAC_VLANTIRR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MAC_VLANTIRR_Mask_21 (ULONG)(0x7ff)

/*#define MAC_VLANTIRR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MAC_VLANTIRR_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MAC_VLANTIRR_VLTI_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_VLTI_Mask (ULONG)(0x1)

/*#define MAC_VLANTIRR_VLTI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_VLANTIRR_VLTI_Wr_Mask (ULONG)(0xffefffff)

#define MAC_VLANTIRR_VLTI_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_VLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_VLANTIRR_VLTI_Wr_Mask) | ((data & MAC_VLANTIRR_VLTI_Mask)<<20));\
		MAC_VLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTIRR_VLTI_UdfRd(pdata, data) do {\
		MAC_VLANTIRR_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_VLANTIRR_VLTI_Mask);\
} while(0)

/*#define MAC_VLANTIRR_CSVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_CSVL_Mask (ULONG)(0x1)

/*#define MAC_VLANTIRR_CSVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_VLANTIRR_CSVL_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_VLANTIRR_CSVL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_VLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_VLANTIRR_CSVL_Wr_Mask) | ((data & MAC_VLANTIRR_CSVL_Mask)<<19));\
		MAC_VLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTIRR_CSVL_UdfRd(pdata, data) do {\
		MAC_VLANTIRR_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_VLANTIRR_CSVL_Mask);\
} while(0)

/*#define MAC_VLANTIRR_VLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTIRR_VLP_Mask (ULONG)(0x1)

/*#define MAC_VLANTIRR_VLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_VLANTIRR_VLP_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_VLANTIRR_VLP_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_VLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_VLANTIRR_VLP_Wr_Mask) | ((data & MAC_VLANTIRR_VLP_Mask)<<18));\
		MAC_VLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTIRR_VLP_UdfRd(pdata, data) do {\
		MAC_VLANTIRR_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_VLANTIRR_VLP_Mask);\
} while(0)

/*#define MAC_VLANTIRR_VLC_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTIRR_VLC_Mask (ULONG)(0x3)

/*#define MAC_VLANTIRR_VLC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (16)))*/

#define MAC_VLANTIRR_VLC_Wr_Mask (ULONG)(0xfffcffff)

#define MAC_VLANTIRR_VLC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_VLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_VLANTIRR_VLC_Wr_Mask) | ((data & MAC_VLANTIRR_VLC_Mask)<<16));\
		MAC_VLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTIRR_VLC_UdfRd(pdata, data) do {\
		MAC_VLANTIRR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_VLANTIRR_VLC_Mask);\
} while(0)

/*#define MAC_VLANTIRR_VLT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANTIRR_VLT_Mask (ULONG)(0xffff)

/*#define MAC_VLANTIRR_VLT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANTIRR_VLT_Wr_Mask (ULONG)(0xffff0000)

#define MAC_VLANTIRR_VLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTIRR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTIRR_RES_Wr_Mask_21))|((( 0) & (MAC_VLANTIRR_Mask_21))<<21);\
		v = ((v & MAC_VLANTIRR_VLT_Wr_Mask) | ((data & MAC_VLANTIRR_VLT_Mask)<<0));\
		MAC_VLANTIRR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTIRR_VLT_UdfRd(pdata, data) do {\
		MAC_VLANTIRR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_VLANTIRR_VLT_Mask);\
} while(0)


#define MAC_VLANHTR_RgOffAddr ((BASE_ADDRESS + 0x58))

#define MAC_VLANHTR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_VLANHTR_RgOffAddr));\
} while(0)

#define MAC_VLANHTR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_VLANHTR_RgOffAddr));\
} while(0)

/*#define  MAC_VLANHTR_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_VLANHTR_Mask_16 (ULONG)(0xffff)

/*#define MAC_VLANHTR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_VLANHTR_RES_Wr_Mask_16 (ULONG)(0xffff)

/*#define MAC_VLANHTR_VLHT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANHTR_VLHT_Mask (ULONG)(0xffff)

/*#define MAC_VLANHTR_VLHT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANHTR_VLHT_Wr_Mask (ULONG)(0xffff0000)

#define MAC_VLANHTR_VLHT_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MAC_VLANHTR_RES_Wr_Mask_16))|((( 0) & (MAC_VLANHTR_Mask_16))<<16);\
		(v) = ((v & MAC_VLANHTR_VLHT_Wr_Mask) | ((data & MAC_VLANHTR_VLHT_Mask)<<0));\
		MAC_VLANHTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANHTR_VLHT_UdfRd(pdata, data) do {\
		MAC_VLANHTR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_VLANHTR_VLHT_Mask);\
} while(0)


#define MAC_VLANTR_RgOffAddr ((BASE_ADDRESS + 0x50))

#define MAC_VLANTR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_VLANTR_RgOffAddr));\
} while(0)

#define MAC_VLANTR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_VLANTR_RgOffAddr));\
} while(0)

/*#define  MAC_VLANTR_Mask_30 (ULONG)(~(~0<<(1)))*/

#define  MAC_VLANTR_Mask_30 (ULONG)(0x1)

/*#define MAC_VLANTR_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(1)))<<(30)))*/

#define MAC_VLANTR_RES_Wr_Mask_30 (ULONG)(0xbfffffff)

/*#define  MAC_VLANTR_Mask_23 (ULONG)(~(~0<<(1)))*/

#define  MAC_VLANTR_Mask_23 (ULONG)(0x1)

/*#define MAC_VLANTR_RES_Wr_Mask_23 (ULONG)(~((~(~0<<(1)))<<(23)))*/

#define MAC_VLANTR_RES_Wr_Mask_23 (ULONG)(0xff7fffff)

/*#define MAC_VLANTR_EIVLRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EIVLRXS_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_EIVLRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define MAC_VLANTR_EIVLRXS_Wr_Mask (ULONG)(0x7fffffff)

#define MAC_VLANTR_EIVLRXS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_EIVLRXS_Wr_Mask) | ((data & MAC_VLANTR_EIVLRXS_Mask)<<31));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_EIVLRXS_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 31) & MAC_VLANTR_EIVLRXS_Mask);\
} while(0)

/*#define MAC_VLANTR_EIVLS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTR_EIVLS_Mask (ULONG)(0x3)

/*#define MAC_VLANTR_EIVLS_Wr_Mask (ULONG)(~((~(~0 << (2))) << (28)))*/

#define MAC_VLANTR_EIVLS_Wr_Mask (ULONG)(0xcfffffff)

#define MAC_VLANTR_EIVLS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_EIVLS_Wr_Mask) | ((data & MAC_VLANTR_EIVLS_Mask)<<28));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_EIVLS_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 28) & MAC_VLANTR_EIVLS_Mask);\
} while(0)

/*#define MAC_VLANTR_ERIVLT_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ERIVLT_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_ERIVLT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define MAC_VLANTR_ERIVLT_Wr_Mask (ULONG)(0xf7ffffff)

#define MAC_VLANTR_ERIVLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_ERIVLT_Wr_Mask) | ((data & MAC_VLANTR_ERIVLT_Mask)<<27));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_ERIVLT_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 27) & MAC_VLANTR_ERIVLT_Mask);\
} while(0)

/*#define MAC_VLANTR_EDVLP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EDVLP_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_EDVLP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define MAC_VLANTR_EDVLP_Wr_Mask (ULONG)(0xfbffffff)

#define MAC_VLANTR_EDVLP_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_EDVLP_Wr_Mask) | ((data & MAC_VLANTR_EDVLP_Mask)<<26));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_EDVLP_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 26) & MAC_VLANTR_EDVLP_Mask);\
} while(0)

/*#define MAC_VLANTR_VTHM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_VTHM_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_VTHM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define MAC_VLANTR_VTHM_Wr_Mask (ULONG)(0xfdffffff)

#define MAC_VLANTR_VTHM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_VTHM_Wr_Mask) | ((data & MAC_VLANTR_VTHM_Mask)<<25));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_VTHM_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 25) & MAC_VLANTR_VTHM_Mask);\
} while(0)

/*#define MAC_VLANTR_EVLRXS_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_EVLRXS_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_EVLRXS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MAC_VLANTR_EVLRXS_Wr_Mask (ULONG)(0xfeffffff)

#define MAC_VLANTR_EVLRXS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_EVLRXS_Wr_Mask) | ((data & MAC_VLANTR_EVLRXS_Mask)<<24));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_EVLRXS_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_VLANTR_EVLRXS_Mask);\
} while(0)

/*#define MAC_VLANTR_EVLS_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_VLANTR_EVLS_Mask (ULONG)(0x3)

/*#define MAC_VLANTR_EVLS_Wr_Mask (ULONG)(~((~(~0 << (2))) << (21)))*/

#define MAC_VLANTR_EVLS_Wr_Mask (ULONG)(0xff9fffff)

#define MAC_VLANTR_EVLS_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_EVLS_Wr_Mask) | ((data & MAC_VLANTR_EVLS_Mask)<<21));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_EVLS_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 21) & MAC_VLANTR_EVLS_Mask);\
} while(0)

/*#define MAC_VLANTR_DOVLTC_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_DOVLTC_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_DOVLTC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MAC_VLANTR_DOVLTC_Wr_Mask (ULONG)(0xffefffff)

#define MAC_VLANTR_DOVLTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_DOVLTC_Wr_Mask) | ((data & MAC_VLANTR_DOVLTC_Mask)<<20));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_DOVLTC_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 20) & MAC_VLANTR_DOVLTC_Mask);\
} while(0)

/*#define MAC_VLANTR_ERSVLM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ERSVLM_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_ERSVLM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (19)))*/

#define MAC_VLANTR_ERSVLM_Wr_Mask (ULONG)(0xfff7ffff)

#define MAC_VLANTR_ERSVLM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_ERSVLM_Wr_Mask) | ((data & MAC_VLANTR_ERSVLM_Mask)<<19));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_ERSVLM_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 19) & MAC_VLANTR_ERSVLM_Mask);\
} while(0)

/*#define MAC_VLANTR_ESVL_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ESVL_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_ESVL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (18)))*/

#define MAC_VLANTR_ESVL_Wr_Mask (ULONG)(0xfffbffff)

#define MAC_VLANTR_ESVL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_ESVL_Wr_Mask) | ((data & MAC_VLANTR_ESVL_Mask)<<18));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_ESVL_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 18) & MAC_VLANTR_ESVL_Mask);\
} while(0)

/*#define MAC_VLANTR_VTIM_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_VTIM_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_VTIM_Wr_Mask (ULONG)(~((~(~0 << (1))) << (17)))*/

#define MAC_VLANTR_VTIM_Wr_Mask (ULONG)(0xfffdffff)

#define MAC_VLANTR_VTIM_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_VTIM_Wr_Mask) | ((data & MAC_VLANTR_VTIM_Mask)<<17));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_VTIM_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 17) & MAC_VLANTR_VTIM_Mask);\
} while(0)

/*#define MAC_VLANTR_ETV_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_VLANTR_ETV_Mask (ULONG)(0x1)

/*#define MAC_VLANTR_ETV_Wr_Mask (ULONG)(~((~(~0 << (1))) << (16)))*/

#define MAC_VLANTR_ETV_Wr_Mask (ULONG)(0xfffeffff)

#define MAC_VLANTR_ETV_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_ETV_Wr_Mask) | ((data & MAC_VLANTR_ETV_Mask)<<16));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_ETV_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_VLANTR_ETV_Mask);\
} while(0)

/*#define MAC_VLANTR_VL_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_VLANTR_VL_Mask (ULONG)(0xffff)

/*#define MAC_VLANTR_VL_Wr_Mask (ULONG)(~((~(~0 << (16))) << (0)))*/

#define MAC_VLANTR_VL_Wr_Mask (ULONG)(0xffff0000)

#define MAC_VLANTR_VL_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_VLANTR_RgRd(pdata, v);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_30))|((( 0) & (MAC_VLANTR_Mask_30))<<30);\
		v = (v & (MAC_VLANTR_RES_Wr_Mask_23))|((( 0) & (MAC_VLANTR_Mask_23))<<23);\
		v = ((v & MAC_VLANTR_VL_Wr_Mask) | ((data & MAC_VLANTR_VL_Mask)<<0));\
		MAC_VLANTR_RgWr(pdata, v);\
} while(0)

#define MAC_VLANTR_VL_UdfRd(pdata, data) do {\
		MAC_VLANTR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_VLANTR_VL_Mask);\
} while(0)


#define DMA_SBUS_RgOffAddr ((BASE_ADDRESS + 0x1004))

#define DMA_SBUS_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_SBUS_RgOffAddr));\
} while(0)

#define DMA_SBUS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_SBUS_RgOffAddr));\
} while(0)

/*#define  DMA_SBUS_Mask_25 (ULONG)(~(~0<<(5)))*/

#define  DMA_SBUS_Mask_27 (ULONG)(0x7)

/*#define DMA_SBUS_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(5)))<<(25)))*/

#define DMA_SBUS_RES_Wr_Mask_27 (ULONG)(0xc7ffffff)

/*#define  DMA_SBUS_Mask_20 (ULONG)(~(~0<<(1)))*/

#define  DMA_SBUS_Mask_20 (ULONG)(0x1)

/*#define DMA_SBUS_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(1)))<<(20)))*/

#define DMA_SBUS_RES_Wr_Mask_20 (ULONG)(0xffefffff)

/*#define  DMA_SBUS_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_SBUS_Mask_15 (ULONG)(0x1)

/*#define DMA_SBUS_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_SBUS_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_SBUS_Mask_8 (ULONG)(~(~0<<(4)))*/

#define  DMA_SBUS_Mask_8 (ULONG)(0x3)

/*#define DMA_SBUS_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(4)))<<(8)))*/

#define DMA_SBUS_RES_Wr_Mask_8 (ULONG)(0xfffffcff)

/*#define DMA_SBUS_EN_LPI_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_EN_LPI_Mask (ULONG)(0x1)

/*#define DMA_SBUS_EN_LPI_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define DMA_SBUS_EN_LPI_Wr_Mask (ULONG)(0x7fffffff)

#define DMA_SBUS_EN_LPI_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_EN_LPI_Wr_Mask) | ((data & DMA_SBUS_EN_LPI_Mask)<<31));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_EN_LPI_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 31) & DMA_SBUS_EN_LPI_Mask);\
} while(0)

/*#define DMA_SBUS_LPI_XIT_PKT_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_LPI_XIT_PKT_Mask (ULONG)(0x1)

/*#define DMA_SBUS_LPI_XIT_PKT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (30)))*/

#define DMA_SBUS_LPI_XIT_PKT_Wr_Mask (ULONG)(0xbfffffff)

#define DMA_SBUS_LPI_XIT_PKT_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_LPI_XIT_PKT_Wr_Mask) | ((data & DMA_SBUS_LPI_XIT_PKT_Mask)<<30));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_LPI_XIT_PKT_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 30) & DMA_SBUS_LPI_XIT_PKT_Mask);\
} while(0)

/*#define DMA_SBUS_WR_OSR_LMT_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_SBUS_WR_OSR_LMT_Mask (ULONG)(0x3f)

/*#define DMA_SBUS_WR_OSR_LMT_Wr_Mask (ULONG)(~((~(~0 << (6))) << (24)))*/

#define DMA_SBUS_WR_OSR_LMT_Wr_Mask (ULONG)(0xc0ffffff)

#define DMA_SBUS_WR_OSR_LMT_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_WR_OSR_LMT_Wr_Mask) | ((data & DMA_SBUS_WR_OSR_LMT_Mask)<<24));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_WR_OSR_LMT_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 24) & DMA_SBUS_WR_OSR_LMT_Mask);\
} while(0)

/*#define DMA_SBUS_RD_OSR_LMT_Mask (ULONG)(~(~0<<(8)))*/

#define DMA_SBUS_RD_OSR_LMT_Mask (ULONG)(0xff)

/*#define DMA_SBUS_RD_OSR_LMT_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define DMA_SBUS_RD_OSR_LMT_Wr_Mask (ULONG)(0xff00ffff)

#define DMA_SBUS_RD_OSR_LMT_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_RD_OSR_LMT_Wr_Mask) | ((data & DMA_SBUS_RD_OSR_LMT_Mask)<<16));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_RD_OSR_LMT_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_SBUS_RD_OSR_LMT_Mask);\
} while(0)

/*#define DMA_SBUS_MB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_MB_Mask (ULONG)(0x1)

/*#define DMA_SBUS_MB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define DMA_SBUS_MB_Wr_Mask (ULONG)(0xffffbfff)

#define DMA_SBUS_MB_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_MB_Wr_Mask) | ((data & DMA_SBUS_MB_Mask)<<14));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_MB_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 14) & DMA_SBUS_MB_Mask);\
} while(0)

/*#define DMA_SBUS_ONEKBBE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_ONEKBBE_Mask (ULONG)(0x1)

/*#define DMA_SBUS_ONEKBBE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (13)))*/

#define DMA_SBUS_ONEKBBE_Wr_Mask (ULONG)(0xffffdfff)

#define DMA_SBUS_ONEKBBE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_ONEKBBE_Wr_Mask) | ((data & DMA_SBUS_ONEKBBE_Mask)<<13));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_ONEKBBE_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 13) & DMA_SBUS_ONEKBBE_Mask);\
} while(0)

/*#define DMA_SBUS_AAL_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_AAL_Mask (ULONG)(0x1)

/*#define DMA_SBUS_AAL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_SBUS_AAL_Wr_Mask (ULONG)(0xffffefff)

#define DMA_SBUS_AAL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_AAL_Wr_Mask) | ((data & DMA_SBUS_AAL_Mask)<<12));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_AAL_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_SBUS_AAL_Mask);\
} while(0)

/*#define DMA_SBUS_EAME_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_EAME_Mask (ULONG)(0x1)

/*#define DMA_SBUS_EAME_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define DMA_SBUS_EAME_Wr_Mask (ULONG)(0xfffff7ff)

#define DMA_SBUS_EAME_UdfWr(pdata, data) do {\
               ULONG v;\
               DMA_SBUS_RgRd(pdata, v);\
               v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
               v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
               v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
               v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
               v = ((v & DMA_SBUS_EAME_Wr_Mask) | ((data & DMA_SBUS_EAME_Mask)<<11));\
               DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_EAME_UdfRd(pdata, data) do {\
               DMA_SBUS_RgRd(pdata, data);\
               data = ((data >> 11) & DMA_SBUS_EAME_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN256_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN256_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN256_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define DMA_SBUS_BLEN256_Wr_Mask (ULONG)(0xffffff7f)

#define DMA_SBUS_BLEN256_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN256_Wr_Mask) | ((data & DMA_SBUS_BLEN256_Mask)<<7));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN256_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 7) & DMA_SBUS_BLEN256_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN128_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN128_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN128_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define DMA_SBUS_BLEN128_Wr_Mask (ULONG)(0xffffffbf)

#define DMA_SBUS_BLEN128_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN128_Wr_Mask) | ((data & DMA_SBUS_BLEN128_Mask)<<6));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN128_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 6) & DMA_SBUS_BLEN128_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN64_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN64_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN64_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define DMA_SBUS_BLEN64_Wr_Mask (ULONG)(0xffffffdf)

#define DMA_SBUS_BLEN64_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN64_Wr_Mask) | ((data & DMA_SBUS_BLEN64_Mask)<<5));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN64_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 5) & DMA_SBUS_BLEN64_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN32_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN32_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN32_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_SBUS_BLEN32_Wr_Mask (ULONG)(0xffffffef)

#define DMA_SBUS_BLEN32_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN32_Wr_Mask) | ((data & DMA_SBUS_BLEN32_Mask)<<4));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN32_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_SBUS_BLEN32_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN16_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN16_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN16_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define DMA_SBUS_BLEN16_Wr_Mask (ULONG)(0xfffffff7)

#define DMA_SBUS_BLEN16_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN16_Wr_Mask) | ((data & DMA_SBUS_BLEN16_Mask)<<3));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN16_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 3) & DMA_SBUS_BLEN16_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN8_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN8_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN8_Wr_Mask (ULONG)(~((~(~0 << (1))) << (2)))*/

#define DMA_SBUS_BLEN8_Wr_Mask (ULONG)(0xfffffffb)

#define DMA_SBUS_BLEN8_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN8_Wr_Mask) | ((data & DMA_SBUS_BLEN8_Mask)<<2));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN8_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 2) & DMA_SBUS_BLEN8_Mask);\
} while(0)

/*#define DMA_SBUS_BLEN4_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_BLEN4_Mask (ULONG)(0x1)

/*#define DMA_SBUS_BLEN4_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_SBUS_BLEN4_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_SBUS_BLEN4_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_BLEN4_Wr_Mask) | ((data & DMA_SBUS_BLEN4_Mask)<<1));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_BLEN4_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_SBUS_BLEN4_Mask);\
} while(0)

/*#define DMA_SBUS_UNDEF_FB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_SBUS_UNDEF_FB_Mask (ULONG)(0x1)

/*#define DMA_SBUS_UNDEF_FB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_SBUS_UNDEF_FB_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_SBUS_UNDEF_FB_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_SBUS_RgRd(pdata, v);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_27))|((( 0) & (DMA_SBUS_Mask_27))<<27);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_20))|((( 0) & (DMA_SBUS_Mask_20))<<20);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_15))|((( 0) & (DMA_SBUS_Mask_15))<<15);\
		v = (v & (DMA_SBUS_RES_Wr_Mask_8))|((( 0) & (DMA_SBUS_Mask_8))<<8);\
		v = ((v & DMA_SBUS_UNDEF_FB_Wr_Mask) | ((data & DMA_SBUS_UNDEF_FB_Mask)<<0));\
		DMA_SBUS_RgWr(pdata, v);\
} while(0)

#define DMA_SBUS_UNDEF_FB_UdfRd(pdata, data) do {\
		DMA_SBUS_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_SBUS_UNDEF_FB_Mask);\
} while(0)


#define DMA_BMR_RgOffAddr ((BASE_ADDRESS + 0x1000))

#define DMA_BMR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_BMR_RgOffAddr));\
} while(0)

#define DMA_BMR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_BMR_RgOffAddr));\
} while(0)

/*#define  DMA_BMR_Mask_15 (ULONG)(~(~0<<(16)))*/

#define  DMA_BMR_Mask_15 (ULONG)(0xffff)

/*#define DMA_BMR_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(16)))<<(15)))*/

#define DMA_BMR_RES_Wr_Mask_15 (ULONG)(0x80007fff)

/*#define  DMA_BMR_Mask_6 (ULONG)(~(~0<<(5)))*/

#define  DMA_BMR_Mask_6 (ULONG)(0x1f)

/*#define DMA_BMR_RES_Wr_Mask_6 (ULONG)(~((~(~0<<(5)))<<(6)))*/

#define DMA_BMR_RES_Wr_Mask_6 (ULONG)(0xfffff83f)

/*#define DMA_BMR_RIB_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_RIB_Mask (ULONG)(0x1)

/*#define DMA_BMR_RIB_Wr_Mask (ULONG)(~((~(~0 << (1))) << (31)))*/

#define DMA_BMR_RIB_Wr_Mask (ULONG)(0x7fffffff)

#define DMA_BMR_Mask_2 (ULONG)(0x3)

#define DMA_BMR_INTM_Mask (ULONG)(0xfffcffff)

#define DMA_BMR_INTM_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = ((v & DMA_BMR_INTM_Mask) | ((data & DMA_BMR_Mask_2)<<16));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_RIB_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_RIB_Wr_Mask) | ((data & DMA_BMR_RIB_Mask)<<31));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_RIB_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 31) & DMA_BMR_RIB_Mask);\
} while(0)

/*#define DMA_BMR_PR_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_BMR_PR_Mask (ULONG)(0x7)

/*#define DMA_BMR_PR_Wr_Mask (ULONG)(~((~(~0 << (3))) << (12)))*/

#define DMA_BMR_PR_Wr_Mask (ULONG)(0xffff8fff)

#define DMA_BMR_PR_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_PR_Wr_Mask) | ((data & DMA_BMR_PR_Mask)<<12));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_PR_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_BMR_PR_Mask);\
} while(0)

/*#define DMA_BMR_TXPR_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_TXPR_Mask (ULONG)(0x1)

/*#define DMA_BMR_TXPR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define DMA_BMR_TXPR_Wr_Mask (ULONG)(0xfffff7ff)

#define DMA_BMR_TXPR_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_TXPR_Wr_Mask) | ((data & DMA_BMR_TXPR_Mask)<<11));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_TXPR_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 11) & DMA_BMR_TXPR_Mask);\
} while(0)

/*#define DMA_BMR_DTXSTS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_DTXSTS_Mask (ULONG)(0x1)

/*#define DMA_BMR_DTXSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define DMA_BMR_DTXSTS_Wr_Mask (ULONG)(0xffffffdf)

#define DMA_BMR_DTXSTS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_DTXSTS_Wr_Mask) | ((data & DMA_BMR_DTXSTS_Mask)<<5));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_DTXSTS_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 5) & DMA_BMR_DTXSTS_Mask);\
} while(0)

/*#define DMA_BMR_TAA_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_BMR_TAA_Mask (ULONG)(0x7)

/*#define DMA_BMR_TAA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (2)))*/

#define DMA_BMR_TAA_Wr_Mask (ULONG)(0xffffffe3)

#define DMA_BMR_TAA_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_TAA_Wr_Mask) | ((data & DMA_BMR_TAA_Mask)<<2));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_TAA_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 2) & DMA_BMR_TAA_Mask);\
} while(0)

/*#define DMA_BMR_DA_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_DA_Mask (ULONG)(0x1)

/*#define DMA_BMR_DA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define DMA_BMR_DA_Wr_Mask (ULONG)(0xfffffffd)

#define DMA_BMR_DA_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_DA_Wr_Mask) | ((data & DMA_BMR_DA_Mask)<<1));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_DA_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_BMR_DA_Mask);\
} while(0)

/*#define DMA_BMR_SWR_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_BMR_SWR_Mask (ULONG)(0x1)

/*#define DMA_BMR_SWR_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_BMR_SWR_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_BMR_SWR_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_BMR_RgRd(pdata, v);\
		v = (v & (DMA_BMR_RES_Wr_Mask_15))|((( 0) & (DMA_BMR_Mask_15))<<15);\
		v = (v & (DMA_BMR_RES_Wr_Mask_6))|((( 0) & (DMA_BMR_Mask_6))<<6);\
		v = ((v & DMA_BMR_SWR_Wr_Mask) | ((data & DMA_BMR_SWR_Mask)<<0));\
		DMA_BMR_RgWr(pdata, v);\
} while(0)

#define DMA_BMR_SWR_UdfRd(pdata, data) do {\
		DMA_BMR_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_BMR_SWR_Mask);\
} while(0)


#define MTL_Q0RCR_RgOffAddr ((BASE_ADDRESS + 0xd3c))

#define MTL_Q0RCR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0RCR_RgOffAddr));\
} while(0)

#define MTL_Q0RCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0RCR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0RCR_Mask_4 (ULONG)(~(~0<<(28)))*/

#define  MTL_Q0RCR_Mask_4 (ULONG)(0xfffffff)

/*#define MTL_Q0RCR_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(28)))<<(4)))*/

#define MTL_Q0RCR_RES_Wr_Mask_4 (ULONG)(0xf)

/*#define MTL_Q0RCR_RXQ_PKT_ARBIT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0RCR_RXQ_PKT_ARBIT_Mask (ULONG)(0x1)

/*#define MTL_Q0RCR_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_Q0RCR_RXQ_PKT_ARBIT_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_Q0RCR_RXQ_PKT_ARBIT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0RCR_RgRd(pdata, v);\
		v = (v & (MTL_Q0RCR_RES_Wr_Mask_4))|((( 0) & (MTL_Q0RCR_Mask_4))<<4);\
		v = ((v & MTL_Q0RCR_RXQ_PKT_ARBIT_Wr_Mask) | ((data & MTL_Q0RCR_RXQ_PKT_ARBIT_Mask)<<3));\
		MTL_Q0RCR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0RCR_RXQ_PKT_ARBIT_UdfRd(pdata, data) do {\
		MTL_Q0RCR_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_Q0RCR_RXQ_PKT_ARBIT_Mask);\
} while(0)

/*#define MTL_Q0RCR_RQW_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0RCR_RQW_Mask (ULONG)(0x7)

/*#define MTL_Q0RCR_RQW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_Q0RCR_RQW_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_Q0RCR_RQW_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0RCR_RgRd(pdata, v);\
		v = (v & (MTL_Q0RCR_RES_Wr_Mask_4))|((( 0) & (MTL_Q0RCR_Mask_4))<<4);\
		v = ((v & MTL_Q0RCR_RQW_Wr_Mask) | ((data & MTL_Q0RCR_RQW_Mask)<<0));\
		MTL_Q0RCR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0RCR_RQW_UdfRd(pdata, data) do {\
		MTL_Q0RCR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0RCR_RQW_Mask);\
} while(0)


#define MTL_Q0OCR_RgOffAddr ((BASE_ADDRESS + 0xd34))

#define MTL_Q0OCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0OCR_RgOffAddr));\
} while(0)

/*#define MTL_Q0OCR_MISCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0OCR_MISCNTOVF_Mask (ULONG)(0x1)

#define MTL_Q0OCR_MISCNTOVF_UdfRd(pdata, data) do {\
		MTL_Q0OCR_RgRd(pdata, data);\
		data = ((data >> 27) & MTL_Q0OCR_MISCNTOVF_Mask);\
} while(0)

/*#define MTL_Q0OCR_MISPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0OCR_MISPKTCNT_Mask (ULONG)(0x7ff)

#define MTL_Q0OCR_MISPKTCNT_UdfRd(pdata, data) do {\
		MTL_Q0OCR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_Q0OCR_MISPKTCNT_Mask);\
} while(0)

/*#define MTL_Q0OCR_OVFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0OCR_OVFCNTOVF_Mask (ULONG)(0x1)

#define MTL_Q0OCR_OVFCNTOVF_UdfRd(pdata, data) do {\
		MTL_Q0OCR_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_Q0OCR_OVFCNTOVF_Mask);\
} while(0)

/*#define MTL_Q0OCR_OVFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0OCR_OVFPKTCNT_Mask (ULONG)(0x7ff)

#define MTL_Q0OCR_OVFPKTCNT_UdfRd(pdata, data) do {\
		MTL_Q0OCR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0OCR_OVFPKTCNT_Mask);\
} while(0)


#define MTL_Q0ROMR_RgOffAddr ((BASE_ADDRESS + 0xd30))

#define MTL_Q0ROMR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0ROMR_RgOffAddr));\
} while(0)

#define MTL_Q0ROMR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0ROMR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0ROMR_Mask_30 (ULONG)(~(~0<<(2)))*/

#define  MTL_Q0ROMR_Mask_30 (ULONG)(0x3)

/*#define MTL_Q0ROMR_RES_Wr_Mask_30 (ULONG)(~((~(~0<<(2)))<<(30)))*/

#define MTL_Q0ROMR_RES_Wr_Mask_30 (ULONG)(0x3fffffff)

/*#define  MTL_Q0ROMR_Mask_16 (ULONG)(~(~0<<(4)))*/

#define  MTL_Q0ROMR_Mask_16 (ULONG)(0xf)

/*#define MTL_Q0ROMR_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(4)))<<(16)))*/

#define MTL_Q0ROMR_RES_Wr_Mask_16 (ULONG)(0xfff0ffff)

/*#define  MTL_Q0ROMR_Mask_11 (ULONG)(~(~0<<(2)))*/

#define  MTL_Q0ROMR_Mask_11 (ULONG)(0x3)

/*#define MTL_Q0ROMR_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(2)))<<(11)))*/

#define MTL_Q0ROMR_RES_Wr_Mask_11 (ULONG)(0xffffe7ff)

/*#define  MTL_Q0ROMR_Mask_2 (ULONG)(~(~0<<(1)))*/

#define  MTL_Q0ROMR_Mask_2 (ULONG)(0x1)

/*#define MTL_Q0ROMR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(1)))<<(2)))*/

#define MTL_Q0ROMR_RES_Wr_Mask_2 (ULONG)(0xfffffffb)

/*#define MTL_Q0ROMR_RQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_Q0ROMR_RQS_Mask (ULONG)(0x3ff)

/*#define MTL_Q0ROMR_RQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (20)))*/

#define MTL_Q0ROMR_RQS_Wr_Mask (ULONG)(0xc00fffff)

#define MTL_Q0ROMR_RQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_RQS_Wr_Mask) | ((data & MTL_Q0ROMR_RQS_Mask)<<20));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_RQS_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_Q0ROMR_RQS_Mask);\
} while(0)

/*#define MTL_Q0ROMR_RFD_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0ROMR_RFD_Mask (ULONG)(0x7)

/*#define MTL_Q0ROMR_RFD_Wr_Mask (ULONG)(~((~(~0 << (3))) << (13)))*/

#define MTL_Q0ROMR_RFD_Wr_Mask (ULONG)(0xffff1fff)

#define MTL_Q0ROMR_RFD_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_RFD_Wr_Mask) | ((data & MTL_Q0ROMR_RFD_Mask)<<13));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_RFD_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 13) & MTL_Q0ROMR_RFD_Mask);\
} while(0)

/*#define MTL_Q0ROMR_RFA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0ROMR_RFA_Mask (ULONG)(0x7)

/*#define MTL_Q0ROMR_RFA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_Q0ROMR_RFA_Wr_Mask (ULONG)(0xfffff8ff)

#define MTL_Q0ROMR_RFA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_RFA_Wr_Mask) | ((data & MTL_Q0ROMR_RFA_Mask)<<8));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_RFA_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_Q0ROMR_RFA_Mask);\
} while(0)

/*#define MTL_Q0ROMR_EFC_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_EFC_Mask (ULONG)(0x1)

/*#define MTL_Q0ROMR_EFC_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MTL_Q0ROMR_EFC_Wr_Mask (ULONG)(0xffffff7f)

#define MTL_Q0ROMR_EFC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_EFC_Wr_Mask) | ((data & MTL_Q0ROMR_EFC_Mask)<<7));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_EFC_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 7) & MTL_Q0ROMR_EFC_Mask);\
} while(0)

/*#define MTL_Q0ROMR_DT_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_DT_Mask (ULONG)(0x1)

/*#define MTL_Q0ROMR_DT_Wr_Mask (ULONG)(~((~(~0 << (1))) << (6)))*/

#define MTL_Q0ROMR_DT_Wr_Mask (ULONG)(0xffffffbf)

#define MTL_Q0ROMR_DT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_DT_Wr_Mask) | ((data & MTL_Q0ROMR_DT_Mask)<<6));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_DT_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 6) & MTL_Q0ROMR_DT_Mask);\
} while(0)

/*#define MTL_Q0ROMR_RSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_RSF_Mask (ULONG)(0x1)

/*#define MTL_Q0ROMR_RSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (5)))*/

#define MTL_Q0ROMR_RSF_Wr_Mask (ULONG)(0xffffffdf)

#define MTL_Q0ROMR_RSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_RSF_Wr_Mask) | ((data & MTL_Q0ROMR_RSF_Mask)<<5));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_RSF_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_Q0ROMR_RSF_Mask);\
} while(0)

/*#define MTL_Q0ROMR_FEP_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_FEP_Mask (ULONG)(0x1)

/*#define MTL_Q0ROMR_FEP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_Q0ROMR_FEP_Wr_Mask (ULONG)(0xffffffef)

#define MTL_Q0ROMR_FEP_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_FEP_Wr_Mask) | ((data & MTL_Q0ROMR_FEP_Mask)<<4));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_FEP_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_Q0ROMR_FEP_Mask);\
} while(0)

/*#define MTL_Q0ROMR_FUP_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ROMR_FUP_Mask (ULONG)(0x1)

/*#define MTL_Q0ROMR_FUP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (3)))*/

#define MTL_Q0ROMR_FUP_Wr_Mask (ULONG)(0xfffffff7)

#define MTL_Q0ROMR_FUP_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_FUP_Wr_Mask) | ((data & MTL_Q0ROMR_FUP_Mask)<<3));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_FUP_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 3) & MTL_Q0ROMR_FUP_Mask);\
} while(0)

/*#define MTL_Q0ROMR_RTC_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0ROMR_RTC_Mask (ULONG)(0x3)

/*#define MTL_Q0ROMR_RTC_Wr_Mask (ULONG)(~((~(~0 << (2))) << (0)))*/

#define MTL_Q0ROMR_RTC_Wr_Mask (ULONG)(0xfffffffc)

#define MTL_Q0ROMR_RTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0ROMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_30))|((( 0) & (MTL_Q0ROMR_Mask_30))<<30);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_16))|((( 0) & (MTL_Q0ROMR_Mask_16))<<16);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_11))|((( 0) & (MTL_Q0ROMR_Mask_11))<<11);\
		v = (v & (MTL_Q0ROMR_RES_Wr_Mask_2))|((( 0) & (MTL_Q0ROMR_Mask_2))<<2);\
		v = ((v & MTL_Q0ROMR_RTC_Wr_Mask) | ((data & MTL_Q0ROMR_RTC_Mask)<<0));\
		MTL_Q0ROMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ROMR_RTC_UdfRd(pdata, data) do {\
		MTL_Q0ROMR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0ROMR_RTC_Mask);\
} while(0)


#define MTL_Q0QR_RgOffAddr ((BASE_ADDRESS + 0xd18))

#define MTL_Q0QR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0QR_RgOffAddr));\
} while(0)

#define MTL_Q0QR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0QR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0QR_Mask_21 (ULONG)(~(~0<<(11)))*/

#define  MTL_Q0QR_Mask_21 (ULONG)(0x7ff)

/*#define MTL_Q0QR_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(11)))<<(21)))*/

#define MTL_Q0QR_RES_Wr_Mask_21 (ULONG)(0x1fffff)

/*#define MTL_Q0QR_QW_Mask (ULONG)(~(~0<<(21)))*/

#define MTL_Q0QR_QW_Mask (ULONG)(0x1fffff)

/*#define MTL_Q0QR_QW_Wr_Mask (ULONG)(~((~(~0 << (21))) << (0)))*/

#define MTL_Q0QR_QW_Wr_Mask (ULONG)(0xffe00000)

#define MTL_Q0QR_QW_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_Q0QR_RES_Wr_Mask_21))|((( 0) & (MTL_Q0QR_Mask_21))<<21);\
		(v) = ((v & MTL_Q0QR_QW_Wr_Mask) | ((data & MTL_Q0QR_QW_Mask)<<0));\
		MTL_Q0QR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0QR_QW_UdfRd(pdata, data) do {\
		MTL_Q0QR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0QR_QW_Mask);\
} while(0)


#define MTL_Q0ECR_RgOffAddr ((BASE_ADDRESS + 0xd10))

#define MTL_Q0ECR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0ECR_RgOffAddr));\
} while(0)

#define MTL_Q0ECR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0ECR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0ECR_Mask_25 (ULONG)(~(~0<<(7)))*/

#define  MTL_Q0ECR_Mask_25 (ULONG)(0x7f)

/*#define MTL_Q0ECR_RES_Wr_Mask_25 (ULONG)(~((~(~0<<(7)))<<(25)))*/

#define MTL_Q0ECR_RES_Wr_Mask_25 (ULONG)(0x1ffffff)

/*#define  MTL_Q0ECR_Mask_0 (ULONG)(~(~0<<(24)))*/

#define  MTL_Q0ECR_Mask_0 (ULONG)(0xffffff)

/*#define MTL_Q0ECR_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(24)))<<(0)))*/

#define MTL_Q0ECR_RES_Wr_Mask_0 (ULONG)(0xff000000)

/*#define MTL_Q0ECR_ABPSSIE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0ECR_ABPSSIE_Mask (ULONG)(0x1)

/*#define MTL_Q0ECR_ABPSSIE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (24)))*/

#define MTL_Q0ECR_ABPSSIE_Wr_Mask (ULONG)(0xfeffffff)

#define MTL_Q0ECR_ABPSSIE_UdfWr(pdata, data) do {\
		ULONG v = 0; \
		v = (v & (MTL_Q0ECR_RES_Wr_Mask_25))|((( 0) & (MTL_Q0ECR_Mask_25))<<25);\
		v = (v & (MTL_Q0ECR_RES_Wr_Mask_0))|((( 0) & (MTL_Q0ECR_Mask_0))<<0);\
		(v) = ((v & MTL_Q0ECR_ABPSSIE_Wr_Mask) | ((data & MTL_Q0ECR_ABPSSIE_Mask)<<24));\
		MTL_Q0ECR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0ECR_ABPSSIE_UdfRd(pdata, data) do {\
		MTL_Q0ECR_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_Q0ECR_ABPSSIE_Mask);\
} while(0)


#define MTL_Q0UCR_RgOffAddr ((BASE_ADDRESS + 0xd04))

#define MTL_Q0UCR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0UCR_RgOffAddr));\
} while(0)

#define MTL_Q0UCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0UCR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0UCR_Mask_12 (ULONG)(~(~0<<(20)))*/

#define  MTL_Q0UCR_Mask_12 (ULONG)(0xfffff)

/*#define MTL_Q0UCR_RES_Wr_Mask_12 (ULONG)(~((~(~0<<(20)))<<(12)))*/

#define MTL_Q0UCR_RES_Wr_Mask_12 (ULONG)(0xfff)

/*#define MTL_Q0UCR_UFCNTOVF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0UCR_UFCNTOVF_Mask (ULONG)(0x1)

#define MTL_Q0UCR_UFCNTOVF_UdfRd(pdata, data) do {\
		MTL_Q0UCR_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_Q0UCR_UFCNTOVF_Mask);\
} while(0)

/*#define MTL_Q0UCR_UFPKTCNT_Mask (ULONG)(~(~0<<(11)))*/

#define MTL_Q0UCR_UFPKTCNT_Mask (ULONG)(0x7ff)

/*#define MTL_Q0UCR_UFPKTCNT_Wr_Mask (ULONG)(~((~(~0 << (11))) << (0)))*/

#define MTL_Q0UCR_UFPKTCNT_Wr_Mask (ULONG)(0xfffff800)

#define MTL_Q0UCR_UFPKTCNT_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0UCR_RgRd(pdata, v);\
		v = (v & (MTL_Q0UCR_RES_Wr_Mask_12))|((( 0) & (MTL_Q0UCR_Mask_12))<<12);\
		v = ((v & MTL_Q0UCR_UFPKTCNT_Wr_Mask) | ((data & MTL_Q0UCR_UFPKTCNT_Mask)<<0));\
		MTL_Q0UCR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0UCR_UFPKTCNT_UdfRd(pdata, data) do {\
		MTL_Q0UCR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0UCR_UFPKTCNT_Mask);\
} while(0)


#define MTL_Q0TOMR_RgOffAddr ((BASE_ADDRESS + 0xd00))

#define MTL_Q0TOMR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_Q0TOMR_RgOffAddr));\
} while(0)

#define MTL_Q0TOMR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_Q0TOMR_RgOffAddr));\
} while(0)

/*#define  MTL_Q0TOMR_Mask_26 (ULONG)(~(~0<<(6)))*/

#define  MTL_Q0TOMR_Mask_26 (ULONG)(0x3f)

/*#define MTL_Q0TOMR_RES_Wr_Mask_26 (ULONG)(~((~(~0<<(6)))<<(26)))*/

#define MTL_Q0TOMR_RES_Wr_Mask_26 (ULONG)(0x3ffffff)

/*#define  MTL_Q0TOMR_Mask_7 (ULONG)(~(~0<<(9)))*/

#define  MTL_Q0TOMR_Mask_7 (ULONG)(0x1ff)

/*#define MTL_Q0TOMR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(9)))<<(7)))*/

#define MTL_Q0TOMR_RES_Wr_Mask_7 (ULONG)(0xffff007f)

/*#define MTL_Q0TOMR_TQS_Mask (ULONG)(~(~0<<(10)))*/

#define MTL_Q0TOMR_TQS_Mask (ULONG)(0x3ff)

/*#define MTL_Q0TOMR_TQS_Wr_Mask (ULONG)(~((~(~0 << (10))) << (16)))*/

#define MTL_Q0TOMR_TQS_Wr_Mask (ULONG)(0xfc00ffff)

#define MTL_Q0TOMR_TQS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0TOMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_26))|((( 0) & (MTL_Q0TOMR_Mask_26))<<26);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_7))|((( 0) & (MTL_Q0TOMR_Mask_7))<<7);\
		v = ((v & MTL_Q0TOMR_TQS_Wr_Mask) | ((data & MTL_Q0TOMR_TQS_Mask)<<16));\
		MTL_Q0TOMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0TOMR_TQS_UdfRd(pdata, data) do {\
		MTL_Q0TOMR_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_Q0TOMR_TQS_Mask);\
} while(0)

/*#define MTL_Q0TOMR_TTC_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_Q0TOMR_TTC_Mask (ULONG)(0x7)

/*#define MTL_Q0TOMR_TTC_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MTL_Q0TOMR_TTC_Wr_Mask (ULONG)(0xffffff8f)

#define MTL_Q0TOMR_TTC_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0TOMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_26))|((( 0) & (MTL_Q0TOMR_Mask_26))<<26);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_7))|((( 0) & (MTL_Q0TOMR_Mask_7))<<7);\
		v = ((v & MTL_Q0TOMR_TTC_Wr_Mask) | ((data & MTL_Q0TOMR_TTC_Mask)<<4));\
		MTL_Q0TOMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0TOMR_TTC_UdfRd(pdata, data) do {\
		MTL_Q0TOMR_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_Q0TOMR_TTC_Mask);\
} while(0)

/*#define MTL_Q0TOMR_TXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_Q0TOMR_TXQEN_Mask (ULONG)(0x3)

/*#define MTL_Q0TOMR_TXQEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_Q0TOMR_TXQEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_Q0TOMR_TXQEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0TOMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_26))|((( 0) & (MTL_Q0TOMR_Mask_26))<<26);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_7))|((( 0) & (MTL_Q0TOMR_Mask_7))<<7);\
		v = ((v & MTL_Q0TOMR_TXQEN_Wr_Mask) | ((data & MTL_Q0TOMR_TXQEN_Mask)<<2));\
		MTL_Q0TOMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0TOMR_TXQEN_UdfRd(pdata, data) do {\
		MTL_Q0TOMR_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_Q0TOMR_TXQEN_Mask);\
} while(0)

/*#define MTL_Q0TOMR_TSF_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TOMR_TSF_Mask (ULONG)(0x1)

/*#define MTL_Q0TOMR_TSF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_Q0TOMR_TSF_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_Q0TOMR_TSF_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0TOMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_26))|((( 0) & (MTL_Q0TOMR_Mask_26))<<26);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_7))|((( 0) & (MTL_Q0TOMR_Mask_7))<<7);\
		v = ((v & MTL_Q0TOMR_TSF_Wr_Mask) | ((data & MTL_Q0TOMR_TSF_Mask)<<1));\
		MTL_Q0TOMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0TOMR_TSF_UdfRd(pdata, data) do {\
		MTL_Q0TOMR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_Q0TOMR_TSF_Mask);\
} while(0)

/*#define MTL_Q0TOMR_FTQ_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_Q0TOMR_FTQ_Mask (ULONG)(0x1)

/*#define MTL_Q0TOMR_FTQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_Q0TOMR_FTQ_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_Q0TOMR_FTQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_Q0TOMR_RgRd(pdata, v);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_26))|((( 0) & (MTL_Q0TOMR_Mask_26))<<26);\
		v = (v & (MTL_Q0TOMR_RES_Wr_Mask_7))|((( 0) & (MTL_Q0TOMR_Mask_7))<<7);\
		v = ((v & MTL_Q0TOMR_FTQ_Wr_Mask) | ((data & MTL_Q0TOMR_FTQ_Mask)<<0));\
		MTL_Q0TOMR_RgWr(pdata, v);\
} while(0)

#define MTL_Q0TOMR_FTQ_UdfRd(pdata, data) do {\
		MTL_Q0TOMR_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_Q0TOMR_FTQ_Mask);\
} while(0)


#define MTL_RQDCM1R_RgOffAddr ((BASE_ADDRESS + 0xc34))

#define MTL_RQDCM1R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_RQDCM1R_RgOffAddr));\
} while(0)

#define MTL_RQDCM1R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_RQDCM1R_RgOffAddr));\
} while(0)

/*#define  MTL_RQDCM1R_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_Mask_29 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define  MTL_RQDCM1R_Mask_27 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_Mask_27 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(1)))<<(27)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_27 (ULONG)(0xf7ffffff)

/*#define  MTL_RQDCM1R_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_Mask_21 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_21 (ULONG)(0xff1fffff)

/*#define  MTL_RQDCM1R_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_Mask_19 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_19 (ULONG)(0xfff7ffff)

/*#define  MTL_RQDCM1R_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_Mask_13 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  MTL_RQDCM1R_Mask_11 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_Mask_11 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(1)))<<(11)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_11 (ULONG)(0xfffff7ff)

/*#define  MTL_RQDCM1R_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM1R_Mask_5 (ULONG)(0x7)

/*#define MTL_RQDCM1R_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_5 (ULONG)(0xffffff1f)

/*#define  MTL_RQDCM1R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM1R_Mask_3 (ULONG)(0x1)

/*#define MTL_RQDCM1R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MTL_RQDCM1R_RES_Wr_Mask_3 (ULONG)(0xfffffff7)

/*#define MTL_RQDCM1R_RXQ7DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ7DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ7DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MTL_RQDCM1R_RXQ7DADMACH_Wr_Mask (ULONG)(0xefffffff)

#define MTL_RQDCM1R_RXQ7DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ7DADMACH_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ7DADMACH_Mask)<<28));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ7DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 28) & MTL_RQDCM1R_RXQ7DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ72DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ72DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ72DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MTL_RQDCM1R_RXQ72DMA_Wr_Mask (ULONG)(0xf8ffffff)

#define MTL_RQDCM1R_RXQ72DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ72DMA_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ72DMA_Mask)<<24));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ72DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_RQDCM1R_RXQ72DMA_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ6DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ6DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ6DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MTL_RQDCM1R_RXQ6DADMACH_Wr_Mask (ULONG)(0xffefffff)

#define MTL_RQDCM1R_RXQ6DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ6DADMACH_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ6DADMACH_Mask)<<20));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ6DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_RQDCM1R_RXQ6DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ26DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ26DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ26DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MTL_RQDCM1R_RXQ26DMA_Wr_Mask (ULONG)(0xfff8ffff)

#define MTL_RQDCM1R_RXQ26DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ26DMA_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ26DMA_Mask)<<16));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ26DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_RQDCM1R_RXQ26DMA_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ5DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ5DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ5DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_RQDCM1R_RXQ5DADMACH_Wr_Mask (ULONG)(0xffffefff)

#define MTL_RQDCM1R_RXQ5DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ5DADMACH_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ5DADMACH_Mask)<<12));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ5DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 12) & MTL_RQDCM1R_RXQ5DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ25DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ25DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ25DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_RQDCM1R_RXQ25DMA_Wr_Mask (ULONG)(0xfffff8ff)

#define MTL_RQDCM1R_RXQ25DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ25DMA_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ25DMA_Mask)<<8));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ25DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_RQDCM1R_RXQ25DMA_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ4DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM1R_RXQ4DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM1R_RXQ4DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_RQDCM1R_RXQ4DADMACH_Wr_Mask (ULONG)(0xffffffef)

#define MTL_RQDCM1R_RXQ4DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ4DADMACH_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ4DADMACH_Mask)<<4));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ4DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_RQDCM1R_RXQ4DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM1R_RXQ42DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM1R_RXQ42DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM1R_RXQ42DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_RQDCM1R_RXQ42DMA_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_RQDCM1R_RXQ42DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM1R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM1R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM1R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM1R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM1R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM1R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM1R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM1R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM1R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM1R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM1R_RXQ42DMA_Wr_Mask) | ((data & MTL_RQDCM1R_RXQ42DMA_Mask)<<0));\
		MTL_RQDCM1R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM1R_RXQ42DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM1R_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_RQDCM1R_RXQ42DMA_Mask);\
} while(0)


#define MTL_RQDCM0R_RgOffAddr ((BASE_ADDRESS + 0xc30))

#define MTL_RQDCM0R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_RQDCM0R_RgOffAddr));\
} while(0)

#define MTL_RQDCM0R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_RQDCM0R_RgOffAddr));\
} while(0)

/*#define  MTL_RQDCM0R_Mask_29 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_Mask_29 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_29 (ULONG)(~((~(~0<<(3)))<<(29)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_29 (ULONG)(0x1fffffff)

/*#define  MTL_RQDCM0R_Mask_27 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_Mask_27 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_27 (ULONG)(~((~(~0<<(1)))<<(27)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_27 (ULONG)(0xf7ffffff)

/*#define  MTL_RQDCM0R_Mask_21 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_Mask_21 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_21 (ULONG)(~((~(~0<<(3)))<<(21)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_21 (ULONG)(0xff1fffff)

/*#define  MTL_RQDCM0R_Mask_19 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_Mask_19 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_19 (ULONG)(~((~(~0<<(1)))<<(19)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_19 (ULONG)(0xfff7ffff)

/*#define  MTL_RQDCM0R_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_Mask_13 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  MTL_RQDCM0R_Mask_11 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_Mask_11 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(1)))<<(11)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_11 (ULONG)(0xfffff7ff)

/*#define  MTL_RQDCM0R_Mask_5 (ULONG)(~(~0<<(3)))*/

#define  MTL_RQDCM0R_Mask_5 (ULONG)(0x7)

/*#define MTL_RQDCM0R_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(3)))<<(5)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_5 (ULONG)(0xffffff1f)

/*#define  MTL_RQDCM0R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MTL_RQDCM0R_Mask_3 (ULONG)(0x1)

/*#define MTL_RQDCM0R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MTL_RQDCM0R_RES_Wr_Mask_3 (ULONG)(0xfffffff7)

/*#define MTL_RQDCM0R_RXQ3DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ3DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ3DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (28)))*/

#define MTL_RQDCM0R_RXQ3DADMACH_Wr_Mask (ULONG)(0xefffffff)

#define MTL_RQDCM0R_RXQ3DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ3DADMACH_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ3DADMACH_Mask)<<28));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ3DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 28) & MTL_RQDCM0R_RXQ3DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ32DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ32DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ32DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (24)))*/

#define MTL_RQDCM0R_RXQ32DMA_Wr_Mask (ULONG)(0xf8ffffff)

#define MTL_RQDCM0R_RXQ32DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ32DMA_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ32DMA_Mask)<<24));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ32DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 24) & MTL_RQDCM0R_RXQ32DMA_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ2DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ2DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ2DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (20)))*/

#define MTL_RQDCM0R_RXQ2DADMACH_Wr_Mask (ULONG)(0xffefffff)

#define MTL_RQDCM0R_RXQ2DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ2DADMACH_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ2DADMACH_Mask)<<20));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ2DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 20) & MTL_RQDCM0R_RXQ2DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ22DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ22DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ22DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (16)))*/

#define MTL_RQDCM0R_RXQ22DMA_Wr_Mask (ULONG)(0xfff8ffff)

#define MTL_RQDCM0R_RXQ22DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ22DMA_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ22DMA_Mask)<<16));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ22DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 16) & MTL_RQDCM0R_RXQ22DMA_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ1DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ1DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ1DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define MTL_RQDCM0R_RXQ1DADMACH_Wr_Mask (ULONG)(0xffffefff)

#define MTL_RQDCM0R_RXQ1DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ1DADMACH_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ1DADMACH_Mask)<<12));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ1DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 12) & MTL_RQDCM0R_RXQ1DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ12DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ12DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ12DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MTL_RQDCM0R_RXQ12DMA_Wr_Mask (ULONG)(0xfffff8ff)

#define MTL_RQDCM0R_RXQ12DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ12DMA_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ12DMA_Mask)<<8));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ12DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_RQDCM0R_RXQ12DMA_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ0DADMACH_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_RQDCM0R_RXQ0DADMACH_Mask (ULONG)(0x1)

/*#define MTL_RQDCM0R_RXQ0DADMACH_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define MTL_RQDCM0R_RXQ0DADMACH_Wr_Mask (ULONG)(0xffffffef)

#define MTL_RQDCM0R_RXQ0DADMACH_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ0DADMACH_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ0DADMACH_Mask)<<4));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ0DADMACH_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 4) & MTL_RQDCM0R_RXQ0DADMACH_Mask);\
} while(0)

/*#define MTL_RQDCM0R_RXQ02DMA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_RQDCM0R_RXQ02DMA_Mask (ULONG)(0x7)

/*#define MTL_RQDCM0R_RXQ02DMA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MTL_RQDCM0R_RXQ02DMA_Wr_Mask (ULONG)(0xfffffff8)

#define MTL_RQDCM0R_RXQ02DMA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_RQDCM0R_RgRd(pdata, v);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_29))|((( 0) & (MTL_RQDCM0R_Mask_29))<<29);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_27))|((( 0) & (MTL_RQDCM0R_Mask_27))<<27);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_21))|((( 0) & (MTL_RQDCM0R_Mask_21))<<21);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_19))|((( 0) & (MTL_RQDCM0R_Mask_19))<<19);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_13))|((( 0) & (MTL_RQDCM0R_Mask_13))<<13);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_11))|((( 0) & (MTL_RQDCM0R_Mask_11))<<11);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_5))|((( 0) & (MTL_RQDCM0R_Mask_5))<<5);\
		v = (v & (MTL_RQDCM0R_RES_Wr_Mask_3))|((( 0) & (MTL_RQDCM0R_Mask_3))<<3);\
		v = ((v & MTL_RQDCM0R_RXQ02DMA_Wr_Mask) | ((data & MTL_RQDCM0R_RXQ02DMA_Mask)<<0));\
		MTL_RQDCM0R_RgWr(pdata, v);\
} while(0)

#define MTL_RQDCM0R_RXQ02DMA_UdfRd(pdata, data) do {\
		MTL_RQDCM0R_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_RQDCM0R_RXQ02DMA_Mask);\
} while(0)


#define MTL_FDDR_RgOffAddr ((BASE_ADDRESS + 0xc10))

#define MTL_FDDR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_FDDR_RgOffAddr));\
} while(0)

#define MTL_FDDR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_FDDR_RgOffAddr));\
} while(0)

#define MTL_FDDR_FDBGDATA_UdfWr(pdata, data) do {\
		MTL_FDDR_RgWr(pdata, data);\
} while(0)

#define MTL_FDDR_FDBGDATA_UdfRd(pdata, data) do {\
		MTL_FDDR_RgRd(pdata, data);\
} while(0)


#define MTL_FDACS_RgOffAddr ((BASE_ADDRESS + 0xc08))

#define MTL_FDACS_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_FDACS_RgOffAddr));\
} while(0)

#define MTL_FDACS_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_FDACS_RgOffAddr));\
} while(0)

/*#define  MTL_FDACS_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MTL_FDACS_Mask_16 (ULONG)(0xffff)

/*#define MTL_FDACS_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MTL_FDACS_RES_Wr_Mask_16 (ULONG)(0xffff)

/*#define  MTL_FDACS_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MTL_FDACS_Mask_7 (ULONG)(0x1)

/*#define MTL_FDACS_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MTL_FDACS_RES_Wr_Mask_7 (ULONG)(0xffffff7f)

/*#define  MTL_FDACS_Mask_4 (ULONG)(~(~0<<(1)))*/

#define  MTL_FDACS_Mask_4 (ULONG)(0x1)

/*#define MTL_FDACS_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(1)))<<(4)))*/

#define MTL_FDACS_RES_Wr_Mask_4 (ULONG)(0xffffffef)

/*#define MTL_FDACS_STSE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_STSE_Mask (ULONG)(0x1)

/*#define MTL_FDACS_STSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (15)))*/

#define MTL_FDACS_STSE_Wr_Mask (ULONG)(0xffff7fff)

#define MTL_FDACS_STSE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_STSE_Wr_Mask) | ((data & MTL_FDACS_STSE_Mask)<<15));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_STSE_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 15) & MTL_FDACS_STSE_Mask);\
} while(0)

/*#define MTL_FDACS_PKTE_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_PKTE_Mask (ULONG)(0x1)

/*#define MTL_FDACS_PKTE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (14)))*/

#define MTL_FDACS_PKTE_Wr_Mask (ULONG)(0xffffbfff)

#define MTL_FDACS_PKTE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_PKTE_Wr_Mask) | ((data & MTL_FDACS_PKTE_Mask)<<14));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_PKTE_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 14) & MTL_FDACS_PKTE_Mask);\
} while(0)

/*#define MTL_FDACS_FIFOSEL_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_FIFOSEL_Mask (ULONG)(0x3)

/*#define MTL_FDACS_FIFOSEL_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MTL_FDACS_FIFOSEL_Wr_Mask (ULONG)(0xffffcfff)

#define MTL_FDACS_FIFOSEL_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_FIFOSEL_Wr_Mask) | ((data & MTL_FDACS_FIFOSEL_Mask)<<12));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_FIFOSEL_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 12) & MTL_FDACS_FIFOSEL_Mask);\
} while(0)

/*#define MTL_FDACS_FIFOWREN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FIFOWREN_Mask (ULONG)(0x1)

/*#define MTL_FDACS_FIFOWREN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (11)))*/

#define MTL_FDACS_FIFOWREN_Wr_Mask (ULONG)(0xfffff7ff)

#define MTL_FDACS_FIFOWREN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_FIFOWREN_Wr_Mask) | ((data & MTL_FDACS_FIFOWREN_Mask)<<11));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_FIFOWREN_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 11) & MTL_FDACS_FIFOWREN_Mask);\
} while(0)

/*#define MTL_FDACS_FIFORDEN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FIFORDEN_Mask (ULONG)(0x1)

/*#define MTL_FDACS_FIFORDEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (10)))*/

#define MTL_FDACS_FIFORDEN_Wr_Mask (ULONG)(0xfffffbff)

#define MTL_FDACS_FIFORDEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_FIFORDEN_Wr_Mask) | ((data & MTL_FDACS_FIFORDEN_Mask)<<10));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_FIFORDEN_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 10) & MTL_FDACS_FIFORDEN_Mask);\
} while(0)

/*#define MTL_FDACS_RSTSEL_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_RSTSEL_Mask (ULONG)(0x1)

/*#define MTL_FDACS_RSTSEL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (9)))*/

#define MTL_FDACS_RSTSEL_Wr_Mask (ULONG)(0xfffffdff)

#define MTL_FDACS_RSTSEL_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_RSTSEL_Wr_Mask) | ((data & MTL_FDACS_RSTSEL_Mask)<<9));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_RSTSEL_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 9) & MTL_FDACS_RSTSEL_Mask);\
} while(0)

/*#define MTL_FDACS_RSTALL_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_RSTALL_Mask (ULONG)(0x1)

/*#define MTL_FDACS_RSTALL_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MTL_FDACS_RSTALL_Wr_Mask (ULONG)(0xfffffeff)

#define MTL_FDACS_RSTALL_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_RSTALL_Wr_Mask) | ((data & MTL_FDACS_RSTALL_Mask)<<8));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_RSTALL_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 8) & MTL_FDACS_RSTALL_Mask);\
} while(0)

/*#define MTL_FDACS_PKTSTATE_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_PKTSTATE_Mask (ULONG)(0x3)

/*#define MTL_FDACS_PKTSTATE_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MTL_FDACS_PKTSTATE_Wr_Mask (ULONG)(0xffffff9f)

#define MTL_FDACS_PKTSTATE_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_PKTSTATE_Wr_Mask) | ((data & MTL_FDACS_PKTSTATE_Mask)<<5));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_PKTSTATE_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_FDACS_PKTSTATE_Mask);\
} while(0)

/*#define MTL_FDACS_BYTEEN_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_FDACS_BYTEEN_Mask (ULONG)(0x3)

/*#define MTL_FDACS_BYTEEN_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MTL_FDACS_BYTEEN_Wr_Mask (ULONG)(0xfffffff3)

#define MTL_FDACS_BYTEEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_BYTEEN_Wr_Mask) | ((data & MTL_FDACS_BYTEEN_Mask)<<2));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_BYTEEN_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_FDACS_BYTEEN_Mask);\
} while(0)

/*#define MTL_FDACS_DEGMOD_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_DEGMOD_Mask (ULONG)(0x1)

/*#define MTL_FDACS_DEGMOD_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_FDACS_DEGMOD_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_FDACS_DEGMOD_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_DEGMOD_Wr_Mask) | ((data & MTL_FDACS_DEGMOD_Mask)<<1));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_DEGMOD_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_FDACS_DEGMOD_Mask);\
} while(0)

/*#define MTL_FDACS_FDBGEN_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_FDACS_FDBGEN_Mask (ULONG)(0x1)

/*#define MTL_FDACS_FDBGEN_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MTL_FDACS_FDBGEN_Wr_Mask (ULONG)(0xfffffffe)

#define MTL_FDACS_FDBGEN_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_FDACS_RgRd(pdata, v);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_16))|((( 0) & (MTL_FDACS_Mask_16))<<16);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_7))|((( 0) & (MTL_FDACS_Mask_7))<<7);\
		v = (v & (MTL_FDACS_RES_Wr_Mask_4))|((( 0) & (MTL_FDACS_Mask_4))<<4);\
		v = ((v & MTL_FDACS_FDBGEN_Wr_Mask) | ((data & MTL_FDACS_FDBGEN_Mask)<<0));\
		MTL_FDACS_RgWr(pdata, v);\
} while(0)

#define MTL_FDACS_FDBGEN_UdfRd(pdata, data) do {\
		MTL_FDACS_RgRd(pdata, data);\
		data = ((data >> 0) & MTL_FDACS_FDBGEN_Mask);\
} while(0)


#define MTL_OMR_RgOffAddr ((BASE_ADDRESS + 0xc00))

#define MTL_OMR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MTL_OMR_RgOffAddr));\
} while(0)

#define MTL_OMR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MTL_OMR_RgOffAddr));\
} while(0)

/*#define  MTL_OMR_Mask_7 (ULONG)(~(~0<<(25)))*/

#define  MTL_OMR_Mask_7 (ULONG)(0x1ffffff)

/*#define MTL_OMR_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(25)))<<(7)))*/

#define MTL_OMR_RES_Wr_Mask_7 (ULONG)(0x7f)

/*#define  MTL_OMR_Mask_0 (ULONG)(~(~0<<(1)))*/

#define  MTL_OMR_Mask_0 (ULONG)(0x1)

/*#define MTL_OMR_RES_Wr_Mask_0 (ULONG)(~((~(~0<<(1)))<<(0)))*/

#define MTL_OMR_RES_Wr_Mask_0 (ULONG)(0xfffffffe)

/*#define MTL_OMR_SCHALG_Mask (ULONG)(~(~0<<(2)))*/

#define MTL_OMR_SCHALG_Mask (ULONG)(0x3)

/*#define MTL_OMR_SCHALG_Wr_Mask (ULONG)(~((~(~0 << (2))) << (5)))*/

#define MTL_OMR_SCHALG_Wr_Mask (ULONG)(0xffffff9f)

#define MTL_OMR_SCHALG_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_OMR_RgRd(pdata, v);\
		v = (v & (MTL_OMR_RES_Wr_Mask_7))|((( 0) & (MTL_OMR_Mask_7))<<7);\
		v = (v & (MTL_OMR_RES_Wr_Mask_0))|((( 0) & (MTL_OMR_Mask_0))<<0);\
		v = ((v & MTL_OMR_SCHALG_Wr_Mask) | ((data & MTL_OMR_SCHALG_Mask)<<5));\
		MTL_OMR_RgWr(pdata, v);\
} while(0)

#define MTL_OMR_SCHALG_UdfRd(pdata, data) do {\
		MTL_OMR_RgRd(pdata, data);\
		data = ((data >> 5) & MTL_OMR_SCHALG_Mask);\
} while(0)

/*#define MTL_OMR_RAA_Mask (ULONG)(~(~0<<(3)))*/

#define MTL_OMR_RAA_Mask (ULONG)(0x7)

/*#define MTL_OMR_RAA_Wr_Mask (ULONG)(~((~(~0 << (3))) << (2)))*/

#define MTL_OMR_RAA_Wr_Mask (ULONG)(0xffffffe3)

#define MTL_OMR_RAA_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_OMR_RgRd(pdata, v);\
		v = (v & (MTL_OMR_RES_Wr_Mask_7))|((( 0) & (MTL_OMR_Mask_7))<<7);\
		v = (v & (MTL_OMR_RES_Wr_Mask_0))|((( 0) & (MTL_OMR_Mask_0))<<0);\
		v = ((v & MTL_OMR_RAA_Wr_Mask) | ((data & MTL_OMR_RAA_Mask)<<2));\
		MTL_OMR_RgWr(pdata, v);\
} while(0)

#define MTL_OMR_RAA_UdfRd(pdata, data) do {\
		MTL_OMR_RgRd(pdata, data);\
		data = ((data >> 2) & MTL_OMR_RAA_Mask);\
} while(0)

/*#define MTL_OMR_DTXSTS_Mask (ULONG)(~(~0<<(1)))*/

#define MTL_OMR_DTXSTS_Mask (ULONG)(0x1)

/*#define MTL_OMR_DTXSTS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MTL_OMR_DTXSTS_Wr_Mask (ULONG)(0xfffffffd)

#define MTL_OMR_DTXSTS_UdfWr(pdata, data) do {\
		ULONG v;\
		MTL_OMR_RgRd(pdata, v);\
		v = (v & (MTL_OMR_RES_Wr_Mask_7))|((( 0) & (MTL_OMR_Mask_7))<<7);\
		v = (v & (MTL_OMR_RES_Wr_Mask_0))|((( 0) & (MTL_OMR_Mask_0))<<0);\
		v = ((v & MTL_OMR_DTXSTS_Wr_Mask) | ((data & MTL_OMR_DTXSTS_Mask)<<1));\
		MTL_OMR_RgWr(pdata, v);\
} while(0)

#define MTL_OMR_DTXSTS_UdfRd(pdata, data) do {\
		MTL_OMR_RgRd(pdata, data);\
		data = ((data >> 1) & MTL_OMR_DTXSTS_Mask);\
} while(0)


#define MAC_RQC3R_RgOffAddr ((BASE_ADDRESS + 0xac))

#define MAC_RQC3R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RQC3R_RgOffAddr));\
} while(0)

#define MAC_RQC3R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RQC3R_RgOffAddr));\
} while(0)

/*#define MAC_RQC3R_PSRQ7_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ7_Mask (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ7_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_RQC3R_PSRQ7_Wr_Mask (ULONG)(0xffffff)

#define MAC_RQC3R_PSRQ7_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC3R_RgRd(pdata, v);\
		v = ((v & MAC_RQC3R_PSRQ7_Wr_Mask) | ((data & MAC_RQC3R_PSRQ7_Mask)<<24));\
		MAC_RQC3R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC3R_PSRQ7_UdfRd(pdata, data) do {\
		MAC_RQC3R_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_RQC3R_PSRQ7_Mask);\
} while(0)

/*#define MAC_RQC3R_PSRQ6_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ6_Mask (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ6_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_RQC3R_PSRQ6_Wr_Mask (ULONG)(0xff00ffff)

#define MAC_RQC3R_PSRQ6_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC3R_RgRd(pdata, v);\
		v = ((v & MAC_RQC3R_PSRQ6_Wr_Mask) | ((data & MAC_RQC3R_PSRQ6_Mask)<<16));\
		MAC_RQC3R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC3R_PSRQ6_UdfRd(pdata, data) do {\
		MAC_RQC3R_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_RQC3R_PSRQ6_Mask);\
} while(0)

/*#define MAC_RQC3R_PSRQ5_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ5_Mask (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ5_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_RQC3R_PSRQ5_Wr_Mask (ULONG)(0xffff00ff)

#define MAC_RQC3R_PSRQ5_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC3R_RgRd(pdata, v);\
		v = ((v & MAC_RQC3R_PSRQ5_Wr_Mask) | ((data & MAC_RQC3R_PSRQ5_Mask)<<8));\
		MAC_RQC3R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC3R_PSRQ5_UdfRd(pdata, data) do {\
		MAC_RQC3R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RQC3R_PSRQ5_Mask);\
} while(0)

/*#define MAC_RQC3R_PSRQ4_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC3R_PSRQ4_Mask (ULONG)(0xff)

/*#define MAC_RQC3R_PSRQ4_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_RQC3R_PSRQ4_Wr_Mask (ULONG)(0xffffff00)

#define MAC_RQC3R_PSRQ4_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC3R_RgRd(pdata, v);\
		v = ((v & MAC_RQC3R_PSRQ4_Wr_Mask) | ((data & MAC_RQC3R_PSRQ4_Mask)<<0));\
		MAC_RQC3R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC3R_PSRQ4_UdfRd(pdata, data) do {\
		MAC_RQC3R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RQC3R_PSRQ4_Mask);\
} while(0)


#define MAC_RQC2R_RgOffAddr ((BASE_ADDRESS + 0xa8))

#define MAC_RQC2R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RQC2R_RgOffAddr));\
} while(0)

#define MAC_RQC2R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RQC2R_RgOffAddr));\
} while(0)

/*#define MAC_RQC2R_PSRQ3_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ3_Mask (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ3_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_RQC2R_PSRQ3_Wr_Mask (ULONG)(0xffffff)

#define MAC_RQC2R_PSRQ3_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC2R_RgRd(pdata, v);\
		v = ((v & MAC_RQC2R_PSRQ3_Wr_Mask) | ((data & MAC_RQC2R_PSRQ3_Mask)<<24));\
		MAC_RQC2R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC2R_PSRQ3_UdfRd(pdata, data) do {\
		MAC_RQC2R_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_RQC2R_PSRQ3_Mask);\
} while(0)

/*#define MAC_RQC2R_PSRQ2_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ2_Mask (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ2_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_RQC2R_PSRQ2_Wr_Mask (ULONG)(0xff00ffff)

#define MAC_RQC2R_PSRQ2_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC2R_RgRd(pdata, v);\
		v = ((v & MAC_RQC2R_PSRQ2_Wr_Mask) | ((data & MAC_RQC2R_PSRQ2_Mask)<<16));\
		MAC_RQC2R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC2R_PSRQ2_UdfRd(pdata, data) do {\
		MAC_RQC2R_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_RQC2R_PSRQ2_Mask);\
} while(0)

/*#define MAC_RQC2R_PSRQ1_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ1_Mask (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ1_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_RQC2R_PSRQ1_Wr_Mask (ULONG)(0xffff00ff)

#define MAC_RQC2R_PSRQ1_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC2R_RgRd(pdata, v);\
		v = ((v & MAC_RQC2R_PSRQ1_Wr_Mask) | ((data & MAC_RQC2R_PSRQ1_Mask)<<8));\
		MAC_RQC2R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC2R_PSRQ1_UdfRd(pdata, data) do {\
		MAC_RQC2R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RQC2R_PSRQ1_Mask);\
} while(0)

/*#define MAC_RQC2R_PSRQ0_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_RQC2R_PSRQ0_Mask (ULONG)(0xff)

/*#define MAC_RQC2R_PSRQ0_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_RQC2R_PSRQ0_Wr_Mask (ULONG)(0xffffff00)

#define MAC_RQC2R_PSRQ0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_RQC2R_RgRd(pdata, v);\
		v = ((v & MAC_RQC2R_PSRQ0_Wr_Mask) | ((data & MAC_RQC2R_PSRQ0_Mask)<<0));\
		MAC_RQC2R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC2R_PSRQ0_UdfRd(pdata, data) do {\
		MAC_RQC2R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RQC2R_PSRQ0_Mask);\
} while(0)


#define MAC_RQC1R_RgOffAddr ((BASE_ADDRESS + 0xa4))

#define MAC_RQC1R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RQC1R_RgOffAddr));\
} while(0)

#define MAC_RQC1R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RQC1R_RgOffAddr));\
} while(0)

/*#define  MAC_RQC1R_Mask_11 (ULONG)(~(~0<<(21)))*/

#define  MAC_RQC1R_Mask_11 (ULONG)(0x1fffff)

/*#define MAC_RQC1R_RES_Wr_Mask_11 (ULONG)(~((~(~0<<(21)))<<(11)))*/

#define MAC_RQC1R_RES_Wr_Mask_11 (ULONG)(0x7ff)

/*#define  MAC_RQC1R_Mask_7 (ULONG)(~(~0<<(1)))*/

#define  MAC_RQC1R_Mask_7 (ULONG)(0x1)

/*#define MAC_RQC1R_RES_Wr_Mask_7 (ULONG)(~((~(~0<<(1)))<<(7)))*/

#define MAC_RQC1R_RES_Wr_Mask_7 (ULONG)(0xffffff7f)

/*#define  MAC_RQC1R_Mask_3 (ULONG)(~(~0<<(1)))*/

#define  MAC_RQC1R_Mask_3 (ULONG)(0x1)

/*#define MAC_RQC1R_RES_Wr_Mask_3 (ULONG)(~((~(~0<<(1)))<<(3)))*/

#define MAC_RQC1R_RES_Wr_Mask_3 (ULONG)(0xfffffff7)

/*#define MAC_RQC1R_DCBCPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_DCBCPQ_Mask (ULONG)(0x7)

/*#define MAC_RQC1R_DCBCPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (8)))*/

#define MAC_RQC1R_DCBCPQ_Wr_Mask (ULONG)(0xfffff8ff)

#define MAC_RQC1R_DCBCPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC1R_RgRd(pdata, v);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_11))|((( 0) & (MAC_RQC1R_Mask_11))<<11);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_7))|((( 0) & (MAC_RQC1R_Mask_7))<<7);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_3))|((( 0) & (MAC_RQC1R_Mask_3))<<3);\
		v = ((v & MAC_RQC1R_DCBCPQ_Wr_Mask) | ((data & MAC_RQC1R_DCBCPQ_Mask)<<8));\
		MAC_RQC1R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC1R_DCBCPQ_UdfRd(pdata, data) do {\
		MAC_RQC1R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RQC1R_DCBCPQ_Mask);\
} while(0)

/*#define MAC_RQC1R_AVPTPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_AVPTPQ_Mask (ULONG)(0x7)

/*#define MAC_RQC1R_AVPTPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_RQC1R_AVPTPQ_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_RQC1R_AVPTPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC1R_RgRd(pdata, v);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_11))|((( 0) & (MAC_RQC1R_Mask_11))<<11);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_7))|((( 0) & (MAC_RQC1R_Mask_7))<<7);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_3))|((( 0) & (MAC_RQC1R_Mask_3))<<3);\
		v = ((v & MAC_RQC1R_AVPTPQ_Wr_Mask) | ((data & MAC_RQC1R_AVPTPQ_Mask)<<4));\
		MAC_RQC1R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC1R_AVPTPQ_UdfRd(pdata, data) do {\
		MAC_RQC1R_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_RQC1R_AVPTPQ_Mask);\
} while(0)

/*#define MAC_RQC1R_AVUCPQ_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_RQC1R_AVUCPQ_Mask (ULONG)(0x7)

/*#define MAC_RQC1R_AVUCPQ_Wr_Mask (ULONG)(~((~(~0 << (3))) << (0)))*/

#define MAC_RQC1R_AVUCPQ_Wr_Mask (ULONG)(0xfffffff8)

#define MAC_RQC1R_AVUCPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC1R_RgRd(pdata, v);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_11))|((( 0) & (MAC_RQC1R_Mask_11))<<11);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_7))|((( 0) & (MAC_RQC1R_Mask_7))<<7);\
		v = (v & (MAC_RQC1R_RES_Wr_Mask_3))|((( 0) & (MAC_RQC1R_Mask_3))<<3);\
		v = ((v & MAC_RQC1R_AVUCPQ_Wr_Mask) | ((data & MAC_RQC1R_AVUCPQ_Mask)<<0));\
		MAC_RQC1R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC1R_AVUCPQ_UdfRd(pdata, data) do {\
		MAC_RQC1R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RQC1R_AVUCPQ_Mask);\
} while(0)


#define MAC_RQC0R_RgOffAddr ((BASE_ADDRESS + 0xa0))

#define MAC_RQC0R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RQC0R_RgOffAddr));\
} while(0)

#define MAC_RQC0R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RQC0R_RgOffAddr));\
} while(0)

/*#define  MAC_RQC0R_Mask_16 (ULONG)(~(~0<<(16)))*/

#define  MAC_RQC0R_Mask_16 (ULONG)(0xffff)

/*#define MAC_RQC0R_RES_Wr_Mask_16 (ULONG)(~((~(~0<<(16)))<<(16)))*/

#define MAC_RQC0R_RES_Wr_Mask_16 (ULONG)(0xffff)

/*#define MAC_RQC0R_RXQEN7_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN7_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN7_Wr_Mask (ULONG)(~((~(~0 << (2))) << (14)))*/

#define MAC_RQC0R_RXQEN7_Wr_Mask (ULONG)(0xffff3fff)

#define MAC_RQC0R_RXQEN7_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN7_Wr_Mask) | ((data & MAC_RQC0R_RXQEN7_Mask)<<14));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN7_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 14) & MAC_RQC0R_RXQEN7_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN6_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN6_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN6_Wr_Mask (ULONG)(~((~(~0 << (2))) << (12)))*/

#define MAC_RQC0R_RXQEN6_Wr_Mask (ULONG)(0xffffcfff)

#define MAC_RQC0R_RXQEN6_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN6_Wr_Mask) | ((data & MAC_RQC0R_RXQEN6_Mask)<<12));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN6_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 12) & MAC_RQC0R_RXQEN6_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN5_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN5_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN5_Wr_Mask (ULONG)(~((~(~0 << (2))) << (10)))*/

#define MAC_RQC0R_RXQEN5_Wr_Mask (ULONG)(0xfffff3ff)

#define MAC_RQC0R_RXQEN5_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN5_Wr_Mask) | ((data & MAC_RQC0R_RXQEN5_Mask)<<10));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN5_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 10) & MAC_RQC0R_RXQEN5_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN4_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN4_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN4_Wr_Mask (ULONG)(~((~(~0 << (2))) << (8)))*/

#define MAC_RQC0R_RXQEN4_Wr_Mask (ULONG)(0xfffffcff)

#define MAC_RQC0R_RXQEN4_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN4_Wr_Mask) | ((data & MAC_RQC0R_RXQEN4_Mask)<<8));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN4_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RQC0R_RXQEN4_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN3_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN3_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN3_Wr_Mask (ULONG)(~((~(~0 << (2))) << (6)))*/

#define MAC_RQC0R_RXQEN3_Wr_Mask (ULONG)(0xffffff3f)

#define MAC_RQC0R_RXQEN3_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN3_Wr_Mask) | ((data & MAC_RQC0R_RXQEN3_Mask)<<6));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN3_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 6) & MAC_RQC0R_RXQEN3_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN2_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN2_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN2_Wr_Mask (ULONG)(~((~(~0 << (2))) << (4)))*/

#define MAC_RQC0R_RXQEN2_Wr_Mask (ULONG)(0xffffffcf)

#define MAC_RQC0R_RXQEN2_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN2_Wr_Mask) | ((data & MAC_RQC0R_RXQEN2_Mask)<<4));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN2_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_RQC0R_RXQEN2_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN1_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN1_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN1_Wr_Mask (ULONG)(~((~(~0 << (2))) << (2)))*/

#define MAC_RQC0R_RXQEN1_Wr_Mask (ULONG)(0xfffffff3)

#define MAC_RQC0R_RXQEN1_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN1_Wr_Mask) | ((data & MAC_RQC0R_RXQEN1_Mask)<<2));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN1_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 2) & MAC_RQC0R_RXQEN1_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN0_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN0_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN0_Wr_Mask (ULONG)(~((~(~0 << (2))) << (0)))*/

#define MAC_RQC0R_RXQEN0_Wr_Mask (ULONG)(0xfffffffc)

#define MAC_RQC0R_RXQEN0_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN0_Wr_Mask) | ((data & MAC_RQC0R_RXQEN0_Mask)<<0));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN0_UdfRd(pdata, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RQC0R_RXQEN0_Mask);\
} while(0)

/*#define MAC_RQC0R_RXQEN_Mask (ULONG)(~(~0<<(2)))*/

#define MAC_RQC0R_RXQEN_Mask (ULONG)(0x3)

/*#define MAC_RQC0R_RXQEN_Wr_Mask(i) (ULONG)(~((~(~0 << (2))) << (0 + (i * 2))))*/

#define MAC_RQC0R_RXQEN_Wr_Mask(i)  (ULONG)(~((~(~0 << (2))) << (0 + (i * 2))))

#define MAC_RQC0R_RXQEN_UdfWr(pdata, i, data) do {\
		ULONG v;\
		MAC_RQC0R_RgRd(pdata, v);\
		v = (v & (MAC_RQC0R_RES_Wr_Mask_16))|((( 0) & (MAC_RQC0R_Mask_16))<<16);\
		v = ((v & MAC_RQC0R_RXQEN_Wr_Mask(i)) | ((data & MAC_RQC0R_RXQEN_Mask)<<(0 + i*2)));\
		MAC_RQC0R_RgWr(pdata, v);\
} while(0)

#define MAC_RQC0R_RXQEN_UdfRd(pdata, i, data) do {\
		MAC_RQC0R_RgRd(pdata, data);\
		data = ((data >> (0 + (i*2))) & MAC_RQC0R_RXQEN_Mask);\
} while(0)


#define MAC_TQPM1R_RgOffAddr ((BASE_ADDRESS + 0x9c))

#define MAC_TQPM1R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TQPM1R_RgOffAddr));\
} while(0)

#define MAC_TQPM1R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TQPM1R_RgOffAddr));\
} while(0)

/*#define MAC_TQPM1R_PSTQ7_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ7_Mask (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ7_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_TQPM1R_PSTQ7_Wr_Mask (ULONG)(0xffffff)

#define MAC_TQPM1R_PSTQ7_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM1R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM1R_PSTQ7_Wr_Mask) | ((data & MAC_TQPM1R_PSTQ7_Mask)<<24));\
		MAC_TQPM1R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM1R_PSTQ7_UdfRd(pdata, data) do {\
		MAC_TQPM1R_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_TQPM1R_PSTQ7_Mask);\
} while(0)

/*#define MAC_TQPM1R_PSTQ6_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ6_Mask (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ6_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_TQPM1R_PSTQ6_Wr_Mask (ULONG)(0xff00ffff)

#define MAC_TQPM1R_PSTQ6_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM1R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM1R_PSTQ6_Wr_Mask) | ((data & MAC_TQPM1R_PSTQ6_Mask)<<16));\
		MAC_TQPM1R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM1R_PSTQ6_UdfRd(pdata, data) do {\
		MAC_TQPM1R_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_TQPM1R_PSTQ6_Mask);\
} while(0)

/*#define MAC_TQPM1R_PSTQ5_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ5_Mask (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ5_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_TQPM1R_PSTQ5_Wr_Mask (ULONG)(0xffff00ff)

#define MAC_TQPM1R_PSTQ5_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM1R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM1R_PSTQ5_Wr_Mask) | ((data & MAC_TQPM1R_PSTQ5_Mask)<<8));\
		MAC_TQPM1R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM1R_PSTQ5_UdfRd(pdata, data) do {\
		MAC_TQPM1R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_TQPM1R_PSTQ5_Mask);\
} while(0)

/*#define MAC_TQPM1R_PSTQ4_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM1R_PSTQ4_Mask (ULONG)(0xff)

/*#define MAC_TQPM1R_PSTQ4_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_TQPM1R_PSTQ4_Wr_Mask (ULONG)(0xffffff00)

#define MAC_TQPM1R_PSTQ4_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM1R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM1R_PSTQ4_Wr_Mask) | ((data & MAC_TQPM1R_PSTQ4_Mask)<<0));\
		MAC_TQPM1R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM1R_PSTQ4_UdfRd(pdata, data) do {\
		MAC_TQPM1R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TQPM1R_PSTQ4_Mask);\
} while(0)


#define MAC_TQPM0R_RgOffAddr ((BASE_ADDRESS + 0x98))

#define MAC_TQPM0R_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_TQPM0R_RgOffAddr));\
} while(0)

#define MAC_TQPM0R_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_TQPM0R_RgOffAddr));\
} while(0)

/*#define MAC_TQPM0R_PSTQ3_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ3_Mask (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ3_Wr_Mask (ULONG)(~((~(~0 << (8))) << (24)))*/

#define MAC_TQPM0R_PSTQ3_Wr_Mask (ULONG)(0xffffff)

#define MAC_TQPM0R_PSTQ3_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM0R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM0R_PSTQ3_Wr_Mask) | ((data & MAC_TQPM0R_PSTQ3_Mask)<<24));\
		MAC_TQPM0R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM0R_PSTQ3_UdfRd(pdata, data) do {\
		MAC_TQPM0R_RgRd(pdata, data);\
		data = ((data >> 24) & MAC_TQPM0R_PSTQ3_Mask);\
} while(0)

/*#define MAC_TQPM0R_PSTQ2_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ2_Mask (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ2_Wr_Mask (ULONG)(~((~(~0 << (8))) << (16)))*/

#define MAC_TQPM0R_PSTQ2_Wr_Mask (ULONG)(0xff00ffff)

#define MAC_TQPM0R_PSTQ2_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM0R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM0R_PSTQ2_Wr_Mask) | ((data & MAC_TQPM0R_PSTQ2_Mask)<<16));\
		MAC_TQPM0R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM0R_PSTQ2_UdfRd(pdata, data) do {\
		MAC_TQPM0R_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_TQPM0R_PSTQ2_Mask);\
} while(0)

/*#define MAC_TQPM0R_PSTQ1_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ1_Mask (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ1_Wr_Mask (ULONG)(~((~(~0 << (8))) << (8)))*/

#define MAC_TQPM0R_PSTQ1_Wr_Mask (ULONG)(0xffff00ff)

#define MAC_TQPM0R_PSTQ1_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM0R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM0R_PSTQ1_Wr_Mask) | ((data & MAC_TQPM0R_PSTQ1_Mask)<<8));\
		MAC_TQPM0R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM0R_PSTQ1_UdfRd(pdata, data) do {\
		MAC_TQPM0R_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_TQPM0R_PSTQ1_Mask);\
} while(0)

/*#define MAC_TQPM0R_PSTQ0_Mask (ULONG)(~(~0<<(8)))*/

#define MAC_TQPM0R_PSTQ0_Mask (ULONG)(0xff)

/*#define MAC_TQPM0R_PSTQ0_Wr_Mask (ULONG)(~((~(~0 << (8))) << (0)))*/

#define MAC_TQPM0R_PSTQ0_Wr_Mask (ULONG)(0xffffff00)

#define MAC_TQPM0R_PSTQ0_UdfWr(pdata, data) do{\
		ULONG v;\
		MAC_TQPM0R_RgRd(pdata, v);\
		v = ((v & MAC_TQPM0R_PSTQ0_Wr_Mask) | ((data & MAC_TQPM0R_PSTQ0_Mask)<<0));\
		MAC_TQPM0R_RgWr(pdata, v);\
} while(0)

#define MAC_TQPM0R_PSTQ0_UdfRd(pdata, data) do {\
		MAC_TQPM0R_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_TQPM0R_PSTQ0_Mask);\
} while(0)


#define MAC_RFCR_RgOffAddr ((BASE_ADDRESS + 0x90))

#define MAC_RFCR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_RFCR_RgOffAddr));\
} while(0)

#define MAC_RFCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_RFCR_RgOffAddr));\
} while(0)

/*#define  MAC_RFCR_Mask_9 (ULONG)(~(~0<<(23)))*/

#define  MAC_RFCR_Mask_9 (ULONG)(0x7fffff)

/*#define MAC_RFCR_RES_Wr_Mask_9 (ULONG)(~((~(~0<<(23)))<<(9)))*/

#define MAC_RFCR_RES_Wr_Mask_9 (ULONG)(0x1ff)

/*#define  MAC_RFCR_Mask_2 (ULONG)(~(~0<<(6)))*/

#define  MAC_RFCR_Mask_2 (ULONG)(0x3f)

/*#define MAC_RFCR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(6)))<<(2)))*/

#define MAC_RFCR_RES_Wr_Mask_2 (ULONG)(0xffffff03)

/*#define MAC_RFCR_PFCE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_PFCE_Mask (ULONG)(0x1)

/*#define MAC_RFCR_PFCE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (8)))*/

#define MAC_RFCR_PFCE_Wr_Mask (ULONG)(0xfffffeff)

#define MAC_RFCR_PFCE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RFCR_RgRd(pdata, v);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_9))|((( 0) & (MAC_RFCR_Mask_9))<<9);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_2))|((( 0) & (MAC_RFCR_Mask_2))<<2);\
		v = ((v & MAC_RFCR_PFCE_Wr_Mask) | ((data & MAC_RFCR_PFCE_Mask)<<8));\
		MAC_RFCR_RgWr(pdata, v);\
} while(0)

#define MAC_RFCR_PFCE_UdfRd(pdata, data) do {\
		MAC_RFCR_RgRd(pdata, data);\
		data = ((data >> 8) & MAC_RFCR_PFCE_Mask);\
} while(0)

/*#define MAC_RFCR_UP_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_UP_Mask (ULONG)(0x1)

/*#define MAC_RFCR_UP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_RFCR_UP_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_RFCR_UP_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RFCR_RgRd(pdata, v);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_9))|((( 0) & (MAC_RFCR_Mask_9))<<9);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_2))|((( 0) & (MAC_RFCR_Mask_2))<<2);\
		v = ((v & MAC_RFCR_UP_Wr_Mask) | ((data & MAC_RFCR_UP_Mask)<<1));\
		MAC_RFCR_RgWr(pdata, v);\
} while(0)

#define MAC_RFCR_UP_UdfRd(pdata, data) do {\
		MAC_RFCR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_RFCR_UP_Mask);\
} while(0)

/*#define MAC_RFCR_RFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_RFCR_RFE_Mask (ULONG)(0x1)

/*#define MAC_RFCR_RFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_RFCR_RFE_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_RFCR_RFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_RFCR_RgRd(pdata, v);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_9))|((( 0) & (MAC_RFCR_Mask_9))<<9);\
		v = (v & (MAC_RFCR_RES_Wr_Mask_2))|((( 0) & (MAC_RFCR_Mask_2))<<2);\
		v = ((v & MAC_RFCR_RFE_Wr_Mask) | ((data & MAC_RFCR_RFE_Mask)<<0));\
		MAC_RFCR_RgWr(pdata, v);\
} while(0)

#define MAC_RFCR_RFE_UdfRd(pdata, data) do {\
		MAC_RFCR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_RFCR_RFE_Mask);\
} while(0)


#define MAC_QTFCR7_RgOffAddr ((BASE_ADDRESS + 0x8c))

#define MAC_QTFCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR7_RgOffAddr));\
} while(0)

#define MAC_QTFCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR7_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR7_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR7_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR7_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR7_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR7_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR7_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR7_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR7_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR7_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR7_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR7_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR7_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR7_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR7_Mask_8))<<8);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR7_Mask_2))<<2);\
		v = ((v & MAC_QTFCR7_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR7_FCB_BPA_Mask)<<0));\
		MAC_QTFCR7_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR7_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR7_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR7_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR7_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR7_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR7_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR7_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR7_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR7_Mask_8))<<8);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR7_Mask_2))<<2);\
		v = ((v & MAC_QTFCR7_TFE_Wr_Mask) | ((data & MAC_QTFCR7_TFE_Mask)<<1));\
		MAC_QTFCR7_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR7_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR7_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR7_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR7_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR7_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR7_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR7_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR7_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR7_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR7_Mask_8))<<8);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR7_Mask_2))<<2);\
		v = ((v & MAC_QTFCR7_PLT_Wr_Mask) | ((data & MAC_QTFCR7_PLT_Mask)<<4));\
		MAC_QTFCR7_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR7_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR7_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR7_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR7_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR7_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR7_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR7_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR7_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR7_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR7_Mask_8))<<8);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR7_Mask_2))<<2);\
		v = ((v & MAC_QTFCR7_DZPQ_Wr_Mask) | ((data & MAC_QTFCR7_DZPQ_Mask)<<7));\
		MAC_QTFCR7_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR7_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR7_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR7_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR7_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR7_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR7_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR7_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR7_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR7_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR7_Mask_8))<<8);\
		v = (v & (MAC_QTFCR7_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR7_Mask_2))<<2);\
		v = ((v & MAC_QTFCR7_PT_Wr_Mask) | ((data & MAC_QTFCR7_PT_Mask)<<16));\
		MAC_QTFCR7_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR7_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR7_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR7_PT_Mask);\
} while(0)


#define MAC_QTFCR6_RgOffAddr ((BASE_ADDRESS + 0x88))

#define MAC_QTFCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR6_RgOffAddr));\
} while(0)

#define MAC_QTFCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR6_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR6_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR6_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR6_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR6_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR6_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR6_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR6_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR6_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR6_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR6_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR6_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR6_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR6_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR6_Mask_8))<<8);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR6_Mask_2))<<2);\
		v = ((v & MAC_QTFCR6_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR6_FCB_BPA_Mask)<<0));\
		MAC_QTFCR6_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR6_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR6_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR6_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR6_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR6_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR6_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR6_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR6_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR6_Mask_8))<<8);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR6_Mask_2))<<2);\
		v = ((v & MAC_QTFCR6_TFE_Wr_Mask) | ((data & MAC_QTFCR6_TFE_Mask)<<1));\
		MAC_QTFCR6_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR6_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR6_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR6_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR6_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR6_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR6_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR6_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR6_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR6_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR6_Mask_8))<<8);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR6_Mask_2))<<2);\
		v = ((v & MAC_QTFCR6_PLT_Wr_Mask) | ((data & MAC_QTFCR6_PLT_Mask)<<4));\
		MAC_QTFCR6_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR6_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR6_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR6_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR6_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR6_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR6_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR6_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR6_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR6_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR6_Mask_8))<<8);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR6_Mask_2))<<2);\
		v = ((v & MAC_QTFCR6_DZPQ_Wr_Mask) | ((data & MAC_QTFCR6_DZPQ_Mask)<<7));\
		MAC_QTFCR6_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR6_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR6_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR6_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR6_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR6_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR6_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR6_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR6_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR6_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR6_Mask_8))<<8);\
		v = (v & (MAC_QTFCR6_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR6_Mask_2))<<2);\
		v = ((v & MAC_QTFCR6_PT_Wr_Mask) | ((data & MAC_QTFCR6_PT_Mask)<<16));\
		MAC_QTFCR6_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR6_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR6_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR6_PT_Mask);\
} while(0)


#define MAC_QTFCR5_RgOffAddr ((BASE_ADDRESS + 0x84))

#define MAC_QTFCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR5_RgOffAddr));\
} while(0)

#define MAC_QTFCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR5_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR5_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR5_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR5_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR5_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR5_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR5_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR5_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR5_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR5_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR5_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR5_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR5_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR5_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR5_Mask_8))<<8);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR5_Mask_2))<<2);\
		v = ((v & MAC_QTFCR5_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR5_FCB_BPA_Mask)<<0));\
		MAC_QTFCR5_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR5_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR5_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR5_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR5_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR5_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR5_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR5_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR5_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR5_Mask_8))<<8);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR5_Mask_2))<<2);\
		v = ((v & MAC_QTFCR5_TFE_Wr_Mask) | ((data & MAC_QTFCR5_TFE_Mask)<<1));\
		MAC_QTFCR5_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR5_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR5_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR5_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR5_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR5_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR5_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR5_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR5_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR5_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR5_Mask_8))<<8);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR5_Mask_2))<<2);\
		v = ((v & MAC_QTFCR5_PLT_Wr_Mask) | ((data & MAC_QTFCR5_PLT_Mask)<<4));\
		MAC_QTFCR5_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR5_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR5_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR5_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR5_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR5_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR5_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR5_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR5_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR5_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR5_Mask_8))<<8);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR5_Mask_2))<<2);\
		v = ((v & MAC_QTFCR5_DZPQ_Wr_Mask) | ((data & MAC_QTFCR5_DZPQ_Mask)<<7));\
		MAC_QTFCR5_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR5_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR5_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR5_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR5_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR5_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR5_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR5_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR5_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR5_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR5_Mask_8))<<8);\
		v = (v & (MAC_QTFCR5_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR5_Mask_2))<<2);\
		v = ((v & MAC_QTFCR5_PT_Wr_Mask) | ((data & MAC_QTFCR5_PT_Mask)<<16));\
		MAC_QTFCR5_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR5_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR5_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR5_PT_Mask);\
} while(0)


#define MAC_QTFCR4_RgOffAddr ((BASE_ADDRESS + 0x80))

#define MAC_QTFCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR4_RgOffAddr));\
} while(0)

#define MAC_QTFCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR4_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR4_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR4_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR4_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR4_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR4_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR4_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR4_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR4_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR4_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR4_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR4_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR4_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR4_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR4_Mask_8))<<8);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR4_Mask_2))<<2);\
		v = ((v & MAC_QTFCR4_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR4_FCB_BPA_Mask)<<0));\
		MAC_QTFCR4_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR4_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR4_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR4_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR4_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR4_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR4_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR4_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR4_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR4_Mask_8))<<8);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR4_Mask_2))<<2);\
		v = ((v & MAC_QTFCR4_TFE_Wr_Mask) | ((data & MAC_QTFCR4_TFE_Mask)<<1));\
		MAC_QTFCR4_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR4_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR4_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR4_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR4_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR4_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR4_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR4_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR4_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR4_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR4_Mask_8))<<8);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR4_Mask_2))<<2);\
		v = ((v & MAC_QTFCR4_PLT_Wr_Mask) | ((data & MAC_QTFCR4_PLT_Mask)<<4));\
		MAC_QTFCR4_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR4_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR4_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR4_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR4_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR4_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR4_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR4_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR4_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR4_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR4_Mask_8))<<8);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR4_Mask_2))<<2);\
		v = ((v & MAC_QTFCR4_DZPQ_Wr_Mask) | ((data & MAC_QTFCR4_DZPQ_Mask)<<7));\
		MAC_QTFCR4_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR4_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR4_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR4_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR4_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR4_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR4_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR4_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR4_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR4_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR4_Mask_8))<<8);\
		v = (v & (MAC_QTFCR4_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR4_Mask_2))<<2);\
		v = ((v & MAC_QTFCR4_PT_Wr_Mask) | ((data & MAC_QTFCR4_PT_Mask)<<16));\
		MAC_QTFCR4_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR4_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR4_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR4_PT_Mask);\
} while(0)


#define MAC_QTFCR3_RgOffAddr ((BASE_ADDRESS + 0x7c))

#define MAC_QTFCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR3_RgOffAddr));\
} while(0)

#define MAC_QTFCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR3_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR3_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR3_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR3_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR3_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR3_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR3_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR3_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR3_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR3_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR3_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR3_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR3_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR3_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR3_Mask_8))<<8);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR3_Mask_2))<<2);\
		v = ((v & MAC_QTFCR3_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR3_FCB_BPA_Mask)<<0));\
		MAC_QTFCR3_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR3_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR3_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR3_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR3_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR3_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR3_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR3_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR3_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR3_Mask_8))<<8);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR3_Mask_2))<<2);\
		v = ((v & MAC_QTFCR3_TFE_Wr_Mask) | ((data & MAC_QTFCR3_TFE_Mask)<<1));\
		MAC_QTFCR3_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR3_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR3_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR3_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR3_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR3_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR3_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR3_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR3_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR3_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR3_Mask_8))<<8);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR3_Mask_2))<<2);\
		v = ((v & MAC_QTFCR3_PLT_Wr_Mask) | ((data & MAC_QTFCR3_PLT_Mask)<<4));\
		MAC_QTFCR3_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR3_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR3_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR3_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR3_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR3_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR3_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR3_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR3_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR3_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR3_Mask_8))<<8);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR3_Mask_2))<<2);\
		v = ((v & MAC_QTFCR3_DZPQ_Wr_Mask) | ((data & MAC_QTFCR3_DZPQ_Mask)<<7));\
		MAC_QTFCR3_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR3_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR3_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR3_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR3_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR3_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR3_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR3_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR3_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR3_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR3_Mask_8))<<8);\
		v = (v & (MAC_QTFCR3_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR3_Mask_2))<<2);\
		v = ((v & MAC_QTFCR3_PT_Wr_Mask) | ((data & MAC_QTFCR3_PT_Mask)<<16));\
		MAC_QTFCR3_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR3_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR3_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR3_PT_Mask);\
} while(0)


#define MAC_QTFCR2_RgOffAddr ((BASE_ADDRESS + 0x78))

#define MAC_QTFCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR2_RgOffAddr));\
} while(0)

#define MAC_QTFCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR2_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR2_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR2_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR2_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR2_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR2_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR2_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR2_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR2_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR2_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR2_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR2_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR2_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR2_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR2_Mask_8))<<8);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR2_Mask_2))<<2);\
		v = ((v & MAC_QTFCR2_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR2_FCB_BPA_Mask)<<0));\
		MAC_QTFCR2_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR2_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR2_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR2_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR2_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR2_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR2_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR2_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR2_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR2_Mask_8))<<8);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR2_Mask_2))<<2);\
		v = ((v & MAC_QTFCR2_TFE_Wr_Mask) | ((data & MAC_QTFCR2_TFE_Mask)<<1));\
		MAC_QTFCR2_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR2_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR2_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR2_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR2_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR2_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR2_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR2_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR2_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR2_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR2_Mask_8))<<8);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR2_Mask_2))<<2);\
		v = ((v & MAC_QTFCR2_PLT_Wr_Mask) | ((data & MAC_QTFCR2_PLT_Mask)<<4));\
		MAC_QTFCR2_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR2_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR2_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR2_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR2_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR2_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR2_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR2_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR2_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR2_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR2_Mask_8))<<8);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR2_Mask_2))<<2);\
		v = ((v & MAC_QTFCR2_DZPQ_Wr_Mask) | ((data & MAC_QTFCR2_DZPQ_Mask)<<7));\
		MAC_QTFCR2_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR2_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR2_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR2_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR2_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR2_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR2_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR2_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR2_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR2_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR2_Mask_8))<<8);\
		v = (v & (MAC_QTFCR2_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR2_Mask_2))<<2);\
		v = ((v & MAC_QTFCR2_PT_Wr_Mask) | ((data & MAC_QTFCR2_PT_Mask)<<16));\
		MAC_QTFCR2_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR2_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR2_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR2_PT_Mask);\
} while(0)


#define MAC_QTFCR1_RgOffAddr ((BASE_ADDRESS + 0x74))

#define MAC_QTFCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_QTFCR1_RgOffAddr));\
} while(0)

#define MAC_QTFCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_QTFCR1_RgOffAddr));\
} while(0)

/*#define  MAC_QTFCR1_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_QTFCR1_Mask_8 (ULONG)(0xff)

/*#define MAC_QTFCR1_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_QTFCR1_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_QTFCR1_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_QTFCR1_Mask_2 (ULONG)(0x3)

/*#define MAC_QTFCR1_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_QTFCR1_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_QTFCR1_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_QTFCR1_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_QTFCR1_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_QTFCR1_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR1_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR1_Mask_8))<<8);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR1_Mask_2))<<2);\
		v = ((v & MAC_QTFCR1_FCB_BPA_Wr_Mask) | ((data & MAC_QTFCR1_FCB_BPA_Mask)<<0));\
		MAC_QTFCR1_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR1_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_QTFCR1_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_QTFCR1_FCB_BPA_Mask);\
} while(0)

/*#define MAC_QTFCR1_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_TFE_Mask (ULONG)(0x1)

/*#define MAC_QTFCR1_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_QTFCR1_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_QTFCR1_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR1_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR1_Mask_8))<<8);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR1_Mask_2))<<2);\
		v = ((v & MAC_QTFCR1_TFE_Wr_Mask) | ((data & MAC_QTFCR1_TFE_Mask)<<1));\
		MAC_QTFCR1_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR1_TFE_UdfRd(pdata, data) do {\
		MAC_QTFCR1_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_QTFCR1_TFE_Mask);\
} while(0)

/*#define MAC_QTFCR1_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_QTFCR1_PLT_Mask (ULONG)(0x7)

/*#define MAC_QTFCR1_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_QTFCR1_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_QTFCR1_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR1_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR1_Mask_8))<<8);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR1_Mask_2))<<2);\
		v = ((v & MAC_QTFCR1_PLT_Wr_Mask) | ((data & MAC_QTFCR1_PLT_Mask)<<4));\
		MAC_QTFCR1_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR1_PLT_UdfRd(pdata, data) do {\
		MAC_QTFCR1_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_QTFCR1_PLT_Mask);\
} while(0)

/*#define MAC_QTFCR1_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_QTFCR1_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_QTFCR1_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_QTFCR1_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_QTFCR1_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR1_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR1_Mask_8))<<8);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR1_Mask_2))<<2);\
		v = ((v & MAC_QTFCR1_DZPQ_Wr_Mask) | ((data & MAC_QTFCR1_DZPQ_Mask)<<7));\
		MAC_QTFCR1_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR1_DZPQ_UdfRd(pdata, data) do {\
		MAC_QTFCR1_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_QTFCR1_DZPQ_Mask);\
} while(0)

/*#define MAC_QTFCR1_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_QTFCR1_PT_Mask (ULONG)(0xffff)

/*#define MAC_QTFCR1_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_QTFCR1_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_QTFCR1_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_QTFCR1_RgRd(pdata, v);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_8))|((( 0) & (MAC_QTFCR1_Mask_8))<<8);\
		v = (v & (MAC_QTFCR1_RES_Wr_Mask_2))|((( 0) & (MAC_QTFCR1_Mask_2))<<2);\
		v = ((v & MAC_QTFCR1_PT_Wr_Mask) | ((data & MAC_QTFCR1_PT_Mask)<<16));\
		MAC_QTFCR1_RgWr(pdata, v);\
} while(0)

#define MAC_QTFCR1_PT_UdfRd(pdata, data) do {\
		MAC_QTFCR1_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_QTFCR1_PT_Mask);\
} while(0)


#define MAC_Q0TFCR_RgOffAddr ((BASE_ADDRESS + 0x70))

#define MAC_Q0TFCR_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + MAC_Q0TFCR_RgOffAddr));\
} while(0)

#define MAC_Q0TFCR_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + MAC_Q0TFCR_RgOffAddr));\
} while(0)

/*#define  MAC_Q0TFCR_Mask_8 (ULONG)(~(~0<<(8)))*/

#define  MAC_Q0TFCR_Mask_8 (ULONG)(0xff)

/*#define MAC_Q0TFCR_RES_Wr_Mask_8 (ULONG)(~((~(~0<<(8)))<<(8)))*/

#define MAC_Q0TFCR_RES_Wr_Mask_8 (ULONG)(0xffff00ff)

/*#define  MAC_Q0TFCR_Mask_2 (ULONG)(~(~0<<(2)))*/

#define  MAC_Q0TFCR_Mask_2 (ULONG)(0x3)

/*#define MAC_Q0TFCR_RES_Wr_Mask_2 (ULONG)(~((~(~0<<(2)))<<(2)))*/

#define MAC_Q0TFCR_RES_Wr_Mask_2 (ULONG)(0xfffffff3)

/*#define MAC_Q0TFCR_PT_Mask (ULONG)(~(~0<<(16)))*/

#define MAC_Q0TFCR_PT_Mask (ULONG)(0xffff)

/*#define MAC_Q0TFCR_PT_Wr_Mask (ULONG)(~((~(~0 << (16))) << (16)))*/

#define MAC_Q0TFCR_PT_Wr_Mask (ULONG)(0xffff)

#define MAC_Q0TFCR_PT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_Q0TFCR_RgRd(pdata, v);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_8))|((( 0) & (MAC_Q0TFCR_Mask_8))<<8);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_2))|((( 0) & (MAC_Q0TFCR_Mask_2))<<2);\
		v = ((v & MAC_Q0TFCR_PT_Wr_Mask) | ((data & MAC_Q0TFCR_PT_Mask)<<16));\
		MAC_Q0TFCR_RgWr(pdata, v);\
} while(0)

#define MAC_Q0TFCR_PT_UdfRd(pdata, data) do {\
		MAC_Q0TFCR_RgRd(pdata, data);\
		data = ((data >> 16) & MAC_Q0TFCR_PT_Mask);\
} while(0)

/*#define MAC_Q0TFCR_DZPQ_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_DZPQ_Mask (ULONG)(0x1)

/*#define MAC_Q0TFCR_DZPQ_Wr_Mask (ULONG)(~((~(~0 << (1))) << (7)))*/

#define MAC_Q0TFCR_DZPQ_Wr_Mask (ULONG)(0xffffff7f)

#define MAC_Q0TFCR_DZPQ_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_Q0TFCR_RgRd(pdata, v);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_8))|((( 0) & (MAC_Q0TFCR_Mask_8))<<8);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_2))|((( 0) & (MAC_Q0TFCR_Mask_2))<<2);\
		v = ((v & MAC_Q0TFCR_DZPQ_Wr_Mask) | ((data & MAC_Q0TFCR_DZPQ_Mask)<<7));\
		MAC_Q0TFCR_RgWr(pdata, v);\
} while(0)

#define MAC_Q0TFCR_DZPQ_UdfRd(pdata, data) do {\
		MAC_Q0TFCR_RgRd(pdata, data);\
		data = ((data >> 7) & MAC_Q0TFCR_DZPQ_Mask);\
} while(0)

/*#define MAC_Q0TFCR_PLT_Mask (ULONG)(~(~0<<(3)))*/

#define MAC_Q0TFCR_PLT_Mask (ULONG)(0x7)

/*#define MAC_Q0TFCR_PLT_Wr_Mask (ULONG)(~((~(~0 << (3))) << (4)))*/

#define MAC_Q0TFCR_PLT_Wr_Mask (ULONG)(0xffffff8f)

#define MAC_Q0TFCR_PLT_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_Q0TFCR_RgRd(pdata, v);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_8))|((( 0) & (MAC_Q0TFCR_Mask_8))<<8);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_2))|((( 0) & (MAC_Q0TFCR_Mask_2))<<2);\
		v = ((v & MAC_Q0TFCR_PLT_Wr_Mask) | ((data & MAC_Q0TFCR_PLT_Mask)<<4));\
		MAC_Q0TFCR_RgWr(pdata, v);\
} while(0)

#define MAC_Q0TFCR_PLT_UdfRd(pdata, data) do {\
		MAC_Q0TFCR_RgRd(pdata, data);\
		data = ((data >> 4) & MAC_Q0TFCR_PLT_Mask);\
} while(0)

/*#define MAC_Q0TFCR_TFE_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_TFE_Mask (ULONG)(0x1)

/*#define MAC_Q0TFCR_TFE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (1)))*/

#define MAC_Q0TFCR_TFE_Wr_Mask (ULONG)(0xfffffffd)

#define MAC_Q0TFCR_TFE_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_Q0TFCR_RgRd(pdata, v);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_8))|((( 0) & (MAC_Q0TFCR_Mask_8))<<8);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_2))|((( 0) & (MAC_Q0TFCR_Mask_2))<<2);\
		v = ((v & MAC_Q0TFCR_TFE_Wr_Mask) | ((data & MAC_Q0TFCR_TFE_Mask)<<1));\
		MAC_Q0TFCR_RgWr(pdata, v);\
} while(0)

#define MAC_Q0TFCR_TFE_UdfRd(pdata, data) do {\
		MAC_Q0TFCR_RgRd(pdata, data);\
		data = ((data >> 1) & MAC_Q0TFCR_TFE_Mask);\
} while(0)

/*#define MAC_Q0TFCR_FCB_BPA_Mask (ULONG)(~(~0<<(1)))*/

#define MAC_Q0TFCR_FCB_BPA_Mask (ULONG)(0x1)

/*#define MAC_Q0TFCR_FCB_BPA_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define MAC_Q0TFCR_FCB_BPA_Wr_Mask (ULONG)(0xfffffffe)

#define MAC_Q0TFCR_FCB_BPA_UdfWr(pdata, data) do {\
		ULONG v;\
		MAC_Q0TFCR_RgRd(pdata, v);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_8))|((( 0) & (MAC_Q0TFCR_Mask_8))<<8);\
		v = (v & (MAC_Q0TFCR_RES_Wr_Mask_2))|((( 0) & (MAC_Q0TFCR_Mask_2))<<2);\
		v = ((v & MAC_Q0TFCR_FCB_BPA_Wr_Mask) | ((data & MAC_Q0TFCR_FCB_BPA_Mask)<<0));\
		MAC_Q0TFCR_RgWr(pdata, v);\
} while(0)

#define MAC_Q0TFCR_FCB_BPA_UdfRd(pdata, data) do {\
		MAC_Q0TFCR_RgRd(pdata, data);\
		data = ((data >> 0) & MAC_Q0TFCR_FCB_BPA_Mask);\
} while(0)


#define DMA_AXI4CR7_RgOffAddr ((BASE_ADDRESS + 0x14e4))

#define DMA_AXI4CR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR7_RgOffAddr));\
} while(0)

#define DMA_AXI4CR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR7_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR7_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR7_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR7_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR7_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR7_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR7_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR7_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR7_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR7_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR7_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR7_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR7_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR7_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR7_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR7_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR7_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR7_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR7_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR7_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR7_AWQOS_Mask)<<0));\
		DMA_AXI4CR7_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR7_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR7_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR7_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR7_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR7_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR7_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR7_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR7_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR7_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR7_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR7_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR7_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR7_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR7_ARQOS_Mask)<<16));\
		DMA_AXI4CR7_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR7_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR7_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR7_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR6_RgOffAddr ((BASE_ADDRESS + 0x1464))

#define DMA_AXI4CR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR6_RgOffAddr));\
} while(0)

#define DMA_AXI4CR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR6_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR6_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR6_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR6_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR6_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR6_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR6_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR6_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR6_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR6_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR6_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR6_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR6_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR6_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR6_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR6_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR6_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR6_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR6_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR6_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR6_AWQOS_Mask)<<0));\
		DMA_AXI4CR6_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR6_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR6_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR6_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR6_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR6_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR6_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR6_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR6_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR6_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR6_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR6_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR6_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR6_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR6_ARQOS_Mask)<<16));\
		DMA_AXI4CR6_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR6_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR6_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR6_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR5_RgOffAddr ((BASE_ADDRESS + 0x13e4))

#define DMA_AXI4CR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR5_RgOffAddr));\
} while(0)

#define DMA_AXI4CR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR5_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR5_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR5_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR5_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR5_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR5_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR5_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR5_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR5_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR5_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR5_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR5_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR5_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR5_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR5_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR5_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR5_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR5_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR5_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR5_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR5_AWQOS_Mask)<<0));\
		DMA_AXI4CR5_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR5_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR5_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR5_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR5_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR5_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR5_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR5_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR5_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR5_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR5_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR5_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR5_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR5_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR5_ARQOS_Mask)<<16));\
		DMA_AXI4CR5_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR5_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR5_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR5_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR4_RgOffAddr ((BASE_ADDRESS + 0x1364))

#define DMA_AXI4CR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR4_RgOffAddr));\
} while(0)

#define DMA_AXI4CR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR4_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR4_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR4_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR4_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR4_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR4_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR4_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR4_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR4_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR4_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR4_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR4_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR4_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR4_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR4_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR4_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR4_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR4_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR4_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR4_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR4_AWQOS_Mask)<<0));\
		DMA_AXI4CR4_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR4_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR4_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR4_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR4_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR4_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR4_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR4_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR4_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR4_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR4_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR4_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR4_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR4_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR4_ARQOS_Mask)<<16));\
		DMA_AXI4CR4_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR4_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR4_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR4_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR3_RgOffAddr ((BASE_ADDRESS + 0x12e4))

#define DMA_AXI4CR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR3_RgOffAddr));\
} while(0)

#define DMA_AXI4CR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR3_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR3_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR3_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR3_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR3_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR3_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR3_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR3_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR3_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR3_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR3_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR3_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR3_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR3_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR3_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR3_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR3_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR3_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR3_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR3_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR3_AWQOS_Mask)<<0));\
		DMA_AXI4CR3_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR3_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR3_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR3_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR3_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR3_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR3_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR3_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR3_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR3_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR3_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR3_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR3_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR3_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR3_ARQOS_Mask)<<16));\
		DMA_AXI4CR3_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR3_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR3_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR3_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR2_RgOffAddr ((BASE_ADDRESS + 0x1264))

#define DMA_AXI4CR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR2_RgOffAddr));\
} while(0)

#define DMA_AXI4CR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR2_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR2_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR2_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR2_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR2_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR2_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR2_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR2_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR2_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR2_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR2_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR2_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR2_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR2_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR2_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR2_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR2_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR2_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR2_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR2_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR2_AWQOS_Mask)<<0));\
		DMA_AXI4CR2_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR2_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR2_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR2_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR2_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR2_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR2_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR2_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR2_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR2_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR2_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR2_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR2_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR2_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR2_ARQOS_Mask)<<16));\
		DMA_AXI4CR2_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR2_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR2_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR2_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR1_RgOffAddr ((BASE_ADDRESS + 0x11e4))

#define DMA_AXI4CR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR1_RgOffAddr));\
} while(0)

#define DMA_AXI4CR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR1_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR1_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR1_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR1_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR1_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR1_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR1_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR1_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR1_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR1_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR1_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR1_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR1_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR1_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR1_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR1_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR1_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR1_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR1_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR1_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR1_AWQOS_Mask)<<0));\
		DMA_AXI4CR1_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR1_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR1_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR1_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR1_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR1_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR1_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR1_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR1_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR1_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR1_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR1_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR1_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR1_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR1_ARQOS_Mask)<<16));\
		DMA_AXI4CR1_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR1_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR1_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR1_ARQOS_Mask);\
} while(0)


#define DMA_AXI4CR0_RgOffAddr ((BASE_ADDRESS + 0x1164))

#define DMA_AXI4CR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_AXI4CR0_RgOffAddr));\
} while(0)

#define DMA_AXI4CR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_AXI4CR0_RgOffAddr));\
} while(0)

/*#define  DMA_AXI4CR0_Mask_4 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR0_Mask_4 (ULONG)(0xfff)

/*#define DMA_AXI4CR0_RES_Wr_Mask_4 (ULONG)(~((~(~0<<(12)))<<(4)))*/

#define DMA_AXI4CR0_RES_Wr_Mask_4 (ULONG)(0xffff000f)

/*#define  DMA_AXI4CR0_Mask_20 (ULONG)(~(~0<<(12)))*/

#define  DMA_AXI4CR0_Mask_20 (ULONG)(0xfff)

/*#define DMA_AXI4CR0_RES_Wr_Mask_20 (ULONG)(~((~(~0<<(12)))<<(20)))*/

#define DMA_AXI4CR0_RES_Wr_Mask_20 (ULONG)(0xfffff)

/*#define DMA_AXI4CR0_AWQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR0_AWQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR0_AWQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (0)))*/

#define DMA_AXI4CR0_AWQOS_Wr_Mask (ULONG)(0xfffffff0)

#define DMA_AXI4CR0_AWQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR0_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR0_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR0_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR0_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR0_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR0_AWQOS_Wr_Mask) | ((data & DMA_AXI4CR0_AWQOS_Mask)<<0));\
		DMA_AXI4CR0_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR0_AWQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_AXI4CR0_AWQOS_Mask);\
} while(0)

/*#define DMA_AXI4CR0_ARQOS_Mask (ULONG)(~(~0<<(4)))*/

#define DMA_AXI4CR0_ARQOS_Mask (ULONG)(0xf)

/*#define DMA_AXI4CR0_ARQOS_Wr_Mask (ULONG)(~((~(~0 << (4))) << (16)))*/

#define DMA_AXI4CR0_ARQOS_Wr_Mask (ULONG)(0xfff0ffff)

#define DMA_AXI4CR0_ARQOS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_AXI4CR0_RgRd(pdata, v);\
		v = (v & (DMA_AXI4CR0_RES_Wr_Mask_4))|((( 0) & (DMA_AXI4CR0_Mask_4))<<4);\
		v = (v & (DMA_AXI4CR0_RES_Wr_Mask_20))|((( 0) & (DMA_AXI4CR0_Mask_20))<<20);\
		v = ((v & DMA_AXI4CR0_ARQOS_Wr_Mask) | ((data & DMA_AXI4CR0_ARQOS_Mask)<<16));\
		DMA_AXI4CR0_RgWr(pdata, v);\
} while(0)

#define DMA_AXI4CR0_ARQOS_UdfRd(pdata, data) do {\
		DMA_AXI4CR0_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_AXI4CR0_ARQOS_Mask);\
} while(0)


#define DMA_RCR7_RgOffAddr ((BASE_ADDRESS + 0x1488))

#define DMA_RCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR7_RgOffAddr));\
} while(0)

#define DMA_RCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR7_RgOffAddr));\
} while(0)

/*#define  DMA_RCR7_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR7_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR7_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR7_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR7_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR7_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR7_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR7_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR7_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR7_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR7_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR7_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR7_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR7_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR7_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_ST_Wr_Mask) | ((data & DMA_RCR7_ST_Mask)<<0));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_ST_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR7_ST_Mask);\
} while(0)

/*#define DMA_RCR7_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR7_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR7_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR7_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR7_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_RBSZ_Wr_Mask) | ((data & DMA_RCR7_RBSZ_Mask)<<1));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR7_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR7_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR7_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR7_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR7_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR7_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_PBL_Wr_Mask) | ((data & DMA_RCR7_PBL_Mask)<<16));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_PBL_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR7_PBL_Mask);\
} while(0)

/*#define DMA_RCR7_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR7_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR7_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR7_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_RES_Wr_Mask) | ((data & DMA_RCR7_RES_Mask)<<25));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_RES_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR7_RES_Mask);\
} while(0)

/*#define DMA_RCR7_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR7_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR7_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR7_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_DFF_Wr_Mask) | ((data & DMA_RCR7_DFF_Mask)<<26));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_DFF_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR7_DFF_Mask);\
} while(0)

/*#define DMA_RCR7_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR7_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR7_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR7_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR7_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR7_RgRd(pdata, v);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_15))|((( 0) & (DMA_RCR7_Mask_15))<<15);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_22))|((( 0) & (DMA_RCR7_Mask_22))<<22);\
		v = (v & (DMA_RCR7_RES_Wr_Mask_28))|((( 0) & (DMA_RCR7_Mask_28))<<28);\
		v = ((v & DMA_RCR7_MAMS_Wr_Mask) | ((data & DMA_RCR7_MAMS_Mask)<<27));\
		DMA_RCR7_RgWr(pdata, v);\
} while(0)

#define DMA_RCR7_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR7_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR7_MAMS_Mask);\
} while(0)


#define DMA_RCR6_RgOffAddr ((BASE_ADDRESS + 0x1408))

#define DMA_RCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR6_RgOffAddr));\
} while(0)

#define DMA_RCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR6_RgOffAddr));\
} while(0)

/*#define  DMA_RCR6_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR6_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR6_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR6_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR6_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR6_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR6_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR6_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR6_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR6_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR6_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR6_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR6_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR6_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR6_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_ST_Wr_Mask) | ((data & DMA_RCR6_ST_Mask)<<0));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_ST_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR6_ST_Mask);\
} while(0)

/*#define DMA_RCR6_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR6_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR6_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR6_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR6_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_RBSZ_Wr_Mask) | ((data & DMA_RCR6_RBSZ_Mask)<<1));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR6_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR6_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR6_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR6_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR6_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR6_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_PBL_Wr_Mask) | ((data & DMA_RCR6_PBL_Mask)<<16));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_PBL_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR6_PBL_Mask);\
} while(0)

/*#define DMA_RCR6_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR6_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR6_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR6_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_RES_Wr_Mask) | ((data & DMA_RCR6_RES_Mask)<<25));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_RES_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR6_RES_Mask);\
} while(0)

/*#define DMA_RCR6_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR6_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR6_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR6_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_DFF_Wr_Mask) | ((data & DMA_RCR6_DFF_Mask)<<26));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_DFF_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR6_DFF_Mask);\
} while(0)

/*#define DMA_RCR6_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR6_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR6_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR6_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR6_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR6_RgRd(pdata, v);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_15))|((( 0) & (DMA_RCR6_Mask_15))<<15);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_22))|((( 0) & (DMA_RCR6_Mask_22))<<22);\
		v = (v & (DMA_RCR6_RES_Wr_Mask_28))|((( 0) & (DMA_RCR6_Mask_28))<<28);\
		v = ((v & DMA_RCR6_MAMS_Wr_Mask) | ((data & DMA_RCR6_MAMS_Mask)<<27));\
		DMA_RCR6_RgWr(pdata, v);\
} while(0)

#define DMA_RCR6_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR6_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR6_MAMS_Mask);\
} while(0)


#define DMA_RCR5_RgOffAddr ((BASE_ADDRESS + 0x1388))

#define DMA_RCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR5_RgOffAddr));\
} while(0)

#define DMA_RCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR5_RgOffAddr));\
} while(0)

/*#define  DMA_RCR5_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR5_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR5_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR5_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR5_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR5_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR5_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR5_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR5_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR5_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR5_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR5_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR5_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR5_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR5_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_ST_Wr_Mask) | ((data & DMA_RCR5_ST_Mask)<<0));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_ST_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR5_ST_Mask);\
} while(0)

/*#define DMA_RCR5_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR5_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR5_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR5_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR5_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_RBSZ_Wr_Mask) | ((data & DMA_RCR5_RBSZ_Mask)<<1));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR5_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR5_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR5_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR5_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR5_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR5_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_PBL_Wr_Mask) | ((data & DMA_RCR5_PBL_Mask)<<16));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_PBL_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR5_PBL_Mask);\
} while(0)

/*#define DMA_RCR5_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR5_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR5_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR5_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_RES_Wr_Mask) | ((data & DMA_RCR5_RES_Mask)<<25));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_RES_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR5_RES_Mask);\
} while(0)

/*#define DMA_RCR5_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR5_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR5_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR5_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_DFF_Wr_Mask) | ((data & DMA_RCR5_DFF_Mask)<<26));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_DFF_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR5_DFF_Mask);\
} while(0)

/*#define DMA_RCR5_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR5_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR5_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR5_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR5_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR5_RgRd(pdata, v);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_15))|((( 0) & (DMA_RCR5_Mask_15))<<15);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_22))|((( 0) & (DMA_RCR5_Mask_22))<<22);\
		v = (v & (DMA_RCR5_RES_Wr_Mask_28))|((( 0) & (DMA_RCR5_Mask_28))<<28);\
		v = ((v & DMA_RCR5_MAMS_Wr_Mask) | ((data & DMA_RCR5_MAMS_Mask)<<27));\
		DMA_RCR5_RgWr(pdata, v);\
} while(0)

#define DMA_RCR5_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR5_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR5_MAMS_Mask);\
} while(0)


#define DMA_RCR4_RgOffAddr ((BASE_ADDRESS + 0x1308))

#define DMA_RCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR4_RgOffAddr));\
} while(0)

#define DMA_RCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR4_RgOffAddr));\
} while(0)

/*#define  DMA_RCR4_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR4_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR4_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR4_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR4_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR4_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR4_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR4_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR4_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR4_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR4_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR4_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR4_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR4_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR4_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_ST_Wr_Mask) | ((data & DMA_RCR4_ST_Mask)<<0));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_ST_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR4_ST_Mask);\
} while(0)

/*#define DMA_RCR4_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR4_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR4_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR4_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR4_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_RBSZ_Wr_Mask) | ((data & DMA_RCR4_RBSZ_Mask)<<1));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR4_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR4_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR4_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR4_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR4_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR4_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_PBL_Wr_Mask) | ((data & DMA_RCR4_PBL_Mask)<<16));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_PBL_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR4_PBL_Mask);\
} while(0)

/*#define DMA_RCR4_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR4_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR4_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR4_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_RES_Wr_Mask) | ((data & DMA_RCR4_RES_Mask)<<25));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_RES_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR4_RES_Mask);\
} while(0)

/*#define DMA_RCR4_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR4_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR4_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR4_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_DFF_Wr_Mask) | ((data & DMA_RCR4_DFF_Mask)<<26));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_DFF_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR4_DFF_Mask);\
} while(0)

/*#define DMA_RCR4_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR4_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR4_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR4_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR4_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR4_RgRd(pdata, v);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_15))|((( 0) & (DMA_RCR4_Mask_15))<<15);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_22))|((( 0) & (DMA_RCR4_Mask_22))<<22);\
		v = (v & (DMA_RCR4_RES_Wr_Mask_28))|((( 0) & (DMA_RCR4_Mask_28))<<28);\
		v = ((v & DMA_RCR4_MAMS_Wr_Mask) | ((data & DMA_RCR4_MAMS_Mask)<<27));\
		DMA_RCR4_RgWr(pdata, v);\
} while(0)

#define DMA_RCR4_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR4_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR4_MAMS_Mask);\
} while(0)


#define DMA_RCR3_RgOffAddr ((BASE_ADDRESS + 0x1288))

#define DMA_RCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR3_RgOffAddr));\
} while(0)

#define DMA_RCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR3_RgOffAddr));\
} while(0)

/*#define  DMA_RCR3_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR3_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR3_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR3_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR3_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR3_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR3_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR3_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR3_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR3_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR3_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR3_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR3_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR3_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR3_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_ST_Wr_Mask) | ((data & DMA_RCR3_ST_Mask)<<0));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_ST_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR3_ST_Mask);\
} while(0)

/*#define DMA_RCR3_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR3_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR3_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR3_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR3_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_RBSZ_Wr_Mask) | ((data & DMA_RCR3_RBSZ_Mask)<<1));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR3_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR3_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR3_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR3_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR3_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR3_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_PBL_Wr_Mask) | ((data & DMA_RCR3_PBL_Mask)<<16));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_PBL_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR3_PBL_Mask);\
} while(0)

/*#define DMA_RCR3_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR3_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR3_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR3_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_RES_Wr_Mask) | ((data & DMA_RCR3_RES_Mask)<<25));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_RES_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR3_RES_Mask);\
} while(0)

/*#define DMA_RCR3_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR3_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR3_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR3_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_DFF_Wr_Mask) | ((data & DMA_RCR3_DFF_Mask)<<26));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_DFF_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR3_DFF_Mask);\
} while(0)

/*#define DMA_RCR3_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR3_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR3_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR3_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR3_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR3_RgRd(pdata, v);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_15))|((( 0) & (DMA_RCR3_Mask_15))<<15);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_22))|((( 0) & (DMA_RCR3_Mask_22))<<22);\
		v = (v & (DMA_RCR3_RES_Wr_Mask_28))|((( 0) & (DMA_RCR3_Mask_28))<<28);\
		v = ((v & DMA_RCR3_MAMS_Wr_Mask) | ((data & DMA_RCR3_MAMS_Mask)<<27));\
		DMA_RCR3_RgWr(pdata, v);\
} while(0)

#define DMA_RCR3_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR3_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR3_MAMS_Mask);\
} while(0)


#define DMA_RCR2_RgOffAddr ((BASE_ADDRESS + 0x1208))

#define DMA_RCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR2_RgOffAddr));\
} while(0)

#define DMA_RCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR2_RgOffAddr));\
} while(0)

/*#define  DMA_RCR2_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR2_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR2_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR2_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR2_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR2_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR2_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR2_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR2_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR2_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR2_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR2_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR2_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR2_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR2_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_ST_Wr_Mask) | ((data & DMA_RCR2_ST_Mask)<<0));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_ST_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR2_ST_Mask);\
} while(0)

/*#define DMA_RCR2_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR2_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR2_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR2_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR2_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_RBSZ_Wr_Mask) | ((data & DMA_RCR2_RBSZ_Mask)<<1));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR2_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR2_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR2_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR2_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR2_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR2_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_PBL_Wr_Mask) | ((data & DMA_RCR2_PBL_Mask)<<16));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_PBL_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR2_PBL_Mask);\
} while(0)

/*#define DMA_RCR2_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR2_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR2_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR2_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_RES_Wr_Mask) | ((data & DMA_RCR2_RES_Mask)<<25));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_RES_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR2_RES_Mask);\
} while(0)

/*#define DMA_RCR2_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR2_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR2_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR2_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_DFF_Wr_Mask) | ((data & DMA_RCR2_DFF_Mask)<<26));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_DFF_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR2_DFF_Mask);\
} while(0)

/*#define DMA_RCR2_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR2_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR2_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR2_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR2_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR2_RgRd(pdata, v);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_15))|((( 0) & (DMA_RCR2_Mask_15))<<15);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_22))|((( 0) & (DMA_RCR2_Mask_22))<<22);\
		v = (v & (DMA_RCR2_RES_Wr_Mask_28))|((( 0) & (DMA_RCR2_Mask_28))<<28);\
		v = ((v & DMA_RCR2_MAMS_Wr_Mask) | ((data & DMA_RCR2_MAMS_Mask)<<27));\
		DMA_RCR2_RgWr(pdata, v);\
} while(0)

#define DMA_RCR2_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR2_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR2_MAMS_Mask);\
} while(0)


#define DMA_RCR1_RgOffAddr ((BASE_ADDRESS + 0x1188))

#define DMA_RCR1_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR1_RgOffAddr));\
} while(0)

#define DMA_RCR1_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR1_RgOffAddr));\
} while(0)

/*#define  DMA_RCR1_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR1_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR1_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR1_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR1_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR1_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR1_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR1_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR1_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR1_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR1_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR1_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR1_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR1_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR1_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR1_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_ST_Wr_Mask) | ((data & DMA_RCR1_ST_Mask)<<0));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_ST_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR1_ST_Mask);\
} while(0)

/*#define DMA_RCR1_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR1_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR1_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR1_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR1_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_RBSZ_Wr_Mask) | ((data & DMA_RCR1_RBSZ_Mask)<<1));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR1_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR1_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR1_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR1_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR1_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR1_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_PBL_Wr_Mask) | ((data & DMA_RCR1_PBL_Mask)<<16));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_PBL_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR1_PBL_Mask);\
} while(0)

/*#define DMA_RCR1_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR1_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR1_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR1_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_RES_Wr_Mask) | ((data & DMA_RCR1_RES_Mask)<<25));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_RES_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR1_RES_Mask);\
} while(0)

/*#define DMA_RCR1_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR1_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR1_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR1_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_DFF_Wr_Mask) | ((data & DMA_RCR1_DFF_Mask)<<26));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_DFF_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR1_DFF_Mask);\
} while(0)

/*#define DMA_RCR1_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR1_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR1_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR1_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR1_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR1_RgRd(pdata, v);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_15))|((( 0) & (DMA_RCR1_Mask_15))<<15);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_22))|((( 0) & (DMA_RCR1_Mask_22))<<22);\
		v = (v & (DMA_RCR1_RES_Wr_Mask_28))|((( 0) & (DMA_RCR1_Mask_28))<<28);\
		v = ((v & DMA_RCR1_MAMS_Wr_Mask) | ((data & DMA_RCR1_MAMS_Mask)<<27));\
		DMA_RCR1_RgWr(pdata, v);\
} while(0)

#define DMA_RCR1_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR1_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR1_MAMS_Mask);\
} while(0)


#define DMA_RCR0_RgOffAddr ((BASE_ADDRESS + 0x1108))

#define DMA_RCR0_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_RCR0_RgOffAddr));\
} while(0)

#define DMA_RCR0_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_RCR0_RgOffAddr));\
} while(0)

/*#define  DMA_RCR0_Mask_15 (ULONG)(~(~0<<(1)))*/

#define  DMA_RCR0_Mask_15 (ULONG)(0x1)

/*#define DMA_RCR0_RES_Wr_Mask_15 (ULONG)(~((~(~0<<(1)))<<(15)))*/

#define DMA_RCR0_RES_Wr_Mask_15 (ULONG)(0xffff7fff)

/*#define  DMA_RCR0_Mask_22 (ULONG)(~(~0<<(3)))*/

#define  DMA_RCR0_Mask_22 (ULONG)(0x7)

/*#define DMA_RCR0_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(3)))<<(22)))*/

#define DMA_RCR0_RES_Wr_Mask_22 (ULONG)(0xfe3fffff)

/*#define  DMA_RCR0_Mask_28 (ULONG)(~(~0<<(4)))*/

#define  DMA_RCR0_Mask_28 (ULONG)(0xf)

/*#define DMA_RCR0_RES_Wr_Mask_28 (ULONG)(~((~(~0<<(4)))<<(28)))*/

#define DMA_RCR0_RES_Wr_Mask_28 (ULONG)(0xfffffff)

/*#define DMA_RCR0_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_ST_Mask (ULONG)(0x1)

/*#define DMA_RCR0_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_RCR0_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_RCR0_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_ST_Wr_Mask) | ((data & DMA_RCR0_ST_Mask)<<0));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_ST_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_RCR0_ST_Mask);\
} while(0)

/*#define DMA_RCR0_RBSZ_Mask (ULONG)(~(~0<<(14)))*/

#define DMA_RCR0_RBSZ_Mask (ULONG)(0x3fff)

/*#define DMA_RCR0_RBSZ_Wr_Mask (ULONG)(~((~(~0 << (14))) << (1)))*/

#define DMA_RCR0_RBSZ_Wr_Mask (ULONG)(0xffff8001)

#define DMA_RCR0_RBSZ_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_RBSZ_Wr_Mask) | ((data & DMA_RCR0_RBSZ_Mask)<<1));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_RBSZ_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_RCR0_RBSZ_Mask);\
} while(0)

/*#define DMA_RCR0_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_RCR0_PBL_Mask (ULONG)(0x3f)

/*#define DMA_RCR0_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_RCR0_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_RCR0_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_PBL_Wr_Mask) | ((data & DMA_RCR0_PBL_Mask)<<16));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_PBL_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_RCR0_PBL_Mask);\
} while(0)

/*#define DMA_RCR0_RES_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_RES_Mask (ULONG)(0x1)

/*#define DMA_RCR0_RES_Wr_Mask (ULONG)(~((~(~0 << (1))) << (25)))*/

#define DMA_RCR0_RES_Wr_Mask (ULONG)(0xfdffffff)

#define DMA_RCR0_RES_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_RES_Wr_Mask) | ((data & DMA_RCR0_RES_Mask)<<25));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_RES_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 25) & DMA_RCR0_RES_Mask);\
} while(0)

/*#define DMA_RCR0_DFF_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_DFF_Mask (ULONG)(0x1)

/*#define DMA_RCR0_DFF_Wr_Mask (ULONG)(~((~(~0 << (1))) << (26)))*/

#define DMA_RCR0_DFF_Wr_Mask (ULONG)(0xfbffffff)

#define DMA_RCR0_DFF_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_DFF_Wr_Mask) | ((data & DMA_RCR0_DFF_Mask)<<26));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_DFF_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 26) & DMA_RCR0_DFF_Mask);\
} while(0)

/*#define DMA_RCR0_MAMS_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_RCR0_MAMS_Mask (ULONG)(0x1)

/*#define DMA_RCR0_MAMS_Wr_Mask (ULONG)(~((~(~0 << (1))) << (27)))*/

#define DMA_RCR0_MAMS_Wr_Mask (ULONG)(0xf7ffffff)

#define DMA_RCR0_MAMS_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_RCR0_RgRd(pdata, v);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_15))|((( 0) & (DMA_RCR0_Mask_15))<<15);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_22))|((( 0) & (DMA_RCR0_Mask_22))<<22);\
		v = (v & (DMA_RCR0_RES_Wr_Mask_28))|((( 0) & (DMA_RCR0_Mask_28))<<28);\
		v = ((v & DMA_RCR0_MAMS_Wr_Mask) | ((data & DMA_RCR0_MAMS_Mask)<<27));\
		DMA_RCR0_RgWr(pdata, v);\
} while(0)

#define DMA_RCR0_MAMS_UdfRd(pdata, data) do {\
		DMA_RCR0_RgRd(pdata, data);\
		data = ((data >> 27) & DMA_RCR0_MAMS_Mask);\
} while(0)


#define DMA_TCR7_RgOffAddr ((BASE_ADDRESS + 0x1484))

#define DMA_TCR7_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR7_RgOffAddr));\
} while(0)

#define DMA_TCR7_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR7_RgOffAddr));\
} while(0)

/*#define  DMA_TCR7_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR7_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR7_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR7_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR7_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR7_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR7_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR7_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR7_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR7_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR7_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR7_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR7_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR7_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR7_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR7_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR7_RgRd(pdata, v);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_5))|((( 0) & (DMA_TCR7_Mask_5))<<5);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_13))|((( 0) & (DMA_TCR7_Mask_13))<<13);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_22))|((( 0) & (DMA_TCR7_Mask_22))<<22);\
		v = ((v & DMA_TCR7_ST_Wr_Mask) | ((data & DMA_TCR7_ST_Mask)<<0));\
		DMA_TCR7_RgWr(pdata, v);\
} while(0)

#define DMA_TCR7_ST_UdfRd(pdata, data) do {\
		DMA_TCR7_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR7_ST_Mask);\
} while(0)

/*#define DMA_TCR7_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR7_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR7_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR7_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR7_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR7_RgRd(pdata, v);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_5))|((( 0) & (DMA_TCR7_Mask_5))<<5);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_13))|((( 0) & (DMA_TCR7_Mask_13))<<13);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_22))|((( 0) & (DMA_TCR7_Mask_22))<<22);\
		v = ((v & DMA_TCR7_TCW_Wr_Mask) | ((data & DMA_TCR7_TCW_Mask)<<1));\
		DMA_TCR7_RgWr(pdata, v);\
} while(0)

#define DMA_TCR7_TCW_UdfRd(pdata, data) do {\
		DMA_TCR7_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR7_TCW_Mask);\
} while(0)

/*#define DMA_TCR7_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR7_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR7_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR7_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR7_RgRd(pdata, v);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_5))|((( 0) & (DMA_TCR7_Mask_5))<<5);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_13))|((( 0) & (DMA_TCR7_Mask_13))<<13);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_22))|((( 0) & (DMA_TCR7_Mask_22))<<22);\
		v = ((v & DMA_TCR7_OSP_Wr_Mask) | ((data & DMA_TCR7_OSP_Mask)<<4));\
		DMA_TCR7_RgWr(pdata, v);\
} while(0)

#define DMA_TCR7_OSP_UdfRd(pdata, data) do {\
		DMA_TCR7_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR7_OSP_Mask);\
} while(0)

/*#define DMA_TCR7_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR7_TSE_Mask (ULONG)(0x1)

/*#define DMA_TCR7_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR7_TSE_Wr_Mask (ULONG)(0xffffefff)

#define DMA_TCR7_TSE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR7_RgRd(pdata, v);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_5))|((( 0) & (DMA_TCR7_Mask_5))<<5);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_13))|((( 0) & (DMA_TCR7_Mask_13))<<13);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_22))|((( 0) & (DMA_TCR7_Mask_22))<<22);\
		v = ((v & DMA_TCR7_TSE_Wr_Mask) | ((data & DMA_TCR7_TSE_Mask)<<12));\
		DMA_TCR7_RgWr(pdata, v);\
} while(0)

#define DMA_TCR7_TSE_UdfRd(pdata, data) do {\
		DMA_TCR7_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_TCR7_TSE_Mask);\
} while(0)

/*#define DMA_TCR7_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR7_PBL_Mask (ULONG)(0x3f)

/*#define DMA_TCR7_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR7_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_TCR7_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR7_RgRd(pdata, v);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_5))|((( 0) & (DMA_TCR7_Mask_5))<<5);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_13))|((( 0) & (DMA_TCR7_Mask_13))<<13);\
		v = (v & (DMA_TCR7_RES_Wr_Mask_22))|((( 0) & (DMA_TCR7_Mask_22))<<22);\
		v = ((v & DMA_TCR7_PBL_Wr_Mask) | ((data & DMA_TCR7_PBL_Mask)<<16));\
		DMA_TCR7_RgWr(pdata, v);\
} while(0)

#define DMA_TCR7_PBL_UdfRd(pdata, data) do {\
		DMA_TCR7_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_TCR7_PBL_Mask);\
} while(0)


#define DMA_TCR6_RgOffAddr ((BASE_ADDRESS + 0x1404))

#define DMA_TCR6_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR6_RgOffAddr));\
} while(0)

#define DMA_TCR6_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR6_RgOffAddr));\
} while(0)

/*#define  DMA_TCR6_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR6_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR6_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR6_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR6_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR6_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR6_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR6_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR6_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR6_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR6_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR6_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR6_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR6_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR6_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR6_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR6_RgRd(pdata, v);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_5))|((( 0) & (DMA_TCR6_Mask_5))<<5);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_13))|((( 0) & (DMA_TCR6_Mask_13))<<13);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_22))|((( 0) & (DMA_TCR6_Mask_22))<<22);\
		v = ((v & DMA_TCR6_ST_Wr_Mask) | ((data & DMA_TCR6_ST_Mask)<<0));\
		DMA_TCR6_RgWr(pdata, v);\
} while(0)

#define DMA_TCR6_ST_UdfRd(pdata, data) do {\
		DMA_TCR6_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR6_ST_Mask);\
} while(0)

/*#define DMA_TCR6_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR6_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR6_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR6_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR6_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR6_RgRd(pdata, v);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_5))|((( 0) & (DMA_TCR6_Mask_5))<<5);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_13))|((( 0) & (DMA_TCR6_Mask_13))<<13);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_22))|((( 0) & (DMA_TCR6_Mask_22))<<22);\
		v = ((v & DMA_TCR6_TCW_Wr_Mask) | ((data & DMA_TCR6_TCW_Mask)<<1));\
		DMA_TCR6_RgWr(pdata, v);\
} while(0)

#define DMA_TCR6_TCW_UdfRd(pdata, data) do {\
		DMA_TCR6_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR6_TCW_Mask);\
} while(0)

/*#define DMA_TCR6_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR6_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR6_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR6_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR6_RgRd(pdata, v);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_5))|((( 0) & (DMA_TCR6_Mask_5))<<5);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_13))|((( 0) & (DMA_TCR6_Mask_13))<<13);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_22))|((( 0) & (DMA_TCR6_Mask_22))<<22);\
		v = ((v & DMA_TCR6_OSP_Wr_Mask) | ((data & DMA_TCR6_OSP_Mask)<<4));\
		DMA_TCR6_RgWr(pdata, v);\
} while(0)

#define DMA_TCR6_OSP_UdfRd(pdata, data) do {\
		DMA_TCR6_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR6_OSP_Mask);\
} while(0)

/*#define DMA_TCR6_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR6_TSE_Mask (ULONG)(0x1)

/*#define DMA_TCR6_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR6_TSE_Wr_Mask (ULONG)(0xffffefff)

#define DMA_TCR6_TSE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR6_RgRd(pdata, v);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_5))|((( 0) & (DMA_TCR6_Mask_5))<<5);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_13))|((( 0) & (DMA_TCR6_Mask_13))<<13);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_22))|((( 0) & (DMA_TCR6_Mask_22))<<22);\
		v = ((v & DMA_TCR6_TSE_Wr_Mask) | ((data & DMA_TCR6_TSE_Mask)<<12));\
		DMA_TCR6_RgWr(pdata, v);\
} while(0)

#define DMA_TCR6_TSE_UdfRd(pdata, data) do {\
		DMA_TCR6_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_TCR6_TSE_Mask);\
} while(0)

/*#define DMA_TCR6_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR6_PBL_Mask (ULONG)(0x3f)

/*#define DMA_TCR6_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR6_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_TCR6_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR6_RgRd(pdata, v);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_5))|((( 0) & (DMA_TCR6_Mask_5))<<5);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_13))|((( 0) & (DMA_TCR6_Mask_13))<<13);\
		v = (v & (DMA_TCR6_RES_Wr_Mask_22))|((( 0) & (DMA_TCR6_Mask_22))<<22);\
		v = ((v & DMA_TCR6_PBL_Wr_Mask) | ((data & DMA_TCR6_PBL_Mask)<<16));\
		DMA_TCR6_RgWr(pdata, v);\
} while(0)

#define DMA_TCR6_PBL_UdfRd(pdata, data) do {\
		DMA_TCR6_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_TCR6_PBL_Mask);\
} while(0)


#define DMA_TCR5_RgOffAddr ((BASE_ADDRESS + 0x1384))

#define DMA_TCR5_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR5_RgOffAddr));\
} while(0)

#define DMA_TCR5_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR5_RgOffAddr));\
} while(0)

/*#define  DMA_TCR5_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR5_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR5_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR5_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR5_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR5_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR5_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR5_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR5_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR5_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR5_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR5_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR5_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR5_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR5_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR5_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR5_RgRd(pdata, v);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_5))|((( 0) & (DMA_TCR5_Mask_5))<<5);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_13))|((( 0) & (DMA_TCR5_Mask_13))<<13);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_22))|((( 0) & (DMA_TCR5_Mask_22))<<22);\
		v = ((v & DMA_TCR5_ST_Wr_Mask) | ((data & DMA_TCR5_ST_Mask)<<0));\
		DMA_TCR5_RgWr(pdata, v);\
} while(0)

#define DMA_TCR5_ST_UdfRd(pdata, data) do {\
		DMA_TCR5_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR5_ST_Mask);\
} while(0)

/*#define DMA_TCR5_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR5_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR5_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR5_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR5_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR5_RgRd(pdata, v);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_5))|((( 0) & (DMA_TCR5_Mask_5))<<5);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_13))|((( 0) & (DMA_TCR5_Mask_13))<<13);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_22))|((( 0) & (DMA_TCR5_Mask_22))<<22);\
		v = ((v & DMA_TCR5_TCW_Wr_Mask) | ((data & DMA_TCR5_TCW_Mask)<<1));\
		DMA_TCR5_RgWr(pdata, v);\
} while(0)

#define DMA_TCR5_TCW_UdfRd(pdata, data) do {\
		DMA_TCR5_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR5_TCW_Mask);\
} while(0)

/*#define DMA_TCR5_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR5_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR5_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR5_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR5_RgRd(pdata, v);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_5))|((( 0) & (DMA_TCR5_Mask_5))<<5);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_13))|((( 0) & (DMA_TCR5_Mask_13))<<13);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_22))|((( 0) & (DMA_TCR5_Mask_22))<<22);\
		v = ((v & DMA_TCR5_OSP_Wr_Mask) | ((data & DMA_TCR5_OSP_Mask)<<4));\
		DMA_TCR5_RgWr(pdata, v);\
} while(0)

#define DMA_TCR5_OSP_UdfRd(pdata, data) do {\
		DMA_TCR5_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR5_OSP_Mask);\
} while(0)

/*#define DMA_TCR5_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR5_TSE_Mask (ULONG)(0x1)

/*#define DMA_TCR5_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR5_TSE_Wr_Mask (ULONG)(0xffffefff)

#define DMA_TCR5_TSE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR5_RgRd(pdata, v);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_5))|((( 0) & (DMA_TCR5_Mask_5))<<5);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_13))|((( 0) & (DMA_TCR5_Mask_13))<<13);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_22))|((( 0) & (DMA_TCR5_Mask_22))<<22);\
		v = ((v & DMA_TCR5_TSE_Wr_Mask) | ((data & DMA_TCR5_TSE_Mask)<<12));\
		DMA_TCR5_RgWr(pdata, v);\
} while(0)

#define DMA_TCR5_TSE_UdfRd(pdata, data) do {\
		DMA_TCR5_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_TCR5_TSE_Mask);\
} while(0)

/*#define DMA_TCR5_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR5_PBL_Mask (ULONG)(0x3f)

/*#define DMA_TCR5_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR5_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_TCR5_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR5_RgRd(pdata, v);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_5))|((( 0) & (DMA_TCR5_Mask_5))<<5);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_13))|((( 0) & (DMA_TCR5_Mask_13))<<13);\
		v = (v & (DMA_TCR5_RES_Wr_Mask_22))|((( 0) & (DMA_TCR5_Mask_22))<<22);\
		v = ((v & DMA_TCR5_PBL_Wr_Mask) | ((data & DMA_TCR5_PBL_Mask)<<16));\
		DMA_TCR5_RgWr(pdata, v);\
} while(0)

#define DMA_TCR5_PBL_UdfRd(pdata, data) do {\
		DMA_TCR5_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_TCR5_PBL_Mask);\
} while(0)


#define DMA_TCR4_RgOffAddr ((BASE_ADDRESS + 0x1304))

#define DMA_TCR4_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR4_RgOffAddr));\
} while(0)

#define DMA_TCR4_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR4_RgOffAddr));\
} while(0)

/*#define  DMA_TCR4_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR4_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR4_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR4_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR4_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR4_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR4_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR4_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR4_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR4_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR4_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR4_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR4_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR4_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR4_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR4_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR4_RgRd(pdata, v);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_5))|((( 0) & (DMA_TCR4_Mask_5))<<5);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_13))|((( 0) & (DMA_TCR4_Mask_13))<<13);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_22))|((( 0) & (DMA_TCR4_Mask_22))<<22);\
		v = ((v & DMA_TCR4_ST_Wr_Mask) | ((data & DMA_TCR4_ST_Mask)<<0));\
		DMA_TCR4_RgWr(pdata, v);\
} while(0)

#define DMA_TCR4_ST_UdfRd(pdata, data) do {\
		DMA_TCR4_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR4_ST_Mask);\
} while(0)

/*#define DMA_TCR4_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR4_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR4_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR4_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR4_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR4_RgRd(pdata, v);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_5))|((( 0) & (DMA_TCR4_Mask_5))<<5);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_13))|((( 0) & (DMA_TCR4_Mask_13))<<13);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_22))|((( 0) & (DMA_TCR4_Mask_22))<<22);\
		v = ((v & DMA_TCR4_TCW_Wr_Mask) | ((data & DMA_TCR4_TCW_Mask)<<1));\
		DMA_TCR4_RgWr(pdata, v);\
} while(0)

#define DMA_TCR4_TCW_UdfRd(pdata, data) do {\
		DMA_TCR4_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR4_TCW_Mask);\
} while(0)

/*#define DMA_TCR4_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR4_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR4_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR4_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR4_RgRd(pdata, v);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_5))|((( 0) & (DMA_TCR4_Mask_5))<<5);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_13))|((( 0) & (DMA_TCR4_Mask_13))<<13);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_22))|((( 0) & (DMA_TCR4_Mask_22))<<22);\
		v = ((v & DMA_TCR4_OSP_Wr_Mask) | ((data & DMA_TCR4_OSP_Mask)<<4));\
		DMA_TCR4_RgWr(pdata, v);\
} while(0)

#define DMA_TCR4_OSP_UdfRd(pdata, data) do {\
		DMA_TCR4_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR4_OSP_Mask);\
} while(0)

/*#define DMA_TCR4_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR4_TSE_Mask (ULONG)(0x1)

/*#define DMA_TCR4_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR4_TSE_Wr_Mask (ULONG)(0xffffefff)

#define DMA_TCR4_TSE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR4_RgRd(pdata, v);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_5))|((( 0) & (DMA_TCR4_Mask_5))<<5);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_13))|((( 0) & (DMA_TCR4_Mask_13))<<13);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_22))|((( 0) & (DMA_TCR4_Mask_22))<<22);\
		v = ((v & DMA_TCR4_TSE_Wr_Mask) | ((data & DMA_TCR4_TSE_Mask)<<12));\
		DMA_TCR4_RgWr(pdata, v);\
} while(0)

#define DMA_TCR4_TSE_UdfRd(pdata, data) do {\
		DMA_TCR4_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_TCR4_TSE_Mask);\
} while(0)

/*#define DMA_TCR4_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR4_PBL_Mask (ULONG)(0x3f)

/*#define DMA_TCR4_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR4_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_TCR4_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR4_RgRd(pdata, v);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_5))|((( 0) & (DMA_TCR4_Mask_5))<<5);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_13))|((( 0) & (DMA_TCR4_Mask_13))<<13);\
		v = (v & (DMA_TCR4_RES_Wr_Mask_22))|((( 0) & (DMA_TCR4_Mask_22))<<22);\
		v = ((v & DMA_TCR4_PBL_Wr_Mask) | ((data & DMA_TCR4_PBL_Mask)<<16));\
		DMA_TCR4_RgWr(pdata, v);\
} while(0)

#define DMA_TCR4_PBL_UdfRd(pdata, data) do {\
		DMA_TCR4_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_TCR4_PBL_Mask);\
} while(0)


#define DMA_TCR3_RgOffAddr ((BASE_ADDRESS + 0x1284))

#define DMA_TCR3_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR3_RgOffAddr));\
} while(0)

#define DMA_TCR3_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR3_RgOffAddr));\
} while(0)

/*#define  DMA_TCR3_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR3_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR3_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR3_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR3_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR3_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR3_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR3_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR3_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR3_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR3_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR3_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR3_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR3_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR3_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR3_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR3_RgRd(pdata, v);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_5))|((( 0) & (DMA_TCR3_Mask_5))<<5);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_13))|((( 0) & (DMA_TCR3_Mask_13))<<13);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_22))|((( 0) & (DMA_TCR3_Mask_22))<<22);\
		v = ((v & DMA_TCR3_ST_Wr_Mask) | ((data & DMA_TCR3_ST_Mask)<<0));\
		DMA_TCR3_RgWr(pdata, v);\
} while(0)

#define DMA_TCR3_ST_UdfRd(pdata, data) do {\
		DMA_TCR3_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR3_ST_Mask);\
} while(0)

/*#define DMA_TCR3_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR3_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR3_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR3_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR3_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR3_RgRd(pdata, v);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_5))|((( 0) & (DMA_TCR3_Mask_5))<<5);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_13))|((( 0) & (DMA_TCR3_Mask_13))<<13);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_22))|((( 0) & (DMA_TCR3_Mask_22))<<22);\
		v = ((v & DMA_TCR3_TCW_Wr_Mask) | ((data & DMA_TCR3_TCW_Mask)<<1));\
		DMA_TCR3_RgWr(pdata, v);\
} while(0)

#define DMA_TCR3_TCW_UdfRd(pdata, data) do {\
		DMA_TCR3_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR3_TCW_Mask);\
} while(0)

/*#define DMA_TCR3_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR3_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR3_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR3_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR3_RgRd(pdata, v);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_5))|((( 0) & (DMA_TCR3_Mask_5))<<5);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_13))|((( 0) & (DMA_TCR3_Mask_13))<<13);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_22))|((( 0) & (DMA_TCR3_Mask_22))<<22);\
		v = ((v & DMA_TCR3_OSP_Wr_Mask) | ((data & DMA_TCR3_OSP_Mask)<<4));\
		DMA_TCR3_RgWr(pdata, v);\
} while(0)

#define DMA_TCR3_OSP_UdfRd(pdata, data) do {\
		DMA_TCR3_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR3_OSP_Mask);\
} while(0)

/*#define DMA_TCR3_TSE_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR3_TSE_Mask (ULONG)(0x1)

/*#define DMA_TCR3_TSE_Wr_Mask (ULONG)(~((~(~0 << (1))) << (12)))*/

#define DMA_TCR3_TSE_Wr_Mask (ULONG)(0xffffefff)

#define DMA_TCR3_TSE_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR3_RgRd(pdata, v);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_5))|((( 0) & (DMA_TCR3_Mask_5))<<5);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_13))|((( 0) & (DMA_TCR3_Mask_13))<<13);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_22))|((( 0) & (DMA_TCR3_Mask_22))<<22);\
		v = ((v & DMA_TCR3_TSE_Wr_Mask) | ((data & DMA_TCR3_TSE_Mask)<<12));\
		DMA_TCR3_RgWr(pdata, v);\
} while(0)

#define DMA_TCR3_TSE_UdfRd(pdata, data) do {\
		DMA_TCR3_RgRd(pdata, data);\
		data = ((data >> 12) & DMA_TCR3_TSE_Mask);\
} while(0)

/*#define DMA_TCR3_PBL_Mask (ULONG)(~(~0<<(6)))*/

#define DMA_TCR3_PBL_Mask (ULONG)(0x3f)

/*#define DMA_TCR3_PBL_Wr_Mask (ULONG)(~((~(~0 << (6))) << (16)))*/

#define DMA_TCR3_PBL_Wr_Mask (ULONG)(0xffc0ffff)

#define DMA_TCR3_PBL_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR3_RgRd(pdata, v);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_5))|((( 0) & (DMA_TCR3_Mask_5))<<5);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_13))|((( 0) & (DMA_TCR3_Mask_13))<<13);\
		v = (v & (DMA_TCR3_RES_Wr_Mask_22))|((( 0) & (DMA_TCR3_Mask_22))<<22);\
		v = ((v & DMA_TCR3_PBL_Wr_Mask) | ((data & DMA_TCR3_PBL_Mask)<<16));\
		DMA_TCR3_RgWr(pdata, v);\
} while(0)

#define DMA_TCR3_PBL_UdfRd(pdata, data) do {\
		DMA_TCR3_RgRd(pdata, data);\
		data = ((data >> 16) & DMA_TCR3_PBL_Mask);\
} while(0)


#define DMA_TCR2_RgOffAddr ((BASE_ADDRESS + 0x1204))

#define DMA_TCR2_RgWr(pdata, data) do {\
		iowrite32(data, (void *)(pdata->dev->base_addr + DMA_TCR2_RgOffAddr));\
} while(0)

#define DMA_TCR2_RgRd(pdata, data) do {\
		(data) = ioread32((void *)(pdata->dev->base_addr + DMA_TCR2_RgOffAddr));\
} while(0)

/*#define  DMA_TCR2_Mask_5 (ULONG)(~(~0<<(7)))*/

#define  DMA_TCR2_Mask_5 (ULONG)(0x7f)

/*#define DMA_TCR2_RES_Wr_Mask_5 (ULONG)(~((~(~0<<(7)))<<(5)))*/

#define DMA_TCR2_RES_Wr_Mask_5 (ULONG)(0xfffff01f)

/*#define  DMA_TCR2_Mask_13 (ULONG)(~(~0<<(3)))*/

#define  DMA_TCR2_Mask_13 (ULONG)(0x7)

/*#define DMA_TCR2_RES_Wr_Mask_13 (ULONG)(~((~(~0<<(3)))<<(13)))*/

#define DMA_TCR2_RES_Wr_Mask_13 (ULONG)(0xffff1fff)

/*#define  DMA_TCR2_Mask_22 (ULONG)(~(~0<<(10)))*/

#define  DMA_TCR2_Mask_22 (ULONG)(0x3ff)

/*#define DMA_TCR2_RES_Wr_Mask_22 (ULONG)(~((~(~0<<(10)))<<(22)))*/

#define DMA_TCR2_RES_Wr_Mask_22 (ULONG)(0x3fffff)

/*#define DMA_TCR2_ST_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR2_ST_Mask (ULONG)(0x1)

/*#define DMA_TCR2_ST_Wr_Mask (ULONG)(~((~(~0 << (1))) << (0)))*/

#define DMA_TCR2_ST_Wr_Mask (ULONG)(0xfffffffe)

#define DMA_TCR2_ST_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR2_RgRd(pdata, v);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_5))|((( 0) & (DMA_TCR2_Mask_5))<<5);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_13))|((( 0) & (DMA_TCR2_Mask_13))<<13);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_22))|((( 0) & (DMA_TCR2_Mask_22))<<22);\
		v = ((v & DMA_TCR2_ST_Wr_Mask) | ((data & DMA_TCR2_ST_Mask)<<0));\
		DMA_TCR2_RgWr(pdata, v);\
} while(0)

#define DMA_TCR2_ST_UdfRd(pdata, data) do {\
		DMA_TCR2_RgRd(pdata, data);\
		data = ((data >> 0) & DMA_TCR2_ST_Mask);\
} while(0)

/*#define DMA_TCR2_TCW_Mask (ULONG)(~(~0<<(3)))*/

#define DMA_TCR2_TCW_Mask (ULONG)(0x7)

/*#define DMA_TCR2_TCW_Wr_Mask (ULONG)(~((~(~0 << (3))) << (1)))*/

#define DMA_TCR2_TCW_Wr_Mask (ULONG)(0xfffffff1)

#define DMA_TCR2_TCW_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR2_RgRd(pdata, v);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_5))|((( 0) & (DMA_TCR2_Mask_5))<<5);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_13))|((( 0) & (DMA_TCR2_Mask_13))<<13);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_22))|((( 0) & (DMA_TCR2_Mask_22))<<22);\
		v = ((v & DMA_TCR2_TCW_Wr_Mask) | ((data & DMA_TCR2_TCW_Mask)<<1));\
		DMA_TCR2_RgWr(pdata, v);\
} while(0)

#define DMA_TCR2_TCW_UdfRd(pdata, data) do {\
		DMA_TCR2_RgRd(pdata, data);\
		data = ((data >> 1) & DMA_TCR2_TCW_Mask);\
} while(0)

/*#define DMA_TCR2_OSP_Mask (ULONG)(~(~0<<(1)))*/

#define DMA_TCR2_OSP_Mask (ULONG)(0x1)

/*#define DMA_TCR2_OSP_Wr_Mask (ULONG)(~((~(~0 << (1))) << (4)))*/

#define DMA_TCR2_OSP_Wr_Mask (ULONG)(0xffffffef)

#define DMA_TCR2_OSP_UdfWr(pdata, data) do {\
		ULONG v;\
		DMA_TCR2_RgRd(pdata, v);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_5))|((( 0) & (DMA_TCR2_Mask_5))<<5);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_13))|((( 0) & (DMA_TCR2_Mask_13))<<13);\
		v = (v & (DMA_TCR2_RES_Wr_Mask_22))|((( 0) & (DMA_TCR2_Mask_22))<<22);\
		v = ((v & DMA_TCR2_OSP_Wr_Mask) | ((data & DMA_TCR2_OSP_Mask)<<4));\
		DMA_TCR2_RgWr(pdata, v);\
} while(0)

#define DMA_TCR2_OSP_UdfRd(pdata, data) do {\
		DMA_TCR2_RgRd(pdata, data);\
		data = ((data >> 4) & DMA_TCR2_OSP_Mask);\
} while(0)

/*#define DMA_TCR2