/*
    Header file for PCIE controller register

    This file is the header file that define register for PCIE module

    @file       pcie_reg.h
    @note       Nothing

    Copyright   Novatek Microelectronics Corp. 2021.  All rights reserved.
*/

#ifndef _NVT_PCIE_REG_H
#define _NVT_PCIE_REG_H

#include <linux/soc/nvt/rcw_macro.h>

//#define MSIX_PCIE_RC_RX_ADDR		(0x400000000ULL)	// map to peer MAU1 (for debug)
//#define MSIX_PCIE_RC_RX_ADDR		(0x620140000ULL)	// map to peer MSIX controller (loopback)
#define MSIX_PCIE_RC_RX_ADDR		(0xE00140000ULL)	// map to peer MSIX controller (RC/EP cascade)

//@{

#define DBI_ADDR_SEL_MSIX		(0x40300000>>22)

#define DBI_SHADOW_SIZE			(1<<22)

//
// PCIE TOP regsiters
//
#define PCI_TOP_DMC_STATUS0_REG_OFS	0x008
REGDEF_BEGIN(PCI_TOP_DMC_STATUS0_REG)
REGDEF_BIT(rdlh_link_up, 1)
REGDEF_BIT(pm_curnt_state, 3)
REGDEF_BIT(smlh_ltssm_state, 6)
REGDEF_BIT(smlh_ltssm_state_rcvry_eq, 1)
REGDEF_BIT(smlh_link_up, 1)
REGDEF_BIT(brdg_slv_xfer_pending, 1)
REGDEF_BIT(edma_xfer_pending, 1)
REGDEF_BIT(radm_xfer_pending, 1)
REGDEF_BIT(cfg_hw_auto_sp_dis, 1)
REGDEF_BIT(pm_dstate, 3)
REGDEF_BIT(pm_pme_en, 1)
REGDEF_BIT(, 11)
REGDEF_END(PCI_TOP_DMC_STATUS0_REG)

#define PCI_TOP_INTR_STAT_OFS		0x020
REGDEF_BEGIN(PCI_TOP_INTR_STAT)
REGDEF_BIT(radm_qoverflow_vc0, 1)
REGDEF_BIT(radm_qoverflow_vc1, 1)
REGDEF_BIT(cfg_aer_rc_err_int, 1)
REGDEF_BIT(cfg_aer_rc_err_msi, 1)
REGDEF_BIT(cfg_sys_err_rc, 1)
REGDEF_BIT(cfg_pme_int, 1)
REGDEF_BIT(cfg_pme_msi, 1)
REGDEF_BIT(radm_msg_unlock, 1)
REGDEF_BIT(radm_vendor_msg, 1)
REGDEF_BIT(inta, 1)
REGDEF_BIT(intb, 1)
REGDEF_BIT(intc, 1)
REGDEF_BIT(intd, 1)
REGDEF_BIT(radm_correctable_err, 1)
REGDEF_BIT(radm_nonfatal_err, 1)
REGDEF_BIT(radm_fatal_err, 1)
REGDEF_BIT(radm_pm_pme, 1)
REGDEF_BIT(radm_pm_to_ack, 1)
REGDEF_BIT(radm_pm_turnoff, 1)
REGDEF_BIT(hp_pme, 1)
REGDEF_BIT(hp_int, 1)
REGDEF_BIT(hp_msi, 1)
REGDEF_BIT(edma_int, 1)
REGDEF_BIT(cfg_link_auto_bw_int, 1)
REGDEF_BIT(cfg_bw_mgt_int, 1)
REGDEF_BIT(cfg_link_eq_req_int, 1)
REGDEF_BIT(msi_ctrl_int, 1)
REGDEF_BIT(cfg_bw_mgt_msi, 1)
REGDEF_BIT(cfg_link_auto_bw_msi, 1)
REGDEF_BIT(link_down_rst_req, 1)
REGDEF_BIT(usp_eq_redo_executed_int, 1)
REGDEF_BIT(dpc_int, 1)
REGDEF_END(PCI_TOP_INTR_STAT)

#define PCI_TOP_INTR_MASK_OFS		0x024
REGDEF_BEGIN(PCI_TOP_INTR_MASK)
REGDEF_BIT(radm_qoverflow_vc0_msk, 1)
REGDEF_BIT(radm_qoverflow_vc1_msk, 1)
REGDEF_BIT(cfg_aer_rc_err_int_msk, 1)
REGDEF_BIT(cfg_aer_rc_err_msi_msk, 1)
REGDEF_BIT(cfg_sys_err_rc_msk, 1)
REGDEF_BIT(cfg_pme_int_msk, 1)
REGDEF_BIT(cfg_pme_msi_msk, 1)
REGDEF_BIT(radm_msg_unlock_msk, 1)
REGDEF_BIT(radm_vendor_msg_msk, 1)
REGDEF_BIT(inta_msk, 1)
REGDEF_BIT(intb_msk, 1)
REGDEF_BIT(intc_msk, 1)
REGDEF_BIT(intd_msk, 1)
REGDEF_BIT(radm_correctable_err_msk, 1)
REGDEF_BIT(radm_nonfatal_err_msk, 1)
REGDEF_BIT(radm_fatal_err_msk, 1)
REGDEF_BIT(radm_pm_pme_msk, 1)
REGDEF_BIT(radm_pm_to_ack_msk, 1)
REGDEF_BIT(radm_pm_turnoff_msk, 1)
REGDEF_BIT(hp_pme_msk, 1)
REGDEF_BIT(hp_int_msk, 1)
REGDEF_BIT(hp_msi_msk, 1)
REGDEF_BIT(edma_int_msk, 1)
REGDEF_BIT(cfg_link_auto_bw_int_msk, 1)
REGDEF_BIT(cfg_bw_mgt_int_msk, 1)
REGDEF_BIT(cfg_link_eq_req_int_msk, 1)
REGDEF_BIT(msi_ctrl_int_msk, 1)
REGDEF_BIT(cfg_bw_mgt_msi_msk, 1)
REGDEF_BIT(cfg_link_auto_bw_msi_msk, 1)
REGDEF_BIT(link_down_rst_req_msk, 1)
REGDEF_BIT(usp_eq_redo_executed_int_msk, 1)
REGDEF_BIT(dpc_int_msk, 1)
REGDEF_END(PCI_TOP_INTR_MASK)

#define PCI_TOP_CTL0_REG_OFS		0x300
REGDEF_BEGIN(PCI_TOP_CTL0_REG)
REGDEF_BIT(prst_n_man, 1)
REGDEF_BIT(power_up_rst_n_man, 1)
REGDEF_BIT(pipe_rst_n_man, 1)
REGDEF_BIT(phy_apb_rst_n_man, 1)
REGDEF_BIT(phy_PORn_man, 1)
REGDEF_BIT(app_hold_phy_rst, 1)
REGDEF_BIT(mac_phy_pipe_reset_n_man, 1)
REGDEF_BIT(mac_phy_pipe_reset_n_man_en, 1)
REGDEF_BIT(, 20)
REGDEF_BIT(mstr_aclk_agat_en, 1)
REGDEF_BIT(slv_aclk_agat_en, 1)
REGDEF_BIT(dbi_aclk_agat_en, 1)
REGDEF_BIT(, 1)
REGDEF_END(PCI_TOP_CTL0_REG)

#define PCI_TOP_CTL3_REG_OFS		0x30C
REGDEF_BEGIN(PCI_TOP_CTL3_REG)			// --> Register "PCI_TOP_CTL3_REG" begin ---
REGDEF_BIT(app_bus_num, 8)
REGDEF_BIT(app_dev_num, 6)
REGDEF_BIT(, 8)
REGDEF_BIT(DBI_ADDR_32to22, 10)
REGDEF_END(PCI_TOP_CTL3_REG)			// --- Register "PCI_TOP_CTL3_REG" end   <--

//
// PCIE DBI registers
//

// DEVICE_ID_VENDOR_ID_REG
#define DEVICE_ID_VENDOR_ID_REG_OFS	0x00
REGDEF_BEGIN(DEVICE_ID_VENDOR_ID_REG)		// --> Register "DEVICE_ID_VENDOR_ID_REG" begin ---
REGDEF_BIT(PCI_TYPE0_VENDOR_ID, 16)
REGDEF_BIT(PCI_TYPE0_DEVICE_ID, 16)
REGDEF_END(DEVICE_ID_VENDOR_ID_REG)		// --- Register "DEVICE_ID_VENDOR_ID_REG" end   <--

#define PCI_MSIX_CAP_ID_NEXT_CTRL_REG_OFS	0xB0
REGDEF_BEGIN(PCI_MSIX_CAP_ID_NEXT_CTRL_REG)
REGDEF_BIT(PCI_MSIX_CAP_ID, 8)
REGDEF_BIT(PCI_MSIX_CAP_NEXT_OFFSET, 8)
REGDEF_BIT(PCI_MSIX_TABLE_SIZE, 11)
REGDEF_BIT(, 3)
REGDEF_BIT(PCI_MSIX_FUNCTION_MASK, 1)
REGDEF_BIT(PCI_MSIX_ENABLE, 1)
REGDEF_END(PCI_MSIX_CAP_ID_NEXT_CTRL_REG)


#define DBI_RAS_DES_CAP_BASE		0x19C

#define RAS_DES_CAP_HEADER_OFS	(DBI_RAS_DES_CAP_BASE + 0x00)
REGDEF_BEGIN(RAS_DES_CAP_HEADER)
REGDEF_BIT(MATCH_EN, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(ADDR_LOW31t2, 30)
REGDEF_END(RAS_DES_CAP_HEADER)

#define VENDOR_SPECIFIC_HEADER_OFS	(DBI_RAS_DES_CAP_BASE + 0x04)
REGDEF_BEGIN(VENDOR_SPECIFIC_HEADER)
REGDEF_BIT(MATCH_EN, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(ADDR_LOW31t2, 30)
REGDEF_END(VENDOR_SPECIFIC_HEADER)


#define EVENT_COUNTER_CONTROL_OFS	(DBI_RAS_DES_CAP_BASE + 0x08)
REGDEF_BEGIN(EVENT_COUNTER_CONTROL)
REGDEF_BIT(EVENT_COUNTER_CLEAR, 2)
REGDEF_BIT(EVENT_COUNTER_ENABLE, 3)
REGDEF_BIT(, 2)
REGDEF_BIT(EVENT_COUNTER_STATUS, 1)
REGDEF_BIT(EVENT_COUNTER_LANE_SELECT, 4)
REGDEF_BIT(, 4)
REGDEF_BIT(EVENT_COUNTER_EVENT_SELECT, 12)
REGDEF_BIT(, 4)
REGDEF_END(EVENT_COUNTER_CONTROL)

#define EVENT_COUNTER_DATA_OFS	(DBI_RAS_DES_CAP_BASE + 0x0C)
REGDEF_BEGIN(EVENT_COUNTER_DATA)
REGDEF_BIT(EVENT_COUNTER_DATA, 32)
REGDEF_END(EVENT_COUNTER_DATA)

#define TIME_BASED_ANALYSIS_CONTROL_OFS	(DBI_RAS_DES_CAP_BASE + 0x10)
REGDEF_BEGIN(TIME_BASED_ANALYSIS_CONTROL)
REGDEF_BIT(TIMER_START, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(TIME_BASED_DURATION_SELECT, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(TIME_BASED_REPORT_SELECT, 8)
REGDEF_END(TIME_BASED_ANALYSIS_CONTROL)


#define TIME_BASED_ANALYSIS_DATA_OFS	(DBI_RAS_DES_CAP_BASE + 0x14)
REGDEF_BEGIN(TIME_BASED_ANALYSIS_DATA)
REGDEF_BIT(TIME_BASED_ANALYSIS_DATA, 32)
REGDEF_END(TIME_BASED_ANALYSIS_DATA)

#define DBI_PORT_LOGIC_BASE		0x700

#define MSIX_ADDRESS_MATCH_LOW_OFF_OFS	(DBI_PORT_LOGIC_BASE + 0x240)
REGDEF_BEGIN(MSIX_ADDRESS_MATCH_LOW_OFF)
REGDEF_BIT(MATCH_EN, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(ADDR_LOW31t2, 30)
REGDEF_END(MSIX_ADDRESS_MATCH_LOW_OFF)

#define MSIX_ADDRESS_MATCH_HIGH_OFF_OFS	(DBI_PORT_LOGIC_BASE + 0x244)
REGDEF_BEGIN(MSIX_ADDRESS_MATCH_HIGH_OFF)
REGDEF_BIT(ADDR_HIGH, 32)
REGDEF_END(MSIX_ADDRESS_MATCH_HIGH_OFF)

#define DBI_ATU_BASE			0x300000

#define DBI_DMA_BASE			0x380000

#define DMA_WRITE_ENGINE_EN_OFF_OFS	(DBI_DMA_BASE + 0x0C)
REGDEF_BEGIN(DMA_WRITE_ENGINE_EN_OFF)
REGDEF_BIT(DMA_WRITE_ENGINE, 1)
REGDEF_BIT(, 31)
REGDEF_END(DMA_WRITE_ENGINE_EN_OFF)

#define DMA_WRITE_DOORBELL_OFF_OFS	(DBI_DMA_BASE + 0x10)
REGDEF_BEGIN(DMA_WRITE_DOORBELL_OFF)
REGDEF_BIT(WR_DOORBELL_NUM, 3)
REGDEF_BIT(, 28)
REGDEF_BIT(WR_STOP, 1)
REGDEF_END(DMA_WRITE_DOORBELL_OFF)

#define DMA_READ_ENGINE_EN_OFF_OFS	(DBI_DMA_BASE + 0x2C)
REGDEF_BEGIN(DMA_READ_ENGINE_EN_OFF)
REGDEF_BIT(DMA_READ_ENGINE, 1)
REGDEF_BIT(, 31)
REGDEF_END(DMA_READ_ENGINE_EN_OFF)

#define DMA_READ_DOORBELL_OFF_OFS	(DBI_DMA_BASE + 0x30)
REGDEF_BEGIN(DMA_READ_DOORBELL_OFF)
REGDEF_BIT(RD_DOORBELL_NUM, 3)
REGDEF_BIT(, 28)
REGDEF_BIT(RD_STOP, 1)
REGDEF_END(DMA_READ_DOORBELL_OFF)

#define DMA_WRITE_INT_STATUS_OFF_OFS	(DBI_DMA_BASE + 0x4C)
REGDEF_BEGIN(DMA_WRITE_INT_STATUS_OFF)
REGDEF_BIT(WR_DONE_INT_STATUS, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(WR_ABORT_INT_STATUS, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_WRITE_INT_STATUS_OFF)

#define DMA_WRITE_INT_MASK_OFF_OFS	(DBI_DMA_BASE + 0x54)
REGDEF_BEGIN(DMA_WRITE_INT_MASK_OFF)
REGDEF_BIT(WR_DONE_INT_MASK, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(WR_ABORT_INT_MASK, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_WRITE_INT_MASK_OFF)

#define DMA_WRITE_INT_CLEAR_OFF_OFS	(DBI_DMA_BASE + 0x58)
REGDEF_BEGIN(DMA_WRITE_INT_CLEAR_OFF)
REGDEF_BIT(WR_DONE_INT_CLEAR, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(WR_ABORT_INT_CLEAR, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_WRITE_INT_CLEAR_OFF)

#define DMA_WRITE_DONE_IMWR_LOW_OFF_OFS	(DBI_DMA_BASE + 0x60)
REGDEF_BEGIN(DMA_WRITE_DONE_IMWR_LOW_OFF)
REGDEF_BIT(DMA_WRITE_DONE_LOW_REG, 32)
REGDEF_END(DMA_WRITE_DONE_IMWR_LOW_OFF)

#define DMA_WRITE_DONE_IMWR_HIGH_OFF_OFS (DBI_DMA_BASE + 0x64)
REGDEF_BEGIN(DMA_WRITE_DONE_IMWR_HIGH_OFF)
REGDEF_BIT(DMA_WRITE_DONE_HIGH_REG, 32)
REGDEF_END(DMA_WRITE_DONE_IMWR_HIGH_OFF)

#define DMA_WRITE_CH01_IMWR_DATA_OFF_OFS	(DBI_DMA_BASE + 0x70)
REGDEF_BEGIN(DMA_WRITE_CH01_IMWR_DATA_OFF)
REGDEF_BIT(WR_CHANNEL_0_DATA, 16)
REGDEF_BIT(WR_CHANNEL_1_DATA, 16)
REGDEF_END(DMA_WRITE_CH01_IMWR_DATA_OFF)

#define DMA_WRITE_CH23_IMWR_DATA_OFF_OFS	(DBI_DMA_BASE + 0x74)
REGDEF_BEGIN(DMA_WRITE_CH23_IMWR_DATA_OFF)
REGDEF_BIT(WR_CHANNEL_2_DATA, 16)
REGDEF_BIT(WR_CHANNEL_3_DATA, 16)
REGDEF_END(DMA_WRITE_CH23_IMWR_DATA_OFF)

#define DMA_WRITE_CH45_IMWR_DATA_OFF_OFS	(DBI_DMA_BASE + 0x78)
REGDEF_BEGIN(DMA_WRITE_CH45_IMWR_DATA_OFF)
REGDEF_BIT(WR_CHANNEL_4_DATA, 16)
REGDEF_BIT(WR_CHANNEL_5_DATA, 16)
REGDEF_END(DMA_WRITE_CH45_IMWR_DATA_OFF)

#define DMA_WRITE_CH67_IMWR_DATA_OFF_OFS	(DBI_DMA_BASE + 0x7C)
REGDEF_BEGIN(DMA_WRITE_CH67_IMWR_DATA_OFF)
REGDEF_BIT(WR_CHANNEL_6_DATA, 16)
REGDEF_BIT(WR_CHANNEL_7_DATA, 16)
REGDEF_END(DMA_WRITE_CH67_IMWR_DATA_OFF)

#define DMA_READ_INT_STATUS_OFF_OFS	(DBI_DMA_BASE + 0xA0)
REGDEF_BEGIN(DMA_READ_INT_STATUS_OFF)
REGDEF_BIT(RD_DONE_INT_STATUS, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(RD_ABORT_INT_STATUS, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_READ_INT_STATUS_OFF)

#define DMA_READ_INT_MASK_OFF_OFS	(DBI_DMA_BASE + 0xA8)
REGDEF_BEGIN(DMA_READ_INT_MASK_OFF)
REGDEF_BIT(RD_DONE_INT_MASK, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(RD_ABORT_INT_MASK, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_READ_INT_MASK_OFF)

#define DMA_READ_INT_CLEAR_OFF_OFS	(DBI_DMA_BASE + 0xAC)
REGDEF_BEGIN(DMA_READ_INT_CLEAR_OFF)
REGDEF_BIT(RD_DONE_INT_CLEAR, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(RD_ABORT_INT_CLEAR, 8)
REGDEF_BIT(, 8)
REGDEF_END(DMA_READ_INT_CLEAR_OFF)

#define DMA_CH_CONTROL1_OFF_WRCH_OFS(i)		(DBI_DMA_BASE + 0x200 + (i)*0x200)
REGDEF_BEGIN(DMA_CH_CONTROL1_OFF_WRCH)
REGDEF_BIT(CB, 1)
REGDEF_BIT(TCB, 1)
REGDEF_BIT(LLP, 1)
REGDEF_BIT(LIE, 1)
REGDEF_BIT(RIE, 1)
REGDEF_BIT(CS, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(CCS, 1)
REGDEF_BIT(LLE, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(DMA_FUNC_NUM, 5)
REGDEF_BIT(, 5)
REGDEF_BIT(DMA_MEM_TYPE, 1)
REGDEF_BIT(DMA_NS_DST, 1)
REGDEF_BIT(DMA_NS_SRC, 1)
REGDEF_BIT(DMA_RO, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(DMA_TC, 3)
REGDEF_BIT(DMA_AT, 2)
REGDEF_END(DMA_CH_CONTROL1_OFF_WRCH)

#define DMA_TRANSFER_SIZE_OFF_WRCH_OFS(i)	(DBI_DMA_BASE + 0x208 + (i)*0x200)
REGDEF_BEGIN(DMA_TRANSFER_SIZE_OFF_WRCH)
REGDEF_BIT(DMA_TRANSFER_SIZE, 32)
REGDEF_END(DMA_TRANSFER_SIZE_OFF_WRCH)

#define DMA_SAR_LOW_OFF_WRCH_OFS(i)		(DBI_DMA_BASE + 0x20C + (i)*0x200)
REGDEF_BEGIN(DMA_SAR_LOW_OFF_WRCH)
REGDEF_BIT(SRC_ADDR_REG_LOW, 32)
REGDEF_END(DMA_SAR_LOW_OFF_WRCH)

#define DMA_SAR_HIGH_OFF_WRCH_OFS(i)		(DBI_DMA_BASE + 0x210 + (i)*0x200)
REGDEF_BEGIN(DMA_SAR_HIGH_OFF_WRCH)
REGDEF_BIT(SRC_ADDR_REG_HIGH, 32)
REGDEF_END(DMA_SAR_HIGH_OFF_WRCH)

#define DMA_DAR_LOW_OFF_WRCH_OFS(i)		(DBI_DMA_BASE + 0x214 + (i)*0x200)
REGDEF_BEGIN(DMA_DAR_LOW_OFF_WRCH)
REGDEF_BIT(DST_ADDR_REG_LOW, 32)
REGDEF_END(DMA_DAR_LOW_OFF_WRCH)

#define DMA_DAR_HIGH_OFF_WRCH_OFS(i)		(DBI_DMA_BASE + 0x218 + (i)*0x200)
REGDEF_BEGIN(DMA_DAR_HIGH_OFF_WRCH)
REGDEF_BIT(DST_ADDR_REG_HIGH, 32)
REGDEF_END(DMA_DAR_HIGH_OFF_WRCH)

#define DMA_CH_CONTROL1_OFF_RDCH_OFS(i)		(DBI_DMA_BASE + 0x300 + (i)*0x200)
REGDEF_BEGIN(DMA_CH_CONTROL1_OFF_RDCH)
REGDEF_BIT(CB, 1)
REGDEF_BIT(TCB, 1)
REGDEF_BIT(LLP, 1)
REGDEF_BIT(LIE, 1)
REGDEF_BIT(RIE, 1)
REGDEF_BIT(CS, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(CCS, 1)
REGDEF_BIT(LLE, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(DMA_FUNC_NUM, 5)
REGDEF_BIT(, 5)
REGDEF_BIT(DMA_MEM_TYPE, 1)
REGDEF_BIT(DMA_NS_DST, 1)
REGDEF_BIT(DMA_NS_SRC, 1)
REGDEF_BIT(DMA_RO, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(DMA_TC, 3)
REGDEF_BIT(DMA_AT, 2)
REGDEF_END(DMA_CH_CONTROL1_OFF_RDCH)

#define DMA_TRANSFER_SIZE_OFF_RDCH_OFS(i)	(DBI_DMA_BASE + 0x308 + (i)*0x200)
REGDEF_BEGIN(DMA_TRANSFER_SIZE_OFF_RDCH)
REGDEF_BIT(DMA_TRANSFER_SIZE, 32)
REGDEF_END(DMA_TRANSFER_SIZE_OFF_RDCH)

#define DMA_SAR_LOW_OFF_RDCH_OFS(i)		(DBI_DMA_BASE + 0x30C + (i)*0x200)
REGDEF_BEGIN(DMA_SAR_LOW_OFF_RDCH)
REGDEF_BIT(SRC_ADDR_REG_LOW, 32)
REGDEF_END(DMA_SAR_LOW_OFF_RDCH)

#define DMA_SAR_HIGH_OFF_RDCH_OFS(i)		(DBI_DMA_BASE + 0x310 + (i)*0x200)
REGDEF_BEGIN(DMA_SAR_HIGH_OFF_RDCH)
REGDEF_BIT(SRC_ADDR_REG_HIGH, 32)
REGDEF_END(DMA_SAR_HIGH_OFF_RDCH)

#define DMA_DAR_LOW_OFF_RDCH_OFS(i)		(DBI_DMA_BASE + 0x314 + (i)*0x200)
REGDEF_BEGIN(DMA_DAR_LOW_OFF_RDCH)
REGDEF_BIT(DST_ADDR_REG_LOW, 32)
REGDEF_END(DMA_DAR_LOW_OFF_RDCH)

#define DMA_DAR_HIGH_OFF_RDCH_OFS(i)		(DBI_DMA_BASE + 0x318 + (i)*0x200)
REGDEF_BEGIN(DMA_DAR_HIGH_OFF_RDCH)
REGDEF_BIT(DST_ADDR_REG_HIGH, 32)
REGDEF_END(DMA_DAR_HIGH_OFF_RDCH)


#define MSIX_TABLE_OFS    		(0x40300000)
//#define MSIX_TABLE_OFS    		(0x40300000&0x00FFFFFF)

//@}

#endif
