/*
	Register definition header file for CG module of NA51055.

	This file is the header file that define the address offset
	definition of registers of CG module.

	@file       cg-reg.h

	Copyright   Novatek Microelectronics Corp. 2018.  All rights reserved
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 as
	published by the Free Software Foundation.
*/

#ifndef _CG_REG_H
#define _CG_REG_H

#include "hardware.h"

/* PLL */
#define CG_PLL_EN_REG_OFFSET				0x00
#define CG_PLL_STAT_REG_OFFSET				0x04

/* Clock source control */
#define CG_SYS_CLK_RATE_REG_OFFSET			0x10
#define CG_IPP_CLK_RATE_REG0_OFFSET			0x14
#define CG_IPP_CLK_RATE_REG1_OFFSET			0x18
#define CG_CODEC_CLK_RATE_REG_OFFSET			0x1C
#define CG_PERI_CLK_RATE_REG0_OFFSET			0x20
#define CG_PERI_CLK_RATE_REG1_OFFSET			0x24
#define CG_PERI_CLK_RATE_REG2_OFFSET			0x28
#define CG_PERI_CLK_RATE_REG3_OFFSET			0x2C

/* Clock rate control */
#define CG_IPP_CLK_DIV_REG0_OFFSET			0x30
#define CG_VIDEO_CLK_DIV_REG_OFFSET			0x34
#define CG_PERI_CLK_DIV_REG0_OFFSET			0x38
#define CG_SDIO_CLK_DIV_REG_OFFSET			0x3C
#define CG_PERI_CLK_DIV_REG1_OFFSET			0x40
#define CG_SPI_CLK_DIV_REG0_OFFSET			0x44
#define CG_SPI_CLK_DIV_REG1_OFFSET			0x48
#define CG_SPI_CLK_DIV_REG2_OFFSET			0x64
#define CG_UART_CLK_DIV_REG0_OFFSET			0x4C

/* PWM clock rate control */
#define CG_PWM_CLK_RATE_REG0_OFFSET			0x50
#define CG_PWM_CLK_RATE_REG1_OFFSET			0x54
#define CG_PWM_CLK_RATE_REG2_OFFSET			0x58

#define CG_PERI_CLK_DIV_REG2_OFFSET			0x60

/* Clock enable/disable control */
#define CG_CLK_EN_REG0_OFFSET				0x70
#define CG_CLK_EN_REG1_OFFSET				0x74
#define CG_CLK_EN_REG2_OFFSET				0x78
#define CG_CLK_EN_REG3_OFFSET				0x7C

/* Module reset control */
#define CG_SYS_RESET_REG0_OFFSET			0x80
#define CG_SYS_RESET_REG1_OFFSET			0x84
#define CG_SYS_RESET_REG2_OFFSET			0x88

/* Low power control */
#define CG_SLEEP_MODE_REG_OFFSET			0xA0
#define CG_CLK_AUTO_GATING_REG0_OFFSET			0xB0
#define CG_CLK_AUTO_GATING_REG1_OFFSET			0xB4
#define CG_APB_CLK_AUTO_GATING_REG0_OFFSET		0xC0
#define CG_APB_CLK_AUTO_GATING_REG1_OFFSET		0xC4
#define CG_APB_CLK_AUTO_GATING_REG2_OFFSET		0xC8

#define CG_PLL_MCU_FLAG_REG_OFFSET			0x1180

/* PLL clock rate control */
#define CG_PLL8_CLK_RATE0_REG_OFFSET			0x1188
#define CG_PLL8_CLK_RATE1_REG_OFFSET			0x118C
#define CG_PLL8_CLK_RATE2_REG_OFFSET			0x1190
#define CG_PLL4_SPREAD_SPECTRUM_REG0_OFFSET		0x11C8
#define CG_PLL4_SPREAD_SPECTRUM_REG1_OFFSET		0x11CC
#define CG_PLL4_SPREAD_SPECTRUM_REG2_OFFSET		0x11D0
#define CG_PLL4_SPREAD_SPECTRUM_REG3_OFFSET		0x11D4
#define CG_PLL3_CLK_RATE0_REG_OFFSET			0x1208
#define CG_PLL3_CLK_RATE1_REG_OFFSET			0x120C
#define CG_PLL3_CLK_RATE2_REG_OFFSET			0x1210
#define CG_PLL14_CLK_RATE0_REG_OFFSET			0x1228
#define CG_PLL14_CLK_RATE1_REG_OFFSET			0x122C
#define CG_PLL14_CLK_RATE2_REG_OFFSET			0x1230
#define CG_PLL11_CLK_RATE0_REG_OFFSET			0x1268
#define CG_PLL11_CLK_RATE1_REG_OFFSET			0x126C
#define CG_PLL11_CLK_RATE2_REG_OFFSET			0x1270
#define CG_PLL6_CLK_RATE0_REG_OFFSET			0x1288
#define CG_PLL6_CLK_RATE1_REG_OFFSET			0x128C
#define CG_PLL6_CLK_RATE2_REG_OFFSET			0x1290
#define CG_PLL10_CLK_RATE0_REG_OFFSET			0x12A8
#define CG_PLL10_CLK_RATE1_REG_OFFSET			0x12AC
#define CG_PLL10_CLK_RATE2_REG_OFFSET			0x12B0
#define CG_PLLF320_CLK_RATE0_REG_OFFSET			0x12C8
#define CG_PLLF320_CLK_RATE1_REG_OFFSET			0x12CC
#define CG_PLLF320_CLK_RATE2_REG_OFFSET			0x12D0
#define CG_PLL7_CLK_RATE0_REG_OFFSET			0x12E8
#define CG_PLL7_CLK_RATE1_REG_OFFSET			0x12EC
#define CG_PLL7_CLK_RATE2_REG_OFFSET			0x12F0
#define CG_PLL13_CLK_RATE0_REG_OFFSET			0x1304
#define CG_PLL13_CLK_RATE1_REG_OFFSET			0x1308
#define CG_PLL13_CLK_RATE2_REG_OFFSET			0x130C
#define CG_PLL4_CLK_RATE0_REG_OFFSET			0x1318
#define CG_PLL4_CLK_RATE1_REG_OFFSET			0x131C
#define CG_PLL4_CLK_RATE2_REG_OFFSET			0x1320
#define CG_PLL12_CLK_RATE0_REG_OFFSET			0x1340
#define CG_PLL12_CLK_RATE1_REG_OFFSET			0x1344
#define CG_PLL12_CLK_RATE2_REG_OFFSET			0x1348
#define CG_PLL9_CLK_RATE0_REG_OFFSET			0x134C
#define CG_PLL9_CLK_RATE1_REG_OFFSET			0x1350
#define CG_PLL9_CLK_RATE2_REG_OFFSET			0x1354
#define CG_PLL5_CLK_RATE0_REG_OFFSET			0x13D0
#define CG_PLL5_CLK_RATE1_REG_OFFSET			0x13D4
#define CG_PLL5_CLK_RATE2_REG_OFFSET			0x13D8
#define CG_PLL15_CLK_RATE0_REG_OFFSET			0x13DC
#define CG_PLL15_CLK_RATE1_REG_OFFSET			0x13E0
#define CG_PLL15_CLK_RATE2_REG_OFFSET			0x13E4


#define CG528_ARMPLL_CONTROL0_REG_OFFSET         	(0x4340)
#define CG528_ARMPLL_CONTROL1_REG_OFFSET         	(0x4344)
#define CG528_ARMPLL_CONTROL2_REG_OFFSET         	(0x43C8)

#define CG528_PLL4_SPREAD_SPECTRUM_REG0_OFFSET		(0x44C0+0x0C)
#define CG528_PLL4_SPREAD_SPECTRUM_REG1_OFFSET		(0x44C0+0x1C)
#define CG528_PLL4_SPREAD_SPECTRUM_REG2_OFFSET		(0x44C0+0x10)
#define CG528_PLL4_SPREAD_SPECTRUM_REG3_OFFSET		(0x44C0+0x14)

#define CG528_PLL3_CLK_RATE0_REG_OFFSET			(0x4400+0x20)
#define CG528_PLL4_CLK_RATE0_REG_OFFSET			(0x44C0+0x20)
#define CG528_PLL5_CLK_RATE0_REG_OFFSET			(0x4600+0x20)
#define CG528_PLL6_CLK_RATE0_REG_OFFSET			(0x4500+0x20)
#define CG528_PLL7_CLK_RATE0_REG_OFFSET			(0x46C0+0x20)
#define CG528_PLL8_CLK_RATE0_REG_OFFSET			(0x47C0+0x20)
#define CG528_PLL9_CLK_RATE0_REG_OFFSET			(0x4540+0x20)
#define CG528_PLL10_CLK_RATE0_REG_OFFSET		(0x4480+0x20)
#define CG528_PLL11_CLK_RATE0_REG_OFFSET		(0x4780+0x20)
#define CG528_PLL12_CLK_RATE0_REG_OFFSET		(0x4640+0x20)
#define CG528_PLL13_CLK_RATE0_REG_OFFSET		(0x4800+0x20)
#define CG528_PLL14_CLK_RATE0_REG_OFFSET		(0x4440+0x20)
#define CG528_PLL15_CLK_RATE0_REG_OFFSET		(0x4740+0x20)
#define CG528_PLL16_CLK_RATE0_REG_OFFSET		(0x4580+0x20)
#define CG528_PLL17_CLK_RATE0_REG_OFFSET		(0x4700+0x20)
#define CG528_PLL18_CLK_RATE0_REG_OFFSET		(0x4680+0x20)
#define CG528_PLLF320_CLK_RATE0_REG_OFFSET		(0x45C0+0x20)

#endif
