/**
	NVT hardware description
	To define NVT platform IO address
	@file      hardware.h
	@ingroup
	@note

	Copyright   Novatek Microelectronics Corp. 2022.  All rights reserved.
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 as
	published by the Free Software Foundation.
*/

#ifndef __SOC_NVT_PLAT_NA51103_HARDWARE_H
#define __SOC_NVT_PLAT_NA51103_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE		(0xfff01000)
#define NVT_GIC_CPU_PHYS_BASE		(0xfff02000)

#define NVT_CPU_REG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x1400000)
#define NVT_CPU_REG_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x1400000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE	(0xf0000000)
#define NVT_PERIPHERAL_VIRT_BASE	IOMEM(0xfD000000)
#define NVT_PERIPHERAL_SIZE		0x2000000

#define NVT_MAU_PHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x00E8000)
#define NVT_MAU_PHY_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x00E8000)

#define NVT_TOP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0010000)
#define NVT_TOP_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0010000)

#define NVT_SRAM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0011000)
#define NVT_SRAM_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0011000)

#define NVT_CG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0020000)
#define NVT_CG_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0030000)
#define NVT_PAD_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0030000)

#define NVT_GPIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0040000)
#define NVT_GPIO_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0040000)

#define NVT_TZPC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0050000)
#define NVT_TZPC_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0050000)

#define NVT_WDT_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0060000)
#define NVT_WDT_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0060000)

#define NVT_HVYLD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x00A0000)
#define NVT_HVYLD_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x00A0000)

#define NVT_TIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0100000)
#define NVT_TIMER_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0100000)

#define NVT_HVYLD2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0110000)
#define NVT_HVYLD2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0110000)

#define NVT_PWM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0120000)
#define NVT_PWM_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0120000)

#define NVT_REMOTE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0130000)
#define NVT_REMOTE_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0130000)

#define NVT_TIMER64_1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0140000)
#define NVT_TIMER64_1_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0140000)

#define NVT_TRNG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0150000)
#define NVT_TRNG_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0150000)

#define NVT_CC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0160000)
#define NVT_CC_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0160000)

#define NVT_TIMER64_2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0170000)
#define NVT_TIMER64_2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0170000)

#define NVT_NAND_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0180000)
#define NVT_NAND_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0180000)

#define NVT_SDIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0190000)
#define NVT_SDIO_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0190000)

#define NVT_I2C1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01c0000)
#define NVT_I2C1_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x01c0000)

#define NVT_I2C2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01d0000)
#define NVT_I2C2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x01d0000)

#define NVT_I2C3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01e0000)
#define NVT_I2C3_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x01e0000)

#define NVT_I2C4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01f0000)
#define NVT_I2C4_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x01f0000)

#define NVT_SPI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0270000)
#define NVT_SPI_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0270000)

#define NVT_UART1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0280000)
#define NVT_UART1_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0280000)

#define NVT_UART2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0290000)
#define NVT_UART2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0290000)

#define NVT_UART3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x02a0000)
#define NVT_UART3_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x02a0000)

// HDMI
#define NVT_HDMI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0880000)
#define NVT_HDMI_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0880000)

#define NVT_TVE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0840000)
#define NVT_TVE_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0840000)

#define NVT_UART4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x02b0000)
#define NVT_UART4_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x02b0000)

#define NVT_ETH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0440000)
#define NVT_ETH_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0440000)

#define NVT_ETH2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0450000)
#define NVT_ETH2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0450000)

#define NVT_USB_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0480000)
#define NVT_USB_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0480000)

#define NVT_USB2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0490000)
#define NVT_USB2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0490000)

#define NVT_USBPHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04E0000)
#define NVT_USBPHY_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x04E0000)

#define NVT_USB2PHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04F0000)
#define NVT_USB2PHY_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x04F0000)

#define NVT_RTC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0620000)
#define NVT_RTC_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0620000)

#define NVT_EFUSE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0630000)
#define NVT_EFUSE_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0630000)

#define NVT_SCE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0640000)
#define NVT_SCE_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0640000)

#define NVT_HASH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0650000)
#define NVT_HASH_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0650000)

#define NVT_RSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0660000)
#define NVT_RSA_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0660000)

#define NVT_SATA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0680000)
#define NVT_SATA_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0680000)

#define NVT_SATA2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0690000)
#define NVT_SATA2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x0690000)

#define NVT_SATACTL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06c0000)
#define NVT_SATACTL_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x06c0000)

#define NVT_SATACTL2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06d0000)
#define NVT_SATACTL2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x06d0000)

#define NVT_SATAPHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06e0000)
#define NVT_SATAPHY_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x06e0000)

#define NVT_SATAPHY2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06f0000)
#define NVT_SATAPHY2_BASE_VIRT		(NVT_PERIPHERAL_VIRT_BASE + 0x06f0000)

#define CHIPVER_A                       0x0
#define CHIPVER_B                       0x1

extern u32 nvt_get_chip_ver(phys_addr_t base);
#endif	/* __SOC_NVT_PLAT_NA51103_HARDWARE_H */
