/**
	NVT hardware description
	To define NVT platform IO address
	@file      hardware.h
	@ingroup
	@note

	Copyright   Novatek Microelectronics Corp. 2021.  All rights reserved.
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 as
	published by the Free Software Foundation.
*/

#ifndef __SOC_NVT_PLAT_NA51103_HARDWARE_H
#define __SOC_NVT_PLAT_NA51103_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE	(0x2fff01000)
#define NVT_GIC_CPU_PHYS_BASE	(0x2fff02000)

#define NVT_CPU_REG_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x1400000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE	(0x2f0000000)

#define NVT_TOP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0010000)

#define NVT_CG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0030000)

#define NVT_GPIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0040000)

#define NVT_TZPC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0050000)

#define NVT_WDT_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0060000)

#define NVT_TIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0100000)

#define NVT_PWM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0120000)

#define NVT_REMOTE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0130000)

#define NVT_TIMER64_1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0140000)

#define NVT_TRNG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0150000)

#define NVT_CC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0160000)

#define NVT_TIMER64_2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0170000)

#define NVT_NAND_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0180000)

#define NVT_SDIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0190000)

#define NVT_I2C1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01c0000)

#define NVT_I2C2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01d0000)

#define NVT_I2C3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01e0000)

#define NVT_I2C4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01f0000)

#define NVT_SPI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0270000)

#define NVT_UART1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0280000)

#define NVT_UART2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0290000)

#define NVT_UART3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x02a0000)

#define NVT_UART4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x02b0000)

#define NVT_ETH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0440000)

#define NVT_ETH2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0450000)

#define NVT_USB_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0480000)

#define NVT_USB2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0490000)

#define NVT_USBPHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04E0000)

#define NVT_USB2PHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04F0000)

#define NVT_RTC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0620000)

#define NVT_EFUSE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0630000)

#define NVT_HASH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0650000)

#define NVT_RSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0660000)

#define NVT_SATA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0680000)

#define NVT_SATA2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0690000)

#define NVT_SATACTL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06c0000)

#define NVT_SATACTL2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06d0000)

#define NVT_SATAPHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06e0000)

#define NVT_SATAPHY2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x06f0000)

#endif	/* __SOC_NVT_PLAT_NA51103_HARDWARE_H */
