/*
   Register definition header file for CG module of NS02201.

   This file is the header file that define the address offset
   definition of registers of CG module.

   @file       cg-reg.h

   Copyright   Novatek Microelectronics Corp. 2018.  All rights reserved
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.
*/

#ifndef _CG_REG_H
#define _CG_REG_H

/* Reset or not during clk_prepare() */
#define DO_RESET        1
#define NOT_RESET       0

/* Enable or not during clock tree construction */
#define DO_DISABLE	2
#define DO_ENABLE	1
#define NOT_ENABLE	0 // keep previous value

/* Enable or not during clock tree construction */
#define DO_AUTOGATING   1
#define NOT_AUTOGATING  0

#define NVT_PLL_MAX_NUMBER 32

/* CPU RATIO */
#define CG_CPU_RATIO	0x20

#define DEFAULT_OSC_IN_CLK_FREQ 12000000
#define DEFAULT_PLL_DIV_VALUE   131072
#define DEFAULT_PLL0_RATIO    0	       /* 0x640000 (600MHz for AXI0) */
#define DEFAULT_PLL2_RATIO    0        /* 0x535555 (500MHz for AXI1) */
#define DEFAULT_PLL3_RATIO    0        /* 0x0 (DRAM clock is determined by Loader) */
#define DEFAULT_PLL4_RATIO    3276800  /* 0x320000 (300MHz for AHB) */
#define DEFAULT_PLL5_RATIO    9284266  /* 0x8DAAAA (850MHz for GPU) */
#define DEFAULT_PLL6_RATIO    2184533  /* 0x215555 (200MHz for SDC) */
#define DEFAULT_PLL7_RATIO    2730666  /* 0x29AAAA (250MHz for MAC) */
#define DEFAULT_PLL8_RATIO    6488064  /* 0x630000 (594MHz for LCD) */
#define DEFAULT_PLL9_RATIO    3244032  /* 0x318000 (297MHz for LCD2) */
#define DEFAULT_PLL10_RATIO   1622016  /* 0x18C000 (148.5MHz for LCD3) */
#define DEFAULT_PLL11_RATIO   5242880  /* 0x500000 (480MHz for DSI) */
#define DEFAULT_PLL12_RATIO   4026531  /* 0x3D70A3 (368.64MHz for AUDIO) */
#define DEFAULT_PLL13_RATIO   0	       /* 0x42AAAA (400MHz for AXI2) */
#define DEFAULT_PLL14_RATIO   5461333  /* 0x535555 (500MHz for USB3) */
#define DEFAULT_PLL15_RATIO   9175040  /* 0x8C0000 (500MHz for SIE_SENSOR) */
#define DEFAULT_PLL16_RATIO   0        /* 0x0      (CPU clock is determined by Loader) */
#define DEFAULT_PLL17_RATIO   6553600  /* 0x640000 (600MHz for SATA_PHY) */
#define DEFAULT_PLL18_RATIO   6881280  /* 0x690000 (630MHz for SIE_SENSOR2) */
#define DEFAULT_PLL19_RATIO   7427413  /* 0x715555 (680MHz for VIE) */
#define DEFAULT_PLL20_RATIO   4369066  /* 0x42AAAA (400MHz for SENSOR_MCLK) */
#define DEFAULT_PLL21_RATIO   7645866  /* 0x74AAAA (700MHz for DSP) */
#define DEFAULT_PLL22_RATIO   6553600  /* 0x640000 (600MHz for DSP2) */
#define DEFAULT_PLL23_RATIO   5789013  /* 0x585555 (530MHz for SENSOR_MCLK2) */
#define DEFAULT_PLL24_RATIO   1092266  /* 0x10AAAA (100MHz for PCIE_PHY) */
#define DEFAULT_PLL25_RATIO   5461333  /* 0x535555 (500MHz for SATA_PHY_SSC) */
#define DEFAULT_PLL26_RATIO   6553600  /* 0x640000 (600MHz for IPP) */
#define DEFAULT_PLL27_RATIO   5242880  /* 0x500000 (480MHz for DSI2) */
#define DEFAULT_PLL28_RATIO   9284266  /* 0x8DAAAA (850MHz for CNN) */
#define DEFAULT_PLL29_RATIO   8738133  /* 0x855555 (800MHz for CNN2) */
#define DEFAULT_PLL30_RATIO   6772053  /* 0x675555 (620MHz for VENC) */
#define DEFAULT_PLL31_RATIO   7099733  /* 0x6C5555 (650MHz for VDEC) */
#define DEFAULT_PLL32_RATIO   0        /* 0x0 (DRAM2 clock is determined by Loader) */

/* PLL */
#define CG_PLL_EN_REG_OFFSET			0x0
#define CG_PLL_STAT_REG_OFFSET			0x4
#define CG_PLL_EN_REG2_OFFSET			0x8

/* Clock source control */
#define CG_SYS_CLK_RATE_REG_OFFSET			0x10
#define CG_IPP_CLK_RATE_REG0_OFFSET			0x14
#define CG_IPP_CLK_RATE_REG1_OFFSET			0x18
#define CG_CODEC_CLK_RATE_REG_OFFSET		0x1C
#define CG_PERI_CLK_RATE_REG0_OFFSET		0x20
#define CG_PERI_CLK_RATE_REG1_OFFSET		0x24
#define CG_PERI_CLK_RATE_REG2_OFFSET		0x28
#define CG_PERI_CLK_RATE_REG3_OFFSET		0x2C

/* Clock rate control */
#define CG_PWM_CLK_DIV_REG0_OFFSET			0x30
#define CG_PWM_CLK_DIV_REG1_OFFSET			0x34
#define CG_PWM_CLK_DIV_REG2_OFFSET			0x38
#define CG_DAI_MCLK_DIV_REG_OFFSET			0x3C
#define CG_SDIO_CLK_DIV_REG_OFFSET			0x40
#define CG_UART_CLK_DIV_REG_OFFSET			0x44
#define CG_PERI_CLK_DIV_REG0_OFFSET			0x48
#define CG_DISP_CLK_DIV_REG_OFFSET			0x4C
#define CG_PERI_CLK_DIV_REG2_OFFSET			0x50
#define CG_DSP_CLK_DIV_REG_OFFSET			0x54
#define CG_DAI_CLK_DIV_REG0_OFFSET			0x58
#define CG_SDIO_CLK_DIV_REG1_OFFSET			0x5C
#define CG_UART_CLK_DIV_REG1_OFFSET			0x60
#define CG_SPI_CLK_DIV_REG0_OFFSET			0x64
#define CG_SPI_CLK_DIV_REG1_OFFSET			0x68
#define CG_SPI_CLK_DIV_REG2_OFFSET			0x6C

/* Clock enable/disable control */
#define CG_CLK_EN_REG0_OFFSET				0x70
#define CG_CLK_EN_REG1_OFFSET				0x74
#define CG_CLK_EN_REG2_OFFSET				0x78
#define CG_CLK_EN_REG3_OFFSET				0x7C
#define CG_CLK_EN_REG4_OFFSET				0x80
#define CG_CLK_EN_REG5_OFFSET				0x84
#define CG_CLK_EN_REG6_OFFSET				0x88
#define CG_CLK_EN_REG7_OFFSET				0x8C
#define CG_CLK_EN_REG8_OFFSET				0x130
#define CG_CLK_EN_REG9_OFFSET				0x140
#define CG_CLK_EN_REG10_OFFSET				0x150
#define CG_CLK_EN_REG11_OFFSET				0x154
#define CG_CLK_EN_REG12_OFFSET				0x158
#define CG_CLK_EN_REG13_OFFSET				0x15C
#define CG_CLK_EN_REG14_OFFSET				0x160
#define CG_CLK_EN_REG15_OFFSET				0x164

/* Module reset control */
#define CG_SYS_RESET_REG0_OFFSET			0x90
#define CG_SYS_RESET_REG1_OFFSET			0x94
#define CG_SYS_RESET_REG2_OFFSET			0x98
#define CG_SYS_RESET_REG3_OFFSET			0x9C
#define CG_SYS_RESET_REG4_OFFSET			0xA0
#define CG_SYS_RESET_REG5_OFFSET			0xA4
#define CG_SYS_RESET_REG6_OFFSET			0xA8
#define CG_SYS_RESET_REG7_OFFSET			0xAC

/* Low power control */
#define CG_SLEEP_MODE_REG_OFFSET			(0xB0)
#define CG_CLK_AUTO_GATING_REG0_OFFSET		0xC0
#define CG_CLK_AUTO_GATING_REG1_OFFSET		0xC4
#define CG_CLK_AUTO_GATING_REG2_OFFSET		0xC8

#define CG_APB_CLK_AUTO_GATING_REG0_OFFSET	0xD0
#define CG_APB_CLK_AUTO_GATING_REG1_OFFSET	0xD4
#define CG_APB_CLK_AUTO_GATING_REG2_OFFSET	0xD8
#define CG_APB_CLK_AUTO_GATING_REG3_OFFSET	0xDC
#define CG_APB_CLK_AUTO_GATING_REG4_OFFSET	0xE0

/* Extclk source control */
//#define CG_EXT_CLK_OUT_SRC_REG_OFFSET		0xF0

#define CG_RO_32K_CALIBRATION_REG0_OFFSET	0x100
#define CG_RO_32K_CALIBRATION_REG1_OFFSET	0x104
#define CG_RO_32K_CALIBRATION_REG2_OFFSET	0x108

#define CG_RINGOSC_CLK_CTRL_REG0_OFFSET		0x110

#define CG_GLITCH_FREE_MUX_REG0_OFFSET		0x120

#define CG_DEBUG_PROTECT_REG0_OFFSET		0x128
#define CG_DEBUG_PROTECT_REG1_OFFSET		0x12C

#define CG_USB3_PD_REG0_OFFSET			0x130

/* Extclk source control */
#define CG_EXT_IPP_CLK_RATE_REG0_OFFSET			0x200
#define CG_EXT_IPP_CLK_RATE_REG1_OFFSET			0x204
#define CG_EXT_IPP_CLK_RATE_REG2_OFFSET			0x208
#define CG_EXT_IPP_CLK_RATE_REG3_OFFSET			0x20C

/* Extclk rate control */
#define CG_EXT_IPP_CLK_DIV_REG0_OFFSET			0x300
#define CG_EXT_IPP_CLK_DIV_REG1_OFFSET			0x304
#define CG_EXT_IPP_CLK_DIV_REG2_OFFSET			0x308
#define CG_EXT_IPP_CLK_DIV_REG3_OFFSET			0x30C
#define CG_EXT_IPP_CLK_DIV_REG4_OFFSET			0x310
#define CG_EXT_IPP_CLK_DIV_REG5_OFFSET			0x314
#define CG_EXT_IPP_CLK_DIV_REG6_OFFSET			0x318
#define CG_EXT_IPP_CLK_DIV_REG7_OFFSET			0x31C
#define CG_EXT_DISP_CLK_DIV_REG0_OFFSET			0x320
#define CG_EXT_PWM_CLK_DIV_REG0_OFFSET			0x324

/* Extclk enable */
#define CG_EXT_SIE_CLK_EN_REG0_OFFSET			0x400
#define CG_EXT_CSIPHY_CLK_EN_REG0_OFFSET		0x404

#define CG_PLL_MCU_FLAG_REG_OFFSET			0x1180

/* PLL clock rate control */
#define CG_PLL0_CLK_RATE0_REG_OFFSET 			0x4420
#define CG_PLL2_CLK_RATE0_REG_OFFSET 			0x44A0
#define CG_PLL3_CLK_RATE0_REG_OFFSET			0x44E0
#define CG_PLL4_CLK_RATE0_REG_OFFSET			0x4520
#define CG_PLL5_CLK_RATE0_REG_OFFSET			0x4560
#define CG_PLL6_CLK_RATE0_REG_OFFSET			0x45A0
#define CG_PLL7_CLK_RATE0_REG_OFFSET			0x45E0
#define CG_PLL8_CLK_RATE0_REG_OFFSET			0x4620
#define CG_PLL9_CLK_RATE0_REG_OFFSET			0x4660
#define CG_PLL10_CLK_RATE0_REG_OFFSET			0x46A0
#define CG_PLL11_CLK_RATE0_REG_OFFSET			0x46E0
#define CG_PLL12_CLK_RATE0_REG_OFFSET			0x4720
#define CG_PLL13_CLK_RATE0_REG_OFFSET			0x4760
#define CG_PLL14_CLK_RATE0_REG_OFFSET			0x47A0
#define CG_PLL15_CLK_RATE0_REG_OFFSET			0x47E0
#define CG_PLL16_CLK_RATE0_REG_OFFSET			0x4820
#define CG_PLL17_CLK_RATE0_REG_OFFSET			0x4860
#define CG_PLL18_CLK_RATE0_REG_OFFSET			0x48A0
#define CG_PLL19_CLK_RATE0_REG_OFFSET			0x48E0
#define CG_PLL20_CLK_RATE0_REG_OFFSET			0x4920
#define CG_PLL21_CLK_RATE0_REG_OFFSET			0x4960
#define CG_PLL22_CLK_RATE0_REG_OFFSET			0x49A0
#define CG_PLL23_CLK_RATE0_REG_OFFSET			0x49E0
#define CG_PLL24_CLK_RATE0_REG_OFFSET			0x4A20
#define CG_PLL25_CLK_RATE0_REG_OFFSET			0x4A60
#define CG_PLL26_CLK_RATE0_REG_OFFSET			0x4AA0
#define CG_PLL27_CLK_RATE0_REG_OFFSET			0x4AE0
#define CG_PLL28_CLK_RATE0_REG_OFFSET			0x4B20
#define CG_PLL29_CLK_RATE0_REG_OFFSET			0x4B60
#define CG_PLL30_CLK_RATE0_REG_OFFSET			0x4BA0
#define CG_PLL31_CLK_RATE0_REG_OFFSET			0x4BE0
#define CG_PLL32_CLK_RATE0_REG_OFFSET			0x4C20

#define SPREAD_SPECTRUM_REG0_MINUS_OFFSET               (0x14) /* MPLL + 0xC */
#define SPREAD_SPECTRUM_REG1_MINUS_OFFSET               (0x10) /* MPLL + 0x10 */
#define SPREAD_SPECTRUM_REG2_MINUS_OFFSET               (0xC)  /* MPLL + 0x14 */
#define SPREAD_SPECTRUM_REG3_MINUS_OFFSET               (0x4)  /* MPLL + 0x1C */
#define SPREAD_SPECTRUM_STEP_OFFSET                     (0x4)
#define SPREAD_SPECTRUM_NEW_MODE_OFFSET                 (0x7)
#define SPREAD_SPECTRUM_DSSC_OFFSET                     (0x2)
#define SPREAD_SPECTRUM_PERIOD_VALUE                    (0xFF)

#endif /* _CG_REG_H */
