#define CG_CPU_RATIO  0x8
/* Reset or not during clk_prepare() */
#define DO_RESET        1
#define NOT_RESET       0

/* Enable or not during clock tree construction */
#define DO_DISABLE      2
#define DO_ENABLE       1
#define NOT_ENABLE      0 // keep previous value

/* Enable or not during clock tree construction */
#define DO_AUTOGATING   1
#define NOT_AUTOGATING  0

#define NVT_PLL_MAX_NUMBER 19
#define DEFAULT_OSC_IN_CLK_FREQ 12000000
#define DEFAULT_PLL_DIV_VALUE   131072
#define DEFAULT_PLL0_RATIO    0        /* 0x0 (AXI clock is determined by Loader) */
#define DEFAULT_PLL3_RATIO    0	       /* 0x0 (DMA1 clock is determined by Loader) */
#define DEFAULT_PLL4_RATIO    4194304  /* 0x400000 (384MHz for SS) */
#define DEFAULT_PLL5_RATIO    2621440  /* 0x280000 (240MHz for SENSOR1) */
#define DEFAULT_PLL6_RATIO    3244032  /* 0x318000 (297MHz for IDE1) */
#define DEFAULT_PLL7_RATIO    4026531  /* 0x3D70A3 (368.64MHz for AUDIO) */
#define DEFAULT_PLL8_RATIO    0        /* 0x0 (CPU clock is determined by Loader) */
#define DEFAULT_PLL9_RATIO    3495253  /* 0x355555 (320MHz for BACKUP) */
#define DEFAULT_PLL10_RATIO   6553600  /* 0x640000 (600MHz for CNN) */
#define DEFAULT_PLL11_RATIO   5242880  /* 0x500000 (480MHz for DSI) */
#define DEFAULT_PLL12_RATIO   2621440  /* 0x280000 (240MHz for SENSOR2) */
#define DEFAULT_PLL13_RATIO   4915200  /* 0x4B0000 (450MHz for IPP) */
#define DEFAULT_PLL14_RATIO   5461333  /* 0x535555 (500MHz for USB3) */
#define DEFAULT_PLL15_RATIO   4369066  /* 0x42AAAA (400MHz for H264/H265) */
#define DEFAULT_PLL16_RATIO   2730666  /* 0x29AAAA (250MHz for ETH) */
#define DEFAULT_PLL17_RATIO   4805973  /* 0x495555 (440MHz for VPE) */
#define DEFAULT_PLL_F320_RATIO   3495253  /* 0x355555 (320MHz for FIX320) */

#define STBC_BASE_OFFSET 0x210000 // base address from 0xF0020000 to 0x230000

/* PLL */
#define CG_PLL_EN_REG_OFFSET			STBC_BASE_OFFSET
#define CG_PLL_STAT_REG0_OFFSET			(0x4 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RATE_REG0_OFFSET		(0x10 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RATE_REG1_OFFSET		(0x20 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RATE_REG3_OFFSET		(0x60 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_EN_REG0_OFFSET		(0x70 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RESET_REG0_OFFSET		(0x90 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_SLEEP_REG0_OFFSET		(0xB0 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_AUTO_GATING_REG0_OFFSET	(0xD0 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_EN_REG1_OFFSET		(0xE0 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_DEBUG_REG0_OFFSET		(0xF8 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_DEBUG_REG1_OFFSET		(0xFC + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RO_32K_REG0_OFFSET		(0x100 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RO_32K_REG1_OFFSET		(0x104 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_RO_32K_REG2_OFFSET		(0x108 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_FREE_MUX_REG0_OFFSET	(0x120 + STBC_BASE_OFFSET)
#define CG_STBC_CLK_FREE_MUX_REG1_OFFSET	(0x124 + STBC_BASE_OFFSET)

/* Clock source control */
#define CG_SYS_CLK_RATE_REG0_OFFSET			0x10
#define CG_IPP_CLK_RATE_REG0_OFFSET			0x14
#define CG_IPP_CLK_RATE_REG1_OFFSET			0x18
#define CG_CODEC_CLK_RATE_REG0_OFFSET		0x1C
#define CG_PERI_CLK_RATE_REG0_OFFSET		0x20
#define CG_PERI_CLK_RATE_REG1_OFFSET		0x24
#define CG_PERI_CLK_RATE_REG2_OFFSET		0x28
#define CG_PERI_CLK_RATE_REG3_OFFSET		0x2C

/* Clock rate control */
#define CG_IPP_CLK_DIV_REG0_OFFSET			0x30
#define CG_VIDEO_CLK_DIV_REG0_OFFSET			0x34
#define CG_PERI_CLK_DIV_REG0_OFFSET			0x38
#define CG_SDIO_CLK_DIV_REG0_OFFSET			0x3C
#define CG_PERI_CLK_DIV_REG1_OFFSET			0x40
#define CG_SPI_CLK_DIV_REG0_OFFSET			0x44
#define CG_SPI_CLK_DIV_REG1_OFFSET			0x48
#define CG_UART_CLK_DIV_REG0_OFFSET			0x4C
#define CG_PWM_CLK_DIV_REG0_OFFSET			0x50
#define CG_PWM_CLK_DIV_REG1_OFFSET			0x54
#define CG_PWM_CLK_DIV_REG2_OFFSET			0x58
#define CG_PERI_CLK_DIV_REG2_OFFSET			0x60
#define CG_PERI_CLK_DIV_REG3_OFFSET			0x64
#define CG_PERI_CLK_DIV_REG4_OFFSET			0x68

/* Clock enable/disable control */
#define CG_CLK_EN_REG0_OFFSET				0x70
#define CG_CLK_EN_REG1_OFFSET				0x74
#define CG_CLK_EN_REG2_OFFSET				0x78
#define CG_CLK_EN_REG3_OFFSET				0x7C
#define CG_CLK_EN_REG4_OFFSET				0x80

/* Module reset control */
#define CG_SYS_RESET_REG0_OFFSET			0x90
#define CG_SYS_RESET_REG1_OFFSET			0x94
#define CG_SYS_RESET_REG2_OFFSET			0x98
#define CG_SYS_RESET_REG3_OFFSET			0x9C
#define CG_SYS_RESET_REG4_OFFSET			0xA0

/* Low power control */
#define CG_SLEEP_MODE_REG_OFFSET			(0xB0+STBC_BASE_OFFSET)
#define CG_CLK_AUTO_GATING_REG0_OFFSET		0xC0
#define CG_CLK_AUTO_GATING_REG1_OFFSET		0xC4
#define CG_CLK_AUTO_GATING_REG2_OFFSET		0xC8

#define CG_APB_CLK_AUTO_GATING_REG0_OFFSET	0xD0
#define CG_APB_CLK_AUTO_GATING_REG1_OFFSET	0xD4
#define CG_APB_CLK_AUTO_GATING_REG2_OFFSET	0xD8
#define CG_APB_CLK_AUTO_GATING_REG3_OFFSET	0xDC

/* Program Clock Enable Register */
#define CG_CLK_PROG_EN_REG0_OFFSET		0xE0
#define CG_CLK_PROG_EN_REG1_OFFSET		0xE4
#define CG_CLK_PROG_EN_REG2_OFFSET		0xE8
#define CG_CLK_PROG_EN_REG3_OFFSET		0xEC

#define CG_CLK_DEBUG_REG0_OFFSET		0xFC

/* PLL clock rate control */
#define CG_PLL0_CLK_RATE0_REG_OFFSET 			(0x46A0 + STBC_BASE_OFFSET)
#define CG_PLL3_CLK_RATE0_REG_OFFSET			(0x4420 + STBC_BASE_OFFSET)
#define CG_PLL4_CLK_RATE0_REG_OFFSET			(0x44E0 + STBC_BASE_OFFSET)
#define CG_PLL5_CLK_RATE0_REG_OFFSET			(0x4620 + STBC_BASE_OFFSET)
#define CG_PLL6_CLK_RATE0_REG_OFFSET			(0x4520 + STBC_BASE_OFFSET)
#define CG_PLL7_CLK_RATE0_REG_OFFSET			(0x46E0 + STBC_BASE_OFFSET)
#define CG_PLL8_CLK_RATE0_REG_OFFSET			(0x47E0 + STBC_BASE_OFFSET)
#define CG_PLL9_CLK_RATE0_REG_OFFSET			(0x4760 + STBC_BASE_OFFSET)
#define CG_PLL10_CLK_RATE0_REG_OFFSET			(0x44A0 + STBC_BASE_OFFSET)
#define CG_PLL11_CLK_RATE0_REG_OFFSET			(0x47A0 + STBC_BASE_OFFSET)
#define CG_PLL12_CLK_RATE0_REG_OFFSET			(0x4660 + STBC_BASE_OFFSET)
#define CG_PLL13_CLK_RATE0_REG_OFFSET			(0x4820 + STBC_BASE_OFFSET)
#define CG_PLL14_CLK_RATE0_REG_OFFSET			(0x45A0 + STBC_BASE_OFFSET)
#define CG_PLL15_CLK_RATE0_REG_OFFSET			(0x4460 + STBC_BASE_OFFSET)
#define CG_PLL16_CLK_RATE0_REG_OFFSET			(0x4560 + STBC_BASE_OFFSET)
#define CG_PLL17_CLK_RATE0_REG_OFFSET			(0x4720 + STBC_BASE_OFFSET)
#define CG_PLL18_CLK_RATE0_REG_OFFSET			(0x45E0 + STBC_BASE_OFFSET) //FIX320

