/* SPDX-License-Identifier: GPL-2.0 */
/*
 * This header provides constants specific to Novatek NS02201 pinctrl bindings.
 */
#ifndef __DT_BINDINGS_INTERRUPT_NA51102_INTERRUPT_H
#define __DT_BINDINGS_INTERRUPT_NA51102_INTERRUPT_H

#define INT_GIC_SPI_START_ID    32

#define INT_ID_TIMER             (INT_GIC_SPI_START_ID +   0)
#define INT_ID_SIE               (INT_GIC_SPI_START_ID +   1)
#define INT_ID_SIE2              (INT_GIC_SPI_START_ID +   2)
#define INT_ID_SIE3              (INT_GIC_SPI_START_ID +   3)
#define INT_ID_DRTC              (INT_GIC_SPI_START_ID +   4)
#define INT_ID_IPE               (INT_GIC_SPI_START_ID +   5)
#define INT_ID_IME               (INT_GIC_SPI_START_ID +   6)
#define INT_ID_DCE               (INT_GIC_SPI_START_ID +   7)
#define INT_ID_IFE               (INT_GIC_SPI_START_ID +   8)
#define INT_ID_VPEL              (INT_GIC_SPI_START_ID +   9)
#define INT_ID_DIS               (INT_GIC_SPI_START_ID +  10)
#define INT_ID_CNN               (INT_GIC_SPI_START_ID +  11)
#define INT_ID_SDP               (INT_GIC_SPI_START_ID +  12)
#define INT_ID_NUE2              (INT_GIC_SPI_START_ID +  13)
#define INT_ID_NUE               (INT_GIC_SPI_START_ID +  14)
#define INT_ID_DAI               (INT_GIC_SPI_START_ID +  15)
#define INT_ID_HEVC              (INT_GIC_SPI_START_ID +  16)
#define INT_ID_JPEG              (INT_GIC_SPI_START_ID +  17)
#define INT_ID_GRAPHIC           (INT_GIC_SPI_START_ID +  18)
#define INT_ID_GRAPHIC2          (INT_GIC_SPI_START_ID +  19)
#define INT_ID_RSA               (INT_GIC_SPI_START_ID +  20)
#define INT_ID_ISE               (INT_GIC_SPI_START_ID +  21)
#define INT_ID_TGE               (INT_GIC_SPI_START_ID +  22)
#define INT_ID_TSE               (INT_GIC_SPI_START_ID +  23)
#define INT_ID_GPIO              (INT_GIC_SPI_START_ID +  24)
#define INT_ID_REMOTE            (INT_GIC_SPI_START_ID +  25)
#define INT_ID_PWM               (INT_GIC_SPI_START_ID +  26)
#define INT_ID_USB3              (INT_GIC_SPI_START_ID +  27)
#define INT_ID_HASH              (INT_GIC_SPI_START_ID +  28)
#define INT_ID_NAND              (INT_GIC_SPI_START_ID +  29)
#define INT_ID_SDIO              (INT_GIC_SPI_START_ID +  30)
#define INT_ID_SDIO2             (INT_GIC_SPI_START_ID +  31)
#define INT_ID_SDIO3             (INT_GIC_SPI_START_ID +  32)
#define INT_ID_DMA               (INT_GIC_SPI_START_ID +  33)
#define INT_ID_ETHERNET          (INT_GIC_SPI_START_ID +  34)
#define INT_ID_SPI               (INT_GIC_SPI_START_ID +  35)
#define INT_ID_SPI2              (INT_GIC_SPI_START_ID +  36)
#define INT_ID_SPI3              (INT_GIC_SPI_START_ID +  37)
#define INT_ID_CRYPTO            (INT_GIC_SPI_START_ID +  38)
#define INT_ID_TZPC              (INT_GIC_SPI_START_ID +  39)
#define INT_ID_SIF               (INT_GIC_SPI_START_ID +  40)
#define INT_ID_I2C               (INT_GIC_SPI_START_ID +  41)
#define INT_ID_I2C2              (INT_GIC_SPI_START_ID +  42)
#define INT_ID_UART              (INT_GIC_SPI_START_ID +  43)
#define INT_ID_UART2             (INT_GIC_SPI_START_ID +  44)
#define INT_ID_UART3             (INT_GIC_SPI_START_ID +  45)
#define INT_ID_MDBC              (INT_GIC_SPI_START_ID +  46)
#define INT_ID_ADC               (INT_GIC_SPI_START_ID +  47)
#define INT_ID_IDE               (INT_GIC_SPI_START_ID +  48)
#define INT_ID_CNN2              (INT_GIC_SPI_START_ID +  49)
#define INT_ID_DSI               (INT_GIC_SPI_START_ID +  50)
#define INT_ID_TRKE              (INT_GIC_SPI_START_ID +  51)
#define INT_ID_CC                (INT_GIC_SPI_START_ID +  52)
#define INT_ID_IVE               (INT_GIC_SPI_START_ID +  53)
#define INT_ID_LVDS              (INT_GIC_SPI_START_ID +  54)
#define INT_ID_LVDS2             (INT_GIC_SPI_START_ID +  55)
#define INT_ID_RTC               (INT_GIC_SPI_START_ID +  56)
#define INT_ID_WDT               (INT_GIC_SPI_START_ID +  57)
#define INT_ID_CG                (INT_GIC_SPI_START_ID +  58)
#define INT_ID_SIE4              (INT_GIC_SPI_START_ID +  59)
#define INT_ID_I2C3              (INT_GIC_SPI_START_ID +  60)
#define INT_ID_SIE5              (INT_GIC_SPI_START_ID +  61)
#define INT_ID_VPE               (INT_GIC_SPI_START_ID +  62)
#define INT_ID_UART4             (INT_GIC_SPI_START_ID +  63)
#define INT_ID_UART5             (INT_GIC_SPI_START_ID +  64)
#define INT_ID_UART6             (INT_GIC_SPI_START_ID +  65)
#define INT_ID_SPI4              (INT_GIC_SPI_START_ID +  66)
#define INT_ID_SPI5              (INT_GIC_SPI_START_ID +  67)
#define INT_ID_I2C4              (INT_GIC_SPI_START_ID +  68)
#define INT_ID_I2C5              (INT_GIC_SPI_START_ID +  69)
#define INT_ID_TIMER2            (INT_GIC_SPI_START_ID +  70)
#define INT_ID_GPIO2             (INT_GIC_SPI_START_ID +  71)
#define INT_ID_SIF2              (INT_GIC_SPI_START_ID +  72)
#define INT_ID_PWM2              (INT_GIC_SPI_START_ID +  73)
#define INT_ID_SDE               (INT_GIC_SPI_START_ID +  74)
#define INT_ID_TIMER64_1         (INT_GIC_SPI_START_ID +  75)
#define INT_ID_TIMER64_2         (INT_GIC_SPI_START_ID +  76)
#define INT_ID_CC2               (INT_GIC_SPI_START_ID +  77)
#define INT_ID_CC3               (INT_GIC_SPI_START_ID +  78)
#define INT_ID_CC4               (INT_GIC_SPI_START_ID +  79)
#define INT_ID_DRE               (INT_GIC_SPI_START_ID +  80)
#define INT_ID_JPEG2             (INT_GIC_SPI_START_ID +  81)
#define INT_ID_DSP               (INT_GIC_SPI_START_ID +  82)
#define INT_ID_I2C6              (INT_GIC_SPI_START_ID +  83)
#define INT_ID_I2C7              (INT_GIC_SPI_START_ID +  84)
#define INT_ID_I2C8              (INT_GIC_SPI_START_ID +  85)
#define INT_ID_I2C9              (INT_GIC_SPI_START_ID +  86)
#define INT_ID_I2C10             (INT_GIC_SPI_START_ID +  87)
#define INT_ID_I2C11             (INT_GIC_SPI_START_ID +  88)
#define INT_ID_IDE2              (INT_GIC_SPI_START_ID +  89)
#define INT_ID_UART7             (INT_GIC_SPI_START_ID +  90)
#define INT_ID_USB               (INT_GIC_SPI_START_ID +  91)
#define INT_ID_HDMI              (INT_GIC_SPI_START_ID +  92)
#define INT_ID_MI                (INT_GIC_SPI_START_ID +  92)
#define INT_ID_HVTLOAD           (INT_GIC_SPI_START_ID +  94)
#define INT_ID_PWBC              (INT_GIC_SPI_START_ID +  95)
#define INT_ID_UART8             (INT_GIC_SPI_START_ID +  96)
#define INT_ID_UART9             (INT_GIC_SPI_START_ID +  97)
#define INT_ID_LVDS3             (INT_GIC_SPI_START_ID +  98)
#define INT_ID_LVDS4             (INT_GIC_SPI_START_ID +  99)
#define INT_ID_LVDS5             (INT_GIC_SPI_START_ID + 100)
#define INT_ID_UVCP              (INT_GIC_SPI_START_ID + 101)
#define INT_ID_DAI2              (INT_GIC_SPI_START_ID + 102)
#define INT_ID_CSI_TX            (INT_GIC_SPI_START_ID + 103)
#define INT_ID_GPENC             (INT_GIC_SPI_START_ID + 104)
#define INT_ID_GPENC2            (INT_GIC_SPI_START_ID + 105)
#define INT_ID_SATA              (INT_GIC_SPI_START_ID + 106)
#define INT_ID_ISE2              (INT_GIC_SPI_START_ID + 107)
#define INT_ID_SIE6              (INT_GIC_SPI_START_ID + 108)
#define INT_ID_VIE               (INT_GIC_SPI_START_ID + 109)
#define INT_ID_VIE2              (INT_GIC_SPI_START_ID + 110)
#define INT_ID_UVCP2             (INT_GIC_SPI_START_ID + 111)
#define INT_ID_ETHERNET2         (INT_GIC_SPI_START_ID + 112)
#define INT_ID_GRAPHIC3          (INT_GIC_SPI_START_ID + 113)
#define INT_ID_ETHERNET2_RX0     (INT_GIC_SPI_START_ID + 114)
#define INT_ID_GPIO3             (INT_GIC_SPI_START_ID + 115)
#define INT_ID_GPIO4             (INT_GIC_SPI_START_ID + 116)
#define INT_ID_GPIO5             (INT_GIC_SPI_START_ID + 117)
#define INT_ID_VTR               (INT_GIC_SPI_START_ID + 118)
#define INT_ID_ETHERNET_RX0      (INT_GIC_SPI_START_ID + 119)
#define INT_ID_ETHERNET_RX1      (INT_GIC_SPI_START_ID + 120)
#define INT_ID_ETHERNET_RX2      (INT_GIC_SPI_START_ID + 121)
#define INT_ID_ETHERNET_RX3      (INT_GIC_SPI_START_ID + 122)
#define INT_ID_ETHERNET_TX0      (INT_GIC_SPI_START_ID + 123)
#define INT_ID_ETHERNET_TX1      (INT_GIC_SPI_START_ID + 124)
#define INT_ID_ETHERNET_TX2      (INT_GIC_SPI_START_ID + 125)
#define INT_ID_ETHERNET_TX3      (INT_GIC_SPI_START_ID + 126)
#define INT_ID_HWCP              (INT_GIC_SPI_START_ID + 127)
#define INT_ID_ETHERNET2_RX1     (INT_GIC_SPI_START_ID + 128)
#define INT_ID_ETHERNET2_RX2     (INT_GIC_SPI_START_ID + 129)
#define INT_ID_ETHERNET2_RX3     (INT_GIC_SPI_START_ID + 130)
#define INT_ID_ETHERNET2_TX0     (INT_GIC_SPI_START_ID + 131)
#define INT_ID_ETHERNET2_TX1     (INT_GIC_SPI_START_ID + 132)
#define INT_ID_ETHERNET2_TX2     (INT_GIC_SPI_START_ID + 133)
#define INT_ID_ETHERNET2_TX3     (INT_GIC_SPI_START_ID + 134)
#define INT_ID_SIF3              (INT_GIC_SPI_START_ID + 135)
#define INT_ID_VDEC              (INT_GIC_SPI_START_ID + 136)
#define INT_ID_PMC               (INT_GIC_SPI_START_ID + 137)
#define INT_ID_JPEG_LITE         (INT_GIC_SPI_START_ID + 138)
#define INT_ID_CNT               (INT_GIC_SPI_START_ID + 139)
#define INT_ID_MAX               (INT_ID_CNT - INT_GIC_SPI_START_ID)
#define INT_ID_DUMMY_DGPIO       (INT_ID_MAX + 1)

#define INT_ID_WFI               229
#define INT_ID_GIC_TOTAL         256

#endif